//
// Copyright (c) 2021 RepliXio Ltd. All rights reserved.
// Use is subject to license terms.
//

use k8s_openapi::ByteString;

use super::*;

pub trait ConfigMapExt: super::ResourceExt {
    fn new(name: impl ToString) -> Self;
    fn immutable(self, yes: bool) -> Self;
    fn binary_data(self, data: impl IntoIterator<Item = (String, ByteString)>) -> Self;
    fn data(self, data: impl IntoIterator<Item = (String, String)>) -> Self;
}

impl ConfigMapExt for corev1::ConfigMap {
    fn new(name: impl ToString) -> Self {
        let metadata = Self::metadata(name);
        Self {
            metadata,
            ..Self::default()
            // binary_data: todo!(),
            // data: todo!(),
            // immutable: todo!(),
        }
    }

    fn immutable(self, yes: bool) -> Self {
        let immutable = Some(yes);
        Self { immutable, ..self }
    }

    fn binary_data(self, data: impl IntoIterator<Item = (String, ByteString)>) -> Self {
        let data = data.into_iter().collect();
        Self {
            binary_data: Some(data),
            ..self
        }
    }

    fn data(self, data: impl IntoIterator<Item = (String, String)>) -> Self {
        let data = data.into_iter().collect();
        Self {
            data: Some(data),
            ..self
        }
    }
}
