//
// Copyright (c) 2021 RepliXio Ltd. All rights reserved.
// Use is subject to license terms.
//

#![cfg_attr(feature = "pedantic", warn(clippy::pedantic))]
#![warn(clippy::use_self)]
#![warn(clippy::map_flatten)]
#![warn(clippy::map_unwrap_or)]
#![warn(deprecated_in_future)]
#![warn(future_incompatible)]
#![warn(noop_method_call)]
#![warn(unreachable_pub)]
#![warn(missing_debug_implementations)]
#![warn(rust_2018_compatibility)]
#![warn(rust_2021_compatibility)]
#![warn(rust_2018_idioms)]
#![warn(unused)]
#![deny(warnings)]

pub use k8s_openapi::api::apps::v1 as appsv1;
pub use k8s_openapi::api::core::v1 as corev1;
pub use k8s_openapi::api::rbac::v1 as rbacv1;
pub use k8s_openapi::apiextensions_apiserver::pkg::apis::apiextensions::v1 as apiextensionsv1;
pub use k8s_openapi::apimachinery::pkg::apis::meta::v1 as metav1;
pub use k8s_openapi::Resource;

pub use ext::ClusterRoleBindingExt;
pub use ext::ClusterRoleExt;
pub use ext::ConfigMapExt;
pub use ext::DeploymentExt;
pub use ext::NamespaceExt;
pub use ext::PolicyRuleExt;
pub use ext::ResourceExt;
pub use ext::RoleBindingExt;
pub use ext::RoleExt;
pub use ext::RoleRefExt;
pub use ext::SecretExt;
pub use ext::ServiceAccountExt;
pub use ext::SubjectExt;

pub use kubectl::Kubectl;

mod ext;
mod kubectl;

pub fn typed_ref(
    object: Option<&corev1::ObjectReference>,
) -> Option<corev1::TypedLocalObjectReference> {
    let object = object?;
    let kind = object.kind.as_ref()?.clone();
    let name = object.name.as_ref()?.clone();
    let typed = corev1::TypedLocalObjectReference {
        kind,
        name,
        ..corev1::TypedLocalObjectReference::default()
    };
    Some(typed)
}
