//
// Copyright (c) 2021 RepliXio Ltd. All rights reserved.
// Use is subject to license terms.
//

use kube::ResourceExt as _;

use super::*;

pub use cluster_role::ClusterRoleExt;
pub use cluster_role_binding::ClusterRoleBindingExt;
pub use configmap::ConfigMapExt;
pub use deployment::DeploymentExt;
pub use namespace::NamespaceExt;
pub use role::RoleExt;
pub use role_binding::RoleBindingExt;
pub use secret::SecretExt;
pub use service_account::ServiceAccountExt;
pub use policy_rule::PolicyRuleExt;

mod cluster_role;
mod cluster_role_binding;
mod configmap;
mod deployment;
mod namespace;
mod policy_rule;
mod role;
mod role_binding;
mod secret;
mod service_account;

pub trait ResourceExt {
    fn metadata(name: impl ToString) -> metav1::ObjectMeta {
        let name = Some(name.to_string());
        metav1::ObjectMeta {
            name,
            ..metav1::ObjectMeta::default()
            // annotations: todo!(),
            // cluster_name: todo!(),
            // creation_timestamp: todo!(),
            // deletion_grace_period_seconds: todo!(),
            // deletion_timestamp: todo!(),
            // finalizers: todo!(),
            // generate_name: todo!(),
            // generation: todo!(),
            // labels: todo!(),
            // managed_fields: todo!(),
            // namespace: todo!(),
            // owner_references: todo!(),
            // resource_version: todo!(),
            // self_link: todo!(),
            // uid: todo!(),
        }
    }

    fn namespace(self, namespace: impl ToString) -> Self;
}

impl<T> ResourceExt for T
where
    T: kube::Resource,
{
    fn namespace(mut self, namespace: impl ToString) -> Self {
        let namespace = Some(namespace.to_string());
        self.meta_mut().namespace = namespace;
        self
    }
}
