//
// Copyright (c) 2021 RepliXio Ltd. All rights reserved.
// Use is subject to license terms.
//

use super::*;

pub trait DeploymentExt: super::ResourceExt {
    fn new(name: impl ToString) -> Self;
    fn replicas(self, replicas: i32) -> Self;
    fn template(self, template: corev1::PodTemplateSpec) -> Self;
    fn pod(self, pod: corev1::PodSpec) -> Self;
}

impl DeploymentExt for appsv1::Deployment {
    fn new(name: impl ToString) -> Self {
        let metadata = Self::metadata(name);
        Self {
            metadata,
            // spec: todo!(),
            // status: todo!(),
            ..Self::default()
        }
    }

    fn replicas(self, replicas: i32) -> Self {
        let mut spec = self.spec.unwrap_or_default();
        spec.replicas = Some(replicas);
        Self {
            spec: Some(spec),
            ..self
        }
    }

    fn template(self, template: corev1::PodTemplateSpec) -> Self {
        let mut spec = self.spec.unwrap_or_default();
        spec.template = template;
        Self {
            spec: Some(spec),
            ..self
        }
    }

    fn pod(self, pod: corev1::PodSpec) -> Self {
        let mut spec = self.spec.unwrap_or_default();
        spec.template.spec = Some(pod);
        Self {
            spec: Some(spec),
            ..self
        }
    }
}
