//! # Startup library
//! blablabla...
//! 
//! 

use std::{fs, error::Error};
use std::env;

///
/// 这是一份简单的配置结构体，接受两个参数，查询和文件绝对路径。
pub struct Config {
    pub query: String,
    pub filename: String,
}

impl Config {
    pub fn new(mut args: env::Args) -> Result<Config, &'static str> {
        args.next();

        let query = match args.next() {
            Some(value) => value,
            None => return Err("Didn`t get a query stringe"),
        };

        let filename = match args.next() {
            Some(value) => value,
            None => return Err("Didn`t get filename"),
        };

        Ok(Config { query, filename })
    }

    // pub fn new(args: &[String]) -> Result<Config, &'static str> {
    //     if args.len() < 3 {
    //         return Err("not enough arguments!")
    //     }
    //     let query = args[1].clone();
    //     let filename = args[2].clone();
    //     Ok(Config { query, filename })
    // }
}

pub fn run(cfg: Config) -> Result<(), Box<dyn Error>> {
    let data = fs::read_to_string(&cfg.filename)?;
    // println!("{}", data);
    // println!("filename: {}", cfg.filename);
    for line in search(&cfg.query, &data) {
        println!("{}", line);
    }

    Ok(())
}

pub fn search<'a>(query: &str, contents: &'a str) -> Vec<&'a str> {
    // let mut result: Vec<&'a str> = Vec::new();
    contents.lines().filter(|line| line.contains(query)).collect()
    // for line in contents.lines() {
    //     if line.contains(query) {
    //         result.push(line)
    //     }
    // }

    // result
}

#[cfg(test)]
mod test {
    use super::*;

    #[test]
    fn one_result() {
        let query = "fast";
        let contents = "\
        Rust:
safe, fast, productive.
        Pick three.";

        assert_eq!(
            vec!["safe, fast, productive."],
            search(query, contents),
        );
    }
}