# stargazer

Stargazer is a fast and easy to use [Gemini](https://gemini.circumlunar.space)
server with no runtime dependencies (if compiled with musl libc).

Heavily inspired by [gmnisrv](https://sr.ht/~sircmpwn/gmnisrv/).

[Project page on Gemini](gemini://sashanoraa.gay/stargazer.gmi)

## Features

- Static file serving
- Automatic cert generation
- CGI
  - Mostly Jetforce compatible
- SCGI
- Multiple domains and routes
  - Regex rewrites
- Development mode

## Installation

There are various installation methods, take your pick.

### Install From Your Package Manager

[![Packaging status](https://repology.org/badge/vertical-allrepos/stargazer-gmi.svg)](https://repology.org/project/stargazer-gmi/versions)

### Container

`docker pull zethra/stargazer`
[Docker Hub](https://hub.docker.com/repository/docker/zethra/stargazer)

### Download Pre-built

You can download pre-built Linux binaries from the
[release page](https://git.sr.ht/~zethra/stargazer/refs). The bundle contains
a static binary, example config, and man pages. It should work on any distro.

### From crates.io

`cargo install stargazer`

### Build from Source

Dependencies:

- A POSIX or other compatible system
- Rust compiler 1.53 or later and cargo
- [scdoc](https://git.sr.ht/~sircmpwn/scdoc) (optional) to generate man pages
- strip (optional) (from binutils) to reduce the binary size
- Python 3 (testing)
- [Python 3 cryptography](https://pypi.org/project/cryptography/) (testing)

```sh
git clone https://git.sr.ht/~zethra/stargazer && cg stargazer
./scripts/build
# As root
./scripts/install --prefix=/usr
```

## Minimum Supported Rust Version Policy

The required Rust version will not change between patch versions.

## Supported Platforms

Stargazer officially supports Linux and FreeBSD.  It will likely work on other 
BSDs, MacOS, Windows, and other platforms that its dependencies support but 
it's not currently tested on those platforms. Other free platforms may be
officially supported in the future if there are sufficient requests for them.
Patches to support other platforms likely will be accepted though.

## Usage

Configure stargazer by editing it's config file, normally found at
`/etc/stargazer.ini`. See [**stargazer**(1)](./doc/stargazer.1.txt) for CLI
options and [**stargazer.ini**(5)](./doc/stargazer.ini.5.txt) for configuration
instructions.

## Security

Stargazer should be reasonably secure. I used it myself and I've tested it
quite a bit. However, Stargazer has been almost exclusively written by one
person and hasn't gone through any formal code review or audit so keep that in
mind.

Do be mindful if you use CGI scripts. It can be easy to write them incorrectly
such that they cause security problems. Especially if they are written in POSIX
shell.

### Know security issues

#### FIXED Root escape - pre 0.4.0

Stargazer would serve files from anywhere on the file system if a path starting
with `//` was requested.

## Copying

All of the source code and resulting binaries of **stargazer** is licensed
under the terms of the [GNU AFFERO GENERAL PUBLIC LICENSE Version 3](./LICENSE).

## Contributing

Please send any and all patches, bugs, and questions to the stargazer mailing
list [~zethra/stargazer@lists.sr.ht](mailto:~zethra/stargazer@lists.sr.ht)
or submit a ticket to the bug tracker if you feel so inclined
[todo.sr.ht/~zethra/stargazer](https://todo.sr.ht/~zethra/stargazer).
You can also contact me directly. Up to date contact info can be found on my
website [sashanoraa.gay](https://sashanoraa.gay/).

### Help Wanted with Packaging

If you can package stargazer please do! I currently maintain an Arch and Alpine
package but if you can package for any other distro please do and let me know.

