use starbox::*;

#[test]
fn constructor() {
    // Construct from image
    let canvas = Canvas::from_image("tests/charizard.png", "windows-95-256");
    assert!(canvas.is_ok());
    let mut canvas = canvas.unwrap();
    assert_eq!(Size::Large, canvas.size());

    // Set title/author
    assert_eq!(canvas.author(), "Unknown");
    assert_eq!(canvas.title(), "Untitled");
    assert!(canvas.set_author("Game Freak").is_ok());
    assert_eq!("Game Freak", canvas.author());
    assert!(canvas.set_title("Charizard").is_ok());
    assert_eq!("Charizard", canvas.title());

    // to/from bytes
    let bytes = canvas.to_bytes().unwrap();
    let from_bytes = Canvas::from_bytes(&bytes).unwrap();
    assert_eq!(from_bytes, canvas);

    // write/read file
    let filename = "tests/test_out.sb";
    assert!(canvas.save(filename).is_ok());
    let loaded_canvas = Canvas::load(filename);
    assert!(loaded_canvas.is_ok());
    let loaded_canvas = loaded_canvas.unwrap();
    assert_eq!(canvas, loaded_canvas);

    // Segmentalize
    assert!(canvas.segmentalize(1024).is_err());
    let segments = canvas.segmentalize(256).unwrap();
    for segment in &segments {
        dbg!(segment.serialized_size().unwrap());
    }
    let segment = &segments[0];
    assert!(match segment.segmental() {
        Segment::Partial(_i, total) => {
            total == segments.len()
        }
        Segment::Complete => segments.len() == 1,
    });
    assert!(segment.serialized_size().unwrap() <= 1024);

    // Join segments
    let canvas_rejoined = Canvas::from_segments(&segments);
    assert!(canvas_rejoined.is_ok());
    let canvas_rejoined = canvas_rejoined.unwrap();
    assert_eq!(canvas, canvas_rejoined);
}
