use clap::Clap;
use starbox::*;
use std::path::Path;

#[derive(Clap, Debug)]
struct Opts {
    image: String,
    #[clap(short, long)]
    title: Option<String>,
    #[clap(short, long, default_value = "Unknown")]
    author: String,
    #[clap(long)]
    output_image: Option<String>,
    #[clap(long)]
    output_qr: Option<String>,
    #[clap(long)]
    output_sb: Option<String>,
    #[clap(short, long, default_value = "windows-95-256")]
    palette: String,
}

fn main() {
    let opts = Opts::parse();
    let image_path = Path::new(&opts.image);

    if !image_path.exists() {
        eprintln!("Image does not exist: '{}'", image_path.display());
        return;
    }

    let title = match opts.title {
        Some(title) => title,
        None => Path::new(&opts.image)
            .file_stem()
            .expect("Could not parse file name.")
            .to_str()
            .unwrap()
            .to_string(),
    };

    let mut canvas = Canvas::from_image(&opts.image, &opts.palette).unwrap();
    canvas.set_title(&title).unwrap();
    canvas.set_author(&opts.author).unwrap();

    if let Some(out_image) = opts.output_image {
        canvas.save_image(&out_image).unwrap();
    }
    if let Some(out_sb) = opts.output_sb {
        canvas.save(&out_sb).unwrap();
    }
    if let Some(out_qr) = opts.output_qr {
        canvas.save_qr(&out_qr).unwrap();
    }
}
