/// An error occurs when there are more than `L` bytes are attempted to be
/// pushed into a `String<L>` or when a `String` is being created with less than `L` bytes.
#[derive(Copy, Clone, Debug, PartialEq)]
pub struct Error<const L: usize>(pub usize);

impl<const L: usize> From<usize> for Error<L> {
    fn from(l: usize) -> Self {
        Self(l)
    }
}

impl<const L: usize> core::fmt::Display for Error<L> {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "Tried to push {} bytes into a string of size {}",
            self.0, L
        )
    }
}

impl<const L: usize> std::error::Error for Error<L> {}
