# Stacking
[![pipeline status](https://gitlab.sokoll.com/moritz/stacking.rs/badges/master/pipeline.svg)](https://gitlab.sokoll.com/moritz/stacking.rs/-/commits/master)

`stacking` is a module containing tools for building stacks in rust
                                                                                                     
## Stack
                                                                                                     
`stacking` comes with a `Stack` builtin.
It only supports `pop`, `push` and `len` as actions
                                                                                                     
### Examples
                                                                                                     
```rust
use stacking::stacks::Stack;
                                                                                                     
let mut stack: Stack<i32> = Stack::new();
assert_eq!(stack.len(), 0);
stack.push(4);
assert_eq!(stack.len(), 1);
assert_eq!(stack.pop(), Some(4));
```
                                                                                                     
This simple example creates a stack, appends `4` to it and pops it off again.
                                                                                                     
## Nodes
`stacking` also contains a `Node`.
A `Node` can be used to build custom stacks or other data structures with specific orders.
                                                                                                     
### Examples
                                                                                                     
```rust
use stacking::nodes::Node;
                                                                                                     
let mut n1: Node<i32> = Node::new(None, None, 15);
let mut n2: Node<i32> = Node::new(None, Some(n1.clone()), 14);
assert_eq!(n1.val, 15);
assert_eq!(n2.val, 14);
```
                                                                                                     
This will create two nodes referencing each other to create an order in which after `n2` comes `n1`.
