mod instructions;
pub mod state;

use {anchor_lang::prelude::*, instructions::*};

declare_id!("DBMi4GBjiX15vCMVj93uB7JYM9LU6rCaZJraVKM6XgZi");

#[program]
pub mod stack_program {
    use super::*;

    pub fn create_stack(ctx: Context<CreateStack>, bump: u8) -> ProgramResult {
        create_stack::handler(ctx, bump)
    }

    pub fn delete_stack(ctx: Context<DeleteStack>) -> ProgramResult {
        delete_stack::handler(ctx)
    }

    pub fn pop_element(ctx: Context<PopElement>) -> ProgramResult {
        pop_element::handler(ctx)
    }

    pub fn push_element(ctx: Context<PushElement>, value: Pubkey, bump: u8) -> ProgramResult {
        push_element::handler(ctx, value, bump)
    }
}
