use {
    anchor_lang::prelude::*,
    crate::state::*,
};

#[derive(Accounts)]
pub struct PopElement<'info> {
    #[account(
        mut, 
        seeds = [
            SEED_STACK, 
            stack.owner.key().as_ref(), 
            stack.namespace.as_ref()
        ],
        bump = stack.bump, 
        has_one = owner,
    )]
    pub stack: Account<'info, Stack>,

    #[account(mut)]
    pub owner: Signer<'info>,

    #[account(
        mut,
        seeds = [
            SEED_ELEMENT,
            stack.key().as_ref(),
            element.position.to_be_bytes().as_ref(),
        ],
        bump = element.bump,
        close = owner,
        constraint = element.position == stack.count - 1
    )]
    pub element: Account<'info, Element>,
}

pub fn handler(ctx: Context<PopElement>) -> ProgramResult {
    // Get accounts.
    let stack = &mut ctx.accounts.stack;

    // Decrement stack counter.
    stack.count -= 1;
    
    return Ok(());
}
