use {
    anchor_lang::prelude::*,
    crate::state::*,
};

#[derive(Accounts)]
pub struct DeleteStack<'info> {
    #[account(
        mut, 
        seeds = [
            SEED_STACK, 
            stack.owner.key().as_ref(), 
            stack.namespace.as_ref()
        ],
        bump = stack.bump, 
        has_one = owner,
        close = owner,
        constraint = stack.count == 0
    )]
    pub stack: Account<'info, Stack>,

    #[account(mut)]
    pub owner: Signer<'info>,
}

pub fn handler(_ctx: Context<DeleteStack>) -> ProgramResult {
    return Ok(());
}
