use {
    anchor_lang::{
        prelude::*,
        solana_program::system_program
    },
    crate::state::*,
    std::mem::size_of
};

#[derive(Accounts)]
#[instruction(
    bump: u8,
)]
pub struct CreateStack<'info> {
    #[account(
        init, 
        seeds = [
            SEED_STACK, 
            owner.key().as_ref(),
            namespace.key().as_ref()
        ],
        bump = bump, 
        payer = payer, 
        space = 8 + size_of::<Stack>()
    )]
    pub stack: Account<'info, Stack>,

    #[account()]
    pub namespace: AccountInfo<'info>,

    #[account(mut)]
    pub owner: Signer<'info>,

    #[account(mut)]
    pub payer: Signer<'info>,
    
    #[account(address = system_program::ID)]
    pub system_program: Program<'info, System>,
}

pub fn handler(
    ctx: Context<CreateStack>, 
    bump: u8,
) -> ProgramResult {
    // Get accounts.
    let stack = &mut ctx.accounts.stack;
    let namespace = &ctx.accounts.namespace;
    let owner = &ctx.accounts.owner;

    // Initialize stack account.
    stack.owner = owner.key();
    stack.namespace = namespace.key();
    stack.count = 0;
    stack.bump = bump;
    
    return Ok(());
}