import { Program } from "@project-serum/anchor";
import {
  PublicKey,
  SystemProgram,
  TransactionInstruction,
} from "@solana/web3.js";
import { StackProgram } from "../idl";
import { Account } from "../account";

export type PushElementArgs = {
  stack: PublicKey;
  owner: PublicKey;
  value: PublicKey;
};

export class PushElement {
  private account: Account;
  private program: Program<StackProgram>;

  constructor(account: Account, program: Program<StackProgram>) {
    this.account = account;
    this.program = program;
  }

  public async pushElement({
    stack,
    owner,
    value,
  }: PushElementArgs): Promise<TransactionInstruction> {
    const stackData = await this.account.stack.data(stack);
    const elementPDA = await this.account.element.pda(stack, stackData.count);
    return this.program.instruction.pushElement(value, elementPDA.bump, {
      accounts: {
        stack: stack,
        element: elementPDA.address,
        owner: owner,
        payer: owner,
        systemProgram: SystemProgram.programId,
      },
    });
  }
}
