import { BN, Program } from "@project-serum/anchor";
import { PublicKey, TransactionInstruction } from "@solana/web3.js";
import { StackProgram } from "../idl";
import { Account } from "../account";

export type PopElementArgs = {
  stack: PublicKey;
};

export class PopElement {
  private account: Account;
  private program: Program<StackProgram>;

  constructor(account: Account, program: Program<StackProgram>) {
    this.account = account;
    this.program = program;
  }

  public async popElement({
    stack,
  }: PopElementArgs): Promise<TransactionInstruction> {
    const stackData = await this.account.stack.data(stack);
    const elementPDA = await this.account.element.pda(
      stack,
      stackData.count.sub(new BN(1))
    );
    return this.program.instruction.popElement({
      accounts: {
        stack: stack,
        element: elementPDA.address,
        owner: stackData.owner,
      },
    });
  }
}
