import { Program } from "@project-serum/anchor";
import { TransactionInstruction } from "@solana/web3.js";
import { StackProgram } from "../idl";
import { Account } from "../account";

import { CreateStack, CreateStackArgs } from "./createStack";
import { DeleteStack, DeleteStackArgs } from "./deleteStack";
import { PushElement, PushElementArgs } from "./pushElement";
import { PopElement, PopElementArgs } from "./popElement";

export class Instruction {
  private account: Account;
  private program: Program<StackProgram>;

  public createStack: (
    args: CreateStackArgs
  ) => Promise<TransactionInstruction>;

  public deleteStack: (
    args: DeleteStackArgs
  ) => Promise<TransactionInstruction>;

  public pushElement: (
    args: PushElementArgs
  ) => Promise<TransactionInstruction>;

  public popElement: (args: PopElementArgs) => Promise<TransactionInstruction>;

  constructor(account: Account, program: Program<StackProgram>) {
    this.account = account;
    this.program = program;

    this.createStack = new CreateStack(account, program).createStack;
    this.deleteStack = new DeleteStack(account, program).deleteStack;
    this.popElement = new PopElement(account, program).popElement;
    this.pushElement = new PushElement(account, program).pushElement;
  }
}
