import { Program } from "@project-serum/anchor";
import { PublicKey, TransactionInstruction } from "@solana/web3.js";
import { StackProgram } from "../idl";
import { Account } from "../account";

export type DeleteStackArgs = {
  stack: PublicKey;
};

export class DeleteStack {
  private account: Account;
  private program: Program<StackProgram>;

  constructor(account: Account, program: Program<StackProgram>) {
    this.account = account;
    this.program = program;
  }

  public async deleteStack({
    stack,
  }: DeleteStackArgs): Promise<TransactionInstruction> {
    const stackData = await this.account.stack.data(stack);
    return this.program.instruction.deleteStack({
      accounts: {
        stack: stack,
        owner: stackData.owner,
      },
    });
  }
}
