import { Program } from "@project-serum/anchor";
import {
  PublicKey,
  SystemProgram,
  TransactionInstruction,
} from "@solana/web3.js";
import { StackProgram } from "../idl";
import { Account } from "../account";

export type CreateStackArgs = {
  namespace: PublicKey;
  owner: PublicKey;
  payer: PublicKey;
};

export class CreateStack {
  private account: Account;
  private program: Program<StackProgram>;

  constructor(account: Account, program: Program<StackProgram>) {
    this.account = account;
    this.program = program;
  }

  public async createStack({
    namespace,
    owner,
    payer,
  }: CreateStackArgs): Promise<TransactionInstruction> {
    const stackPDA = await this.account.stack.pda(owner, namespace);
    return this.program.instruction.createStack(stackPDA.bump, {
      accounts: {
        stack: stackPDA.address,
        namespace: namespace,
        owner: owner,
        payer: payer,
        systemProgram: SystemProgram.programId,
      },
    });
  }
}
