import { Gateway, findPDA } from "@faktorfi/utils";
import { PublicKey } from "@solana/web3.js";
import { StackProgram } from "../idl";

const SEED_STACK = Buffer.from("stk");

export class StackGateway extends Gateway<
  StackProgram,
  StackProgram["accounts"][1]
> {
  public async pda(owner: PublicKey, namespace: PublicKey) {
    return await findPDA(
      [SEED_STACK, owner.toBuffer(), namespace.toBuffer()],
      this.program.programId
    );
  }
}
