import { Program } from "@project-serum/anchor";
import { StackProgram } from "../idl";

import { StackGateway } from "./stack";
import { ElementGateway } from "./element";

export class Account {
  public element: ElementGateway;
  public stack: StackGateway;

  constructor(program: Program<StackProgram>) {
    this.element = new ElementGateway(program, program.account.element);
    this.stack = new StackGateway(program, program.account.stack);
  }
}
