use borsh::{BorshDeserialize, BorshSerialize};
use core::fmt;

#[derive(PartialEq, Eq, PartialOrd, Ord, Clone, Copy, BorshDeserialize, BorshSerialize)]
pub enum StackUsize {
    U0 = 0x00,
    U2 = 0x02,
    U3 = 0x03,
    U4 = 0x04,
}

impl From<usize> for StackUsize {
    fn from(value: usize) -> Self {
        match value {
            0x02 => StackUsize::U2,
            0x03 => StackUsize::U3,
            0x04 => StackUsize::U4,
            _ => StackUsize::U0,
        }
    }
}

impl Default for StackUsize {
    fn default() -> Self {
        StackUsize::U2
    }
}

impl fmt::Debug for StackUsize {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(
            f,
            "{}",
            match self {
                StackUsize::U0 => "StackUsize::U0",
                StackUsize::U2 => "StackUsize::U2",
                StackUsize::U3 => "StackUsize::U3",
                StackUsize::U4 => "StackUsize::U4",
            }
        )
    }
}

pub const fn init_storage_stack(bar: &StackUsize) -> usize {
    match bar {
        StackUsize::U2 => 2,
        StackUsize::U3 => 3,
        StackUsize::U4 => 4,
        _ => 0,
    }
}
