# Contributing to **stac-rs**

First off, thanks for contributing!
We appreciates you.

## Testing

We aim for comprehensive unit testing of this library.
Please provide tests for any new features, or to demonstrate bugs.
Draft pull requests with a failing test to demonstrate a bug are much appreciated.

## Submitting changes

Please open a [pull request](https://docs.github.com/en/pull-requests) with your changes -- make sure to include unit tests.
Please follow standard git commit formatting (subject line 50 characters max, wrap the body at 72 characters).

We use [conventional commits](https://www.conventionalcommits.org/en/v1.0.0/).
Your commits do not have to but if you'd like to format them this way, we would be grateful.

If you can, use `git rebase -i` to create a clean, well-formatted history before opening your pull request.
If you need to make changes after opening your pull request (e.g. to fix CI breakages) we will be grateful if you squash those fixes into their relevant commits.


Thanks so much! \
-Pete Gadomski
