mod test_utils;

use ssz_rs::prelude::*;
use test_utils::{
    deserialize, hash_tree_root, read_ssz_snappy_from_test_data, root_from_hex, serialize,
};

#[derive(PartialEq, Eq, Debug, Default, SimpleSerialize)]
struct SingleFieldTestStruct {
    a: u8,
}

#[derive(PartialEq, Eq, Debug, Default, SimpleSerialize)]
struct SmallTestStruct {
    a: u16,
    b: u16,
}

#[derive(PartialEq, Eq, Debug, Default, Clone, SimpleSerialize)]
struct FixedTestStruct {
    a: u8,
    b: u64,
    c: u32,
}

#[derive(PartialEq, Eq, Debug, Default, Clone, SimpleSerialize)]
struct VarTestStruct {
    a: u16,
    b: List<u16, 1024>,
    c: u8,
}

#[derive(PartialEq, Eq, Debug, Default, SimpleSerialize)]
struct ComplexTestStruct {
    a: u16,
    b: List<u16, 128>,
    c: u8,
    d: List<u8, 256>,
    e: VarTestStruct,
    f: Vector<FixedTestStruct, 4>,
    g: Vector<VarTestStruct, 2>,
}

#[derive(PartialEq, Eq, Debug, Default, SimpleSerialize)]
struct BitsStruct {
    a: Bitlist<5>,
    b: Bitvector<2>,
    c: Bitvector<1>,
    d: Bitlist<6>,
    e: Bitvector<8>,
}

#[test]
fn test_containers_var_test_struct_zero_chaos_2() {
    let value = VarTestStruct {
        a: 0,
        b: List::<u16, 1024>::from_iter([
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        ]),
        c: 0,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_zero_chaos_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("e0021bb04ff4cbf7fdb8ce02d79ed8295dedafb6f1b44a30a500cc97d800e36a");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_random_chaos_1() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([true, true, true, false, true]),
        b: Bitvector::<2>::from_iter([true, true]),
        c: Bitvector::<1>::from_iter([false]),
        d: Bitlist::<6>::from_iter([]),
        e: Bitvector::<8>::from_iter([false, false, true, true, false, true, true, false]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_random_chaos_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("f11a74232c75623074eeb6bf827b692e43f613e672b40ed442f72cd01c5ee2f4");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_max_0() {
    let value = ComplexTestStruct {
        a: 65535,
        b: List::<u16, 128>::from_iter([65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535]),
        c: 255,
        d: List::<u8, 256>::from_iter([255]),
        e: VarTestStruct {
            a: 65535,
            b: List::<u16, 1024>::from_iter([
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535,
            ]),
            c: 255,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 65535,
                b: List::<u16, 1024>::from_iter([
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                ]),
                c: 255,
            },
            VarTestStruct {
                a: 65535,
                b: List::<u16, 1024>::from_iter([
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                ]),
                c: 255,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_max_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("9a7021a723498d5ae6cadbc025f7ff755e98438d410ce09fd55b27a9e6a25a5c");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_max_7() {
    let value = ComplexTestStruct {
        a: 65535,
        b: List::<u16, 128>::from_iter([
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535,
        ]),
        c: 255,
        d: List::<u8, 256>::from_iter([255]),
        e: VarTestStruct {
            a: 65535,
            b: List::<u16, 1024>::from_iter([
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535,
            ]),
            c: 255,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 65535,
                b: List::<u16, 1024>::from_iter([
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535,
                ]),
                c: 255,
            },
            VarTestStruct {
                a: 65535,
                b: List::<u16, 1024>::from_iter([
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535,
                ]),
                c: 255,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_max_7/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("2355b8f62ff0427f4f1bda41968c93eb41f6be15f2989b2e235ab24772699bbf");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_max_chaos_2() {
    let value = SingleFieldTestStruct { a: 255 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data("ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_max_chaos_2/serialized.ssz_snappy");
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("ff00000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_zero_chaos_1() {
    let value = FixedTestStruct { a: 0, b: 0, c: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_zero_chaos_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("db56114e00fdd4c1f85c892bf35ac9a89289aaecb1ebd0a96cde606a748b5d71");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_one_3() {
    let value = ComplexTestStruct {
        a: 49003,
        b: List::<u16, 128>::from_iter([15653]),
        c: 239,
        d: List::<u8, 256>::from_iter([148]),
        e: VarTestStruct {
            a: 56933,
            b: List::<u16, 1024>::from_iter([51513]),
            c: 227,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 198,
                b: 207392827392641159,
                c: 1227551918,
            },
            FixedTestStruct {
                a: 84,
                b: 10977915993707539152,
                c: 2750630791,
            },
            FixedTestStruct {
                a: 153,
                b: 4650923157821976456,
                c: 1619878481,
            },
            FixedTestStruct {
                a: 152,
                b: 8681817436929663740,
                c: 1036507554,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 50540,
                b: List::<u16, 1024>::from_iter([62171]),
                c: 33,
            },
            VarTestStruct {
                a: 37202,
                b: List::<u16, 1024>::from_iter([64409]),
                c: 142,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_one_3/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("1adf1503de419e5735c87cd21784ddf520cb547be4f18ea5d25390d65a654ef1");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_one_4() {
    let value = ComplexTestStruct {
        a: 33449,
        b: List::<u16, 128>::from_iter([11465]),
        c: 54,
        d: List::<u8, 256>::from_iter([146]),
        e: VarTestStruct {
            a: 18361,
            b: List::<u16, 1024>::from_iter([27935]),
            c: 175,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 253,
                b: 4615349917584694335,
                c: 872999527,
            },
            FixedTestStruct {
                a: 196,
                b: 943453220127137753,
                c: 1191989886,
            },
            FixedTestStruct {
                a: 222,
                b: 16035451323611208354,
                c: 3434643610,
            },
            FixedTestStruct {
                a: 17,
                b: 2846087815058082165,
                c: 837051951,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 37931,
                b: List::<u16, 1024>::from_iter([29047]),
                c: 70,
            },
            VarTestStruct {
                a: 25348,
                b: List::<u16, 1024>::from_iter([18965]),
                c: 186,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_one_4/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("f8591818dc82c94e16373493167e3a04d837fe453a532336d2f4b80c986b7da5");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_max_9() {
    let value = ComplexTestStruct {
        a: 65535,
        b: List::<u16, 128>::from_iter([
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
        ]),
        c: 255,
        d: List::<u8, 256>::from_iter([255]),
        e: VarTestStruct {
            a: 65535,
            b: List::<u16, 1024>::from_iter([
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            ]),
            c: 255,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 65535,
                b: List::<u16, 1024>::from_iter([
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                ]),
                c: 255,
            },
            VarTestStruct {
                a: 65535,
                b: List::<u16, 1024>::from_iter([
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535,
                ]),
                c: 255,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_max_9/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("8fc6ab2617bc9d8e8b0156ec1c6cda0d5b9f09c91e2ab52900e65376c767bfc3");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_small_test_struct_zero() {
    let value = SmallTestStruct { a: 0, b: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SmallTestStruct_zero/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SmallTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("f5a5fd42d16a20302798ef6ed309979b43003d2320d9f0e8ea9831a92759fb4b");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_zero_chaos_1() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([]),
        b: Bitvector::<2>::from_iter([false, false]),
        c: Bitvector::<1>::from_iter([false]),
        d: Bitlist::<6>::from_iter([]),
        e: Bitvector::<8>::from_iter([false, false, false, false, false, false, false, false]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_zero_chaos_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("aaaa3533b5c1fb113f5629286d167a1c134872b245c59f5b1f547fc325618d84");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_max_8() {
    let value = SingleFieldTestStruct { a: 255 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_max_8/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("ff00000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_max_1() {
    let value = SingleFieldTestStruct { a: 255 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_max_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("ff00000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_random_5() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([false, false, true]),
        b: Bitvector::<2>::from_iter([false, true]),
        c: Bitvector::<1>::from_iter([false]),
        d: Bitlist::<6>::from_iter([true]),
        e: Bitvector::<8>::from_iter([false, false, true, false, false, false, true, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_random_5/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("5c652a6881fdbcf2bb433889972d124eeaefc56e933603449bd5654f3aa77f4d");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_max_chaos_0() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([true, true, true]),
        b: Bitvector::<2>::from_iter([true, true]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([true, true, true]),
        e: Bitvector::<8>::from_iter([true, true, true, true, true, true, true, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_max_chaos_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("f4d67e998921885ee4480b12b72a3fa729ac54f8b6c5b7e02bfc5be185bcec3a");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_zero_2() {
    let value = ComplexTestStruct {
        a: 0,
        b: List::<u16, 128>::from_iter([
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        ]),
        c: 0,
        d: List::<u8, 256>::from_iter([0]),
        e: VarTestStruct {
            a: 0,
            b: List::<u16, 1024>::from_iter([
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            ]),
            c: 0,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 0,
                b: List::<u16, 1024>::from_iter([
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                ]),
                c: 0,
            },
            VarTestStruct {
                a: 0,
                b: List::<u16, 1024>::from_iter([
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                ]),
                c: 0,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_zero_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("1f6d75d4252f3c39169e59d7831661be5224e98bd91460fd93582645af0e8abf");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_zero_3() {
    let value = SingleFieldTestStruct { a: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_zero_3/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("0000000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_max_6() {
    let value = SingleFieldTestStruct { a: 255 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_max_6/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("ff00000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_zero_4() {
    let value = SingleFieldTestStruct { a: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_zero_4/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("0000000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_zero_5() {
    let value = ComplexTestStruct {
        a: 0,
        b: List::<u16, 128>::from_iter([
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0,
        ]),
        c: 0,
        d: List::<u8, 256>::from_iter([0]),
        e: VarTestStruct {
            a: 0,
            b: List::<u16, 1024>::from_iter([
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0,
            ]),
            c: 0,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 0,
                b: List::<u16, 1024>::from_iter([
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                ]),
                c: 0,
            },
            VarTestStruct {
                a: 0,
                b: List::<u16, 1024>::from_iter([
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0,
                ]),
                c: 0,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_zero_5/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("b14eff3c8dcf43636fb3674437f01c1e31541a4fe2f59fce85969931cf502e66");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_random_2() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([true, false, false]),
        b: Bitvector::<2>::from_iter([false, false]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([true, false, false, false]),
        e: Bitvector::<8>::from_iter([true, false, true, false, false, true, true, false]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_random_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("b8f13ccf822810bb645e3c6fb81ebb92971e06d9a3bffb4ec521f55de27f8138");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_one_5() {
    let value = ComplexTestStruct {
        a: 522,
        b: List::<u16, 128>::from_iter([58016]),
        c: 1,
        d: List::<u8, 256>::from_iter([219]),
        e: VarTestStruct {
            a: 55674,
            b: List::<u16, 1024>::from_iter([51843]),
            c: 103,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 51,
                b: 8951864537982408591,
                c: 648765584,
            },
            FixedTestStruct {
                a: 123,
                b: 4699791381600974666,
                c: 2038553040,
            },
            FixedTestStruct {
                a: 170,
                b: 1053862214600258695,
                c: 1813309682,
            },
            FixedTestStruct {
                a: 254,
                b: 4682841909108083768,
                c: 3230963302,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 5130,
                b: List::<u16, 1024>::from_iter([59171]),
                c: 150,
            },
            VarTestStruct {
                a: 48351,
                b: List::<u16, 1024>::from_iter([14640]),
                c: 9,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_one_5/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("65b2e7eb07c99979ba85bc12bfb32c3f443bdc9a0a5ea5c284d5f4a4a8255615");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_max_8() {
    let value = ComplexTestStruct {
        a: 65535,
        b: List::<u16, 128>::from_iter([
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
        ]),
        c: 255,
        d: List::<u8, 256>::from_iter([255]),
        e: VarTestStruct {
            a: 65535,
            b: List::<u16, 1024>::from_iter([
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535,
            ]),
            c: 255,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 65535,
                b: List::<u16, 1024>::from_iter([
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                ]),
                c: 255,
            },
            VarTestStruct {
                a: 65535,
                b: List::<u16, 1024>::from_iter([
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535,
                ]),
                c: 255,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_max_8/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("92ca028b53e0f56f97935a2a736f42f176f4810165ed93b8aae9637825ceecf6");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_one_2() {
    let value = ComplexTestStruct {
        a: 12541,
        b: List::<u16, 128>::from_iter([2249]),
        c: 53,
        d: List::<u8, 256>::from_iter([126]),
        e: VarTestStruct {
            a: 37873,
            b: List::<u16, 1024>::from_iter([24680]),
            c: 104,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 111,
                b: 9187765509688476407,
                c: 1210202299,
            },
            FixedTestStruct {
                a: 158,
                b: 18103802857683004608,
                c: 3789132591,
            },
            FixedTestStruct {
                a: 124,
                b: 1767260191485559055,
                c: 2679810848,
            },
            FixedTestStruct {
                a: 146,
                b: 10731242871815542387,
                c: 1584483294,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 49176,
                b: List::<u16, 1024>::from_iter([36844]),
                c: 150,
            },
            VarTestStruct {
                a: 3399,
                b: List::<u16, 1024>::from_iter([39383]),
                c: 4,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_one_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("bfb6c2ce9bbc2339a06b32d54b9beebb6628397f1bc9f31b2919045350e076da");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_zero_chaos_0() {
    let value = FixedTestStruct { a: 0, b: 0, c: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_zero_chaos_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("db56114e00fdd4c1f85c892bf35ac9a89289aaecb1ebd0a96cde606a748b5d71");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_max_6() {
    let value = ComplexTestStruct {
        a: 65535,
        b: List::<u16, 128>::from_iter([
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
        ]),
        c: 255,
        d: List::<u8, 256>::from_iter([255]),
        e: VarTestStruct {
            a: 65535,
            b: List::<u16, 1024>::from_iter([
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            ]),
            c: 255,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 65535,
                b: List::<u16, 1024>::from_iter([
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535,
                ]),
                c: 255,
            },
            VarTestStruct {
                a: 65535,
                b: List::<u16, 1024>::from_iter([
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                ]),
                c: 255,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_max_6/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("f2e200a0ed6dddf52d635ab3b163ab612c1e8f1d9f614f3aef85beb4cd66cdd2");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_lengthy_chaos_2() {
    let value = ComplexTestStruct {
        a: 43914,
        b: List::<u16, 128>::from_iter([
            62086, 1328, 36452, 57324, 9737, 54653, 31513, 53012, 55142, 1461, 52584, 61080, 47577,
            41202, 28554, 51016, 3395, 21150, 12211, 16631, 4736, 51622, 20853, 48055, 36665,
            38198, 21707, 62715, 27251, 56397, 58251, 20691, 59462, 54066, 14496, 12001, 57294,
            56845, 26369, 29814, 34603, 34624, 32640, 24630, 53704, 52972, 1442, 48234, 57217,
            7410, 54435, 39184, 16945, 26130, 19393, 29353, 46432, 22530, 25280, 46319, 2456,
            43794, 19084, 3999, 13723, 59888, 18991, 6336, 33994, 39883, 7156, 30544, 4935, 36305,
            46871, 44707, 2403, 24512, 18361, 45353, 23333, 41515, 51072, 6572, 4622, 7773, 20374,
            2079, 39276, 5866, 1956, 30298, 41162, 31599, 34614, 34697, 8326, 61013, 29554, 36633,
            48167, 20032, 25457, 51141, 25570, 16769, 33919, 35383, 41487, 53945, 59643, 15499,
            16000, 28282, 8774, 61412, 30042, 22151, 7154, 31953, 53103, 43074, 3550, 62797, 56455,
            2268, 34010, 46390,
        ]),
        c: 115,
        d: List::<u8, 256>::from_iter([
            67, 108, 235, 173, 230, 5, 113, 72, 60, 94, 194, 112, 0, 195, 72, 239, 116, 39, 209, 7,
            55, 12, 69, 237, 106, 45, 69, 169, 158, 5, 86, 197, 56, 18, 136, 199, 56, 253, 135,
            167, 99, 191, 156, 177, 203, 104, 181, 35, 173, 200, 59, 66, 34, 241, 28, 7, 202, 17,
            152, 1, 80, 229, 248, 221, 104, 209, 225, 153, 248, 141, 133, 252, 32, 31, 190, 39,
            252, 34, 242, 143, 198, 66, 128, 86, 68, 48, 157, 76, 204, 134, 206, 168, 107, 34, 30,
            238, 30, 166, 247, 74, 6, 193, 108, 96, 33, 92, 149, 243, 186, 0, 179, 78, 185, 77,
            197, 17, 160, 176, 210, 92, 0, 95, 167, 215, 41, 9, 253, 91, 57, 27, 83, 118, 243, 242,
            125, 159, 71, 97, 170, 221, 158, 90, 42, 176, 152, 77, 213, 181, 94, 141, 158, 47, 133,
            54, 30, 236, 128, 160, 204, 103, 189, 183, 9, 245, 176, 173, 227, 87, 148, 39, 236,
            102, 112, 112, 254, 0, 164, 157, 178, 74, 94, 213, 181, 187, 169, 85, 18, 139, 177,
            121, 109, 119, 188, 237, 125, 99, 126, 78, 93, 197, 98, 118, 19, 103, 137, 62, 97, 244,
            239, 40, 191, 78, 123, 59, 69, 87, 141, 185, 229, 209, 146, 29, 83, 119, 118, 231, 164,
            154, 8, 155, 120, 254, 112, 189, 55, 125, 183, 130, 92, 131, 250, 23, 193, 66, 100,
            106, 165, 194, 172, 37, 60, 139, 111, 203, 59, 156,
        ]),
        e: VarTestStruct {
            a: 23486,
            b: List::<u16, 1024>::from_iter([
                15593, 63604, 1036, 11176, 19273, 36219, 35466, 12766, 22074, 40009, 2165, 60871,
                10347, 18371, 24026, 49210, 12254, 61533, 19213, 17225, 47173, 23502, 19775, 16365,
                22372, 23420, 17370, 16473, 31126, 21509, 57384, 13788, 57261, 35364, 16417, 44529,
                7955, 44734, 34744, 16949, 22873, 45312, 61913, 21451, 54156, 34596, 48106, 38739,
                19399, 17826, 65002, 48667, 45100, 33250, 13181, 53778, 61679, 12600, 34137, 23291,
                11566, 54421, 3586, 52520, 52111, 22904, 34356, 16399, 42888, 44715, 811, 14021,
                29563, 19294, 20194, 4654, 30802, 53104, 63566, 16361, 18204, 40434, 14592, 54330,
                34911, 65254, 15030, 40691, 4026, 57356, 37607, 51999, 7557, 60424, 32999, 5102,
                55569, 7475, 32717, 39629, 46335, 18013, 63081, 15022, 16576, 27703, 15518, 17745,
                39333, 27791, 39625, 14139, 1093, 55255, 14612, 14935, 12345, 5001, 17837, 28995,
                29585, 5056, 54529, 11226, 19431, 54130, 52849, 63301, 38394, 53611, 9896, 40345,
                20777, 52688, 43652, 33871, 31087, 31651, 35739, 40443, 25280, 10296, 15747, 32611,
                1081, 39938, 14502, 9303, 3537, 60499, 36699, 24564, 65253, 6807, 30936, 41530,
                48628, 6260, 15739, 1139, 40541, 47136, 15559, 42283, 289, 14025, 46768, 12445,
                65457, 29556, 56398, 22133, 4010, 15117, 51299, 1849, 41906, 3322, 63024, 29634,
                59788, 8797, 37379, 46302, 54222, 59902, 39908, 892, 40776, 851, 63341, 17747,
                9924, 31453, 3330, 47434, 49418, 38032, 15150, 19307, 14499, 55637, 62039, 31569,
                7939, 22269, 29644, 36440, 29079, 54213, 60614, 8454, 7136, 25386, 54692, 52439,
                7988, 4419, 7337, 5885, 37333, 44102, 8467, 19262, 14565, 29567, 4389, 2150, 22606,
                24929, 62638, 36224, 59591, 64252, 12798, 33698, 57182, 49489, 21629, 29980, 16955,
                56048, 31331, 672, 7913, 36101, 4590, 9552, 64424, 48603, 63066, 48019, 35026,
                32305, 63429, 47675, 9882, 63825, 1988, 51424, 64792, 7468, 53151, 11836, 26345,
                18733, 8007, 59569, 43430, 24548, 19184, 63699, 22931, 48166, 36294, 10338, 53620,
                23212, 39218, 18483, 45371, 55720, 27938, 4726, 44647, 38401, 49521, 19471, 44093,
                63219, 13068, 37585, 29740, 24131, 14987, 28170, 29699, 21522, 53644, 10230, 61387,
                40881, 54835, 32503, 30687, 17639, 20658, 41262, 57767, 32695, 57562, 33557, 61532,
                39796, 38990, 37545, 21916, 36408, 23564, 21978, 33729, 17441, 39285, 39075, 32251,
                11196, 530, 20433, 53546, 3251, 5308, 7916, 15230, 15239, 29647, 11165, 13798,
                15624, 45725, 24663, 27518, 29704, 20356, 17569, 23591, 40658, 62983, 13806, 32779,
                49993, 60125, 35645, 34057, 21187, 700, 22933, 42449, 11875, 38642, 54045, 62276,
                17852, 43830, 33150, 7567, 26722, 12643, 61311, 11197, 31854, 24390, 14883, 43019,
                16072, 28709, 53377, 14780, 41804, 28600, 22978, 59696, 28566, 22795, 54819, 565,
                25043, 60497, 61053, 25985, 5623, 48427, 28414, 63343, 1552, 24065, 55802, 52313,
                20987, 20413, 23652, 38352, 35994, 2359, 34882, 54943, 51456, 45078, 2482, 50647,
                9045, 44827, 13211, 7614, 30564, 37107, 42904, 16679, 18928, 346, 60545, 23498,
                56045, 24394, 4957, 1612, 31439, 40317, 26146, 21858, 62101, 6024, 23110, 1710,
                39471, 7255, 41863, 12500, 54170, 51554, 13006, 51282, 64352, 38251, 56915, 56357,
                59322, 41790, 38471, 37871, 16280, 5836, 21261, 63787, 63480, 50239, 19560, 13311,
                147, 61842, 59690, 46612, 3647, 36505, 15819, 48395, 62981, 22804, 64596, 31329,
                53717, 13176, 14350, 9580, 59930, 6626, 46327, 45394, 32470, 52910, 63908, 35667,
                56648, 59841, 23125, 47598, 64652, 43078, 9051, 38319, 2169, 33224, 8208, 25652,
                31213, 65189, 49435, 22200, 25770, 10046, 56995, 6051, 37079, 47757, 1575, 31413,
                62094, 47831, 37338, 22664, 59667, 47280, 50437, 36960, 55442, 18695, 9506, 3419,
                37141, 32711, 13765, 44832, 44756, 43642, 13683, 39098, 51545, 48305, 61022, 50798,
                48781, 49651, 11142, 58483, 36057, 26512, 50015, 46941, 1717, 6499, 54385, 50804,
                21901, 57400, 56294, 33992, 57100, 47195, 53247, 11033, 64931, 51432, 63216, 24006,
                7085, 37975, 10085, 33231, 37845, 28664, 31642, 18596, 53057, 22196, 45887, 55139,
                33019, 10912, 29363, 47731, 26613, 27872, 33421, 10935, 40453, 6549, 24689, 22586,
                61720, 42568, 47856, 5594, 57343, 60876, 20883, 57761, 5956, 32113, 3280, 1178,
                15913, 2049, 59601, 16040, 32110, 32684, 53297, 29911, 29285, 39850, 46579, 820,
                53434, 1348, 4384, 44069, 9891, 26242, 123, 22715, 15634, 25332, 4730, 36848,
                15146, 54955, 26910, 6389, 21390, 41975, 40896, 64000, 57206, 33749, 40627, 1089,
                16195, 27857, 26715, 36724, 61762, 14098, 52516, 14825, 45574, 16740, 50819, 15917,
                42908, 57274, 59206, 48821, 18520, 63350, 21886, 5404, 56160, 14298, 50529, 19117,
                51178, 10729, 9479, 33161, 49061, 40405, 28682, 51229, 41030, 34045, 32018, 8913,
                8102, 54945, 19476, 10464, 25104, 29972, 30576, 23970, 18614, 30398, 48925, 22794,
                53775, 4360, 56013, 30762, 27630, 36344, 22201, 31812, 57292, 16847, 8723, 44865,
                14239, 21211, 40014, 45888, 9448, 42422, 10155, 47957, 54903, 19108, 30675, 38878,
                55849, 19222, 63753, 52007, 7711, 33914, 14692, 42498, 36292, 80, 58900, 62143,
                33579, 10866, 9229, 33885, 33596, 33049, 24701, 31623, 8145, 39668, 16053, 50623,
                48594, 30376, 54719, 3191, 24141, 51164, 47700, 23261, 50228, 44211, 16540, 16983,
                50346, 42231, 39277, 1890, 15757, 64567, 32369, 34087, 34497, 49583, 32796, 19877,
                6123, 33688, 26272, 9943, 364, 37190, 29476, 7916, 26196, 7435, 11626, 32608,
                36861, 55350, 21656, 57724, 51795, 3930, 4048, 47282, 29956, 20641, 44773, 60183,
                30145, 52596, 33581, 37854, 48499, 52450, 37241, 39260, 61850, 31260, 65004, 24599,
                59099, 8488, 9090, 26873, 42722, 11990, 55440, 6440, 52949, 42119, 39667, 39535,
                9551, 14793, 65248, 24786, 7594, 27946, 10427, 63086, 64125, 61148, 59202, 46526,
                36548, 58192, 38515, 45732, 15881, 5315, 33765, 63866, 24349, 41267, 36335, 46448,
                37326, 44485, 26486, 22998, 39914, 15176, 30154, 36370, 41988, 39079, 12642, 58414,
                18475, 59493, 4021, 12388, 14050, 27629, 39314, 3812, 8418, 36396, 56265, 21661,
                18297, 33798, 45977, 14658, 47219, 65435, 6893, 55984, 17635, 30505, 34812, 56035,
                341, 64693, 11675, 52967, 46548, 41950, 46037, 27232, 20237, 59428, 39272, 11168,
                63822, 51982, 34297, 9583, 40733, 54617, 8106, 63768, 49931, 42463, 51512, 33001,
                32730, 20866, 13896, 26820, 2256, 52704, 20449, 23064, 26726, 29364, 41601, 17879,
                18327, 41223, 1854, 41891, 39994, 22242, 6757, 33874, 23444, 888, 10838, 27845,
                29135, 11693, 7425, 12244, 16038, 2633, 12130, 14798, 50876, 38216, 42936, 17915,
                41877, 58345, 45828, 9014, 57600, 19775, 21573, 12511, 58596, 18220, 58924, 5404,
                18798, 7048, 30268, 38033, 41665, 29706, 48009, 60874, 35441, 3641, 25972, 34946,
                35012, 46392, 18328, 18080, 14997, 2596, 56549, 44023, 25242, 37423, 44762, 34635,
                54001, 2408, 29980, 64152, 1463, 905, 56029, 3463, 1799, 13585, 52253, 25167, 2143,
                24081, 61603, 10888, 45578, 13276, 26583, 63122, 34896, 22960, 39961, 28934, 24033,
                61958, 49473, 64840, 24974, 55178, 42152, 45365, 23387, 15509, 59867, 58993, 1684,
                33050, 2912, 41106, 24440, 20485, 2921, 48132, 47509, 51589, 28075, 4631, 61031,
                35897, 9677, 8828, 54958, 11312, 62827, 64638, 10491, 19197, 15403, 18327, 47761,
                55042, 40670, 19875, 52462, 15920, 8766, 30590, 65344, 21233, 41136, 58846, 61639,
                18621, 40045,
            ]),
            c: 132,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 159,
                b: 16295530782191573869,
                c: 898963900,
            },
            FixedTestStruct {
                a: 192,
                b: 1126888825704345083,
                c: 621551181,
            },
            FixedTestStruct {
                a: 76,
                b: 5513933778385349547,
                c: 203149383,
            },
            FixedTestStruct {
                a: 121,
                b: 16663028344398051269,
                c: 3304510184,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 27500,
                b: List::<u16, 1024>::from_iter([
                    29281, 21678, 50067, 64292, 22880, 65463, 7138, 53665, 14459, 7247, 28850,
                    3632, 48847, 4930, 27628, 65477, 46860, 56833, 37500, 54486, 32885, 40941,
                    35048, 2303, 51735, 33978, 3806, 7921, 10309, 6720, 40601, 58072, 30791, 41291,
                    59863, 47889, 44613, 39102, 64879, 18428, 60829, 17503, 15135, 42841, 52697,
                    13327, 25197, 21289, 12684, 3032, 52332, 31674, 54132, 46576, 9328, 19929,
                    15199, 28739, 64668, 14956, 12487, 11298, 63454, 8433, 59697, 10916, 10576,
                    7778, 2933, 6240, 41564, 33717, 33157, 32638, 28815, 24690, 56340, 57098,
                    12594, 4884, 10251, 52714, 38939, 50189, 59680, 60785, 8434, 21363, 38159,
                    21210, 7813, 57275, 48557, 19144, 49458, 37297, 4938, 55434, 57328, 48834,
                    31094, 52384, 46280, 36369, 32522, 50513, 43750, 21913, 42931, 33435, 56808,
                    51411, 33397, 19192, 314, 19092, 56648, 22113, 34241, 29343, 59574, 45397,
                    22937, 12923, 51665, 61548, 18252, 13989, 32443, 35371, 34000, 15966, 28542,
                    43895, 37691, 43946, 23361, 31019, 47770, 37293, 1317, 23353, 27705, 22762,
                    12063, 30990, 48165, 33960, 9359, 49239, 59607, 21590, 63123, 23882, 8591,
                    51475, 49097, 56351, 32627, 62560, 31764, 61277, 43166, 20931, 28824, 2261,
                    25890, 21257, 52400, 62298, 12636, 26512, 31233, 7924, 16836, 9421, 473, 45438,
                    52131, 33646, 13964, 22344, 49422, 22029, 2643, 15253, 60944, 19839, 51819,
                    37299, 33641, 45154, 17558, 37923, 16057, 14251, 19645, 31147, 25540, 24210,
                    47302, 4334, 61043, 49038, 49138, 14645, 60456, 34158, 51891, 45900, 9064,
                    52434, 16409, 27182, 14597, 50036, 63404, 44719, 36248, 46806, 19898, 40730,
                    51144, 50223, 12889, 20890, 13446, 59804, 4308, 59376, 58207, 11130, 19410,
                    3580, 51378, 21218, 5571, 22459, 43310, 51370, 47510, 4906, 38160, 185, 50073,
                    23563, 46787, 1134, 49942, 29705, 34854, 42239, 26463, 45191, 14758, 44872,
                    15758, 13509, 35241, 60869, 1180, 28884, 65034, 40406, 43540, 59859, 12472,
                    27235, 29732, 2850, 4677, 45797, 23491, 57561, 38559, 9150, 57394, 55174,
                    27405, 14792, 65063, 31178, 59833, 3992, 61436, 5507, 62030, 11270, 7891,
                    44528, 39536, 62181, 29705, 50009, 6318, 7008, 28140, 63195, 35116, 16219,
                    36277, 54583, 61926, 22439, 55119, 23900, 47365, 54634, 27477, 48718, 55945,
                    62353, 42684, 26179, 54934, 58362, 59848, 14301, 11550, 32290, 47877, 59428,
                    18842, 12660, 47022, 36199, 15279, 43073, 10706, 41013, 29076, 26146, 58099,
                    841, 34914, 55835, 47362, 32550, 9495, 5268, 62103, 54611, 30863, 2081, 29651,
                    41084, 1359, 48434, 64730, 54973, 50126, 2330, 9468, 49299, 16687, 43299,
                    36671, 50540, 64279, 33834, 8622, 33841, 10688, 37470, 42486, 13936, 47066,
                    32289, 36691, 23849, 39080, 62657, 2773, 31344, 42870, 15677, 30603, 37153,
                    42395, 15322, 63124, 48559, 7328, 20189, 58043, 8093, 58828, 51207, 2114,
                    36835, 13252, 3707, 39308, 25399, 53406, 13064, 39503, 42822, 13484, 38997,
                    63362, 59378, 54524, 5137, 64056, 47367, 39193, 16882, 32708, 18031, 46298,
                    853, 5439, 40214, 57048, 25090, 55664, 21207, 49603, 17699, 58781, 1924, 58961,
                    59483, 52953, 60307, 62525, 34479, 58494, 54391, 10794, 18956, 16365, 4443,
                    38307, 62346, 51856, 16471, 29440, 18772, 23814, 15911, 7070, 3814, 20349,
                    62982, 5907, 32825, 20539, 17303, 46730, 22652, 33165, 17845, 63772, 15107,
                    32494, 14987, 63697, 45621, 32698, 53224, 60643, 21055, 56974, 45361, 45284,
                    44643, 50551, 47011, 51060, 45721, 44041, 30835, 9881, 6391, 58187, 58994,
                    58604, 12222, 31423, 33364, 9211, 40136, 28115, 902, 64318, 36908, 47299,
                    27806, 65025, 56474, 22184, 1347, 15152, 58487, 22663, 48281, 50383, 27012,
                    60317, 10930, 58668, 25699, 65086, 63670, 37544, 13743, 29675, 9059, 59240,
                    60332, 42067, 45576, 10439, 24820, 33770, 53328, 17818, 51074, 1101, 10223,
                    17557, 33394, 14350, 21327, 535, 10266, 56608, 53721, 50965, 46452, 6628,
                    60343, 19453, 2031, 29074, 6841, 54516, 38480, 32486, 50226, 27771, 65047,
                    48750, 46925, 23550, 12936, 61725, 8960, 58747, 63394, 14362, 62625, 34672,
                    44488, 36369, 18002, 52446, 56401, 23489, 16458, 32346, 61390, 63897, 44782,
                    52399, 23980, 47161, 34397, 51454, 23096, 5915, 38087, 32330, 30759, 64907,
                    23291, 57274, 50361, 2438, 65103, 15611, 35113, 14452, 24767, 47741, 6771,
                    5464, 18028, 34414, 20216, 61370, 38822, 54651, 9997, 49885, 12194, 57514,
                    54941, 23964, 25211, 42202, 62513, 1482, 50034, 15373, 29366, 6518, 62828,
                    44943, 23540, 60872, 34821, 11471, 48374, 50550, 46184, 57887, 39127, 44717,
                    57530, 55050, 24207, 18865, 16812, 54363, 24025, 27634, 53075, 56798, 11209,
                    8542, 17612, 63460, 18319, 24223, 20119, 43846, 23677, 2043, 62607, 28177,
                    14729, 63173, 3573, 14973, 24655, 53232, 45305, 16004, 29849, 30363, 56088,
                    7304, 43785, 3745, 30406, 39539, 28636, 9826, 37167, 28079, 38691, 41687,
                    52727, 36603, 6532, 55972, 58854, 40001, 27012, 31467, 10885, 51968, 40634,
                    38334, 48923, 38917, 9345, 15379, 39211, 23137, 23680, 19685, 27357, 39568,
                    30352, 1221, 9847, 32890, 64371, 24432, 59292, 29796, 8865, 50896, 13383,
                    65165, 64813, 58863, 62256, 50694, 4005, 52913, 13044, 44650, 18022, 10963,
                    40399, 16733, 42523, 25865, 14058, 57112, 54382, 50123, 49378, 47060, 26100,
                    61428, 23399, 52180, 47432, 43529, 47807, 3548, 1649, 62506, 24732, 57335,
                    12939, 2445, 60052, 56214, 21944, 22678, 2333, 38485, 29216, 57769, 27778,
                    11103, 11657, 28153, 65248, 47062, 57037, 39819, 27645, 12723, 28614, 43831,
                    4879, 29063, 9191, 56588, 3524, 50473, 29823, 13413, 35968, 13411, 30390,
                    28453, 43423, 22630, 21359, 10937, 5891, 4024, 10313, 61875, 31116, 61714,
                    57223, 57066, 35134, 3306, 38544, 58431, 39002, 29273, 25657, 36366, 36201,
                    29920, 18817, 51234, 1743, 5610, 6535, 11243, 11750, 35869, 54518, 57026,
                    31084, 17954, 17018, 31061, 9010, 34366, 46449, 46626, 14605, 15340, 28281,
                    48176, 18299, 16830, 40421, 62857, 50759, 32586, 22972, 40189, 57097, 61732,
                    51089, 50555, 20246, 19972, 6857, 6066, 8899, 33451, 41181, 60518, 10812,
                    53543, 41959, 6898, 56889, 24460, 54529, 47261, 65479, 38784, 18860, 49388,
                    44832, 36788, 23391, 55467, 45585, 593, 25372, 52439, 39129, 38297, 11694,
                    42871, 52432, 37960, 5975, 24967, 6784, 22940, 13569, 15322, 30808, 41078,
                    21779, 55278, 56941, 57162, 37426, 49844, 20751, 65095, 553, 22041, 57433,
                    13702, 56756, 9738, 10730, 43825, 51206, 3846, 5067, 4530, 7474, 53004, 16880,
                    13976, 48440, 64924, 41769, 53831, 18007, 25740, 53501, 5765, 16481, 9370,
                    9215, 27715, 32600, 63059, 477, 56163, 6795, 36965, 59318, 61703, 36318, 28881,
                    52037, 62255, 56436, 3350, 35307, 60908, 56557, 9511, 20001, 31208, 22330,
                    15784, 29174, 51004, 29021, 49288, 30727, 14524, 40929, 61498, 6682, 60102,
                    40195, 42501, 40427, 35669, 3208, 12501, 5997, 38962, 63611, 54147, 30767,
                    50079, 10401, 48961, 57477, 7170, 49076, 42623, 62301, 62640, 906, 54476,
                    29802, 44727, 51111, 61797, 32882, 30971, 6591, 54332, 26948, 1339, 15681,
                    20937, 60583, 58110, 8648, 45273, 44179, 46977, 62778, 49195, 45342, 25689,
                    41104, 13364, 29007, 32860, 8492, 48825, 16478, 3958, 33220, 18983, 56898,
                    13293, 33388, 57384, 20773, 57702, 44664, 6798, 24610, 38836, 15132, 39434,
                    41898, 33155, 12551, 28531, 58476, 29132, 56174, 22516, 35582, 12646, 33909,
                    58087, 35818, 56124, 37228, 24483, 30578, 28958, 12868, 32882, 59585, 39454,
                    5929, 6920, 56966, 56742, 62425,
                ]),
                c: 147,
            },
            VarTestStruct {
                a: 25233,
                b: List::<u16, 1024>::from_iter([
                    47297, 16490, 46876, 14434, 59976, 18686, 52905, 35542, 53890, 62146, 7934,
                    42139, 27861, 6454, 12550, 56788, 34173, 60275, 52163, 43444, 31478, 10378,
                    39625, 46265, 46166, 49816, 31867, 16558, 25895, 2996, 55050, 24105, 17354,
                    47100, 46836, 11416, 32905, 40733, 12316, 5906, 22671, 12926, 61635, 45033,
                    20928, 29922, 49327, 25439, 18241, 2307, 64858, 36404, 63027, 54157, 30849,
                    7651, 28544, 27353, 50876, 55798, 7487, 29320, 14233, 50164, 35351, 25869,
                    7981, 57499, 62035, 55646, 24474, 65453, 3655, 42375, 63330, 39055, 31017, 840,
                    55732, 16969, 4853, 42838, 17024, 62107, 53038, 17328, 42412, 23061, 63323,
                    4196, 43417, 52117, 13454, 34855, 2009, 16955, 28149, 18381, 12658, 24321,
                    45656, 43998, 32456, 53105, 32548, 46839, 52041, 31061, 1809, 6065, 28847,
                    58331, 58188, 36887, 44225, 5122, 14080, 17057, 31036, 62287, 29583, 35836,
                    63282, 1474, 10386, 64844, 28127, 1719, 30772, 4014, 8815, 6298, 13413, 63307,
                    42025, 33081, 26099, 10021, 50075, 13997, 30351, 52470, 31694, 24331, 16702,
                    54619, 18707, 16071, 60574, 55181, 48416, 19776, 63349, 22894, 61573, 18314,
                    63100, 27827, 58132, 30545, 57340, 18305, 30266, 28865, 22379, 4022, 62071,
                    11734, 54899, 37941, 19254, 50153, 46645, 33839, 5023, 18917, 15599, 49432,
                    10423, 29690, 58396, 11326, 52348, 60105, 37951, 16837, 17482, 41954, 56376,
                    57039, 27662, 40843, 35098, 59637, 16114, 37994, 58016, 39165, 11107, 841,
                    56817, 41740, 31991, 17304, 34550, 55282, 61214, 2295, 64467, 20625, 23285,
                    33085, 15160, 32987, 26524, 16565, 28706, 61070, 62335, 11617, 62611, 55822,
                    8372, 45841, 18377, 8438, 52095, 19900, 36093, 31518, 47210, 1526, 47603,
                    32826, 39037, 12709, 37301, 59542, 65456, 65337, 10147, 21680, 28023, 56695,
                    12784, 46084, 32953, 328, 55871, 27257, 13978, 12214, 25991, 60306, 3121,
                    11520, 19360, 55903, 54509, 58395, 12310, 55498, 1448, 2624, 51507, 59785,
                    35092, 14688, 39810, 21056, 36088, 8398, 16828, 9132, 12606, 63082, 40854,
                    14528, 19130, 54996, 30388, 26490, 32371, 50064, 50662, 42283, 23909, 54985,
                    29822, 47740, 8322, 8262, 57203, 29546, 29668, 22812, 38039, 38031, 61257,
                    34499, 25237, 47820, 21886, 50805, 30225, 42457, 16584, 37790, 28103, 12211,
                    21345, 37100, 16492, 51591, 46750, 58467, 15613, 9071, 57201, 18426, 37422,
                    25951, 59194, 8582, 44849, 28287, 38117, 43390, 31852, 27521, 64594, 36274,
                    15559, 49432, 29181, 5730, 8395, 45237, 14886, 3215, 11421, 63038, 52614, 5042,
                    55608, 52450, 37806, 39645, 28224, 60154, 43119, 57382, 55658, 32623, 35363,
                    57794, 58361, 41783, 44388, 13143, 32030, 20203, 54281, 22157, 21472, 8736,
                    61490, 4025, 6012, 62445, 58407, 50014, 49277, 25469, 48941, 17471, 47128,
                    17066, 60189, 22970, 37698, 37864, 31339, 27600, 43300, 47458, 50985, 3122,
                    27897, 45397, 19383, 7347, 13520, 25565, 26745, 17977, 31869, 39374, 28124,
                    721, 18530, 342, 13051, 61923, 3855, 29524, 53902, 45108, 47878, 9159, 17734,
                    13466, 27446, 42308, 53489, 40346, 26062, 25719, 54361, 60254, 7861, 22122,
                    62538, 27201, 58681, 15638, 51115, 18291, 5672, 10203, 25051, 49872, 6928,
                    24773, 25500, 39825, 30848, 17685, 26323, 3032, 30173, 14457, 29642, 23807,
                    11328, 16277, 33100, 40931, 12873, 12227, 33581, 52984, 15066, 37054, 33862,
                    32543, 23127, 18356, 1858, 30829, 51568, 14495, 2640, 34734, 62460, 13191,
                    37284, 56382, 65385, 52698, 36788, 33235, 18878, 50262, 47475, 52151, 50523,
                    42583, 6818, 47993, 58869, 59933, 743, 5032, 39184, 53906, 2395, 449, 8013,
                    56728, 14566, 27334, 33037, 61939, 64455, 14861, 47446, 7011, 12345, 59934,
                    49485, 24984, 26723, 59873, 65392, 43725, 63231, 1484, 16297, 33744, 10662,
                    48257, 65058, 6545, 56068, 38160, 34417, 15743, 22765, 5873, 36812, 40808,
                    19041, 58234, 18120, 59080, 57057, 56989, 59172, 65367, 39304, 62737, 25324,
                    3813, 17398, 50801, 60904, 32965, 4548, 37439, 5998, 53473, 10326, 39159,
                    63603, 27590, 60297, 18437, 40221, 20300, 29959, 55452, 61767, 54906, 61447,
                    30334, 487, 6176, 12970, 26687, 2219, 46565, 55590, 37369, 61653, 17292, 15404,
                    28037, 34879, 59090, 58189, 37146, 39289, 32104, 59106, 36584, 43939, 56637,
                    13533, 44645, 57578, 34027, 30793, 56916, 56858, 63385, 31733, 7768, 56488,
                    35521, 31179, 49861, 45155, 33577, 23244, 15418, 64584, 20739, 64411, 34059,
                    3155, 20341, 44392, 57595, 2238, 52319, 11167, 44065, 7739, 33438, 62651,
                    58152, 12637, 10162, 38016, 55444, 35498, 1776, 53995, 55151, 9860, 50828,
                    39846, 32519, 15039, 22242, 1408, 58097, 42437, 57798, 47613, 10416, 21839,
                    49283, 12474, 5553, 3063, 37432, 26476, 28180, 56248, 40458, 8372, 19692, 1740,
                    27670, 40456, 8994, 8527, 48204, 7690, 40755, 9323, 37950, 253, 5965, 40263,
                    58589, 17811, 12853, 21386, 26749, 26033, 36007, 48257, 14967, 47304, 62240,
                    40866, 63732, 43018, 41995, 32104, 13974, 51311, 9851, 11777, 39867, 52546,
                    19088, 20015, 16594, 49254, 62473, 29279, 41694, 38257, 39659, 65145, 5949,
                    23520, 11822, 20655, 55952, 20228, 41403, 32749, 49884, 21642, 19935, 29242,
                    29710, 8515, 40312, 41324, 57890, 27224, 47955, 53368, 30090, 33816, 2239,
                    27409, 3065, 18242, 48535, 56868, 12100, 571, 3639, 59905, 48489, 55401, 49187,
                    2302, 914, 48951, 64645, 58366, 37841, 48833, 28712, 26433, 51940, 37757,
                    18044, 21658, 54295, 24766, 19918, 1934, 41025, 17130, 12387, 63846, 54711,
                    30267, 40658, 3645, 18071, 55870, 2075, 37734, 1889, 58908, 37826, 2301, 7373,
                    6256, 29956, 39147, 48746, 7523, 3918, 21983, 56639, 41908, 46343, 24019,
                    43717, 45597, 54500, 45369, 64794, 51619, 27342, 57138, 14104, 64745, 32442,
                    60083, 39249, 28754, 43156, 15038, 47370, 24344, 31286, 49708, 31360, 10422,
                    41394, 12117, 57430, 56285, 41688, 19010, 35437, 18918, 59151, 27131, 49205,
                    26134, 58797, 2844, 22194, 52590, 42833, 39403, 35383, 38013, 17522, 42441,
                    32007, 33073, 41469, 6351, 42379, 61175, 43042, 59429, 31180, 47950, 15901,
                    40015, 41723, 56784, 53325, 38700, 23600, 34006, 35203, 27692, 61588, 55278,
                    17482, 47141, 56412, 36071, 57706, 60945, 33647, 7738, 38128, 58432, 12463,
                    42864, 3738, 12734, 52176, 26068, 32193, 38078, 49841, 25355, 28916, 65516,
                    40322, 52189, 33877, 7886, 49477, 49593, 57477, 11904, 33951, 43112, 21849,
                    8963, 20985, 34414, 25506, 59206, 61670, 49924, 43620, 14109, 59834, 36437,
                    1357, 44938, 58300, 53424, 51048, 7622, 7207, 62071, 16084, 29282, 26143,
                    47976, 57684, 63378, 38521, 7145, 63359, 14438, 44028, 24900, 33799, 54049,
                    1058, 9573, 34224, 48175, 16842, 26172, 12160, 33149, 24383, 25754, 29135,
                    25261, 44387, 601, 9649, 44749, 47256, 33629, 36804, 45071, 20925, 7179, 2961,
                    34170, 20691, 21828, 57792, 50851, 33553, 12051, 3437, 63853, 33510, 51536,
                    812, 56029, 19496, 53784, 10945, 54152, 46354, 16822, 11521, 25521, 57291,
                    44074, 56589, 7696, 47238, 38422, 128, 30555, 34576, 45760, 23625, 14201,
                    59861, 45825, 32478, 19431, 36634, 13304, 63936, 54325, 15159, 43583, 33923,
                    23346, 15538, 39697, 23928, 27618, 35253, 17802, 18782, 1885, 6766, 39663,
                    8960, 44945, 54220, 12113, 39765, 21884, 24868, 13089, 11077, 10643, 44397,
                    4769, 37780, 16483, 4825, 26581, 62372, 12716, 37193, 8446, 64329, 57747,
                    53148, 15916, 17895, 57125, 47188, 64611, 13150, 48768, 17788, 51180, 63494,
                    19391, 4062, 11525, 64498, 16275, 38102, 11672, 51183, 49513, 65084, 37895,
                    26572,
                ]),
                c: 0,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data("ssz_rs/tests/data/containers/valid/ComplexTestStruct_lengthy_chaos_2/serialized.ssz_snappy");
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("b4e8f7ebdf3579a50da0cbf6eb889fafa7daef0efffb0fc165d76d88dff40bf4");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_max_1() {
    let value = ComplexTestStruct {
        a: 65535,
        b: List::<u16, 128>::from_iter([
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535,
        ]),
        c: 255,
        d: List::<u8, 256>::from_iter([255]),
        e: VarTestStruct {
            a: 65535,
            b: List::<u16, 1024>::from_iter([
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            ]),
            c: 255,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 65535,
                b: List::<u16, 1024>::from_iter([
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535,
                ]),
                c: 255,
            },
            VarTestStruct {
                a: 65535,
                b: List::<u16, 1024>::from_iter([
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535,
                ]),
                c: 255,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_max_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("822b36c8a4513b7c9c81f8100a99b1ca977fc64a180154af81c27af6ce6da5a8");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_zero() {
    let value = FixedTestStruct { a: 0, b: 0, c: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_zero/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("db56114e00fdd4c1f85c892bf35ac9a89289aaecb1ebd0a96cde606a748b5d71");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_random_chaos_0() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([]),
        b: Bitvector::<2>::from_iter([true, false]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([false, true, false]),
        e: Bitvector::<8>::from_iter([true, true, true, false, true, false, true, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_random_chaos_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("38c9859e2c0584a1802aa9b25ec33db9dae9df50169d68d948b589d8eb01f7aa");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_max_7() {
    let value = SingleFieldTestStruct { a: 255 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_max_7/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("ff00000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_zero_4() {
    let value = ComplexTestStruct {
        a: 0,
        b: List::<u16, 128>::from_iter([
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0,
        ]),
        c: 0,
        d: List::<u8, 256>::from_iter([0]),
        e: VarTestStruct {
            a: 0,
            b: List::<u16, 1024>::from_iter([
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            ]),
            c: 0,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 0,
                b: List::<u16, 1024>::from_iter([
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                ]),
                c: 0,
            },
            VarTestStruct {
                a: 0,
                b: List::<u16, 1024>::from_iter([
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                ]),
                c: 0,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_zero_4/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("8021f013769eba11681a8dcf7458660e19c30efe1b95bf0ad1d047a80a51bcc5");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_zero_5() {
    let value = SingleFieldTestStruct { a: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_zero_5/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("0000000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_random_3() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([true, false, true]),
        b: Bitvector::<2>::from_iter([false, true]),
        c: Bitvector::<1>::from_iter([false]),
        d: Bitlist::<6>::from_iter([true, false]),
        e: Bitvector::<8>::from_iter([true, true, true, false, false, false, false, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_random_3/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("00bebd4ee633b4af3e0247fbba72ff80727cd84e5999374dabf8ba04740114aa");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_one_chaos_2() {
    let value = ComplexTestStruct {
        a: 30483,
        b: List::<u16, 128>::from_iter([9712]),
        c: 0,
        d: List::<u8, 256>::from_iter([70]),
        e: VarTestStruct {
            a: 50066,
            b: List::<u16, 1024>::from_iter([3290]),
            c: 58,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 139,
                b: 7928507530719916828,
                c: 4282303815,
            },
            FixedTestStruct {
                a: 51,
                b: 4745801933491683654,
                c: 1707679012,
            },
            FixedTestStruct {
                a: 162,
                b: 9136612036359568408,
                c: 168035181,
            },
            FixedTestStruct {
                a: 135,
                b: 15428331690937311254,
                c: 3775273129,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 31574,
                b: List::<u16, 1024>::from_iter([50627]),
                c: 188,
            },
            VarTestStruct {
                a: 38077,
                b: List::<u16, 1024>::from_iter([18972]),
                c: 184,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_one_chaos_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("887aeaa4092a72ed26e711b4e2147f1c1ee3de66f61641981c17326727824d53");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_max_0() {
    let value = SingleFieldTestStruct { a: 255 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_max_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("ff00000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_random_4() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([false, true]),
        b: Bitvector::<2>::from_iter([false, true]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([true, true]),
        e: Bitvector::<8>::from_iter([false, false, true, false, false, true, true, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_random_4/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("a72542f6f22787da3a00dc428c75c8dd6a75dab48cc8fb663f65594e7947e63a");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_zero_2() {
    let value = SingleFieldTestStruct { a: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_zero_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("0000000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_max_chaos_1() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([true, true]),
        b: Bitvector::<2>::from_iter([true, true]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([true, true, true, true, true]),
        e: Bitvector::<8>::from_iter([true, true, true, true, true, true, true, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_max_chaos_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("d14588c56f40c8ec3eae3b9a658aab2baac9cc08c418d609737dc6137b90045b");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_zero_3() {
    let value = ComplexTestStruct {
        a: 0,
        b: List::<u16, 128>::from_iter([
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        ]),
        c: 0,
        d: List::<u8, 256>::from_iter([0]),
        e: VarTestStruct {
            a: 0,
            b: List::<u16, 1024>::from_iter([
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0,
            ]),
            c: 0,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 0,
                b: List::<u16, 1024>::from_iter([
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                ]),
                c: 0,
            },
            VarTestStruct {
                a: 0,
                b: List::<u16, 1024>::from_iter([
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                ]),
                c: 0,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_zero_3/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("10d835c8af095afc274d2a76ce98ebeb857396a8f68cbf524d14d3521076c3f8");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_zero_chaos_0() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([false, false, false, false]),
        b: Bitvector::<2>::from_iter([false, false]),
        c: Bitvector::<1>::from_iter([false]),
        d: Bitlist::<6>::from_iter([false]),
        e: Bitvector::<8>::from_iter([false, false, false, false, false, false, false, false]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_zero_chaos_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("27b61f43e35013d439d4d131de8ad79811792cf58724d87ae45f1f3d1f74bacd");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_max_9() {
    let value = SingleFieldTestStruct { a: 255 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_max_9/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("ff00000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_max_6() {
    let value = FixedTestStruct {
        a: 255,
        b: 18446744073709551615,
        c: 4294967295,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_max_6/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("3925681862db7892428eac4afae08671930e623601b5b85fbbc366371e29acd7");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_max_1() {
    let value = FixedTestStruct {
        a: 255,
        b: 18446744073709551615,
        c: 4294967295,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_max_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("3925681862db7892428eac4afae08671930e623601b5b85fbbc366371e29acd7");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_small_test_struct_zero_chaos_2() {
    let value = SmallTestStruct { a: 0, b: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SmallTestStruct_zero_chaos_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SmallTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("f5a5fd42d16a20302798ef6ed309979b43003d2320d9f0e8ea9831a92759fb4b");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_max_8() {
    let value = FixedTestStruct {
        a: 255,
        b: 18446744073709551615,
        c: 4294967295,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_max_8/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("3925681862db7892428eac4afae08671930e623601b5b85fbbc366371e29acd7");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_nil_1() {
    let value = ComplexTestStruct {
        a: 52446,
        b: List::<u16, 128>::from_iter([]),
        c: 216,
        d: List::<u8, 256>::from_iter([]),
        e: VarTestStruct {
            a: 9582,
            b: List::<u16, 1024>::from_iter([]),
            c: 179,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 113,
                b: 8308260144033443154,
                c: 856314353,
            },
            FixedTestStruct {
                a: 88,
                b: 18286529193086391033,
                c: 3373857601,
            },
            FixedTestStruct {
                a: 10,
                b: 866825965816182963,
                c: 3877443397,
            },
            FixedTestStruct {
                a: 73,
                b: 16810218414276843777,
                c: 184057769,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 56619,
                b: List::<u16, 1024>::from_iter([]),
                c: 32,
            },
            VarTestStruct {
                a: 28432,
                b: List::<u16, 1024>::from_iter([]),
                c: 148,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_nil_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("3ad080351afcde8c45956a9dbba68db5b7bd737f5be21f6b07833356b3b77ac5");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_nil_chaos_2() {
    let value = ComplexTestStruct {
        a: 43567,
        b: List::<u16, 128>::from_iter([]),
        c: 74,
        d: List::<u8, 256>::from_iter([]),
        e: VarTestStruct {
            a: 3088,
            b: List::<u16, 1024>::from_iter([]),
            c: 230,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 80,
                b: 12261896720768000582,
                c: 1113008435,
            },
            FixedTestStruct {
                a: 167,
                b: 13074400124343650680,
                c: 250375806,
            },
            FixedTestStruct {
                a: 106,
                b: 9461353936973742711,
                c: 613200224,
            },
            FixedTestStruct {
                a: 114,
                b: 15818203515089967829,
                c: 143907859,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 61793,
                b: List::<u16, 1024>::from_iter([]),
                c: 214,
            },
            VarTestStruct {
                a: 56893,
                b: List::<u16, 1024>::from_iter([]),
                c: 6,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_nil_chaos_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("643a44a63abc2b0c12c5db0dd5376fe5a6681e1336d0c0bf99a945d4aa9774e7");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_small_test_struct_zero_9() {
    let value = SmallTestStruct { a: 0, b: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SmallTestStruct_zero_9/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SmallTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("f5a5fd42d16a20302798ef6ed309979b43003d2320d9f0e8ea9831a92759fb4b");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_nil_6() {
    let value = ComplexTestStruct {
        a: 14779,
        b: List::<u16, 128>::from_iter([]),
        c: 128,
        d: List::<u8, 256>::from_iter([]),
        e: VarTestStruct {
            a: 11314,
            b: List::<u16, 1024>::from_iter([]),
            c: 88,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 69,
                b: 2289519359095941959,
                c: 4055974165,
            },
            FixedTestStruct {
                a: 207,
                b: 9671730801211586811,
                c: 3033394329,
            },
            FixedTestStruct {
                a: 210,
                b: 15954635843475561660,
                c: 3723422315,
            },
            FixedTestStruct {
                a: 121,
                b: 12464746318130489510,
                c: 2445696058,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 57485,
                b: List::<u16, 1024>::from_iter([]),
                c: 228,
            },
            VarTestStruct {
                a: 15604,
                b: List::<u16, 1024>::from_iter([]),
                c: 201,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_nil_6/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("ff282ed32a48f3c3cab8f5e90c41f31e3b765f98d841adf99f26b0afb1599c66");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_small_test_struct_zero_0() {
    let value = SmallTestStruct { a: 0, b: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SmallTestStruct_zero_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SmallTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("f5a5fd42d16a20302798ef6ed309979b43003d2320d9f0e8ea9831a92759fb4b");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_nil_8() {
    let value = ComplexTestStruct {
        a: 9736,
        b: List::<u16, 128>::from_iter([]),
        c: 129,
        d: List::<u8, 256>::from_iter([]),
        e: VarTestStruct {
            a: 52567,
            b: List::<u16, 1024>::from_iter([]),
            c: 0,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 155,
                b: 8632484518626447911,
                c: 4093634018,
            },
            FixedTestStruct {
                a: 229,
                b: 17748644962945795383,
                c: 2079529187,
            },
            FixedTestStruct {
                a: 210,
                b: 3312027085582884946,
                c: 3589310165,
            },
            FixedTestStruct {
                a: 99,
                b: 9084020690761810545,
                c: 2773076247,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 65501,
                b: List::<u16, 1024>::from_iter([]),
                c: 183,
            },
            VarTestStruct {
                a: 13237,
                b: List::<u16, 1024>::from_iter([]),
                c: 155,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_nil_8/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("6660bf5b0be775c00b5a3a0bbeb90d8f110adb2bd54e7a1779a1230398b27f69");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_small_test_struct_zero_7() {
    let value = SmallTestStruct { a: 0, b: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SmallTestStruct_zero_7/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SmallTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("f5a5fd42d16a20302798ef6ed309979b43003d2320d9f0e8ea9831a92759fb4b");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_random_chaos_2() {
    let value = FixedTestStruct {
        a: 30,
        b: 6156748712181862619,
        c: 562352362,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_random_chaos_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("5fddaefef3945fe9d1efe6d5f33d593db1cac4dc5e0edff46092b80ae564f713");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_max_9() {
    let value = FixedTestStruct {
        a: 255,
        b: 18446744073709551615,
        c: 4294967295,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_max_9/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("3925681862db7892428eac4afae08671930e623601b5b85fbbc366371e29acd7");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_max_0() {
    let value = FixedTestStruct {
        a: 255,
        b: 18446744073709551615,
        c: 4294967295,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_max_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("3925681862db7892428eac4afae08671930e623601b5b85fbbc366371e29acd7");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_max_7() {
    let value = FixedTestStruct {
        a: 255,
        b: 18446744073709551615,
        c: 4294967295,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_max_7/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("3925681862db7892428eac4afae08671930e623601b5b85fbbc366371e29acd7");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_random_chaos_2() {
    let value = SingleFieldTestStruct { a: 177 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data("ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_random_chaos_2/serialized.ssz_snappy");
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("b100000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_max() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([true, true, true, true, true]),
        b: Bitvector::<2>::from_iter([true, true]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([true, true, true]),
        e: Bitvector::<8>::from_iter([true, true, true, true, true, true, true, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_max/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("696fb0974bbb2eb3a5d4a7613f2c3cabf81d28a8e51005e7fcab962da7ebca2b");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_nil_9() {
    let value = ComplexTestStruct {
        a: 23577,
        b: List::<u16, 128>::from_iter([]),
        c: 175,
        d: List::<u8, 256>::from_iter([]),
        e: VarTestStruct {
            a: 52190,
            b: List::<u16, 1024>::from_iter([]),
            c: 120,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 179,
                b: 14068119846896464581,
                c: 1617655325,
            },
            FixedTestStruct {
                a: 205,
                b: 9540752016240576228,
                c: 779151254,
            },
            FixedTestStruct {
                a: 62,
                b: 57390556918623452,
                c: 3205281123,
            },
            FixedTestStruct {
                a: 209,
                b: 2652996980740976958,
                c: 1890472584,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 18553,
                b: List::<u16, 1024>::from_iter([]),
                c: 151,
            },
            VarTestStruct {
                a: 61674,
                b: List::<u16, 1024>::from_iter([]),
                c: 65,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_nil_9/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("cc17028327728aac7c2760530199432a97ee4812bdd76faefb4b11bac84e981a");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_small_test_struct_zero_6() {
    let value = SmallTestStruct { a: 0, b: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SmallTestStruct_zero_6/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SmallTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("f5a5fd42d16a20302798ef6ed309979b43003d2320d9f0e8ea9831a92759fb4b");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_small_test_struct_zero_1() {
    let value = SmallTestStruct { a: 0, b: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SmallTestStruct_zero_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SmallTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("f5a5fd42d16a20302798ef6ed309979b43003d2320d9f0e8ea9831a92759fb4b");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_max_chaos_2() {
    let value = VarTestStruct {
        a: 65535,
        b: List::<u16, 1024>::from_iter([
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
        ]),
        c: 255,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_max_chaos_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("e9aabd6fc8bc59fcbe5d369d36a5a7f4e4da30372c2ee0a79042c68b64306e2c");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_small_test_struct_zero_8() {
    let value = SmallTestStruct { a: 0, b: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SmallTestStruct_zero_8/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SmallTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("f5a5fd42d16a20302798ef6ed309979b43003d2320d9f0e8ea9831a92759fb4b");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_nil_7() {
    let value = ComplexTestStruct {
        a: 50885,
        b: List::<u16, 128>::from_iter([]),
        c: 128,
        d: List::<u8, 256>::from_iter([]),
        e: VarTestStruct {
            a: 48844,
            b: List::<u16, 1024>::from_iter([]),
            c: 156,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 111,
                b: 9308979922821387243,
                c: 1304134955,
            },
            FixedTestStruct {
                a: 39,
                b: 16163096394648852761,
                c: 2955079535,
            },
            FixedTestStruct {
                a: 220,
                b: 13508351431752869162,
                c: 2371579308,
            },
            FixedTestStruct {
                a: 69,
                b: 4382219926106737506,
                c: 1420285418,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 25187,
                b: List::<u16, 1024>::from_iter([]),
                c: 165,
            },
            VarTestStruct {
                a: 33983,
                b: List::<u16, 1024>::from_iter([]),
                c: 251,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_nil_7/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("354ebad67ef3b789f06d89b0ecea632024ca91d353f1e847e83111060f9b6523");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_nil_0() {
    let value = ComplexTestStruct {
        a: 18142,
        b: List::<u16, 128>::from_iter([]),
        c: 231,
        d: List::<u8, 256>::from_iter([]),
        e: VarTestStruct {
            a: 61305,
            b: List::<u16, 1024>::from_iter([]),
            c: 147,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 141,
                b: 10953418948196676936,
                c: 1290597142,
            },
            FixedTestStruct {
                a: 218,
                b: 10485599593819308885,
                c: 2568442688,
            },
            FixedTestStruct {
                a: 148,
                b: 7829464349203048716,
                c: 2940052654,
            },
            FixedTestStruct {
                a: 130,
                b: 12125340572984727979,
                c: 2441735511,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 59231,
                b: List::<u16, 1024>::from_iter([]),
                c: 103,
            },
            VarTestStruct {
                a: 5969,
                b: List::<u16, 1024>::from_iter([]),
                c: 211,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_nil_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("27375ceba8646507e7195acd6a9b584af05e32ac9939ef29df75faa8e1fb7198");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_small_test_struct_max_0() {
    let value = SmallTestStruct { a: 65535, b: 65535 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SmallTestStruct_max_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SmallTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("5ee8ff3d8661977c818a2d7f926019872cfef9cf4270b99ff833160f41fc01ec");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_zero_5() {
    let value = VarTestStruct {
        a: 0,
        b: List::<u16, 1024>::from_iter([
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        ]),
        c: 0,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_zero_5/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("4929401717bbb72c80a54a7d31d9fe75e36091585a2c188fa9f4a278cd28f504");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_zero_5() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([false]),
        b: Bitvector::<2>::from_iter([false, false]),
        c: Bitvector::<1>::from_iter([false]),
        d: Bitlist::<6>::from_iter([false, false, false, false]),
        e: Bitvector::<8>::from_iter([false, false, false, false, false, false, false, false]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_zero_5/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("a0ed0ec4a187f5f5a40bee9c8680cf42cf0a4c7631957639772eff3628d913f3");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_lengthy_9() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([true, false, true, false, true]),
        b: Bitvector::<2>::from_iter([false, false]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([true, true, false, false, false, true]),
        e: Bitvector::<8>::from_iter([false, true, false, false, false, false, true, false]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_lengthy_9/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("0ab92b5d899d3e4c819f32bda870df0d777c2eed0a22eee40532a3feff7eb197");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_zero_2() {
    let value = VarTestStruct {
        a: 0,
        b: List::<u16, 1024>::from_iter([0, 0, 0]),
        c: 0,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_zero_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("24635e0d491ca51baf0883d3e8b61f7684db971a9608fd4fb5b51a97257f976d");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_small_test_struct_max_7() {
    let value = SmallTestStruct { a: 65535, b: 65535 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SmallTestStruct_max_7/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SmallTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("5ee8ff3d8661977c818a2d7f926019872cfef9cf4270b99ff833160f41fc01ec");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_zero_2() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([false, false, false, false]),
        b: Bitvector::<2>::from_iter([false, false]),
        c: Bitvector::<1>::from_iter([false]),
        d: Bitlist::<6>::from_iter([false, false]),
        e: Bitvector::<8>::from_iter([false, false, false, false, false, false, false, false]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_zero_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("7aa68d25017352ef95142af2bb269ce805269676da6111d74887aa9cdcb072a4");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_random_9() {
    let value = VarTestStruct {
        a: 36289,
        b: List::<u16, 1024>::from_iter([
            15770, 34869, 26310, 3628, 24227, 36802, 9331, 13524, 8151, 1295, 18640, 24073, 3542,
            47222, 15379, 49690, 31549, 2507, 53458, 64468, 25758, 49504, 64229, 3740, 39967,
            28550, 3550, 6921, 65195, 54891, 28559, 41353, 13795, 52666, 64543, 30565, 45021, 7635,
            13316, 55848, 35206, 41794, 41064, 28906, 53686, 15265, 46524, 24718, 53773, 42436,
            53160, 52479, 56223, 8179, 59380, 52392, 54755, 19878, 14302, 53916, 31155, 26664,
            48267, 9328, 27011, 8710, 46885, 5051, 17694, 30649, 53056, 655, 25365, 6594, 573,
            51459, 35850, 47644, 64232, 62783, 54844,
        ]),
        c: 17,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_random_9/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("496d0493780bb91c6ced1e11510a1e2c494ac1eb16e3bf293dfdadaf834958c7");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_random_0() {
    let value = VarTestStruct {
        a: 9142,
        b: List::<u16, 1024>::from_iter([
            22416, 223, 7972, 11484, 19434, 28447, 5231, 56724, 51306, 42521, 27147, 49964, 36706,
            39915, 55317, 41805, 19846, 12172, 34120, 36440, 53773, 52437, 36273, 14907, 49197,
            35943, 28034, 38986, 52211, 6881, 45813, 57744, 30473, 64290, 21668, 49878, 40359, 320,
            9611, 62941, 51772, 39114, 56218, 62860, 24324, 52495, 62647, 20603, 36865, 48434,
            45414, 27009, 22148, 59954, 62184, 3708, 61327, 13593, 3527, 48055, 62366, 8544, 18352,
            43486, 45729, 37965, 39140, 43330, 38506, 25502, 36573, 9500, 26738, 44516, 43808,
            42082, 60034, 35062, 11135, 15678, 32145, 33705, 48742, 17967, 3719, 51713, 4896, 5776,
            27355, 20291, 41026, 46586, 56958, 9043, 39998, 34265, 63644, 28783, 45579, 10862,
            2379, 43396, 30094, 21303, 62649, 65459, 18342, 8943, 19075, 31887, 21528, 51531,
            42795, 16898, 58502, 5359, 48719, 9003, 48379, 53529, 5849, 9293, 41177, 29874, 25977,
            45375, 49779, 64590, 6874, 3911, 58730, 10509, 38425, 55888, 44604, 19384, 63720,
            31723, 3906, 46741, 48681, 54395, 22813, 9786, 2334, 27822, 25749, 18540, 17367, 33387,
            6489, 61347, 47389, 48731, 37802, 51990, 53503, 48217, 30693, 37390, 1146, 40992,
            34865, 15790, 4640, 28647, 48418, 24104, 42236, 38394, 47560, 35769, 23109, 59882,
            22177, 423, 53557, 31329, 25129, 58161, 35835, 22838, 46381, 53662, 63722, 63059,
            62940, 58363, 48893, 13445, 52629, 16651, 13906, 61519, 63976, 12682, 17280, 33541,
            31322, 9288, 43949, 51404, 38481, 46527, 53147, 24686, 61987, 61038, 41883, 57878,
            14142, 60712, 11255, 9968, 25881, 23043, 44026, 22629, 49513, 35585, 26161, 34678,
            3851, 20729, 41423, 13074, 5930, 7299, 34124, 55573, 42360, 44558, 40360, 56850, 21792,
            49250, 51715, 1160, 37892, 37185, 41500, 32616, 20458, 25467, 59368, 58330, 54723,
            44092, 35226, 57025, 51351, 34034, 64690, 41306, 32465, 37513, 20683, 21484, 53850,
            20660, 4514, 30481, 46379, 27036, 56373, 58231, 3172, 53001, 9068, 8268, 9281, 32033,
            49955, 63629, 49768, 31128, 39678, 42896, 59238, 8420, 39680, 3423, 23669, 18717,
            19250, 49210, 56133, 23208, 17950, 39502, 12292, 64027, 44021, 17505, 34999, 56486,
            61866, 36539, 41349, 21955, 8641, 57572, 30183, 57983, 32735, 8757, 34950, 20469,
            35938, 18988, 51651, 28556, 26356, 19159, 27794, 44907, 54154, 242, 45388, 25075,
            29313, 2174, 2314, 47601, 57706, 30986, 1451, 54310, 55358, 65115, 55275, 43470, 32677,
            63547, 40039, 61454, 2236, 2646, 38283, 16176, 59286, 32096, 51802, 54940, 27443, 5518,
            56533, 51332, 14617, 54082, 23329, 22820, 9483, 48295, 22353, 30089, 8292, 49798, 4329,
            16647, 35158, 3770, 45230, 7856, 36001, 2317, 5922, 53944, 63075, 3987, 37793, 23932,
            30238, 64222, 8098, 38614, 31902, 58410, 60158, 22946, 34517, 21133, 54713, 40857,
            1249, 38290, 42738, 26882, 24319, 4260, 40285, 65497, 2365, 55677, 21290, 56983, 44440,
            37594, 12326, 10481, 54917, 43962, 4982, 53518, 57962, 23944, 53195, 13978, 43412,
            24919, 13137, 51956, 11767, 41673, 16436, 9498, 43299, 63167, 34351, 10006, 8354,
            59068, 1377, 46262, 4763, 28350, 14144, 58447, 23475, 5438, 34975, 52436, 40688, 4232,
            44224, 44922, 27855, 11518, 31954, 12900, 39291, 2204, 8952, 11027, 3659, 39007, 45278,
            56515, 2365, 51232, 59731, 11478, 28586, 10316, 45669, 43867, 46239, 50889, 46538,
            12456, 4094, 16941, 17517, 59135, 46966, 16505, 12639, 8089, 34897, 20779, 4142, 44528,
            64715, 10776, 57067, 47195, 2350, 55112, 41270, 25163, 21751, 30049, 55494, 22443,
            56693, 65477, 18304, 49722, 62399, 50538, 40000, 36289, 34045, 18731, 46894, 17228,
            34239, 40826, 32621, 38704, 21978, 20313, 59697, 7675, 34261, 54989, 48326, 6525,
            45585, 1149, 4908, 25857, 40177, 24839, 62376, 50834, 36995, 41448, 50390, 54481,
            35759, 58404, 7367, 43845, 33680, 25556, 41328, 12424, 52819, 47853, 47789, 55978,
            38859, 50960, 53553, 36937, 33677, 22217, 59545, 47048, 26333, 23995, 8154, 49423,
            59537, 17383, 31070, 49224, 39907, 48761, 53876, 33303, 29275, 42796, 57934, 41127,
            16235, 21731, 32887, 23106, 53006, 58920, 34131, 36269, 59068, 11913, 21507, 59728,
            64259, 6271, 7602, 39449, 27773, 49674, 17386, 53896, 9330, 24816, 20014, 37952, 48875,
            38206, 23681, 57114, 61553, 6859, 31683, 62582, 51244, 12580, 20831, 7093, 15057,
            12773, 19211, 16994, 16260, 61759, 48546, 13804, 2755, 10654, 27001, 17678, 41104,
            49638, 33604, 55547, 38612, 47139, 58864, 30198, 8363, 41113, 6293, 26879, 39412,
            52639, 49144, 64727, 39990, 33655, 21796, 24259, 41590, 2733, 5172, 44938, 43068,
            47316, 59594, 16123, 57322, 10619, 38642, 54714, 13858, 42426, 17878, 51553, 35176,
            63160, 5617, 49361, 878, 53276, 3591, 29091, 8321, 8286, 48804, 47701, 64141, 5356,
            7849, 31, 2535, 28852, 15777, 50447, 36423, 30409, 33434, 39079, 8277, 9918,
        ]),
        c: 149,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_random_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("3c833af82f46636a42cfa718c0e9b287f4e26fa14c0f32a1a7674eaf10347707");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_lengthy_0() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([false, true, true, true, true]),
        b: Bitvector::<2>::from_iter([false, true]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([true, false, true, false, true, true]),
        e: Bitvector::<8>::from_iter([true, false, true, true, true, false, false, false]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_lengthy_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("39bb190acc9f76e94c785e87e6d20235be64a0d8913fad03cabcf7ec6929e005");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_random_7() {
    let value = VarTestStruct {
        a: 15141,
        b: List::<u16, 1024>::from_iter([
            11492, 62534, 29650, 54155, 42383, 41747, 4722, 64781, 28665, 7575, 43451, 64198,
            60649, 65080, 30481, 20350, 555, 54139, 29652, 32621, 2068, 50399, 35141, 35336, 60963,
            54790, 42991, 63010, 25898, 36562, 22390, 61383, 737, 60181, 59369, 59664, 18944, 620,
            24499, 62519, 23843, 899, 61045, 25610, 40129, 53188, 15773, 16822, 59078, 35660,
            17975, 18177, 35999, 36333, 25068, 45479, 24058, 48489, 6432, 21581, 33765, 60791,
            30983, 43164, 63790, 14094, 52188, 38186, 36408, 32854, 24788, 50280, 43473, 14787,
            9431, 49509, 54204, 13158, 33909, 1723, 49512, 3998, 503, 47620, 8712, 21099, 13187,
            3886, 41368, 39291, 1167, 11778, 31776, 51077, 45297, 27096, 49776, 604, 25107, 31694,
            59670, 58098, 48640, 25738, 34494, 11456, 22335, 48893, 51124, 38865, 54749, 64901,
            2690, 58928, 10742, 5477, 23760, 36812, 27472, 27174, 42401, 55421, 10142, 11710,
            51903, 57988, 33169, 24510, 62967, 43560, 50759, 58756, 52983, 17425, 29663, 32043,
            11452, 9229, 1927, 57451, 1826, 42134, 46590, 57091, 52281, 58185, 25106, 58335, 41897,
            9009, 34924, 45915, 36396, 58361, 64873, 48476, 49651, 12566, 61137, 55462, 30150,
            14019, 4389, 28838, 8230, 44742, 3998, 16639, 60592, 52017, 24957, 39976, 10667, 50788,
            10386, 17062, 52717, 59242, 7305, 18157, 36353, 64471, 29693, 54452, 47924, 58033,
            55809, 20008, 4788, 10971, 5333, 3482, 50366, 24538, 5926, 33364, 20599, 22726, 16586,
            23058, 17253, 41719, 43348, 21710, 45644, 22138, 8726, 18278, 49545, 26174, 4856,
            18980, 52829, 61316, 54755, 52387, 547, 42381, 52940, 45486, 45221, 47272, 33976,
            55255, 64271, 45639, 34992, 20289, 32179, 60967, 4831, 24867, 30900, 51068, 51180,
            18895, 14927, 50714, 60369, 26178, 36562, 50371, 32112, 33435, 49200, 19207, 63908,
            4719, 23431, 42143, 31561, 52266, 63902, 43408, 20806, 29202, 43171, 2965, 37781,
            34174, 13194, 3809, 28446, 12793, 41574, 63759, 39184, 1511, 60581, 20365, 10171,
            56885, 62303, 62419, 1784, 42802, 47183, 32218, 60120, 12772, 32106, 52623, 45977,
            60956, 7417, 17576, 52239, 39073, 8323, 19153, 13998, 41076, 5947, 61408, 49315, 46038,
            261, 13569, 33734, 39354, 3214, 1415, 29150, 35761, 29100, 6532, 15563, 7411, 31732,
            10962, 2230, 24119, 54489, 41040, 20960, 32790, 11001, 37776, 14676, 41629, 34703,
            65470, 36146, 28409, 29239, 7533, 49880, 50145, 21576, 15064, 52685, 18777, 38920,
            39789, 18249, 35922, 5120, 17338, 45878, 16853, 45834, 33349, 15022, 12205, 51928,
            32362, 60661, 46068, 51503, 29739, 14495, 33225, 7330, 55026, 48141, 46474, 51413,
            6204, 60291, 56725, 13734, 54630, 49359, 15864, 18765, 53931, 33278, 61242, 52695,
            36214, 2238, 28984, 61680, 56467, 4126, 31773, 24428, 768, 3157, 28140, 43695, 36472,
            8674, 36615, 42024, 38150, 51941, 46819, 5331, 42260, 17174, 2717, 3694, 15186, 13635,
            45771, 41472, 40979, 26855, 45352, 35254, 7064, 15687, 17205, 57566, 2125, 56098,
            28480, 32707,
        ]),
        c: 227,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_random_7/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("fdec9924b0923e29f38cef674bb14550bb6ae3ad82afa514c8f0f9fd5b9f1501");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_nil_chaos_1() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([]),
        b: Bitvector::<2>::from_iter([true, true]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([]),
        e: Bitvector::<8>::from_iter([true, true, false, true, false, false, true, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_nil_chaos_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("b54cbc74cccfac2ac02868b7442271e3e0e98533c9a409529c183874e742f416");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_small_test_struct_max_9() {
    let value = SmallTestStruct { a: 65535, b: 65535 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SmallTestStruct_max_9/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SmallTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("5ee8ff3d8661977c818a2d7f926019872cfef9cf4270b99ff833160f41fc01ec");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_lengthy_7() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([true, false, false, true, true]),
        b: Bitvector::<2>::from_iter([true, true]),
        c: Bitvector::<1>::from_iter([false]),
        d: Bitlist::<6>::from_iter([false, true, true, true, false, true]),
        e: Bitvector::<8>::from_iter([false, false, false, true, true, false, true, false]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_lengthy_7/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("e7156a8ddcb2f1c71a736c1fa3e5e429bd70dac43c624261774a506fd0bf9091");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_nil_2() {
    let value = VarTestStruct {
        a: 54253,
        b: List::<u16, 1024>::from_iter([]),
        c: 113,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_nil_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("393695f7c96d59344d2c9ac1877e32143abf12828b1cf629876140699d66b84f");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_random_9() {
    let value = ComplexTestStruct {
        a: 11787,
        b: List::<u16, 128>::from_iter([
            8531, 23602, 46945, 14476, 64645, 50631, 21162, 24632, 45653, 45856, 24236, 2463,
        ]),
        c: 255,
        d: List::<u8, 256>::from_iter([
            12, 10, 211, 92, 54, 219, 98, 127, 115, 201, 120, 168, 193, 48, 16, 117, 97, 182, 170,
            209, 95, 96, 24, 123, 140, 84, 62, 197, 247, 79, 150, 209, 41, 38, 101, 170, 232, 99,
            254, 141, 0, 123, 233, 167, 194, 199, 151, 12, 251, 148, 116, 165, 205, 133, 57, 10,
            26, 87, 227, 51, 158, 142, 187, 47, 159, 231, 231, 40, 197, 103, 3, 18, 117, 200, 205,
            109, 93, 76, 37, 46, 116, 133, 159, 101, 128, 70, 147, 191, 206, 6, 161, 92, 67, 187,
            52, 132, 240, 37, 33, 100, 86, 154, 13, 228, 243, 222, 215, 35, 139, 107, 179, 163, 46,
            252, 90, 239, 68, 39, 141, 244, 226, 203, 209, 32, 68, 166, 10, 197, 251, 119, 209, 60,
            32, 27, 95, 173, 68, 141, 210, 136, 167, 187, 174, 246, 12, 6, 124, 103, 217, 135, 19,
            189, 216, 27, 128, 124, 151, 231, 186, 171, 191, 105, 224, 18, 3, 214, 240, 195, 55,
            222, 8, 167, 136, 138, 184, 20, 69, 96, 71, 195, 218, 206, 71, 49, 17, 216, 62, 183,
            245, 76, 27, 221, 5, 188,
        ]),
        e: VarTestStruct {
            a: 52907,
            b: List::<u16, 1024>::from_iter([
                37099, 31817, 10319, 35717, 54398, 56813, 58033, 39357, 26917, 38775, 10885, 34282,
                26328, 45783, 28493, 27345, 56865, 48149, 57156, 60669, 22262, 33108, 35756, 44313,
                25626, 13033, 13296, 56332, 27214, 50796, 18143, 61919, 19611, 49665, 54790, 17370,
                42341, 57736, 46631, 15055, 63126, 27596, 61180, 45983, 22076, 33823, 54868, 55242,
                40024, 5960, 25823, 209, 38243, 63926, 37020, 29071, 43264, 14046, 22787, 47774,
                2597, 40202, 35452, 51232, 59558, 37244, 28361, 31303, 63216, 65320, 21705, 31661,
                31970, 11224, 30328, 12502, 50719, 53320, 59551, 6177, 25842, 23233, 10672, 59866,
                33248, 51464, 24129, 15868, 51310, 831, 11679, 39776, 16838, 15094, 1891, 4945,
                17139, 14483, 53417, 43793, 26732, 25508, 60376, 45651, 42304, 20805, 51017, 51137,
                18853, 5282, 56980, 36262, 63291, 40055, 17194, 44512, 3754, 14677, 37193, 4063,
                61233, 22279, 23257, 13592, 30216, 19982, 28442, 27947, 26463, 53635, 61708, 47188,
                59831, 42961, 26492, 9340, 35601, 11309, 38972, 6821, 2617, 50856, 11340, 4937,
                46850, 7973, 37673, 27306, 19855, 41187, 5963, 44203, 64792, 33983, 13343, 10665,
                11175, 64153, 53260, 62614, 49346, 36709, 55179, 8543, 39141, 36887, 27874, 11142,
                32650, 16114, 64619, 58247, 8714, 18354, 43117, 2534, 60065, 40265, 31687, 48791,
                50066, 27022, 40843, 4931, 24620, 57753, 25680, 2913, 55151, 20387, 15219, 11052,
                9219, 37402, 63692, 21719, 39391, 33838, 39773, 997, 36072, 4482, 55672, 60378,
                32729, 34536, 7624, 17576, 48245, 426, 55571, 40444, 33146, 33971, 6131, 35061,
                18155, 7598, 36545, 60972, 26042, 744, 27907, 14928, 44169, 29624, 62476, 62732,
                7788, 59995, 12290, 2471, 53137, 25846, 61841, 43565, 8741, 49759, 39626, 1621,
                26404, 47860, 10662,
            ]),
            c: 236,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 244,
                b: 10736787368015739932,
                c: 2999381551,
            },
            FixedTestStruct {
                a: 118,
                b: 8708320525189144534,
                c: 4021318982,
            },
            FixedTestStruct {
                a: 212,
                b: 11980052676225444100,
                c: 3164386682,
            },
            FixedTestStruct {
                a: 250,
                b: 2578982393630105132,
                c: 1941069318,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 36012,
                b: List::<u16, 1024>::from_iter([
                    45286, 64710, 8368, 8693, 49467, 56997, 22986, 51416, 21129, 56764, 42816,
                    26552, 20183, 4560, 3501, 29609, 22941, 8435, 18060, 6370, 14409, 55377, 47088,
                    2710, 48849, 53593, 63102, 56162, 64610, 44972, 60690, 33226, 4385, 20787,
                    62649, 14925, 11076, 18857, 65112, 45284, 25042, 31476, 10658, 52761, 9685,
                    28598, 64039, 51278, 17992, 37157, 1498, 52309, 32568, 62865, 41435, 55629,
                    35149, 33412, 28758, 28117, 58245, 14074, 22108, 34109, 61881, 32814, 37049,
                    45305, 42186, 5714, 7265, 13932, 447, 61512, 11899, 17687, 64398, 34194, 21446,
                    35552, 26702, 48997, 61368, 14868, 42241, 54460, 50699, 60111, 59354, 55703,
                    42362, 53746, 8603, 2741, 64296, 18003, 32343, 34383, 8391, 62667, 44571,
                    20590, 64772, 31105, 56873, 40297, 55524, 2322, 17617, 42097, 41871, 36808,
                    48776, 22211, 62889, 19084, 8932, 16013, 43393, 16865, 40638, 10791, 17251,
                    26095, 40987, 26729, 9192, 32057, 46343, 8810, 17582, 55995, 44869, 8001,
                    23345, 54462, 36009, 40649, 17469, 4343, 3093, 52656, 59475, 7954, 43018,
                    20960, 25278, 37715, 54264, 26240, 58334, 5105, 47069, 5160, 38451, 40773,
                    13359, 27225, 37181, 33916, 56148, 23569, 38233, 10482, 23428, 34537, 36982,
                    25181, 46879, 45695, 41328, 52917, 56537, 23022, 22362, 9637, 22502, 30665,
                    52452, 40130, 48728, 61342, 35105, 28775, 7801, 21527, 10960, 49907, 1641,
                    3484, 62086, 41865, 35410, 60677, 40950, 59160, 64936, 57534, 24173, 42359,
                    37968, 22374, 52091, 49686, 4477, 47609, 22917, 54488, 36737, 20905, 37087,
                    41243, 32660, 46427, 55358, 43032, 32413, 26366, 37967, 24909, 56387, 12032,
                    33133, 17852, 10866, 26859, 63534, 47675, 47325, 61384, 7279, 51925, 38224,
                    35343, 65409, 45459, 64379, 45111, 60623, 7260, 28870, 8442, 7300, 45830, 1759,
                    18499, 23076, 60368, 57635, 61907, 5922, 12539, 56519, 27867, 61191, 595,
                    28032, 15966, 27715, 46892, 15097, 13286, 14895, 36347, 693, 42448, 15546,
                    52347, 23353, 27833, 14817, 35726, 13538, 45073, 28152, 10903, 29949, 15038,
                    57062, 34920, 14561, 19470, 17932, 10674, 18489, 428, 54348, 5739, 14770,
                    15543, 13621, 20382, 60636, 59709, 3807, 49258, 39153, 52366, 53293, 7894,
                    53835, 55045, 52192, 36234, 27933, 9105, 42430, 18848, 4460, 64409, 59681,
                    31874, 40799, 33941, 20631, 42146, 45969, 31351, 60280, 54110, 26471, 34224,
                    24968, 17633, 22435, 45965, 63293, 19971, 20740, 40692, 28847, 18645, 11345,
                    33386, 58714, 43968, 45436, 4270, 46708, 61014, 37550, 50779, 27530, 17093,
                    2259, 23561, 21896, 5186, 47076, 24443, 936, 38650, 60577, 44251, 5761, 62387,
                    18540, 5317, 3363, 56878, 10919, 18535, 44141, 39677, 24206, 15318, 37574,
                    57387, 62783, 3389, 8092, 12209, 18049, 24502, 46967, 22503, 8512, 8226, 63811,
                    56513, 4743, 19782, 12640, 37695, 64386, 9762, 45475, 9411, 17115, 10015,
                    12599, 54147, 61600, 26852, 1148, 37474, 63075, 15980, 43161, 55810, 61079,
                    27848, 62525, 6834, 60241, 50441, 15839, 49518, 44909, 11828, 55384, 46282,
                    33324, 35412, 41225, 34489, 61487, 64526, 41570, 4958, 2146, 22053, 46184,
                    26429, 65286, 45439, 45344, 2204, 55658, 27206, 38544, 14014, 61098, 51208,
                    53600, 16659, 12558, 55154, 20309, 47872, 40118, 33163, 2610, 47296, 10209,
                    33906, 9158, 30500, 28178, 36440, 16967, 41714, 41582, 45966, 38529, 49792,
                    13737, 37646, 10501, 16316, 32590, 24455, 16772, 12864, 21596, 16527, 12798,
                    18187, 52900, 59773, 56087, 13932, 15454, 50483, 21790, 40332, 47284, 37669,
                    29153, 30352, 10849, 2347, 42574, 39453, 42068, 8065, 28073, 2582, 26238,
                    34891, 39482, 13426, 38648, 56760, 10387, 9840, 52595, 4807, 32639, 51655,
                    21344, 53750, 21916, 29446, 27482, 41372, 33985, 49020, 3663, 2019, 12577,
                    55177, 931, 27485, 11373, 1267, 55553, 59022, 62195, 20393, 63584, 21974,
                    47084, 27772, 17704, 10495, 2500, 15315, 52055, 23126, 59962, 56334, 44004,
                    23761, 334, 51509, 41332, 12235, 18653, 31753, 46390, 60926, 24835, 26748,
                    16684, 58141, 4015, 3914, 59060, 21889, 20349, 7707, 36486, 59721, 25215,
                    55969, 37148, 53949, 22911, 45007, 19793, 23959, 48820, 48149, 49686, 51059,
                    33115, 26073, 51296, 14882, 1326, 30168, 64869, 43058, 48107, 29482, 48491,
                    43455, 44790, 1503, 27454, 37513, 9376, 38519, 6451, 15707, 20228, 30422,
                    62993, 19751, 47556, 2878, 13163, 34329, 34559, 62383, 52402, 61134, 33229,
                    8925, 52851, 6132, 23037, 4657, 7954, 38039, 49967, 14081, 41895, 33737, 46823,
                    51981, 61105, 30655, 9660, 615, 2294, 45829, 33125, 36603, 42625, 22707, 16947,
                    45044, 40025, 52227, 26381, 4849, 37959, 60411, 22338, 22519, 29277, 44102,
                    65308, 11318, 37027, 31689, 11116, 55217, 2284, 11058, 6249, 15882, 12448,
                    45130, 11494, 63883, 17598, 7170, 49100, 44676, 6514, 32885, 45865, 14767,
                    22431, 43642, 27078, 3781, 33964, 63007, 12512, 62469, 38426, 19395, 29509,
                    4615, 6228, 17896, 32730, 25060, 20060, 38936, 63691, 9729, 54210, 30236,
                    26207, 63821, 39139, 2882, 16276, 55087, 33316, 14854, 48439, 31930, 23761,
                    8885, 28439, 13358, 49995, 46555, 63024, 34432, 13298, 21409, 33225, 44572,
                    20507, 15112, 64911, 25235, 6362, 12931, 30836, 27340, 48648, 35724, 29930,
                    46277, 13513, 40053,
                ]),
                c: 75,
            },
            VarTestStruct {
                a: 31422,
                b: List::<u16, 1024>::from_iter([
                    41536, 53745, 8614, 26181, 41078, 47910, 51433, 8103, 43092, 60217, 35900,
                    28603, 6651, 41287, 19112, 59182, 47397, 35978, 5990, 1581, 35667, 10300,
                    45523, 47493, 44283, 34256, 36472, 36037, 52151, 60187, 18020, 42646, 48183,
                    2853, 8697, 58435, 57453, 16165, 62083, 46951, 22790, 56044, 62268, 1757,
                    18900, 45829, 64950, 5366, 18666, 62278, 16311, 54792, 6113, 42220, 4249,
                    32254, 15092, 17794, 27843, 8568, 60888, 54806, 39105, 2787, 54509, 14154,
                    24967, 3656, 465, 59445, 12025, 27791, 20363, 14487, 7737, 51844, 47341, 2248,
                    5041, 16650, 4692, 27755, 62812, 8429, 50753, 30416, 27531, 53358, 63241,
                    45643, 55306, 37281, 37230, 61432, 17032, 35216, 61364, 31748, 9459, 32814,
                    65411, 30654, 55370, 3399, 15511, 5240, 41442, 38449, 43079, 52342, 47357,
                    36560, 62152, 43645, 57855, 27808, 10563, 64456, 45779, 18756, 60554, 34229,
                    39138, 56430, 59421, 245, 64706, 56095, 17053, 39701, 46279, 59737, 39576,
                    3386, 20323, 64231, 40947, 606, 13118, 55847, 15063, 737, 37551, 33620, 44503,
                    35756, 10535, 49135, 27599, 33839, 12785, 60403, 58687, 45402, 47195, 37566,
                    1337, 30181, 33364, 42690, 50490, 37666, 16274, 27821, 25761, 31495, 49899,
                    28386, 33207, 31819, 40538, 59051, 17171, 64316, 47999, 64395, 44710, 39715,
                    63030, 30234, 10304, 20987, 56323, 13163, 19022,
                ]),
                c: 47,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_random_9/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("ef116345d1d809e3a8c2fde4dae330d025ce3d5afbd096ca0477bde166093560");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_one_1() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([false]),
        b: Bitvector::<2>::from_iter([false, true]),
        c: Bitvector::<1>::from_iter([false]),
        d: Bitlist::<6>::from_iter([false]),
        e: Bitvector::<8>::from_iter([true, false, true, true, true, true, false, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_one_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("41c895a709caea4c3e74ef7bafafb1cb189eae3298ab2817c28ce78444488545");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_nil_5() {
    let value = VarTestStruct {
        a: 33408,
        b: List::<u16, 1024>::from_iter([]),
        c: 65,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_nil_5/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("d97827015e4a4920cb11833893aafdf4335e4495a69b7ac9aa4bb9e2282f2077");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_random_9() {
    let value = SingleFieldTestStruct { a: 8 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_random_9/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("0800000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_one_6() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([false]),
        b: Bitvector::<2>::from_iter([true, true]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([true]),
        e: Bitvector::<8>::from_iter([false, true, true, false, false, false, true, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_one_6/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("317370e20fa26f536091dafc94282aa86db552df4ac30045150d4bcd2cc49426");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_lengthy_chaos_2() {
    let value = VarTestStruct {
        a: 1866,
        b: List::<u16, 1024>::from_iter([
            5970, 16331, 6233, 25696, 43712, 34308, 6378, 53193, 12729, 41143, 28218, 28244, 12683,
            24508, 43595, 29477, 28929, 15327, 12920, 45691, 9195, 49912, 53273, 60694, 64402,
            5845, 47975, 23367, 17966, 35482, 48861, 63267, 39059, 25534, 61724, 45706, 54292,
            58613, 1045, 24709, 61688, 42432, 54121, 30218, 65150, 20066, 25154, 43166, 16452,
            12854, 53712, 45446, 20207, 3310, 52949, 60249, 23203, 53917, 35632, 61453, 49993,
            62739, 43525, 367, 35467, 57856, 41583, 5875, 23173, 31875, 18045, 54676, 38595, 46884,
            22358, 2063, 33608, 31947, 24080, 40973, 14838, 43625, 16170, 50450, 44754, 14162,
            55307, 8892, 23549, 34990, 10095, 50915, 16197, 40134, 60136, 17179, 19271, 23620,
            5124, 12110, 7585, 53326, 13824, 831, 24949, 56586, 48809, 39253, 14814, 48606, 15947,
            28078, 43571, 46273, 34098, 25445, 25167, 45435, 57431, 12520, 27531, 27363, 24100,
            17936, 31791, 19770, 37935, 1299, 46114, 12568, 60826, 6719, 36327, 41530, 31543,
            19327, 49610, 50389, 49219, 37438, 40502, 16771, 39555, 56974, 165, 62026, 51594,
            22029, 56832, 41288, 62627, 28807, 14506, 51584, 10197, 54235, 18316, 16051, 53838,
            22324, 2576, 63004, 46632, 55985, 1981, 57295, 32041, 17218, 34588, 47219, 48357,
            20228, 17159, 7290, 41727, 13631, 16464, 40814, 32955, 48902, 53396, 1809, 58332,
            10962, 22715, 60120, 54891, 49895, 6185, 61710, 18377, 8933, 33281, 22283, 41494,
            27669, 20502, 59533, 25947, 42727, 34602, 65125, 28617, 42599, 25746, 20372, 38616,
            30992, 42804, 28034, 37067, 62166, 52442, 60520, 53349, 60607, 36539, 42627, 20810,
            26732, 287, 25168, 56862, 36705, 51341, 35764, 21272, 58387, 63383, 374, 48534, 7824,
            12706, 45288, 55943, 314, 42605, 29950, 41780, 31002, 24329, 1140, 43282, 31766, 40488,
            39765, 24238, 63647, 33116, 12833, 23948, 47332, 28169, 15933, 11386, 28330, 53491,
            27171, 16768, 55320, 5802, 9985, 53550, 37294, 48466, 49208, 9922, 51014, 4301, 65497,
            3748, 40404, 51586, 49775, 21765, 32601, 25754, 41752, 64935, 53061, 20604, 35425,
            34957, 22356, 49238, 15530, 12659, 22637, 4844, 40024, 12527, 63141, 52298, 1765,
            13911, 22490, 7311, 45725, 35496, 4151, 35447, 32399, 38929, 32902, 56916, 43167, 9748,
            4762, 50505, 44050, 64685, 15813, 15709, 62230, 54750, 4185, 62634, 18175, 20663,
            27181, 38941, 45930, 31981, 16227, 44767, 45637, 53622, 25008, 7810, 41642, 714, 30658,
            13957, 64254, 3677, 7525, 3211, 25752, 53390, 43862, 19137, 38008, 3956, 36900, 12589,
            53890, 33104, 31383, 59596, 24698, 46509, 22901, 10973, 18080, 65086, 20274, 27048,
            64235, 45712, 6424, 65255, 59777, 48325, 63865, 7375, 47741, 46549, 25913, 2634, 59115,
            25776, 37445, 18277, 26912, 23061, 18528, 18901, 62051, 32433, 3268, 63069, 38787,
            45049, 25288, 65333, 56243, 48363, 46423, 14154, 60015, 4184, 28456, 60447, 8878,
            31779, 39674, 16853, 13917, 37348, 22894, 21256, 56163, 12562, 19958, 47672, 45432,
            15304, 43109, 14459, 55660, 63948, 56739, 45099, 5588, 39053, 2972, 50696, 8875, 47571,
            6614, 2544, 42326, 43348, 64673, 30519, 45199, 5406, 49945, 23371, 371, 27670, 48568,
            50561, 64724, 62349, 54189, 57613, 14443, 8559, 26502, 41726, 6901, 44688, 52502,
            18474, 19036, 44177, 56732, 35247, 15602, 23660, 38154, 38785, 25149, 15782, 24048,
            15716, 14413, 31824, 14362, 64210, 22880, 14971, 54874, 22139, 2245, 12097, 3347,
            24565, 34623, 9544, 46850, 4927, 10725, 28793, 58842, 24528, 3868, 2528, 18787, 16438,
            55970, 47764, 7360, 1245, 1450, 37738, 46922, 42795, 22641, 14711, 14407, 11947, 2869,
            57715, 56210, 29896, 21844, 42892, 15427, 11967, 4684, 22552, 3131, 46662, 7291, 64288,
            8462, 24742, 37077, 34461, 17296, 56237, 22277, 24355, 46309, 59560, 28545, 14695,
            55318, 39797, 46755, 54885, 27783, 7696, 44432, 4470, 59831, 6850, 1044, 54375, 44760,
            55342, 23305, 22757, 63672, 48825, 58585, 62187, 65267, 38774, 22121, 21157, 18583,
            55683, 20800, 40792, 550, 26999, 52625, 18547, 45395, 39277, 21955, 6486, 56582, 3109,
            1512, 44872, 57839, 38523, 43275, 61248, 41045, 61315, 39137, 25506, 34563, 7938,
            30840, 57727, 44389, 27419, 57344, 18982, 55350, 1023, 22585, 57438, 24617, 24270,
            32652, 13060, 56475, 63859, 62740, 29880, 40778, 5479, 45638, 39709, 10619, 54970,
            2335, 38350, 24554, 31392, 36780, 55101, 56904, 47853, 14208, 42640, 45385, 43204,
            34753, 3763, 41993, 16633, 6811, 27205, 7049, 47069, 16556, 3529, 25128, 58729, 55363,
            58056, 11218, 52268, 31716, 23504, 38870, 6557, 53680, 32717, 37837, 10970, 44350,
            18756, 61361, 27977, 20107, 44747, 61306, 56376, 21427, 14742, 61118, 51044, 11174,
            9042, 8518, 19128, 21434, 46797, 62119, 21082, 14199, 686, 51834, 55535, 11373, 63797,
            36105, 28456, 55347, 52402, 33958, 12968, 54287, 55896, 46715, 47588, 49198, 13997,
            53648, 5990, 49277, 39390, 51907, 61398, 26931, 52509, 43987, 18078, 26981, 58095,
            17507, 21970, 59132, 19414, 5301, 15822, 57689, 53917, 48447, 15856, 23188, 23243,
            6173, 15966, 17789, 10233, 45716, 3083, 40619, 35682, 12739, 34494, 35142, 8445, 34451,
            50566, 7643, 46456, 18351, 53283, 18030, 53469, 37402, 1928, 58633, 59357, 63711,
            26428, 50762, 53830, 37582, 26869, 59482, 32946, 34049, 3608, 43454, 46718, 38124,
            46039, 7835, 65191, 50456, 51451, 13691, 12011, 48484, 27478, 2451, 54180, 36476,
            49499, 5854, 59560, 7551, 64268, 20884, 21909, 55473, 61928, 838, 63495, 13276, 4387,
            60645, 24724, 15326, 31256, 31738, 22293, 55344, 15508, 13464, 35228, 49188, 36578,
            38066, 3360, 38285, 16843, 63090, 4088, 5849, 23622, 48128, 2085, 61965, 54534, 10191,
            25398, 40351, 39275, 44581, 1075, 48561, 63662, 19557, 30062, 7923, 64529, 4157, 51081,
            21171, 61497, 29294, 51623, 30915, 28523, 2564, 51064, 18549, 32604, 11172, 34918,
            7619, 5267, 31817, 19228, 47639, 4652, 11629, 10658, 5566, 56690, 44297, 17576, 64227,
            22980, 52522, 55461, 22503, 21595, 59596, 30262, 50203, 18755, 27349, 13183, 34221,
            20416, 34970, 10488, 62359, 897, 62230, 2310, 59557, 52814, 61303, 14837, 52762, 60921,
            26199, 37351, 64987, 48328, 57355, 27227, 38458, 32459, 33462, 20660, 54514, 4981,
            61664, 49957, 15663, 34590, 23097, 8231, 65379, 42482, 280, 1223, 6681, 6156, 19655,
            57390, 53230, 43373, 42754, 60562, 42763, 9783, 23547, 36149, 27002, 13331, 20777,
            47385, 31177, 41070, 18660, 57006, 65099, 40300, 18253, 17497, 32333, 42189, 17121,
            1470, 13624, 4990, 6379, 23246, 6974, 45554, 40945, 26476, 39928, 55462, 10801, 14894,
            46886, 31161, 10674, 28639, 3274, 62862, 25278, 5882, 27918, 19253, 44063, 23603,
            41694, 12114, 7981, 18099, 58430, 26836, 55658, 24319, 53761, 53503, 36355, 21488,
            33774, 43737, 64294, 64278, 38315, 45991, 22998, 7864, 27676, 18684, 61900, 56624,
            4278, 37451, 23528, 51577, 39587, 63099, 31768, 54706, 14829, 60296, 54761, 39259,
            64042, 63351, 50844, 64804, 13666, 39608, 21155, 38025, 50900, 61208, 20115, 2607,
            27370, 45010, 34314, 8386, 13699, 47900, 1646, 35166, 9217, 20659, 32720, 26382, 49755,
            3234, 65001, 50573, 30074, 10202, 3931, 1555, 12814, 61209, 6188, 65061, 51868, 20794,
            45650, 49084, 59964, 45754, 6407, 51965, 42941, 15645, 17485, 14612, 4420, 32948,
            48945, 62288, 29224, 61120, 33430, 4819, 63360, 49790, 20778, 20285, 33746, 17870,
            37550, 65203, 44896, 6194, 28706, 16922, 25682, 49818, 28984, 356, 43222,
        ]),
        c: 138,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_lengthy_chaos_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("8f429bf1e545075721c16851b18e1a739991404141ef08e63d23ecfadab79d41");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_random_0() {
    let value = SingleFieldTestStruct { a: 225 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_random_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("e100000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_random_7() {
    let value = ComplexTestStruct {
        a: 1062,
        b: List::<u16, 128>::from_iter([
            7871, 15592, 44564, 58127, 25646, 24396, 9801, 25517, 30144, 20664, 5792, 56306, 64674,
            27800, 52593, 36265, 57252, 21602, 8534, 62398, 64818, 36283, 6802, 24593, 20984,
            17318, 29447, 60640, 15717, 7292, 60554, 36208, 32300, 32134, 48798, 15032, 7980,
            63005, 24421, 23810, 25719, 55471, 16882, 14932, 34601, 43250, 2139, 2944, 33882,
            48450, 18166, 59547, 48486, 37668, 12682, 15929, 63034, 31640, 17667, 27607, 64387,
            20804, 20296, 30183, 8042, 37003, 36014, 23584, 17738, 37637, 7402, 4123, 30247, 65530,
            27032, 49484, 34057, 64929, 51903, 55218, 41188, 44292, 7511, 40492, 44924, 473, 53670,
            53051, 23861, 47634, 42549, 51375, 24749, 17034, 12266, 46234, 13588, 4317, 24555,
            8559, 55946, 47474, 33775, 62956, 52506, 64845, 57029, 4215, 50404, 54094, 33610,
            61550, 46057, 44761,
        ]),
        c: 111,
        d: List::<u8, 256>::from_iter([
            198, 161, 60, 63, 253, 100, 243, 231, 3, 42, 12, 4, 163, 239, 231, 12, 42, 229, 115,
            238, 152, 84, 151, 79, 169, 145, 51, 196, 113, 25, 94, 21, 53,
        ]),
        e: VarTestStruct {
            a: 51924,
            b: List::<u16, 1024>::from_iter([
                57236, 10831, 42662, 34230, 2526, 4927, 61167, 41459, 7798, 12414, 43345, 13692,
                48636, 59892, 63284, 42044, 35235, 50832, 1703, 47028, 40466, 64651, 56307, 29066,
                17694, 1155, 44038, 59504, 54451, 34142, 7106, 61363, 27357, 45932, 24160, 46724,
                24015, 20859, 48680, 35381, 5844, 54848, 9361, 46461, 10798, 56348, 56432, 34579,
                33178, 62511, 50087, 40882, 39780, 49814, 53431, 61715, 17138, 6276, 36794, 19612,
                37741, 25752, 56826, 33468, 6011, 56121, 51014, 33343, 34747, 18255, 48131, 24443,
                15255, 26972, 57524, 34537, 11650, 35781, 7244, 12009, 4976, 19767, 36973, 52579,
                26872, 24115, 23242, 26471, 33170, 5494, 54282, 46899, 57793, 458, 33439, 33949,
                43245, 37559, 10200, 56877, 39976, 27389, 59444, 5213, 30929, 5613, 9177, 4787,
                55947, 60298, 10280, 17231, 29477, 50263, 65122, 13489, 47610, 8371, 29727, 49617,
                22063, 3488, 13750, 14433, 7948, 59870, 33605, 32617, 4336, 20424, 8546, 11286,
                32240, 16004, 38397, 58041, 35739, 12687, 18888, 23169, 63191, 35791, 12185, 14573,
                58319, 10949, 36028, 54890, 40324, 59052, 31528, 53608, 13677, 46594, 9120, 58479,
                26028, 18608, 62392, 36094, 55363, 1241, 62470, 10406, 51200, 38466, 53705, 42458,
                28567, 43104, 4373, 25654, 49874, 47501, 23228, 17428, 41418, 28635, 60527, 52358,
                63139, 15239, 42030, 55321, 50142, 13832, 59165, 39630, 16419, 26653, 25229, 44822,
                55123, 7382, 36306, 1172, 18371, 6640, 14156, 57307, 3565, 47827, 10860, 55405,
                58034, 11303, 2423, 2066, 61743, 26136, 35506, 34983, 42754, 54833, 6265, 49501,
                60112, 53591, 33405, 24543, 56860, 21004, 49778, 34335, 18742, 13096, 51621, 14790,
                59823, 52848, 45656, 43934, 26110, 26165, 16698, 33516, 61399, 51219, 58511, 35478,
                44672, 22148, 15437, 64311, 63434, 34380, 36535, 63408, 48165, 34299, 36287, 37464,
                22273, 53551, 64413, 24892, 10752, 56395, 31602, 1277, 46914, 7449, 49943, 31565,
                22184, 11422, 23425, 34145, 27662, 39829, 4880, 17335, 10708, 60069, 20951, 16466,
                39337, 19534, 18704, 35602, 60745, 40186, 5634, 35542, 57091, 33065, 9371, 9184,
                28177, 47666, 38109, 56669, 39761, 31955, 46925, 24344, 54905, 10859, 39298, 35307,
                3702, 51944, 34403, 16866, 10887, 54918, 13622, 25027, 59986, 15255, 63514, 59647,
                33904, 52147, 17843, 18026, 3999, 2987, 58838, 51416, 6611, 27716, 7052, 55016,
                52498, 46161, 58490, 44602, 19391, 27900, 28319, 15701, 19499, 54526, 15835, 37717,
                10736, 64623, 38502, 60475, 63591, 4497, 50657,
            ]),
            c: 41,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 236,
                b: 7317836259427658061,
                c: 4070989328,
            },
            FixedTestStruct {
                a: 241,
                b: 2866003389764641033,
                c: 1136948491,
            },
            FixedTestStruct {
                a: 121,
                b: 18232523595989838681,
                c: 1887266280,
            },
            FixedTestStruct {
                a: 94,
                b: 6612092953144428216,
                c: 3128966878,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 41464,
                b: List::<u16, 1024>::from_iter([
                    59857, 12838, 60112, 52836, 54408, 37997, 10347, 26218, 52511, 52907, 52086,
                    42812, 21088, 53968, 54622, 27862, 61709, 41763, 10063, 1008, 18890, 40199,
                    24885, 14998, 42868, 60475, 53312, 28514, 30180, 36424, 18293, 38449, 30738,
                    46916, 27499, 37804, 35655, 11832, 49339, 41551, 17260, 18853, 33650, 57808,
                    16173, 32883, 29461, 13507, 14476, 35065, 26053, 32909, 56336, 26707, 18962,
                    51583, 10941, 45750, 34817, 17018, 43880, 28249, 25413, 1607, 3629, 2355,
                    10544, 10455, 43271, 40569, 28803, 62773, 17542, 16266, 9198, 2897, 3851, 3354,
                    22972, 38319, 14719, 55527, 43036, 64628, 1951, 30024, 14710, 6440, 13390,
                    38625, 45298, 55789, 19336, 56627, 29522, 64967, 1488, 49510, 54627, 31288,
                    18347, 24681, 41546, 45928, 12078, 59085, 62363, 52293, 36620, 21855, 20312,
                    4817, 24538, 4225, 45399, 244, 48407, 19151, 49897, 43745, 27162, 54695, 32567,
                    48799, 4015, 11772, 62200, 46724, 31884, 28578, 55434, 45904, 46851, 65125,
                    43224, 32290, 24475, 35141, 63007, 11205, 27517, 36540, 56502, 33114, 59809,
                    26039, 7642, 59185, 14507, 49248, 2074, 832, 11149, 2059, 15052, 34116, 62260,
                    51135, 11376, 57190, 49016, 57783, 45829, 44468, 45343, 43172, 44952, 14313,
                    60040, 19958, 8851, 29607, 7183, 47486, 13904, 11350, 26501, 59854, 13266,
                    44897, 23302, 23264, 24296, 44992, 3099, 12467, 27590, 25506, 27979, 46745,
                    45069, 15448, 29618, 45419, 29237, 59113, 26399, 59126, 8274, 18307, 26554,
                    38198, 60084, 19727, 34621, 5136, 57090, 3269, 17431, 48782, 35166, 571, 25832,
                    12792, 37507, 1261, 14164, 1988, 59986, 26394, 16289, 40483, 458, 42077, 46410,
                    39332, 64420, 61749, 17144, 22081, 22810, 59629, 36576, 5913, 6293, 12922,
                    49882, 42798, 60132, 8522, 60160, 31481, 59653, 44639, 10726, 56928, 22241,
                    5353, 9664, 15526, 34904, 3424, 11920, 3454, 49989, 26004, 39144, 21295, 49245,
                    48605, 2907, 14952, 14220, 50732, 11, 23177, 11516, 18584, 3159, 44676, 11053,
                    43356, 64723, 33548, 44696, 52529, 27252, 30260, 486, 7129, 50745, 46575,
                    35931, 50867, 14243, 64778, 49842, 12278, 61448, 16138, 12996, 46230, 14707,
                    33829, 58189, 2577, 675, 2022, 36619, 18736, 17542, 42568, 37660, 40919, 26173,
                    56657, 25669, 14093, 10974, 39972, 41918, 23992, 40461, 41634, 42532, 24258,
                    11694, 56649, 16235, 520, 41827, 55695, 28949, 44731, 33652, 46774, 18046,
                    11514, 46511, 25547, 55437, 23895, 13479, 34814, 17459, 1971, 63102, 65365,
                    63115, 9511, 37034, 40029, 63575, 42679, 23889, 46963, 208, 58990, 32063,
                    47333, 39725, 25439, 65149, 39144, 20576, 57281, 20912, 1632, 48877, 34704,
                    46263, 9042, 12899, 4492, 10017, 19720, 64153, 28431, 39965, 55744, 48152,
                    24592, 48448, 64012, 10606, 27587, 33352, 65401, 2668, 39127, 1107, 45311,
                    29490, 50665, 57195, 42615, 34718, 500, 54201, 25546, 25737, 55336, 22774, 804,
                    48164, 47507, 38649, 35846, 50895, 5940, 29102, 4053, 21926, 6486, 6901, 17935,
                    44898, 4243, 2304, 47171, 26991, 26784, 27545, 10865, 7368, 29382, 60691, 1166,
                    18307, 33168, 25600, 21335, 36423, 35993, 42521, 24603, 15099, 64943, 32591,
                    1082, 16841, 54466, 10419, 14549, 9915, 28409, 14528, 30081, 5937, 40738,
                    28063, 2187, 28786, 64126, 49383, 41814, 9204, 546, 3867, 45145, 8527, 1018,
                    23976, 36517, 34987, 45614, 25278, 34836, 12950, 11694, 56409, 49449, 53023,
                    60439, 32102, 11858, 37323, 13851, 41588, 27609, 63749, 55920, 60364, 57863,
                    46148, 50844, 32261, 6792, 5501, 12771, 54901, 31653, 47023, 13720, 40083,
                    54434, 22025, 28795, 45083, 28425, 31881, 41538, 40305, 14918, 22028, 17856,
                    20431, 30408, 221, 22931, 49186, 26233, 57555, 49227, 31081, 26150, 53264,
                    51462, 8543, 6090, 47251, 42316, 45383, 7218, 46007, 28037, 47451, 46936,
                    46217, 54746, 56648, 3565, 38259, 33645, 41504, 28480, 31347, 3432, 44084,
                    36810, 29475, 47887, 10186, 56134, 40610, 62583, 63039, 38472, 65004, 51166,
                    33597, 39618, 53504, 19191, 44581, 53048, 46083, 49728, 65292, 2052, 57048,
                    60297, 24389, 3829, 41159, 13259, 6577, 48080, 47454, 12345, 59215, 39396,
                    9234, 22700, 17540, 19030, 64618, 58417, 27936, 6211, 15418, 43151, 10828,
                    19212, 58134, 2270, 14325, 14574, 8274, 6726, 51038, 47945, 35033, 33011, 1664,
                    3355, 50793, 58506, 55248, 27206, 25643, 54231, 45155, 30990, 18133, 63276,
                    28353, 63892, 2972, 61538, 53755, 11050, 56709, 14415, 15084, 7533, 48805,
                    32705, 59998, 24547, 3555, 39, 10296, 55758, 52857, 23455, 17169, 20038, 38869,
                    12578, 25134, 53379, 47249, 1695, 45356, 27617, 5972, 21343, 50046, 87, 22584,
                    62060, 59114, 13800, 29581, 1171, 38874, 57321, 42409, 2184, 64415, 6076,
                    48406, 40829, 59768, 2166, 45725, 6366, 51063, 49683, 24621, 97, 44200, 26495,
                    37236, 34525, 7662, 17312, 44503, 55196, 31510, 42158, 17301, 18538, 16481,
                    15445, 28664, 1550, 6905, 10239, 35146, 27566, 54731, 43865, 332, 5015, 41075,
                    29747, 26353, 19655, 49071, 49795, 16102, 40760, 1614, 48807, 61005, 35446,
                    63860, 31453, 37569, 28856, 39270, 19756, 324, 7538, 54747, 47373, 10931, 8667,
                    26782, 21516, 43340, 57300, 39272, 24481, 48285, 17275, 24429, 43651, 61180,
                    34835, 61259, 20928, 33332, 11318, 62719, 23522, 9125, 60715, 33169, 35984,
                    55358, 42778, 17336, 20563, 10029, 14303, 42762, 51446, 57250, 43791, 3553,
                    46043, 37341,
                ]),
                c: 6,
            },
            VarTestStruct {
                a: 23382,
                b: List::<u16, 1024>::from_iter([
                    7292, 62152, 54746, 49789, 34666, 32564, 63999, 45527, 16076, 27308, 53941,
                    41650, 31214, 23325, 60736, 1409, 30298, 22851, 62472, 54988, 47414, 17809,
                    5979, 59154, 19737, 60947, 63941, 31574, 61560, 23791, 7625, 52180, 33394,
                    24151, 29348, 7593, 26975, 63747, 19618, 54649, 38892, 8268, 24591, 46258,
                    35189, 34319, 61142, 22425, 31747, 26069, 55816, 45820, 61166, 44108, 36310,
                    36327, 57155, 32942, 4985, 49395, 14791, 21239, 24004, 1660, 13128, 14225,
                    20702, 6952, 44956, 20415, 44845, 59587, 38802, 24255, 54130, 2657, 38576,
                    47092, 53018, 1353, 58676, 51455, 58981, 18586, 4072, 62868, 55769, 36050,
                    60497, 40534, 35914, 2875, 46338, 1022, 6783, 8041, 40528, 25083, 51644, 52797,
                    3578, 5416, 46943, 61293, 58393, 43251, 23426, 13533, 49791, 49843, 42515,
                    28978, 45852, 24273, 26823, 6366, 4408, 58138, 51144, 29315, 54882, 14345,
                    21333, 15653, 64283, 40207, 32827, 43793, 30829, 26044, 246, 9427, 48148,
                    47135, 63205, 65007, 49038, 36731, 17641, 18006, 53720, 62456, 33162, 19896,
                    11727, 64779, 12984, 20187, 47165, 64199, 29021, 34202, 35477, 41370, 65501,
                    17748, 17172, 50569, 4234, 15429, 30499, 36401, 35586, 16261, 50071, 9349,
                    17911, 33101, 58367, 34178, 26290, 62294, 35925, 48942, 42367, 4832, 37143,
                    49432, 9537, 26353, 9423, 23249, 9096, 56237, 16732, 634, 42370, 14486, 22950,
                    39848, 57410, 16573, 42670, 7069, 52647, 2066, 12307, 14770, 42689, 65443,
                    24556, 50687, 49653, 13211, 65146, 23198, 48369, 5124, 58052, 63121, 5209,
                    32605, 49725, 47551, 59422, 57574, 8784, 55475, 23468, 8407, 41206, 44871,
                    57394, 56810, 28563, 64807, 2731, 19845, 62392, 26341, 50176, 6370, 53698,
                    41686, 34647, 36623, 39165, 15024, 9268, 4838, 22272, 45961, 53138, 63332,
                    35700, 29638, 18819, 42053, 51075, 38318, 20922, 34816, 8259, 37004, 35821,
                    14532, 61189, 56751, 61386, 59672, 57279, 45287, 39337, 36882, 61643, 39339,
                    10134, 309, 30077, 31374, 27880, 27444, 12155, 17596, 17191, 60603, 53444,
                    33121, 33418, 62164, 20700, 42906, 29184, 10098, 59216, 7405, 26987, 34421,
                    55695, 16905, 14917, 36148, 13329, 10563, 62834, 20190, 26012, 23813, 3365,
                    33948, 43510, 18154, 62935, 54716, 38117, 49131, 12866, 61211, 37140, 45119,
                    57976, 50746, 39707, 64489, 47532, 31877, 7658, 47682, 37305, 19046, 19181,
                    7244, 24801, 35127, 25365, 38196, 16809, 55918, 39889, 39130, 40163, 52876,
                    38112, 32996, 37933, 46702, 48321, 29278, 23681, 59645, 59338, 56897, 8366,
                    51551, 34991, 58873, 11615, 53259, 18695, 32295, 52983, 52307, 52577, 22121,
                    57250, 62221, 46975, 17057, 5908, 33793, 37639, 45518, 57222, 38024, 18475,
                    23371, 50891, 40761, 18875, 56407, 578, 6565, 10165, 41160, 11418, 26946,
                    37621, 23820, 6573, 25671, 11573, 15288, 56409, 22204, 12491, 7384, 16470,
                    45173, 3546, 24492, 64207, 1905, 63383, 11124, 62890, 57500, 7029, 32167,
                    10808, 40378, 4855, 13811, 51034, 31975, 43696, 34159, 4181, 51377, 11973,
                    65475, 51794, 24238, 53126, 16071, 60541, 46235, 732, 31851, 40193, 22591,
                    51633, 531, 31946,
                ]),
                c: 111,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_random_7/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("423f3f5a0661f71ca55f045f87ab19265d7b53c701a438893ac630277c2faea0");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_small_test_struct_random_chaos_1() {
    let value = SmallTestStruct { a: 59426, b: 2529 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SmallTestStruct_random_chaos_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SmallTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("d7d8effdbcd60412d8b8affe2aaeeb6a6252256055f4efe4e54863bb9bf940f5");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_max_2() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([true]),
        b: Bitvector::<2>::from_iter([true, true]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([true, true, true, true, true, true]),
        e: Bitvector::<8>::from_iter([true, true, true, true, true, true, true, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_max_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("9a3d0c2e21e801c79164317f02379726734baa7c163bbe5a1f9c34055113a8bd");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_random_0() {
    let value = ComplexTestStruct {
        a: 45098,
        b: List::<u16, 128>::from_iter([24760, 11575, 2534, 13704, 55254]),
        c: 96,
        d: List::<u8, 256>::from_iter([
            141, 59, 88, 169, 119, 128, 156, 87, 77, 70, 192, 123, 130, 5, 192, 216, 198, 140, 107,
            43, 49, 109, 137, 161, 195, 146, 241, 74, 32, 190, 3, 4, 2, 219, 194, 152, 240, 57, 73,
            24, 151, 186, 238, 220, 46, 78, 90, 76, 175, 161, 242, 111, 30, 99, 220, 54, 120, 155,
            57, 74, 144, 220, 158, 69, 130, 204, 20, 24, 237, 119, 58, 18, 82, 121, 96, 112, 67,
            113, 48, 206, 48, 208, 230, 91, 34, 223, 13, 141, 184, 142, 132, 77, 174, 161, 236,
            129, 214, 215, 207, 3, 125, 62, 31, 93, 49, 139, 203, 36, 84, 96, 205,
        ]),
        e: VarTestStruct {
            a: 1284,
            b: List::<u16, 1024>::from_iter([
                62801, 12676, 50809, 30221, 38726, 51052, 18468, 59585, 63940, 64980, 40354, 21180,
                31638, 16957, 49696, 164, 41620, 32688, 48922, 13279, 1759, 7737, 63477, 47970,
                54063, 29083, 51239, 18581, 28120, 35618, 8863, 16998, 29260, 38915, 32819, 63268,
                20560, 18956, 51280, 23952, 11129, 56406, 3342, 3822, 51901, 45000, 41696, 40385,
                31779, 928, 32255, 53443, 33570, 45501, 51216, 43732, 24156, 35486, 9812, 33584,
                59672, 43287, 14471, 4037, 58903, 22222, 21087, 14542, 38704, 30732, 41262, 58351,
                45925, 50970, 29249, 39963, 24542, 14433, 31920, 33158, 23374, 57731, 54091, 42771,
                38871, 65074, 33415, 19160, 16143, 51638, 50090, 36329, 26287, 57137, 5633, 56449,
                39625, 38031, 48938, 48348, 9966, 30765, 26355, 8632, 45986, 23892, 36279, 33895,
                34323, 24456, 1291, 3627, 9140, 36608, 15198, 6627, 49584, 63051, 50591, 40412,
                54586, 46933, 819, 13979, 42852, 56843, 3091, 46616, 41949, 5561, 50973, 65043,
                41758, 41270, 60854, 61638, 58097, 49082, 28009, 48886, 56033, 31292, 36613, 52316,
                64550, 27960, 51763, 64807, 360, 11327, 54514, 45232, 27822, 5464, 13285, 51333,
                43546, 44771, 62811, 43740, 49103, 54050, 53678, 25000, 27644, 32503, 60383, 14930,
                1853, 14877, 62163, 11335, 10795, 14575, 49439, 39597, 50801, 41069, 48537, 39603,
                15218, 51080, 7835, 25379, 24238, 13033, 15896, 30372, 275, 23453, 8503, 13084,
                58034, 8739, 34600, 25443, 54836, 44961, 18656, 29412, 15764, 2618, 24311, 37072,
                9785, 31723, 49067, 54898, 17572, 14430, 62910, 3421, 12689, 12978, 26233, 431,
                28622, 46748, 44543, 51497, 16017, 48776, 35900, 31745, 31204, 27197, 34761, 65462,
                34986, 17400, 65413, 12739, 23434, 63499, 64320, 40163, 18430, 53400, 32036, 39530,
                34385, 47477, 37997, 54620, 33135, 57990, 62186, 20679, 33802, 46961, 61819, 38704,
                10434, 8675, 14572, 16605, 54880, 46512, 61751, 46750, 22458, 12165, 27426, 59728,
                8463, 4877, 5477, 8167, 49491, 2355, 54078, 61927, 6846, 38062, 38821, 46381,
                49303, 63599, 46708, 47439, 8465, 39556, 60260, 21415, 30693, 60905, 4905, 45868,
                37397, 40072, 16145, 17471, 19502, 58308, 47396, 57259, 23509, 59274, 30231, 50802,
                6241, 54565, 41870, 11052, 15025, 58401, 64859, 37129, 55258, 16163, 50668, 51358,
                22008, 51206, 19003, 58277, 16706, 5106, 61860, 43434, 52523, 64227, 63820, 38277,
                62597, 23057, 41607, 5143, 32730, 27833, 36142, 37387, 49747, 33054, 54032, 22789,
                1146, 26097, 45312, 28010, 42407, 10524, 39414, 30977, 45149, 36752, 7575, 31660,
                14392, 3013, 34379, 34915, 27881, 53059, 30975, 61054, 51041, 36721, 24576, 43343,
                20200, 11545, 58098, 37743, 16966, 24617, 30184, 54565, 4478, 41471, 57584, 50767,
                24311, 57709, 61960, 20956, 27405, 26808, 14702, 27203, 18802, 46072, 58598, 62292,
                53382, 26220, 65021, 56397, 37777, 51076, 37342, 9956, 51351, 11231, 40949, 38411,
                43224, 13856, 28755, 61099, 54806, 38782, 35186, 48589, 62021, 48608, 35636, 48491,
                21764, 7498, 59701, 28354, 56587, 63799, 20040, 55283, 40167, 50476, 7051, 62170,
                25811, 28859, 8908, 702, 26577, 36510, 43810, 28804, 40947, 47961, 14353, 48346,
                40133, 64817, 56334, 64974, 24892, 10439, 41491, 40326, 34988, 57939, 55987, 60406,
                64400, 55949, 51913, 47956, 33850, 3299, 20494, 46240, 4524, 39497, 11102, 4618,
                1095, 7133, 13375, 9845, 511, 8393, 18101, 44759, 47744, 29751, 41955, 57665, 1245,
                32303, 11193, 51187, 17554, 61974, 37301, 47236, 19647, 31536, 16177, 48131, 51359,
                56360, 35750, 24390, 9649, 34896, 23661, 14856, 44515, 42323, 3387, 35370, 29921,
                10462, 64264, 43005, 14082, 3573, 60543, 13781, 46362, 46395, 58536, 21370, 6328,
                43763, 43510, 62052, 20617, 19958, 42542, 22985, 46933, 42263, 54655, 18168, 40689,
                61202, 5421, 1030, 55210, 40852, 55448, 59304, 35819, 34683, 1792, 63255, 10752,
                26304, 27346, 28114, 13574, 4186, 12962, 22023, 46593, 26272, 7532, 14897, 33813,
                4690, 14544, 12203, 28806,
            ]),
            c: 96,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 188,
                b: 9730166158537326586,
                c: 582055670,
            },
            FixedTestStruct {
                a: 142,
                b: 12146156903005665865,
                c: 481599615,
            },
            FixedTestStruct {
                a: 68,
                b: 14644856350027584855,
                c: 637057914,
            },
            FixedTestStruct {
                a: 161,
                b: 15243040026072936985,
                c: 1682921351,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 59880,
                b: List::<u16, 1024>::from_iter([
                    51238, 41083, 39782, 47063, 19253, 43226, 61078, 11077, 18828, 32437, 23333,
                    54387, 15304, 38402, 45920, 47775, 35413, 10760, 14587, 2142, 44510, 27301,
                    13737, 28389, 61990, 40825, 36833, 57074, 44628, 50528, 33918, 56843, 22773,
                    34587, 46811, 54157, 33870, 46448, 45017, 54342, 21634, 58217, 41806, 52216,
                    62560, 50521, 51846, 43306, 56118, 33693, 39260, 51350, 3603, 13157, 47372,
                    2761, 26190, 43524, 1931, 5764, 20664, 48756, 6326, 37655, 4735, 4880, 42669,
                    33564, 7178, 51716, 29167, 63508, 15132, 59746, 40067, 2736, 33947, 49661,
                    39584, 55606, 26382, 4886, 8623, 62292, 60183, 35005, 50462, 20638, 60782,
                    56295, 22674, 32684, 4708, 36045, 37839, 40860, 61535, 8477, 40858, 39972,
                    39104, 13437, 36779, 59659, 7427, 10071, 30602, 58474, 60456, 36384, 31033,
                    17749, 19732, 51958, 34584, 6692, 55404, 62559, 36039, 44083, 29601, 56259,
                    17994, 19934, 32152, 283, 18477, 58722, 59284, 12213, 54589, 6901, 16221,
                    48228, 2604, 49844, 46449, 27329, 25538, 38148, 36087, 25060, 13673, 9541,
                    23581, 48137, 18068, 57229, 17904, 39674, 21943, 41282, 29001, 58721, 45525,
                    12464, 21246, 42220, 43994, 63651, 32165, 41032, 59382, 3510, 11820, 57248,
                    58221, 33864, 15286, 16167, 25997, 47605, 30396, 30072, 57188, 3617, 55325,
                    42201, 47914, 60230, 48751, 57821, 52789, 62962, 42076, 9530, 64938, 17104,
                    25553, 18290, 33513, 13526, 29398, 65444, 10237, 9100, 15080, 21173, 39509,
                    38712, 40526, 42677, 26523, 22525, 29897, 16864, 26101, 43991, 42834, 3149,
                    41463, 22167, 21716, 30153, 33931, 53729, 37341, 18679, 22148, 58784, 53991,
                    15870, 33617, 47541, 3689, 63008, 54687, 39914, 29706, 1133, 45266, 7448,
                    24713, 60482, 46040, 46136, 55018, 2821, 63338, 30049, 35694, 50422, 50947,
                    48183, 6462, 14170, 7080, 39032, 36947, 13735, 10793, 53683, 32689, 34998,
                    39723, 14644, 46400, 51182, 8700, 34778, 60057, 52784, 36164, 60569, 16907,
                    55391, 52366, 10984, 25945, 60027, 6108, 61731, 38632, 19487, 15257, 32705,
                    53925, 30513, 1036, 56741, 47257, 25869, 34351, 32770, 2781, 47657, 47155,
                    18358, 27697, 37245, 56394, 61706, 6130, 1507, 36830, 8926, 41471, 22084, 4709,
                    42087, 32166, 14779, 61286, 18848, 53222, 47009, 5024, 41372, 19586, 62620,
                    56160, 15734, 56813, 10029, 53484, 26471, 7860, 63554, 15413, 50905, 27286,
                    7132, 42831, 20471, 47957, 26207, 58312, 29701, 61591, 5901, 7686, 18827,
                    31053, 23402, 41020, 27898, 52318, 62296, 45516, 40734, 29277, 12421, 2906,
                    49157, 30041, 29353, 41798, 56524, 30284, 53110, 42879, 1859, 17633, 10400,
                    4691, 50304, 4162, 25306, 16708, 40827, 36860, 3198, 46204, 52425, 9686, 1296,
                    37261, 5765, 56562, 26108, 32748, 43094, 21872, 44320, 29356, 41642, 63763,
                    31224, 38951, 12326, 57684, 46254, 16900, 22451, 30560, 19083, 11371, 14147,
                    15483, 65135, 37717, 45311, 37291, 45223, 21765, 54601, 40722, 44458, 36498,
                    10638, 2078, 1566, 1043, 24231, 60296, 33948, 60526, 2807, 4607, 11893, 22546,
                    59338, 25429, 27441, 27401, 11880, 8856, 17644, 63453, 35130, 50120, 42497,
                    63737, 48365, 52771, 40967, 7256, 31745, 58968, 49826, 46929, 24308, 8951,
                    30997, 9340, 24870, 35000, 17240, 49880, 52282, 44365, 15289, 25155, 50359,
                    19071, 14016, 15770, 63494, 44598, 65397, 60326, 13321, 10833, 48063, 9501,
                    23609, 7644, 35963, 13962, 41249, 21276, 55620, 11630, 42128, 38874, 63304,
                    29998, 62631, 13498, 1582, 664, 26228, 24396, 6707, 4801, 27050, 28899, 7644,
                    52796, 45772, 24670, 26322, 57744, 4010, 15601, 18837, 8835, 57180, 2025,
                    11078, 59063, 55094, 38720, 44201, 31777, 16310, 19213, 26862, 46909, 9462,
                    16085, 29557, 41105, 23230, 24319, 16853, 59071, 58820, 47708, 40765, 55587,
                    29714, 32635, 961, 24212, 32722, 4142, 26467, 57894, 16479, 30210, 29711, 5112,
                    6136, 56713, 7289, 55752, 34673, 37111, 59336, 11557, 20114, 13614, 3525,
                    62872, 3560, 26529, 19206, 64369, 52344, 40825, 5967, 60868, 47020, 39618,
                    37500, 17726, 8008, 6850, 1338, 7334, 25021, 24509, 16889, 64700, 20285, 32059,
                    44716, 59511, 55365, 32630, 13455, 57928, 62465, 23912, 34398, 29132, 27012,
                    57444, 45336, 60340, 7714, 44882, 51844, 38093, 23126, 15142, 16800, 54212,
                    29856, 57632, 43289, 8879, 23275, 63359, 59317, 20556, 11208, 30643, 39552,
                    43491, 1825, 33606, 62158, 58063, 37827, 2509, 42887, 33703, 10760, 16681,
                    63750, 16097, 31555, 10722, 6138, 55576, 280, 49584, 19749, 25117, 51770,
                    64258, 12061, 13961, 48712, 14490, 47505, 21524, 19496, 46975, 16710, 3392,
                    19106, 3757, 52785, 33573, 61594, 59301, 22942, 21244, 28871, 50929, 9546,
                    41163, 6988, 14062, 55276, 15650, 9772, 22559, 36131, 48109, 40180, 12911,
                    28736, 11906, 36735, 43134, 18150, 6637, 52743, 7653, 62701, 46605, 13450,
                    24351, 51399, 56826, 60224, 65266, 53856, 23188, 34504, 34114, 15786, 19629,
                    41884, 52356, 4225, 9884, 53460, 39877, 14903, 37672, 39619, 7868, 20750,
                    15794, 9913, 30240, 33418, 44756, 5638, 35125, 8412, 21986, 5948, 25577, 43722,
                    18043, 65173, 30832, 31201, 46635, 1608, 13472, 51585, 43323, 23167, 29262,
                    15327, 4920, 54075, 18266, 17577, 39510, 51636, 62233, 22086, 64792, 26896,
                    64500, 55966, 39568, 18200, 45832, 60197, 32892, 13068, 49687, 17142, 3026,
                    62589, 19623, 616, 36672, 36830, 51880, 63450, 45700, 35989, 1527, 61371,
                    58142, 7782, 61074, 48620, 11495, 63091, 1934, 1057, 44396, 39230, 47927, 8440,
                    25883, 50393, 64262, 4791, 4369, 55781, 62252, 11699, 56307, 56616, 17560,
                    8339, 21742, 35440, 15369, 26117, 48382, 57360, 35277, 14851, 9748, 47941,
                    11765, 6828, 25160, 5817, 54281, 8047, 5511, 7975, 59344, 4473, 21785, 52528,
                    5836, 18153, 48343, 28146, 48488, 30276, 64502, 4154, 45509, 59957, 10308,
                    34086, 27202, 13855, 64935, 29469, 61467, 39072, 21297, 18919, 39040, 56662,
                    55186, 12369, 9690, 7072, 59376, 18090, 48834, 17262, 58046, 53887, 28193,
                    39017, 30431, 3632, 16483, 11332, 65443, 55314, 6334, 29170, 13432, 38958,
                    33328, 11872, 46856, 30806, 37484, 14213, 22247, 26711, 20113, 65148, 56501,
                    35565, 48070, 37682, 54024, 23999, 9949, 54521, 5440, 64748, 28893, 13081,
                    54594, 16750, 35353, 2181, 8616, 18175, 28985, 59463, 14121, 15548, 59185,
                    52570, 61386, 30140, 61404, 22860, 15944, 60732, 53367, 15091, 49135, 24605,
                    58139, 11767, 616, 40902, 16764, 46031, 13946, 43333, 65282, 59400, 51158,
                    27837, 35331, 27453, 44651, 12379, 64532, 6171, 43855, 16227, 61879, 6327,
                    24863, 64148, 34333, 14684, 45896, 29147, 38364, 33364, 32974, 32789, 40769,
                    2693, 10359, 63522, 41864, 34548, 20281, 60357, 20975, 11443, 7685, 1379,
                    64175, 32975, 22510, 63824, 2491, 4689, 25561, 34163, 18760, 40177,
                ]),
                c: 230,
            },
            VarTestStruct {
                a: 53517,
                b: List::<u16, 1024>::from_iter([
                    11845, 15331, 4596, 1367, 47799, 6408, 49887, 10341, 41539, 51692, 34465,
                    58213, 10750, 63127, 63235, 45719, 63149, 19657, 26565, 17773, 6406, 65330,
                    1027, 40763, 8342, 51231, 19674, 10960, 46107, 61188, 3981, 40258, 31478,
                    15641, 25830, 2325, 5027, 43220, 47058, 56688, 35103, 48538, 50311, 18403,
                    12957, 58151, 65341, 13196, 38878, 11186, 46418, 52884, 57807, 20946, 25006,
                    14041, 5375, 1346, 29742, 31497, 53566, 686, 28299, 56600, 56668, 55235, 26603,
                    10936, 27003, 13785, 30510, 38981, 10072, 13327, 62874, 51956, 52132, 54469,
                    33946, 37615, 20369, 32870, 43646, 53304, 52190, 33577, 45970, 49705, 59447,
                    20141, 62508, 1290, 30408, 5157, 4294, 47033, 45227, 22499, 7603, 59807, 2412,
                    18854, 42628, 31777, 11892, 1093, 38363, 4406, 28779, 29532, 40307, 16248,
                    21777, 5017, 3058, 41828, 41492, 18681, 38355, 15008, 48239, 59253, 27637,
                    42292, 6209, 44985, 43557, 56327, 2992, 16147, 23957, 34105, 48890, 57368,
                    20069, 30545, 44840, 26208, 46480, 41268, 46893, 44552, 41668, 55793, 7017,
                    14881, 27086, 11382, 46799, 6524, 5353, 60116, 3765, 35142, 3672, 64718, 4880,
                    35714, 48414, 40889, 25801, 17772, 5615, 23026, 2703, 40512, 10780, 60628,
                    45149, 15555, 54362, 42684, 18369, 44687, 1953, 3184, 48679, 33897, 32253,
                    6679, 41234, 33479, 16043, 10340, 34487, 45717, 52308, 36937, 52038, 27657,
                    11771, 7402, 33925, 35238, 37953, 64976, 18156, 16069, 21275, 35916, 24117,
                    28346, 39854, 58583, 37423, 5674, 25352, 28684, 18097, 44161, 10367, 43200,
                    29763, 9643, 32444, 62144, 30998, 13888, 55916, 54535, 18420, 30173, 38308,
                    26146, 63608, 40395, 14702, 7447, 2285, 17792, 1131, 33260, 2960, 32332, 38513,
                    37337, 2831, 63527, 16931, 22920, 30454, 14495, 33167, 51268, 24171, 58792,
                    53698, 57702, 60022, 64480, 4330, 30086, 37025, 42134, 35636, 22129, 16956,
                    64925, 62346, 23640, 14228, 30043, 58230, 18841, 39563, 13550, 18521, 19504,
                    23667, 477, 10268, 16820, 28933, 45869, 20854, 17269, 64544, 9645, 35815,
                    42542, 20048, 20539, 41750, 23915, 57789, 30885, 29366, 55670, 48984, 35912,
                    36928, 21634, 2735,
                ]),
                c: 76,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_random_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("e3fbf979c708d4d77adc452ca27d02e9cd978f3fc28601fc75c929b9f1821705");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_one_8() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([false]),
        b: Bitvector::<2>::from_iter([true, false]),
        c: Bitvector::<1>::from_iter([false]),
        d: Bitlist::<6>::from_iter([false]),
        e: Bitvector::<8>::from_iter([false, false, false, false, false, false, false, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_one_8/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("ddc21ccafde9998af8e3fd39a744f1b4d1a08b64e49c9eb7f6137d8e04c07512");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_random_7() {
    let value = SingleFieldTestStruct { a: 181 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_random_7/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("b500000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_max_5() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([true, true, true]),
        b: Bitvector::<2>::from_iter([true, true]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([true, true, true, true, true, true]),
        e: Bitvector::<8>::from_iter([true, true, true, true, true, true, true, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_max_5/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("7b1d842462bfa92850d7e7bfbf6042416e2a0cffdf850987712212d33142e8c4");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_max_chaos_1() {
    let value = FixedTestStruct {
        a: 255,
        b: 18446744073709551615,
        c: 4294967295,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_max_chaos_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("3925681862db7892428eac4afae08671930e623601b5b85fbbc366371e29acd7");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_random_6() {
    let value = VarTestStruct {
        a: 64476,
        b: List::<u16, 1024>::from_iter([
            53688, 48973, 58629, 2535, 50734, 12116, 62095, 53745, 26049, 52022, 56676, 54631,
            32042, 14196, 56909, 30469, 19594, 54011, 16861, 63636, 10939, 39418, 15810, 5773,
            17244, 33735, 40043, 50352, 61825, 9238, 19987, 45755, 56357, 27296, 15875, 35616,
            15348, 10125, 58115, 63028, 48302, 35751, 5032, 28427, 49223, 26098, 25675, 59726,
            12839, 65217, 16028, 58573, 17825, 43167, 4383,
        ]),
        c: 37,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_random_6/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("42f6b3f1963d18c3bca3c22c8fbb50df79b0a55b016591fb42d2e3428d9b334d");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_lengthy_6() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([true, true, true, false, true]),
        b: Bitvector::<2>::from_iter([false, true]),
        c: Bitvector::<1>::from_iter([false]),
        d: Bitlist::<6>::from_iter([false, true, false, true, true, true]),
        e: Bitvector::<8>::from_iter([false, true, true, false, false, false, true, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_lengthy_6/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("26545a0284e45121d8699e25f19fc9c1c4c41112144013c50472a663e9dec051");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_nil_chaos_0() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([]),
        b: Bitvector::<2>::from_iter([false, true]),
        c: Bitvector::<1>::from_iter([false]),
        d: Bitlist::<6>::from_iter([]),
        e: Bitvector::<8>::from_iter([true, false, false, false, true, true, false, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_nil_chaos_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("91aca4bfc8c7a312ed9834decb0c9b2fd8b7f8c6128ac236382a22513df732a1");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_small_test_struct_max_8() {
    let value = SmallTestStruct { a: 65535, b: 65535 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SmallTestStruct_max_8/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SmallTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("5ee8ff3d8661977c818a2d7f926019872cfef9cf4270b99ff833160f41fc01ec");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_one_chaos_2() {
    let value = VarTestStruct {
        a: 7706,
        b: List::<u16, 1024>::from_iter([40992]),
        c: 148,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_one_chaos_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("f51f249688539a42ee372275ec980a4ff15647920a2215f6c572c3d178058275");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_random_1() {
    let value = VarTestStruct {
        a: 43634,
        b: List::<u16, 1024>::from_iter([
            55593, 62281, 4908, 59811, 54631, 42687, 27754, 27273, 26194, 35717, 1605, 53917, 4007,
            61438, 1012, 35712, 56777, 1947, 7104, 53378, 55331, 21992, 11578, 58601, 30836, 5086,
            29700, 12490, 34397, 1117, 27495, 52391, 50304, 3392, 24708, 18726, 12722, 44314,
            13333, 10550, 12089, 15248, 59251, 4147, 26456, 52856, 52045, 26285, 43132, 44254,
            7579, 8064, 54813, 53649, 58140, 29406, 58276, 59263, 47571, 42844, 37539, 63904,
            14568, 35186, 64267, 47115, 61329, 42554, 13821, 18970, 24310, 13957, 35941, 53797,
            38170, 59692, 35209, 35683, 11691, 6108, 62708, 42277, 58234, 13256, 7191, 32396, 4100,
            27360, 11818, 12580, 52257, 52094, 48006, 43310, 12496, 35666, 25786, 18344, 45715,
            47644, 36559, 63271, 5337, 61110, 5413, 55741, 3566, 25693, 14581, 39066, 23559, 34561,
            56241, 20922, 38150, 64575, 9193, 10095, 25655, 44861, 59792, 12597, 60448, 14839,
            64050, 65247, 51265, 36873, 38147, 9610, 54991, 29399, 4513, 40366, 19914, 65200,
            33889, 65303, 42555, 31735, 32484, 58482, 13483, 52310, 15478, 10926, 26602, 7977,
            50775, 39848, 32156, 52108, 24170, 24878, 25522, 17688, 32352, 16137, 1829, 39541,
            36216, 26913, 17042, 8075, 38756, 51004, 41348, 58925, 31179, 22140, 19154, 57071,
            64662, 17552, 41678, 22160, 18149, 64721, 59288, 43373, 45073, 22817, 29913, 27426,
            14635, 34046, 47293, 63103, 37279, 27200, 51273, 10569, 47453, 51839, 52101, 50944,
            29518, 25244, 47018, 33508, 21557, 17846, 17927, 57043, 32878, 59897, 35793, 57091,
            32497, 51567, 51361, 10257, 9147, 41209, 40319, 7159, 6035, 12320, 2948, 8913, 63446,
            33955, 30176, 33539, 24417, 12731, 10030, 14547, 44648, 4009, 48074, 39874, 18367,
            61065, 58508, 12900, 55669, 57835, 14509, 62532, 21599, 58550, 18193, 45887, 2996,
            27048, 30968, 3280, 16733, 45330, 46622, 21302, 199, 30809, 5961, 19489, 28107, 10620,
            40919, 44336, 51387, 47261, 8560, 33558, 35987, 46831, 50989, 17202, 10824, 4165,
            32156, 32741, 4824, 19954, 12555, 56038, 61215, 46504, 43945, 52040, 6544, 57173,
            39481, 41003, 23365, 10530, 46924, 58671, 12188, 36886, 55998, 58650, 32471, 15417,
            28067, 51352, 59311, 35919, 34593, 14706, 39574, 53868, 48757, 12920, 33149, 59406,
            48754, 39786, 12312, 58318, 14966, 37668, 46928, 65487, 22250, 24796, 7043, 49742,
            46495, 44245, 5372, 46169, 36046, 60670, 29615, 59474, 2630, 4376, 65427, 13583, 41975,
            15842, 27686, 33957, 45114, 56180, 24895, 4175, 40381, 32830, 48421, 52207, 58611,
            41821, 31373, 23853, 55119, 1957, 34877, 62496, 37311, 40303, 44876, 36839, 47492,
            53209, 24055, 39340, 21094, 12815, 18079, 3546, 9133, 45047, 41320, 3878, 13753, 38525,
            64568, 43355, 62649, 55650, 30889, 7989, 16810, 53928, 52810, 54272, 34111, 43130,
            14634, 55804, 24247, 2549, 37573, 53039, 1273, 63106, 10081, 35901, 22063, 65529,
            36398, 22557, 6548, 49942, 51535, 8125, 6097, 44735, 41844, 6924, 38812, 46284, 28742,
            15255, 52107, 18447, 53412, 25887, 55412, 63792, 34766, 5505, 60081, 60102, 22907,
            4472, 52200, 9287, 57769, 19130, 9576, 33612, 29442, 51950, 31312, 57224, 42421, 3948,
            27456, 17061, 26184, 43827, 38666, 45497, 49012, 31663, 20589, 33660, 6416, 42817,
            12859, 36023, 18361, 13106, 3948, 6069, 45466, 29677, 18064, 3643, 3116, 53510, 64358,
            43166, 45247, 20328, 64702, 19889, 60714, 32942, 45721, 46172, 65267, 36597, 16011,
            60612, 34941, 2235, 28718, 60810, 57652, 34739, 8085, 40064, 34439, 30836, 63285,
            49357, 36164, 40730, 6028, 20536, 7821, 11758, 13935, 41594, 5480, 50109, 45486, 34524,
            65518, 33646, 26927, 51166, 8137, 65325, 47159, 15817, 21430, 55199, 43094, 18188,
            10207, 9270, 12316, 59028, 45281, 65293, 18359, 26572, 1483, 37642, 33838, 30229,
            20598, 17948, 17913, 8381, 2294, 65136, 56785, 32374, 21420, 32944, 55524, 54245, 9455,
            19743, 46340, 44594, 34585, 20335, 47339, 56153, 6446, 38290, 11996, 3640, 19236,
            56251, 26006, 39485, 49775, 18442, 14177, 58677, 29326, 65175, 15895, 55082, 13796,
            36474, 17814, 15645, 18234, 33170, 51110, 44025, 25628, 50098, 4543, 11961, 5240,
            12269, 60922, 50694, 57333, 36294, 54967, 34897, 38937, 23327, 21211, 38130, 40763,
            28268, 32512, 44967, 13536, 14845, 33262, 60590, 42683, 51728, 39972, 55685, 7063,
            44366, 38396, 34545, 19207, 23781, 5187, 6760, 4664, 2548, 34910, 45079, 63988, 24389,
            33740, 46265, 48490, 13086, 13997, 4472, 58789, 42140, 38861, 56799, 27990, 2090,
            17510, 18149, 56801, 36116, 29, 27248, 14112, 43872, 56950, 31835, 54234, 60391, 61682,
            6150, 8409, 14113, 14813, 43837, 34413, 35895, 60346, 9764, 39419, 8802, 34406, 19505,
            46628, 3351, 48702, 8558, 5754, 2593, 60784, 39575, 1647, 5760, 16362, 63845, 48749,
            27443, 24090, 40960, 19478, 5559, 7717, 62950, 12398, 29842, 16378, 36410, 37918,
            22070, 37187, 2388, 2471, 59879, 9256, 16878, 28021, 9280, 63982, 3237, 64103, 60696,
            53445, 43639, 26328, 22322, 25785, 42833, 11185, 19944, 39503, 46656, 62113, 54641,
            39184, 38083, 52218, 10422, 19936, 38976, 37156, 53804, 24969, 32577,
        ]),
        c: 213,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_random_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("19b0167346cd2f1c984be3174c47724ddc1137b403532b6b12158e8005cf1539");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_lengthy_1() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([false, true, false, false, true]),
        b: Bitvector::<2>::from_iter([true, true]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([false, false, false, true, true, false]),
        e: Bitvector::<8>::from_iter([false, false, true, true, true, false, true, false]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_lengthy_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("105a099af0fed50f5972d242475878035e14d2322e5c2a12e8ac5cc41cdc9dbe");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_small_test_struct_max_6() {
    let value = SmallTestStruct { a: 65535, b: 65535 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SmallTestStruct_max_6/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SmallTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("5ee8ff3d8661977c818a2d7f926019872cfef9cf4270b99ff833160f41fc01ec");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_lengthy_8() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([true, true, true, false, true]),
        b: Bitvector::<2>::from_iter([true, false]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([true, false, false, true, true, true]),
        e: Bitvector::<8>::from_iter([false, false, false, false, false, true, false, false]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_lengthy_8/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("50c9c0adb3b583620b03914e9d06233cebfdc185c0b1dd3be2a00fe64d16d015");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_zero_3() {
    let value = VarTestStruct {
        a: 0,
        b: List::<u16, 1024>::from_iter([
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        ]),
        c: 0,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_zero_3/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("21a89163d6419cf2b1b80f4371602341016505eba8a183eebac76841fc29a77d");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_zero_chaos_2() {
    let value = ComplexTestStruct {
        a: 0,
        b: List::<u16, 128>::from_iter([
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        ]),
        c: 0,
        d: List::<u8, 256>::from_iter([0]),
        e: VarTestStruct {
            a: 0,
            b: List::<u16, 1024>::from_iter([
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            ]),
            c: 0,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 0,
                b: List::<u16, 1024>::from_iter([
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                ]),
                c: 0,
            },
            VarTestStruct {
                a: 0,
                b: List::<u16, 1024>::from_iter([
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                ]),
                c: 0,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_zero_chaos_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("0ec955700f739bb044257ec65d06df9ba2b4028dc074362e9ae558e313896af0");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_random_8() {
    let value = VarTestStruct {
        a: 27146,
        b: List::<u16, 1024>::from_iter([
            22447, 64070, 3185, 62696, 47496, 19881, 59400, 35567, 8927, 12773, 18897, 10230,
            64382, 59300, 18831, 59520, 9367, 47402, 6761, 8006, 22245, 16016, 13486, 6282, 23492,
            51927, 15216, 47571, 37250, 41454, 63626, 38860, 62393, 61579, 38901, 18485, 26811,
            9006, 16865, 61638, 60728, 61196, 27714, 10173, 46074, 38945, 35079, 60651, 19970,
            31751, 11585, 25248, 60548, 4715, 41360, 1418, 63052, 44162, 34875, 39425, 30674,
            10083, 35543, 28810, 13258, 54905, 51912, 42064, 42086, 35617, 63924, 37847, 35858,
            16198, 52392, 15619, 56332, 56708, 7220, 58504, 47340, 50459, 8003,
        ]),
        c: 87,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_random_8/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("2b40e3ede4edeb7bd1809b6b360acd0929eeea5556de2886b75b946058eccf94");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_zero_3() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([]),
        b: Bitvector::<2>::from_iter([false, false]),
        c: Bitvector::<1>::from_iter([false]),
        d: Bitlist::<6>::from_iter([false, false, false, false]),
        e: Bitvector::<8>::from_iter([false, false, false, false, false, false, false, false]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_zero_3/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("a08e590982dffd5e3b7a9410c9d86d152cfb2d342bd00eec228aab3e3c5ef64b");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_zero_4() {
    let value = VarTestStruct {
        a: 0,
        b: List::<u16, 1024>::from_iter([
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0,
        ]),
        c: 0,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_zero_4/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("95043ab51c19af41709a41bcecfe6b3efafc1eacf1ac3ea4185c0d26f175584f");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_small_test_struct_max_1() {
    let value = SmallTestStruct { a: 65535, b: 65535 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SmallTestStruct_max_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SmallTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("5ee8ff3d8661977c818a2d7f926019872cfef9cf4270b99ff833160f41fc01ec");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_zero_4() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([false, false, false]),
        b: Bitvector::<2>::from_iter([false, false]),
        c: Bitvector::<1>::from_iter([false]),
        d: Bitlist::<6>::from_iter([false, false, false]),
        e: Bitvector::<8>::from_iter([false, false, false, false, false, false, false, false]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_zero_4/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("7a14e144cf89605fa98f03d5315652596c9607d815e162b2d371d7bad872012d");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_random_6() {
    let value = SingleFieldTestStruct { a: 50 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_random_6/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("3200000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_random_1() {
    let value = ComplexTestStruct {
        a: 10570,
        b: List::<u16, 128>::from_iter([
            25130, 47018, 44501, 60270, 30202, 60019, 979, 5334, 4184, 39381, 16060, 48693, 2177,
            1624, 44145, 109, 26297, 3760, 45976, 26234, 12306, 35072, 23108, 359, 36205, 42375,
            43668, 49701, 5985, 17741, 35986, 50806, 40456, 11569, 7764, 49999, 31368, 7231, 60872,
            61541, 20524, 32048, 6712, 30223, 8153, 53195, 4763, 44163, 42869, 57362, 61754, 17873,
            33684, 10606, 30774, 54348, 33012, 632, 28777, 42496, 43559, 30314, 45073, 30845,
            40909, 26651, 302, 6161, 19181, 36556, 3936, 53923, 28705, 46409, 24161, 53550, 61875,
            42759, 7125, 12173, 29283, 64822, 63922, 44442, 43951, 37379, 46418, 2732, 16965, 9105,
            53923, 48096, 41181, 32866, 7869, 57048, 39161, 23300, 33355, 10982, 179, 44668, 34392,
            54101, 52667, 38022, 48921, 16050, 37525, 18046, 59409, 52990, 56338, 52766, 31686,
            28089,
        ]),
        c: 207,
        d: List::<u8, 256>::from_iter([
            137, 42, 38, 79, 48, 237, 43, 239, 229, 237, 68, 206, 34, 234, 199, 211, 147, 192, 39,
            165, 55, 93, 7, 85, 10, 185, 173, 224, 62, 43, 122, 41, 37, 183, 181, 15, 253, 188,
            120, 16, 63, 210, 198, 236, 94, 224, 242, 54, 162, 151, 152, 213, 4, 229, 175, 226, 79,
            117, 44, 79, 247, 141, 63, 149, 171, 2, 244, 32, 197, 157, 80, 239, 119, 21, 156, 216,
            54, 5, 234, 249, 161, 202, 102, 168, 153, 37, 122, 68, 63, 58, 154, 238, 33, 123, 245,
            154, 107, 192, 130, 189, 108, 149, 133, 164, 179, 144, 154, 127, 3, 98, 185, 42, 143,
            214, 108, 179, 159, 175, 87, 118, 202, 238, 226, 116, 70, 70, 77, 84, 25, 32, 154, 160,
            106, 161, 48, 152, 144, 22, 99, 110, 132, 226, 191, 247, 80, 83, 23, 89, 50, 144, 86,
            32, 117, 12, 24, 96, 212, 64, 137, 252, 114, 41, 165, 33, 239, 110, 158, 167, 118, 106,
            59, 3, 2, 24, 52, 146, 53, 174, 110, 120, 167, 96, 2, 216, 234, 165, 43, 77, 244, 88,
            7, 83, 239, 87, 77, 33, 155, 34, 49, 215, 159, 211, 137, 117, 70, 103, 91, 120, 158,
            116, 117, 187, 12, 80, 167, 32, 140, 4, 4, 151, 215, 20, 108, 68, 24, 82, 228, 177,
            171, 191, 154, 198, 1, 180, 218, 203, 252, 138, 37, 42, 40, 214, 78, 127, 146, 80,
        ]),
        e: VarTestStruct {
            a: 3432,
            b: List::<u16, 1024>::from_iter([
                28962, 11394, 22785, 28581, 55052, 43341, 53264, 30844, 33165, 28308, 54453, 13625,
                29292, 9763, 32817, 58460, 40141, 2448, 37496, 34081, 52786, 22210, 50500, 51413,
                29126, 36769, 43292, 18244, 20473, 47107, 50265, 2320, 56137, 2746, 50727, 48561,
                16565, 12005, 6276, 47926, 45147, 29886, 55396, 57000, 46288, 48724, 37089, 57406,
                48266, 59628, 28876, 21811, 31183, 14062, 53330, 10317, 45440, 62525, 35051, 20458,
                53646, 11341, 9604, 47082, 11580, 25609, 3262, 39181, 17010, 40443, 35122, 31288,
                22934, 9937, 4106, 15004, 59372, 16131, 12670, 39395, 28159, 58633, 6266, 4724,
                55914, 57012, 60243, 54445, 2377, 7458, 34134, 22124, 29976, 53635, 51503, 50312,
                4338, 2295, 62248, 23365, 9769, 8775, 11132, 14910, 41745, 1220, 31456, 39275,
                11531, 14984, 4258, 64746, 9235, 60642, 42010, 3378, 32360, 35392, 1838, 31984,
                46955, 29648, 15826, 64936, 62965, 53274, 21525, 52201, 33182, 39605, 24181, 56208,
                22404, 54333, 42895, 13863, 24206, 48662, 46263, 437, 2398, 22343, 20176, 18670,
                31807, 34037, 26311, 35649, 43253, 12343, 33593, 40178, 64534, 39707, 32148, 18244,
                922, 28452, 42570, 6781, 63724, 36488, 32874, 56549, 15519, 30726, 21572, 43165,
                64473, 16619, 48128, 12523, 33120, 61591, 42319, 41353, 59194, 15140, 38659, 51807,
                52366, 36837, 2052, 47911, 64953, 19816, 18801, 52259, 48898, 52463, 22137, 46456,
                58429, 17201, 1704, 61033, 63848, 47929, 43661, 60381, 19194, 15658, 38106, 26512,
                30627, 17027, 47403, 18228, 20276, 61936, 33212, 55972, 10184, 11399, 15291, 30938,
                30612, 5398, 6772, 58525, 31460, 46486, 44751, 50458, 7858, 43542, 50930, 56945,
                36025, 56677, 43487, 63408, 7428, 56091, 55253, 24345, 58999, 51149, 30080, 40324,
                10777, 56094, 5654, 9730, 59633, 26035, 350, 29364, 56062, 50655, 7435, 51169,
                1496, 55034, 19505, 28135, 36965, 42148, 12733, 11143, 34889, 3140, 24353, 25123,
                56868, 40242, 27381, 24145, 37854, 46609, 2021, 29877, 63279, 56335, 32920, 39475,
                31007, 10330, 15026, 29818, 32041, 23646, 54540, 63584, 32148, 57607, 27323, 42202,
                33253, 7571, 19501, 31928, 43882, 54288, 11689, 28873, 18582, 11100, 15274, 56066,
                16607, 63103, 52394, 23088, 5934, 47019, 23313, 21529, 53968, 28636, 36481, 7394,
                1669, 47058, 25922, 12435, 14106, 25807, 45774, 56007, 57169, 22425, 14315, 10015,
                5277, 31002, 22866, 20440, 59011, 59782, 40484, 47772, 57785, 42650, 34494, 13672,
                29484, 22960, 42630, 64849, 5875, 26200, 48552, 52253, 57580, 26786, 58474, 16470,
                41167, 50301, 26638, 43149, 38135, 51118, 61197, 61726, 11527, 47401, 12013, 41462,
                63503, 1895, 11848, 22852, 12088, 54598, 2239, 48127, 54869, 53764, 34984, 64819,
                24276, 58233, 29952, 31711, 25194, 46704, 21808, 45102, 39954, 11449, 25982, 58525,
                15035, 34896, 58909, 907, 12615, 17652, 33350, 64545, 59993, 16195, 60900, 28750,
                8007, 7691, 62983, 42024, 58583, 36933, 42557, 52132, 54761, 15056, 12448, 13142,
                65283, 27373, 26369, 16552, 15685, 51428, 21993, 18847, 61140, 14492, 56600, 17930,
                26404, 42741, 50153, 54872, 4911, 19672, 10882, 30084, 40005, 37122, 5487, 13875,
                9070, 3529, 60893, 41929, 26048, 36420, 20226, 12206, 15736, 9007, 56187, 22710,
                29413, 26169, 42891, 31453, 52558, 16561, 48212, 32197, 63461, 65495, 55719, 34166,
                27183, 6277, 10330, 30055, 24421, 39894, 1590, 50974, 9457, 61119, 6175, 6847,
                56281, 41441, 55740, 61464, 17539, 35962, 55569, 14010, 50314, 49065, 308, 46191,
                20862, 64832, 3597, 32058, 59561, 30926, 52830, 3180, 56167, 58450, 39944, 51675,
                26064, 49070, 58947, 52813, 62294, 36713, 48767, 22670, 11739, 24851, 3258, 40199,
                44300, 58863, 57240, 16157, 61144, 53112, 39023, 57596, 22055, 38379, 17467, 23479,
                32534, 15470, 46976, 60539, 36433, 55438, 62731, 21650, 22672, 23007, 56552, 15111,
                30304, 845, 57614, 27431, 8468, 61481, 62207, 46583, 8118, 34734,
            ]),
            c: 230,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 231,
                b: 1863231633934349380,
                c: 2790073216,
            },
            FixedTestStruct {
                a: 37,
                b: 14159239175366384790,
                c: 3878144546,
            },
            FixedTestStruct {
                a: 172,
                b: 10223347348532532647,
                c: 3873962530,
            },
            FixedTestStruct {
                a: 228,
                b: 6481981747729743213,
                c: 817324705,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 33242,
                b: List::<u16, 1024>::from_iter([
                    47227, 37536, 46215, 50335, 52121, 8097, 64235, 27197, 7249, 8568, 16725,
                    16612, 42968, 20796, 6356, 31220, 27948, 4246, 33344, 40546, 60800, 32272,
                    34461, 51856, 24106, 11988, 3380, 5730, 45737, 30833, 1965, 21053, 13204,
                    50503, 40670, 51104, 42160, 56854, 31896, 62806, 35065, 62865, 19119, 13151,
                    50686, 34188, 17170, 63895, 5483, 36547, 18355, 61042, 55214, 48008, 27449,
                    36858, 5832, 5827, 58798, 30184, 14349, 29998, 58597, 26956, 21310, 38282,
                    9582, 47665, 22322, 40639, 2660, 9370, 56242, 5313, 60678, 3524, 32640, 22397,
                    48941, 6325, 43146, 47535, 34380, 23938, 52169, 42240, 19029, 87, 65211, 16723,
                    22411, 9044, 48028, 5360, 21489, 54014, 25091, 40209, 56957, 30166, 61763,
                    12538, 57745, 18461, 950, 5884, 61044, 15658, 9510, 37657, 5342, 46055, 33064,
                    49596, 49727, 16553, 53187, 39859, 55016, 27294, 10467, 33639, 6496, 21574,
                    3319, 28053, 61240, 14564, 22446, 62825, 63701, 41076, 65331, 25976, 28935,
                    46190, 59052, 5978, 4937, 29649, 21714, 43348, 59083, 48671, 54719, 54919,
                    62564, 15064, 15492, 10310, 23814, 58312, 15505, 35497, 64466, 20340, 51492,
                    55526, 47630, 40920, 56527, 7780, 54246, 35602, 1091, 24618, 28046, 3956,
                    62891, 32475, 39197, 10864, 44184, 459, 56445, 4644, 48076, 64797, 5477, 9971,
                    908, 46855, 10116, 57495, 4787, 10777, 33486, 33706, 63880, 35814, 38102,
                    44108, 20955, 12199, 3413, 37589, 20131, 28128, 19806, 44211, 225, 6181, 58015,
                    61157, 672, 1685, 47442, 56517, 38923, 38796, 47968, 40714, 52112, 51923, 3279,
                    20351, 62297, 13769, 53676, 1685, 18586, 40550, 35681, 1342, 15790, 54458,
                    54743, 41973, 6767, 32012, 29117, 6801, 24552, 52877, 46380, 15752, 60197,
                    16849, 37141, 32613, 64372, 64207, 27250, 49276, 30880, 26452, 25222, 62169,
                    9643, 26537, 7274, 21835, 10792, 38833, 33229, 53399, 56249, 27836, 42095,
                    1994, 55040, 65447, 42454, 28826, 53882, 16933, 36202, 41189, 58201, 5221,
                    22199, 30992, 52153, 60946, 27007, 43634, 29485, 15687, 42811, 48721, 37314,
                    41995, 53486, 5561, 4448, 36422, 58238, 32123, 60207, 18145, 1022, 23369,
                    11938, 33743, 39376, 19270, 7173, 33603, 58949, 3060, 10799, 27215, 49617,
                    13604, 35875, 24198, 56380, 48764, 61890, 21136, 23821, 32848, 16553, 10389,
                    34924, 64208, 43619, 40757, 9632, 34271, 21110, 24100, 24558, 22422, 43760,
                ]),
                c: 230,
            },
            VarTestStruct {
                a: 41398,
                b: List::<u16, 1024>::from_iter([
                    37637, 60630, 5618, 16275, 48590, 34771, 14023, 39677, 5882, 7409, 6483, 11030,
                    44489, 14753, 6355, 47920, 47286, 49687, 32520, 46974, 52864, 46905, 9705,
                    35634, 29235, 28158, 31341, 3993, 20930, 61867, 60115, 64147, 52387, 24318,
                    23065, 2287, 47151, 7115, 60782, 33894, 54203, 20345, 12088, 43785, 52419,
                    35442, 57189, 64822, 11974, 18782, 19726, 27342, 4934, 35411, 51636, 42411,
                    32915, 3358, 31351, 6191, 54101, 38763, 41845, 32368, 37795, 60060, 26247,
                    37383, 37831, 30981, 59295, 34278, 54376, 51426, 9390, 6193, 10660, 39178,
                    17982, 45343, 30696, 37725, 8853, 39267, 30340, 54863, 31520, 57111, 20655,
                    39748, 37100, 38122, 43901, 41022, 64161, 40570, 50122, 17037, 33987, 45478,
                    29723, 22592, 36173, 5241, 45030, 33006, 28014, 31705, 52871, 52245, 65263,
                    21204, 43385, 43900, 35230, 1496, 23777, 407, 43493, 49471, 41992, 44179,
                    32461, 9755, 55182, 28242, 1552, 44445, 20009, 48914, 8957, 3780, 30400, 50764,
                    52875, 34390, 64667, 41288, 14196, 8323, 13296, 12300, 44106, 37447, 31824,
                    19937, 7562, 55441, 19922, 65393, 62069, 54216, 53575, 29471, 35523, 40855,
                    38995, 4949, 61856, 56360, 47382, 8932, 64144, 26639, 20860, 28353, 28778,
                    29764, 8993, 49287, 47173, 33950, 31589, 4833, 5994, 18852, 57108, 38201,
                    15181, 10162, 11260, 6547, 26391, 62446, 9488, 17658, 22078, 45846, 40070,
                    59120, 8767, 64778, 14054, 3636, 28072, 5851, 30583, 2158, 34866, 31945, 30376,
                    61634, 41102, 64409, 22678, 18643, 21341, 24406, 11231, 51896, 62418, 32255,
                    42126, 4962, 22672, 43634, 27654, 5928, 4376, 1987, 55380, 19561, 62886, 59174,
                    25333, 9510, 2132, 2378, 26809, 44758, 36510, 28142, 12136, 9685, 32159, 42256,
                    57679, 8624, 58299, 49729, 28094, 52092, 20607, 53823, 43603, 19836, 54095,
                    43940, 6498, 37425, 46432, 63707, 2048, 30217, 31148, 15431, 65083, 4044,
                    27107, 54770, 1634, 26113, 16574, 19206, 305, 14190, 13627, 24517, 59034, 2066,
                    5421, 59845, 36560, 44348, 28794, 12620, 46123, 56797, 17640, 42063, 35763,
                    31669, 43113, 41417, 13979, 44036, 48544, 45906, 35142, 39080, 42813, 3177,
                    53424, 57840, 25764, 43201, 59484, 20364, 32041, 3452, 36433, 21146, 6679,
                    13195, 16593, 26660, 5250, 49757, 30435, 9150, 56914, 14896, 53146, 63927,
                    52958, 1, 16821, 24439, 64956, 3804, 21930, 15532, 47984, 8884, 56988, 48868,
                    35611, 5493, 63657, 41499, 55380, 37728, 16769, 23559, 57683, 3921, 49532,
                    9588, 49903, 3020, 42334, 58957, 31275, 38661, 19234, 44853, 20525, 62481,
                    28416, 26298, 58537, 60679, 56277, 19174, 41894, 17873, 64750, 9105, 19665,
                    14539, 14113, 13899, 48921, 48840, 45740, 54161, 5994, 21812, 15017, 18290,
                    57281, 36714, 37001, 24523, 1796, 43725, 41057, 8742, 12975, 21189, 57679,
                    10027, 5673, 28958, 49524, 3221, 11316, 20434, 60805, 52210, 2892, 165, 50601,
                    44737, 2009, 16262, 32961, 50653, 35491, 15144, 1324, 61353, 43976, 38280,
                    8077, 21034, 20250, 7650, 48293, 29649, 34225, 5844, 3954, 29912, 2764, 32640,
                    18295, 37007, 8517, 7629, 40727, 37087, 30131, 3188, 63417, 35393, 14949,
                    65277, 53493, 64264, 38666, 28457, 48270, 34153, 5336, 31342, 1547, 1619,
                    44200, 57020, 49459, 37090, 9735, 36668, 36033, 4790, 8294, 52302, 37213,
                    32977, 38690, 36723, 12201, 60669, 61855, 51776, 56089, 65300, 24103, 11179,
                    432, 29915, 53512, 34900, 31077, 13491, 34671, 28147, 56567, 1360, 37625,
                    26580, 34806, 491, 18534, 57752, 45232, 37461, 55246, 61194, 23002, 34230,
                    18780, 28938, 46672, 38195, 31766, 28682, 38892, 55873, 5043, 37855, 36346,
                    56134, 7852, 48611, 23716, 61276, 10763, 48469, 30334, 30417, 58174, 45328,
                    60762, 52074, 47252, 61442, 43105, 39409, 57960, 64420, 65204, 32094, 20482,
                    22905, 13343, 46177, 5213, 19893, 31472, 47764, 56937, 20526, 49572, 34134,
                    53627, 31468, 40245, 27105, 51064, 15981, 9629, 24690, 1030, 18771, 44540,
                    36668, 11054, 27243,
                ]),
                c: 247,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_random_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("7c29a9a223e62fb6fd23a50ee5dab5de6de62ec44f9a9785e203123599b68bc3");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_one_9() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([false]),
        b: Bitvector::<2>::from_iter([true, false]),
        c: Bitvector::<1>::from_iter([false]),
        d: Bitlist::<6>::from_iter([true]),
        e: Bitvector::<8>::from_iter([false, false, true, false, false, false, false, false]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_one_9/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("6d9ba4547518645f70c84b158d170837d2a6627f4dc9b851f46d2487b3b94af4");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_max_4() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([true, true, true]),
        b: Bitvector::<2>::from_iter([true, true]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([true, true]),
        e: Bitvector::<8>::from_iter([true, true, true, true, true, true, true, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_max_4/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("c91372ca27e8e68838e9afd761fa5e4adbb48e4a2e2ea9377a863b4c1a41b880");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_max_chaos_0() {
    let value = FixedTestStruct {
        a: 255,
        b: 18446744073709551615,
        c: 4294967295,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_max_chaos_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("3925681862db7892428eac4afae08671930e623601b5b85fbbc366371e29acd7");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_random_6() {
    let value = ComplexTestStruct {
        a: 56082,
        b: List::<u16, 128>::from_iter([
            16100, 22857, 27807, 34340, 18934, 15120, 29987, 2470, 46665, 59647, 31943, 45611,
            58344, 27670, 50944, 47092, 21665, 36667, 42227, 41577, 12512, 596, 62087, 38343,
            31525, 9968, 45121, 40434, 32084, 5333, 4835, 3339, 38395, 20109, 58009, 60253, 3746,
            13519, 13381, 18659, 23803, 44518, 2163, 32548, 22246, 23513, 46382, 41869, 50979,
            65142, 44880, 7016, 22020, 29275, 21014, 46115, 44108, 60556, 28879, 43476, 62973,
            33776, 18845, 11764, 21132, 34696, 27081, 29853, 43833, 22089, 54364, 22524, 48064,
            11065, 34923, 31045, 19944, 21676, 57420, 29950, 31156, 23207, 53147, 36016, 8072,
            8802, 30624, 746, 39360, 48449, 47030, 56748, 63276,
        ]),
        c: 168,
        d: List::<u8, 256>::from_iter([
            40, 41, 197, 38, 95, 95, 2, 105, 184, 76, 97, 39, 73, 184, 37, 136, 136, 110, 210, 118,
            215, 74, 142, 13, 197, 139, 95, 107, 119, 111, 26, 254, 80, 89, 236, 205, 186, 139, 39,
            51, 94, 149, 164, 178, 230, 135, 193, 198, 60, 14, 218, 149, 132, 85, 23, 199, 210,
            226, 118, 31, 56, 216, 11, 255, 151, 87, 151, 247, 184, 3, 165, 107, 241, 90, 168, 8,
            147, 188, 31, 135, 132, 23, 116, 141, 64, 10, 255, 176, 119, 227, 129, 51, 94, 193,
            154, 121, 153, 218, 196, 184, 54, 166, 186, 114, 32, 243, 54, 12, 70, 207, 234, 14, 35,
            181, 112, 105, 210, 174, 163, 42, 243, 165, 96, 136, 231, 207, 198, 179, 141, 160, 122,
            168, 12, 200, 212, 185, 22, 118, 247, 54, 107, 152, 167,
        ]),
        e: VarTestStruct {
            a: 11429,
            b: List::<u16, 1024>::from_iter([
                60109, 40769, 46399, 40756, 54364, 14755, 50154, 2464, 1212, 36993, 15934, 14639,
                39209, 27684, 14374, 35993, 10919, 51667, 30710, 27337, 35066, 29087, 42877, 31353,
                59108, 5772, 31403, 56426, 36255, 2499, 40269, 61875, 14862, 55082, 12666, 40997,
                32483, 5102, 29843, 44065, 62507, 22572, 14565, 40211, 63852, 40161, 26729, 27975,
                34763, 41474, 13844, 49887, 62325, 43565, 55572, 10575, 55219, 31844, 56829, 61982,
                8771, 45842, 21991, 15880, 54050, 20851, 54799, 31339, 54890, 46122, 51850, 58914,
                2017, 39112, 54124, 47541, 44552, 5427, 7523, 29640, 51044, 54296, 31402, 59264,
                25986, 51517, 8277, 9171, 20055, 31198, 53559, 8724, 18988, 58309, 36392, 30245,
                10592, 42461, 48509, 4718, 34309, 20621, 27109, 39094, 1022, 58534, 17763, 16513,
                45819, 39001, 53091, 55842, 4204, 50292, 24274, 47003, 42656, 25870, 52020, 21053,
                46432, 10180, 9480, 34172, 26850, 4541, 49254, 16630, 40105, 35609, 1479, 29030,
                900, 64758, 28345, 26429, 2734, 39968, 53604, 33270, 28230, 10428, 44780, 27263,
                54066, 39925, 22898, 52924, 30209, 59795, 5412, 26053, 49646, 62122, 48129, 35818,
                46169, 55076, 45832, 21972, 3104, 5797, 30916, 46820, 53916, 36058, 6868, 49186,
                54491, 29663, 12432, 62953, 58052, 39803, 37474, 11824, 41000, 7692, 40243, 38171,
                14003, 17490, 46196, 64915, 6431, 36061, 45610, 43994, 35390, 25523, 26079, 21393,
                28906, 23901, 31445, 17045, 52356, 21030, 55380, 48331, 16940, 48799, 58154, 32164,
                19082, 39629, 63652, 63132, 13473, 1364, 57314, 23750, 1810, 43481, 37305, 52627,
                9392, 58872, 53894, 46152, 45875, 34605, 44743, 57919, 60216, 57430, 29934, 29802,
                44241, 57402, 29074, 64833, 58200, 28698, 56489, 59917, 38441, 2832, 46336, 21703,
                40717, 60689, 41146, 25148, 37711, 20280, 65169, 37198, 47577, 10489, 7122, 10868,
                21298, 48235, 33165, 19746, 43817, 43550, 47763, 41143, 20578, 64962, 29759, 47455,
                57859, 6635, 17711, 29993, 13215, 28406, 47882, 8564, 51741, 58231, 44409, 23398,
                28637, 24610, 44549, 63219, 63341, 28771, 17697, 53943, 42839, 23415, 20512, 14303,
                58799, 19909, 32500, 45613, 9698, 7229, 20909, 18416, 13781, 44003, 37876, 46575,
                3038, 11285, 25808, 18171, 45806, 57529, 7098, 61748, 45637, 25942, 7953, 36145,
                50040, 34868, 64094, 47417, 38691, 51227, 1536, 17259, 24120, 41457, 56671, 13966,
                1174, 2387, 17070, 64206, 44057, 46027, 28588, 21394, 19856, 16102, 4257, 34921,
                22595, 59352, 57474, 50989, 12619, 64380, 38802, 1453, 28019, 46175, 38494, 63087,
                3317, 25228, 5061, 6857, 2720, 11644, 10185, 48463, 860, 28939, 18110, 46013,
                57306, 23289, 37649, 2141, 10370, 59391, 20084, 52753, 11556, 40070, 14866, 35041,
                25792, 14187, 45309, 27530, 3086, 12714, 39807, 20461, 43265, 45510, 28492, 19647,
                31047, 42926, 59070, 38759, 50348, 54563, 54077, 59543, 35695, 22876, 63822, 26594,
                14422, 63493, 17703, 27724, 51362, 11687, 26337, 23525, 1101, 55583, 51781, 16023,
                23421, 9737, 13157, 51954, 6741, 3529, 52313, 27377, 3865, 46942, 45209, 28247,
                33929, 62684, 24120, 8762, 40347, 46217, 10954, 35789, 61978, 47615, 20503, 37495,
                9803, 519, 45395, 7594, 57011, 39206, 46855, 20502, 61895, 17227, 59147, 19898,
                37317, 41325, 45616, 56104, 36278, 55740, 53453, 36719, 34719, 39113, 18132, 29006,
                37500, 46312, 58213, 49214, 48729, 2111, 8067, 47898, 57516, 61328, 2473, 52107,
                10288, 36501, 17254, 54973, 29799, 25435, 46730, 21493, 29954, 11644, 65224, 51985,
                61765, 56600, 31555, 760, 31761, 65476, 52084, 57730, 46812, 28512, 37606, 11305,
                64521, 9535, 43867, 46039, 21311, 7189, 50903, 33032, 30180, 24892, 18303, 43250,
                51003, 2353, 101, 40042, 20819, 31079, 15497, 24071, 4230, 30715, 53670, 42124,
                55028, 6882, 19357, 36370, 32944, 1660, 5756, 748, 20482, 49167, 3140, 11548,
                10076, 29953, 33585, 46644, 30843, 7781, 6809, 2134, 25327, 47376, 41257, 39430,
                51286, 17936, 32262, 63837, 56966, 317, 64489, 11660, 29588, 277, 49999, 16712,
                48048, 10742, 26833, 39029, 10154, 22940, 5028, 34882, 1087, 14107, 50349, 40229,
                2318, 13391, 9539, 35939, 6920, 45422, 10917, 23853, 30605, 17288, 5432, 40796,
                9667, 16573, 8351, 55697, 4253, 33724, 6543, 42128, 62401, 35278, 30338, 9506,
                35655, 58431, 42941, 11053, 500, 46484, 20741, 34337, 2317, 3187, 33738, 25311,
                11821, 63656, 38232, 39161, 47836, 32621, 19988, 5037, 14530, 45416, 26008, 23924,
                1994, 64224, 19500, 56883, 56009, 55221, 53206, 42436, 56981, 20695, 3758, 36394,
                35154, 48634, 63340, 32711, 27716, 37784, 39640, 40504, 35772, 31659, 32637, 36833,
                47472, 19880, 45447, 10695, 34458, 63716, 44762, 5507, 28180, 3823, 30626, 38140,
                37042, 39212, 35480, 45559, 15401, 37524, 28408, 51096, 40489, 53487, 41212, 60999,
                31696, 42933, 21149, 45805, 15412, 62896, 62451, 33440, 64374, 12928, 50948, 45095,
                18714, 39236, 37743, 7906, 16113, 55455, 45351, 62767, 47743, 28792, 50466, 3907,
                5872, 64569,
            ]),
            c: 101,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 222,
                b: 15123379162607136266,
                c: 1353896497,
            },
            FixedTestStruct {
                a: 133,
                b: 12301823266505627415,
                c: 2049419971,
            },
            FixedTestStruct {
                a: 74,
                b: 14612473027338292713,
                c: 3280573163,
            },
            FixedTestStruct {
                a: 182,
                b: 13293144499800156659,
                c: 1044267296,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 39096,
                b: List::<u16, 1024>::from_iter([
                    47532, 38310, 11840, 11592, 469, 61623, 49907, 61644, 16027, 49338, 26917,
                    37058, 43868, 56308, 35037, 41241, 42071, 16557, 41814, 8749, 19464, 25529,
                    25666, 40039, 17818, 23454, 23260, 57082, 3694, 56932, 40871, 37605, 21584,
                    62023, 37510, 58767, 1740, 49525, 7762, 30260, 65402, 22805, 30770, 44599,
                    45778, 24465, 46478, 43863, 65460, 38184, 63704, 41862, 20097, 56089, 41588,
                    7427, 11636, 23305, 57184, 6169, 43277, 46876, 866, 942, 16690, 5511, 63265,
                    50351, 45473, 42186, 3573, 17690, 27032, 32319, 45154, 62190, 18710, 27725,
                    17911, 10316, 42125, 27374, 57853, 34124, 24971, 52653, 49910, 16461, 16134,
                    32588, 61027, 46832, 34179, 40576, 11813, 32137, 8074, 27030, 42590, 45711,
                    54805, 47087, 25417, 45070, 44553, 33690, 1476, 57171, 44579, 9033, 46690,
                    39935, 59737, 52755, 51391, 41295, 41330, 55941, 31939, 60444, 36601, 6926,
                    13523, 40091, 45339, 61991, 40007, 64321, 49560, 15169, 51322, 58774, 37107,
                    45583, 26297, 54708, 15267, 60625, 26517, 12538, 34030, 11853, 35855, 40582,
                    21421, 21490, 10358, 65012, 3368, 36628, 30058, 21475, 49777, 64440, 43991,
                    38963, 53494, 41266, 46001, 62084, 8817, 55638, 33082, 49874, 54457, 24837,
                    14921, 3546, 37103, 31542, 9459, 45588, 57889, 54278, 19541, 35765, 34527,
                    22277, 6360, 50737, 711, 18118, 46590, 54432, 53814, 51163, 11539, 24925,
                    44565, 37206, 26721, 5775, 25630, 46440, 715, 13361, 35588, 17454, 52223,
                    63509, 36023, 28724, 7212, 45929, 7093, 13976, 26737, 53576, 39567, 47240,
                    3399, 2570, 65470, 57086, 21490, 48871, 22074, 10452, 57419, 50547, 26682,
                    56144, 32132, 31349, 31428, 60860, 63913, 16701, 15163, 62923, 46513, 22322,
                    20280, 61732, 35918, 62171, 11841, 33745, 33886, 44409, 17300, 24502, 53435,
                    30350, 61009, 59322, 22652, 59882, 50889, 29382, 62177, 42818, 29659, 12527,
                    49610, 49504, 54014, 31847, 56059, 569, 46255, 12576, 14335, 62835, 23626,
                    18121, 62389, 63161, 19213, 11139, 48834, 27132, 38294, 311, 43846, 38965,
                    45448, 10736, 59742, 21994, 42385, 17169, 44705, 53907, 16422, 26005, 65396,
                    35343, 19231, 58743, 56975, 40844, 2550, 34550, 6201, 11680, 1627, 26935,
                    64630, 13940, 57153, 40641, 25861, 32773, 30797, 56282, 50811, 59832, 47756,
                    40228, 3679, 15430, 46829, 4476, 41464, 30031, 33894, 3082, 20909, 30595,
                    41297, 1935, 11186, 45945, 22677, 48425, 56310, 27995, 45984, 64564, 23437,
                    15856, 376, 22595, 46436, 54846, 61800, 13210, 55192, 2145, 15867, 43340,
                    19287, 58291, 51954, 32430, 40773, 27789, 45920, 38315, 27976, 865, 23067,
                    60034, 52964, 32871, 65017, 54288, 22730, 53655, 15956, 46364, 33889, 48645,
                    3575, 47240, 12690, 44880, 61855, 39332, 12337, 3796, 17014, 32757, 53382,
                    27373, 48405, 51912, 25461, 18008, 9758, 56914, 23441, 38416, 53458, 26875,
                    56623, 37735, 1106, 40434, 49852, 13272, 35545, 42887, 14662, 40822, 21207,
                    16350, 52258, 47876, 29357, 63271, 34551, 59103, 1705, 49636, 26140, 51260,
                    47625, 45058, 55421, 17852, 130, 55603, 58211, 35244, 9802, 19550, 13156,
                    31748, 20604, 36363, 32394, 47311, 61977, 1320, 24478, 6849, 3493, 39758,
                    65307, 32498, 63115, 20745, 22748, 37608, 8312, 35439, 46642, 56304, 33462,
                    7710, 31596, 26039, 10265, 35734, 36134, 31444, 3555, 43971, 43202, 43305,
                    9362, 37528, 38184, 35015, 8089, 8947, 3778, 2872, 55387, 43079, 14895, 58214,
                    35030, 30203, 48410, 58640, 59856, 9390, 41965, 10568, 14369, 29385, 26143,
                    6191, 19045, 9739, 35007, 35051, 65360, 51280, 64462, 417, 54846, 38325, 65258,
                    20017, 7246, 15520, 59245, 48884,
                ]),
                c: 181,
            },
            VarTestStruct {
                a: 38223,
                b: List::<u16, 1024>::from_iter([
                    5078, 33434, 40974, 12861, 22394, 56300, 44801, 7123, 45572, 52308, 40807,
                    3493, 48886, 3940, 18613, 26392, 12954, 58150, 22535, 15141, 14353, 34568,
                    5140, 33061, 42050, 222, 56269, 22014, 15367, 23727, 29954, 10957, 50158,
                    25117, 37952, 29924, 31698, 52634, 60633, 29668, 42847, 57732, 14741, 45137,
                    45876, 30641, 46256, 60313, 10369, 60296, 14824, 39076, 35703, 15327, 61517,
                    53968, 18262, 48816, 64261, 4225, 52297, 24968, 46731, 45883, 32368, 23481,
                    7710, 53869, 44403, 63559, 13037, 30310, 24176, 19340, 1609, 20624, 60769,
                    56915, 58478, 33712, 35868, 1383, 44415, 27418, 4835, 20124, 54465, 12941,
                    60505, 31993, 61029, 51639, 60735, 5170, 14228, 38317, 36735, 23988, 23534,
                    1572, 12474, 47683, 53173, 29696, 31315, 14715, 30743, 52757, 6495, 26642,
                    38707, 49754, 884, 47564, 22209, 12685, 32687, 9040, 52980, 36502, 42059,
                    18218, 5867, 59198, 5543, 57792, 34772, 60792, 30934, 19458, 58984, 34757,
                    13434, 50929, 10068, 37958, 38209, 61035, 43630, 24939, 15188, 43949, 5392,
                    58805, 44519, 42242, 33351, 19984, 46339, 12170, 32558, 28737, 20471, 27073,
                    8747, 51893, 33789, 50217, 29880, 39244, 55549, 9906, 23468, 21564, 39514,
                    3538, 496, 29247, 33027, 16765, 11771, 6754, 28493, 43204, 36568, 18739, 26868,
                    39761, 51957, 46326, 13487, 56253, 12066, 34608, 34664, 63073, 27848, 59618,
                    40095, 2098, 38457, 36086, 8412, 34675, 24069, 14637, 32751, 42661, 48717,
                    54862, 44866, 11369, 26564, 8032, 3474, 27864, 61073, 4585, 1981, 56747, 14372,
                    24057, 37663, 6864, 20457, 57876, 56687, 28893, 36773, 34602, 38592, 20539, 44,
                    26662, 65056, 11589, 25283, 60360, 58177, 42948, 29815, 7773, 44818, 30993,
                    56295, 10455, 62408, 328, 29491, 2300, 21072, 12450, 10602, 38200, 18317,
                    51447, 48975, 58303, 65519, 59005, 20637, 11803, 14445, 3742, 50580, 45846,
                    3151, 13312, 41621, 18102, 27387, 24634, 29568, 47549, 12592, 28440, 18599,
                    61206, 33614, 20136, 18281, 13331, 1323, 33935, 32131, 57383, 41544, 12392,
                    48431, 22301, 14528, 16018, 65209, 32376, 42426, 47698, 32853, 56741, 54779,
                    6409, 9829, 38179, 3275, 18353, 21512, 62518, 2467, 22415, 65086, 56003, 59330,
                    38995, 62356, 44340, 4130, 17221, 39589, 29757, 64864, 10488, 13534, 1576,
                    12041, 49624, 30253, 90, 11287, 5595, 60461, 4469, 57154, 56043, 28711, 29304,
                    26712, 60310, 59433, 32725, 21522, 8517, 31293, 51504, 63333, 63611, 46241,
                    2279, 8302, 24105, 43332, 25429, 48327, 41648, 38022, 46441, 63420, 7988,
                    13751, 7908, 56906, 32998, 5488, 21060, 30701, 53544, 35117, 46511, 24316,
                    10634, 38944, 3325, 29584, 48800, 12977, 63867, 61882, 33782, 58423, 53522,
                    11685, 11320, 42282, 41308, 37014, 62120, 7496, 35660, 49308, 12485, 38555,
                    32241, 25401, 56247, 31195, 12137, 25727, 48105, 28020, 30806, 63222, 65509,
                    13275, 30811, 44812, 26557, 2288, 50631, 59536, 12184, 50965, 59295, 39461,
                    41675, 61012, 35958, 25508, 14033, 58216, 59021, 43365, 46666, 27207, 10699,
                    904, 46546, 51842, 9621, 35291, 2728, 22417, 51561, 48692, 26054, 12037, 58524,
                    27047, 37005, 12523, 49344, 8493, 45596, 34948, 35244, 4823, 34631, 53606,
                    13865, 13199, 50519, 53984, 8566, 53831, 59750, 31949, 45881, 33739, 55355,
                    19664, 2750, 32342, 10813, 57648, 54334, 50656, 44969, 38621, 18149, 47740,
                    40327, 62600, 29955, 45508, 27697, 18509, 11655, 60093, 2851, 3594, 58830,
                    17466, 11472, 27443, 21810, 32487, 35764, 20858, 30826, 5069, 60940, 54966,
                    45899, 38522, 65346, 33917, 55533, 18830, 5978, 20715, 41704, 46018, 59850,
                    49630, 57108, 42312, 11541, 10152, 39108, 28724, 43661, 42906, 60771, 61287,
                    17566, 52887, 56450, 8683, 6633, 64194, 42012, 35214, 65394, 39797, 28253,
                    52835, 30726, 14013, 49892, 32969, 27705, 10921, 56995, 21051, 14409, 62434,
                    19748, 53963, 32044, 17003, 4488, 56800, 28496, 47074, 46312, 41792, 8267,
                    14566, 61835, 4262, 25737, 41313, 20863, 54045, 26891, 48484, 56404, 15748,
                    36192, 30175, 19914, 60233, 64930, 10483, 47069, 45904, 65413, 60672, 55080,
                    41007, 48128, 6070, 31624, 22731, 22469, 6073, 10766, 40073, 26700, 60161,
                    16290, 3795, 52035, 17291, 4152, 56414, 21318, 58001, 61727, 9740, 40194,
                    52455, 64347, 27221, 59041, 19095, 58610, 4366, 50095, 63260, 55737, 60937,
                    7222, 51754, 1108, 18973, 14077, 31157, 45997, 20645, 41240, 36439, 16135,
                    61571, 21045, 27703, 12363, 36386, 39286, 65410, 60890, 20350, 43267, 10669,
                    12243, 21158, 59186, 12638, 36701, 26560, 61417, 28835, 41381, 28053, 20393,
                    17703, 23909, 51913, 6918, 47017, 6885, 23656, 20831, 43054, 37613, 52560,
                    33514, 8989, 32310, 1298, 35171, 16171, 52683, 3297, 53769, 36205, 58958,
                    59415, 30566, 18349, 16569, 46120, 8668, 48644, 21468, 40978, 7834, 16466,
                    34612, 43494, 50607, 45423, 21905, 61423, 2783, 24196, 38257, 29335, 50288,
                    16685, 62897, 46316, 33355, 46608, 13827, 37696, 31120, 32772, 46822, 63564,
                    36404, 56740, 14611, 37355, 61409, 2265, 41750, 40866, 46534, 33758, 52433,
                    41622, 33281, 51011, 61997, 48199, 52823, 58395, 28191, 43893, 21034, 17496,
                    11992, 37674, 20854, 16846, 47118, 40681, 18949, 23045, 39577, 11889, 38199,
                    64960, 30494, 60573, 58008, 46796, 10877, 21882, 14735, 35892, 62994, 39881,
                    59415, 25418, 46530, 62264, 55770, 40414, 18337, 53684, 51738, 10026, 46718,
                    28596, 29473, 8228, 2258, 44354, 42402, 59577, 21544, 57265, 30307, 65156,
                    32329, 18486, 30384, 48616, 33690, 57627, 62515, 40417, 12520, 16990, 60549,
                    7877, 39042, 31668, 53799, 33442, 8452, 33676, 1684, 9274, 40279, 28787, 62165,
                    15875, 25232, 64774, 21820, 1073, 20019, 4589, 64738, 56552, 62726, 44483,
                    50846, 659, 19753, 10017, 6086, 45600, 36665, 61487, 14711, 36820, 7006, 3134,
                    43946, 413, 13265, 14490, 31396, 18428, 64861, 44336, 62908, 24269, 16313,
                    14633, 33920, 32136, 12444, 15697, 6174, 22281, 3076, 25048, 19740, 27731,
                    59445, 16649, 53662, 53231, 41088, 60671, 37263, 43399, 2813, 55789, 27855,
                    49652, 16510, 6149, 61821, 2217, 21260, 30861, 59369, 27966, 7392, 65127, 1056,
                    47428, 4868, 24329, 58533, 42001, 19903, 38866, 44845, 31781,
                ]),
                c: 120,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_random_6/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("171ae6694d194490e836168998f9ee01694f403e9104a36ec8b9ca05df67cdbe");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_small_test_struct_random_chaos_0() {
    let value = SmallTestStruct { a: 32656, b: 26218 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SmallTestStruct_random_chaos_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SmallTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("42fccd03498ca740c0d81c60d845db06b8b10257b9112411d1863b732810725d");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_random_1() {
    let value = SingleFieldTestStruct { a: 59 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_random_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("3b00000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_max_3() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([]),
        b: Bitvector::<2>::from_iter([true, true]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([]),
        e: Bitvector::<8>::from_iter([true, true, true, true, true, true, true, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_max_3/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("4ba4cfc5cf2a708b0b5fac027a42fd0d03e25ea79114660a4183a9f8ed7fe70f");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_nil_4() {
    let value = VarTestStruct {
        a: 28577,
        b: List::<u16, 1024>::from_iter([]),
        c: 222,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_nil_4/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("1f74745ce203e543c7e2ca93e001fc86755a5aa6cf4a0e3a0f02b516a8764974");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_one_7() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([true]),
        b: Bitvector::<2>::from_iter([true, false]),
        c: Bitvector::<1>::from_iter([false]),
        d: Bitlist::<6>::from_iter([true]),
        e: Bitvector::<8>::from_iter([false, false, false, false, false, true, true, false]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_one_7/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("ebeb7f15f8e27e619d126d73430a13dadc766ce9ab7cae7b0701dbcf88b8cae3");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_random_8() {
    let value = SingleFieldTestStruct { a: 121 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_random_8/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("7900000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_random_chaos_2() {
    let value = VarTestStruct {
        a: 56424,
        b: List::<u16, 1024>::from_iter([
            14923, 5692, 42866, 61765, 4524, 40147, 49185, 62818, 16625, 13626, 26774, 26803,
            27596, 7960, 33695, 64432, 57196, 57270, 58176, 61600, 53363, 27678, 55705, 55519, 99,
            61383, 30970, 56502, 42545, 5930, 30494, 5507, 7084, 1879, 52535, 37062, 52431, 9370,
            44427, 28161, 55314, 34557, 20893, 25736, 5799, 15607, 32615, 63064, 42958, 4591,
            63902, 61997, 18283, 8868, 56569, 10716, 49303, 16470, 35770, 18456, 22101, 59922,
            5112, 16222, 9475, 2909, 53670, 14946, 9470, 29043, 6466, 42784, 54249, 51930, 53120,
            49553, 40009, 62722, 15442, 39885, 47715, 31420, 30392, 59441, 49844, 30511, 60938,
            24123, 37496, 60799, 39564, 41712, 46779, 27229, 33936, 34677, 34317, 3524, 61643,
            64379, 41330, 38164, 55130, 1863, 25732, 28989, 49648, 57163, 44576, 19832, 35293,
            28298, 28054, 30960, 63728, 63386, 64191, 16214, 53783, 42818, 14406, 58212, 4450,
            12448, 28328, 1525, 59012, 3222, 27943, 26956, 51734, 16261, 48885, 10425, 32547,
            27503, 48787, 61339, 56655, 35114, 48615, 50238, 54306, 35846, 46318, 21347, 35973,
            28551, 29932, 1210, 33034, 38597, 32462, 52056, 55890, 27690, 57732, 27173, 27704,
            54492, 36064, 50832, 28574, 50842, 5328, 14306, 55779, 49080, 47166, 41079, 22171,
            17880, 13494, 40666, 1033, 41469, 53527, 11442, 60101, 6853, 51301, 20698, 60179,
            13770, 44646, 18935, 6613, 6065, 20647, 13032, 3082, 1807, 2462, 13790, 38100, 51950,
            5549, 26563, 65532, 45091, 17302, 25886, 19272, 17176, 48484, 27932, 4411, 26989,
            52117, 40255, 48837, 4549, 43056, 11717, 4213, 13597, 18234, 44020, 23535, 27845,
            37440, 45023, 41171, 11738, 9492, 65076, 44029, 26722, 16406, 38258, 20273, 59229,
            61837, 13718, 22651, 29205, 58345, 25080, 51116, 41205, 7082, 58487, 47213, 59964,
            54195, 34052, 12593, 7040, 23308, 15232, 55712, 36564, 46983, 61371, 56295, 20614,
            18532, 44867, 64237, 2879, 52724, 19375, 33835, 45323, 21348, 11045, 5764, 7128, 65493,
            16173, 4336, 34064, 15351, 59268, 46550, 29691, 55782, 11758, 31160, 62671, 51828,
            41478, 38046, 64362, 52586, 34516, 34317, 38339, 39417, 7111, 51712, 44259, 23120,
            3386, 57500, 31109, 4932, 7691, 19250, 62704, 35731, 16459, 34235, 46133, 25305, 65099,
            28075, 61760, 33544, 845,
        ]),
        c: 237,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_random_chaos_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("afc6aa81f584fba24b6c7a0fa73bd1b3bdb09a75dab31d111b62bc9e9850cfae");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_nil_3() {
    let value = VarTestStruct {
        a: 16239,
        b: List::<u16, 1024>::from_iter([]),
        c: 51,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_nil_3/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("3168dedbcb599653e924a07f395a5e2d2ee0af53acdb1323fcd7d8b5c018c65d");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_random_8() {
    let value = ComplexTestStruct {
        a: 20254,
        b: List::<u16, 128>::from_iter([
            20019, 60900, 48556, 15177, 23768, 57178, 35087, 7767, 19440, 595, 14057, 20155, 35173,
            35336, 64153, 21450, 36425, 55180, 52004, 42407, 19621, 742, 32674, 58289, 9198, 44946,
            48837, 57874, 50783, 46004, 42531, 47118, 25301, 48855, 10466, 34574, 27766, 32913,
            59288, 29576, 62320, 39237, 48839, 29122, 25641, 41609, 60367, 30823, 21187, 34405,
            65294, 5151, 1793, 5552, 2864, 42727, 702, 2491, 48324, 3944, 62993, 16985, 21918,
            49657, 8425, 10712, 50340, 30588, 14530, 11749, 6804, 1495, 51933, 8457, 34646, 21116,
            60205, 58353, 124, 1481, 59528, 9590, 4347, 2702, 15150, 677, 38550, 28196, 46638,
            59880,
        ]),
        c: 118,
        d: List::<u8, 256>::from_iter([
            108, 97, 223, 200, 182, 147, 35, 133, 49, 171, 249, 221, 65, 139, 125, 159, 124, 65,
            204, 18, 41, 97, 28, 230, 55, 150, 187, 143, 212, 236, 222, 220, 218, 110, 168, 119,
            178, 58, 139, 231, 162, 177, 213, 78, 145, 200, 194, 101, 182, 175, 220, 126, 11, 138,
            185, 212, 172, 112, 93, 123, 53, 188, 91, 79, 153, 60, 104, 141, 33,
        ]),
        e: VarTestStruct {
            a: 15566,
            b: List::<u16, 1024>::from_iter([
                23038, 52467, 41326, 7563, 19676, 51828, 34152, 35277, 31528, 15242, 52634, 23460,
                662, 57334, 51356, 51069, 62275, 51556, 9608, 61918, 11647, 8270, 23699, 38091,
                13755, 10586, 1912, 12225, 49116, 20133, 37751, 60597, 64257, 42895, 46087, 33385,
                2505, 39233, 65481, 36900, 44692, 48901, 57503, 47013, 10149, 11443, 6751, 40026,
                65136, 24278, 24408, 52675, 30579, 22220, 16607, 45228, 22219, 54085, 30563, 55581,
                9463, 53112, 34, 30617, 47477, 5298, 30294, 11311, 29564, 58717, 35313, 16998,
                21351, 58470, 8359, 1304, 53801, 49970, 3507, 57786, 56260, 44562, 30257, 7650,
                36333, 47070, 3575, 5861, 17655, 57540, 15435, 42401, 51256, 34878, 28770, 2628,
                48312, 43028, 62550, 54455, 14143, 56090, 33068, 61934, 19848, 30845, 44235, 43090,
                39642, 59346, 35395, 41672, 40733, 20450, 2975, 58444, 27817, 5251, 407, 41801,
                11994, 34767, 35100, 53842, 51699, 51779, 27328, 55964, 31723, 48561, 28002, 30110,
                33484, 35352, 58292, 4230, 47386, 56285, 64411, 33751, 33961, 29007, 38688, 51050,
                7125, 11803, 13068, 63754, 53090, 34587, 35542, 45246, 54620, 6581, 5122, 10149,
                45379, 25659, 23061, 45914, 598, 40874, 7128, 11296, 26013, 56871, 10082, 17350,
                35057, 64511, 23196, 25536, 921, 34801, 57331, 53619, 3385, 24312, 7501, 64696,
                43269, 51564, 16998, 37607, 9736, 20160, 23205, 47204, 12909, 62084, 46171, 34480,
                7301, 19, 48602, 17400, 53932, 34104, 54714, 50565, 23142, 9583, 36290, 13105,
                17632, 64758, 53859, 48557, 22417, 35909, 13069, 51497, 9730, 55921, 33459, 23387,
                38711, 54174, 42625, 57795, 17568, 38904, 20044, 58948, 48375, 32402, 27931, 35005,
                38562, 1676, 17801, 54, 7513, 26578, 46119, 30052, 35530, 11384, 13531, 42624,
                56620, 18653, 42752, 41161, 23162, 34126, 20564, 49149, 24100, 12881, 30241, 47538,
                53663, 38843, 47756, 9411, 25012, 19131, 42097, 52976, 17633, 34450, 12281, 32939,
                21055, 43801, 48633, 37097, 34579, 33852, 4982, 2955, 48169, 34914, 1437, 48070,
                33516, 39601, 1788, 46643, 52766, 47271, 41865, 22083, 1058, 49598, 33249, 43144,
                41894, 21913, 64824, 33419, 6358, 2988, 43758, 19922, 24492, 50825, 39861, 62492,
                12321, 59018, 8514, 40413, 59127, 22379, 6038, 27666, 33790, 55918, 25974, 19092,
                10219, 2648, 17859, 16754, 65381, 40019, 42411, 40586, 18643, 38833, 60778, 35088,
                19365, 16615, 47563, 49340, 20330, 20458, 33330, 60705, 47494, 51169, 11203, 43187,
                6138, 2505, 20405, 46548, 40584, 24993, 62231, 20986, 46283, 38288, 60599, 20233,
                55047, 5984, 23254, 24025, 31374, 47643, 62445, 52763, 52452, 43885, 43362, 14792,
                5673, 10021, 31738, 9067, 15167, 7853, 63528, 27105, 62764, 13090, 6254, 35859,
                59536, 54027, 14904, 64031, 65071, 53232, 27028, 42983, 40543, 24781, 20444, 41784,
                60171, 34731, 34600, 39511, 32768, 27348, 42675, 25447, 55249, 24705, 22908, 37437,
                45719, 11497, 50270, 47556, 40284, 22236, 58097, 52214, 62016, 52033, 51909, 1017,
                36042, 31122, 58767, 3302, 61282, 24875, 50420, 19597, 56833, 24486, 64716, 51516,
                2892, 51416, 42233, 33490, 28745, 10441, 16353, 23993, 29684, 39092, 33527, 14540,
                63877, 52781, 19691, 21007, 37703, 38191, 1160, 62982, 52948, 8684, 59121, 56101,
                5091, 62786, 6965, 29258, 24770, 18219, 2061, 28593, 16491, 55234, 12659, 31184,
                2347, 24082, 1817, 19529, 59188, 8470, 54829, 35039, 54773, 6492, 22279, 25784,
                47210, 64774, 49465, 63119, 23357, 46595, 8480, 7135, 37037, 55754, 58607, 15162,
                59514, 62454, 64385, 53026, 40752, 28766, 60737, 39821, 34691, 41439, 42882, 24899,
                46916, 13493, 55991, 44304, 30454, 11407, 53016, 16063, 7049, 56307, 9135, 56666,
                12923, 39358, 17561, 46630, 7399, 20274, 32193, 22999, 47006, 63989, 11858, 9990,
                21774, 49916, 37153, 9606, 63414, 35134, 8733, 44605, 26307, 52908, 11617, 37977,
                33251, 14901, 34690, 39345, 47417, 9357, 29558, 63632, 23563, 62408, 15920, 42437,
                8958, 22378, 36801, 20725, 18729, 16779, 38026, 26668, 34107, 47028, 62619, 40842,
                30704, 6197, 45446, 23256, 53321, 16785, 8464, 29133, 31951, 14485, 32301, 31234,
                8675, 7635, 33229, 4765, 17395, 22256, 60347, 16649, 23084, 19739, 48433, 40504,
                3208, 40921, 63982, 45174, 23696, 688, 12887, 3603, 28246, 7593, 43322, 61745,
                11342, 29008, 51004, 15627, 36299, 12852, 6301, 27901, 56818, 28378, 40325, 31964,
                33201, 8283, 29352, 56931, 58168, 58626, 12750, 1693, 56526, 37439, 3393, 7169,
                38011, 2024, 35868, 44922, 57706, 17629, 1927, 30471, 16307, 59197, 52511, 38939,
                52119, 6498, 55563, 36590, 63080, 43285, 21344, 29599, 58333, 36815, 30442, 16488,
                5865, 16310, 22214, 3197, 1994, 46368, 26181, 15751, 292, 37374, 7959, 43053,
                43706, 3804, 54377, 20680, 32790, 46929, 16913, 57654, 16611, 36697, 10334, 54145,
                34644, 36632, 52785, 10180, 26004, 16564, 15248, 6316, 6205, 21235, 7245, 10689,
                35183, 6528, 32510, 38225, 46675, 37667, 50383, 22314, 42619, 20975, 5100, 28320,
                9244, 8456, 16467, 42101, 52228, 20837, 65198, 18384, 2023, 18571, 7614, 42939,
                58425, 5177, 63253, 62529, 24436, 17040, 435, 23623, 21340, 34153, 17123, 18561,
                21853, 16579, 20498, 28322, 59997, 59146, 29827, 33000, 18576, 9772, 31481, 11536,
                36242, 42804, 26276, 40157, 42698, 12944, 46401, 57269, 34921, 58492, 43121, 58409,
                43764, 51536, 18534, 56921, 64238, 9140, 16751, 13987, 22539, 4143, 61909, 64012,
                1545, 7899, 64832, 3251, 49234, 63211, 47145, 14128, 55114, 26059, 4646, 54250,
                19494, 20415, 17706, 20466, 34349, 13833, 38218, 13018, 28319, 45422, 61053, 4983,
                35438, 42987, 57782, 23435, 63994, 49597, 19417, 32429, 56932, 21668, 26397, 62483,
                425, 41979, 3748, 41752, 1925, 24146, 14386, 63454, 2571, 38359, 60363, 9558,
                57512, 15444, 3022, 57386, 38406, 13766, 33526, 1004, 52004, 63668, 43171, 18294,
                40038, 43932, 37914, 45261, 22944, 3603, 56880, 4943, 32036, 17552, 22058, 24106,
                17075, 61325, 39999, 45555, 53765, 60978, 6921, 59977, 41619, 60973, 60245, 18330,
                54001, 40067, 16271, 61908, 53267, 10359, 63026, 42225, 31232, 28082, 16767, 34385,
                34457, 42076, 27634, 16656, 22750, 14799, 50248, 49235, 4043, 64542, 27166, 42198,
                20774, 52729, 48013, 41013, 45422, 31504, 45128, 16020, 20162, 33898, 52032, 49305,
                49790, 25177, 45504, 5590, 22672, 8392, 54615, 25499, 7724, 29949, 46898, 37758,
                46248, 46673, 34286, 9910, 14859, 4033, 64325, 16766, 30351, 20549, 58149, 41480,
                46831, 38411, 47717, 36604, 55904, 60964, 61372, 6153, 7, 51179, 43044, 60547,
                57477, 47628, 11910, 23577, 53559, 9283, 19886, 48454, 54199, 54701, 3286, 41565,
                38454, 17603, 26062, 58024, 15522, 58312, 39831, 24586, 59926, 49516, 21706, 42153,
                5540, 64830, 38577, 54671, 16607, 32804, 45601, 2312, 1769, 63576, 34619, 23153,
                55671, 3450, 6981, 35324, 4052, 35486, 16532, 62252, 41492, 10429, 64631, 61955,
                24238, 40810, 46168, 50191, 48746, 20982, 36322, 39661, 38201, 13902, 62589, 15644,
                1597, 8016, 20948, 32630, 7116, 40892, 55874, 17482, 18790, 30054, 3759, 58363,
                59346, 37782, 52308, 55784, 18670, 62067, 11374, 44003, 27072, 34676, 61532, 51383,
                3289, 7494, 28421, 16328, 59441, 43722, 32573, 47552, 31206, 13961, 59701, 31785,
                46488, 52510, 15541, 54445, 12747, 56879, 37276, 53177, 24919, 24322, 55996, 35239,
                20308, 38034, 47668, 30704, 2903, 41200, 34928, 32197, 45503, 14275, 25982, 39402,
                46211, 10299,
            ]),
            c: 159,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 35,
                b: 13234913345360785102,
                c: 172363296,
            },
            FixedTestStruct {
                a: 143,
                b: 15275530587653726896,
                c: 1598380581,
            },
            FixedTestStruct {
                a: 87,
                b: 11938384569861367173,
                c: 4135857227,
            },
            FixedTestStruct {
                a: 174,
                b: 2815096997284796480,
                c: 3314608453,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 61309,
                b: List::<u16, 1024>::from_iter([
                    6101, 25775, 3733, 46672, 48616, 25668, 59747, 37205, 60722, 47023, 15262,
                    53619, 24589, 51541, 14230, 56659, 37929, 52476, 9436, 23768, 61651, 11002,
                    11113, 23652, 28837, 46402, 48222, 37692, 22676, 47681, 62696, 6057, 13277,
                    18819, 18034, 27652, 18360, 23490, 41594, 11574, 4644, 60947, 28531, 19304,
                    18903, 52404, 8652, 36103, 61759, 8841, 51954, 30458, 23370, 50510, 52460,
                    2919, 21203, 62480, 11693, 61840, 15044, 13144, 23298, 27578, 11400, 35760,
                    10498, 17558, 27972, 9958, 44038, 7793, 61468, 43420, 19814, 33495, 8683,
                    64391, 60163, 45374, 51934, 39630, 29711, 62043, 15550, 29818, 39152, 8075,
                    63681, 35378, 17310, 49144, 39836, 32212, 37525, 3003, 3086, 28649, 26124,
                    47198, 44647, 55203, 36586, 63172, 4780, 55953, 19499, 44062, 35712, 60565,
                    35068, 23197, 24909, 13556, 2502, 26719, 54123, 11655, 8825, 26298, 33724,
                    11153, 47187, 10731, 14067, 12914, 59297, 46848, 28674, 58531, 7589, 44146,
                    55565, 17183, 3016, 60325, 837, 6518, 23866, 2514, 2719, 34416, 46727, 40113,
                    52505, 46306, 57350, 7232, 65080, 28462, 35430, 56086, 44291, 48032, 40131,
                    3440, 5846, 45642, 44602, 40407, 47046, 30387, 27211, 32955, 55269, 22245,
                    10795, 5043, 37598, 4975, 22369, 23489, 49633, 56785, 11299, 58007, 56493,
                    6855, 7084, 58084, 27102, 24899, 63424, 25800, 46243, 15144, 48060, 20000,
                    7379, 35259, 61989, 20194, 41803, 59007, 48247, 7065, 10646, 41599, 58393,
                    10050, 23459, 50541, 38902, 13378, 60735, 31461, 40617, 24902, 19441, 47698,
                    51392, 39897, 19877, 38465, 22167, 56974, 42646, 52013, 59659, 31775, 64391,
                    11835, 55150, 61661, 49227, 21634, 26656, 56465, 65202, 4049, 46575, 32503,
                    56898, 689, 5469, 63418, 64096, 21223, 15890, 52426, 40652, 31684, 54047,
                    29107, 19711, 58157, 24638, 27364, 7933, 9853, 21155, 35563, 50597, 30362,
                    6890, 51785, 53965, 14563, 35295, 17174, 55105, 46077, 63507, 42763, 31369,
                    8762, 64581, 19172, 51474, 20717, 57786, 9096, 29042, 54841, 48798, 55143,
                    56743, 33164, 13989, 25509, 58981, 20853, 21778, 26005, 52876, 22627, 55027,
                    37733, 20744, 58945, 62213, 23052, 54639, 6129, 50988, 57145, 51447, 22969,
                    47273, 48897, 16962, 11028, 8106, 2891, 60396, 57229, 9064, 31469, 2591, 24817,
                    60259, 64928, 22513, 625, 26886, 25764, 58261, 41026, 57810, 39521, 61285,
                    61026, 42128, 43152, 16450, 32737, 25657, 2560, 40193, 17144, 4120, 54355,
                    50871, 15492, 13070, 52287, 49836, 9657, 6505, 29156, 43743, 3522, 10611,
                    64255, 6008, 46055, 26789, 36959, 32442, 6235, 19906, 37973, 56812, 9841,
                    31861, 46749, 7627, 18867, 42436, 13433, 11022, 63536, 23238, 11233, 38202,
                    13879, 29216, 6119, 63821, 62132, 32015, 12339, 41057, 43390, 32683, 5569,
                    44573, 28138, 17649, 51768, 40247, 37972, 63291, 46940, 7657, 2400, 17498,
                    23529, 27203, 2673, 39161, 6939, 33235, 8877, 44277, 47743, 8243, 62420, 41619,
                    63808, 55063, 36170, 8122, 50009, 64887, 28710, 10198, 9556, 26240, 1835,
                    44772, 32033, 10457, 2021, 1053, 62308, 642, 36767, 63676, 30961, 39187, 7748,
                    3553, 8959, 39150, 17902, 45253, 31234, 24700, 11499, 24130, 14067, 1532,
                    27967, 25496, 7458, 2619, 3714, 21336, 29363, 1624, 857, 6720, 57098, 52810,
                    16421, 19807, 6039, 20422, 28223, 61824, 12870, 36232, 57898, 16126, 43049,
                    59000, 32480, 33493, 36269, 37733, 62095, 59870, 56470, 41882, 60716, 12599,
                    46080,
                ]),
                c: 3,
            },
            VarTestStruct {
                a: 34532,
                b: List::<u16, 1024>::from_iter([
                    45796, 18375, 37834, 2783, 2547, 23183, 37213, 4430, 2216, 28517, 6685, 9572,
                    14339, 7840, 46610, 62005, 14231, 56026, 49029, 25365, 45017, 59892, 37635,
                    37039, 5534, 32488, 36307, 20202, 14133, 38835, 41232, 43417, 50193, 61322,
                    12497, 63946, 40186, 5409, 6597, 29495, 51569, 50776, 56488, 48943, 38415,
                    30793, 60777, 49597, 33818, 22039, 22367, 9419, 43194, 556, 53740, 227, 34763,
                    64976, 45771, 57206, 11303, 43770, 62989, 12619, 25054, 12198, 22037, 59265,
                    56189, 12513, 22698, 40654, 56041, 41845, 63478, 62016, 50246, 51149, 9579,
                    37949, 35223, 61704, 39497, 25753, 56055, 21150, 2548, 2226, 62713, 61281,
                    4253, 63662, 52884, 60310, 377, 41170, 27307, 8545, 62008, 54420, 43051, 18340,
                    9371, 20869, 8305, 57799, 59553, 53148, 8258, 37659, 33621, 63382, 42335,
                    40163, 46424, 46243, 50852, 40396, 35123, 52333, 6167, 287, 64998, 61939,
                    11339, 28726, 5251, 24746, 3192, 34887, 58919, 14305, 22516, 21983, 16053,
                    52208, 31078, 49245, 4278, 37520, 11095, 60968, 47723, 31762, 22801, 1730,
                    61360, 55701, 53998, 2241, 47691, 32901, 25085, 28305, 24029, 30555, 42918,
                    64945, 44616, 28144, 33595, 41350, 41692, 30993, 4497, 50838, 3530, 48805,
                    27173, 27712, 37570, 62305, 62316, 44712, 62793, 29394, 16491, 28390, 10408,
                    14516, 25130, 65110, 14324, 15169, 44744, 46253, 7562, 45029, 316, 18792, 6675,
                    38865, 10052, 36666, 40807, 3336, 25176, 56382, 39360, 22193, 47798, 63773,
                    56176, 43762, 60444, 29203, 42920, 31031, 42960, 734, 10279, 29084, 63167,
                    48335, 14468, 6904, 39217, 25254, 42026, 39024, 43077, 3253, 5909, 28959,
                    52143, 39849, 30151, 28996, 48557, 24876, 54341, 58060, 49819, 2229, 59147,
                    10436, 61764, 12145, 10176, 62235, 20188, 36701, 10774, 4552, 26705, 8406,
                    46742, 1391, 24846, 33930, 56731, 28552, 59949, 64839, 30449, 4956, 5056,
                    65013, 56177, 56052, 13256, 64421, 26667, 24891, 19374, 46271, 2746, 27946,
                    21012, 19467, 16435, 7137, 62398, 50061, 3870, 27785, 171, 48103, 4629, 39017,
                    48636, 46150, 44826, 53782, 61652, 14988, 54004, 23821, 64602, 61791, 43490,
                    48957, 40252, 60539, 2530, 33509, 40557, 47585, 43780, 1834, 31083, 10151,
                    54286, 24033, 28501, 22262, 19242, 54632, 17777, 34759, 12546, 19928, 61296,
                    34569, 50440, 32506, 44229, 54793, 48774, 46966, 7241, 62272, 25104, 42472,
                    51610, 15296, 22483, 31651, 1759, 51706, 50005, 2698, 41805, 32307, 51683,
                    4805, 58759, 44512, 23034, 1429, 16509, 18365, 46197, 35862, 42220, 14834,
                    10886, 34534, 47865, 47372, 45365, 17310, 56323, 6, 30602, 53341, 57603, 38787,
                    45467, 31382, 17241, 8690, 29575, 54319, 39136, 58139, 3899, 51017, 52062,
                    40422, 36738, 32920, 39190, 58054, 65026, 37016, 64298, 22094, 60177, 845,
                    32645, 23084, 6448, 61671, 53586, 45336, 18107, 61191, 43493, 21989, 48665,
                    46880, 45959, 6581, 26222, 20775, 51807, 818, 41555, 34348, 17275, 6841, 47144,
                    43896, 23236, 25456, 44616, 59703, 41068, 11379, 44392, 50336, 11859, 42669,
                    24047, 52984, 18849, 8877, 8302, 5689, 58346, 21274, 24696, 61887, 14159,
                    46439, 35139, 57289, 12242, 12064, 4178, 63296, 35933, 10596, 48988, 1199,
                    56617, 22335, 64255, 53441, 42364, 23662, 3098, 53507, 54208, 35064, 21739,
                    20295, 22858, 41962, 29193, 37230, 43789, 10663, 27948, 47478, 62004, 28553,
                    34909, 12686, 39782, 53788, 26674, 61096, 25235, 58177, 21025, 17613, 56304,
                    40182, 15235, 4973, 34064, 4669, 6825, 53751, 35358, 36209, 37355, 39640,
                    38754, 34402, 29436, 34612, 23886, 10436, 48569, 28894, 50118, 38832, 62722,
                    32879, 33441, 888, 44111, 15312, 18232, 51122, 34096, 62233, 20445, 43928,
                    17291, 46008, 20354, 64717, 18103, 60897, 64357, 554, 45709, 64630, 26749,
                    50210, 43786, 54811, 15955, 53515, 11793, 29758, 37700, 31728, 24881, 30698,
                    581, 23336, 23207, 18859, 11761, 59544, 41643, 43820, 31524, 62873, 42794,
                    52162, 7006, 49091, 52896, 24037, 15770, 7876, 10000, 62193, 23699, 47752,
                    22825, 55255, 32138, 38357, 37743, 33771, 45651, 52988, 33575, 2880, 36046,
                    41461, 8806, 27885, 28629, 19862, 38098, 33447, 20, 9564, 3345, 27856, 62546,
                    5801, 1182, 48799, 56772, 34700, 63084, 29108, 2338, 38017, 13752, 52727,
                    60959, 6915, 47186, 16535, 53223, 61297, 64167, 7103, 13071, 57525, 5815,
                    17031, 3467, 45601, 57726, 47281, 24225, 40594, 50673, 4837, 36578, 47507,
                    6271, 45344, 21430, 23186, 54985, 9546, 59568, 19721, 62488, 17246, 18336,
                    2932, 43077, 9573, 20550, 10186, 45299, 38415, 11154, 25431, 2224, 7952, 34040,
                    9661, 33383, 1011, 53102, 34504, 17596, 20500, 61731, 15480, 38020, 11293,
                    13132, 9733, 20343, 23111, 38910, 10912, 23775, 51763, 15820, 53023, 15054,
                    6614, 34479, 61444, 17471, 8416, 50288, 17795, 48290, 26408, 23071, 7673,
                    51868, 6919, 13493, 50846, 61423, 3022, 4267, 2318, 58447, 20104, 47029, 47130,
                    18948, 33554, 51913, 48287, 16235, 25618, 22268, 11310, 51214, 7566, 24288,
                    19481, 61627, 30623, 44372, 35744, 60201, 1603, 39373, 43735, 50183, 63915,
                    28188, 29454, 43387, 20397, 16759, 14539, 6184, 1018, 2334, 41552, 63924,
                    44028, 57577, 60663, 48790, 4721, 19935, 49753, 2823, 51430, 30779, 55295,
                    35820, 36457, 54220, 38345, 49902, 24291, 16128, 65240, 15017, 2238, 62226,
                    37171, 9869, 59963, 37788, 43747, 60871, 30196, 48022, 34800, 45626, 17874,
                    52700, 27023, 25737, 5972, 39448, 63979, 18675, 13631, 40688, 64367, 19842,
                    42761, 22227, 60207, 39866, 3442, 59616, 46666, 11948, 45279, 20839, 24310,
                    36553, 18628, 32331, 64683, 63900, 18663, 4406, 22521, 23809, 41824, 57718,
                    18566, 18581, 7917, 50562, 23865, 57352, 61204, 5438, 13668, 42052, 39805,
                    25256, 25471, 43890, 46357, 2497,
                ]),
                c: 87,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_random_8/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("c44655c114a8ebcf54bbb672b379a0eb3b8091237000cb806c9e3c664bffe2c5");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_one_0() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([true]),
        b: Bitvector::<2>::from_iter([true, false]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([true]),
        e: Bitvector::<8>::from_iter([false, true, true, false, true, false, false, false]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_one_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("1542a289ee369034f9a2bc8b879978a66b396b90cfbcff05168d7acdb3ea78c7");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_random_chaos_2() {
    let value = ComplexTestStruct {
        a: 38946,
        b: List::<u16, 128>::from_iter([
            5471, 27102, 57450, 14239, 40850, 28804, 29251, 64229, 2817, 698, 12066, 31923, 8627,
            46696, 45162, 20487, 26658, 9609, 30585, 34251, 1327, 43070, 64396, 53909, 458, 40421,
            42105, 41328, 38697, 1374, 64232, 64691, 62808, 17976, 53874, 61537, 15907, 42772,
            58056, 61290, 30753, 11997, 32240, 35573, 523, 58558, 9488, 19648, 49356, 13503, 41572,
            5291, 46694, 18537, 24217, 55537, 34818, 14214, 52245, 20089,
        ]),
        c: 19,
        d: List::<u8, 256>::from_iter([
            232, 30, 111, 0, 23, 237, 114, 162, 9, 235, 232, 180, 148, 118, 35, 147, 142, 238, 230,
            156, 255, 204, 127, 12, 221, 208, 18, 64, 118, 234, 211, 34, 86, 11, 4, 180, 217, 132,
            95, 149, 28, 249, 15, 9, 250, 110, 164, 184, 160, 36, 57, 12, 19, 24, 139, 194, 160,
            109, 156, 247, 95, 237, 109, 211, 9, 87, 18, 214, 86, 26, 80, 134, 207, 34, 192, 74,
            12, 143, 43, 141, 154, 104, 197, 209, 206, 66, 4, 70, 16, 190, 155, 34, 178, 134, 28,
            212, 211, 161, 125, 221, 195, 89, 97, 8, 48, 106, 190, 202, 190,
        ]),
        e: VarTestStruct {
            a: 41206,
            b: List::<u16, 1024>::from_iter([
                38917, 43774, 38559, 38822, 50501, 34597, 19855, 23072, 14435, 33924, 7401, 4825,
                30064, 2249, 14300, 5634, 61411, 21535, 45447, 65111, 51794, 54294, 11954, 521,
                33149, 41959, 58815, 60732, 13060, 32016, 27542, 32726, 62219, 7113, 43818, 8180,
                58547, 29689, 13656, 2705, 61030, 43613, 51475, 56830, 3954, 35527, 27835, 58907,
                9584, 40816, 65058, 53223, 27346, 51756, 37323, 9645, 28525, 23973, 17596, 46371,
                42743, 23765, 35775, 23725, 8966, 58476, 9215, 16391, 17257, 64861, 2628, 16202,
                22869, 44322, 58192, 42671, 49395, 16050, 14801, 25682, 63949, 2898, 29059, 3450,
                60756, 24032, 23356, 45771, 869, 6203, 39521, 28192, 23493, 45118, 47074, 58746,
                22150, 50329, 43202, 18371, 49297, 63860, 44745, 31131, 21100, 55372, 22881, 26972,
                55494, 11192, 32695, 17773, 37190, 38006, 781, 18248, 15905, 33626, 61383, 35394,
                51218, 31372, 2439, 32229, 6278, 26983, 13978, 35737, 56317, 50329, 33325, 3122,
                40882, 62197, 22635, 17845, 30168, 44278, 49784, 57542, 54176, 13316, 43007, 63245,
                10824, 49640, 50495, 36115, 60655, 11039, 18879, 59080, 41747, 47926, 15000, 64884,
                62864, 27986, 4917, 59531, 7465, 21435, 43, 27262, 51058, 8788, 48329, 10090,
                58015, 56030, 57239, 6245, 10615, 143, 34311, 11281, 18352, 152, 54221, 3987,
                19183, 46145, 59264, 29443, 32202, 5947, 5443, 8909, 28022, 63743, 10668, 60739,
                14533, 31871, 22029, 49332, 62812, 20917, 43810, 17372, 15526, 48388, 23144, 13711,
                40790, 51387, 60411, 63038, 48660, 27050, 55777, 28593, 45019, 6074, 21433, 10257,
                17804, 4842, 56494, 25660, 46301, 10365, 19003, 53706, 2165, 23718, 38577, 39791,
                52570, 48178, 64438, 54362, 19988, 38343, 15376, 23105, 983, 44621, 40452, 63081,
                9959, 50448, 4145, 52587, 59052, 6088, 65292, 60185, 20052, 44118, 9748, 15779,
                1765, 21188, 9430, 28527, 50525, 24557, 43404, 41168, 31153, 24875, 5594, 28984,
                4465, 9999, 48399, 48441, 38957, 7452, 56282, 1934, 43469, 59140, 26798, 56848,
                54391, 21009, 49171, 40128, 4466, 5013, 4282, 9355, 39488, 52680, 61685, 58911,
                27385, 37935, 61272, 49908, 8749, 4604, 18348, 7448, 45770, 29231, 20248, 2210,
                11529, 40380, 50412, 18109, 21000, 61587, 57791, 34100, 61720, 14550, 61375, 26716,
                25658, 42477, 6222, 61297, 50324, 40262, 7606, 6290, 32195, 28638, 11935, 41914,
                40809, 55164, 25353, 49954, 9807, 12244, 15097, 62087, 39388, 6355, 47420, 7566,
                56057, 49238, 14737, 36442, 48155, 57518, 63191, 25589, 33852, 46017, 57260, 48771,
                35039, 20136, 3671, 38230, 40508, 53972, 34396, 3033, 21862, 24145, 32479, 22911,
                25842, 38158, 54146, 2776, 39681, 61546, 41221, 5011, 6394, 56998, 42877, 53615,
                27157, 28848, 20009, 61556, 27988, 44277, 57719, 34396, 26429, 32945, 42464, 25956,
                62649, 45461, 55102, 59697, 62670, 59172, 14786, 58950, 20171, 1057, 37935, 19530,
                21109, 22243, 7482, 20469, 9970, 25902, 42395, 8743, 55772, 35528, 2326, 1859,
                59130, 42304, 60807, 14184, 1267, 35620, 7748, 25619, 10385, 10989, 24594, 4693,
                64475, 48253, 11534, 60744, 43291, 62230, 65502, 27181, 31997, 16934, 55882, 44858,
                8372, 63603, 31364, 27282, 42991, 35984, 30183, 20650, 41066, 47355, 51951, 16848,
                62122, 42744, 41585, 16942, 43377, 20856, 18694, 23907, 37953, 35856, 31037, 15748,
                28208, 21520, 48447, 33080, 40178, 42973, 41617, 24909, 56187, 392, 13155, 44233,
                45802, 63936, 57243, 42453, 16377, 31140, 51590, 11141, 16667, 47826, 58779, 51244,
                20699, 35202, 32246, 28921, 17369, 33032, 31063, 9568, 44849, 1311, 23124, 472,
                35834, 11322, 8902, 26137, 63396, 64598, 44549, 29418, 48388, 29027, 12818, 40904,
                56816, 11868, 32629, 29459, 50779, 27706, 58473, 2955, 20098, 22243, 28670, 49805,
                5081, 22117, 8350, 60055, 47281, 37562, 54748, 58881, 50297, 25767, 51006, 3169,
                21092, 3417, 41301, 40026, 38949, 11398, 8010, 24862, 49266, 12377, 57112, 15391,
                18299, 33685, 36838, 41339, 23327, 22682, 3441, 45058, 15711, 12647, 34735, 55741,
                25140, 23751, 8944, 44679, 39171, 48351, 44085, 37813, 16167, 26821, 23654, 56932,
                51609, 64743, 13824, 18868, 46246, 20461, 61404, 49451, 17923, 24494, 30616, 6657,
                22205, 60250, 30931, 13459, 33590, 32087, 58546, 28238, 51702, 24234, 51892, 11958,
                14255, 38912, 59705, 47624, 54577, 48223, 43956, 32055, 58016, 25908, 57852, 8931,
                6290, 63949, 64466, 16049, 7756, 27274, 12887, 37376, 21310, 47565, 54834, 62792,
                49104, 40280, 60903, 63983, 39815, 27609, 9759, 35583, 5553, 32470, 16252, 26701,
                4592, 22002, 9234, 2477, 38507, 57312, 32552, 24116, 32314, 28271, 46492, 38029,
                51183, 60798, 21437, 48852, 14101, 11901, 42307, 6842, 37425, 62394, 51423, 13673,
                20486, 3659, 32098, 63167, 59225, 21637, 33444, 34322, 8267, 20452, 3314,
            ]),
            c: 114,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 249,
                b: 4107181588698988535,
                c: 2407634107,
            },
            FixedTestStruct {
                a: 106,
                b: 18323237399640037470,
                c: 1699273180,
            },
            FixedTestStruct {
                a: 23,
                b: 3936185887010202334,
                c: 892696758,
            },
            FixedTestStruct {
                a: 136,
                b: 351826920636170295,
                c: 3961519671,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 55095,
                b: List::<u16, 1024>::from_iter([
                    12824, 37147, 20776, 9838, 30702, 26363, 53923, 12254, 26244, 39805, 30481,
                    48303, 31045, 49481, 65263, 45286, 45319, 44074, 20758, 12542, 9423, 51600,
                    29493, 13156, 29556, 47905, 27566, 56758, 42483, 29799, 11737, 59600, 35788,
                    33629, 46098, 42830, 26727, 26295, 42353, 17462, 64187, 36623, 34323, 29974,
                    6677, 48943, 60803, 63543, 24735, 27439, 7744, 50536, 6985, 10999, 29008,
                    53803, 26760, 65535, 26346, 51565, 23105, 59016, 15291, 19928, 41125, 25932,
                    11501, 60495, 49720, 40527, 37131, 52402, 18647, 29767, 20242, 52106, 29541,
                    39733, 56977, 39719, 40192, 6599, 42959, 62415, 20379, 5536, 42176, 26657,
                    48935, 28529, 15560, 54443, 54965, 59505, 50340, 51504, 6594, 46283, 55134,
                    41413, 35577, 23452, 50471, 39753, 60901, 42658, 52881, 55662, 17251, 26506,
                    50089, 38721, 29254, 4193, 26877, 18116, 16514, 23089, 50072, 33386, 13532,
                    24169, 48965, 54057, 3044, 26949, 45527, 25214, 6386, 809, 913, 60299, 54301,
                    19923, 2524, 53044, 13359, 33429, 20256, 8594, 46446, 15918, 30530, 11318,
                    43633, 45556, 57775, 42976,
                ]),
                c: 34,
            },
            VarTestStruct {
                a: 36056,
                b: List::<u16, 1024>::from_iter([
                    63443, 953, 61737, 53195, 19552, 12277, 49695, 10490, 61265, 4699, 19174,
                    58223, 35909, 23830, 38240, 24693, 21556, 28113, 55300, 44141, 22697, 60601,
                    43258, 21075, 30469, 6417, 21447, 59691, 8827, 40374, 28331, 57423, 51412,
                    21639, 49521, 48990, 48607, 54943, 31490, 50477, 50405, 34046, 51668, 7471,
                    25523, 17449, 53308, 23182, 15293, 56485, 27508, 56093, 1170, 53289, 30201,
                    13836, 53910, 53979, 20463, 44633, 38314, 49085, 1830, 29589, 65322, 29362,
                    10412, 41065, 55813, 29800, 56445, 22331, 34661, 48588, 50048, 42554, 5616,
                    19552, 32911, 48337, 6584, 1276, 7580, 56607, 32677, 50035, 21878, 10121,
                    56487,
                ]),
                c: 86,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_random_chaos_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("da1d555dbd61054d6102286c29ac6076cac1b835620a76dba49c92812cebd1ef");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_max_3() {
    let value = VarTestStruct {
        a: 65535,
        b: List::<u16, 1024>::from_iter([
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535,
        ]),
        c: 255,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_max_3/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("fee37a3f786fcd9d92d4b79fb1b8582694fde17505f381d69c0b0442ab8a9646");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_nil_chaos_2() {
    let value = VarTestStruct {
        a: 57138,
        b: List::<u16, 1024>::from_iter([]),
        c: 18,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_nil_chaos_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("df3efa5ecdee8b78e276a4019413bb50ce5d8fd8cd1d9907584659732db872c1");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_zero_6() {
    let value = FixedTestStruct { a: 0, b: 0, c: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_zero_6/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("db56114e00fdd4c1f85c892bf35ac9a89289aaecb1ebd0a96cde606a748b5d71");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_max_4() {
    let value = VarTestStruct {
        a: 65535,
        b: List::<u16, 1024>::from_iter([
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535,
        ]),
        c: 255,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_max_4/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("f43b89ecb1afcea42daf293bdd44f386565d4798ab5dc989b91ccc5964714e36");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_lengthy_chaos_2() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([false, false, false, true, true]),
        b: Bitvector::<2>::from_iter([false, false]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([false, true, true, false, false, false]),
        e: Bitvector::<8>::from_iter([true, false, true, true, false, true, false, false]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_lengthy_chaos_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("15e8b95c167c4d5af197499b0109debf87516cab159f1a211fd4f4bdace7d05d");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_zero_1() {
    let value = FixedTestStruct { a: 0, b: 0, c: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_zero_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("db56114e00fdd4c1f85c892bf35ac9a89289aaecb1ebd0a96cde606a748b5d71");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_one_chaos_0() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([false]),
        b: Bitvector::<2>::from_iter([false, true]),
        c: Bitvector::<1>::from_iter([false]),
        d: Bitlist::<6>::from_iter([false]),
        e: Bitvector::<8>::from_iter([true, true, true, true, false, true, false, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_one_chaos_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("63c94f1066c71e7fa926100c20d180831c6db761bb9e8500073cb3cccfb180fb");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_one_9() {
    let value = VarTestStruct {
        a: 34750,
        b: List::<u16, 1024>::from_iter([11259]),
        c: 43,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_one_9/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("585294982a9f2210cc413c2c211b1564eec730eaf550a08db0d3a6c0308083f4");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_zero_8() {
    let value = FixedTestStruct { a: 0, b: 0, c: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_zero_8/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("db56114e00fdd4c1f85c892bf35ac9a89289aaecb1ebd0a96cde606a748b5d71");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_one_0() {
    let value = VarTestStruct {
        a: 61255,
        b: List::<u16, 1024>::from_iter([17467]),
        c: 65,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_one_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("263402ff6691e913333141841d14b9a4d4f7b1b08d83f07d57a4638babfcb6ce");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_lengthy_5() {
    let value = VarTestStruct {
        a: 15159,
        b: List::<u16, 1024>::from_iter([
            40266, 41646, 61275, 56828, 55784, 13765, 5796, 17724, 49215, 57779, 48446, 61955,
            31367, 42786, 50032, 49065, 62786, 42186, 205, 17247, 50820, 37658, 24377, 10169,
            41075, 53746, 8356, 25932, 45622, 27068, 52763, 3905, 15862, 28126, 20621, 13913, 3287,
            32731, 64049, 38140, 4633, 59798, 46915, 50652, 56348, 14212, 31268, 28124, 30184,
            42573, 50609, 38750, 56173, 55013, 29426, 30317, 27321, 30176, 53921, 30516, 50391,
            64286, 4002, 26549, 37697, 64128, 62791, 47733, 6758, 23354, 35398, 39783, 5603, 31593,
            29931, 62807, 39525, 22960, 31611, 60076, 61069, 33118, 51633, 36681, 35201, 63131,
            57976, 53980, 26862, 5526, 27693, 59949, 28315, 40673, 21657, 37447, 7173, 6273, 60144,
            46334, 51675, 21959, 14083, 63322, 19817, 11565, 64397, 44620, 33698, 17540, 54907,
            18417, 46083, 57982, 15207, 19947, 39484, 38645, 20556, 47523, 35769, 60442, 16245,
            7136, 36210, 64424, 59417, 7065, 25400, 17770, 12639, 53513, 26893, 24945, 20458,
            44064, 32684, 33195, 34288, 54811, 64545, 26163, 1606, 34438, 61765, 27354, 49031,
            43873, 27699, 55178, 20057, 26741, 56039, 48720, 42869, 11207, 18823, 35744, 16640,
            51189, 56213, 39393, 11279, 57428, 25401, 51327, 12373, 46056, 39658, 22790, 16024,
            27028, 6877, 8169, 26767, 23285, 24104, 40186, 18733, 6293, 30884, 49327, 63942, 44730,
            59946, 567, 4896, 3305, 61423, 16351, 57417, 16923, 61467, 4028, 50748, 25219, 2858,
            23941, 16045, 6325, 39192, 52108, 20202, 23170, 28164, 32713, 8566, 65058, 17592,
            31227, 9495, 58572, 59169, 64539, 18195, 25848, 62999, 2567, 625, 27932, 38439, 63734,
            18357, 16889, 10120, 58645, 45807, 28477, 24032, 61881, 28697, 15837, 40711, 62441,
            43212, 36747, 47247, 48702, 5004, 50713, 58757, 327, 32023, 18047, 44629, 56156, 49809,
            27253, 8667, 43371, 22270, 49207, 57148, 55652, 12853, 57297, 4882, 5033, 15717, 20909,
            51369, 1660, 28602, 58525, 64722, 33487, 10225, 41969, 15432, 39244, 6650, 11309,
            50468, 39975, 47851, 28207, 21584, 32420, 12698, 49458, 57098, 64727, 23627, 25878,
            61213, 34397, 27200, 58343, 26552, 19799, 59954, 61221, 47544, 35901, 35508, 52836,
            1719, 31754, 34244, 52550, 16561, 58801, 25853, 43681, 39390, 12185, 9972, 47546, 1829,
            5990, 64073, 18298, 9266, 12496, 4894, 41007, 6298, 60698, 4441, 23191, 20980, 44225,
            26750, 26529, 44543, 60132, 53479, 24363, 10817, 6294, 33523, 21955, 35783, 814, 30126,
            41274, 13287, 20372, 38718, 43249, 10103, 41521, 41728, 15359, 23356, 13482, 47949,
            60925, 19649, 50587, 2028, 16188, 47406, 32411, 18392, 50087, 23556, 28540, 46938,
            34260, 24645, 1090, 17582, 12425, 40898, 18533, 57465, 9365, 16851, 36173, 49601,
            57394, 9303, 1450, 11421, 34731, 36704, 36258, 58268, 51543, 60559, 10002, 18373,
            38304, 63147, 46545, 11631, 36682, 65507, 61565, 13008, 37688, 35285, 10122, 16840,
            44192, 52338, 24551, 10878, 38335, 1428, 8548, 41925, 37327, 32416, 57973, 14418,
            65315, 54073, 7303, 35650, 38067, 26344, 33488, 6148, 58584, 11080, 36753, 48068,
            60853, 823, 28807, 24356, 42206, 36600, 60392, 34488, 18009, 9267, 4261, 30247, 1832,
            49902, 55776, 25964, 63822, 39898, 54359, 37226, 6056, 51461, 42397, 51733, 8952, 1902,
            28244, 5940, 55887, 21082, 57457, 54552, 46612, 30577, 49304, 29271, 52470, 24464,
            9714, 63341, 24988, 64426, 58887, 62248, 41551, 56777, 54860, 28940, 55726, 6549,
            22294, 55725, 30601, 42710, 14039, 52355, 7119, 42975, 36398, 1930, 23194, 44716,
            38544, 2894, 21186, 42457, 54454, 55759, 64726, 1852, 23267, 9989, 28219, 217, 39404,
            62326, 36654, 45520, 58659, 22569, 31612, 25724, 52933, 54063, 33087, 41451, 18482,
            56623, 6304, 65297, 62609, 53445, 20788, 41257, 22370, 45448, 65004, 37023, 6513,
            35082, 34973, 11324, 23313, 11166, 61355, 31282, 23348, 3442, 41310, 14410, 2014,
            22002, 61242, 60764, 50457, 28559, 36741, 53740, 61396, 19742, 20263, 59788, 45465,
            5999, 58492, 34682, 60825, 55849, 53614, 48937, 54765, 14165, 20739, 49363, 2825,
            36502, 9126, 61867, 63656, 55683, 33646, 55788, 1976, 48822, 27901, 36850, 36062,
            13705, 42944, 4739, 19406, 42522, 14031, 9424, 62422, 20085, 31389, 4691, 1664, 17488,
            59411, 51719, 53248, 53066, 11988, 11526, 839, 13086, 64255, 41602, 41621, 6730, 35219,
            45484, 21924, 35220, 8997, 54406, 1963, 18713, 1689, 48031, 64652, 2562, 56373, 45801,
            6715, 61166, 9535, 15176, 35880, 60603, 53642, 30585, 58224, 57970, 23717, 52159,
            55203, 64886, 43811, 21809, 60137, 52074, 2427, 41056, 52065, 48321, 61357, 31128,
            63474, 19282, 42205, 64338, 52686, 48111, 12309, 33128, 56312, 25846, 23180, 62647,
            1918, 47884, 43671, 32982, 720, 52850, 21660, 60389, 44679, 60224, 6524, 30144, 35778,
            58718, 39114, 2284, 26229, 683, 5325, 17429, 56506, 59126, 8096, 60346, 24052, 56057,
            12781, 18297, 61239, 17808, 29364, 43074, 14597, 61708, 56273, 46909, 49018, 36433,
            1378, 4165, 1576, 12138, 34945, 55039, 55036, 22472, 38716, 13039, 58305, 12691, 31453,
            31231, 26723, 43467, 34003, 48679, 18972, 41114, 28527, 46927, 55097, 4018, 37957,
            16218, 52456, 10564, 54694, 32175, 45058, 26121, 34762, 13729, 21576, 41371, 31687,
            2777, 6054, 21893, 1826, 7885, 11857, 30076, 17308, 22458, 41625, 42706, 20125, 42911,
            31021, 2016, 7295, 15907, 59269, 14430, 27729, 41255, 56802, 40413, 52836, 40571,
            19781, 19511, 39353, 2203, 20540, 50713, 28025, 11288, 23858, 30906, 14831, 51241,
            38482, 29467, 40739, 22915, 28559, 62212, 15451, 1785, 36094, 12095, 55418, 58100,
            14415, 42213, 3993, 27868, 25731, 53728, 53814, 56621, 9064, 11021, 55263, 6028, 48344,
            5647, 44402, 6470, 60431, 41746, 22183, 13371, 14935, 7984, 59835, 35098, 9046, 18696,
            60865, 11445, 32353, 37537, 42674, 39469, 56849, 36301, 64063, 34090, 45803, 45644,
            32168, 8650, 42425, 2885, 55870, 53898, 8613, 45166, 12328, 43003, 7596, 16808, 52606,
            33787, 8079, 5887, 34729, 8977, 4941, 64214, 12625, 23713, 35509, 35288, 27855, 61603,
            23221, 24087, 2651, 47664, 14691, 45924, 28964, 7892, 4004, 56152, 64321, 11425, 55781,
            24967, 27437, 60968, 28528, 802, 40192, 50137, 923, 30539, 5466, 35683, 31453, 53346,
            25938, 61027, 60517, 31683, 41838, 21897, 46743, 32110, 11414, 26229, 51251, 3953,
            19554, 56673, 7711, 52659, 54031, 49501, 34924, 3052, 41045, 55152, 38717, 50952,
            27832, 6652, 16988, 32005, 35892, 31525, 63326, 62447, 43759, 6586, 2966, 48284, 39202,
            11599, 18244, 61583, 64894, 8393, 52087, 56738, 63364, 33619, 30876, 37388, 38748,
            26641, 16052, 64964, 4936, 4889, 31626, 61209, 5332, 4895, 15946, 47219, 43451, 60011,
            46921, 42616, 6807, 44286, 53386, 15090, 3790, 9451, 42557, 21237, 58854, 17340, 39880,
            5134, 51854, 42730, 10774, 33289, 61764, 52806, 36261, 64602, 45571, 59385, 59626,
            35994, 17746, 16175, 24702, 17890, 23900, 28308, 6044, 36617, 51900, 58907, 28840,
            39632, 10362, 1773, 55690, 21503, 29648, 33760, 47045, 16792, 15348, 41911, 65046,
            27133, 58266, 50916, 22440, 11367, 61567, 51332, 20347, 30981, 21759, 20725, 30837,
            56781, 37830, 31915, 48263, 14330, 2594, 57138, 51927, 51244, 27232, 3128, 44021,
            51173, 7697, 32119, 17398, 32775, 21509, 46252, 27407, 62467, 45228, 49480, 61986,
            38413, 5459, 2861, 42474, 48881, 28027, 20981, 59394, 60034, 58475, 53265, 22845,
            44462, 9073, 51844, 46219, 37527, 28131, 15546, 38281, 14527, 5713,
        ]),
        c: 136,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_lengthy_5/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("c1155932fbf4dfa2b35cb98acc09f52cde342511a72a66655dd4d71c748efaf8");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_nil_3() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([]),
        b: Bitvector::<2>::from_iter([true, false]),
        c: Bitvector::<1>::from_iter([false]),
        d: Bitlist::<6>::from_iter([]),
        e: Bitvector::<8>::from_iter([true, false, false, true, true, true, true, false]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_nil_3/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("4c2527b09791d6a951c4dc5a5a2a7c441856d5473dcac3cb138b04a891f599e2");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_lengthy_2() {
    let value = VarTestStruct {
        a: 6378,
        b: List::<u16, 1024>::from_iter([
            56213, 56690, 5490, 50070, 64104, 50125, 17654, 6411, 61997, 28536, 45501, 33550,
            17405, 30649, 13300, 14528, 41192, 51965, 17404, 60982, 27197, 54125, 891, 29291, 4026,
            64060, 30878, 37389, 2818, 38130, 54714, 49140, 31623, 12673, 35472, 4012, 23691,
            44257, 15127, 7003, 9921, 59134, 3361, 37492, 46003, 533, 59373, 6187, 44573, 48111,
            61171, 3927, 54079, 12224, 40227, 59644, 18652, 34944, 44207, 55057, 27540, 17904,
            39424, 46910, 20815, 6330, 32172, 10904, 27684, 43829, 26441, 19196, 49116, 23580,
            8417, 63413, 8632, 36484, 61727, 24337, 52098, 45525, 48734, 8087, 25227, 24952, 60172,
            20489, 45524, 6155, 61837, 11859, 63895, 43556, 7585, 29924, 64302, 47897, 48852,
            56300, 22224, 10597, 57398, 49891, 33097, 5904, 26806, 6944, 30491, 17359, 17939,
            29460, 62085, 6539, 30209, 38401, 18968, 36704, 40001, 58447, 50270, 30679, 911, 60064,
            56770, 57687, 4741, 52537, 29645, 23002, 49040, 18468, 58066, 50512, 5886, 15505,
            42753, 11000, 59827, 40304, 49478, 62576, 24582, 36409, 38539, 9545, 21585, 53048,
            46585, 59128, 46710, 30126, 17367, 29162, 15679, 22249, 22546, 16182, 19513, 18682,
            59188, 24875, 10383, 1234, 6515, 4304, 58536, 44436, 60819, 55550, 61079, 53822, 18983,
            18896, 63873, 59599, 1235, 3018, 3987, 5370, 33022, 15950, 19533, 1721, 12416, 47618,
            41631, 41237, 28989, 56678, 28356, 19395, 57226, 45502, 59124, 23664, 27634, 35706,
            33915, 5924, 34244, 29604, 45893, 35512, 26574, 19766, 28385, 48108, 18087, 51932,
            26116, 47251, 38527, 30222, 43941, 19930, 50261, 46553, 59063, 40994, 15857, 56362,
            35908, 65177, 1035, 10334, 23318, 60257, 6546, 44603, 29092, 17553, 18581, 52255,
            64079, 13799, 56127, 58824, 32240, 26519, 17472, 40291, 14017, 26712, 31706, 1498,
            51383, 50896, 51354, 27156, 18490, 60346, 18593, 18881, 18741, 49251, 25622, 9718,
            58417, 45173, 51310, 61531, 64722, 7094, 30197, 40396, 35631, 61283, 29654, 45535,
            23902, 30598, 9970, 44354, 16946, 62686, 65110, 52174, 23433, 64107, 47176, 63584,
            35585, 15472, 5148, 4424, 24503, 22180, 28446, 52501, 29142, 36414, 51160, 48586, 5766,
            43971, 44634, 39855, 20297, 54455, 17995, 20761, 31464, 44231, 17891, 57603, 26332,
            47871, 36307, 48537, 42247, 916, 31939, 64461, 23668, 20397, 27954, 33666, 32545,
            28403, 314, 28446, 33962, 12817, 24764, 41250, 1217, 41522, 48036, 40577, 18544, 12995,
            16521, 59386, 17613, 19877, 43443, 50891, 31281, 29065, 21805, 63326, 10933, 36080,
            46469, 19587, 59395, 18320, 36997, 56079, 53301, 53776, 6863, 55275, 50765, 17305,
            34213, 51951, 14220, 41708, 24872, 47278, 64644, 42201, 39659, 63923, 57317, 19217,
            7205, 2669, 48342, 51903, 23325, 6618, 36489, 38246, 36686, 32461, 25775, 39783, 40256,
            21072, 21643, 62327, 58801, 52908, 36463, 22419, 36885, 14882, 40229, 8489, 6626,
            27723, 916, 45860, 23435, 23242, 43134, 25348, 19905, 18792, 33382, 18226, 53901,
            56490, 50464, 61880, 26601, 33436, 23972, 29332, 17761, 13596, 8346, 27867, 57762,
            6487, 5164, 30669, 49385, 36829, 6052, 2983, 59937, 40413, 48055, 5005, 64750, 30683,
            24195, 28954, 55842, 45130, 6613, 7661, 51429, 52102, 53711, 1534, 27869, 38164, 38469,
            3501, 29190, 57523, 15976, 23650, 34310, 28938, 28490, 46058, 20728, 49569, 52781,
            2263, 47277, 33251, 23620, 18727, 46410, 43332, 49060, 57302, 19180, 62007, 13476,
            24446, 29821, 47456, 17107, 63922, 48616, 28313, 57603, 56836, 12994, 40252, 37663,
            60847, 13190, 7953, 21467, 62514, 43444, 10018, 37838, 3473, 879, 23657, 59372, 24023,
            63455, 35378, 32761, 23690, 1281, 40517, 31178, 53835, 21115, 17994, 38655, 36010,
            43698, 42350, 56142, 12263, 40819, 10377, 55969, 49743, 49581, 61416, 48318, 36625,
            40034, 58589, 33135, 24630, 60840, 22381, 8971, 57488, 58984, 23117, 21338, 48875,
            10706, 16938, 48527, 46735, 45623, 51379, 17461, 43380, 62950, 10343, 23231, 31204,
            49074, 10899, 63867, 16638, 41718, 9629, 64242, 63955, 53544, 34682, 15526, 25620,
            39558, 53827, 26170, 711, 26461, 18868, 8338, 10873, 30987, 14510, 9769, 5087, 31384,
            29197, 4132, 57137, 10241, 62862, 47525, 755, 60182, 43238, 10344, 11225, 47119, 18784,
            1638, 45502, 32275, 14356, 63427, 42758, 24544, 30894, 14276, 50201, 56292, 39408,
            1498, 46856, 516, 29377, 25531, 43021, 64920, 30019, 34869, 61749, 62033, 17469, 27949,
            62966, 41220, 65037, 23504, 45516, 57547, 16717, 24198, 29283, 8884, 62621, 3860,
            19091, 15855, 38983, 57074, 20058, 5856, 65056, 62143, 18576, 11391, 59878, 24269,
            17669, 25259, 8468, 41730, 21483, 64015, 6373, 25019, 53269, 18973, 40840, 9583, 2649,
            841, 5068, 41928, 32078, 56191, 50434, 55626, 57951, 19260, 37211, 24479, 39731, 53369,
            8479, 60265, 35413, 53118, 13209, 31132, 24585, 808, 29774, 47757, 31849, 1585, 10441,
            25565, 57828, 13586, 31259, 37059, 64605, 22548, 23742, 43016, 54382, 20064, 15444,
            11306, 5699, 29994, 44387, 60028, 54857, 63979, 42457, 3607, 54872, 44551, 2385, 57022,
            52973, 65376, 12748, 42932, 22828, 50592, 23926, 2341, 47803, 11509, 5111, 55500,
            51645, 63861, 2668, 11548, 29883, 58149, 40166, 2193, 52824, 34882, 37249, 30557,
            64680, 42628, 46885, 8840, 17838, 59335, 37036, 7203, 50643, 340, 36113, 18966, 37689,
            47601, 55203, 23079, 64072, 64965, 47483, 39619, 20526, 15520, 48171, 46887, 41987,
            27322, 56677, 58814, 12813, 20499, 20988, 54754, 26252, 33450, 21117, 42892, 22453,
            14678, 48476, 53340, 36438, 44926, 2765, 5292, 54278, 2365, 47397, 51706, 8521, 2955,
            26381, 10240, 46374, 35385, 63226, 10718, 10184, 47615, 31534, 31102, 8947, 56566,
            45771, 29423, 5201, 10380, 27094, 10908, 50251, 4515, 64727, 61484, 26699, 44500,
            51169, 21347, 6324, 23049, 54660, 19877, 63898, 12550, 7801, 44396, 51651, 59938,
            40896, 49652, 22958, 20328, 50463, 20778, 61526, 492, 38905, 40124, 56110, 50710,
            37900, 14967, 49633, 36052, 2922, 32298, 44884, 38711, 64259, 43410, 60047, 32736,
            35176, 50514, 40000, 59754, 79, 13811, 46856, 40468, 11593, 43206, 53766, 46286, 21254,
            1028, 55528, 9153, 48331, 23094, 59826, 44199, 16351, 14987, 56860, 9643, 19996, 31437,
            38431, 32187, 22621, 2384, 28058, 1779, 60095, 46511, 58290, 38711, 42379, 49788,
            52918, 23405, 21794, 10169, 31634, 56761, 64534, 6488, 34581, 11348, 22963, 11391,
            58333, 14709, 8707, 50621, 28106, 39682, 14515, 2145, 52433, 23705, 30255, 18846,
            51493, 54189, 65404, 19446, 50743, 29933, 24975, 556, 31258, 28964, 2730, 50624, 5634,
            48038, 29965, 36247, 8272, 48400, 34074, 48962, 26709, 52827, 60618, 33499, 5976,
            11419, 21782, 38640, 22223, 64887, 28193, 34856, 41569, 17444, 44444, 30139, 37310,
            62485, 21992, 25391, 8215, 16392, 15120, 51019, 51050, 5778, 255, 20528, 24982, 16400,
            7819, 37720, 19899, 25289, 24536, 53117, 40044, 8589, 59192, 62749, 48819, 61910,
            53602, 9490, 61039, 57172, 29192, 22469, 57228, 34328, 31266, 39220, 27043, 27114,
            63188, 39647, 5268, 50746, 8495, 18351, 35797, 57052, 4696, 61775, 12605, 54791, 34979,
            45697, 38779, 33067, 26982, 2938, 6110, 37084, 19831, 7836, 33227, 27623, 19271, 8329,
            51158, 33965, 44071, 47508, 10894, 52334, 63719, 6808, 56243, 52946, 682, 48416, 26359,
            48885, 17707, 56903, 60483, 8139, 56249, 37205, 34338, 59837, 64288, 50997, 6618,
            53792, 30126, 30157, 3369, 27996, 9789, 42130, 13424, 10781, 13704, 35789, 40904,
        ]),
        c: 209,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_lengthy_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("ff4561a4611b946e3422adc157c64abd3ada3013475eb8d6f2920e5c6376481a");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_one_7() {
    let value = VarTestStruct {
        a: 14149,
        b: List::<u16, 1024>::from_iter([16482]),
        c: 230,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_one_7/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("92f9dcdd18f4dc0f8641862bd82cdf4081aefeb974f36bc74cda484ce7dc6637");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_nil_4() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([]),
        b: Bitvector::<2>::from_iter([true, false]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([]),
        e: Bitvector::<8>::from_iter([false, false, false, true, false, false, false, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_nil_4/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("a4c710723bb49c0db44a70044fa725642f265b6c9d1cce288f8d40c42a294c1c");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_lengthy_1() {
    let value = ComplexTestStruct {
        a: 63134,
        b: List::<u16, 128>::from_iter([
            15027, 15033, 56026, 45017, 4982, 62406, 9561, 49872, 52603, 11592, 55880, 4782, 36171,
            26861, 55558, 58823, 12551, 11511, 24886, 43494, 40213, 41920, 27461, 15039, 49814,
            26538, 36052, 14184, 10525, 50365, 9275, 23249, 1104, 30936, 24487, 53059, 41222,
            38145, 15502, 56163, 39867, 19511, 38728, 2915, 23614, 48179, 20924, 18112, 51366,
            53923, 42019, 23120, 45722, 40060, 36337, 32414, 51796, 9358, 59730, 55551, 7324,
            10685, 57486, 55930, 45841, 31863, 54502, 12634, 20045, 52645, 22003, 53987, 50618,
            40953, 27187, 11254, 33967, 42019, 35326, 47678, 49945, 11221, 57245, 54437, 20412,
            45170, 28640, 15880, 61263, 19478, 4927, 63744, 59926, 62295, 56389, 36956, 44117,
            3845, 3345, 6133, 54169, 5586, 43234, 7624, 9784, 3959, 2242, 62530, 30627, 12414,
            8430, 51041, 45125, 40760, 50229, 24210, 64534, 33741, 19262, 60229, 49611, 57320,
            35270, 2712, 4988, 6673, 50059, 46899,
        ]),
        c: 60,
        d: List::<u8, 256>::from_iter([
            106, 216, 87, 172, 99, 102, 184, 141, 255, 105, 248, 168, 165, 231, 129, 170, 137, 141,
            127, 63, 127, 154, 190, 203, 210, 76, 118, 183, 138, 67, 221, 231, 150, 246, 56, 180,
            183, 158, 12, 11, 25, 24, 198, 6, 159, 71, 249, 18, 36, 54, 105, 108, 148, 194, 129,
            35, 70, 54, 9, 254, 175, 114, 127, 2, 91, 108, 240, 57, 76, 64, 136, 192, 37, 202, 90,
            78, 95, 211, 221, 10, 36, 30, 158, 128, 248, 99, 242, 220, 72, 228, 198, 95, 132, 206,
            99, 102, 71, 116, 221, 205, 203, 207, 203, 79, 143, 155, 121, 209, 218, 255, 167, 121,
            114, 93, 223, 82, 71, 229, 127, 91, 223, 190, 36, 202, 220, 71, 189, 40, 105, 111, 255,
            156, 173, 96, 43, 179, 201, 68, 168, 120, 85, 43, 218, 112, 149, 239, 171, 215, 2, 130,
            188, 51, 95, 202, 232, 210, 140, 105, 36, 155, 243, 24, 22, 109, 92, 231, 6, 91, 150,
            16, 66, 77, 73, 117, 234, 93, 96, 12, 214, 172, 147, 232, 33, 161, 32, 77, 205, 85,
            131, 83, 195, 192, 78, 108, 180, 164, 200, 233, 87, 61, 110, 141, 103, 78, 10, 249, 82,
            117, 251, 212, 220, 204, 208, 93, 156, 160, 39, 156, 97, 194, 161, 6, 6, 12, 99, 186,
            111, 6, 177, 75, 52, 50, 215, 118, 35, 196, 119, 142, 243, 183, 140, 194, 125, 182, 40,
            48, 67, 72, 47, 145, 28, 165, 178, 135, 5, 139,
        ]),
        e: VarTestStruct {
            a: 16603,
            b: List::<u16, 1024>::from_iter([
                43809, 9135, 16086, 48583, 13970, 22509, 12263, 46555, 15163, 11156, 33631, 7319,
                3475, 39814, 64328, 43807, 29156, 12012, 55126, 30153, 58754, 18899, 25946, 15610,
                7685, 8906, 3696, 33019, 24544, 59865, 18399, 38783, 62712, 60126, 39734, 27342,
                6025, 57776, 30836, 24783, 45974, 7172, 64852, 65222, 17661, 23046, 57744, 8643,
                6970, 18089, 30272, 56662, 1355, 64699, 46997, 23865, 57731, 62231, 38548, 27234,
                4686, 5274, 31519, 31190, 35830, 64398, 48383, 15574, 7111, 27229, 29662, 16030,
                15346, 36806, 50186, 16436, 51502, 47299, 64895, 28076, 50356, 35869, 45367, 13305,
                58226, 11054, 32921, 19746, 58470, 38055, 60447, 32297, 16523, 51118, 22079, 29369,
                55573, 9637, 63509, 19251, 12334, 33272, 57584, 6543, 25311, 1008, 47382, 54649,
                11758, 17318, 28109, 18807, 29173, 37849, 45690, 63856, 24578, 17766, 56278, 50792,
                12391, 62332, 861, 64970, 56712, 33173, 45373, 8933, 35241, 1560, 61195, 6632,
                28453, 55691, 40908, 20061, 10534, 51476, 29293, 23408, 52911, 63477, 51603, 48647,
                25092, 39029, 7799, 40231, 49604, 34434, 19543, 54952, 37892, 44511, 44171, 8051,
                5605, 43788, 41808, 10904, 33271, 14349, 65498, 37830, 30095, 49014, 34133, 48215,
                322, 35881, 38942, 4928, 40524, 32813, 53672, 35444, 34072, 26883, 6655, 24924,
                31889, 19726, 10080, 39203, 110, 13331, 20015, 52470, 39626, 15358, 34326, 8369,
                22283, 63277, 37804, 30221, 18437, 18973, 13944, 24075, 31405, 32972, 12606, 51933,
                65088, 50106, 63839, 39676, 57664, 52661, 41475, 45638, 36472, 43132, 4539, 34909,
                17398, 35390, 54372, 42179, 31606, 25148, 53502, 49304, 25543, 40497, 1632, 47880,
                31860, 54855, 35365, 37471, 11315, 33647, 17189, 1538, 12915, 58947, 7324, 27091,
                49388, 54839, 44056, 38317, 172, 20887, 51675, 19699, 19703, 31360, 30118, 32806,
                54730, 12628, 50755, 64744, 10647, 13739, 31930, 34670, 16155, 19298, 22807, 24447,
                44735, 25934, 42539, 8932, 28991, 47497, 23569, 58967, 19264, 4448, 47848, 47792,
                56937, 3594, 52219, 50209, 35453, 34801, 60105, 275, 53205, 15415, 47725, 46290,
                23778, 23300, 2037, 53673, 12090, 54196, 60945, 42116, 3814, 19146, 38117, 11681,
                52641, 62468, 16251, 32734, 2685, 6113, 8649, 34804, 48046, 13099, 36263, 22932,
                43077, 12057, 54729, 27039, 57343, 60514, 56414, 40976, 60737, 58725, 29139, 58721,
                7733, 43270, 54753, 10973, 44469, 10570, 48231, 8495, 52167, 33222, 29145, 29337,
                55356, 43950, 7810, 30423, 59865, 65282, 51269, 22772, 65530, 48503, 15313, 1285,
                60948, 6379, 25255, 8121, 58504, 47676, 21291, 44456, 14666, 40036, 45249, 49365,
                40777, 56059, 59949, 18803, 36467, 11857, 57956, 39922, 44578, 3025, 53081, 32781,
                4294, 27700, 29003, 19280, 12064, 39319, 54733, 44768, 15327, 1206, 6149, 32734,
                7242, 7245, 13464, 25709, 64075, 24126, 65498, 3336, 65185, 52640, 46277, 7815,
                57319, 64332, 5945, 56674, 6729, 51606, 45143, 34377, 43833, 2892, 58697, 36254,
                54022, 61208, 50772, 30636, 63103, 40669, 2495, 33654, 60476, 8362, 51993, 59348,
                50512, 48627, 56968, 34687, 32674, 28498, 57608, 49904, 23372, 48496, 30231, 44997,
                42255, 45435, 26509, 8417, 31923, 17041, 20862, 1834, 46016, 62550, 7295, 12447,
                14795, 6053, 57763, 54029, 32788, 27850, 61916, 58099, 1982, 30124, 40816, 2766,
                64378, 26979, 26911, 30129, 51620, 27604, 28949, 12566, 26762, 27402, 22463, 33190,
                33972, 7271, 11931, 31616, 57428, 225, 10657, 43957, 57902, 8534, 32493, 16011,
                601, 455, 46471, 62529, 56085, 46166, 3427, 16865, 40692, 532, 8616, 5162, 20447,
                7734, 46917, 2407, 33522, 13136, 42667, 33656, 17231, 29906, 63852, 57087, 25575,
                16480, 24914, 41227, 37421, 54568, 27233, 13941, 14398, 57835, 28563, 1533, 4687,
                46872, 60329, 19690, 60298, 48517, 47049, 27694, 39374, 17730, 15231, 27522, 2767,
                43036, 19219, 34264, 52020, 62290, 15065, 6262, 47178, 37741, 29534, 32693, 55223,
                3793, 23317, 53071, 6297, 17129, 1084, 12097, 38879, 22003, 29287, 35932, 25739,
                8525, 19442, 51066, 64338, 21505, 19627, 55245, 50841, 59125, 7547, 21286, 52395,
                54057, 38734, 33986, 13974, 65144, 16106, 14745, 48756, 44516, 40837, 39257, 60012,
                54294, 53085, 30637, 55144, 56486, 5389, 23513, 53685, 22419, 64094, 347, 19087,
                9444, 30683, 35252, 15211, 36546, 21968, 43578, 46882, 32873, 7059, 51185, 53582,
                49587, 54622, 57587, 10114, 50398, 38660, 47966, 46173, 53920, 40284, 34441, 37508,
                41617, 2843, 25808, 2701, 16960, 65435, 64699, 2534, 47940, 27303, 32843, 45840,
                43034, 60033, 48454, 47506, 63470, 30546, 22690, 28892, 31625, 28032, 30391, 39288,
                44315, 1709, 6770, 32713, 52742, 33261, 2031, 56245, 27452, 17489, 26948, 56626,
                25891, 10915, 45382, 51551, 1447, 53972, 46519, 34979, 36229, 9860, 3484, 29042,
                20079, 18997, 1402, 14340, 61269, 41276, 27810, 29432, 8237, 39184, 8822, 57969,
                28769, 62653, 28315, 56607, 53230, 43104, 18950, 1195, 41178, 40620, 60826, 52714,
                23882, 58487, 56224, 23987, 55837, 62529, 2221, 1544, 18473, 42, 37793, 56643,
                29564, 50017, 20862, 58975, 27898, 13547, 14352, 30024, 37277, 25852, 24425, 8740,
                2446, 7274, 2910, 61004, 24552, 39845, 52144, 15430, 21841, 61626, 60080, 56930,
                2800, 25150, 65187, 60963, 2825, 16887, 32365, 64296, 3335, 61525, 23942, 38574,
                29398, 42380, 27196, 63483, 5422, 17873, 27408, 980, 27080, 58134, 37981, 58654,
                41902, 16065, 29352, 34791, 27269, 21635, 43679, 27005, 64730, 18072, 29466, 53775,
                6889, 25052, 1126, 12558, 35518, 43049, 13137, 64030, 49123, 16845, 18772, 44846,
                2593, 44948, 60663, 35501, 43962, 13486, 44953, 32332, 32946, 20164, 6146, 9727,
                57740, 20742, 12595, 46365, 56614, 22084, 6317, 65021, 37045, 13280, 25179, 31232,
                17378, 62137, 19290, 26175, 53089, 40575, 46274, 64051, 43276, 7803, 22037, 51835,
                24215, 178, 32839, 19120, 18755, 21044, 39579, 59105, 52837, 36488, 45071, 59349,
                63384, 18447, 28, 3518, 8874, 18842, 133, 45890, 36173, 49362, 57915, 14332, 56330,
                41248, 38912, 63718, 20356, 46898, 31554, 55369, 19062, 9200, 127, 7666, 18127,
                42883, 42201, 10403, 5932, 22943, 64786, 53451, 15877, 423, 2621, 39399, 38499,
                4520, 36693, 43222, 46353, 36711, 57964, 43398, 7073, 16417, 13834, 14266, 15790,
                25897, 21393, 45543, 50953, 42072, 33898, 48991, 16728, 4015, 58969, 64091, 37612,
                16181, 41807, 50711, 1932, 1791, 5531, 7596, 63035, 57933, 43549, 2920, 8843,
                26733, 6918, 29834, 24406, 50246, 16023, 24572, 10895, 35239, 61436, 43827, 41786,
                15722, 27279, 52841, 21595, 61861, 5624, 63255, 41644, 59788, 7875, 59566, 62491,
                23627, 40764, 43348, 29599, 38244, 36578, 47370, 45822, 1011, 24531, 29897, 37846,
                2893, 15870, 29212, 41476, 5611, 53742, 50435, 42809, 5405, 16218, 55762, 44472,
                62983, 6126, 40309, 26819, 28390, 38207, 37780, 44817, 48104, 37231, 47179, 49228,
                29088, 64569, 55009, 19922, 59137, 14282, 24667, 50932, 33600, 26612, 5060, 32216,
                41643, 8931, 23519, 44853, 63679, 58097, 57325, 50871, 45610, 58930, 61464, 43659,
                20570, 57545, 50595, 2459, 42741, 6160, 63273, 17454, 17927, 34693, 54867, 5447,
                31562, 63784, 6036, 22183, 22204, 18370, 38749, 48257, 27996, 43191, 48403, 17342,
                30870, 44612, 65375, 34411, 49212, 17629, 832, 11062, 11812, 24883, 61908, 56214,
                65118, 8156, 46627, 48590, 34539, 43110, 24849, 18621, 53361, 39585, 34054, 57930,
                24281, 19601,
            ]),
            c: 172,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 228,
                b: 3400495176621689780,
                c: 2782837041,
            },
            FixedTestStruct {
                a: 242,
                b: 11524830070205099188,
                c: 745207975,
            },
            FixedTestStruct {
                a: 86,
                b: 4411883652197834213,
                c: 1172881869,
            },
            FixedTestStruct {
                a: 43,
                b: 14564562638993582932,
                c: 1949588893,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 30799,
                b: List::<u16, 1024>::from_iter([
                    14556, 55222, 24251, 24293, 27235, 26958, 6438, 60832, 7215, 22695, 17144,
                    54587, 61706, 47463, 14773, 4854, 39837, 15514, 9141, 44675, 27253, 22362,
                    28392, 40731, 21612, 54045, 5781, 26217, 56460, 64881, 41020, 57680, 65287,
                    13880, 52279, 5846, 29036, 50062, 19738, 11373, 60434, 7130, 8227, 64105,
                    54444, 40315, 59712, 17241, 13550, 4700, 56140, 61280, 47635, 9319, 964, 56488,
                    15578, 43452, 12098, 17876, 16873, 62551, 39093, 27189, 54872, 57422, 3735,
                    64046, 64039, 31954, 15993, 18984, 60283, 6361, 46789, 42785, 13332, 31918,
                    27160, 52343, 52679, 54286, 38773, 54607, 59847, 62384, 26963, 46459, 33899,
                    48285, 39854, 8461, 2958, 23862, 38568, 12694, 57934, 58916, 3171, 27759,
                    34964, 6302, 51666, 7205, 30337, 18842, 34555, 41713, 29536, 21168, 58754,
                    21771, 363, 30290, 7256, 20252, 47998, 23556, 40739, 17033, 51474, 7401, 50679,
                    49735, 47305, 51765, 8270, 57990, 17814, 16191, 9226, 14888, 29, 30812, 59921,
                    62268, 47691, 28929, 9225, 53347, 51029, 33411, 11593, 21327, 47202, 38974,
                    48095, 49443, 63303, 10284, 43717, 37160, 61700, 24089, 61130, 20083, 35567,
                    34995, 55871, 7756, 15226, 56633, 20387, 13331, 8658, 32666, 51541, 63796,
                    22539, 53400, 12691, 33213, 52248, 43492, 12098, 61685, 38634, 3287, 50398,
                    15855, 11166, 65229, 20185, 36228, 12371, 38469, 22190, 58344, 12598, 2572,
                    11134, 47093, 52623, 3299, 43477, 11235, 11139, 46752, 3710, 62367, 42947,
                    4946, 27498, 705, 43305, 61060, 60143, 27517, 31065, 38648, 11199, 42291,
                    19735, 44971, 37078, 25592, 49935, 41192, 2488, 60095, 62630, 49877, 44753,
                    38876, 6094, 53516, 41457, 52845, 31569, 23301, 33034, 8316, 40753, 19410,
                    9092, 6612, 59485, 54815, 24910, 829, 11082, 6023, 15632, 37404, 23602, 34937,
                    28490, 14501, 46857, 2295, 1961, 37006, 51278, 24044, 23398, 29645, 34623,
                    38583, 62124, 62923, 47659, 15649, 28428, 29646, 678, 8332, 10965, 34236,
                    56552, 53594, 3605, 39484, 64402, 28026, 30609, 16502, 53763, 61311, 51658,
                    9914, 43182, 42103, 46559, 26671, 1103, 37378, 65332, 52477, 37344, 35287,
                    38760, 55241, 64071, 49612, 33094, 32259, 40962, 33646, 19645, 43641, 51853,
                    30409, 61156, 10026, 29813, 49648, 26448, 32412, 27328, 45121, 39106, 18453,
                    18718, 56097, 41358, 12420, 55211, 23373, 57936, 32039, 21907, 62933, 60621,
                    48588, 1438, 56083, 8707, 42191, 23084, 16085, 35176, 8884, 52825, 6273, 48998,
                    24022, 17108, 8257, 6866, 12342, 48899, 54001, 28090, 38925, 52560, 38546,
                    28992, 34307, 43464, 3518, 53589, 40150, 43840, 42707, 11231, 5273, 2326,
                    43213, 34992, 57773, 64470, 65156, 6707, 13073, 30922, 19089, 10095, 25809,
                    29796, 56113, 3918, 52182, 33662, 21162, 52741, 3396, 41269, 1630, 31035,
                    11627, 30437, 39583, 51163, 18537, 2789, 40419, 42790, 47780, 33202, 9659,
                    35203, 1675, 9623, 22516, 42101, 1244, 63558, 46536, 4757, 9228, 22978, 1111,
                    29752, 25019, 5374, 22596, 30775, 60334, 54534, 23115, 22358, 906, 21640,
                    54802, 28556, 10043, 29331, 23348, 9043, 39272, 26085, 29669, 19662, 16208,
                    34232, 19721, 17033, 32501, 51268, 64668, 9273, 112, 51105, 5090, 18774, 16722,
                    49529, 53521, 59295, 13507, 9208, 26709, 57166, 8394, 61444, 2869, 34477, 2673,
                    9806, 47275, 7356, 48361, 32519, 46320, 37630, 63924, 62227, 52074, 19676,
                    13768, 44794, 17114, 22579, 13988, 16042, 19260, 24709, 9126, 60050, 28983,
                    35407, 1981, 25374, 64260, 30768, 28960, 22351, 26592, 32378, 53284, 59178,
                    59194, 9727, 56100, 21791, 36486, 50857, 194, 25358, 63240, 39097, 20785,
                    14097, 57187, 39396, 59708, 24091, 65452, 17992, 19600, 40184, 4537, 64667,
                    19700, 42549, 42197, 63737, 4738, 63550, 5828, 2367, 41525, 55485, 53638,
                    42635, 47473, 14898, 5676, 37546, 7977, 19269, 12103, 31222, 55931, 61413,
                    50869, 62541, 22455, 61032, 38894, 33182, 53831, 1277, 19149, 3676, 25082,
                    55975, 33203, 55880, 28342, 31990, 8493, 40881, 38352, 3353, 28926, 60116,
                    6144, 14730, 9028, 48367, 60749, 60869, 31703, 48910, 37001, 4582, 57947,
                    37773, 59656, 48705, 39951, 22954, 19269, 49989, 51833, 1175, 34028, 22453,
                    14534, 20802, 16514, 3306, 46801, 12271, 17499, 34362, 50048, 63163, 21414,
                    42617, 29047, 16063, 47720, 2279, 21646, 37699, 20678, 24600, 5258, 7534,
                    21605, 54730, 54792, 57909, 55219, 52889, 14202, 50279, 11688, 50212, 23909,
                    54533, 49331, 65532, 37091, 31449, 45485, 61378, 14797, 64406, 5716, 968,
                    32257, 47486, 30143, 32992, 40587, 2360, 2748, 5867, 7880, 38105, 53759, 18957,
                    62817, 19433, 27156, 21744, 36370, 45295, 20204, 9493, 63319, 137, 37281,
                    20860, 55658, 59719, 33497, 54537, 15323, 58963, 37836, 16228, 46851, 32734,
                    32, 5874, 502, 44055, 53228, 899, 42636, 154, 41256, 48491, 12457, 59255,
                    44138, 32993, 57620, 64385, 32340, 26627, 55894, 3424, 49969, 23264, 35397,
                    34359, 490, 49359, 65418, 39386, 45830, 63227, 27112, 59864, 35938, 14413,
                    59271, 29434, 59797, 4758, 42380, 20292, 6298, 36596, 55049, 62380, 23445,
                    23848, 25498, 2250, 33407, 44083, 23451, 25449, 14514, 50239, 32414, 57696,
                    46504, 27760, 53667, 16794, 18360, 32469, 2397, 30070, 21997, 50802, 15192,
                    5447, 10167, 56749, 243, 51024, 50148, 47278, 30030, 20638, 40910, 57523,
                    54192, 23718, 55917, 32121, 64181, 28197, 63332, 21020, 28275, 45116, 14199,
                    9787, 13201, 46969, 38791, 39564, 56544, 60144, 17769, 58323, 3820, 56379,
                    63633, 56116, 50646, 47449, 36608, 58106, 36161, 47561, 57190, 43016, 9732,
                    18842, 3407, 15817, 27227, 26584, 44870, 26800, 37705, 27407, 57242, 4141,
                    34870, 43410, 19921, 64652, 17189, 27651, 65019, 53261, 59448, 19171, 2270,
                    4456, 63205, 62012, 20051, 43164, 15617, 63877, 35186, 3359, 54985, 57920,
                    57460, 11143, 25139, 24129, 33191, 27670, 27400, 54144, 1448, 48527, 47199,
                    60491, 49589, 48774, 57698, 27172, 33599, 22866, 7911, 59659, 43569, 48199,
                    60439, 56615, 20261, 64799, 54021, 19186, 2178, 21671, 17258, 29766, 48683,
                    37926, 37030, 27164, 3488, 38172, 41727, 32029, 33375, 51842, 61716, 51174,
                    50472, 19665, 28249, 14765, 23675, 14883, 32606, 55668, 39312, 26075, 62632,
                    15060, 17545, 40226, 58995, 43158, 11009, 31970, 5449, 26415, 8355, 3795,
                    58391, 3021, 60465, 58668, 30215, 53797, 28590, 44993, 5494, 48013, 37939,
                    23129, 58786, 5780, 49976, 47175, 1827, 58376, 33707, 30781, 36499, 26501,
                    3723, 55708, 35322, 4027, 49633, 11260, 48645, 43174, 5706, 47771, 17325,
                    58745, 38674, 30280, 8495, 17113, 39129, 42198, 47502, 13357, 13971, 17258,
                    26099, 25143, 9472, 20621, 40948, 62577, 60545, 40091, 1388, 38198, 2215,
                    56268, 58353, 5630, 48419, 50700, 18201, 63935, 674, 43023, 3196, 44845, 7697,
                    124, 24471, 4267, 7138, 42472, 30305, 57544, 61019, 29579, 51793, 41534, 50316,
                    58377, 61785, 52786, 37544, 61278, 18872, 4433, 46600, 16066, 56558, 29303,
                    34779, 51332, 3121, 20687, 49639, 61120, 1157, 32143, 42256, 12923, 5650,
                    59278, 54678, 55709, 7880, 56954, 39195, 18645, 38050, 45208, 29446, 56410,
                    57187, 19994, 41883, 35183, 27266, 14092, 7295, 12740, 53582, 52766, 4978,
                    5886, 60421, 48413, 44860, 37449, 55511, 53735, 64929, 64849, 3804, 57355,
                    6442, 59897, 42688, 48255, 64036, 3936, 18883, 6608, 23716, 60749, 64147,
                    60292, 33495, 9911, 3267, 2343, 60532, 30389, 33446, 40794, 25352, 26142, 4116,
                    29406, 15719, 61133, 64295, 24586, 34867, 36836, 14632, 52950, 10854,
                ]),
                c: 206,
            },
            VarTestStruct {
                a: 37045,
                b: List::<u16, 1024>::from_iter([
                    40012, 20147, 36304, 59222, 14275, 40439, 12833, 27481, 16102, 36518, 22014,
                    12807, 17727, 33809, 17208, 45861, 61773, 21505, 42225, 40102, 38056, 58524,
                    37981, 17397, 13087, 36293, 47576, 52952, 27090, 43652, 29267, 46696, 16852,
                    37112, 9531, 13325, 1466, 61863, 42155, 62232, 12589, 28753, 33531, 24078,
                    56683, 14224, 7090, 60762, 4722, 19589, 63213, 51906, 26344, 18995, 23765,
                    11486, 56992, 6725, 9359, 24923, 13926, 22031, 31792, 30944, 60351, 39062,
                    19921, 48559, 29761, 13049, 46939, 29256, 43454, 35501, 28042, 64171, 45372,
                    26888, 48905, 51339, 32221, 27638, 28617, 16252, 25820, 58631, 15852, 53646,
                    64640, 36283, 43676, 5838, 59027, 45762, 24511, 27023, 50613, 28369, 32983,
                    41790, 5336, 27837, 4168, 43765, 65137, 41046, 52071, 17284, 13059, 36003,
                    59279, 29416, 50090, 57022, 1989, 14276, 6207, 33414, 20965, 44909, 15013,
                    60567, 54810, 28900, 48638, 11177, 64319, 47831, 13075, 11489, 39025, 52903,
                    24991, 40957, 11799, 17348, 408, 61755, 64537, 34135, 39212, 64652, 25136,
                    48250, 11263, 46229, 60248, 52685, 34902, 32762, 38922, 45399, 49417, 2938,
                    21508, 65307, 63859, 7876, 57720, 25663, 54923, 33095, 31001, 30716, 51753,
                    17696, 36934, 59917, 34026, 9742, 46695, 41753, 62085, 47677, 34225, 32936,
                    36676, 15824, 58934, 30315, 42073, 63265, 57180, 5931, 7653, 23772, 37796,
                    46691, 57491, 35253, 40233, 15924, 8312, 51764, 22787, 28997, 10923, 8934,
                    41694, 4834, 3848, 9493, 26339, 19692, 22645, 62370, 33015, 64879, 42141,
                    23417, 55244, 21749, 5923, 20127, 45099, 805, 4061, 3069, 53926, 42858, 41811,
                    35544, 19671, 7512, 52226, 23952, 36654, 37186, 154, 48126, 56118, 48224, 950,
                    12048, 7420, 50752, 56476, 5741, 32248, 34848, 40286, 24084, 33667, 14003,
                    2032, 25472, 55337, 26201, 8175, 38831, 42511, 11217, 42707, 28091, 23108,
                    38837, 14045, 10260, 60295, 46509, 37159, 25573, 5177, 24741, 5753, 43034,
                    39289, 58363, 27404, 48758, 57944, 15448, 20620, 46900, 25590, 35364, 26062,
                    36508, 19601, 25034, 58475, 33925, 37339, 3252, 16534, 65055, 41647, 63677,
                    48556, 42838, 41823, 20932, 17658, 6347, 18175, 60908, 25572, 15000, 52779,
                    43200, 26729, 51503, 29562, 57961, 13004, 64270, 60277, 34380, 114, 51877,
                    37393, 38043, 48436, 37482, 7018, 36989, 33064, 3752, 2271, 29822, 32608, 1663,
                    19799, 48033, 17726, 9406, 34956, 62537, 20965, 20727, 23637, 25135, 7824,
                    64492, 24616, 10006, 9516, 55228, 37163, 52628, 8420, 27032, 18196, 12996,
                    28651, 11090, 48241, 3272, 45651, 5543, 37274, 33988, 15081, 25189, 42622,
                    2511, 51445, 49272, 41866, 17934, 60762, 35498, 1085, 60453, 8143, 61704,
                    10287, 26432, 60631, 24521, 42889, 37512, 58750, 2942, 33426, 32085, 7143,
                    14640, 56329, 45068, 62234, 59453, 42021, 5966, 16811, 25187, 32519, 31741,
                    63147, 6725, 40535, 42943, 44038, 54399, 58685, 15197, 28082, 31942, 56015,
                    2066, 28985, 52896, 19192, 56281, 30924, 34425, 47177, 34460, 51507, 42741,
                    14896, 26601, 2318, 56385, 7576, 20018, 11107, 40457, 55679, 27021, 15365,
                    12886, 28363, 30532, 23095, 23431, 5122, 7424, 45142, 44294, 16249, 31276,
                    54752, 44051, 48489, 6015, 12944, 15076, 6538, 31583, 64013, 29130, 5885,
                    14706, 57426, 24552, 20012, 25002, 46199, 34863, 17288, 40925, 42416, 17096,
                    64694, 3516, 32441, 64249, 51154, 53658, 31688, 47842, 34335, 19862, 35134,
                    4620, 28911, 23128, 5142, 13356, 39460, 28794, 16442, 45973, 29492, 43697,
                    14654, 28740, 20168, 44845, 37537, 56071, 8593, 63059, 39823, 28877, 15252,
                    31094, 42001, 14891, 63163, 20035, 43696, 64832, 55112, 23912, 34767, 48027,
                    31228, 49363, 28741, 29488, 10044, 15481, 54081, 58409, 22193, 55297, 1952,
                    43279, 21985, 55701, 12320, 31379, 192, 40191, 3965, 50958, 9405, 29711, 38711,
                    39068, 48864, 43048, 19592, 39709, 52789, 42656, 11163, 939, 3019, 17595,
                    54840, 4731, 15914, 6611, 54415, 30247, 59319, 25966, 37848, 22279, 54871,
                    38565, 40508, 23438, 15023, 40328, 21368, 47621, 43884, 48424, 46057, 65032,
                    32393, 29943, 36598, 26755, 41965, 29747, 29303, 28697, 39964, 43470, 51690,
                    41376, 21785, 55344, 7090, 32594, 32947, 12839, 19988, 47449, 28471, 24129,
                    49292, 19991, 58370, 46928, 62574, 20869, 33886, 41180, 18699, 26187, 57673,
                    14570, 46440, 38207, 47794, 7906, 64563, 780, 29956, 6168, 7699, 30983, 23271,
                    13490, 23984, 17101, 8174, 8475, 12461, 6430, 29468, 48872, 8198, 43557, 3774,
                    56496, 22672, 531, 38858, 1963, 4157, 4027, 24258, 35414, 58654, 26576, 63574,
                    28600, 38030, 40178, 21770, 1455, 15617, 11702, 2728, 3941, 45294, 35534,
                    13201, 7802, 55539, 33941, 62473, 1627, 4813, 59044, 33505, 47750, 44671, 6298,
                    43442, 2703, 41407, 50359, 56933, 60562, 12477, 63417, 36975, 22808, 12107,
                    5138, 3442, 35804, 15212, 53958, 10668, 31878, 56026, 7077, 27957, 10490,
                    42511, 41672, 33229, 946, 29494, 10200, 40814, 14410, 17119, 15869, 24487,
                    13358, 16618, 39310, 25590, 30117, 51290, 21107, 6419, 19230, 15869, 31117,
                    2280, 40448, 59248, 757, 41509, 37521, 63923, 17345, 17093, 58259, 2016, 42147,
                    8146, 10808, 64148, 3366, 22909, 1348, 18614, 51765, 28134, 64236, 41910,
                    28810, 60285, 38021, 55988, 32096, 4676, 9980, 42341, 50499, 3866, 14359,
                    45516, 38989, 60286, 50177, 12176, 47473, 46731, 44122, 11272, 16488, 28558,
                    14976, 39301, 28460, 41575, 29325, 24049, 13378, 39713, 14267, 7112, 62737,
                    19241, 27716, 38407, 41677, 27790, 25307, 27292, 54856, 36100, 7016, 36272,
                    39293, 4711, 35652, 524, 59838, 2945, 24996, 35616, 19953, 48279, 35041, 34115,
                    32979, 26300, 49391, 12088, 52389, 57216, 64926, 55031, 12448, 51541, 62389,
                    56322, 22336, 11570, 56399, 13062, 17281, 5848, 48155, 22250, 64970, 56866,
                    29747, 5708, 8341, 31396, 23899, 44477, 38975, 20551, 63525, 1988, 16141, 461,
                    19533, 8040, 33126, 37918, 52286, 19918, 23976, 48132, 46772, 61128, 63943,
                    19095, 65229, 30128, 62239, 1130, 34642, 25489, 15483, 43490, 29676, 17263,
                    14149, 36672, 28137, 35952, 25885, 10179, 21137, 56624, 855, 5073, 41001, 5119,
                    56247, 59776, 40332, 42294, 20132, 58808, 19313, 61043, 4484, 56733, 25618,
                    28810, 58373, 17674, 6171, 34843, 11786, 25399, 1144, 12727, 23261, 6449,
                    39312, 41019, 39024, 52056, 9872, 10047, 18372, 61860, 18740, 16481, 59082,
                    12694, 24320, 47466, 23533, 39700, 2707, 21902, 50810, 26154, 5844, 1972,
                    18853, 20426, 45366, 63924, 50390, 701, 59286, 26137, 14889, 15937, 60214,
                    34554, 34388, 20536, 30313, 33859, 11547, 35367, 43251, 48515, 9146, 59007,
                    42202, 59810, 18822, 32724, 3495, 7564, 2450, 63288, 53590, 64480, 15468,
                    60039, 54247, 30387, 53881, 51366, 14127, 23319, 21560, 40792, 44251, 24824,
                    57063, 17578, 31107, 55489, 35456, 12293, 62625, 20633, 37677, 22715, 47017,
                    29894, 3185, 51501, 51221, 62711, 64906, 1114, 32352, 58756, 52323, 57123,
                    59880, 54564, 12790, 57690, 48578, 48349, 20482, 40182, 25647, 30777, 60673,
                    25842, 35200, 43534, 7138, 18523, 27530, 34278, 47898, 7890, 56141, 58316,
                    34553, 6882, 57094, 20866, 18280, 31289, 21868, 14464, 34023, 34390, 62698,
                    12885, 50477, 10221, 34724, 20145, 27647, 58502, 42417, 17562, 49318, 64729,
                    19487, 54821, 45307, 13639, 23461, 11632, 2007, 58981, 37626, 1146, 20743,
                    10624, 20726, 1875, 36451, 19954, 33597, 54359, 19014, 6816, 59600, 5837, 9682,
                    17257, 38614, 19693, 50996, 34155, 53196, 8804, 64272, 15365, 506,
                ]),
                c: 165,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_lengthy_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("8edf67843395b2619b3d98e675e5a533be437a2164391889399bba6e4e8f5c46");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_random_4() {
    let value = FixedTestStruct {
        a: 141,
        b: 14877529853037520628,
        c: 761682555,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_random_4/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("3dd95177bc95d33d840bde460ca0c86b483a15e51f0a0eabe1998f05df5c7edd");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_lengthy_6() {
    let value = ComplexTestStruct {
        a: 3811,
        b: List::<u16, 128>::from_iter([
            53668, 15579, 54351, 30460, 22734, 24817, 58067, 27093, 43172, 7583, 31508, 17987,
            22578, 45349, 63406, 16953, 15482, 215, 55951, 50236, 65030, 17195, 34478, 56436,
            39178, 13504, 10962, 26642, 35363, 34750, 65094, 34944, 52252, 52387, 18841, 40676,
            39903, 2510, 26977, 51265, 865, 45298, 44314, 57523, 42380, 52460, 56453, 47329, 27505,
            27818, 49198, 19391, 10041, 17106, 61847, 28903, 26794, 61417, 52975, 1800, 57350,
            35440, 9709, 22868, 50054, 58390, 23066, 27877, 57177, 30799, 6053, 10140, 4418, 65064,
            37772, 27086, 61234, 31150, 16384, 46863, 44847, 58711, 25933, 3389, 35522, 31063,
            32912, 25682, 26834, 28911, 36410, 50641, 43417, 30597, 42842, 21182, 29256, 10153,
            34902, 32427, 58349, 62223, 27817, 34853, 50982, 45197, 59236, 1996, 9004, 11384,
            11541, 63527, 30766, 40467, 42520, 8912, 60430, 20150, 25536, 65294, 5125, 17995,
            39235, 35005, 7350, 20710, 61776, 1880,
        ]),
        c: 11,
        d: List::<u8, 256>::from_iter([
            23, 206, 127, 68, 96, 28, 185, 87, 18, 206, 94, 235, 156, 137, 17, 193, 39, 92, 135,
            234, 85, 44, 19, 55, 74, 177, 188, 29, 103, 226, 44, 84, 55, 101, 74, 230, 117, 236,
            218, 188, 128, 243, 92, 8, 46, 86, 198, 179, 87, 119, 166, 207, 247, 216, 170, 217, 96,
            7, 221, 152, 63, 161, 86, 165, 225, 110, 113, 186, 239, 173, 13, 22, 144, 166, 9, 69,
            40, 110, 100, 80, 88, 34, 22, 94, 202, 189, 35, 184, 79, 184, 92, 223, 47, 156, 23,
            163, 91, 64, 210, 70, 174, 184, 13, 171, 51, 100, 67, 53, 124, 37, 140, 79, 203, 208,
            206, 251, 68, 71, 250, 235, 176, 149, 149, 200, 182, 216, 217, 231, 126, 205, 40, 185,
            155, 147, 159, 159, 95, 19, 236, 34, 227, 25, 120, 170, 205, 39, 108, 110, 67, 120,
            243, 21, 65, 179, 40, 167, 179, 192, 109, 133, 10, 218, 28, 160, 243, 105, 24, 213, 56,
            78, 150, 246, 99, 88, 140, 110, 1, 94, 30, 221, 215, 133, 61, 196, 44, 220, 124, 185,
            44, 82, 160, 198, 81, 244, 154, 54, 213, 237, 162, 239, 41, 3, 69, 111, 103, 1, 201,
            29, 184, 248, 254, 179, 221, 214, 96, 192, 14, 153, 190, 34, 157, 176, 218, 235, 133,
            10, 98, 60, 237, 34, 156, 42, 29, 225, 204, 61, 236, 224, 119, 96, 63, 13, 249, 2, 162,
            234, 148, 37, 199, 237, 137, 243, 121, 155, 133, 193,
        ]),
        e: VarTestStruct {
            a: 17184,
            b: List::<u16, 1024>::from_iter([
                59369, 53687, 12570, 39161, 59430, 3090, 17863, 22211, 2669, 50509, 59882, 22858,
                49824, 20553, 9648, 49698, 5967, 21001, 65028, 10108, 39476, 59598, 34704, 8646,
                37968, 37897, 31296, 60081, 62822, 47017, 17915, 5145, 11738, 54916, 25290, 43720,
                20721, 6569, 33528, 10785, 29601, 8051, 4528, 38376, 50664, 53339, 30638, 20398,
                3683, 56945, 15937, 36951, 31088, 1674, 41055, 35522, 4853, 4534, 5708, 40058,
                15905, 13370, 36470, 25169, 20632, 21965, 15158, 12507, 882, 55238, 39589, 18301,
                22884, 735, 58426, 8608, 30099, 34829, 18361, 4599, 43627, 49126, 22766, 41253,
                20459, 13862, 17731, 24093, 43777, 20468, 20097, 41682, 62197, 46004, 12054, 14961,
                64176, 46905, 29880, 4368, 18864, 30556, 15212, 9247, 59219, 51053, 44791, 26776,
                60456, 53819, 56955, 1951, 42635, 43913, 16204, 40262, 28821, 46199, 55048, 5268,
                38787, 26400, 35184, 22964, 42226, 16680, 11207, 32214, 34858, 9050, 61054, 31504,
                57325, 26882, 48617, 1193, 9662, 22462, 40852, 60712, 31058, 12882, 65479, 64889,
                56631, 28126, 31786, 24847, 23628, 109, 14430, 54867, 45293, 8339, 38662, 2381,
                64710, 51029, 57378, 6786, 64775, 45346, 47054, 23888, 41221, 21552, 33824, 1854,
                62580, 7749, 42902, 985, 56878, 52609, 52844, 17699, 10114, 9858, 34795, 63453,
                2219, 6192, 16763, 10375, 31901, 31130, 20949, 62176, 61918, 8506, 2751, 21935,
                19114, 13824, 52063, 33857, 52476, 33393, 45905, 1866, 6936, 59985, 31557, 6979,
                11500, 49908, 61153, 20804, 26988, 1325, 60489, 34980, 48024, 10407, 6871, 27561,
                54137, 56016, 50769, 65432, 46878, 20425, 35598, 46223, 26851, 43520, 11083, 30978,
                5730, 63556, 35278, 25719, 55113, 5478, 48671, 62717, 63643, 20672, 56677, 65392,
                59009, 45242, 17687, 17431, 11425, 5198, 63974, 52844, 49078, 60779, 21326, 54842,
                9961, 20375, 49040, 20213, 45682, 19524, 45706, 7824, 16255, 16187, 58831, 30226,
                10506, 12203, 64340, 57345, 13141, 32577, 27515, 18489, 51188, 40114, 2949, 48940,
                26680, 49997, 18295, 26302, 59548, 31565, 16689, 11374, 31363, 28515, 45669, 28840,
                15379, 39937, 54961, 9285, 53444, 54695, 18707, 57091, 28485, 27678, 13805, 55370,
                15952, 50522, 2536, 55714, 20925, 62711, 53439, 57375, 53894, 42499, 33693, 35883,
                55297, 30218, 60290, 7191, 62751, 24426, 56214, 34725, 28773, 26048, 40568, 45997,
                18520, 2488, 26446, 57979, 64616, 6523, 39227, 39077, 10814, 27316, 4512, 3777,
                37195, 31629, 56082, 8526, 59343, 21549, 19036, 37873, 65011, 19568, 11078, 7080,
                45097, 44287, 51603, 17099, 4036, 16632, 50265, 35893, 43345, 50038, 21665, 3142,
                44477, 55546, 9366, 55448, 29773, 29014, 28527, 34707, 59802, 53765, 27216, 28034,
                3593, 8531, 34638, 28731, 14010, 32021, 4480, 40401, 23953, 56050, 29523, 9455,
                31827, 34026, 17107, 43270, 7050, 63996, 38298, 1298, 48022, 38236, 35171, 6375,
                41023, 32213, 50731, 24903, 15765, 10364, 40504, 5418, 52798, 32340, 4097, 51261,
                30060, 40747, 36849, 52137, 3808, 19961, 32008, 30895, 54287, 52624, 47677, 12487,
                50659, 64622, 32649, 5021, 55935, 59339, 45856, 42739, 42813, 414, 53430, 31005,
                50609, 16418, 26268, 26848, 900, 43362, 1176, 44999, 21361, 3058, 3329, 61641,
                55280, 38902, 43916, 1983, 52887, 63012, 58342, 51664, 62887, 46974, 34351, 48499,
                49047, 18556, 11978, 7063, 61734, 57109, 65177, 12245, 5327, 39202, 55123, 40082,
                6316, 45423, 54217, 10072, 6925, 53447, 18466, 27754, 47357, 53776, 13437, 31653,
                13471, 21062, 56273, 50069, 44566, 47743, 37080, 57940, 38546, 13805, 39582, 11099,
                30543, 40856, 8010, 58972, 39205, 10302, 18926, 34275, 20025, 64854, 58859, 22397,
                16419, 5630, 48611, 27645, 9519, 58634, 33678, 59924, 11508, 36577, 20014, 24184,
                2160, 37721, 10887, 43033, 26938, 14951, 25659, 17789, 20640, 16717, 62517, 33962,
                53805, 2497, 46491, 5404, 48334, 65356, 52186, 48158, 26782, 44497, 23125, 63869,
                38584, 21214, 46755, 9974, 44730, 34948, 4206, 42048, 16286, 25249, 42831, 58891,
                10275, 20747, 43294, 17679, 54866, 12893, 20687, 64671, 33902, 35109, 24446, 21001,
                22560, 28440, 31315, 34285, 6951, 59745, 35419, 41182, 32435, 31764, 31778, 46523,
                51953, 15682, 28523, 53325, 50132, 38317, 46725, 18939, 55067, 56698, 39978, 53906,
                14483, 35592, 32977, 31505, 28480, 19994, 25060, 46073, 11287, 40659, 37444, 10019,
                20976, 42683, 56405, 15647, 2139, 27532, 23574, 3405, 10848, 29620, 9891, 49743,
                3659, 53838, 12335, 64348, 14180, 23699, 54596, 24746, 11277, 34639, 62599, 27559,
                54469, 7986, 24429, 63411, 51961, 25325, 27962, 45597, 43207, 59884, 37600, 47896,
                23440, 28985, 17759, 15175, 20812, 44569, 11648, 2445, 2547, 10443, 26976, 64387,
                48064, 62187, 42657, 64823, 17531, 5499, 62738, 4928, 60640, 12039, 52690, 64951,
                55795, 39093, 24211, 31382, 983, 53152, 33889, 38780, 50039, 47730, 49479, 57141,
                6027, 32006, 53012, 53988, 51614, 4085, 53782, 28969, 18301, 63374, 56984, 55478,
                16687, 772, 32990, 59305, 32300, 45594, 22768, 41224, 62228, 35857, 3946, 9389,
                15951, 8838, 5998, 49547, 17878, 21177, 11729, 37860, 37265, 37883, 45491, 31615,
                17208, 669, 61877, 47969, 10331, 42942, 12634, 4704, 30741, 4325, 39356, 11383,
                19210, 48664, 30365, 55558, 24065, 22970, 50995, 64266, 33696, 37543, 57085, 11944,
                19624, 20961, 64562, 26022, 43090, 4975, 3719, 60358, 50565, 26522, 21941, 27352,
                32846, 10316, 27274, 52255, 4139, 13232, 23075, 5956, 15618, 6838, 29241, 16121,
                18590, 33835, 62976, 24294, 4236, 44277, 48144, 33708, 5260, 1125, 31974, 24100,
                52755, 57691, 33401, 55406, 35893, 39810, 40516, 31625, 48075, 16067, 10472, 2451,
                29373, 35575, 13384, 64609, 24827, 48314, 46332, 61496, 23730, 63986, 4446, 27749,
                60825, 27415, 60957, 53068, 36771, 39965, 56202, 9083, 63771, 46114, 48850, 49914,
                57377, 12698, 41935, 52264, 61566, 55021, 35163, 24740, 45998, 29660, 52828, 27484,
                28787, 61850, 54104, 35530, 7373, 56657, 40295, 14445, 57763, 47856, 53837, 18523,
                45390, 24388, 26471, 38936, 63502, 1791, 51251, 14292, 31815, 55645, 22124, 198,
                31124, 50124, 60554, 12197, 42194, 7215, 28703, 50953, 46197, 35764, 43501, 1505,
                6640, 63262, 51772, 56840, 25288, 27496, 38161, 51063, 32680, 23705, 12486, 13106,
                23863, 40240, 55526, 15361, 54764, 49655, 16975, 52821, 37487, 18022, 35656, 25004,
                3798, 23595, 9486, 30723, 53884, 57907, 13600, 23494, 34758, 6125, 52471, 59052,
                20726, 4456, 41166, 3445, 944, 30855, 3938, 39365, 60479, 46851, 25921, 23572,
                44699, 19690, 17601, 9294, 48025, 62309, 63039, 5945, 40147, 40248, 30163, 7883,
                44262, 53301, 40053, 55808, 44905, 61604, 669, 59464, 4273, 51298, 27900, 59252,
                64228, 35589, 43883, 62461, 22710, 55778, 19633, 58823, 28784, 16077, 22747, 8268,
                63493, 58144, 8674, 376, 43580, 63447, 7363, 65509, 31876, 38802, 51621, 60130,
                53630, 43744, 3769, 32622, 46635, 45858, 16491, 58299, 893, 9978, 43663, 30752,
                39282, 35577, 50070, 9185, 16642, 39582, 12262, 25045, 59891, 37727, 47173, 10716,
                16822, 5715, 29662, 35, 39780, 42432, 37969, 27245, 3570, 1346, 53054, 18591,
                28480, 50803, 27633, 2699, 13511, 59700, 40383, 39077, 56934, 41897, 10201, 12963,
                45342, 46010, 40780, 42470, 39053, 48233, 55776, 43951, 60952, 54600, 4599, 62155,
                1892, 47008, 3379, 36053, 54895, 32445, 63889, 44565, 5123, 47150, 29285, 61861,
                51390, 40000, 62525, 51618,
            ]),
            c: 72,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 250,
                b: 6141795178871855673,
                c: 240645572,
            },
            FixedTestStruct {
                a: 21,
                b: 4877910149201583175,
                c: 1417391071,
            },
            FixedTestStruct {
                a: 84,
                b: 7661562362140687688,
                c: 34213759,
            },
            FixedTestStruct {
                a: 148,
                b: 17897429674566788394,
                c: 859275185,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 59524,
                b: List::<u16, 1024>::from_iter([
                    10829, 17303, 14277, 18963, 26241, 29327, 14882, 15208, 16925, 43597, 63407,
                    22188, 9080, 32634, 27816, 31164, 62634, 43697, 25236, 21639, 49155, 62153,
                    42459, 8754, 63899, 3773, 30550, 31486, 42200, 23508, 22649, 40233, 64909,
                    58136, 29268, 23491, 43831, 54614, 32649, 34803, 4503, 40920, 17028, 11498,
                    5441, 25244, 12038, 44684, 52919, 46024, 61494, 13879, 16946, 44122, 13281,
                    12881, 41775, 65006, 42076, 10505, 40143, 34603, 4030, 64491, 26608, 17982,
                    26953, 33797, 31453, 48743, 43486, 17025, 31087, 821, 52611, 9933, 17022,
                    10248, 53814, 63518, 30466, 44358, 6696, 61013, 45985, 65252, 52476, 20982,
                    23284, 61884, 51368, 5673, 15481, 19431, 3358, 11464, 4673, 42707, 52054,
                    61137, 46937, 51377, 21535, 15120, 48203, 25496, 32564, 12175, 9803, 46362,
                    30395, 40246, 36898, 44829, 8585, 19954, 64971, 25362, 9883, 19115, 8842,
                    58710, 42571, 11367, 29933, 45983, 11034, 59508, 24039, 5616, 23038, 30185,
                    61232, 64372, 41890, 19531, 42215, 57345, 43408, 8060, 24106, 25020, 52510,
                    38991, 61735, 38145, 46877, 27423, 3309, 21204, 8143, 5051, 51914, 46824,
                    21030, 6891, 26973, 11863, 28466, 27450, 2527, 51543, 14911, 21882, 19565,
                    54303, 19662, 25798, 31502, 9075, 62792, 49623, 23414, 14861, 65416, 4226,
                    2008, 49016, 29194, 19835, 51380, 5755, 40770, 31484, 43928, 10351, 11727,
                    25702, 58126, 37719, 52682, 42108, 59305, 7372, 289, 64507, 62580, 13835,
                    24241, 60477, 60121, 24444, 15733, 37288, 34648, 44120, 40895, 18533, 42645,
                    215, 56618, 1989, 63331, 56068, 60311, 10840, 8487, 18087, 44964, 48359, 57762,
                    1169, 6688, 54151, 39816, 52091, 43107, 21641, 56201, 25746, 19717, 15893, 654,
                    29840, 28169, 52558, 16703, 13994, 31133, 54566, 34082, 65437, 32360, 29933,
                    52655, 61439, 16938, 47562, 24921, 44634, 34257, 39447, 59598, 59472, 43706,
                    26065, 48002, 28380, 18207, 629, 43865, 3243, 51644, 54683, 44853, 29618,
                    57015, 26648, 49254, 9596, 21030, 41724, 46454, 23808, 10018, 50893, 46422,
                    5251, 39365, 30830, 20429, 38407, 8564, 28002, 53564, 48937, 33163, 15429,
                    15749, 2993, 24196, 1219, 5311, 50065, 44914, 37887, 59655, 61649, 53208,
                    54533, 47065, 59893, 19225, 39982, 44831, 41041, 46626, 64086, 36379, 48387,
                    16249, 40636, 36520, 37238, 30167, 36199, 42774, 22724, 31869, 20324, 40607,
                    44299, 24685, 32488, 1935, 59249, 28563, 49592, 29837, 28784, 26734, 48026,
                    40239, 4445, 52448, 6425, 2400, 38266, 30416, 15235, 30324, 2333, 42479, 53606,
                    59885, 9452, 2350, 24415, 3614, 61364, 48457, 1498, 9036, 8070, 20971, 3733,
                    22393, 60486, 6966, 6830, 61645, 34014, 45532, 21062, 4815, 40350, 8731, 10248,
                    32955, 47230, 14286, 31244, 49723, 64216, 12573, 12644, 44735, 19615, 42728,
                    40653, 8495, 6463, 17091, 11961, 30409, 57657, 38752, 13856, 15847, 62969,
                    4789, 15671, 33889, 40836, 46091, 47581, 35699, 1886, 64209, 196, 49619, 16402,
                    35657, 44018, 59823, 60110, 48784, 25695, 8509, 9033, 5485, 45987, 28498,
                    28543, 18362, 14544, 10102, 60514, 58998, 31860, 23063, 15291, 28445, 7425,
                    33623, 3575, 7521, 23322, 30292, 52055, 19063, 51342, 41872, 23888, 54621,
                    60424, 19240, 17936, 61444, 13973, 63622, 16994, 40654, 32290, 9233, 60248,
                    45059, 16571, 10451, 388, 41036, 60733, 34731, 1248, 40854, 34310, 32783,
                    54912, 62483, 10302, 21839, 25216, 44642, 39043, 44447, 12619, 33529, 5184,
                    62792, 32156, 16330, 55631, 2046, 23113, 33092, 1251, 49534, 32221, 23739,
                    39058, 2686, 32575, 18530, 19538, 30073, 22914, 63457, 21377, 62501, 19103,
                    22077, 61408, 30878, 60002, 2576, 61082, 56812, 35834, 16671, 26752, 32064,
                    23410, 15114, 33432, 36189, 7828, 64559, 51227, 39867, 6683, 13568, 64345,
                    40496, 1037, 52134, 37084, 9142, 43639, 47880, 16270, 29532, 10371, 22449,
                    44545, 41895, 55699, 59155, 21055, 65507, 1817, 5402, 41200, 38564, 21735,
                    59250, 15662, 29713, 1806, 54410, 31841, 3973, 44962, 40499, 22720, 30538,
                    11332, 34374, 37028, 61218, 33097, 38835, 1146, 26430, 35935, 14509, 60165,
                    50617, 12495, 8743, 64394, 26725, 42910, 1047, 62399, 45584, 2281, 62128,
                    54498, 8783, 12877, 32881, 3839, 19700, 18676, 19274, 2522, 48559, 34038,
                    20723, 24550, 7503, 35805, 28985, 33951, 54134, 51404, 57864, 65463, 43076,
                    46714, 56641, 63660, 8794, 61384, 60531, 9664, 38903, 10161, 15870, 30598,
                    13795, 16437, 40506, 28740, 6154, 60428, 49781, 57444, 43731, 19968, 28634,
                    55137, 13786, 6134, 1519, 40282, 35940, 25174, 50285, 41906, 61046, 21095,
                    47444, 36991, 31116, 43711, 61524, 39282, 17378, 17051, 12921, 38646, 35919,
                    44758, 16522, 21515, 10094, 24938, 23822, 15701, 3835, 52747, 29305, 17662,
                    8633, 56088, 3070, 3360, 17883, 20682, 46010, 646, 26974, 31499, 43764, 25366,
                    25701, 28938, 37614, 58246, 28876, 56429, 48124, 26057, 3323, 34945, 29008,
                    40465, 40907, 28642, 52930, 44602, 5221, 27830, 3138, 31935, 21989, 14863,
                    17154, 4971, 400, 25004, 25841, 9157, 26822, 30926, 1715, 4031, 43256, 25072,
                    62071, 38596, 24388, 64715, 61618, 40439, 30437, 57693, 15064, 12610, 26813,
                    62837, 60826, 22328, 15650, 51738, 11278, 22588, 8096, 47194, 40188, 12709,
                    40663, 24962, 47915, 3999, 26531, 25148, 55305, 10590, 2934, 50982, 63596,
                    30391, 1241, 56272, 49079, 28504, 30694, 64376, 45874, 38405, 52669, 31784,
                    9810, 38049, 61769, 17896, 39815, 33058, 36507, 30802, 43174, 13842, 9532,
                    3986, 30556, 9170, 58461, 60882, 9645, 2747, 61918, 9507, 35029, 14685, 25016,
                    4132, 2229, 10158, 61199, 45253, 17766, 13821, 58966, 21249, 49476, 15232,
                    27071, 45929, 7407, 48478, 16799, 56816, 7577, 13357, 51450, 51323, 36165,
                    7604, 60233, 14632, 22801, 63658, 61743, 57000, 45560, 12439, 50497, 1737, 661,
                    60834, 3218, 11662, 63660, 22961, 38192, 32605, 35503, 20075, 51982, 55188,
                    50737, 48657, 2448, 43453, 25893, 40412, 20129, 29870, 50190, 38953, 27855,
                    30688, 20362, 808, 30355, 53214, 4536, 29502, 36597, 50964, 2098, 56085, 15741,
                    3210, 4346, 45395, 48777, 64625, 25194, 43703, 15077, 29871, 16452, 15502,
                    22278, 6070, 36034, 34465, 33077, 56059, 34837, 65063, 9523, 59050, 25322,
                    10260, 47546, 36821, 23635, 22743, 3881, 25441, 41951, 56260, 36813, 30884,
                    9080, 53639, 29467, 62037, 59505, 10290, 41577, 21843, 22248, 19168, 61051,
                    12845, 12552, 22163, 18666, 56439, 63015, 6673, 57774, 2087, 2859, 7621, 53684,
                    8000, 8837, 39627, 2328, 35823, 30843, 17826, 60431, 10991, 40223, 5530, 61596,
                    4337, 11434, 54912, 33118, 35117, 31593, 34435, 20067, 28565, 57213, 2946,
                    48275, 63039, 30883, 26791, 4894, 61034, 60199, 38558, 24715, 14570, 61617,
                    17923, 4570, 57095, 41794, 32421, 32162, 1552, 29918, 30492, 9783, 8326, 17119,
                    2817, 25380, 786, 54780, 32247, 32633, 29672, 25028, 38667, 30829, 44200,
                    56739, 43971, 43486, 51603, 61797, 1846, 22999, 30932, 30404, 52770, 24960,
                    1720, 20527, 2063, 63381, 8403, 23610, 27404, 31122, 46604, 40343, 61974,
                    29104, 13733, 15144, 18222, 7145, 44018, 202, 53993, 43841, 18802, 10973,
                    46184, 36611, 36570, 11686, 20815, 12120, 55460, 62963, 58393, 19002, 14194,
                    61571, 1966, 37737, 877, 43509, 50443, 51770, 28544, 30703, 22948, 14718,
                    33988, 37425, 29980, 28674, 62494, 25223, 34219, 31488, 46045, 29638, 2399,
                    11514, 14584, 64887, 56279, 22625, 8510, 42610, 12916, 48421, 36341, 21345,
                    62956, 26679, 35104, 56011, 52969, 33573, 59036, 62433, 9469,
                ]),
                c: 219,
            },
            VarTestStruct {
                a: 39373,
                b: List::<u16, 1024>::from_iter([
                    56408, 61365, 9279, 903, 31115, 9775, 20507, 30317, 59362, 20743, 16552, 36108,
                    22961, 29672, 19552, 7599, 53970, 10548, 44814, 26173, 34010, 47860, 51321,
                    6361, 25857, 31826, 39286, 47620, 11766, 56215, 4605, 10337, 62081, 24409,
                    53653, 40085, 41398, 63566, 64952, 7760, 50321, 44674, 37374, 56430, 59559,
                    57198, 49443, 34044, 35741, 161, 43887, 52933, 62906, 43096, 51604, 15862,
                    51233, 15259, 21807, 57071, 3441, 1511, 31170, 41454, 8954, 9172, 57618, 43042,
                    3033, 44658, 9027, 36312, 19295, 17776, 28204, 35318, 46442, 58706, 36036,
                    55999, 5093, 43984, 965, 9625, 7709, 63228, 20605, 37067, 6769, 41433, 53186,
                    34211, 50131, 39599, 2251, 63553, 37999, 43484, 55553, 53746, 18529, 59223,
                    38433, 59691, 38064, 12606, 65327, 33034, 7029, 24552, 44816, 41365, 51567,
                    64669, 19201, 42688, 38528, 39033, 48477, 12300, 5379, 9857, 17916, 19525,
                    42405, 52703, 3852, 46739, 9812, 17890, 5110, 19733, 51544, 31208, 52707,
                    55511, 18006, 56766, 64208, 25867, 47373, 3584, 14260, 61945, 36972, 59330,
                    2192, 32828, 57735, 34283, 26208, 9812, 40824, 53320, 39120, 42817, 37540,
                    16163, 23237, 10288, 56744, 12702, 48690, 20825, 63661, 48530, 35032, 17795,
                    38732, 17563, 31140, 32650, 13005, 47348, 42202, 18107, 37143, 37550, 36987,
                    42833, 39673, 45124, 29712, 57705, 65523, 11334, 8638, 63758, 1347, 23256,
                    61794, 28643, 7932, 53994, 48123, 15101, 32415, 11693, 44867, 4018, 20981,
                    56304, 18567, 46173, 42624, 62493, 17947, 11444, 31601, 63509, 53688, 26705,
                    34780, 59441, 4223, 1165, 22437, 24073, 38315, 35752, 6247, 21960, 41883, 2717,
                    2748, 15746, 65014, 25763, 32571, 38705, 6829, 57172, 74, 14509, 10460, 31342,
                    29941, 8177, 59076, 34973, 3263, 11501, 30166, 24257, 38183, 63535, 50092,
                    32889, 36441, 63354, 38305, 53303, 3213, 23681, 5572, 35388, 462, 46461, 43912,
                    1274, 7902, 55595, 37884, 60574, 25109, 2975, 33298, 19114, 31205, 2818, 34665,
                    3779, 30793, 44724, 9318, 36591, 27289, 52378, 61104, 14355, 55356, 44330,
                    48788, 876, 51257, 12199, 13437, 8114, 60774, 45122, 40045, 36910, 24480,
                    56455, 10682, 17842, 11909, 41220, 6856, 41577, 49591, 12315, 25184, 35994,
                    22365, 39470, 10816, 5525, 37553, 59359, 33060, 55583, 39312, 14458, 47779,
                    26227, 36099, 51332, 40196, 53651, 35193, 9747, 43226, 16553, 44826, 53065,
                    53981, 42011, 20347, 9362, 22629, 23709, 31994, 56931, 58737, 25703, 2646,
                    16284, 49768, 24647, 29236, 60764, 58527, 56369, 4809, 23250, 27806, 35791,
                    11102, 53887, 25276, 2069, 9642, 20266, 65073, 43662, 20761, 88, 18462, 18770,
                    36031, 4105, 46450, 40725, 27026, 45763, 20160, 429, 5378, 62493, 27072, 27921,
                    9339, 41361, 26215, 25124, 12275, 53621, 31447, 54567, 13015, 12057, 11482,
                    25284, 26461, 19772, 14671, 60076, 42970, 20545, 39285, 48806, 18526, 46229,
                    44984, 21961, 27652, 30916, 43254, 1353, 27819, 2085, 31258, 30774, 20656,
                    50391, 34354, 27482, 8365, 30907, 49104, 37886, 26300, 58764, 63180, 51505,
                    51538, 48915, 58450, 43428, 23072, 907, 20856, 56490, 24597, 51995, 31526,
                    57710, 5956, 61340, 16289, 45515, 27164, 40244, 39283, 52718, 60463, 51324,
                    40090, 50027, 6180, 40208, 64746, 3223, 15740, 6757, 28504, 55684, 36883,
                    55243, 12637, 34100, 37747, 30475, 57033, 12707, 20514, 64054, 58313, 63005,
                    7186, 18098, 52147, 31769, 58224, 10269, 47788, 33651, 60201, 53800, 60066,
                    4852, 10085, 16673, 45807, 50849, 15683, 16611, 20278, 55287, 13271, 35013,
                    1689, 26596, 8575, 13853, 54389, 26815, 63362, 1162, 45603, 12844, 15331,
                    44479, 62876, 15124, 42689, 64522, 5962, 52582, 65003, 7455, 17444, 9843, 2507,
                    47649, 12074, 53249, 48525, 48339, 22658, 62104, 56643, 8052, 1926, 57580,
                    27728, 59257, 25315, 55397, 54876, 34273, 28664, 36367, 11384, 55072, 22230,
                    28482, 45237, 11017, 50303, 19031, 43158, 60141, 5823, 43913, 48924, 11649,
                    60267, 41252, 7662, 40135, 15391, 47957, 6024, 48096, 49336, 16173, 218, 8025,
                    38298, 1174, 44144, 40840, 62862, 12391, 23517, 25079, 28163, 3556, 65389,
                    10016, 11329, 5151, 64198, 3087, 47921, 61681, 59733, 4636, 14097, 46441,
                    26571, 48353, 19188, 40806, 39466, 23284, 2134, 25586, 18548, 28201, 42970,
                    24783, 8710, 28849, 39846, 14968, 1740, 1999, 10183, 36907, 20290, 7701, 39671,
                    38204, 26550, 37541, 49517, 40336, 10442, 15375, 11919, 23004, 52051, 44718,
                    35874, 49033, 59164, 36017, 14593, 57643, 23764, 37436, 24119, 27665, 14245,
                    45119, 1851, 37551, 21221, 10187, 60022, 10133, 45798, 9089, 64769, 64484,
                    59298, 9143, 57804, 60470, 40461, 17021, 46515, 21246, 19362, 29937, 37197,
                    17341, 19247, 46329, 65029, 59777, 12984, 1102, 20472, 52710, 55114, 40355,
                    38902, 39954, 15988, 42346, 50944, 3324, 14443, 56291, 56624, 51149, 4837,
                    45824, 908, 10990, 43762, 47420, 36392, 32029, 63092, 935, 60270, 674, 32785,
                    43706, 21294, 63739, 5275, 5377, 5008, 12934, 45320, 15789, 35750, 51030,
                    14462, 30912, 28011, 20382, 36812, 53357, 54641, 12664, 38116, 19877, 29424,
                    23640, 48978, 23960, 25192, 8992, 32128, 52536, 12631, 18256, 37548, 3018,
                    7890, 18852, 39566, 51167, 43999, 30760, 36030, 61600, 17772, 2949, 15782,
                    38531, 47300, 33921, 33352, 42288, 59053, 52902, 7250, 8833, 7777, 61704,
                    55278, 63261, 27673, 54921, 10021, 20363, 65048, 31217, 7995, 12296, 15459,
                    52384, 42841, 20855, 34718, 17523, 58745, 19668, 51517, 4777, 49166, 381,
                    13850, 47185, 10574, 64896, 55259, 51528, 16563, 13922, 23108, 38405, 6296,
                    64938, 41784, 62733, 62107, 9510, 11039, 14394, 5439, 1153, 11329, 65097, 4409,
                    39356, 44464, 50017, 43656, 55395, 5742, 37521, 59587, 53723, 22784, 1127,
                    54952, 40911, 46916, 11831, 24047, 58220, 49096, 45647, 53394, 12747, 6050,
                    12594, 58420, 6597, 57068, 39976, 64932, 22677, 17311, 46285, 35171, 57310,
                    41922, 37499, 58495, 22969, 8233, 12616, 35337, 26983, 30778, 33390, 12639,
                    49801, 12443, 49862, 37771, 48668, 51982, 60969, 2628, 3656, 24376, 58479,
                    39986, 63823, 58562, 61111, 49358, 55661, 6518, 23302, 46538, 35358, 44050,
                    7160, 44683, 16253, 51841, 29263, 59470, 42534, 51112, 24861, 20943, 58256,
                    36589, 29060, 14946, 57182, 52842, 16995, 42106, 62456, 35985, 43770, 37744,
                    26814, 58578, 34821, 792, 18721, 56167, 56742, 36183, 3291, 52187, 11146, 3258,
                    6269, 37280, 37380, 5210, 38307, 30216, 56248, 5148, 12622, 24405, 9245, 28641,
                    45672, 50254, 12575, 41018, 535, 28169, 50367, 42967, 25699, 28077, 10543,
                    23062, 15460, 20931, 61126, 6882, 43584, 24209, 38474, 50295, 15269, 25181,
                    28497, 30970, 36289, 35570, 59075, 6754, 19579, 24441, 50140, 29369, 49749,
                    35394, 37385, 35815, 65098, 8346, 3282, 5740, 57943, 55153, 3379, 48142, 43368,
                    49308, 20920, 30512, 20610, 59534, 6691, 40086, 10580, 504, 24654, 50764, 1371,
                    29697, 28480, 27015, 6049, 14438, 57976, 33254, 14479, 17454, 43424, 39540,
                    48248, 11454, 52970, 57139, 47794, 54891, 43472, 5952, 46945, 37107, 41072,
                    18540, 36831, 22311, 12116, 58498, 50420, 1411, 1555, 47045, 44841, 58799,
                    25178, 24602, 33537, 29722, 42746, 61795, 5564, 34873, 6131, 26533, 26502,
                    43907, 26850, 1951, 26625, 9509, 58079, 50170, 52887, 1611, 65082, 3664, 32566,
                    10237, 12375, 22764, 49728, 17285, 50663, 56437, 11507, 17281, 42379, 34309,
                    25175, 60147, 20043, 1121, 36641, 11215, 56020, 63529, 49110, 52642, 8241,
                    14382, 26558, 9404, 42074,
                ]),
                c: 133,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_lengthy_6/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("4741272dc08836f02aa60f80fa5406f123bc608906860f276af418b525c49756");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_random_3() {
    let value = FixedTestStruct {
        a: 72,
        b: 5633501076518207946,
        c: 170036136,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_random_3/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("14e08728743971dd0ac92ca94864067b449c28e91d3dcebd6b5f47df98697acb");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_small_test_struct_random_5() {
    let value = SmallTestStruct { a: 61066, b: 8987 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SmallTestStruct_random_5/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SmallTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("b056a7a8da6c09c77b17d34126d6cf3c772d818c6893ca5c4ea512be7ab55d88");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_lengthy_8() {
    let value = ComplexTestStruct {
        a: 19399,
        b: List::<u16, 128>::from_iter([
            22032, 62371, 21788, 9932, 54144, 27131, 3242, 54591, 47647, 13046, 29529, 13141,
            13151, 65437, 479, 12807, 8406, 19308, 58331, 12475, 60877, 648, 47633, 54804, 53138,
            32889, 14147, 49208, 62814, 28632, 16541, 28011, 29384, 46093, 25628, 4212, 1275,
            34893, 33063, 15710, 28029, 21874, 32187, 860, 44718, 5406, 21494, 51195, 39418, 53687,
            3242, 57475, 43017, 14479, 9464, 21638, 46818, 26768, 60783, 62698, 45868, 38771,
            21489, 41619, 36701, 55099, 15797, 11487, 7063, 46591, 9249, 33310, 18093, 8741, 52420,
            11068, 11526, 60206, 4998, 63015, 36848, 23591, 28844, 26898, 36240, 32994, 5319,
            41353, 26402, 10342, 6770, 31168, 13710, 24788, 39775, 41401, 46666, 55851, 25958,
            62625, 61587, 8989, 63624, 7883, 42031, 42898, 2138, 29944, 44939, 49024, 59647, 5306,
            49764, 45165, 61638, 13884, 58920, 35065, 62325, 44582, 53512, 54047, 21337, 1998,
            58010, 2841, 47024, 38382,
        ]),
        c: 161,
        d: List::<u8, 256>::from_iter([
            96, 63, 241, 170, 196, 246, 41, 136, 3, 163, 4, 17, 205, 53, 24, 20, 174, 161, 184,
            147, 191, 243, 129, 225, 14, 212, 237, 43, 210, 161, 69, 108, 12, 212, 78, 174, 134,
            243, 80, 175, 222, 45, 216, 172, 65, 223, 68, 13, 202, 122, 178, 214, 156, 65, 81, 91,
            239, 218, 198, 184, 244, 166, 66, 118, 24, 193, 82, 180, 163, 246, 15, 190, 170, 51,
            20, 189, 50, 12, 234, 49, 121, 18, 25, 246, 2, 138, 31, 110, 130, 208, 133, 111, 243,
            249, 160, 20, 107, 177, 45, 158, 44, 62, 29, 102, 36, 200, 212, 225, 179, 205, 144,
            209, 240, 14, 17, 82, 27, 244, 249, 13, 213, 160, 247, 175, 4, 146, 149, 101, 30, 34,
            74, 166, 163, 233, 12, 161, 56, 246, 254, 137, 104, 197, 182, 38, 79, 179, 40, 213, 40,
            218, 40, 19, 82, 63, 19, 104, 210, 25, 49, 149, 205, 47, 21, 99, 87, 48, 156, 147, 141,
            135, 229, 137, 32, 142, 69, 118, 252, 84, 34, 79, 180, 241, 159, 210, 199, 47, 179, 31,
            222, 187, 227, 191, 124, 128, 225, 1, 145, 38, 97, 169, 116, 64, 99, 146, 63, 231, 67,
            103, 89, 196, 137, 125, 229, 155, 244, 5, 35, 120, 7, 128, 128, 224, 30, 4, 68, 15, 61,
            200, 144, 227, 215, 189, 107, 27, 168, 20, 114, 109, 41, 218, 15, 194, 204, 132, 50,
            133, 161, 124, 73, 199, 212, 98, 229, 156, 69, 63,
        ]),
        e: VarTestStruct {
            a: 64404,
            b: List::<u16, 1024>::from_iter([
                50822, 53487, 218, 11457, 62680, 59808, 6329, 29782, 25436, 7336, 62178, 17478,
                61419, 65325, 44191, 30048, 58349, 46880, 10909, 55045, 26538, 17437, 34657, 29113,
                45580, 13831, 34004, 9692, 37147, 16086, 16226, 40707, 18063, 41603, 17459, 19073,
                26070, 11990, 62242, 42024, 25124, 63881, 40618, 43700, 51045, 50416, 23397, 47943,
                56472, 35909, 23410, 50852, 9601, 750, 31943, 57458, 16369, 31237, 41361, 13475,
                41287, 63964, 42328, 63898, 52363, 42923, 56981, 27517, 29978, 56193, 39554, 15609,
                55036, 7362, 38879, 3179, 4044, 11912, 63382, 14604, 17907, 40233, 53000, 28437,
                24397, 43730, 7157, 51311, 44475, 60273, 20925, 3965, 10808, 55387, 21071, 7898,
                11510, 15975, 9816, 64308, 23540, 63783, 54045, 10035, 49185, 24817, 54807, 3524,
                42225, 53517, 44493, 55722, 25776, 26177, 43607, 65477, 40066, 6723, 40868, 17393,
                26362, 21983, 48536, 13206, 9864, 45301, 64780, 35891, 12873, 14177, 50199, 55108,
                1464, 53455, 38495, 28472, 20013, 10186, 52619, 37505, 32299, 35612, 7194, 25051,
                43900, 20431, 58627, 58768, 62735, 5933, 31418, 44215, 33743, 24127, 22392, 14672,
                24741, 42508, 60128, 50020, 53547, 64562, 26813, 64776, 17591, 5090, 61409, 25558,
                27318, 50386, 62745, 521, 57775, 44451, 31660, 55112, 31714, 21674, 48412, 21524,
                1619, 61860, 31479, 37834, 19947, 16131, 62554, 16291, 51959, 26042, 7931, 58821,
                26949, 19690, 28748, 63858, 39231, 20265, 15035, 2880, 6254, 51835, 32100, 52733,
                30361, 15407, 39475, 29228, 20494, 62922, 21020, 54737, 47687, 48367, 36757, 35221,
                53457, 31016, 39907, 52325, 39332, 4024, 6348, 64798, 51978, 19159, 38816, 8145,
                16496, 5055, 21984, 59114, 32388, 35802, 34594, 50209, 42742, 49318, 17591, 12665,
                22341, 62579, 19470, 525, 9952, 63396, 58478, 64453, 5919, 36384, 2260, 8207,
                21174, 43889, 32280, 12442, 58625, 45111, 4014, 32361, 39989, 53955, 35355, 28816,
                16604, 40058, 30067, 29059, 13889, 36436, 32408, 36418, 33956, 11217, 62336, 58586,
                55266, 27567, 15918, 37007, 22875, 24454, 36766, 58731, 14878, 16885, 58455, 292,
                35245, 55442, 22658, 42222, 26703, 53347, 38811, 40876, 5788, 39217, 18291, 38793,
                60967, 23102, 7468, 50706, 61961, 53781, 49798, 43091, 25350, 21421, 39721, 15284,
                34253, 37662, 13895, 38011, 1526, 10320, 44564, 2864, 23610, 25366, 20532, 48447,
                31981, 37770, 14263, 13260, 27380, 30901, 44978, 53542, 36603, 50571, 43910, 56316,
                18478, 54920, 45681, 8283, 41162, 26131, 65481, 6861, 19735, 54259, 30296, 50181,
                49063, 39620, 16660, 38372, 6459, 43312, 31515, 59272, 7259, 64256, 24854, 11177,
                56777, 15450, 28203, 63054, 64693, 49598, 37319, 13387, 9246, 40913, 30771, 3264,
                44803, 62582, 23541, 44718, 34039, 42083, 303, 253, 33194, 40429, 54695, 9674,
                12120, 49448, 25608, 49721, 60824, 53598, 56004, 33545, 39773, 59495, 15350, 23979,
                51627, 40387, 25073, 34784, 61876, 57106, 51348, 28923, 41304, 10857, 50146, 65379,
                30695, 17971, 41744, 11146, 34990, 479, 52741, 6890, 31938, 39130, 2536, 19400,
                21845, 21008, 30654, 11337, 29341, 60894, 45192, 26002, 9569, 54625, 10406, 45140,
                64176, 51767, 26635, 1122, 11798, 58056, 25133, 57236, 64479, 64437, 5302, 17830,
                20249, 49475, 62507, 1795, 15734, 500, 33544, 59497, 5496, 3368, 11549, 7228,
                55517, 29253, 20634, 53393, 10906, 11293, 36718, 317, 60715, 28315, 18621, 43582,
                64973, 31663, 58821, 15268, 61881, 14365, 12810, 42708, 51000, 37963, 4864, 61957,
                13079, 59497, 56703, 55835, 40235, 27024, 17929, 1511, 56539, 37467, 21711, 64844,
                28363, 44905, 41421, 44516, 62254, 54502, 51479, 29761, 64230, 50596, 13109, 21224,
                26807, 12448, 43495, 60388, 59715, 473, 36658, 49627, 30353, 56362, 9880, 9633,
                19766, 62295, 30356, 31539, 23876, 64274, 20158, 47999, 13805, 63364, 1003, 60748,
                20622, 434, 9671, 51617, 6670, 25108, 25448, 54252, 10992, 26174, 15946, 39405,
                26233, 10029, 6884, 22168, 63607, 10426, 59256, 23770, 24589, 9388, 57735, 38410,
                6536, 55379, 53875, 60650, 2470, 59633, 41118, 44739, 15034, 40804, 65394, 41152,
                8352, 54576, 39269, 55190, 50381, 36079, 62403, 54174, 53182, 15299, 60549, 22194,
                22613, 62418, 23254, 49169, 60338, 20867, 12336, 48695, 42542, 63685, 60822, 17256,
                53642, 32927, 52750, 63579, 48217, 52827, 8942, 1820, 53705, 38661, 46378, 22593,
                45865, 5546, 59305, 32426, 41477, 39242, 46610, 30368, 11897, 27846, 2935, 57576,
                30339, 6867, 50591, 59892, 46091, 27934, 29857, 40968, 14152, 34791, 18667, 28592,
                63015, 5117, 37517, 28058, 49615, 41789, 31123, 49393, 38631, 47365, 60174, 12964,
                61246, 45455, 57146, 65109, 9377, 65349, 25623, 39940, 5182, 19212, 13028, 38051,
                43591, 31201, 19227, 41021, 26111, 35711, 62505, 18766, 29094, 34824, 11222, 43928,
                34425, 5123, 45548, 59900, 35932, 11515, 15753, 49829, 38431, 18619, 63220, 62040,
                6111, 16210, 4041, 40369, 54872, 2832, 1421, 8037, 57206, 65520, 11245, 32220,
                43416, 34493, 39888, 27635, 28942, 40642, 8084, 21367, 8160, 30884, 15410, 21259,
                46394, 48598, 31984, 49363, 42888, 30141, 40299, 11737, 33312, 29661, 28618, 21502,
                14733, 53935, 19345, 47585, 7586, 43724, 55831, 12080, 28193, 6653, 8308, 40106,
                7425, 63203, 47731, 41340, 26308, 45329, 48025, 51108, 47007, 47731, 63782, 53350,
                4015, 38980, 34920, 48449, 31705, 1488, 22457, 23347, 16992, 56681, 14429, 33527,
                12765, 20151, 46112, 1421, 62834, 22748, 59314, 11327, 2312, 58302, 63363, 3265,
                21926, 40114, 55177, 60244, 37620, 61488, 10287, 460, 29068, 60999, 713, 16091,
                15827, 41058, 1319, 47520, 5215, 40565, 1972, 1914, 30861, 19560, 2811, 59072,
                29824, 44862, 213, 24992, 20911, 37795, 26367, 53655, 60881, 7032, 28945, 60539,
                56890, 62146, 44351, 6870, 20189, 63384, 32285, 57301, 648, 563, 58096, 56614,
                58411, 62965, 36263, 29863, 53991, 55456, 32311, 1858, 6415, 54413, 5093, 41786,
                44133, 14979, 64800, 20978, 3362, 51659, 13409, 19106, 35229, 14345, 59318, 19729,
                27374, 24663, 55933, 50009, 35921, 63536, 22827, 47812, 3723, 54976, 46414, 58598,
                11684, 45054, 812, 62649, 20744, 37795, 8765, 35736, 58821, 62209, 43607, 21883,
                60853, 63978, 30960, 14803, 28167, 54300, 5881, 42380, 39608, 15000, 23000, 18951,
                63061, 29707, 51018, 14327, 18279, 3314, 21816, 32286, 29796, 7826, 44839, 39968,
                37867, 18933, 31217, 10616, 59625, 52633, 48450, 30414, 24235, 55644, 34702, 59985,
                48635, 22363, 24614, 64551, 42264, 18409, 33734, 33026, 27273, 45394, 6127, 42392,
                45504, 34704, 23929, 48967, 58934, 14363, 25931, 47902, 10533, 43411, 50746, 57932,
                51160, 31082, 35878, 30010, 56605, 19720, 44354, 39172, 39200, 57353, 11481, 58175,
                21891, 59976, 43980, 50141, 58864, 10561, 47808, 11169, 15212, 27778, 37923, 5259,
                57695, 33586, 39994, 32675, 36275, 8804, 39037, 14981, 12489, 17535, 8063, 48736,
                3439, 22024, 20693, 59623, 43521, 58628, 3481, 57705, 39685, 2332, 55301, 54418,
                1314, 9560, 28195, 56031, 37832, 39137, 11587, 35239, 20294, 4100, 48208, 61011,
                10064, 60853, 47593, 45743, 58509, 3262, 19525, 33613, 24319, 25901, 4039, 28446,
                5427, 4414, 43548, 26445, 9292, 12857, 46585, 33407, 3372, 42337, 57182, 32368,
                47528, 30472, 63534, 28991, 48686, 47536, 20132, 49451, 53621, 58534, 49758, 45621,
                37990, 29719, 60278, 28229, 43190, 32291, 21405, 55830, 3506, 6235, 9749, 33643,
                53436, 28877, 35078, 35442,
            ]),
            c: 233,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 82,
                b: 642531935108670539,
                c: 1838776326,
            },
            FixedTestStruct {
                a: 131,
                b: 5961421925085947308,
                c: 1737832730,
            },
            FixedTestStruct {
                a: 192,
                b: 10876950485646554345,
                c: 3013846498,
            },
            FixedTestStruct {
                a: 40,
                b: 10429973492576791947,
                c: 2638874374,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 23494,
                b: List::<u16, 1024>::from_iter([
                    62191, 8719, 61871, 52371, 4325, 52627, 15113, 41387, 46256, 64066, 23921,
                    57006, 52024, 14123, 52688, 25260, 1534, 4578, 59148, 60025, 18090, 4127,
                    18118, 58622, 25342, 6543, 59224, 25765, 676, 25053, 50858, 63336, 28537,
                    57729, 43425, 24290, 51422, 42353, 22866, 15031, 20485, 18453, 16848, 18829,
                    55314, 15976, 46459, 61304, 51311, 29694, 44125, 8044, 35035, 19778, 28952,
                    6615, 56411, 7175, 14170, 43580, 37804, 64459, 38963, 47485, 34326, 43429,
                    63311, 26647, 51254, 59880, 2699, 92, 20450, 40570, 9076, 20341, 23477, 26050,
                    59964, 16179, 24878, 55637, 444, 46119, 31445, 47989, 27081, 1149, 28156,
                    32773, 41560, 17593, 45182, 6245, 43914, 64624, 44185, 51507, 62888, 30346,
                    46118, 46020, 29434, 54053, 47382, 5611, 38004, 52540, 44300, 60777, 60559,
                    26005, 5822, 10987, 30633, 20032, 53531, 9222, 16509, 14044, 43208, 58186,
                    59793, 54138, 50848, 44015, 52862, 61238, 36472, 154, 5098, 48827, 18839, 4924,
                    35578, 3152, 60672, 31754, 41505, 3816, 63901, 11147, 48009, 62726, 20766,
                    15846, 22382, 31535, 53123, 44009, 30832, 30365, 34949, 62007, 23094, 6962,
                    56549, 19702, 36142, 38995, 46783, 60666, 52898, 23448, 50759, 38035, 54340,
                    41776, 24211, 37750, 9620, 56156, 292, 23204, 40343, 41425, 56262, 53892,
                    33710, 8284, 48961, 2982, 59758, 25438, 22503, 8668, 26619, 50730, 8356, 61977,
                    55866, 48502, 61645, 48798, 40415, 13102, 35196, 56779, 46796, 37731, 38928,
                    16588, 46582, 64290, 26751, 37435, 43258, 21538, 28089, 50485, 13346, 14907,
                    41361, 49869, 446, 45538, 19715, 58516, 12783, 42204, 60856, 21829, 42133,
                    23028, 50730, 60035, 29839, 54733, 2446, 52922, 29019, 28126, 35436, 15589,
                    10542, 6667, 36915, 20564, 15057, 748, 13660, 35382, 60195, 24555, 17869,
                    42435, 22765, 39650, 48393, 23203, 29556, 7801, 24232, 58274, 34912, 21357,
                    12457, 4176, 11276, 1730, 26876, 9354, 15954, 24433, 4468, 9397, 46989, 26769,
                    38163, 1774, 40930, 51365, 64538, 33629, 7654, 34424, 28960, 30428, 28594,
                    55354, 40616, 62455, 38894, 49024, 49755, 52650, 64992, 18342, 35023, 17667,
                    56484, 16755, 30750, 61882, 24585, 10795, 14801, 16912, 45508, 7085, 60466,
                    24257, 1990, 5862, 47479, 55970, 45775, 7162, 8156, 17371, 30187, 54202, 11823,
                    15573, 12840, 13243, 1263, 12431, 23496, 52000, 5924, 41551, 13669, 60239,
                    7403, 49895, 35116, 25207, 20887, 33668, 351, 18018, 35552, 14323, 35509, 3710,
                    22654, 40471, 63934, 27502, 26718, 55112, 37246, 10938, 7343, 6719, 58233,
                    6144, 23089, 3383, 39228, 35848, 5146, 27867, 24716, 8081, 62689, 48306, 16648,
                    11995, 25175, 6134, 57069, 10630, 18399, 44701, 15617, 43504, 23610, 61950,
                    49021, 40170, 50765, 6994, 5897, 21505, 7080, 39266, 9212, 39982, 2058, 54074,
                    56410, 12051, 52108, 50253, 62569, 56769, 7572, 49160, 65266, 15642, 50500,
                    9711, 53998, 52967, 34476, 4076, 10437, 44165, 14942, 9033, 42939, 46803,
                    23362, 31786, 17198, 40797, 44524, 7307, 22751, 20620, 44264, 46853, 29253,
                    5124, 10033, 40243, 13321, 35051, 24615, 65102, 48524, 29313, 21855, 6955,
                    57862, 25714, 63063, 40738, 2696, 20443, 31963, 4760, 46377, 13862, 26352,
                    55527, 4045, 4013, 39291, 39960, 38643, 6271, 20501, 57354, 50070, 48143,
                    35483, 2625, 18932, 62188, 49636, 27722, 19199, 40995, 41767, 59123, 55110,
                    9584, 61617, 7846, 15898, 23996, 57750, 1512, 64979, 17410, 59138, 9553, 63487,
                    17382, 32126, 47643, 13004, 2282, 55422, 41408, 27874, 16605, 60021, 24806,
                    32930, 52065, 15198, 13726, 302, 12443, 32347, 28698, 52619, 5587, 326, 33090,
                    35413, 26051, 3006, 25128, 50129, 54008, 28425, 2877, 36428, 48780, 60133,
                    15346, 46743, 33084, 23717, 31273, 145, 8481, 40321, 61538, 7903, 23905, 3678,
                    19559, 43084, 25933, 32461, 24788, 60754, 42195, 48135, 50846, 3150, 60911,
                    60267, 4193, 44024, 29327, 5276, 25871, 51173, 47643, 42755, 51981, 51647,
                    24232, 40874, 28027, 19657, 17143, 57219, 30483, 5485, 33844, 31562, 44934,
                    58892, 54240, 52207, 46513, 12510, 55911, 32133, 42371, 1570, 43230, 39269,
                    59613, 7561, 33556, 48104, 51193, 6208, 33674, 42273, 64503, 12609, 30434,
                    45199, 45715, 5369, 31255, 16260, 23577, 21081, 41769, 65054, 44312, 2278,
                    45485, 29238, 46249, 4442, 23, 19035, 9001, 45808, 13986, 9503, 5633, 31185,
                    63181, 42369, 6926, 9197, 11428, 55738, 10686, 13854, 7202, 41715, 51414,
                    51879, 61711, 6789, 36978, 23222, 56855, 11279, 22418, 9096, 58281, 54899,
                    19764, 6689, 27108, 35723, 33393, 58956, 30927, 62578, 59410, 24544, 34094,
                    53415, 23775, 26535, 35658, 18147, 18846, 46321, 60892, 18435, 46527, 7389,
                    60259, 48294, 38834, 3878, 45532, 5838, 18234, 49174, 8902, 51493, 1108, 5697,
                    49762, 54584, 37340, 19637, 51706, 23267, 27122, 36282, 5724, 10761, 10114,
                    51996, 61053, 3367, 63987, 64494, 60026, 38466, 51491, 8074, 52960, 13399,
                    13761, 32242, 22227, 16632, 10335, 64171, 63708, 39334, 13945, 50422, 41502,
                    23900, 33459, 20576, 63075, 36813, 53171, 1333, 21498, 44793, 16899, 34376,
                    41310, 61478, 43000, 44470, 35030, 21815, 60644, 17191, 49679, 55916, 55568,
                    20525, 16873, 55669, 46990, 20812, 21004, 47358, 28886, 24033, 53541, 38799,
                    40500, 33655, 28096, 19909, 22163, 58646, 1438, 19300, 45486, 15625, 4736,
                    52773, 8107, 44256, 23959, 29712, 34987, 32629, 61777, 10508, 47024, 47918,
                    62358, 32627, 60016, 61360, 18965, 34356, 15046, 59209, 46025, 24213, 5276,
                    56640, 63413, 7075, 41930, 40904, 13720, 60923, 49987, 52362, 44754, 40574,
                    14916, 53222, 22851, 26119, 25511, 64407, 8873, 16445, 55026, 50617, 44097,
                    18296, 8616, 17153, 47006, 20239, 53120, 17559, 42213, 23768, 965, 637, 59104,
                    32621, 6789, 5483, 49873, 32512, 22719, 21796, 19625, 63377, 1799, 41088, 2557,
                    44854, 20722, 36933, 15858, 14400, 31235, 51052, 53327, 29495, 57904, 4146,
                    18932, 25232, 13048, 29972, 22835, 31974, 20172, 32863, 44026, 50882, 3174,
                    43562, 30254, 47240, 20351, 58500, 41491, 36623, 2362, 40284, 49440, 12485,
                    35880, 3318, 9420, 50502, 54568, 51929, 37002, 6223, 27443, 7160, 37082, 36452,
                    8342, 53248, 64760, 26304, 58672, 22861, 42074, 21767, 40528, 3973, 40099,
                    37381, 1098, 64995, 48112, 35327, 7428, 13163, 59637, 21473, 5847, 51703,
                    47236, 43554, 26323, 5479, 6095, 52918, 24954, 41134, 12702, 8985, 30564,
                    16947, 55126, 27833, 63325, 2381, 50245, 49979, 24505, 40592, 10815, 58175,
                    60050, 29763, 29871, 5196, 31350, 56428, 1983, 52875, 34927, 55670, 7069, 8308,
                    53370, 19041, 20822, 14713, 20985, 30094, 54457, 36120, 23191, 6346, 10603,
                    55737, 7683, 13077, 62699, 9603, 26704, 52537, 35149, 32458, 33447, 41441,
                    11186, 43736, 8700, 19915, 24944, 15963, 27004, 19561, 25786, 25900, 45268,
                    19239, 63365, 5373, 47282, 40030, 13747, 58850, 47686, 49482, 40267, 31428,
                    17353, 42307, 59572, 48716, 64787, 35482, 21563, 14860, 51825, 20973, 424,
                    19890, 26870, 39007, 60289, 17668, 22052, 36549, 45400, 35605, 58181, 40307,
                    12062, 34867, 43943, 44128, 23797, 48770, 43726, 12974, 52184, 34142, 26983,
                    48965, 47657, 17828, 12295, 1104, 35640, 3687, 43993, 16928, 30854, 37888,
                    52097, 5540, 27351, 19547, 38977, 53008, 35634, 50688, 59133, 31620, 62563,
                    50071, 63584, 743, 59929, 31910, 53142, 33817, 6879, 30309, 33065, 17363,
                    39592, 21915, 24753, 19689, 61386, 43691, 55542, 25364, 24761, 55837, 37774,
                    10253, 50414, 3909, 28594, 7191, 32780,
                ]),
                c: 227,
            },
            VarTestStruct {
                a: 37931,
                b: List::<u16, 1024>::from_iter([
                    33232, 49745, 32208, 19257, 59506, 50483, 27643, 42473, 5883, 63100, 25377,
                    38309, 64931, 41988, 59618, 12505, 11426, 12564, 49033, 59160, 54071, 60819,
                    7716, 7965, 39124, 62484, 39276, 57449, 7320, 54267, 23912, 63484, 8827, 11782,
                    13847, 35208, 57374, 40244, 53328, 2791, 51985, 55447, 37924, 3487, 30267,
                    22529, 42413, 47235, 10845, 40887, 20408, 37661, 62626, 37899, 4384, 40353,
                    34220, 25634, 39265, 56634, 1459, 1570, 27098, 6472, 1521, 44826, 38003, 11888,
                    290, 3893, 46645, 6929, 45005, 14656, 56210, 33419, 50641, 12383, 31466, 21994,
                    53378, 9261, 6666, 17491, 21735, 59633, 49822, 62999, 31824, 39411, 36362,
                    14832, 2760, 54476, 8641, 22518, 42102, 29029, 27163, 16146, 35874, 13886,
                    51784, 46204, 18791, 57909, 18012, 43519, 54259, 5894, 11495, 51486, 8181,
                    30073, 8477, 29121, 39068, 24490, 4986, 33786, 31575, 23403, 50161, 59485,
                    48904, 36212, 33666, 61527, 2129, 53555, 52529, 5486, 51562, 4534, 26341,
                    18072, 13459, 47209, 64277, 46346, 16919, 41742, 29508, 19053, 15901, 22319,
                    9651, 58641, 43175, 6736, 13543, 13832, 19637, 27437, 40663, 28975, 18028,
                    28632, 19, 48466, 23844, 56296, 29125, 21254, 2055, 61565, 46985, 16810, 29883,
                    43175, 2753, 48443, 18148, 45216, 31089, 6453, 60974, 47934, 58200, 43513,
                    5024, 23323, 45869, 31548, 55228, 33247, 2087, 25225, 59264, 10405, 39972,
                    6279, 44086, 12349, 2246, 31668, 15361, 60930, 57918, 57074, 20872, 53649,
                    11262, 2039, 25103, 16081, 55513, 46032, 16810, 4748, 65174, 31704, 9373, 7664,
                    36837, 13405, 3525, 47929, 1416, 13455, 16190, 34764, 42627, 63174, 13088,
                    22210, 40794, 61543, 61524, 57256, 32549, 45568, 4062, 45423, 13111, 3579,
                    37883, 33359, 19437, 11782, 39242, 14842, 36, 63841, 58760, 54662, 41654, 1756,
                    30565, 55932, 52561, 28043, 1995, 50837, 37274, 16168, 64154, 30158, 41983,
                    3043, 50605, 26286, 29390, 54470, 34069, 27565, 32945, 427, 55389, 49559,
                    51033, 15133, 59704, 37912, 35763, 16790, 25796, 47492, 21405, 60196, 11838,
                    58016, 43593, 55325, 17311, 64123, 18505, 16890, 9045, 50807, 48381, 41519,
                    62549, 33546, 28863, 48237, 44386, 42213, 45075, 11179, 52764, 33269, 4414,
                    35782, 53930, 840, 6103, 29647, 56460, 23363, 16249, 7406, 50938, 34251, 12539,
                    20227, 51622, 62870, 16303, 36646, 51911, 61992, 31580, 8881, 50427, 11347,
                    50302, 36261, 36170, 39729, 13501, 13163, 25482, 28153, 16734, 50238, 21442,
                    55785, 27238, 8812, 3676, 41568, 12450, 26456, 25268, 8872, 17507, 46981, 5227,
                    19553, 34279, 694, 38775, 46180, 59660, 51011, 42880, 8566, 65281, 29255, 5309,
                    29962, 47485, 46229, 21434, 30944, 21652, 49461, 42476, 13200, 49168, 11274,
                    52182, 15387, 8611, 4888, 21400, 52125, 24220, 14083, 37632, 31470, 53919,
                    23707, 39502, 50622, 52863, 28792, 58321, 60284, 44856, 20709, 13444, 4659,
                    640, 53293, 21235, 44075, 56440, 51231, 13946, 64401, 38305, 15262, 55431,
                    37273, 14882, 42986, 7366, 25842, 32782, 4161, 28804, 23872, 23495, 29135,
                    2136, 54160, 24172, 19533, 55912, 40296, 15572, 48253, 29676, 41192, 13743,
                    43051, 35059, 2203, 5676, 17844, 22810, 10115, 62456, 60125, 9656, 3296, 22941,
                    40532, 13693, 47128, 58293, 36504, 39152, 9489, 23967, 37675, 10542, 459,
                    59701, 22715, 58997, 24572, 57156, 60140, 20937, 36530, 50545, 61567, 20801,
                    30020, 58679, 64206, 51749, 58047, 59614, 41057, 32949, 62282, 47477, 18262,
                    3741, 38454, 17946, 36908, 35656, 42445, 55570, 49469, 33066, 21053, 22443,
                    35801, 6501, 53516, 23709, 40976, 57983, 27207, 22655, 62207, 38148, 52511,
                    34650, 48422, 11531, 25474, 43062, 18927, 59331, 14694, 38814, 30037, 60319,
                    47484, 7509, 26395, 10886, 47632, 63818, 7091, 33298, 3361, 13284, 37484,
                    38433, 16929, 16744, 42972, 15286, 59004, 64424, 10820, 6975, 46943, 32406,
                    22980, 7929, 27069, 13481, 19937, 1175, 63733, 30579, 3254, 49131, 27448, 973,
                    28039, 58260, 2315, 46817, 61465, 57458, 27082, 34919, 46292, 9477, 37395,
                    54895, 13989, 58344, 33234, 48514, 10013, 23372, 39777, 48969, 51859, 5022,
                    65476, 51005, 55333, 59413, 1594, 51943, 45907, 41983, 55906, 6664, 30701,
                    35013, 22727, 1121, 25600, 9544, 57605, 26200, 45663, 17555, 636, 14101, 56741,
                    43836, 64905, 18905, 18406, 4450, 3681, 50139, 40001, 14933, 13861, 43235,
                    15683, 38294, 41783, 34361, 17712, 30821, 55965, 27741, 44427, 29675, 11624,
                    46932, 4788, 61259, 32422, 61249, 37116, 27512, 47066, 7206, 43574, 18970,
                    24049, 4267, 37442, 30966, 42196, 27359, 1052, 39421, 37799, 44276, 3249,
                    23107, 48774, 10703, 3652, 51266, 4988, 4789, 64548, 6791, 54506, 61965, 2233,
                    16133, 20833, 31894, 55185, 55553, 58900, 42265, 23982, 4563, 9293, 26629, 175,
                    18796, 57239, 34187, 65291, 31608, 65093, 59280, 58233, 12792, 62070, 55343,
                    54841, 28314, 33215, 12105, 28290, 32337, 33529, 7153, 27806, 25534, 11519,
                    43036, 25074, 4278, 2409, 22954, 8587, 32472, 52640, 6566, 62003, 19574, 32192,
                    2705, 2068, 34403, 7858, 29371, 4245, 1294, 23185, 49353, 36435, 24985, 63316,
                    21483, 6776, 1513, 5058, 45339, 14814, 42025, 64335, 60535, 53851, 51715,
                    59393, 14618, 48382, 27394, 39310, 21058, 7076, 6211, 28691, 35565, 30500,
                    43999, 46505, 46261, 61265, 40383, 65155, 63572, 31788, 53756, 43474, 16115,
                    8169, 20813, 24048, 18296, 51827, 25214, 25179, 52235, 58173, 31157, 27773,
                    27712, 62894, 3258, 61915, 36620, 10031, 27272, 61799, 8814, 53997, 44344,
                    31313, 59839, 32067, 8877, 36514, 1579, 39593, 63869, 47571, 30967, 35198,
                    6489, 65142, 53689, 16119, 9916, 6266, 55591, 14983, 63411, 44117, 46988,
                    37220, 10898, 6399, 9425, 371, 53523, 52493, 10171, 63986, 24601, 12618, 21622,
                    30756, 22168, 15632, 37784, 18170, 26423, 29787, 31163, 43433, 48707, 47147,
                    64074, 3595, 18289, 29680, 8419, 46213, 9998, 40845, 19543, 2063, 26780, 39261,
                    36867, 11861, 22532, 482, 46275, 61127, 12792, 64281, 45927, 16765, 47884,
                    30879, 6136, 3592, 26929, 53918, 2055, 52446, 4127, 22016, 10513, 55797, 54,
                    55962, 24550, 4122, 216, 8272, 26033, 60761, 58435, 14927, 64092, 41186, 5820,
                    6599, 7607, 2843, 21510, 46932, 36564, 1599, 1444, 48375, 23107, 27101, 32863,
                    59425, 55645, 41071, 54991, 39762, 27985, 13617, 45825, 63510, 44876, 43027,
                    58745, 34335, 52176, 26016, 1029, 53235, 65506, 24985, 49690, 55491, 6797,
                    5299, 56649, 49954, 13467, 37772, 61019, 9905, 41585, 41587, 53789, 36033,
                    40085, 34009, 19870, 39740, 2791, 16242, 65226, 602, 3657, 8774, 19785, 11033,
                    17321, 12743, 16813, 31986, 32454, 50437, 21549, 19129, 10769, 18028, 25901,
                    47037, 15697, 52271, 39208, 11650, 24131, 51286, 22109, 27380, 38143, 9664,
                    62877, 41423, 48176, 65245, 59433, 64131, 17601, 17491, 33769, 31239, 25953,
                    40006, 40665, 19539, 29898, 54577, 28794, 2709, 20549, 23365, 48767, 34030,
                    28172, 38739, 23497, 12497, 669, 47382, 55701, 54381, 28408, 25532, 12994,
                    25510, 59802, 9767, 505, 4616, 37770, 59717, 17412, 64799, 24562, 3508, 53786,
                    39485, 9473, 50327, 24863, 26667, 54354, 40963, 21436, 49367, 51215, 29704,
                    44704, 42663, 49150, 46704, 31256, 53842, 51288, 37099, 42215, 62083, 9475,
                    49879, 18005, 3423, 6405, 43997, 48786, 39755, 59538, 49695, 566, 10618, 58216,
                    37762, 32930, 31347, 35431, 35734, 19275, 61864, 40299, 22981, 45058, 20344,
                    27995, 40134, 20744, 16250, 13836, 63918, 26514, 16127, 57742, 24253,
                ]),
                c: 107,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_lengthy_8/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("cf3761ba9461b1af5158ea2e93141841e86368e57dc089d80fded1e1f7750866");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_small_test_struct_random_2() {
    let value = SmallTestStruct { a: 23998, b: 14996 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SmallTestStruct_random_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SmallTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("6c014ce952c149ee0484856ca5f90db0015b6fcc6afd4dd5fa8f3354ea32f427");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_max() {
    let value = FixedTestStruct {
        a: 255,
        b: 18446744073709551615,
        c: 4294967295,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_max/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("3925681862db7892428eac4afae08671930e623601b5b85fbbc366371e29acd7");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_lengthy_3() {
    let value = VarTestStruct {
        a: 53621,
        b: List::<u16, 1024>::from_iter([
            12824, 63199, 12227, 37027, 24572, 53189, 4389, 44798, 43145, 8174, 43110, 30174,
            62754, 21656, 40949, 53812, 40888, 30440, 59145, 10801, 28955, 19257, 37274, 43429,
            1057, 41095, 36357, 4155, 28658, 44280, 43649, 44937, 19737, 61292, 19192, 27640,
            12891, 33832, 21987, 15325, 30046, 39353, 42201, 41239, 578, 51593, 12759, 22415,
            25369, 41609, 63054, 34114, 5523, 44794, 8868, 3115, 10983, 29661, 35422, 46638, 44220,
            32081, 1521, 6905, 21448, 15523, 11823, 10535, 63613, 7800, 29751, 56314, 6810, 37152,
            45202, 17885, 46224, 41522, 55064, 55034, 23405, 16385, 37885, 52284, 56597, 22342,
            13705, 41350, 12167, 29118, 31088, 37853, 1988, 61330, 37334, 55488, 5963, 61333,
            12915, 63312, 20922, 54718, 63217, 34767, 20943, 41833, 38426, 48977, 30574, 24718,
            17816, 13273, 23697, 35672, 39289, 46117, 20558, 46389, 25024, 19873, 64107, 30217,
            6650, 2012, 56112, 41641, 12942, 4166, 64536, 5189, 55420, 32271, 25800, 51807, 63728,
            52464, 41427, 54659, 32115, 39009, 47270, 39551, 50858, 23532, 60800, 36607, 14927,
            13474, 59257, 35292, 62928, 23256, 14812, 51561, 17012, 4652, 32518, 8304, 30481,
            29465, 65016, 19089, 35130, 9756, 31265, 32297, 44620, 47169, 23733, 32989, 4086,
            59561, 39285, 36965, 22085, 8378, 54829, 50571, 13548, 63472, 2016, 52180, 64456,
            43721, 15993, 9031, 13471, 24815, 2034, 23903, 25676, 14915, 5684, 26632, 1329, 31017,
            42437, 57785, 19570, 28168, 42408, 8684, 21826, 50701, 25954, 62000, 28631, 17658,
            24628, 60838, 1818, 14082, 35417, 9495, 65040, 65256, 54854, 17912, 36016, 18982,
            46911, 59346, 50637, 56068, 8951, 3987, 25910, 10172, 32664, 28275, 7739, 2871, 19584,
            40133, 53255, 49564, 19850, 26000, 22484, 10086, 25457, 11863, 23747, 32063, 1375,
            20477, 38593, 1119, 23799, 32090, 21624, 39954, 22767, 23888, 9289, 65408, 36174,
            39294, 40728, 24981, 374, 55536, 10984, 44014, 26666, 15202, 24834, 18552, 53468,
            40709, 7921, 32676, 57505, 12446, 34258, 146, 32728, 50805, 17277, 15454, 43322, 8537,
            16913, 6511, 50187, 39335, 8752, 20231, 34134, 23248, 61310, 5165, 1814, 51275, 57596,
            45933, 55855, 19742, 1826, 40280, 10996, 36168, 13576, 54805, 47846, 61015, 587, 60471,
            29621, 26522, 5915, 158, 18461, 6820, 64659, 53083, 48481, 40473, 45506, 61232, 41672,
            17842, 1548, 4992, 34785, 55044, 45130, 29968, 39908, 41722, 26447, 30411, 30816,
            34584, 58139, 17373, 1767, 11136, 57962, 39073, 20109, 48849, 62197, 44858, 64613,
            25430, 31126, 9234, 23003, 30425, 23090, 32660, 36495, 62214, 56111, 5781, 49324,
            43924, 26114, 10988, 2595, 24871, 56135, 56882, 54305, 14533, 64595, 48290, 14544,
            24151, 1802, 61817, 48204, 49941, 47529, 12673, 49460, 29934, 64877, 43088, 10912,
            49531, 4222, 16284, 191, 9767, 17371, 26973, 55656, 19739, 27919, 65374, 40530, 40286,
            26476, 24664, 20366, 9967, 48365, 20415, 3879, 19655, 34812, 61134, 35950, 14720,
            18888, 10069, 16577, 31675, 34830, 19296, 28186, 57105, 63685, 28433, 2441, 38900,
            52568, 20180, 54108, 30962, 41663, 41162, 9924, 19119, 29418, 13674, 62989, 912, 21362,
            2361, 9348, 23810, 17782, 25388, 20276, 36758, 17616, 37003, 62703, 25855, 32639,
            41721, 55280, 50239, 9817, 59209, 7338, 61297, 7118, 7555, 23209, 34271, 52326, 63243,
            47765, 46845, 8216, 52514, 39175, 6855, 36103, 20546, 35462, 32576, 57863, 59386,
            28986, 10626, 34460, 30107, 63828, 55285, 24445, 30837, 36790, 16082, 51703, 37350,
            5331, 31688, 41107, 60384, 9222, 58880, 38350, 11341, 47994, 21225, 61858, 4590, 20131,
            19399, 7606, 46715, 47869, 12019, 40950, 9830, 1496, 47800, 48413, 2912, 4054, 51443,
            47494, 7523, 44600, 29898, 2554, 14621, 56416, 28097, 31884, 55056, 63050, 16540,
            16605, 52921, 34914, 60457, 32972, 9185, 19912, 9352, 39493, 36702, 39956, 52474,
            24680, 47327, 48286, 30950, 29333, 10409, 4091, 21410, 5227, 54353, 60079, 45759,
            56625, 14338, 57190, 40981, 43602, 17006, 53073, 56010, 4709, 5430, 26296, 37529,
            47667, 8833, 2971, 57303, 63231, 15702, 26827, 39565, 9249, 20140, 4173, 8250, 17027,
            4990, 20050, 4431, 15435, 46771, 15130, 13649, 30386, 48851, 17859, 40727, 1727, 3412,
            40850, 54557, 50322, 29032, 8445, 29183, 41999, 50925, 61595, 14196, 35072, 39816,
            50201, 23840, 37744, 26866, 3602, 46965, 22856, 26798, 43015, 40206, 55515, 11291,
            14295, 25047, 12508, 42920, 61545, 36847, 42827, 59149, 37648, 20834, 4214, 15295,
            45749, 17057, 37635, 47729, 15217, 50778, 7236, 63009, 47585, 8546, 20844, 1714, 26460,
            15336, 63245, 34216, 58685, 15646, 3498, 29123, 62271, 43203, 12246, 3134, 9311, 53746,
            28666, 5828, 45743, 50930, 41775, 21044, 7624, 49610, 19369, 41631, 40808, 21746,
            16537, 59450, 15484, 39419, 56493, 38487, 63573, 28134, 46943, 57911, 13618, 27665,
            63693, 21072, 34656, 63629, 23609, 55587, 30903, 8100, 28620, 21732, 27509, 47468,
            15126, 31921, 16048, 39864, 5653, 25472, 18436, 19876, 52126, 39651, 47640, 8025,
            60396, 12961, 11559, 19217, 37464, 48299, 60234, 48664, 17783, 6445, 23475, 14987,
            46398, 35504, 62413, 57423, 53601, 6077, 53923, 42587, 23539, 8990, 28851, 34421,
            49397, 61664, 54315, 3593, 28324, 50753, 47720, 37264, 7728, 20211, 34865, 39022,
            23668, 13442, 6771, 50757, 9518, 18825, 62867, 4054, 6240, 16905, 27035, 46010, 11940,
            24279, 48265, 37950, 20187, 56769, 27295, 31211, 575, 12642, 9751, 39340, 32877, 6935,
            27306, 10933, 58991, 47581, 48835, 15245, 15429, 50806, 5562, 14231, 5518, 9902, 16135,
            39182, 1680, 13628, 43562, 35187, 27239, 588, 17920, 5853, 39399, 31080, 13365, 61435,
            14953, 29568, 4929, 53504, 35721, 39671, 2227, 32135, 21383, 64510, 15481, 59049, 2032,
            16254, 17682, 8602, 64410, 16152, 17573, 23476, 21416, 60463, 30720, 8117, 59855, 3926,
            24068, 65487, 36427, 28490, 5766, 19232, 18471, 58849, 22846, 58016, 5434, 43093,
            57345, 50164, 20043, 20320, 59193, 1832, 34512, 28820, 64998, 7348, 26775, 50866,
            55706, 38800, 39677, 42733, 5620, 24482, 16486, 12981, 43476, 51650, 37424, 16718,
            3806, 56666, 9956, 4126, 57305, 16012, 51301, 46051, 48009, 26308, 17439, 44536, 42504,
            44282, 13750, 45145, 30812, 41906, 26513, 1365, 46416, 18062, 41850, 62624, 52481,
            45361, 62555, 54272, 13710, 59825, 55116, 8289, 29104, 14423, 25618, 43571, 8984,
            27448, 3638, 48426, 47278, 39039, 30918, 16734, 59710, 32735, 44274, 32123, 53804,
            13043, 28523, 25232, 36266, 15100, 58840, 28057, 50214, 42030, 38537, 40603, 61101,
            58153, 49848, 41247, 8699, 19091, 47538, 25546, 19561, 38790, 64260, 32976, 60806,
            14783, 9629, 48369, 30608, 29534, 17392, 54595, 2000, 1731, 16822, 14065, 12114, 48259,
            40194, 46581, 15692, 60445, 16662, 8508, 41248, 32381, 34455, 45060, 60137, 57750,
            14183, 11223, 38168, 34879, 11355, 3323, 16613, 64476, 3189, 53954, 24359, 62200, 1202,
            55946, 768, 27060, 14657, 55024, 27519, 42256, 63606, 36574, 54148, 29741, 36099, 8779,
            36894, 31347, 42576, 38020, 14817, 7303, 64961, 42979, 30210, 46928, 38757, 10021,
            28505, 64359, 50842, 28773, 19200, 18414, 55308, 18799, 6307, 6519, 7775, 53258, 61139,
            49334, 47308, 13579, 51794, 24185, 44464, 53056, 2504, 41519, 20023, 12170, 24384,
            56645, 14604, 61920, 39018, 32, 20528, 51398, 25015, 52982, 16304, 41598, 53136, 49436,
            19512, 42007, 1305, 5487, 23918, 57245, 1315, 12214, 462, 2117,
        ]),
        c: 192,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_lengthy_3/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("ac826d5dd43427c8f4838bf5b54134ce4ddf37a6a9bcea07d229964940858853");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_one_6() {
    let value = VarTestStruct {
        a: 5264,
        b: List::<u16, 1024>::from_iter([12220]),
        c: 50,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_one_6/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("14662980605e77baa6e07639d5bbe81467e2ca249340e9531edcaa87585cedab");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_nil_5() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([]),
        b: Bitvector::<2>::from_iter([false, false]),
        c: Bitvector::<1>::from_iter([false]),
        d: Bitlist::<6>::from_iter([]),
        e: Bitvector::<8>::from_iter([true, false, false, false, true, true, true, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_nil_5/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("51e74ba89a64b57dcb64384a1ba81c8ac3e15edfec97f187e20dfa5669859035");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_one_1() {
    let value = VarTestStruct {
        a: 47389,
        b: List::<u16, 1024>::from_iter([45887]),
        c: 140,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_one_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("90fc29dbcb37509bde9cbecb990e7fb5ead6249d16964870263e7b58c57ba7cb");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_lengthy_4() {
    let value = VarTestStruct {
        a: 49542,
        b: List::<u16, 1024>::from_iter([
            24176, 6691, 23594, 34600, 279, 42247, 61589, 7750, 35436, 7515, 9624, 33952, 31649,
            13277, 30992, 9446, 46849, 44684, 29092, 21121, 32148, 37757, 15766, 53992, 14343,
            46848, 13002, 11444, 15204, 27637, 38576, 34625, 26673, 19521, 36230, 2040, 42348,
            31031, 37348, 53512, 47951, 23324, 52778, 59277, 60983, 50449, 925, 31111, 8005, 23828,
            17807, 3116, 37028, 54069, 32494, 42511, 27960, 51027, 4225, 15907, 24504, 5820, 6374,
            9214, 34511, 23569, 39346, 54283, 20963, 46388, 9248, 40785, 26950, 9648, 5362, 27878,
            36250, 20754, 17908, 46299, 52362, 44315, 21562, 21740, 36159, 22140, 40730, 17608,
            5915, 1543, 4244, 63320, 51731, 49433, 56472, 30938, 62884, 13353, 22011, 13603, 39755,
            36974, 14793, 41047, 42644, 47525, 8585, 41126, 3068, 61868, 32452, 52070, 33625,
            59274, 4232, 4123, 62962, 5919, 57924, 42027, 62102, 54757, 44714, 22173, 55963, 55023,
            35385, 25614, 14518, 50974, 21008, 35291, 64803, 23383, 32083, 40008, 54466, 4501,
            40608, 30567, 30581, 45418, 35755, 52742, 9300, 7454, 22498, 6943, 47429, 46974, 23901,
            57481, 34202, 15665, 29487, 22450, 48240, 7168, 37505, 29279, 9176, 14888, 17827,
            30185, 10835, 16258, 10, 2254, 55532, 37893, 26048, 60132, 65144, 38122, 41241, 48651,
            32337, 14493, 27793, 4045, 62823, 41331, 55548, 61248, 8373, 17875, 15170, 39035,
            48214, 39540, 47175, 25028, 39359, 55471, 34582, 31956, 62883, 58081, 25685, 11263,
            32593, 61245, 15820, 41533, 22717, 38000, 1384, 27193, 31524, 22975, 41184, 29342,
            5847, 32060, 7879, 24652, 34137, 33187, 26967, 42794, 5307, 38986, 28813, 57421, 29231,
            36, 18699, 35421, 59357, 26104, 30013, 52482, 5618, 38088, 31838, 7805, 17322, 28129,
            2877, 29566, 6862, 32532, 27071, 1987, 23147, 13110, 18689, 44738, 18454, 18160, 51485,
            37708, 30555, 30998, 59779, 62206, 44125, 65321, 47938, 30689, 52748, 40869, 2952,
            12566, 5409, 44384, 61449, 6342, 56545, 19438, 4594, 22158, 27778, 51319, 50187, 35936,
            14422, 40344, 58111, 5552, 43834, 49356, 55870, 8915, 25853, 46690, 47187, 14809, 1919,
            19597, 42198, 26016, 15751, 52908, 19762, 24896, 44586, 22383, 32549, 52973, 32963,
            54469, 27375, 54695, 8847, 61163, 29739, 21356, 1500, 21492, 7855, 18915, 46901, 55982,
            34455, 49702, 20122, 39680, 24157, 9292, 45732, 34031, 20797, 15331, 42589, 69, 40291,
            13901, 12701, 34931, 17402, 38396, 3110, 39186, 980, 65109, 8001, 54203, 7982, 10644,
            15853, 32133, 33766, 61594, 15788, 29198, 40624, 52298, 4386, 8873, 64378, 46318,
            44016, 31213, 31756, 35290, 21201, 18664, 62670, 24327, 48958, 18623, 3362, 11938,
            14438, 10886, 11030, 56209, 59949, 37520, 17563, 33924, 24993, 34084, 49026, 5634,
            52415, 38219, 48486, 45027, 25230, 2654, 41060, 45731, 39398, 57706, 9221, 26315, 7224,
            16867, 49921, 7805, 18418, 27190, 29605, 36359, 29785, 63860, 24874, 37547, 10873,
            30645, 46879, 1128, 36289, 16248, 65211, 25291, 54314, 20839, 29417, 53234, 58341,
            46797, 56326, 63209, 64319, 6554, 17870, 15067, 55045, 40733, 2326, 15114, 13536,
            25525, 1743, 55935, 19768, 35755, 12992, 55374, 60641, 27321, 43157, 64574, 35891,
            44609, 60838, 513, 51352, 57846, 8060, 36767, 36506, 19069, 54924, 16010, 37227, 28707,
            60322, 32929, 51131, 10723, 30838, 31526, 8309, 47710, 2473, 23498, 53300, 37291,
            10765, 29267, 14344, 19826, 40084, 44731, 10118, 32600, 53186, 61810, 42415, 54321,
            4864, 32063, 15243, 26552, 14641, 28192, 57558, 9781, 44137, 32123, 38308, 12573,
            48273, 47813, 20783, 4285, 45602, 27703, 62809, 56829, 41949, 32555, 12407, 47653,
            33000, 18411, 41481, 9563, 7496, 3352, 42560, 62847, 17073, 42997, 47040, 56191, 25939,
            45878, 20457, 18613, 5765, 32674, 64671, 30294, 22750, 33890, 51595, 21694, 18936,
            46983, 21385, 45557, 50079, 23949, 43257, 40700, 40058, 64281, 10550, 26952, 6781,
            10292, 41284, 40684, 19296, 38469, 65436, 48807, 54970, 33267, 225, 37537, 14390,
            10819, 45704, 47157, 23273, 40019, 63952, 48361, 41840, 37051, 31639, 34707, 24711,
            26598, 24132, 31161, 54780, 40532, 25239, 14389, 10673, 58898, 60210, 61180, 60406,
            58563, 18362, 9816, 3990, 36543, 53267, 36507, 64624, 62830, 40623, 6927, 18675, 63757,
            48167, 36978, 53133, 39634, 37097, 46323, 31345, 45398, 45348, 1612, 59525, 3728,
            54322, 65201, 15868, 46368, 35881, 45423, 36049, 56122, 57932, 53129, 62648, 48375,
            21424, 60423, 2348, 52797, 6775, 5255, 41656, 44466, 6959, 59394, 50100, 64363, 58849,
            35646, 18008, 36382, 9509, 44699, 20277, 738, 12298, 31313, 32696, 40912, 36950, 25236,
            17136, 28897, 47315, 39651, 62937, 14642, 23035, 28629, 32736, 16679, 35939, 31181,
            51426, 53744, 4499, 11172, 56374, 63738, 3664, 33845, 37157, 965, 32592, 63003, 63686,
            19615, 4657, 41773, 31900, 50581, 18028, 1079, 29992, 34383, 5175, 18724, 55095, 34374,
            48355, 12191, 62499, 62508, 63612, 39047, 26733, 53960, 55239, 20815, 65434, 55386,
            60984, 34748, 29996, 3357, 55343, 7686, 20719, 47697, 25815, 46829, 46412, 55814,
            14954, 3357, 42532, 15634, 35270, 32870, 59622, 3985, 27252, 45296, 48358, 8451, 64871,
            57567, 7304, 63953, 10696, 62588, 13406, 49243, 63350, 58218, 10163, 20681, 37966,
            64938, 24883, 12339, 20460, 6435, 5027, 12935, 58835, 25601, 42816, 55130, 46980,
            33955, 2700, 62344, 26772, 49951, 17175, 2289, 34685, 61812, 51435, 45366, 28638,
            36391, 22398, 20053, 60454, 27696, 39806, 23627, 30652, 8110, 20266, 16441, 20423,
            47009, 33684, 60909, 9702, 57568, 26503, 25931, 61716, 16870, 54646, 61593, 19618,
            48952, 4915, 53893, 24200, 63028, 38000, 44874, 7726, 31012, 24641, 61568, 59741,
            52712, 50516, 1360, 61226, 18309, 1403, 32679, 6717, 25356, 41731, 54184, 38756, 3767,
            25101, 24133, 2397, 38331, 2687, 37038, 43443, 47201, 37141, 57101, 31255, 14285,
            18735, 52887, 57902, 27817, 43542, 35864, 42910, 54409, 22273, 32147, 23776, 15718,
            27147, 30733, 49369, 13919, 46822, 46991, 43084, 36413, 53876, 61482, 23379, 10338,
            2753, 26758, 35000, 60336, 58532, 41487, 56416, 33731, 57977, 48319, 54818, 623, 31523,
            48801, 30764, 2552, 25466, 44332, 14911, 43224, 31602, 105, 48493, 44213, 24487, 57050,
            14160, 34137, 57442, 62213, 29737, 33973, 40612, 19783, 51676, 31939, 20052, 50605,
            20918, 55316, 48016, 40253, 58739, 26284, 31291, 19970, 11793, 11690, 14549, 35505,
            61927, 8663, 27698, 5182, 27535, 38689, 43328, 34168, 25500, 61636, 2259, 64968, 36733,
            31201, 25144, 41771, 2888, 28180, 10426, 40259, 47533, 35148, 29417, 2389, 33575,
            33454, 53437, 29607, 56328, 26017, 1631, 55664, 41612, 6499, 21837, 54618, 41586,
            21958, 48422, 32507, 4943, 28887, 35079, 29344, 42857, 18651, 21237, 43919, 29056,
            63768, 10172, 44679, 3866, 9606, 24041, 32219, 22596, 8366, 42644, 32522, 41151, 2680,
            15538, 34354, 47859, 36035, 60830, 54743, 52989, 24891, 42186, 33301, 36198, 30264,
            44612, 3714, 29131, 28926, 55360, 43546, 38201, 31205, 18149, 17004, 46729, 47446,
            15866, 31071, 9267, 60229, 1970, 25222, 59538, 1375, 21638, 18073, 38411, 33281, 12698,
            11192, 11252, 24193, 52988, 48070, 39438, 1888, 7320, 63951, 40461, 22286, 40137,
            61093, 52731, 30123, 17484, 3302, 22216, 55458, 608, 34610, 10863, 22823, 50379, 6078,
            37084, 2682, 5584, 43468, 44929, 16330, 57616, 12260, 59257, 2719, 11929, 39447, 16197,
            53235, 60854, 48756, 20252, 48603, 18883, 1404,
        ]),
        c: 123,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_lengthy_4/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("8c5021941ca0553eaff53a2b56b2ff86bee1249c77c700d3f47406569bd0b01f");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_zero_chaos_2() {
    let value = SingleFieldTestStruct { a: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data("ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_zero_chaos_2/serialized.ssz_snappy");
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("0000000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_zero_9() {
    let value = FixedTestStruct { a: 0, b: 0, c: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_zero_9/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("db56114e00fdd4c1f85c892bf35ac9a89289aaecb1ebd0a96cde606a748b5d71");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_nil_2() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([]),
        b: Bitvector::<2>::from_iter([true, true]),
        c: Bitvector::<1>::from_iter([false]),
        d: Bitlist::<6>::from_iter([]),
        e: Bitvector::<8>::from_iter([false, false, true, true, true, true, false, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_nil_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("6624f0820a556f057e3fbe2cc01793f8b0feab93bba19c642d0aee954d336493");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_max_chaos_2() {
    let value = ComplexTestStruct {
        a: 65535,
        b: List::<u16, 128>::from_iter([
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535,
        ]),
        c: 255,
        d: List::<u8, 256>::from_iter([255]),
        e: VarTestStruct {
            a: 65535,
            b: List::<u16, 1024>::from_iter([
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            ]),
            c: 255,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 65535,
                b: List::<u16, 1024>::from_iter([
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                ]),
                c: 255,
            },
            VarTestStruct {
                a: 65535,
                b: List::<u16, 1024>::from_iter([
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                ]),
                c: 255,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_max_chaos_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("5065533e7b56e29e0da6386fa6ab9370faa05722ab0e60080fadf809cf58807a");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_max_5() {
    let value = VarTestStruct {
        a: 65535,
        b: List::<u16, 1024>::from_iter([
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535,
        ]),
        c: 255,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_max_5/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("5d79a4fe1fc468caab77f2c903262aa8c4ce6756121fca8b25919b0fab711367");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_one_8() {
    let value = VarTestStruct {
        a: 32967,
        b: List::<u16, 1024>::from_iter([65174]),
        c: 29,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_one_8/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("68282c3fddc3aa7aabbff61772ef621b78adedcaed8b4ccaf1ab7e6b8e01361c");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_one_chaos_1() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([false]),
        b: Bitvector::<2>::from_iter([true, true]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([true]),
        e: Bitvector::<8>::from_iter([false, true, false, true, false, false, true, false]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_one_chaos_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("64d99ff40982dc77152ffd324add9251d78e4b83fc1a1e466d79a123444bdf8d");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_zero_0() {
    let value = FixedTestStruct { a: 0, b: 0, c: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_zero_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("db56114e00fdd4c1f85c892bf35ac9a89289aaecb1ebd0a96cde606a748b5d71");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_max_2() {
    let value = VarTestStruct {
        a: 65535,
        b: List::<u16, 1024>::from_iter([
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
        ]),
        c: 255,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_max_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("728b5cde46644e09809e707f1db6076c692954b8cc589a17884626884f5e05e9");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_small_test_struct_max_chaos_2() {
    let value = SmallTestStruct { a: 65535, b: 65535 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SmallTestStruct_max_chaos_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SmallTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("5ee8ff3d8661977c818a2d7f926019872cfef9cf4270b99ff833160f41fc01ec");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_zero_7() {
    let value = FixedTestStruct { a: 0, b: 0, c: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_zero_7/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("db56114e00fdd4c1f85c892bf35ac9a89289aaecb1ebd0a96cde606a748b5d71");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_small_test_struct_random_3() {
    let value = SmallTestStruct { a: 1916, b: 63799 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SmallTestStruct_random_3/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SmallTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("57841ce63e13790da0b2ff364dbf4a9e2fb95226220689bb070f170197c9a6d6");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_lengthy_9() {
    let value = ComplexTestStruct {
        a: 30344,
        b: List::<u16, 128>::from_iter([
            27285, 31750, 46578, 54105, 57571, 43485, 744, 1344, 32473, 47440, 11194, 63789, 51406,
            37376, 38249, 60165, 33154, 64174, 55216, 40772, 54694, 57064, 284, 15090, 37949, 2419,
            36394, 51863, 14377, 9930, 63924, 1052, 56672, 4452, 64521, 35049, 20321, 53698, 49928,
            57477, 32623, 9402, 19536, 53550, 14402, 43887, 12704, 16647, 12655, 36204, 30889,
            63009, 36953, 1485, 13796, 875, 40454, 39755, 40840, 7957, 39865, 45197, 4950, 28755,
            19609, 30717, 23519, 3819, 32042, 54189, 36262, 37283, 15891, 3286, 62776, 11998,
            17403, 36926, 19911, 60940, 9910, 51730, 3767, 10296, 24414, 56319, 7900, 46969, 48170,
            42937, 37053, 29988, 49978, 21348, 64806, 13650, 18850, 28151, 26745, 44992, 38448,
            26489, 12891, 45319, 44674, 43692, 57120, 19420, 33502, 9583, 4622, 3966, 60405, 55604,
            34205, 47241, 48704, 1772, 60046, 44520, 25522, 59273, 36522, 14925, 57471, 63734,
            55845, 30341,
        ]),
        c: 232,
        d: List::<u8, 256>::from_iter([
            99, 104, 35, 109, 210, 97, 247, 62, 235, 217, 21, 187, 178, 135, 238, 229, 12, 166, 76,
            68, 55, 19, 91, 60, 238, 24, 90, 152, 244, 178, 104, 142, 76, 80, 122, 99, 2, 14, 243,
            173, 120, 94, 19, 185, 125, 75, 3, 151, 150, 55, 51, 253, 255, 5, 75, 139, 94, 137,
            162, 121, 233, 174, 17, 237, 80, 0, 247, 2, 173, 190, 235, 180, 100, 146, 73, 197, 113,
            70, 176, 79, 36, 83, 178, 223, 158, 139, 191, 167, 111, 49, 235, 33, 145, 53, 15, 193,
            179, 141, 255, 243, 196, 169, 217, 153, 232, 143, 124, 106, 179, 239, 72, 112, 228, 17,
            29, 246, 29, 17, 32, 158, 115, 221, 175, 198, 247, 2, 61, 80, 242, 32, 254, 12, 240,
            109, 8, 164, 139, 205, 119, 166, 74, 8, 113, 105, 127, 161, 49, 134, 192, 1, 197, 13,
            38, 146, 178, 58, 13, 4, 99, 59, 4, 88, 112, 1, 228, 72, 115, 53, 247, 99, 20, 16, 196,
            40, 179, 179, 48, 139, 143, 161, 150, 56, 250, 11, 254, 139, 28, 251, 112, 10, 177,
            151, 246, 184, 5, 183, 151, 52, 83, 237, 50, 120, 193, 244, 31, 143, 50, 78, 223, 71,
            162, 171, 117, 57, 198, 234, 216, 78, 216, 209, 126, 100, 159, 199, 67, 191, 58, 42,
            135, 246, 102, 175, 206, 61, 35, 14, 51, 89, 34, 22, 51, 144, 71, 250, 109, 4, 139, 75,
            165, 214, 158, 218, 174, 43, 150, 168,
        ]),
        e: VarTestStruct {
            a: 6409,
            b: List::<u16, 1024>::from_iter([
                63410, 3333, 22112, 3774, 3153, 65192, 31578, 20841, 1011, 56551, 55765, 57694,
                16588, 21882, 51592, 64066, 61181, 42182, 52872, 42491, 16147, 33742, 12923, 25318,
                25964, 52728, 47839, 10450, 8881, 51682, 31438, 1864, 51725, 6773, 50158, 37906,
                36402, 27740, 18169, 62647, 27752, 39858, 31304, 2140, 46753, 8022, 53839, 28735,
                22576, 55301, 57556, 48592, 31738, 657, 62869, 47835, 61722, 9607, 61296, 5815,
                13471, 49662, 35481, 30600, 24824, 33743, 50959, 60611, 32000, 7011, 29471, 189,
                39699, 62663, 53365, 31214, 27133, 42428, 16934, 7822, 2781, 19234, 61631, 42863,
                41420, 3022, 64979, 33155, 17211, 6321, 23395, 43547, 33544, 39024, 10331, 18428,
                28026, 47427, 62052, 45348, 22566, 40636, 23279, 5109, 27057, 50493, 23229, 37698,
                30798, 3459, 38491, 43479, 1027, 58715, 61722, 5349, 51136, 46640, 38914, 34004,
                58899, 12839, 26742, 48070, 61283, 14369, 21488, 537, 58459, 4758, 63638, 14736,
                55981, 710, 32345, 43316, 60134, 44843, 17373, 6397, 52465, 30152, 59984, 15858,
                62684, 49955, 46097, 59932, 1622, 3154, 31660, 64727, 6181, 31762, 38556, 46394,
                17784, 46397, 64871, 11728, 54460, 33288, 50630, 7098, 32608, 47695, 47174, 2583,
                2206, 33316, 7837, 25989, 33133, 46083, 44285, 9169, 6780, 10805, 25059, 29236,
                58714, 6878, 38206, 58972, 31671, 59410, 27877, 58720, 51110, 39991, 19196, 12834,
                51762, 11134, 53261, 20274, 21300, 58618, 25420, 40834, 31722, 61603, 34526, 49735,
                61190, 20055, 16449, 56417, 42320, 9436, 51589, 3308, 22140, 64302, 2784, 12533,
                30639, 23075, 40629, 32394, 39842, 23184, 1790, 20546, 10781, 3726, 44617, 38538,
                24274, 25022, 41120, 39251, 13444, 44385, 20169, 13855, 4518, 34563, 61861, 42020,
                38421, 46262, 59118, 6038, 1387, 53995, 18361, 40919, 23573, 16076, 17299, 52522,
                47357, 45045, 8002, 11043, 49214, 63932, 21963, 48675, 54576, 55853, 39509, 60756,
                21336, 51375, 16952, 21746, 37491, 65495, 52028, 45966, 11184, 64390, 62137, 12924,
                14698, 32491, 37810, 28149, 44260, 32471, 21291, 22193, 48049, 16310, 48010, 44280,
                21934, 22727, 60556, 32535, 36516, 60493, 13962, 40438, 54881, 2180, 62420, 50849,
                2096, 37844, 19353, 2916, 4269, 50724, 57824, 35803, 55005, 32481, 12157, 20838,
                16058, 47691, 35670, 31224, 41494, 7626, 7959, 42590, 43802, 32741, 33809, 15502,
                15831, 11454, 59784, 44056, 63131, 15469, 8348, 62330, 36340, 47210, 35269, 16549,
                65016, 29816, 31523, 48294, 19249, 30907, 38802, 63284, 41843, 32135, 43782, 34852,
                28504, 34884, 35149, 48003, 64116, 35134, 56281, 41800, 35727, 19336, 40578, 31200,
                19608, 44044, 47782, 19650, 64200, 25410, 7177, 13064, 50022, 4312, 4322, 37597,
                35676, 10229, 29684, 935, 15426, 36879, 37844, 39243, 45468, 611, 21852, 45567,
                64939, 1961, 59055, 4320, 47190, 32843, 42519, 31197, 25754, 58426, 30288, 7910,
                1765, 9394, 61176, 32529, 23219, 3482, 46194, 13662, 14547, 26477, 2121, 13702,
                32186, 5229, 2576, 41328, 39013, 14395, 57869, 64527, 8911, 16918, 23615, 20578,
                8701, 5854, 7306, 54599, 3348, 27559, 6783, 23116, 7702, 55475, 13521, 41846,
                25227, 50582, 47649, 19258, 23006, 62989, 32137, 63862, 61177, 18536, 40346, 63096,
                48013, 51703, 830, 15846, 54885, 36908, 12024, 39511, 16852, 47311, 27011, 36334,
                54344, 59572, 58768, 43649, 40675, 55083, 47619, 20382, 37028, 10762, 62937, 49142,
                33630, 4672, 15202, 16523, 59513, 10039, 34221, 37921, 4462, 57673, 62957, 24726,
                57002, 37991, 42985, 34390, 50066, 29142, 61458, 30181, 6442, 43216, 62786, 36234,
                37652, 22963, 53068, 20291, 27988, 2542, 56678, 22020, 28692, 54146, 35072, 4752,
                23271, 43626, 64408, 46906, 33844, 15985, 12872, 50020, 42594, 55975, 56256, 50883,
                17688, 19694, 59039, 40465, 10662, 52752, 64518, 19535, 53608, 54060, 22121, 45124,
                385, 20746, 13378, 46843, 37145, 25736, 4586, 14540, 52342, 48518, 39620, 21257,
                45580, 20785, 60520, 47638, 50887, 7237, 21313, 23647, 41185, 49974, 36077, 57806,
                3878, 30205, 19761, 36345, 47089, 59211, 23734, 37410, 10696, 61413, 27030, 14160,
                54002, 21700, 7719, 46470, 47269, 53780, 20439, 26507, 49988, 60696, 32614, 8484,
                27411, 60931, 5374, 54530, 4977, 11701, 40538, 51387, 2367, 21390, 31145, 13488,
                46105, 45423, 44812, 28902, 41087, 40419, 54068, 23303, 21978, 44170, 44998, 53213,
                31834, 4029, 34403, 1972, 4226, 14927, 12308, 9763, 35969, 54408, 36726, 63816,
                64347, 50900, 14566, 700, 62233, 8580, 46005, 51306, 19836, 52369, 47471, 39457,
                324, 14937, 49777, 23565, 36855, 48991, 62856, 4755, 30401, 16094, 58049, 35734,
                4269, 2368, 22746, 31825, 40288, 24288, 39608, 51252, 55491, 25079, 44051, 61721,
                18363, 30223, 27793, 41635, 17413, 64342, 6349, 11062, 3503, 16321, 18950, 38123,
                33118, 1994, 21038, 57207, 6895, 47933, 23177, 38368, 37916, 5660, 6239, 44653,
                20689, 23588, 16486, 26792, 41416, 63367, 56706, 35288, 20434, 26791, 22874, 14427,
                40070, 2140, 59890, 16891, 5785, 42811, 27493, 61832, 53939, 47778, 7698, 44865,
                46169, 25362, 52730, 57474, 11122, 34975, 58660, 32425, 63494, 7520, 11826, 9648,
                49205, 54811, 17381, 52565, 58686, 47967, 18636, 23513, 14097, 50725, 32871, 33108,
                53504, 56074, 46964, 50577, 17793, 38712, 28408, 8338, 54068, 9346, 966, 20559,
                27367, 60168, 22896, 16668, 19005, 46720, 9278, 64996, 2975, 63196, 36376, 55246,
                52241, 34757, 19037, 29815, 46636, 12221, 4494, 57458, 55359, 38388, 49529, 59896,
                52599, 22135, 6903, 38917, 45249, 29172, 62024, 32505, 43125, 20212, 23885, 10921,
                6687, 51513, 18115, 45864, 7000, 45969, 50822, 36648, 49482, 1494, 47249, 3068,
                15290, 8645, 41494, 16928, 47112, 19835, 7469, 49589, 13542, 24179, 21931, 11862,
                64752, 46141, 26490, 10401, 64630, 139, 34818, 39655, 50656, 57591, 24338, 40087,
                7087, 40290, 10479, 19267, 28618, 43263, 38254, 40649, 11078, 25338, 59267, 65367,
                28771, 41091, 47426, 54947, 19759, 24984, 33337, 36131, 45227, 54145, 47460, 60807,
                15609, 5357, 23158, 749, 55515, 20322, 3713, 43736, 58335, 16694, 3839, 53659,
                44883, 5353, 27992, 59519, 57154, 38753, 4709, 10267, 48741, 53882, 49165, 20236,
                44944, 31435, 24580, 13008, 40126, 43198, 40989, 61928, 21272, 44923, 12035, 28932,
                13161, 11568, 37809, 32970, 11964, 19814, 49208, 45575, 47345, 44367, 17992, 8667,
                53291, 30138, 2968, 28456, 54800, 10841, 59159, 20789, 8138, 44560, 56841, 34514,
                39638, 34857, 5850, 53223, 39770, 15438, 46294, 64553, 62318, 34384, 41875, 16251,
                4125, 34735, 39820, 21427, 54023, 56564, 43365, 31444, 39463, 19207, 125, 32098,
                16220, 2291, 51231, 30998, 63093, 64973, 3102, 42590, 12084, 46333, 58265, 21993,
                21819, 8128, 52754, 36493, 55314, 47006, 46010, 60487, 39627, 5885, 35918, 17349,
                35856, 43092, 64254, 14809, 35588, 40581, 43011, 43638, 2534, 4094, 50625, 39517,
                54074, 20328, 65, 31919, 29051, 51068, 35171, 19001, 43332, 18907, 48556, 34896,
                19087, 38730, 37610, 35289, 37586, 41011, 38083, 17144, 7460, 12001, 28579, 33565,
                37202, 43234, 34160, 9931, 33234, 65381, 51965, 20912, 27298, 57502, 28904, 41156,
                55146, 62593, 20262, 7179, 3469, 18423, 48539, 20036, 28189, 19676, 2003, 9700,
                20536, 20312, 48842, 3153, 15725, 7350, 33505, 48503, 43534, 63739, 41968, 11656,
                44112, 59996, 51697, 23090, 12070, 23536, 1632, 19669, 62805, 14447, 32973, 31165,
                41737, 10307, 20029, 46979,
            ]),
            c: 207,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 8,
                b: 9407325527306457431,
                c: 2933613952,
            },
            FixedTestStruct {
                a: 182,
                b: 8329657173333432997,
                c: 4042190449,
            },
            FixedTestStruct {
                a: 21,
                b: 6255070391095125444,
                c: 196984688,
            },
            FixedTestStruct {
                a: 218,
                b: 5821387191283060247,
                c: 1932683805,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 7018,
                b: List::<u16, 1024>::from_iter([
                    43098, 46200, 50262, 46999, 38620, 18378, 44705, 64505, 12555, 5316, 45278,
                    8567, 16568, 50442, 11392, 34878, 25044, 21481, 52692, 24747, 50889, 39004,
                    34142, 18210, 11272, 30435, 2780, 19317, 32033, 1136, 16491, 50779, 17161,
                    37607, 47108, 65311, 23368, 27166, 2544, 17356, 60532, 61886, 19133, 59978,
                    42817, 40814, 27506, 15256, 61747, 57296, 7542, 9565, 22134, 59988, 53638,
                    26366, 10813, 48368, 22652, 41466, 42593, 9637, 41948, 29650, 3157, 21270,
                    25656, 6153, 52797, 5200, 11722, 3711, 60325, 51879, 36431, 46074, 36185,
                    51780, 6497, 38753, 55377, 64343, 8718, 48211, 4583, 31556, 27408, 50439,
                    18682, 35879, 57439, 57574, 44543, 35493, 61391, 25224, 31780, 18164, 7750,
                    912, 16861, 1515, 22940, 58903, 63435, 35513, 49830, 57677, 27438, 24513,
                    58430, 60512, 63885, 6852, 13701, 33348, 11290, 35936, 62340, 21992, 60689,
                    16543, 20909, 50921, 30810, 10837, 22806, 50471, 45553, 1469, 16246, 16264,
                    61992, 2710, 33427, 200, 63360, 6192, 19245, 53849, 5076, 18975, 57053, 22631,
                    20837, 48718, 38675, 17891, 10227, 27507, 13473, 7658, 14031, 30338, 35614,
                    24310, 64381, 23802, 50688, 16532, 20075, 65, 13796, 43567, 11667, 21859,
                    33233, 45834, 53935, 64313, 37733, 10413, 19782, 14743, 52847, 33860, 28992,
                    50819, 52612, 12418, 16090, 44274, 29020, 55372, 18466, 27080, 33037, 29604,
                    40796, 58766, 4522, 65151, 27003, 53634, 47977, 18071, 19469, 41752, 5443,
                    20514, 5068, 46750, 7703, 2691, 51603, 18774, 29130, 10980, 40952, 15347,
                    32581, 26192, 22721, 24097, 62756, 60603, 13693, 2283, 45230, 11527, 11069,
                    55505, 49452, 21545, 31080, 5669, 645, 9171, 64811, 28980, 36466, 9754, 31325,
                    28452, 32917, 61039, 55538, 52336, 44011, 59914, 64405, 20922, 37363, 711,
                    39954, 20905, 40614, 28166, 26512, 58331, 40876, 19178, 58990, 9518, 36534,
                    154, 19401, 45594, 14112, 50823, 60155, 64095, 12960, 13214, 17408, 12175,
                    40677, 29991, 16035, 6204, 59464, 25821, 19842, 129, 3678, 2367, 53323, 36515,
                    1736, 38471, 622, 29744, 26822, 32214, 3415, 38173, 3336, 53438, 2858, 54691,
                    35213, 21249, 46915, 21909, 24056, 25690, 4434, 48222, 51727, 33304, 49295,
                    18984, 15650, 58793, 38766, 45265, 6952, 49299, 54158, 9497, 18353, 49520,
                    59698, 43027, 18229, 17170, 57466, 22670, 26859, 18604, 31410, 54697, 26266,
                    36123, 26021, 36147, 48347, 22383, 56231, 45105, 56189, 29249, 55500, 56529,
                    25916, 51290, 37361, 30115, 17747, 19695, 58250, 24898, 54592, 22796, 54272,
                    58544, 59344, 52296, 11445, 37480, 7282, 20367, 43167, 32914, 56855, 60674,
                    59318, 38262, 36010, 55832, 23636, 56720, 38899, 1561, 26058, 223, 37389,
                    24820, 61106, 57061, 46303, 1272, 17467, 33287, 45281, 12626, 25860, 14501,
                    25588, 35362, 49506, 18178, 40631, 54615, 36053, 59387, 59725, 24238, 40121,
                    48787, 32896, 16587, 22279, 30411, 58186, 22080, 9373, 19604, 14359, 55700,
                    57974, 11658, 7238, 29661, 21531, 47095, 22997, 15085, 36567, 39716, 10495,
                    430, 64646, 56191, 8794, 37306, 50710, 24088, 44783, 9759, 60690, 55937, 31269,
                    64319, 30882, 36085, 20947, 57802, 869, 19771, 32766, 20648, 52946, 38537,
                    42700, 28646, 58652, 20501, 31266, 31208, 24668, 35432, 21639, 36402, 32519,
                    40154, 58588, 34345, 57750, 57376, 6833, 27861, 16917, 29216, 41765, 60382,
                    54098, 18900, 32347, 11328, 3226, 55071, 49318, 62589, 41292, 17665, 40502,
                    13921, 60323, 36986, 29224, 20147, 51648, 19556, 65145, 37584, 54410, 24026,
                    13347, 61507, 61588, 27906, 65504, 8594, 18646, 49866, 9067, 51116, 6993,
                    53976, 32466, 63395, 22242, 54383, 11331, 14678, 40780, 34177, 26991, 60359,
                    17992, 43450, 6698, 16714, 30853, 52688, 50404, 5321, 4855, 3771, 65309, 6433,
                    31790, 2963, 3606, 12865, 43293, 5611, 5135, 46963, 43906, 1616, 24725, 14402,
                    32709, 55954, 23195, 40091, 11968, 10486, 52562, 21860, 37543, 15002, 44373,
                    26694, 28590, 47720, 63765, 34019, 49263, 23025, 17439, 57757, 56990, 17009,
                    34978, 30805, 18471, 8836, 654, 48527, 35306, 12660, 46504, 14148, 13913,
                    46466, 53818, 63112, 18550, 30159, 9301, 5362, 52023, 33217, 38581, 45924,
                    7974, 12803, 63798, 5798, 7985, 48463, 45834, 54081, 61285, 32821, 18812,
                    42408, 3165, 39051, 57071, 39040, 11792, 42107, 48688, 57379, 37237, 33795,
                    40107, 59746, 59506, 35266, 54010, 58902, 33580, 23866, 33435, 32962, 40398,
                    55618, 61761, 36025, 23562, 27145, 9438, 43715, 25561, 38858, 50719, 63935,
                    33690, 14547, 4975, 41583, 13237, 12707, 7971, 63141, 63796, 21324, 35296, 740,
                    50344, 31799, 1734, 23705, 24915, 36553, 43456, 34202, 46971, 16967, 50430,
                    52358, 19881, 15126, 63764, 52518, 56362, 24298, 63997, 25767, 33518, 2220,
                    13098, 63530, 29121, 51470, 2202, 13616, 20929, 39972, 32215, 5589, 58690,
                    20307, 28460, 34611, 10796, 41282, 55431, 15931, 10424, 14829, 45864, 41277,
                    14379, 25110, 24057, 5549, 52787, 48504, 63914, 44452, 62850, 37495, 53989,
                    41185, 59128, 28312, 1502, 31600, 4989, 9797, 58866, 30819, 1798, 57517, 39721,
                    31914, 34246, 22870, 16037, 56088, 556, 50712, 17845, 48969, 13382, 65306,
                    21072, 10189, 46615, 25768, 24024, 49747, 20412, 55951, 2021, 60814, 43975,
                    51108, 13766, 35391, 60542, 37828, 40526, 29043, 34807, 13952, 38863, 60373,
                    1743, 1198, 53116, 49804, 35983, 28428, 15515, 59619, 61398, 16918, 52307,
                    19343, 53872, 49687, 58015, 4287, 37269, 9218, 17093, 1389, 47269, 27012,
                    16045, 4215, 36546, 23671, 7078, 12631, 6591, 16903, 24848, 48093, 42199, 1891,
                    13553, 46915, 45022, 61592, 62244, 19226, 29493, 8982, 62806, 6589, 2322,
                    54202, 29447, 39963, 17710, 20136, 27832, 25209, 546, 58036, 10959, 38263,
                    46087, 3538, 44747, 48477, 17069, 41980, 23332, 30470, 39352, 35748, 59229,
                    42149, 54606, 38011, 26360, 26286, 16283, 20205, 14543, 34091, 49148, 36856,
                    31008, 44862, 20764, 65200, 64769, 3928, 4407, 13162, 59320, 45164, 11184,
                    48751, 19951, 4400, 35780, 5351, 3198, 9999, 20930, 13433, 1476, 31354, 16076,
                    45839, 58665, 37397, 59184, 17508, 30483, 63018, 2980, 10620, 63414, 31792,
                    30726, 53831, 53535, 13653, 55001, 57378, 50809, 59009, 31528, 16231, 46285,
                    6986, 26841, 17511, 29374, 59738, 57325, 1565, 64660, 10472, 17325, 3456,
                    37583, 44340, 10072, 33685, 29960, 56476, 47911, 63897, 12783, 3474, 35717,
                    49731, 58217, 4750, 26266, 52660, 24864, 38589, 42348, 14894, 48343, 44401,
                    10977, 20286, 59494, 35009, 63663, 35439, 26493, 9537, 39135, 44394, 35160,
                    53240, 11665, 7515, 62431, 63664, 47147, 33763, 31681, 18924, 60501, 5647,
                    47825, 62901, 36809, 13301, 63003, 63395, 45775, 837, 12745, 3684, 56930,
                    56744, 65166, 57999, 206, 14846, 56101, 8860, 29970, 22845, 32931, 31349,
                    37328, 40238, 15053, 33701, 31547, 51327, 28558, 27800, 40148, 16370, 24419,
                    12401, 15367, 44293, 51437, 52488, 39230, 39794, 63832, 7968, 29063, 54310,
                    5150, 23537, 56930, 20838, 31438, 19967, 54908, 47290, 29820, 7467, 53824,
                    55384, 14138, 22305, 6108, 38807, 37503, 4279, 33530, 29331, 51855, 36139,
                    47840, 9528, 48174, 41430, 51015, 38738, 34687, 9490, 54679, 57138, 45660,
                    53303, 64637, 4275, 63961, 46342, 23412, 29627, 61697, 22324, 30255, 63916,
                    47755, 58401, 17967, 21088, 59836, 56763, 5464, 36602, 35741, 34564, 5548,
                    13056, 39975, 14237, 21837, 65337, 51652, 4385, 26520, 17356, 53348, 22154,
                    39463, 19833, 43318, 43823, 61335, 33575, 32186, 47874, 61236, 50058, 50230,
                    53043,
                ]),
                c: 132,
            },
            VarTestStruct {
                a: 60230,
                b: List::<u16, 1024>::from_iter([
                    48625, 39218, 40689, 38688, 40060, 28479, 14797, 32969, 20063, 21210, 53756,
                    56938, 27073, 8282, 18402, 30525, 17473, 44106, 30268, 20699, 57653, 4455,
                    51446, 63986, 56054, 37298, 4258, 50768, 34993, 27755, 50588, 12788, 41791,
                    3753, 31929, 7424, 61495, 51548, 37814, 24743, 46080, 37721, 47836, 30008,
                    54222, 2715, 42764, 18282, 60523, 46264, 50187, 51469, 30011, 29056, 6288,
                    27896, 28623, 59896, 15567, 32117, 55484, 7336, 20108, 7682, 11590, 33554,
                    11922, 4708, 64571, 53943, 37648, 42193, 64556, 29042, 28758, 43466, 58098,
                    43723, 63964, 42841, 29337, 50593, 31251, 20852, 42913, 5795, 58071, 61019,
                    59786, 3437, 6742, 63808, 50631, 53363, 19337, 34405, 51682, 63309, 48657,
                    28202, 39025, 42702, 34838, 19773, 32396, 29502, 23607, 61313, 26073, 41212,
                    19723, 57508, 10083, 55123, 9289, 14482, 60359, 52796, 36081, 61694, 56031,
                    18754, 12884, 53179, 38364, 18307, 40777, 59375, 429, 761, 50366, 9602, 41859,
                    10209, 35978, 40516, 38156, 54857, 52903, 30324, 27715, 18551, 3045, 62645,
                    49957, 3987, 6781, 64601, 45195, 43030, 1462, 32801, 60393, 8807, 37199, 49932,
                    30469, 46832, 26, 10553, 52584, 17851, 63480, 19134, 59981, 9008, 62017, 13372,
                    29155, 30976, 8908, 60005, 52622, 64231, 48245, 37044, 29679, 7430, 59299,
                    18119, 46458, 49331, 18060, 25177, 26831, 8580, 23630, 14623, 200, 38949,
                    15451, 48700, 17188, 21655, 58800, 31799, 12154, 53133, 3322, 7057, 42360,
                    22721, 60186, 56545, 28018, 13595, 51872, 20606, 38725, 39320, 28178, 11912,
                    11044, 53548, 25851, 45456, 15658, 29010, 51291, 63882, 17578, 35256, 56382,
                    29370, 53327, 41196, 18449, 43822, 31787, 2172, 30364, 22029, 62721, 12992,
                    62990, 24444, 16328, 36418, 2799, 28662, 9518, 61953, 17105, 36252, 46239,
                    51004, 54857, 43928, 6110, 300, 5101, 41749, 48744, 3324, 946, 41271, 62515,
                    25838, 9751, 4924, 1459, 740, 1251, 2411, 53147, 24539, 39790, 45150, 28968,
                    59561, 5564, 27254, 17882, 3238, 17209, 8961, 24259, 4488, 10522, 33221, 48805,
                    61225, 54440, 26345, 36582, 22590, 64970, 33054, 21834, 17554, 19140, 46253,
                    48, 13262, 38541, 38394, 2693, 53230, 9192, 4955, 57444, 1217, 39122, 32834,
                    61081, 2482, 62447, 50413, 18598, 11686, 59910, 34317, 57503, 2159, 50574,
                    12696, 57089, 10918, 11733, 56551, 20996, 19357, 28449, 41928, 2702, 12287,
                    63175, 48539, 28440, 8058, 4304, 38971, 19335, 35301, 18553, 18717, 56490,
                    37832, 57320, 58904, 41535, 39084, 17171, 782, 10658, 29739, 48517, 52219,
                    11377, 45427, 14311, 57271, 59781, 20654, 26667, 2963, 17075, 58717, 27238,
                    17407, 49658, 17268, 62331, 44353, 4758, 8821, 61029, 56207, 33050, 52965,
                    18927, 16860, 56918, 3119, 38679, 41920, 21268, 8342, 39832, 25697, 61270,
                    62830, 46088, 52734, 59674, 22098, 46789, 25670, 11498, 57195, 56983, 30984,
                    51068, 40006, 62993, 22589, 11572, 21959, 45883, 37821, 33381, 12333, 38541,
                    34350, 34311, 63663, 26190, 41436, 43652, 21907, 58079, 19510, 56504, 37258,
                    46240, 55747, 39917, 32726, 3615, 58318, 61278, 16443, 3649, 57628, 24445,
                    31454, 31581, 21837, 15542, 54959, 61187, 54795, 24413, 63975, 21751, 23949,
                    63634, 1835, 50662, 1561, 35842, 28912, 20722, 43761, 41155, 33593, 11124,
                    22161, 10980, 30406, 62151, 42315, 43447, 60719, 45085, 59308, 11344, 41296,
                    34139, 22241, 41415, 12101, 35684, 62291, 43687, 11610, 16837, 5779, 39962,
                    15327, 34523, 29912, 24449, 12825, 13327, 54841, 35347, 34058, 62120, 59854,
                    22410, 28718, 8927, 55282, 62494, 37868, 57692, 64239, 64124, 60187, 61116,
                    345, 51320, 36763, 42453, 14900, 32755, 58781, 26293, 27779, 45923, 18447,
                    4991, 467, 49526, 4266, 15726, 7463, 47461, 37563, 38099, 19962, 54002, 63104,
                    13743, 23438, 53938, 45720, 576, 57555, 5850, 13332, 34899, 26143, 2083, 35890,
                    57293, 56259, 16253, 6193, 14598, 62369, 55203, 53559, 13975, 92, 43783, 18455,
                    29743, 17919, 25238, 4456, 49722, 49024, 18851, 27317, 5999, 46856, 52203,
                    44748, 50270, 42993, 22117, 12760, 32564, 54815, 29622, 14478, 46560, 18835,
                    26309, 4059, 57162, 30070, 7984, 47583, 34280, 9480, 52899, 21655, 62443,
                    17375, 60322, 43671, 60129, 51501, 55440, 63956, 4958, 64271, 63939, 2538,
                    18437, 46976, 37326, 19379, 42426, 36156, 19193, 56467, 270, 4980, 58745,
                    35117, 3933, 92, 12900, 31402, 58370, 6080, 32852, 30705, 27404, 29138, 16907,
                    23917, 16975, 48484, 1421, 10160, 30783, 64215, 39743, 54494, 49319, 14345,
                    26466, 8292, 19030, 57511, 32333, 61805, 2761, 45783, 709, 13581, 13161, 62803,
                    60778, 56223, 49022, 64397, 15284, 12257, 40286, 18770, 36208, 10372, 30645,
                    59991, 648, 17640, 16542, 14129, 32407, 58, 3817, 53913, 24513, 48190, 807,
                    6010, 60183, 33436, 27063, 32277, 32297, 35879, 37183, 26000, 42937, 35067,
                    5590, 25716, 25910, 332, 36604, 55407, 12884, 56579, 57708, 42199, 40857, 5035,
                    43459, 8017, 27155, 56986, 42047, 63491, 28770, 17823, 64036, 50015, 11934,
                    60994, 51679, 22233, 35129, 50450, 54561, 27758, 2630, 48575, 55503, 51060,
                    44271, 29615, 37625, 4085, 42005, 32484, 30992, 29733, 20919, 60265, 26015,
                    38753, 11279, 27339, 62615, 34569, 57073, 40002, 31325, 42099, 42843, 43942,
                    52321, 12137, 65101, 32204, 44611, 3228, 29627, 5595, 26584, 59241, 39916,
                    24623, 53918, 26011, 50199, 62328, 36200, 49780, 6221, 62607, 60162, 48885,
                    5170, 29493, 56284, 13757, 29990, 51687, 53108, 22293, 10059, 5001, 2481, 1444,
                    41176, 13969, 951, 41744, 40716, 39172, 43043, 57489, 48285, 63488, 11757,
                    16429, 38927, 38194, 6631, 58747, 28307, 19347, 37029, 20747, 54507, 21434,
                    30300, 19020, 50754, 14953, 56542, 25494, 1792, 2491, 46365, 56394, 23094,
                    14540, 49144, 64003, 2859, 36132, 17045, 63916, 11508, 57869, 52249, 8432,
                    6279, 5662, 14002, 57781, 60233, 35301, 8118, 2631, 63339, 31750, 45533, 27351,
                    45286, 4325, 62904, 332, 19373, 55217, 1263, 16834, 49570, 41914, 12410, 65275,
                    6623, 1058, 44509, 16173, 62906, 59682, 23913, 53458, 8046, 53755, 56508,
                    21915, 38855, 4355, 4121, 673, 43372, 19767, 36153, 22687, 38756, 28169, 48513,
                    37608, 514, 45854, 6406, 28690, 33712, 57309, 35338, 3063, 21940, 7027, 53192,
                    59745, 12031, 39588, 25609, 47072, 19534, 36125, 19641, 49482, 27357, 48433,
                    45573, 48973, 53000, 19103, 22494, 35025, 19796, 56519, 55867, 13066, 17967,
                    33728, 34408, 42385, 64838, 40090, 12389, 2320, 26085, 60917, 18845, 51572,
                    40816, 22764, 51406, 11156, 2240, 6265, 33196, 55882, 26416, 58626, 26985,
                    5084, 28750, 748, 53009, 14592, 27065, 22269, 21131, 14943, 25655, 11630, 8112,
                    12518, 4725, 670, 40380, 49609, 10272, 5187, 15117, 19681, 21505, 4185, 8610,
                    65478, 27779, 28384, 41950, 63892, 59443, 44106, 62648, 57753, 30321, 897,
                    28356, 39983, 9255, 41966, 23375, 60510, 18161, 17789, 11601, 32797, 41758,
                    26861, 51502, 64068, 23663, 16515, 1337, 9318, 28494, 63971, 828, 37694, 63851,
                    11364, 49195, 30987, 51010, 23361, 19134, 32136, 1988, 33256, 17850, 51762,
                    20238, 33863, 30142, 20972, 65160, 52956, 60571, 53271, 43459, 27579, 1863,
                    3167, 18845, 2970, 63740, 21140, 4759, 22464, 1785, 31667, 8635, 44831, 6888,
                    45138, 29365, 65350, 54096, 13327, 42212, 7626, 9877, 28042, 57482, 14523, 84,
                    62177, 14732, 53754, 56472, 16326, 31686, 16353, 25286, 41969, 42352, 13278,
                    42273, 47367, 29562, 23245, 26554, 42062, 26726, 44714, 4391, 51325,
                ]),
                c: 98,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_lengthy_9/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("4f851814990c1305f4686cda352ec5c2313a0dff0d960a7a900ce1e2e90f8150");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_max() {
    let value = SingleFieldTestStruct { a: 255 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_max/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("ff00000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_small_test_struct_random_4() {
    let value = SmallTestStruct { a: 32745, b: 8462 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SmallTestStruct_random_4/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SmallTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("864908308d350be5c4591f067a662751434af440702d06685f8a652c07f6c12a");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_lengthy_7() {
    let value = ComplexTestStruct {
        a: 30521,
        b: List::<u16, 128>::from_iter([
            10757, 35890, 12515, 50368, 25758, 35190, 25950, 21021, 49712, 38881, 38680, 30011,
            4064, 55981, 47138, 59921, 45521, 20265, 14741, 11262, 8367, 64030, 10448, 40723,
            62505, 3639, 55780, 61641, 41167, 16656, 8119, 15105, 15914, 52091, 53317, 33987,
            58752, 30803, 35976, 39145, 11730, 61249, 44559, 6939, 27626, 52987, 15022, 18764,
            12586, 35713, 15780, 13105, 12997, 55555, 36315, 58098, 28815, 12879, 22618, 32975,
            28616, 6821, 42723, 10854, 41342, 4193, 26184, 2580, 21194, 47861, 65451, 45510, 62093,
            62855, 20637, 29736, 3043, 145, 54436, 43015, 52293, 50082, 36481, 59583, 21178, 17853,
            11801, 12943, 3584, 45978, 54013, 37949, 39997, 32388, 36428, 17725, 39198, 7599,
            60281, 29528, 14864, 19332, 48578, 40088, 27335, 42630, 8360, 35401, 58522, 18576,
            20625, 6665, 50698, 46374, 18421, 37370, 48564, 42619, 27550, 29524, 19179, 34087,
            9549, 56589, 23552, 35125, 45204, 35582,
        ]),
        c: 210,
        d: List::<u8, 256>::from_iter([
            166, 27, 8, 16, 152, 164, 224, 203, 128, 168, 249, 157, 113, 29, 67, 241, 27, 84, 115,
            165, 127, 71, 211, 107, 25, 35, 99, 24, 80, 7, 40, 237, 113, 18, 213, 168, 53, 151,
            137, 128, 87, 46, 90, 144, 122, 11, 87, 45, 20, 171, 156, 201, 105, 241, 65, 16, 64,
            72, 7, 152, 4, 183, 47, 222, 110, 212, 219, 200, 196, 27, 33, 170, 166, 87, 48, 247,
            240, 143, 107, 239, 71, 53, 157, 140, 143, 203, 248, 208, 52, 87, 66, 215, 73, 90, 152,
            97, 126, 249, 32, 188, 178, 46, 242, 157, 52, 35, 44, 22, 214, 71, 128, 105, 229, 99,
            61, 229, 155, 100, 34, 23, 164, 60, 14, 189, 10, 62, 60, 65, 165, 247, 222, 229, 175,
            138, 162, 132, 78, 144, 125, 53, 29, 218, 146, 74, 230, 44, 116, 99, 149, 184, 69, 101,
            74, 135, 77, 40, 126, 81, 67, 1, 78, 246, 51, 248, 111, 200, 177, 87, 134, 17, 113,
            154, 161, 73, 129, 17, 252, 47, 69, 76, 203, 112, 113, 114, 47, 147, 161, 101, 24, 5,
            154, 147, 138, 170, 118, 155, 10, 206, 247, 221, 181, 248, 111, 94, 156, 129, 158, 45,
            117, 136, 55, 9, 125, 65, 52, 185, 107, 202, 64, 79, 83, 1, 255, 212, 178, 228, 57, 46,
            49, 100, 126, 89, 53, 153, 121, 136, 166, 76, 146, 120, 17, 224, 134, 108, 163, 169,
            234, 249, 167, 30, 77, 67, 152, 182, 174, 104,
        ]),
        e: VarTestStruct {
            a: 27041,
            b: List::<u16, 1024>::from_iter([
                49600, 61775, 21387, 44317, 23608, 33906, 31434, 61720, 30487, 61629, 62489, 53183,
                6739, 42206, 33620, 45146, 52617, 4696, 23207, 42706, 44091, 3309, 22826, 24081,
                38684, 15934, 50964, 32181, 34184, 32606, 21759, 38223, 19125, 44609, 57140, 58834,
                4801, 50545, 10086, 29252, 54060, 12525, 58780, 1300, 24995, 62135, 31105, 41613,
                20832, 29299, 18164, 36172, 15004, 58376, 64230, 64055, 49875, 40591, 58249, 40585,
                37618, 60025, 11635, 34482, 49751, 8496, 28883, 64002, 45259, 8948, 60117, 1663,
                45342, 23917, 13786, 34365, 32563, 24011, 1086, 45351, 25791, 60747, 61720, 19428,
                22802, 27246, 7015, 65338, 40548, 12277, 35081, 41459, 27326, 50564, 47023, 54679,
                2804, 38190, 51806, 21795, 12182, 36428, 477, 65070, 25644, 38394, 63283, 36261,
                61914, 49964, 55277, 33547, 39696, 31036, 31006, 52697, 45745, 56971, 37404, 39118,
                802, 29699, 960, 25552, 30653, 48998, 7044, 10608, 31466, 22372, 51057, 35007,
                24785, 37771, 19875, 34121, 44743, 27521, 6023, 58913, 23733, 15861, 48487, 50859,
                52867, 39431, 50481, 18607, 20243, 34343, 4791, 26930, 60013, 20925, 10993, 33913,
                6035, 2216, 19581, 7814, 40614, 7809, 51781, 33924, 5514, 36179, 62600, 56435,
                65313, 10400, 15626, 15213, 48139, 12755, 11544, 39989, 27381, 51889, 31306, 49777,
                9775, 34623, 44564, 54900, 53268, 16176, 17332, 636, 638, 43044, 26962, 35851,
                64215, 54835, 30082, 62363, 44934, 4784, 11795, 17119, 38379, 45660, 12506, 60110,
                57183, 6478, 24047, 19342, 2734, 19217, 16219, 31026, 15411, 13410, 43181, 35809,
                32686, 18376, 2496, 23904, 57206, 11820, 19397, 7919, 33029, 60772, 23086, 40602,
                62917, 41786, 16865, 42189, 38226, 55964, 51785, 61186, 52845, 32595, 4578, 15050,
                3346, 6267, 48040, 54333, 16786, 7318, 48790, 32131, 49916, 28357, 47765, 10234,
                25577, 45201, 3885, 18658, 58845, 20671, 56205, 35710, 51446, 33175, 23613, 35948,
                26876, 64975, 63149, 60613, 6858, 39184, 21414, 7663, 5463, 26004, 8483, 44214,
                43087, 12121, 47589, 64373, 28854, 16934, 31237, 47624, 7826, 19932, 1499, 46533,
                56395, 57458, 64746, 42487, 53463, 10681, 49246, 48813, 11075, 23221, 58349, 42103,
                42718, 15360, 44046, 17004, 1319, 5765, 47678, 14993, 11717, 48410, 3705, 64362,
                18796, 6586, 11188, 17916, 43055, 42968, 54055, 20005, 3349, 8986, 40001, 22986,
                40893, 31454, 60828, 10778, 11000, 49999, 19184, 24204, 38294, 56925, 35888, 18647,
                63133, 15852, 12811, 55156, 63081, 30560, 10613, 578, 21423, 15344, 46588, 9781,
                10799, 18863, 29416, 14697, 41097, 15992, 24999, 43217, 53357, 58056, 19815, 14798,
                23451, 1325, 52924, 43188, 56101, 1866, 59895, 55056, 14423, 3204, 50262, 53377,
                29041, 59013, 2239, 3975, 23459, 61255, 8540, 29151, 45468, 55815, 41237, 24387,
                41098, 33582, 53984, 22224, 17212, 19913, 35416, 27613, 38630, 47795, 20106, 12203,
                1227, 62979, 24822, 10594, 3270, 2988, 13821, 44678, 35836, 47672, 55189, 38775,
                5634, 38167, 7523, 31434, 19651, 14798, 62148, 1011, 27738, 40121, 31530, 63368,
                36038, 53762, 2928, 19322, 44731, 9120, 22974, 51100, 48553, 62294, 63199, 20763,
                5382, 18465, 18901, 12548, 10022, 56028, 16244, 9669, 48181, 9509, 30835, 46120,
                57911, 42047, 831, 2898, 45462, 18104, 3849, 43064, 63549, 50179, 32631, 9473,
                62641, 61487, 53746, 51999, 26268, 35895, 50248, 25364, 7762, 9668, 36186, 35147,
                31511, 684, 50919, 5139, 40201, 15114, 36926, 25951, 15206, 56822, 12517, 17423,
                22233, 40624, 45201, 47729, 30568, 23114, 27258, 58340, 17070, 12023, 46841, 7164,
                25449, 32079, 65305, 63254, 63226, 7971, 32989, 42042, 45422, 63513, 31462, 12250,
                30917, 24784, 38444, 31772, 35021, 10283, 12408, 36924, 6582, 60677, 50199, 894,
                8593, 59585, 12766, 20020, 46231, 23283, 58546, 18483, 29026, 38069, 48164, 17418,
                12521, 41392, 25184, 18692, 37690, 63055, 14440, 17753, 19065, 14596, 55031, 43079,
                28846, 59284, 55501, 30972, 37270, 61187, 47350, 17190, 58159, 12954, 32122, 57852,
                28912, 16187, 26695, 53193, 59891, 65426, 40778, 63816, 32093, 59086, 38586, 5939,
                57907, 44873, 44620, 64060, 57814, 60855, 34191, 20549, 44740, 7974, 27397, 3237,
                43493, 17244, 8347, 54782, 35280, 51977, 27761, 46352, 49620, 16987, 24423, 53386,
                58077, 30375, 14266, 65325, 34235, 23281, 4424, 63614, 1398, 64361, 2930, 32803,
                57336, 10316, 45895, 32190, 59305, 41692, 20841, 40889, 59867, 50962, 14147, 51709,
                59810, 39868, 4328, 36406, 43028, 48452, 56791, 5163, 63020, 46371, 9780, 18302,
                60260, 15493, 16110, 558, 59687, 29486, 31673, 9047, 32328, 37263, 49000, 7374,
                62590, 54787, 39241, 927, 41779, 15873, 41042, 14323, 52868, 50135, 5303, 55660,
                1292, 37131, 40413, 62478, 41112, 56077, 16238, 13025, 62333, 16197, 10543, 48016,
                42674, 10859, 15929, 34335, 47091, 49321, 46545, 33551, 33504, 22837, 39801, 57764,
                37490, 13963, 39750, 28474, 22087, 58703, 15526, 45634, 38730, 57103, 22749, 58383,
                1127, 11522, 28856, 52026, 61543, 55417, 22948, 20569, 35359, 4436, 45577, 12140,
                49817, 61949, 22675, 8027, 58761, 55661, 33889, 54508, 53847, 63020, 32063, 8901,
                57762, 36581, 29011, 21097, 9182, 50926, 59726, 33845, 37074, 10414, 42946, 56885,
                21471, 15339, 4882, 47573, 63689, 8183, 35091, 33854, 41940, 37328, 30004, 46,
                39520, 50311, 2019, 19361, 30508, 15455, 56175, 16580, 26561, 9424, 11380, 30991,
                59904, 59351, 20741, 8092, 28568, 46740, 60735, 35372, 26709, 13410, 23177, 37215,
                52392, 54816, 26853, 14321, 3497, 21829, 33036, 41828, 48725, 44004, 25457, 20071,
                2832, 43006, 40076, 2831, 19795, 60767, 24095, 5464, 52362, 14626, 7906, 42281,
                33382, 37535, 9845, 50087, 51061, 16326, 2966, 18477, 31622, 22862, 53792, 59073,
                36607, 26508, 42679, 29438, 50147, 37839, 37789, 53749, 64892, 62089, 39303, 44226,
                64146, 12180, 50464, 34574, 25638, 59428, 44739, 45407, 55871, 17483, 47212, 23559,
                31276, 12088, 24447, 49736, 37119, 178, 37733, 13581, 44009, 42689, 26041, 61992,
                24926, 60496, 5190, 15508, 36716, 35107, 42640, 63819, 3139, 63830, 38695, 29625,
                1495, 4701, 12714, 26079, 14941, 50193, 48948, 8626, 2927, 60193, 5945, 9252,
                49455, 4491, 8887, 50812, 50950, 42731, 54203, 11022, 65374, 47568, 22996, 58943,
                50798, 47748, 44712, 61317, 14239, 14982, 25532, 15777, 18016, 46939, 36344, 41507,
                36395, 18903, 52701, 53037, 42966, 58023, 23187, 26511, 55852, 36291, 54467, 52751,
                65345, 23386, 26948, 837, 13627, 44343, 63452, 26625, 16973, 10977, 23075, 39897,
                53958, 35031, 51629, 24041, 25322, 65323, 62018, 31668, 51181, 17327, 50232, 10722,
                29459, 51347, 4304, 16115, 16914, 34935, 7618, 61680, 55410, 34603, 61463, 30787,
                15002, 38827, 47707, 22085, 21440, 64953, 64680, 4762, 65362, 13508, 63308, 38718,
                33205, 47217, 55917, 21394, 40123, 51619, 13265, 1655, 39793, 32247, 46747, 61114,
                48189, 2827, 35637, 39573, 14265, 26559, 55485, 6884, 28471, 22006, 5827, 56990,
                50066, 19927, 21504, 28651, 22878, 51866, 29949, 13774, 58907, 7674, 41774, 10103,
                7828, 33439, 33884, 52414, 1987, 36590, 15359, 21499, 51277, 17036, 51875, 39252,
                32361, 6432, 61861, 51531, 6703, 20282, 44149, 27813, 59030, 23429, 9187, 52354,
                36805, 60491, 51507, 2868, 60113, 29276, 42840, 12913, 22033, 33483, 27810, 48477,
                62416, 20777, 36435, 36355, 31295, 4141, 54671, 1240, 38977, 29878, 26934, 9969,
                12291, 19161, 4876, 9705,
            ]),
            c: 141,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 2,
                b: 7841558952321562465,
                c: 3857359829,
            },
            FixedTestStruct {
                a: 156,
                b: 694470498189668020,
                c: 2697873136,
            },
            FixedTestStruct {
                a: 190,
                b: 7482312537342053811,
                c: 4045907139,
            },
            FixedTestStruct {
                a: 250,
                b: 4865241528780669066,
                c: 2811081156,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 13120,
                b: List::<u16, 1024>::from_iter([
                    55487, 20414, 48377, 37529, 60816, 59161, 51738, 62436, 16499, 36346, 61626,
                    11312, 30079, 3908, 32685, 29800, 12319, 53079, 4783, 12951, 9381, 26404,
                    46253, 7097, 13892, 58201, 29290, 20151, 13171, 5943, 48808, 7863, 27595, 6052,
                    15836, 25578, 64201, 49565, 41764, 64021, 13416, 35879, 37380, 4152, 28870,
                    13809, 36608, 43312, 45826, 38751, 30035, 20209, 1513, 15368, 52, 53582, 1634,
                    65265, 23319, 61552, 44351, 64529, 7629, 8381, 55960, 17379, 33327, 8448,
                    58496, 55537, 50325, 59683, 14943, 30774, 13494, 24729, 2253, 62366, 11658,
                    28156, 42344, 36493, 30327, 9105, 45217, 56937, 46142, 27857, 22758, 2149,
                    46376, 37326, 36776, 55256, 9566, 19126, 65431, 180, 32920, 39282, 31627, 1234,
                    14888, 32282, 23998, 31426, 33643, 61080, 24568, 14367, 64932, 45654, 5, 26562,
                    8380, 38796, 31705, 4012, 28955, 64850, 39336, 48006, 63871, 55211, 20911,
                    7738, 52893, 21033, 11005, 48726, 28838, 62972, 12894, 987, 37916, 27690,
                    23552, 28446, 50146, 13232, 55186, 37230, 37444, 23573, 18586, 48966, 36859,
                    10111, 63302, 4883, 58074, 8836, 50497, 60085, 37125, 58548, 43025, 44626,
                    21106, 64120, 20408, 16007, 60461, 24878, 19496, 10742, 63469, 19153, 49807,
                    64162, 6240, 40614, 14836, 37095, 51531, 28732, 38254, 34111, 4801, 58014,
                    59475, 64322, 7434, 10306, 52732, 29774, 36313, 36946, 42500, 53889, 63589,
                    14154, 20354, 50076, 44269, 22016, 61591, 35445, 60025, 26280, 14817, 33670,
                    18803, 33951, 31132, 55781, 36044, 60000, 30597, 43379, 44867, 3720, 46920,
                    40112, 42926, 25431, 32604, 62818, 58111, 24570, 26096, 61012, 15505, 43951,
                    25519, 23411, 7418, 43737, 48034, 61324, 19722, 9646, 12812, 10140, 13080,
                    18517, 63701, 29981, 47551, 18921, 50264, 38966, 56666, 3422, 50582, 46737,
                    26071, 48063, 61399, 27778, 31715, 44789, 22740, 17824, 36595, 44829, 41886,
                    26313, 34706, 36220, 32710, 55364, 60115, 10437, 7211, 29547, 14610, 24825,
                    43007, 21894, 48846, 40561, 37469, 54908, 46762, 59989, 4442, 28636, 51371,
                    45360, 24808, 29620, 40473, 18907, 6612, 9928, 39344, 9616, 15770, 57010,
                    14238, 34091, 23123, 9022, 62424, 1565, 34601, 28936, 64277, 43487, 27144,
                    35399, 18155, 53100, 34713, 39842, 28753, 11949, 48775, 35585, 10151, 42054,
                    15682, 28799, 40731, 42710, 34852, 21278, 35020, 1417, 3560, 63512, 6320,
                    52618, 18648, 34719, 7477, 21595, 62500, 62043, 20086, 36801, 40530, 42115,
                    28552, 56828, 35653, 40600, 60498, 26134, 32103, 6484, 35279, 9109, 34600,
                    30291, 47320, 45590, 18939, 53431, 20916, 16399, 8768, 24243, 18736, 11885,
                    48902, 49270, 62088, 52641, 28567, 29173, 46295, 21756, 23071, 42775, 38423,
                    19547, 54813, 195, 4369, 51618, 7740, 35924, 14277, 25893, 62404, 52613, 18656,
                    65439, 4429, 48610, 20695, 973, 50910, 37798, 24494, 60853, 21339, 11997,
                    59336, 60159, 32938, 61256, 17650, 13239, 19863, 52072, 36424, 17566, 45213,
                    41180, 15657, 21407, 29689, 38001, 20271, 45516, 41189, 35126, 20451, 17166,
                    54269, 19783, 37825, 33414, 46326, 18798, 32797, 26179, 16184, 8377, 47574,
                    24652, 22196, 10970, 413, 23454, 10801, 61585, 25724, 26688, 47203, 58044,
                    26066, 17483, 51713, 43792, 32016, 4633, 26837, 59405, 53529, 20699, 20321,
                    44187, 51404, 2085, 597, 24249, 38146, 48587, 42722, 6065, 51702, 43347, 38180,
                    17008, 60621, 9793, 31717, 51615, 19528, 8683, 14400, 16783, 20228, 33069,
                    24397, 38745, 19647, 35035, 50954, 37156, 47476, 41210, 3413, 21037, 27554,
                    14889, 1532, 35033, 62444, 36799, 2783, 838, 6099, 46651, 62123, 34504, 23406,
                    54380, 13583, 33071, 14865, 18419, 11299, 26802, 17840, 17038, 46241, 43872,
                    31433, 7732, 2345, 42567, 41807, 6265, 57057, 6051, 28148, 25652, 36473, 38887,
                    1510, 28090, 52193, 44188, 35510, 51786, 51768, 65142, 61963, 14007, 1828,
                    27792, 57811, 34088, 34844, 52454, 57232, 4213, 45150, 51313, 12770, 8662,
                    4778, 23208, 45466, 38227, 51430, 43235, 7226, 9949, 37142, 44588, 5091, 56674,
                    50673, 101, 16161, 732, 13076, 31633, 61776, 22567, 28031, 56097, 16951, 39777,
                    57198, 38708, 9473, 14324, 22435, 17820, 9881, 53952, 30773, 51940, 49608,
                    8713, 1177, 26981, 49782, 61447, 63171, 45923, 34133, 56412, 1793, 61104,
                    19880, 61448, 56653, 41307, 2792, 29971, 23997, 60802, 51355, 51703, 55428,
                    36714, 4512, 18965, 6538, 12623, 30896, 49689, 15962, 47357, 46504, 47876,
                    5527, 58170, 28811, 26318, 45422, 63328, 58721, 56469, 63666, 38916, 32398,
                    45318, 13324, 36821, 60578, 19520, 57030, 25331, 62060, 60314, 2751, 55842,
                    11443, 16102, 13636, 22043, 53734, 53694, 14873, 11874, 59020, 47559, 57789,
                    9133, 43404, 34484, 55130, 56303, 23712, 52322, 64794, 51147, 27246, 44364,
                    40162, 38216, 51182, 26272, 52226, 64754, 49870, 35234, 48217, 34623, 38284,
                    26758, 11559, 53855, 19915, 25582, 34576, 57609, 22166, 28529, 8406, 36437,
                    22579, 31231, 17741, 21566, 33381, 45392, 59941, 47572, 9084, 47960, 16268,
                    54092, 48547, 48173, 47050, 58826, 57834, 60390, 21539, 30384, 27423, 28631,
                    17538, 1919, 11678, 40176, 12221, 57455, 3415, 64976, 7784, 13142, 5135, 10363,
                    35939, 55256, 36084, 32458, 56916, 47686, 13126, 35937, 13981, 48239, 39386,
                    17994, 12356, 32424, 41451, 40186, 47130, 1633, 12743, 31677, 2348, 27612,
                    51827, 33413, 63356, 36873, 50163, 59464, 26570, 13655, 58323, 8184, 65138,
                    23863, 51077, 59809, 56034, 28676, 24945, 49436, 53241, 44969, 29407, 18563,
                    39895, 6413, 39172, 31183, 22717, 38407, 14125, 16230, 4314, 56423, 65533,
                    53850, 7746, 40819, 13105, 6439, 58546, 33068, 35449, 55381, 60949, 12787,
                    44022, 22215, 26398, 26577, 1716, 38292, 16636, 51111, 17755, 49493, 13319,
                    12119, 47558, 14492, 23299, 29548, 36423, 44967, 18869, 32662, 47198, 58113,
                    1963, 22830, 19434, 10325, 26056, 9260, 29268, 62712, 51200, 16017, 41592,
                    2624, 39311, 1606, 40625, 54131, 14988, 12292, 51985, 43324, 37507, 9541,
                    36074, 52634, 44567, 28070, 39581, 38146, 14437, 50290, 40726, 59237, 36159,
                    42801, 52944, 44553, 61963, 15616, 54155, 57187, 3206, 57208, 63995, 42417,
                    41421, 15066, 21556, 39572, 3384, 50733, 49191, 54752, 54999, 14293, 48240,
                    8802, 48593, 31186, 63826, 53208, 23282, 14878, 41342, 49485, 42483, 49150,
                    53149, 35581, 9333, 4012, 39131, 16449, 37729, 33085, 57826, 40450, 51658,
                    11329, 11923, 47144, 62755, 7911, 33062, 22900, 5009, 50952, 19534, 3376, 6194,
                    11780, 1144, 38488, 1845, 26823, 22325, 37958, 2496, 64977, 7222, 48241, 30421,
                    14307, 62969, 1302, 26238, 4776, 46833, 50476, 38185, 50134, 56678, 11996,
                    27896, 16629, 4505, 52725, 11765, 36849, 31918, 28720, 35950, 63890, 58878,
                    44497, 5300, 51268, 4198, 684, 62950, 1547, 10981, 39085, 39614, 25165, 32453,
                    55547, 44661, 11817, 36840, 60803, 19879, 13658, 28470, 20998, 17194, 2865,
                    43762, 22654, 52015, 26238, 25520, 45790, 15056, 33898, 2334, 1000, 46533,
                    16232, 32456, 39076, 13816, 24479, 34018, 40077, 26717, 1616, 30018, 62745,
                    51080, 64661, 31437, 61329, 56305, 8017, 7852, 1116, 49128, 2608, 42887, 3825,
                    52467, 32047, 16697, 55063, 24078, 27588, 52664, 12973, 40564, 20274, 52527,
                    43345, 14030, 16870, 54646, 36576, 48234, 5826, 55013, 36907, 12870, 61223,
                    53567, 22395, 47737, 65446, 4073, 10489, 7907, 34836, 58056, 51491, 60814,
                    24937, 10756, 42219, 24107, 37621, 24232, 42496, 14847, 58538, 25681, 29941,
                    22502, 22979, 34881, 32187, 16254, 50572, 35610, 1393,
                ]),
                c: 178,
            },
            VarTestStruct {
                a: 48415,
                b: List::<u16, 1024>::from_iter([
                    27130, 3832, 25356, 54457, 15552, 12775, 56882, 49252, 64698, 5033, 18586,
                    33923, 36894, 52083, 11860, 3362, 16465, 36764, 47012, 15220, 32358, 947, 7971,
                    15456, 27763, 36543, 13811, 37594, 54761, 2363, 22764, 54391, 64781, 50408,
                    16759, 38786, 10291, 54478, 7690, 61409, 50842, 31783, 33973, 34851, 3146,
                    26729, 36068, 13234, 65246, 62603, 59467, 21162, 16544, 20322, 25031, 22790,
                    12246, 2951, 19790, 37501, 37220, 24165, 7378, 39493, 16270, 8348, 5770, 57364,
                    7865, 27077, 2557, 52374, 34498, 36642, 62252, 1884, 25071, 38098, 44332,
                    34823, 47301, 43519, 48796, 37815, 42924, 28444, 39202, 8087, 36073, 8703,
                    14534, 64305, 53457, 29141, 6537, 294, 55189, 61383, 11765, 11998, 3567, 1737,
                    24684, 169, 49141, 23410, 34481, 40491, 36983, 29196, 26295, 47744, 36336,
                    28684, 64967, 4406, 48422, 1675, 43516, 30238, 1670, 35241, 1543, 58139, 22033,
                    12138, 36107, 18875, 56198, 8796, 40617, 58996, 25208, 25255, 37993, 24515,
                    7204, 59780, 20815, 10031, 21314, 49948, 32631, 23055, 42546, 53627, 39514,
                    55372, 2441, 7809, 62982, 65532, 21494, 5155, 50622, 9372, 57134, 19934, 24239,
                    6328, 40351, 47426, 19361, 42924, 20650, 46081, 33070, 57884, 40873, 36835,
                    20886, 31848, 18752, 18589, 54545, 12648, 938, 30510, 9543, 20168, 59503,
                    48498, 42324, 31078, 11648, 30086, 11620, 17115, 64743, 60786, 47981, 18048,
                    3253, 62452, 52766, 52786, 41619, 9776, 28891, 1682, 54912, 59322, 28204,
                    15079, 15855, 5396, 49941, 16980, 35866, 35930, 8021, 22388, 40194, 21743,
                    27433, 32343, 54982, 13118, 45070, 36699, 34426, 53562, 47965, 49426, 8279,
                    16168, 5347, 61069, 52341, 32099, 63276, 31165, 51645, 3034, 39386, 11791,
                    22899, 22849, 33262, 22920, 48837, 51427, 42360, 30638, 19984, 60587, 19317,
                    49654, 59834, 62933, 11291, 37749, 62099, 62438, 19002, 4806, 44298, 32119,
                    13632, 33145, 3633, 19413, 60254, 28564, 34894, 20214, 53435, 47842, 50325,
                    31787, 28932, 27805, 24174, 31376, 37456, 36981, 13874, 26630, 9779, 12253,
                    24259, 60754, 27154, 62609, 64757, 3358, 47415, 64565, 19723, 53161, 26018,
                    19433, 18927, 33639, 19459, 32975, 35798, 4395, 25466, 35857, 41950, 51538,
                    15204, 63521, 64953, 26296, 63100, 10863, 14419, 13810, 28796, 17242, 11867,
                    13365, 64098, 18375, 56141, 53959, 27113, 11270, 31369, 16624, 27887, 11158,
                    6090, 32538, 9008, 63623, 47698, 57220, 48572, 49944, 34212, 44515, 65488,
                    6930, 9913, 26082, 47483, 62107, 41080, 35555, 49322, 3590, 26604, 18977,
                    20589, 5109, 12623, 53920, 62230, 54246, 30109, 60346, 32173, 6948, 47735,
                    6177, 61868, 2132, 11420, 57491, 58672, 17562, 18772, 25998, 55661, 54932,
                    38254, 21283, 17684, 9670, 22975, 61702, 52559, 11041, 31904, 25860, 36730,
                    35425, 21435, 57496, 54384, 21645, 208, 51532, 10794, 24790, 10676, 51150,
                    4192, 25401, 12435, 64429, 4092, 27883, 28390, 33032, 4668, 7279, 56920, 5785,
                    24906, 17070, 18396, 49464, 49600, 50923, 10600, 33756, 38149, 21778, 32591,
                    52915, 22860, 20451, 46082, 20516, 42458, 2357, 38327, 50404, 27314, 63264,
                    57870, 57469, 30302, 28872, 26097, 3694, 8998, 63552, 56273, 55784, 34375, 691,
                    11573, 10144, 46115, 24406, 47019, 37406, 37440, 29021, 13206, 62481, 32155,
                    18048, 41130, 36245, 21864, 18218, 58215, 28254, 33122, 26440, 58617, 45731,
                    19045, 44940, 52067, 2357, 11643, 29037, 1171, 24019, 53083, 42789, 63987,
                    3756, 404, 22023, 33142, 17452, 9656, 42368, 24179, 56662, 45608, 26502, 48845,
                    115, 19921, 44621, 5600, 9830, 49016, 33291, 8514, 52405, 2018, 27029, 36321,
                    14717, 52609, 55786, 57442, 41050, 56066, 62599, 47814, 13674, 27014, 26062,
                    15795, 21844, 50474, 31425, 5718, 18600, 29578, 27543, 56480, 2084, 25609,
                    3346, 11323, 64892, 33651, 48503, 44096, 63310, 7971, 53178, 25402, 8941,
                    60258, 42846, 57452, 34495, 33959, 57140, 45959, 39073, 42359, 52995, 8811,
                    49473, 59595, 15806, 34387, 38872, 23551, 11109, 37029, 54649, 7910, 5350,
                    40225, 52062, 49557, 59641, 35104, 1590, 12506, 1374, 17264, 7760, 7191, 10454,
                    58614, 11093, 33355, 17137, 25479, 52989, 48616, 7044, 19832, 29979, 1958,
                    19366, 54926, 27182, 12829, 57431, 58346, 4477, 23798, 37981, 45139, 58204,
                    28798, 21503, 33832, 5437, 1180, 16715, 47904, 62541, 60161, 55616, 14525,
                    41270, 1024, 53409, 13231, 50614, 48034, 59952, 57965, 16307, 22690, 3291,
                    64512, 55125, 26446, 36308, 35663, 56226, 5418, 39852, 15852, 5128, 5356, 5647,
                    9012, 9569, 41602, 21914, 46837, 23047, 39658, 3843, 7508, 64995, 47928, 5266,
                    42361, 53158, 57356, 58714, 41365, 23696, 22956, 57755, 4786, 2340, 51870,
                    13297, 26497, 32240, 48833, 51415, 61197, 31947, 37909, 21642, 47429, 17622,
                    63162, 8840, 53401, 39773, 24112, 42047, 52537, 10444, 16449, 64593, 62703,
                    49366, 26563, 14770, 39879, 28290, 35719, 57668, 52367, 56191, 8922, 51542,
                    2708, 29891, 60823, 12846, 5432, 57932, 40927, 2361, 26263, 22626, 13192,
                    49418, 48717, 11532, 29796, 44526, 59836, 63910, 4689, 1505, 15054, 13338,
                    47019, 30664, 31988, 18955, 39506, 5087, 63233, 33926, 57646, 31533, 36782,
                    34028, 20146, 64464, 62254, 54304, 35579, 39579, 57572, 20024, 37107, 64157,
                    30133, 14295, 45761, 34388, 57113, 10521, 46045, 14654, 46585, 63613, 12473,
                    10419, 40606, 61218, 61470, 63120, 24372, 46249, 61875, 17061, 35381, 40624,
                    32980, 59834, 44946, 14848, 19058, 59011, 4945, 28552, 57500, 33800, 32371,
                    53874, 62530, 37510, 49164, 2190, 57318, 32510, 48519, 19125, 35991, 37519,
                    54749, 18777, 63646, 58422, 9190, 5990, 33319, 36453, 24008, 61028, 48651,
                    13421, 61048, 30274, 39542, 9980, 41775, 54104, 43876, 7626, 11925, 2836, 8117,
                    34713, 60946, 20986, 33832, 15720, 15270, 58244, 33060, 46134, 33320, 47969,
                    2690, 2479, 30235, 37560, 43812, 25814, 55962, 42326, 48411, 12860, 43030,
                    24047, 32035, 47386, 16188, 15323, 17579, 54580, 45541, 12172, 56210, 40972,
                    48365, 2913, 64322, 44268, 63899, 45091, 13020, 21535, 44618, 16196, 60860,
                    18780, 30909, 37726, 23854, 9196, 18403, 46833, 51176, 57974, 24116, 1815,
                    25984, 57692, 6591, 59680, 11356, 52518, 10222, 21414, 62589, 27083, 55445,
                    65268, 49282, 32584, 52143, 47818, 57706, 33115, 35497, 3728, 64349, 34303,
                    61415, 44515, 19738, 36960, 13078, 9560, 25024, 37541, 32625, 41533, 43929,
                    16782, 6315, 10022, 34116, 17224, 47095, 43216, 23780, 37087, 44743, 59211,
                    48291, 52677, 16326, 10432, 47573, 33551, 36363, 6217, 22373, 6482, 5739,
                    37867, 6330, 50427, 35477, 53711, 38864, 34681, 62823, 7141, 47001, 34490,
                    60680, 64803, 23574, 16860, 24014, 47457, 37738, 9398, 22680, 1112, 36095,
                    57678, 13673, 30265, 956, 26267, 45095, 3738, 30444, 9121, 39042, 15809, 52989,
                    30638, 27954, 19823, 15864, 4720, 43622, 4361, 16789, 43755, 6382, 34963,
                    63158, 41522, 4943, 57944, 1045, 14950, 19627, 1426, 25140, 15415, 63297,
                    16395, 34702, 19603, 36802, 9949, 36749, 41228, 23609, 44648, 31472, 56689,
                    38769, 42373, 28243, 21125, 55941, 17313, 6664, 17972, 46653, 42144, 61639,
                    19451, 32778, 47092, 15325, 25443, 9602, 39685, 22793, 36698, 52024, 64103,
                    20444, 5585, 2219, 37095, 42077, 3375, 11188, 27240, 57631, 23837, 34780,
                    20844, 63314, 14055, 6938, 13815, 49308, 61189, 17189, 17835, 30630, 2906,
                    44540, 22967, 37050, 11736, 42100, 13920, 63261, 51263, 55799, 54238, 54753,
                    37249, 34854, 38661, 38555, 12747, 13275, 52616, 16789, 52568,
                ]),
                c: 131,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_lengthy_7/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("79cd0ec624c402f43dad6d2c2e9c7699ff6c9f59e30455409194db3c2a48ade5");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_random_2() {
    let value = FixedTestStruct {
        a: 73,
        b: 17290263866691938161,
        c: 3311333766,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_random_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("925af6af4968ef66f299362d6b40cf4164b3e27fbb7e085445f0c9b827e74ccc");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_lengthy_0() {
    let value = ComplexTestStruct {
        a: 34044,
        b: List::<u16, 128>::from_iter([
            48874, 34700, 53776, 29805, 17569, 35418, 43707, 15489, 5164, 33511, 1254, 54569,
            16520, 32997, 29838, 23006, 40826, 60676, 46896, 6267, 31061, 14530, 56395, 56663,
            2084, 56824, 62602, 58694, 51680, 18415, 34766, 3506, 23098, 54494, 27270, 42848,
            27840, 1235, 57458, 18698, 42777, 56323, 14515, 8153, 4254, 57377, 27167, 35643, 40944,
            52977, 7846, 1253, 39539, 20098, 46499, 35303, 48573, 40247, 25159, 20692, 43641,
            17960, 58202, 42582, 9646, 37256, 65084, 26088, 52645, 62272, 31932, 14050, 38418,
            9204, 46698, 61903, 13828, 53723, 59474, 56151, 15229, 53335, 60044, 47156, 25870,
            45301, 25326, 13946, 8490, 38033, 19445, 6806, 6972, 58745, 19550, 6545, 61811, 58973,
            14877, 31691, 19354, 29588, 24023, 26217, 56464, 21662, 16898, 9753, 50257, 14051,
            2119, 53084, 41811, 44751, 53566, 38834, 5628, 58306, 28488, 51782, 29900, 12554,
            15448, 16999, 13292, 59987, 32816, 8584,
        ]),
        c: 250,
        d: List::<u8, 256>::from_iter([
            35, 210, 33, 112, 187, 147, 48, 91, 156, 105, 238, 219, 117, 100, 200, 235, 191, 6,
            115, 210, 221, 78, 181, 61, 189, 5, 165, 235, 210, 230, 252, 143, 236, 219, 212, 17,
            117, 56, 198, 82, 187, 155, 134, 148, 17, 109, 251, 103, 184, 201, 98, 14, 223, 252,
            205, 86, 71, 200, 122, 163, 99, 29, 108, 156, 165, 212, 118, 240, 187, 123, 0, 252,
            146, 235, 33, 59, 26, 138, 135, 215, 215, 0, 164, 189, 147, 15, 210, 10, 99, 77, 29,
            73, 125, 72, 225, 185, 56, 39, 231, 199, 165, 38, 134, 44, 152, 209, 170, 38, 156, 226,
            99, 143, 67, 241, 234, 70, 28, 229, 255, 105, 152, 137, 10, 151, 20, 225, 211, 181, 23,
            47, 23, 223, 20, 85, 99, 150, 50, 255, 248, 227, 190, 249, 164, 208, 151, 104, 134,
            163, 78, 96, 56, 37, 76, 118, 61, 170, 49, 69, 175, 33, 0, 99, 208, 112, 79, 45, 200,
            159, 49, 240, 101, 156, 251, 94, 169, 201, 18, 241, 0, 170, 173, 14, 84, 100, 186, 168,
            158, 116, 122, 223, 112, 12, 111, 83, 99, 63, 13, 182, 139, 40, 9, 0, 164, 191, 156,
            176, 36, 117, 85, 98, 214, 117, 38, 12, 100, 37, 49, 208, 235, 209, 133, 159, 146, 234,
            207, 245, 223, 102, 176, 43, 63, 201, 34, 172, 111, 88, 177, 209, 34, 138, 145, 13,
            222, 130, 253, 186, 49, 87, 212, 156, 231, 136, 186, 199, 171, 140,
        ]),
        e: VarTestStruct {
            a: 58150,
            b: List::<u16, 1024>::from_iter([
                28375, 58221, 41145, 32357, 1664, 57869, 13675, 35989, 49729, 26286, 64527, 44083,
                50267, 27448, 34519, 3283, 60852, 63342, 40004, 35369, 30566, 21773, 18301, 59649,
                7569, 50344, 46676, 17930, 10745, 52690, 57680, 1384, 10842, 54891, 65494, 16900,
                49987, 44177, 25269, 16949, 60887, 3941, 10023, 22469, 61976, 63026, 44690, 15845,
                8017, 59159, 1637, 47743, 13948, 32319, 29050, 50525, 13954, 19511, 53874, 59934,
                60668, 27052, 3576, 37153, 5832, 20342, 31511, 29631, 13707, 65518, 36833, 45582,
                20628, 31310, 60814, 19798, 30013, 58186, 44674, 45819, 62235, 9803, 15318, 36806,
                29814, 8759, 31328, 12085, 59511, 27639, 38322, 36305, 35942, 18714, 53126, 15704,
                5161, 73, 28208, 5106, 40668, 55453, 13761, 18509, 27411, 40681, 44371, 11459,
                43334, 43283, 49557, 34276, 34263, 18122, 24981, 60351, 29562, 23301, 28407, 38218,
                62851, 47538, 37942, 12176, 52646, 18213, 980, 18458, 21438, 21869, 21069, 46735,
                47700, 10282, 5030, 34532, 31856, 21106, 56536, 56941, 15490, 5424, 48271, 22437,
                17636, 56304, 21694, 13921, 10890, 30935, 65255, 15202, 13200, 55152, 49984, 64350,
                64190, 55396, 30081, 40652, 28707, 36318, 13352, 48148, 23019, 19405, 3066, 47303,
                52657, 29852, 49627, 41773, 4718, 598, 28502, 60987, 43692, 9108, 43528, 48462,
                26998, 55727, 15543, 25347, 29289, 14577, 1670, 49577, 19860, 45573, 54837, 17472,
                18756, 44889, 14991, 1515, 32803, 48145, 21595, 19652, 4710, 23304, 39417, 7918,
                34936, 41671, 35693, 14717, 23279, 23870, 8924, 36944, 4427, 752, 32567, 10910,
                19039, 55410, 7733, 8427, 13830, 48607, 31085, 23343, 23847, 18518, 8019, 19893,
                58818, 13052, 35223, 10088, 57577, 14274, 5466, 61505, 14397, 20959, 13589, 60803,
                44786, 34183, 29388, 18951, 12203, 52757, 45107, 20924, 41979, 28307, 34069, 25333,
                27807, 32264, 43868, 17788, 29153, 16431, 48032, 17888, 41411, 56308, 2, 6695,
                10935, 48781, 43941, 62390, 22558, 28772, 12397, 50375, 64923, 56284, 44290, 4288,
                33833, 16440, 18649, 54317, 59248, 51589, 54749, 33695, 1348, 10750, 58660, 55582,
                43318, 842, 45, 43800, 22637, 18496, 23078, 61830, 8797, 36543, 51813, 19150,
                51513, 51109, 40101, 5082, 43947, 30362, 53914, 2190, 12651, 8587, 44746, 52970,
                64474, 61806, 5650, 6620, 63698, 5893, 22999, 9332, 56506, 22347, 28741, 54123,
                23263, 42707, 63813, 15870, 56784, 150, 11640, 4029, 7484, 790, 37465, 12951, 1233,
                56496, 48523, 10045, 28780, 37987, 63093, 23471, 30390, 34022, 9484, 58517, 44462,
                19112, 28290, 64440, 18120, 40954, 62676, 7008, 13962, 54984, 17172, 32919, 61142,
                41814, 12788, 28297, 3791, 45471, 30443, 22098, 12566, 28470, 21197, 22694, 7963,
                7772, 41589, 59990, 56795, 54740, 7022, 56014, 18619, 36740, 4500, 34963, 53211,
                17261, 4145, 37154, 19986, 43903, 26165, 29420, 64201, 15729, 15956, 42823, 1475,
                7137, 32108, 26635, 41910, 65517, 54285, 55628, 24778, 60958, 27893, 52969, 22786,
                16070, 3097, 9016, 18905, 6510, 20739, 30262, 12217, 10171, 10699, 15860, 21922,
                62626, 2849, 26393, 13509, 44374, 22478, 16598, 2442, 35425, 34232, 64801, 13569,
                33877, 63493, 23856, 12910, 56640, 24645, 30277, 21555, 40677, 18783, 44023, 20131,
                7527, 20375, 63956, 46726, 20608, 17139, 19476, 3477, 64523, 52059, 19526, 17394,
                57143, 31792, 62867, 16734, 56946, 53330, 17317, 24629, 41244, 30946, 37039, 61422,
                55935, 50574, 1049, 36279, 59209, 53991, 20968, 5286, 6720, 38891, 6823, 888,
                10192, 27267, 53894, 31583, 52868, 41408, 47190, 38338, 18671, 15046, 36256, 40596,
                22827, 22250, 405, 29253, 10027, 2155, 54481, 14021, 30918, 19853, 2571, 24299,
                24057, 34154, 4806, 17219, 6716, 41710, 41292, 36490, 59387, 387, 13282, 40783,
                32502, 51885, 10715, 47061, 60087, 60490, 60576, 33242, 4772, 7260, 48628, 62850,
                45515, 2030, 22255, 51734, 32005, 8489, 40064, 57951, 2720, 48489, 44505, 9257,
                36382, 12953, 56376, 63298, 64278, 2769, 16330, 18864, 44393, 52507, 3427, 20562,
                65432, 14733, 4647, 53458, 64805, 55385, 40424, 53899, 7460, 25501, 20486, 50181,
                20061, 30783, 3153, 37987, 22288, 61066, 29808, 15995, 10585, 33663, 34543, 26007,
                23913, 62267, 49703, 23390, 55425, 19485, 17121, 44531, 4094, 32941, 17454, 32358,
                22177, 27919, 27215, 26345, 16975, 36517, 61898, 40440, 32515, 33802, 16632, 5226,
                25817, 63632, 41165, 40082, 28264, 44057, 60594, 42564, 41906, 28205, 35183, 10188,
                59644, 6293, 14679, 51165, 58128, 46776, 33987, 45399, 46177, 22498, 41427, 40014,
                49718, 59135, 24675, 26921, 4328, 56179, 49374, 50808, 26062, 46246, 16649, 60154,
                12596, 26360, 13768, 27301, 50349, 26066, 64172, 47610, 55514, 8764, 62015, 63086,
                27632, 41705, 63582, 1288, 63506, 5810, 65503, 26449, 16293, 3129, 15541, 39735,
                41940, 12309, 41197, 6947, 7351, 27575, 42095, 7418, 21122, 36041, 53537, 16988,
                25978, 41817, 51005, 8209, 60786, 18328, 59131, 18865, 36696, 10982, 35201, 38825,
                25336, 2358, 40828, 55543, 43385, 5054, 50406, 16618, 55789, 19667, 25421, 28399,
                2524, 45630, 14183, 5632, 52200, 45566, 26257, 23502, 49474, 49330, 50417, 25191,
                51210, 64374, 34010, 65406, 31787, 33873, 62361, 52923, 30090, 38395, 61522, 6542,
                1687, 36154, 12044, 26590, 54522, 27254, 20341, 57812, 15919, 64081, 11500, 37268,
                56753, 58201, 61164, 32780, 44472, 26289, 22851, 60136, 1476, 30248, 35190, 20989,
                24663, 34995, 4432, 44128, 6635, 46005, 7393, 39515, 2871, 29986, 29749, 50079,
                36948, 34487, 59993, 12757, 57152, 20192, 5776, 23616, 51020, 42344, 16934, 25068,
                33204, 56066, 57846, 16551, 11423, 46229, 49283, 10710, 834, 53793, 26481, 7233,
                15416, 47358, 40005, 43889, 52539, 8561, 60718, 34482, 37970, 48864, 36847, 34941,
                6042, 734, 13559, 65307, 24069, 56211, 63235, 8503, 36787, 58113, 62242, 55660,
                30944, 42380, 22261, 44119, 7916, 9903, 13525, 14513, 2720, 42721, 3513, 63495,
                24992, 33404, 37099, 31517, 47922, 28095, 12195, 56497, 60157, 59855, 55384, 28603,
                31811, 13162, 62639, 16688, 43366, 21377, 29904, 10793, 10645, 44144, 14836, 57708,
                59748, 9145, 25175, 64324, 4664, 151, 44634, 43351, 23400, 64555, 20191, 2702,
                30879, 48431, 5694, 14436, 4924, 36958, 15660, 5294, 61227, 28847, 21116, 4999,
                17946, 23859, 39921, 51429, 32450, 50129, 16084, 61858, 48685, 47145, 46495, 22796,
                20777, 32161, 52813, 57967, 21575, 60176, 47299, 60912, 38332, 28302, 54683, 52211,
                929, 5025, 41998, 36619, 17771, 16712, 37397, 7502, 24590, 32974, 63998, 5914,
                43280, 61120, 27778, 1558, 24839, 27343, 18623, 32180, 6320, 8764, 32613, 59302,
                54110, 63461, 41102, 60618, 23378, 9764, 60883, 61403, 62898, 29789, 10343, 2496,
                59042, 25765, 55100, 59014, 61844, 16541, 24325, 24263, 32675, 11017, 37568, 62902,
                3396, 43313, 58237, 38512, 65225, 29192, 57963, 63687, 14971, 43291, 31524, 29912,
                65468, 51212, 48846, 44133, 618, 13987, 28545, 20894, 9351, 46583, 2088, 3439,
                28894, 30305, 60376, 30077, 36410, 19646, 50906, 8164, 48525, 17178, 5325, 48213,
                54335, 24349, 9710, 22967, 44316, 5782, 26138, 11941, 36293, 50938, 49133, 5500,
                41539, 51770, 36701, 39085, 33344, 30340, 56475, 33883, 57074, 60492, 49022, 58091,
                4384, 5411, 33155, 56957, 36746, 23977, 15290, 816, 21135, 63003, 49998, 23391,
                29302, 14140, 7253, 46182, 5993, 63370, 2166, 23187, 35562, 27379, 58117, 30136,
                43811, 96, 3774,
            ]),
            c: 105,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 129,
                b: 4365870474151103771,
                c: 3073914233,
            },
            FixedTestStruct {
                a: 27,
                b: 34960855107345240,
                c: 2881905467,
            },
            FixedTestStruct {
                a: 79,
                b: 258237538561784111,
                c: 2295427765,
            },
            FixedTestStruct {
                a: 39,
                b: 9916630652249637025,
                c: 3021856725,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 60806,
                b: List::<u16, 1024>::from_iter([
                    1668, 1285, 26968, 24028, 22219, 30539, 10736, 61246, 7153, 7264, 28743, 6875,
                    29268, 16523, 37945, 14995, 3556, 58115, 48080, 59908, 41327, 61877, 13971,
                    49544, 58779, 24167, 54612, 82, 60472, 44148, 5394, 25388, 998, 55884, 13710,
                    41974, 34922, 2924, 14985, 17067, 62561, 52349, 16477, 36531, 63531, 9367,
                    31905, 51948, 32788, 62758, 61419, 22805, 42614, 48983, 58560, 59449, 51003,
                    4670, 42178, 64178, 5369, 18180, 15140, 549, 49920, 7530, 8022, 8947, 46321,
                    37341, 53968, 8911, 27877, 9943, 35137, 9290, 44775, 15822, 44224, 42118,
                    58108, 36231, 10577, 4135, 2437, 12142, 57741, 2268, 9837, 49160, 26515, 35533,
                    34160, 64548, 11263, 29064, 48228, 38086, 8588, 59072, 41763, 5208, 53429,
                    14621, 47154, 2569, 31875, 47557, 52821, 31784, 1946, 62841, 36032, 53266,
                    53801, 31104, 58821, 7174, 60251, 46169, 63218, 32666, 8864, 20514, 3986,
                    34139, 50246, 21116, 17179, 731, 16509, 55272, 7943, 61719, 38468, 11496,
                    65253, 52874, 50899, 41388, 29057, 742, 36343, 24386, 41533, 43775, 36046,
                    37843, 55988, 38113, 1587, 36260, 36878, 36843, 46937, 63616, 17059, 5390,
                    38257, 43741, 31937, 44500, 10816, 27723, 24291, 46673, 31976, 20609, 31489,
                    22768, 38325, 12938, 55098, 25582, 33399, 51057, 28773, 49973, 27929, 61877,
                    48909, 55460, 38078, 33637, 28262, 10253, 45124, 41303, 5191, 54384, 11636,
                    35019, 60946, 591, 1882, 54769, 7793, 9839, 22153, 64547, 26406, 11390, 9220,
                    31102, 35423, 36773, 49242, 53616, 44515, 31738, 52805, 51789, 37016, 44101,
                    31596, 9795, 42269, 41329, 26191, 19852, 60557, 29405, 65054, 36442, 61384,
                    35237, 12547, 24499, 18465, 13944, 5272, 58124, 41906, 644, 60885, 16610,
                    34880, 52306, 28769, 22097, 1457, 27566, 36881, 26592, 16397, 15267, 1034,
                    51047, 52158, 13318, 59844, 14688, 60401, 39963, 42033, 4434, 22973, 61077,
                    11951, 52365, 43727, 13466, 27458, 29107, 42761, 59059, 54721, 22221, 61870,
                    22864, 8887, 1565, 48990, 12611, 34921, 44810, 22195, 52793, 36328, 53594,
                    13354, 42007, 46393, 51832, 37991, 7350, 25568, 52345, 58688, 59357, 50782,
                    16992, 10979, 17782, 16450, 55108, 57901, 40375, 4264, 22711, 42150, 14133,
                    38578, 29015, 44963, 32151, 51011, 2195, 10097, 55320, 35593, 56303, 46012,
                    27149, 13758, 102, 21121, 54743, 33023, 38343, 49600, 58045, 32741, 28607,
                    2666, 35430, 10992, 48301, 3448, 34318, 56213, 17961, 2913, 6647, 2362, 55802,
                    39749, 20235, 25474, 9438, 58372, 16058, 42754, 28791, 38553, 71, 63676, 49440,
                    47340, 45635, 28594, 58453, 21208, 20377, 37902, 2621, 12658, 48051, 26147,
                    31523, 60608, 43958, 64715, 24964, 33880, 38269, 5741, 58705, 42328, 7373,
                    33981, 55179, 15633, 61034, 9914, 38072, 52422, 5886, 22928, 5931, 18446,
                    44184, 9407, 21727, 59593, 41280, 43583, 16852, 57002, 7826, 52051, 46323,
                    54959, 6369, 20124, 20878, 60719, 2803, 59032, 10702, 43579, 21831, 59945,
                    45717, 24824, 61062, 47908, 25705, 14592, 26398, 3367, 16535, 2075, 29064,
                    29014, 38633, 32085, 11656, 61801, 6831, 38036, 50263, 14750, 47729, 30713,
                    47861, 8310, 61704, 5295, 21698, 12498, 16772, 50690, 26423, 33779, 10876,
                    29148, 24465, 11881, 3076, 12074, 24399, 40037, 23445, 37884, 31257, 24467,
                    61992, 7684, 14961, 13050, 54908, 58700, 48298, 19180, 32297, 10199, 29353,
                    13775, 46175, 56844, 62225, 9208, 54164, 43702, 54019, 65416, 33331, 5793,
                    58631, 58400, 4524, 19354, 895, 39221, 62862, 16675, 32979, 26242, 62788,
                    17905, 27258, 61097, 23700, 50535, 42890, 60667, 41435, 40955, 9493, 36280,
                    3870, 20178, 28474, 7798, 47860, 15555, 61921, 56967, 2315, 15531, 21992,
                    63981, 58101, 9132, 30593, 62087, 22709, 25602, 48258, 4396, 47111, 55380,
                    19837, 46367, 5891, 6190, 6774, 39201, 50797, 50305, 52328, 9377, 37192, 10902,
                    51145, 45427, 33454, 1414, 6380, 9608, 63704, 64320, 16965, 44787, 61354,
                    32239, 3244, 11398, 48260, 11996, 39826, 13080, 16166, 1297, 61448, 51374,
                    50053, 61449, 56459, 38154, 8815, 9728, 45200, 888, 39305, 25442, 37424, 54709,
                    26324, 21821, 8227, 15865, 53769, 3235, 19030, 47307, 36025, 49593, 59768,
                    21070, 64337, 3642, 28508, 28658, 20690, 9930, 21692, 8151, 64405, 7190, 36306,
                    63891, 42031, 19592, 10094, 22981, 3980, 5805, 47915, 38509, 21061, 52968,
                    36624, 55391, 34296, 60677, 19728, 18118, 23372, 10724, 46879, 15772, 11525,
                    47097, 51930, 20033, 34527, 9939, 24210, 56454, 31174, 3990, 48130, 4998,
                    10791, 32986, 57706, 44128, 62626, 14091, 31654, 3005, 7308, 75, 35551, 61377,
                    14196, 61884, 57323, 8612, 57849, 25947, 44783, 13300, 44899, 7058, 64039,
                    6957, 22334, 35812, 243, 43358, 45718, 15771, 6243, 33619, 39268, 30156, 57491,
                    7536, 58356, 19193, 29025, 9804, 22770, 28239, 56104, 14830, 38346, 5732,
                    55885, 18705, 10299, 49320, 32207, 6092, 52296, 25920, 45714, 56861, 52086,
                    56633, 13108, 34860, 61085, 60645, 64823, 11514, 54765, 60115, 25518, 14790,
                    64103, 63143, 52637, 17316, 16641, 43714, 13720, 56354, 33677, 62462, 48744,
                    48565, 60516, 63618, 57892, 4332, 57403, 27425, 12202, 64302, 8753, 58368,
                    7993, 28185, 53814, 24689, 29917, 567, 25469, 37018, 53080, 7462, 48288, 20872,
                    669, 7416, 32145, 45540, 18274, 30247, 28450, 50316, 39103, 18406, 13409,
                    14623, 10269, 12479, 32652, 24845, 50403, 5469, 16926, 44523, 32913, 15066,
                    41282, 50229, 30811, 59217, 15779, 51522, 65290, 15079, 20765, 2805, 52174,
                    54509, 32779, 63164, 31337, 19558, 15719, 62818, 39116, 2044, 25155, 65366,
                    16392, 49378, 39853, 56155, 58167, 6938, 29798, 48201, 3561, 8580, 46938,
                    58688, 41813, 41373, 50473, 47465, 55634, 53596, 63348, 46884, 19395, 49791,
                    14750, 37129, 39382, 12060, 54313, 56428, 2369, 61755, 2574, 49412, 51540,
                    47304, 58640, 59537, 1169, 27771, 2631, 6077, 23448, 61208, 29025, 38974, 8951,
                    4553, 15720, 683, 64158, 11648, 3432, 6313, 19649, 3030, 53524, 58604, 23389,
                    9115, 14443, 53676, 64593, 63378, 10878, 43138, 8374, 8865, 17183, 59080,
                    30477, 42907, 30646, 10960, 49556, 62228, 60597, 62598, 4833, 44284, 19733,
                    11670, 40299, 19668, 16209, 43703, 15122, 34724, 45144, 49048, 39975, 6908,
                    60485, 18947, 35805, 30174, 30388, 25460, 48228, 13691, 340, 19681, 25228,
                    4020, 1913, 26867, 46450, 14852, 14485, 63692, 26457, 12697, 25538, 12984,
                    45712, 59549, 4717, 21, 7105, 30283, 20495, 58524, 63885, 1652, 15280, 54894,
                    46077, 46129, 8967, 11132, 58176, 1043, 59413, 2563, 56043, 46634, 36334,
                    17017, 63996, 1563, 12164, 13454, 58660, 8189, 28871, 32763, 1380, 60920, 7729,
                    45523, 21453, 35646, 64849, 57412, 61930, 6457, 63918, 40903, 29391, 45920,
                    63909, 53202, 31653, 6597, 36449, 50872, 17834, 16796, 37348, 45142, 59672,
                    10168, 53048, 50879, 7633, 49646, 32455, 24835, 32701, 30875, 24474, 59281,
                    33069, 53729, 22030, 59425, 17324, 52269, 2751, 23244, 31323, 15545, 30871,
                    26895, 64413, 57317, 8776, 19517, 21360, 35833, 7284, 14168, 8355, 49100,
                    22031, 7302, 35598, 53730, 65187, 265, 32312, 30216, 59751, 5657, 52341, 1986,
                    64785, 4745, 41132, 22262, 14629, 30998, 57032, 11955, 204, 963, 10315, 36272,
                    12862, 4223, 43658, 55565, 28146, 2067, 15527, 7660, 21725, 44167, 23399,
                    47310, 60642, 62286, 48685, 55178, 28134, 28969, 28238, 35621, 64728, 59882,
                    60998, 1341, 26206, 21975, 36226, 50508, 36824, 34108, 57115, 43592, 36989,
                    54318, 4303, 16337, 25397,
                ]),
                c: 250,
            },
            VarTestStruct {
                a: 4703,
                b: List::<u16, 1024>::from_iter([
                    60490, 40978, 209, 51204, 53280, 50414, 30138, 24087, 59631, 51584, 42330,
                    56509, 9742, 49650, 49661, 17545, 3768, 57673, 64119, 16467, 1405, 9188, 52282,
                    31454, 10481, 43745, 23159, 455, 30629, 46779, 37195, 64515, 48507, 21569,
                    63164, 22178, 25160, 55615, 58953, 64032, 46884, 44321, 46898, 40007, 23307,
                    59014, 51756, 55556, 47035, 11109, 40185, 25166, 360, 18578, 21013, 46790,
                    26323, 38999, 18398, 24586, 30656, 62072, 22121, 17306, 34272, 54705, 10091,
                    42169, 55410, 32954, 63924, 46034, 3688, 53743, 17323, 42095, 32162, 56544,
                    55372, 50066, 42067, 39275, 18742, 24392, 62402, 43088, 40064, 57833, 31915,
                    4788, 51474, 5125, 56858, 30995, 51220, 4635, 54295, 22024, 2410, 17277, 40471,
                    10850, 47018, 33138, 24634, 56609, 64138, 33513, 65221, 1475, 11581, 33291,
                    52827, 14842, 36786, 413, 56789, 27242, 36406, 48977, 19480, 34017, 37650,
                    26781, 23705, 58781, 40563, 39235, 3669, 1735, 11331, 37606, 341, 24431, 59216,
                    16678, 33435, 55808, 26587, 37401, 47677, 52901, 30185, 30474, 24197, 56382,
                    27520, 64534, 6217, 24747, 39579, 22361, 24609, 45973, 41899, 33423, 9851,
                    35335, 38077, 17659, 42245, 61695, 16966, 975, 25771, 30672, 62688, 4688, 4337,
                    27696, 16698, 20584, 23561, 41949, 62961, 31083, 5484, 24585, 46630, 20591,
                    29428, 49376, 61525, 2058, 28605, 44934, 46746, 29629, 4432, 10762, 36858,
                    11052, 46691, 34534, 43516, 12528, 17188, 51517, 53879, 91, 63825, 8548, 27727,
                    25033, 52048, 27049, 53775, 26931, 48368, 3694, 26944, 25074, 31645, 57893,
                    51760, 62849, 50965, 25259, 63728, 24635, 14461, 4747, 5098, 64014, 44939,
                    33071, 33667, 51587, 316, 11154, 38371, 28277, 2198, 30602, 60056, 1060, 63117,
                    25587, 49451, 12593, 50307, 47047, 31690, 62573, 21640, 44683, 12904, 50629,
                    59220, 1509, 20015, 1329, 46891, 60113, 8315, 47193, 27245, 36006, 49164,
                    13076, 28024, 44704, 47220, 45484, 43117, 57935, 52201, 34044, 34618, 62657,
                    2039, 8316, 8689, 33809, 605, 30319, 33136, 24333, 44340, 63793, 51139, 35441,
                    18989, 58357, 12292, 37349, 55621, 35609, 61923, 13040, 11238, 64003, 29958,
                    15317, 13557, 64734, 23166, 14571, 55999, 16757, 34296, 47644, 3592, 28872,
                    15527, 54071, 36682, 29430, 63168, 29353, 50771, 22590, 21892, 12824, 4607,
                    27890, 8934, 37182, 4511, 38290, 15551, 44701, 55376, 64915, 31748, 27345,
                    60915, 33077, 29827, 54165, 42813, 1341, 57154, 38491, 44894, 51749, 36587,
                    51596, 59598, 16607, 3845, 49198, 1852, 37703, 65353, 48713, 26762, 46096,
                    50884, 22704, 46199, 65043, 63378, 46908, 25564, 42607, 15858, 12754, 56603,
                    61745, 15553, 35034, 63276, 31791, 65395, 21347, 45707, 26564, 30310, 14743,
                    14492, 8813, 16977, 49600, 21695, 44719, 34695, 48261, 38075, 57735, 41105,
                    30282, 46159, 9765, 22408, 7107, 27543, 18502, 34307, 55784, 16761, 22621,
                    34191, 19700, 19368, 14950, 17453, 17140, 49113, 25739, 32139, 28585, 38046,
                    46465, 42298, 30326, 60944, 3766, 13253, 45551, 46286, 778, 15278, 62840,
                    16413, 43334, 23621, 30329, 16351, 63863, 65471, 41848, 27693, 52501, 381,
                    1961, 38324, 37177, 32655, 49475, 44716, 47872, 30975, 714, 38082, 9932, 52281,
                    28409, 50741, 9013, 53486, 29215, 23651, 16331, 31756, 54725, 45347, 45306,
                    11882, 27939, 49767, 6775, 22765, 4473, 34693, 42012, 12611, 6022, 5226, 27247,
                    60475, 13302, 16672, 14714, 5866, 7137, 53938, 21713, 41918, 33031, 43682,
                    9868, 19835, 28102, 49789, 46648, 50833, 55370, 52805, 4930, 62578, 36194,
                    63080, 28446, 60459, 46358, 14709, 48475, 34801, 60460, 25140, 5849, 15381,
                    45854, 49464, 47883, 54606, 61265, 35394, 21104, 44288, 29653, 51355, 64485,
                    41577, 64088, 12157, 44247, 37987, 60631, 45026, 56043, 57738, 53740, 64248,
                    40827, 4741, 22340, 48149, 21908, 6208, 25546, 19149, 29510, 12646, 4135,
                    24826, 34752, 52971, 28570, 42490, 17655, 52246, 51913, 12993, 4824, 53699,
                    54831, 52341, 20883, 23752, 45970, 38384, 18298, 22064, 24101, 15809, 47371,
                    2339, 27543, 42669, 17891, 37102, 61557, 50633, 40247, 52547, 34381, 2208,
                    53524, 19213, 20470, 44730, 8759, 28753, 23327, 34607, 14456, 33795, 6841,
                    17336, 12966, 61019, 13036, 17068, 28331, 39261, 48399, 57559, 53036, 992,
                    34028, 8717, 63795, 64418, 4505, 63092, 53117, 45450, 57757, 64439, 48767,
                    6590, 59669, 34135, 50266, 19885, 53242, 17166, 51610, 9779, 20099, 61671,
                    11075, 50010, 7220, 47242, 58393, 43750, 45451, 36995, 56295, 35198, 33946,
                    4330, 55691, 29840, 12311, 40295, 49004, 13974, 15384, 23419, 350, 33117,
                    45441, 17767, 14644, 45765, 28564, 39824, 2127, 21303, 23331, 12711, 8977,
                    59756, 15945, 41453, 9373, 22928, 37662, 18467, 10676, 61550, 24024, 30611,
                    62005, 57007, 540, 28744, 40875, 4946, 16426, 60823, 20246, 2928, 23405, 25189,
                    64912, 1082, 3115, 15851, 2225, 2314, 14103, 12187, 52834, 52362, 10004, 27539,
                    25822, 40600, 30575, 35071, 37377, 38414, 8378, 58813, 33550, 24525, 53239,
                    46773, 32786, 11546, 63813, 28985, 50703, 62879, 12700, 973, 17364, 37674,
                    58327, 34784, 58644, 46114, 11830, 12134, 54539, 39292, 8746, 34316, 58466,
                    24959, 33831, 58222, 48056, 65067, 22289, 3655, 42140, 24759, 13483, 11939,
                    59348, 50106, 40716, 58001, 17874, 64488, 23272, 32463, 61190, 32611, 135,
                    64098, 36230, 19512, 40214, 10564, 40270, 47116, 42582, 30689, 48110, 13578,
                    7589, 40462, 14977, 31906, 20888, 44859, 11506, 53487, 40520, 63676, 10855,
                    58667, 39088, 27601, 18752, 63110, 18475, 57289, 18431, 41390, 57620, 26085,
                    22771, 34478, 41657, 27633, 11528, 11079, 8986, 47042, 30394, 39677, 16167,
                    47431, 22038, 56228, 54625, 51123, 19798, 46514, 28488, 426, 62162, 55270,
                    60774, 4402, 17537, 58499, 15185, 1722, 11502, 61793, 54484, 23616, 15489,
                    36027, 14802, 2320, 25169, 56821, 52034, 35056, 6535, 58572, 56076, 4556,
                    42993, 22825, 49678, 35427, 59614, 18884, 49668, 60647, 47546, 39368, 21266,
                    36185, 62562, 16624, 4019, 36900, 25307, 58953, 52072, 29613, 61500, 8892,
                    59210, 53285, 9882, 38732, 54560, 56859, 56107, 31008, 4213, 41342, 26304,
                    26399, 26626, 17757, 28248, 13430, 44322, 46738, 18797, 38856, 14224, 44358,
                    45331, 3623, 58893, 415, 23780, 32265, 28315, 17639, 50164, 27847, 29681,
                    37722, 55632, 12536, 25247, 65212, 27540, 1290, 19543, 44473, 53494, 62504,
                    365, 57624, 64314, 36574, 54090, 22207, 24010, 52520, 11326, 4080, 25811,
                    14651, 40609, 36823, 10419, 16157, 28821, 42883, 13293, 26963, 4768, 50688,
                    55161, 30748, 58063, 26827, 12679, 61279, 63489, 41884, 6485, 44921, 26214,
                    24304, 40805, 26790, 17169, 9407, 37029, 21032, 61353, 58632, 7309, 10716,
                    16230, 43600, 1786, 8736, 26311, 57026, 36947, 49893, 24867, 41560, 53164,
                    48933, 64830, 56078, 54033, 7712, 33111, 58864, 18141, 4973, 55508, 56776,
                    9323, 21206, 19534, 25917, 9628, 23623, 12779, 33660, 6822, 61633, 17121,
                    22651, 27509, 14925, 9703, 20922, 44817, 41887, 44171, 14556, 37614, 22580,
                    29784, 43281, 9663, 22875, 41637, 29127, 25494, 57336, 29104, 14016, 13559,
                    9529, 59253, 15830, 50931, 7826, 53448, 13747, 667, 38859, 42451, 50476, 62419,
                    58977, 39636, 17707, 23892, 30212, 55819, 21968, 37482, 11569, 50438, 35431,
                    24406, 54713, 35326, 39657, 6009, 53892, 5453, 60537, 32164, 58056, 3581, 5671,
                    31963, 58017, 44667, 57071, 42403, 38396, 19810, 37025, 27965, 98, 17235, 6286,
                    29020, 62045, 35020, 44137, 47451, 3971, 43408, 896, 18089,
                ]),
                c: 174,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_lengthy_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("d1bb44d6f0a011c83488f0f87c801b8392a35a9e6b78218332de4e193b29dc48");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_random_5() {
    let value = FixedTestStruct {
        a: 79,
        b: 14098080771816090726,
        c: 2129688544,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_random_5/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("c44c5c18fc468fd2689febc405f521c41a5b5fd6958319e53b1d0f94c5aa238a");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_zero_8() {
    let value = ComplexTestStruct {
        a: 0,
        b: List::<u16, 128>::from_iter([
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        ]),
        c: 0,
        d: List::<u8, 256>::from_iter([0]),
        e: VarTestStruct {
            a: 0,
            b: List::<u16, 1024>::from_iter([
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            ]),
            c: 0,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 0,
                b: List::<u16, 1024>::from_iter([
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                ]),
                c: 0,
            },
            VarTestStruct {
                a: 0,
                b: List::<u16, 1024>::from_iter([
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                ]),
                c: 0,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_zero_8/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("44aa205a1ab79b3ef1674d4040b34d702efe212440c817248c48beaf73443a45");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_zero_9() {
    let value = SingleFieldTestStruct { a: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_zero_9/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("0000000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_zero_chaos_2() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([false, false, false]),
        b: Bitvector::<2>::from_iter([false, false]),
        c: Bitvector::<1>::from_iter([false]),
        d: Bitlist::<6>::from_iter([]),
        e: Bitvector::<8>::from_iter([false, false, false, false, false, false, false, false]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_zero_chaos_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("5b8c65840d6ad9823340ff0108e98f8efa055be1911fc7d7012c5de1064b4caf");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_random_8() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([true, true, true, true]),
        b: Bitvector::<2>::from_iter([false, false]),
        c: Bitvector::<1>::from_iter([false]),
        d: Bitlist::<6>::from_iter([false, false]),
        e: Bitvector::<8>::from_iter([false, false, true, false, true, true, false, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_random_8/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("de589adc2de052524b60cb01e01ed8a5cc1c24404877b152b1e9154f6393b5bd");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_max_5() {
    let value = SingleFieldTestStruct { a: 255 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_max_5/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("ff00000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_zero_6() {
    let value = ComplexTestStruct {
        a: 0,
        b: List::<u16, 128>::from_iter([
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        ]),
        c: 0,
        d: List::<u8, 256>::from_iter([0]),
        e: VarTestStruct {
            a: 0,
            b: List::<u16, 1024>::from_iter([
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            ]),
            c: 0,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 0,
                b: List::<u16, 1024>::from_iter([
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                ]),
                c: 0,
            },
            VarTestStruct {
                a: 0,
                b: List::<u16, 1024>::from_iter([
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0,
                ]),
                c: 0,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_zero_6/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("a1763935a5d9d806ec0c10b05513374b75fb112f3b82509c1f9326ced4b58b6f");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_zero_7() {
    let value = SingleFieldTestStruct { a: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_zero_7/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("0000000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_random_1() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([true, true, true]),
        b: Bitvector::<2>::from_iter([false, false]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([false]),
        e: Bitvector::<8>::from_iter([true, true, true, false, false, false, true, false]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_random_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("df0f6d27156f4692278048a9b03fed71e2265fb85a651d685197034ebbce876f");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_one_chaos_0() {
    let value = ComplexTestStruct {
        a: 16851,
        b: List::<u16, 128>::from_iter([43827]),
        c: 197,
        d: List::<u8, 256>::from_iter([24]),
        e: VarTestStruct {
            a: 2938,
            b: List::<u16, 1024>::from_iter([13314]),
            c: 230,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 251,
                b: 10114294449636136645,
                c: 3440022400,
            },
            FixedTestStruct {
                a: 92,
                b: 4270638512643996390,
                c: 2080063790,
            },
            FixedTestStruct {
                a: 181,
                b: 6361529668076857388,
                c: 3692475116,
            },
            FixedTestStruct {
                a: 58,
                b: 12444896282347205507,
                c: 36692008,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 45027,
                b: List::<u16, 1024>::from_iter([44189]),
                c: 188,
            },
            VarTestStruct {
                a: 19339,
                b: List::<u16, 1024>::from_iter([60067]),
                c: 62,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_one_chaos_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("6647355693570b0e372117d77096b3049a5ac71571d706fd486a4814b18c637a");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_max_2() {
    let value = SingleFieldTestStruct { a: 255 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_max_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("ff00000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_random_6() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([false, true, true, true, true]),
        b: Bitvector::<2>::from_iter([true, true]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([false, false, false, true, false, true]),
        e: Bitvector::<8>::from_iter([true, true, true, true, false, false, false, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_random_6/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("3e65520e875a5d0347f9cdf810c1d2c76b33f0606bbf136b9e4d5d17ff87ded9");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_zero_0() {
    let value = SingleFieldTestStruct { a: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_zero_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("0000000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_zero_1() {
    let value = ComplexTestStruct {
        a: 0,
        b: List::<u16, 128>::from_iter([
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0,
        ]),
        c: 0,
        d: List::<u8, 256>::from_iter([0]),
        e: VarTestStruct {
            a: 0,
            b: List::<u16, 1024>::from_iter([
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0,
            ]),
            c: 0,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 0,
                b: List::<u16, 1024>::from_iter([
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0,
                ]),
                c: 0,
            },
            VarTestStruct {
                a: 0,
                b: List::<u16, 1024>::from_iter([
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                ]),
                c: 0,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_zero_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("f701b968d59dc21a5e05a33ec5cfa5e46a4090d66d92adf6d3e2b244366b2e8f");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_max_4() {
    let value = ComplexTestStruct {
        a: 65535,
        b: List::<u16, 128>::from_iter([
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
        ]),
        c: 255,
        d: List::<u8, 256>::from_iter([255]),
        e: VarTestStruct {
            a: 65535,
            b: List::<u16, 1024>::from_iter([
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            ]),
            c: 255,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 65535,
                b: List::<u16, 1024>::from_iter([
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                ]),
                c: 255,
            },
            VarTestStruct {
                a: 65535,
                b: List::<u16, 1024>::from_iter([
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535,
                ]),
                c: 255,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_max_4/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("869070dd164bec9a6a980ba72829d21004a9df8268033a5f2dc1aa606a43158a");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_max_chaos_1() {
    let value = SingleFieldTestStruct { a: 255 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data("ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_max_chaos_1/serialized.ssz_snappy");
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("ff00000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_lengthy_chaos_0() {
    let value = ComplexTestStruct {
        a: 6800,
        b: List::<u16, 128>::from_iter([
            36829, 20943, 41561, 60705, 6836, 19276, 13404, 15270, 24787, 32752, 38430, 8083,
            34903, 14442, 11739, 63845, 58058, 22059, 39304, 25491, 5073, 6016, 23531, 28902,
            42251, 34597, 49664, 5043, 51205, 5299, 52893, 2709, 23188, 63532, 19881, 29182, 7813,
            44835, 60112, 13706, 3889, 8031, 36192, 28397, 21513, 26621, 24371, 20825, 36012,
            41472, 34720, 878, 49916, 55632, 7699, 57365, 55101, 55073, 8349, 54708, 5482, 50387,
            59119, 34469, 52095, 13939, 25469, 24090, 8092, 51886, 21020, 36989, 42388, 5825,
            12913, 54900, 37947, 6656, 61583, 29576, 58879, 23340, 32777, 58812, 6045, 62477,
            33289, 15339, 569, 22264, 26352, 26854, 41491, 30478, 48681, 17608, 47905, 10185,
            14841, 244, 42227, 14997, 52644, 1462, 4781, 4276, 5780, 27685, 58146, 40039, 16054,
            18824, 35159, 8918, 35585, 54400, 23883, 29802, 38038, 29470, 21839, 48288, 4225,
            57722, 17192, 10239, 10610, 34360,
        ]),
        c: 87,
        d: List::<u8, 256>::from_iter([
            147, 28, 238, 175, 199, 176, 239, 194, 18, 154, 240, 144, 93, 255, 16, 103, 173, 97,
            49, 254, 180, 43, 120, 14, 230, 175, 154, 167, 185, 103, 73, 237, 48, 127, 156, 94,
            119, 193, 74, 116, 126, 117, 235, 2, 216, 92, 188, 246, 13, 238, 90, 215, 183, 200, 96,
            72, 154, 138, 194, 197, 41, 224, 120, 190, 224, 38, 91, 43, 199, 217, 179, 149, 184,
            230, 32, 21, 15, 225, 41, 64, 58, 167, 34, 224, 203, 80, 140, 44, 107, 121, 231, 170,
            78, 101, 12, 43, 142, 176, 8, 239, 165, 77, 237, 197, 110, 100, 229, 128, 16, 183, 171,
            11, 148, 246, 171, 5, 77, 121, 20, 146, 164, 97, 113, 48, 148, 156, 23, 252, 158, 42,
            93, 76, 90, 161, 53, 160, 120, 181, 38, 25, 4, 162, 202, 162, 79, 231, 90, 13, 238,
            109, 51, 194, 175, 187, 106, 86, 117, 184, 195, 134, 191, 74, 139, 190, 157, 43, 68,
            22, 66, 65, 142, 201, 243, 100, 39, 225, 90, 90, 108, 126, 0, 137, 187, 99, 121, 136,
            26, 87, 147, 5, 185, 150, 178, 110, 231, 173, 179, 79, 234, 186, 132, 233, 253, 0, 33,
            60, 57, 252, 168, 223, 10, 217, 66, 215, 101, 54, 170, 0, 4, 176, 173, 67, 107, 222,
            33, 133, 115, 231, 115, 189, 31, 251, 32, 166, 105, 149, 207, 162, 205, 197, 186, 107,
            233, 136, 117, 129, 241, 61, 80, 86, 63, 27, 103, 13, 34, 7,
        ]),
        e: VarTestStruct {
            a: 52897,
            b: List::<u16, 1024>::from_iter([
                57538, 46153, 13864, 55980, 36298, 42375, 57333, 13823, 11080, 15719, 54365, 64655,
                17454, 50910, 14109, 30664, 45163, 54393, 40565, 1346, 15357, 12532, 51876, 19481,
                36026, 43931, 33409, 46595, 20759, 9753, 45390, 244, 57398, 59979, 31862, 20241,
                33359, 60686, 45041, 28453, 57529, 8261, 43545, 60077, 37757, 9334, 1504, 49579,
                30131, 32751, 65106, 19988, 58425, 56529, 45565, 18854, 39574, 54966, 28824, 26997,
                15596, 23761, 56917, 21503, 54743, 30367, 53952, 51841, 25202, 40259, 23196, 57645,
                29080, 6355, 54692, 22102, 10357, 49405, 14016, 39920, 39004, 53287, 20340, 31725,
                21882, 38632, 42915, 33059, 10498, 23590, 17807, 17784, 12910, 32269, 47, 24852,
                35432, 46766, 30647, 62137, 51337, 32141, 59655, 61258, 40991, 59415, 32201, 53768,
                60841, 42380, 48123, 3995, 55160, 14602, 5920, 45634, 1287, 33765, 63007, 30476,
                5921, 50441, 21565, 23326, 4899, 59239, 25447, 1994, 23235, 28842, 12210, 39894,
                51086, 55167, 13509, 62490, 47804, 46432, 13459, 28650, 26110, 849, 29944, 21814,
                12664, 1082, 731, 34974, 22476, 13722, 57896, 50355, 55205, 17247, 13256, 41717,
                32106, 28750, 53621, 14095, 2001, 21525, 33400, 1057, 39725, 10529, 16286, 9802,
                54791, 18799, 5923, 34001, 11721, 13668, 23042, 37780, 56, 40943, 19303, 33351,
                805, 25053, 43037, 14950, 43590, 3572, 40973, 62838, 52771, 30449, 61766, 2946,
                28684, 30292, 41403, 2977, 29432, 29157, 35240, 57947, 26586, 14087, 27399, 12259,
                61008, 29356, 45020, 56112, 19173, 23098, 30061, 47842, 60665, 4881, 30041, 35263,
                55351, 64447, 5871, 49427, 4316, 9872, 37374, 11511, 45625, 46598, 32537, 34702,
                25793, 51440, 11534, 3964, 21046, 34739, 22367, 21205, 52363, 29025, 21790, 25975,
                59790, 8779, 27475, 60566, 64297, 16572, 18891, 9106, 63597, 27230, 38630, 48535,
                28614, 44789, 3985, 12322, 55204, 62638, 47762, 27809, 38501, 18, 12944, 38846,
                58215, 57300, 61546, 49560, 22417, 38185, 60067, 37445, 51305, 19772, 61808, 17533,
                48168, 49689, 32242, 53591, 17598, 52701, 63333, 13130, 40425, 43631, 3626, 27195,
                32583, 56846, 2347, 9027, 264, 35874, 54691, 35426, 51718, 5360, 28309, 5080,
                29974, 37086, 10894, 5618, 22896, 49428, 46359, 16199, 2552, 23143, 40465, 26614,
                52106, 63071, 21350, 13195, 6304, 60477, 34246, 7476, 25830, 38573, 45559, 37428,
                63645, 64024, 21871, 84, 59442, 28245, 29309, 36126, 1319, 15843, 25200, 33069,
                37609, 29816, 53400, 21354, 13050, 57573, 58238, 29716, 62701, 47626, 53435, 35397,
                27944, 49333, 6050, 63316, 44693, 29915, 48712, 37441, 10567, 39, 42099, 61403,
                52029, 4899, 44665, 27201, 57771, 43192, 38154, 54323, 47908, 36754, 39132, 30919,
                25993, 28543, 27197, 61479, 33201, 54018, 42783, 33407, 33219, 42436, 29562, 14132,
                13017, 6987, 17756, 22501, 47348, 36696, 62174, 33984, 23666, 43427, 53621, 32848,
                51887, 53435, 6409, 55570, 17000, 3524, 28141, 5100, 11882, 34313, 26068, 13143,
                42942, 8619, 52231, 17637, 39539, 18401, 55661, 35279, 15937, 43043, 17790, 26276,
                25323, 6725, 41662, 30419, 62612, 30045, 55819, 50116, 15889, 63377, 34229, 13984,
                13152, 58130, 1229, 1153, 24190, 53536, 35174, 58369, 50366, 17092, 21256, 18727,
                18160, 20315, 2132, 65264, 12333, 23524, 64750, 56546, 59440, 43049, 15083, 59149,
                19227, 17086, 57652, 58911, 57022, 56693, 31725, 44481, 18394, 19218, 24666, 34837,
                31582, 59757, 34055, 17417, 49457, 49217, 9836, 23118, 47592, 37017, 57832, 58077,
                36438, 64873, 6183, 14577, 11249, 19180, 51947, 22839, 4484, 5740, 15897, 39765,
                65133, 37749, 48408, 46160, 12284, 59102, 1663, 64294, 58550, 9859, 4209, 23120,
                42257, 46244, 46784, 37709, 21524, 10020, 5649, 14185, 27495, 52100, 55861, 39435,
                14583, 59522, 39942, 53219, 57171, 22382, 62877, 7019, 57610, 21115, 9954, 14082,
                55818, 50310, 36705, 20993, 65252, 19362, 57006, 47661, 4465, 43616, 12803, 54274,
                55540, 27448, 39736, 4094, 59949, 34319, 57221, 25768, 7279, 62176, 14292, 52168,
                59129, 33996, 60631, 48399, 2677, 61353, 60188, 21080, 31556, 26111, 30161, 42556,
                2183, 16129, 2273, 59218, 42404, 2745, 27499, 33082, 33667, 26193, 32896, 11953,
                31541, 46407, 10755, 55072, 22670, 8813, 45541, 40583, 1842, 7892, 31595, 11540,
                9020, 87, 15252, 55780, 46521, 61767, 58559, 17093, 63906, 23375, 48737, 4874,
                47690, 23332, 24979, 45041, 51030, 48804, 38918, 57437, 42468, 58537, 25906, 33036,
                6760, 51741, 53019, 52011, 29209, 23204, 36899, 56831, 38561, 40856, 53458, 58143,
                723, 43359, 65350, 47591, 45442, 31961, 56731, 1762, 63521, 15251, 29299, 43441,
                46612, 29330, 10929, 58165, 58808, 20932, 33775, 59904, 54978, 38415, 47839, 51959,
                10291, 43190, 27051, 48778, 41373, 23840, 17079, 33312, 18838, 65200, 36901, 19231,
                16256, 5783, 42490, 27467, 35972, 7802, 1546, 27070, 8738, 15326, 48250, 36469,
                7091, 56230, 55736, 44356, 38391, 26024, 52634, 28269, 24201, 30137, 59379, 25971,
                42912, 20564, 48104, 39042, 50008, 61430, 29391, 31500, 902, 51008, 33059, 18402,
                45011, 14367, 46586, 52981, 62440, 21919, 42894, 37712, 57883, 6968, 37110, 35941,
                56019, 11089, 16381, 2421, 22643, 37677, 23624, 51771, 17769, 7037, 11536, 46870,
                41876, 56872, 32972, 13216, 19298, 37856, 47357, 18178, 8111, 14856, 17806, 52965,
                21941, 19633, 36043, 32914, 7253, 55001, 773, 14698, 4592, 27702, 7140, 45399,
                28704, 2649, 56448, 53390, 28730, 54835, 12602, 469, 11568, 46397, 48653, 50397,
                22510, 50834, 50867, 10261, 39014, 24232, 30131, 18762, 60754, 52029, 24774, 50922,
                22860, 56048, 5717, 60845, 235, 64949, 43916, 37422, 6559, 2732, 61895, 2418,
                64448, 36828, 54582, 10602, 58840, 41906, 6299, 9640, 65098, 25540, 21303, 60074,
                42304, 24256, 2452, 34060, 13492, 60381, 13865, 45393, 62497, 8580, 57956, 740,
                62868, 56743, 44661, 53090, 12252, 44468, 41754, 35555, 22850, 57374, 9974, 26770,
                35311, 64606, 49948, 9966, 38080, 1549, 49713, 15898, 37459, 50666, 37759, 44825,
                44337, 50653, 46095, 42576, 41871, 35552, 6671, 11692, 62035, 16562, 49706, 47473,
                49602, 62115, 28265, 45687, 49177, 57850, 55322, 24563, 12193, 41716, 12757, 50238,
                49055, 61066, 33436, 18102, 17540, 15869, 26361, 64025, 64099, 58097, 42522, 47787,
                15572, 3496, 7587, 40535, 59823, 17473, 39390, 32235, 63408, 60300, 3979, 15343,
                42259, 8617, 6781, 58482, 6044, 9419, 57800, 8295, 16731, 36123, 51778, 63177,
                21258, 27164, 11294, 8994, 6069, 47955, 33507, 30025, 7278, 6106, 30788, 38937,
                7474, 55879, 38380, 14200, 41567, 17494, 6527, 64579, 39847, 60783, 56977, 42701,
                5743, 64552, 21185, 28881, 7027, 14069, 36775, 57815, 43144, 19578, 40497, 21033,
                11754, 40586, 47862, 42276, 26224, 38852, 50355, 46114, 18512, 4276, 15792, 44229,
                57433, 18711, 41024, 18129, 53606, 22921, 51621, 46635, 23410, 61990, 17006, 29511,
                32262, 39401, 24383, 41407, 15449, 38280, 20211, 380, 3770, 38462, 30172, 28008,
                37569, 11404, 43860, 23897, 58232, 26337, 61518, 20572, 53060, 30563, 11913, 1260,
                18826, 56364, 3636, 50608, 7444, 39192, 34444, 10585, 42043, 40965, 36796, 28985,
                40984, 34313, 41385, 14882, 58944, 63764, 44071, 37150, 20063, 6701, 54525, 2603,
                39516, 29664, 27931, 54316, 35337, 49269, 64349, 23533, 20243, 17618, 47554, 46238,
                20877, 61195, 39794, 54062, 18998, 2138, 44332, 10814, 23503, 40168, 52664, 10427,
                26935, 38958, 10249, 43556,
            ]),
            c: 197,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 126,
                b: 3435762523509387151,
                c: 3665221517,
            },
            FixedTestStruct {
                a: 243,
                b: 943513122303052545,
                c: 1401396655,
            },
            FixedTestStruct {
                a: 249,
                b: 8873799629985696120,
                c: 1314056729,
            },
            FixedTestStruct {
                a: 152,
                b: 3484830523848989111,
                c: 2938394908,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 50336,
                b: List::<u16, 1024>::from_iter([
                    41481, 27737, 20084, 21026, 51969, 22420, 56680, 44694, 34473, 8227, 26994,
                    20777, 23402, 62830, 7234, 27458, 6656, 44260, 3196, 45565, 45086, 52477, 3041,
                    40855, 56914, 18620, 21648, 5871, 46598, 21094, 25422, 30346, 2885, 33974,
                    6795, 40002, 39064, 26623, 61564, 43313, 57302, 54238, 769, 34489, 41722,
                    32632, 56982, 35153, 55466, 42379, 3727, 57323, 33312, 3970, 42909, 8109, 4483,
                    26312, 63378, 50364, 6744, 39041, 58828, 34961, 17110, 63034, 2290, 33765,
                    54708, 65397, 56768, 14224, 10424, 61820, 48868, 14028, 5048, 35846, 47220,
                    6492, 8468, 15914, 30734, 8064, 17308, 59809, 24985, 46323, 941, 37939, 45853,
                    50846, 13439, 5046, 56946, 24902, 48330, 51141, 42224, 12584, 10241, 46214,
                    5541, 38933, 54853, 35632, 2811, 62290, 33498, 28989, 60803, 20380, 43960,
                    45632, 22668, 27154, 36005, 6234, 10958, 42051, 19918, 13279, 49375, 47132,
                    10247, 36361, 10247, 44350, 41520, 17877, 56449, 2551, 27877, 23014, 5437,
                    49859, 20342, 64317, 45162, 29926, 9773, 8037, 21768, 38484, 63389, 61351,
                    3525, 311, 32412, 22995, 33562, 57947, 41586, 57875, 47466, 40981, 63026,
                    13179, 55931, 31646, 46317, 59022, 56146, 62761, 64166, 57367, 64643, 52313,
                    2840, 43943, 58314, 52000, 64264, 22359, 40941, 26086, 25640, 28390, 55285,
                    30615, 25002, 54095, 23386, 49764, 26003, 20586, 53546, 6018, 12581, 54375,
                    38920, 51490, 45080, 33968, 16939, 6486, 2147, 20508, 23264, 13486, 15944,
                    10011, 42915, 5766, 20217, 42913, 25524, 3945, 60919, 12868, 27094, 45567,
                    33602, 41887, 9763, 62254, 19498, 8487, 4167, 10929, 41289, 62807, 36484,
                    33308, 21024, 34758, 21713, 22131, 7439, 59993, 12850, 49488, 15814, 32689,
                    3637, 577, 60218, 9449, 52588, 46575, 51382, 50716, 28851, 13972, 23467, 20387,
                    32593, 45932, 59637, 25374, 18665, 3295, 8966, 58827, 3913, 31712, 53967,
                    63564, 44062, 55667, 29838, 41747, 64053, 13348, 56221, 37374, 59539, 24983,
                    55582, 30848, 46270, 60180, 61578, 26992, 9025, 46758, 14754, 45813, 31301,
                    58000, 40014, 33515, 50300, 39938, 15729, 42035, 45056, 11714, 17851, 2986,
                    24049, 39804, 58627, 26225, 23216, 30525, 36946, 43518, 1628, 6416, 51576,
                    22120, 42294, 19989, 12303, 13847, 57549, 5738, 14125, 12629, 54480, 42206,
                    57669, 17084, 22136, 6763, 54225, 24358, 51680, 38996, 53342, 16734, 9314,
                    58350, 64027, 43818, 32267, 15237, 41158, 38437, 47038, 44941, 34323, 41321,
                    44174, 23597, 35601, 6795, 62710, 16304, 9705, 14417, 28029, 57617, 27980,
                    21503, 29138, 30468, 21943, 39184, 33627, 43616, 10109, 44708, 48381, 32484,
                    23136, 21738, 14522, 48177, 27101, 56348, 54765, 22027, 51756, 40697, 9136,
                    4050, 29596, 39490, 40285, 35449, 33861, 65218, 8129, 34936, 42569, 14197,
                    36825, 1909, 34790, 62070, 31076, 26112, 45098, 52223, 58189, 60262, 44948,
                    57936, 39041, 47582, 35713, 10043, 60405, 9332, 27122, 57361, 39723, 45292,
                    16624, 4845, 50847, 62786, 15510, 24290, 33327, 5634, 49016, 37186, 5299,
                    30162, 10354, 60243, 25401, 36804, 30411, 15642, 57393, 38502, 41987, 12828,
                    44864, 52293, 24681, 20206, 21329, 33570, 27214, 47872, 42774, 19639, 24645,
                    59075, 39007, 31375, 59269, 62154, 50855, 32775, 16062, 14162, 10139, 18647,
                    23976, 48074, 59390, 45356, 44707, 54370, 19190, 61403, 51969, 59983, 5188,
                    54232, 31932, 41997, 21254, 44880, 10259, 44381, 37708, 39509, 27342, 43999,
                    39001, 17064, 41439, 26094, 52176, 43007, 49596, 24015, 16595, 8958, 5910,
                    25446, 41820, 24403, 35373, 52975, 13152, 26120, 26500, 21467, 339, 55186,
                    49857, 45045, 26512, 43217, 6376, 56572, 17898, 9479, 20332, 25481, 33820,
                    35678, 51131, 14887, 12098, 64416, 7117, 55136, 30812, 10866, 62239, 37613,
                    25821, 40355, 38241, 29897, 24572, 39619, 63710, 6458, 36918, 57755, 18396,
                    22804, 23668, 51740, 48652, 6380, 3005, 20755, 6534, 6727, 19158, 42965, 11456,
                    56083, 56876, 32990, 41566, 56770, 57696, 32393, 43651, 31740, 47496, 60289,
                    8600, 57421, 60943, 30738, 29042, 25052, 39740, 48585, 33450, 26571, 9520,
                    33788, 29259, 14498, 54760, 40396, 11318, 26635, 14225, 18476, 39847, 48006,
                    1610, 22901, 10652, 2536, 30092, 39904, 4534, 40858, 64330, 9816, 24870, 17792,
                    58389, 29188, 20670, 65417, 33353, 31543, 64041, 32394, 41910, 58920, 17712,
                    32091, 43192, 31353, 2493, 16626, 32525, 61943, 48428, 15825, 34080, 48587,
                    58219, 49198, 58021, 44104, 56503, 10617, 6998, 49926, 32334, 18632, 25389,
                    32723, 57677, 25747, 4352, 63629, 26905, 26795, 32938, 20951, 46511, 53508,
                    46031, 27214, 22460, 30199, 23778, 35464, 48128, 44573, 31645, 64267, 27629,
                    58246, 15769, 22646, 37281, 23809, 54766, 29176, 31818, 61933, 51038, 35692,
                    25234, 1977, 53744, 18274, 37042, 2688, 3384, 46261, 53731, 580, 6383, 54920,
                    43083, 10414, 22199, 61537, 36215, 43521, 14929, 10204, 59884, 4278, 10551,
                    46398, 43195, 46815, 52166, 54649, 41131, 56367, 34543, 30682, 6162, 58867,
                    26826, 24077, 31553, 31691, 62437, 2057, 39778, 59423, 48469, 5599, 14123,
                    29883, 36662, 14614, 12689, 17740, 57079, 47637, 43695, 49643, 2666, 30843,
                    26536, 6226, 41490, 41961, 8781, 19368, 44621, 4100, 63166, 42543, 21247,
                    11642, 59385, 48985, 13704, 47856, 52796, 19489, 20381, 38607, 38760, 9665,
                    44691, 38974, 33168, 16765, 27020, 60695, 28191, 18919, 37477, 22590, 43878,
                    29895, 17425, 25370, 35650, 55797, 34845, 35460, 26752, 59997, 28222, 49610,
                    55218, 3111, 13350, 44623, 11603, 48690, 19387, 64758, 4615, 56336, 10868,
                    52915, 14575, 31302, 54181, 14522, 17348, 58219, 26462, 18473, 28637, 27782,
                    21014, 61134, 63137, 36649, 44959, 902, 42869, 62507, 65182, 57335, 5583,
                    45386, 907, 62158, 58919, 28197, 7234, 56068, 49282, 37296, 64144, 43871, 7137,
                    32463, 11718, 22487, 52467, 62049, 46149, 40010, 59060, 55233, 64648, 59852,
                    38718, 43304, 38505, 1506, 25837, 3633, 29460, 36739, 21697, 11212, 28268, 905,
                    32385, 49208, 21787, 64179, 18365, 40892, 22696, 7, 10678, 43456, 6352, 43299,
                    56003, 9178, 49726, 35269, 47738, 25250, 4834, 33669, 34968, 30302, 18240,
                    22323, 64336, 3177, 11394, 62862, 19004, 56129, 10729, 22986, 52891, 39020,
                    1316, 26410, 11174, 16057, 56272, 11473, 543, 35315, 43523, 45592, 31036,
                    44813, 23829, 33573, 58271, 44827, 46665, 5549, 41645, 9291, 12457, 361, 27355,
                    49808, 44918, 27122, 4824, 4208, 63233, 43410, 37958, 30595, 6678, 7656, 2571,
                    22841, 26542, 11344, 10069, 23671, 28739, 15127, 14433, 54107, 31398, 59257,
                    18365, 4846, 5175, 19468, 52944, 60332, 14373, 9433, 41176, 41501, 32425,
                    34284, 731, 62439, 36099, 42797, 34759, 14334, 7952, 1317, 19713, 63663, 7172,
                    31151, 60429, 57584, 214, 52931, 48186, 53899, 30507, 37952, 53545, 6237,
                    63944, 13886, 19542, 44271, 30112, 11246, 54657, 63817, 55875, 20147, 53008,
                    29243, 14010, 60198, 48824, 55707, 53591, 50976, 55565, 20583, 3444, 64533,
                    14095, 20703, 25820, 33160, 33611, 60794, 29095, 36456, 28814, 12046, 3282,
                    50130, 12495, 59043, 3592, 20409, 63628, 47165, 53808, 42900, 54119, 40716,
                    22081, 59737, 42239, 35456, 1080, 17474, 1231, 45216, 46169, 53755, 11140,
                    51210, 42016, 21635, 41091, 35743, 63746, 26755, 36460, 20084, 39803, 34379,
                    65334, 32831, 14886, 12586, 24969, 28481, 59297, 3126, 62524, 42587, 34177,
                    61156, 27477, 61815, 1175, 30208, 13562, 49811, 38845, 49723, 12590, 5231,
                    4168, 7223, 14124, 5525, 55720, 25451, 23462, 17252, 30929, 16276,
                ]),
                c: 88,
            },
            VarTestStruct {
                a: 22996,
                b: List::<u16, 1024>::from_iter([
                    18049, 23381, 17471, 45440, 57003, 19762, 1146, 5298, 31435, 19141, 37079,
                    46179, 38144, 54491, 65355, 15320, 20738, 17594, 44000, 5057, 19754, 7417,
                    50377, 35990, 16560, 3769, 59936, 19996, 6403, 39, 27926, 36412, 35110, 22053,
                    16664, 13243, 11743, 11678, 33374, 20604, 64814, 17539, 53250, 60055, 9782,
                    27275, 9256, 49760, 2784, 10915, 34573, 7116, 38999, 8380, 18529, 9618, 11993,
                    17521, 18424, 23233, 10988, 60760, 5441, 9366, 7987, 43256, 39661, 64034,
                    51113, 27896, 20361, 62133, 42626, 10437, 30389, 19224, 15057, 35860, 62585,
                    36401, 8704, 36561, 43495, 20925, 54259, 52245, 29072, 56121, 60476, 33825,
                    35465, 41980, 46222, 9012, 20564, 12506, 7761, 33331, 28693, 51259, 42950,
                    30572, 60064, 12172, 5484, 13074, 13143, 36910, 6527, 60740, 64254, 47001,
                    11916, 43588, 64673, 33500, 14914, 17681, 24475, 13914, 16719, 40993, 40475,
                    55166, 64014, 45905, 42475, 23460, 38117, 4587, 895, 2326, 11193, 46559, 11216,
                    62032, 4089, 24114, 36342, 20877, 12878, 56517, 40994, 15028, 13450, 37507,
                    20410, 15713, 49077, 60011, 12838, 42922, 59323, 21984, 16491, 20728, 25248,
                    57325, 27797, 34395, 42472, 21682, 6506, 10690, 55293, 17920, 61234, 26703,
                    43801, 57234, 38746, 31090, 16945, 33394, 29751, 38441, 23998, 52746, 32254,
                    2238, 9098, 28753, 11040, 42409, 23789, 27113, 43776, 22048, 13908, 30110,
                    38377, 47052, 124, 56943, 33216, 19738, 63166, 35926, 11960, 10922, 22838,
                    3927, 59670, 32779, 45082, 22897, 11521, 29993, 5746, 27439, 59124, 8602,
                    42013, 9051, 43411, 50527, 62677, 58522, 43530, 33389, 38392, 25685, 20010,
                    27089, 23352, 49737, 38733, 30324, 9909, 17693, 33673, 3832, 56071, 21673,
                    22218, 37948, 6129, 40196, 38561, 19638, 60330, 4942, 10562, 61928, 44974,
                    30688, 21606, 50982, 3288, 42524, 3954, 63738, 54858, 30147, 54046, 59825,
                    42154, 17199, 2709, 890, 216, 53128, 31504, 5250, 3718, 17010, 65391, 16872,
                    20324, 11424, 45905, 27402, 9245, 16750, 44321, 58299, 37757, 5153, 57972,
                    57460, 47309, 304, 29009, 34047, 54575, 56167, 2803, 2784, 31580, 58798, 7761,
                    21686, 59788, 24015, 47189, 58653, 41579, 63537, 20944, 38658, 47770, 32134,
                    13101, 4632, 54424, 47049, 49011, 33149, 20279, 1850, 27309, 65263, 24284,
                    43256, 32114, 61632, 61286, 65353, 46712, 57359, 35497, 29568, 28945, 31660,
                    44675, 64118, 29550, 53699, 16089, 8963, 52213, 65052, 48537, 3836, 33223,
                    56379, 52299, 17272, 10640, 25805, 29294, 59876, 62547, 53795, 61993, 63083,
                    40306, 41983, 58976, 33618, 50995, 33751, 40168, 29155, 14331, 43784, 8930,
                    5736, 39730, 37753, 11721, 37523, 40832, 42702, 47244, 26455, 1893, 60026,
                    35092, 12176, 58080, 60114, 12191, 39402, 50038, 39761, 27631, 48221, 50090,
                    48585, 64013, 37974, 42466, 33217, 34836, 18111, 48581, 28329, 37779, 33176,
                    29837, 28962, 34589, 64831, 32528, 63618, 65438, 26082, 36575, 44584, 10197,
                    36850, 6044, 8199, 22109, 52, 41499, 65145, 29577, 38621, 57327, 40557, 39791,
                    753, 48835, 11905, 57871, 30277, 53936, 12236, 28873, 54182, 25200, 8446,
                    34870, 30242, 62865, 51522, 56366, 3065, 31400, 19551, 11556, 59408, 5615,
                    12582, 24498, 54755, 42472, 21195, 16326, 54331, 65266, 29584, 61222, 56993,
                    42115, 52972, 6667, 43912, 33817, 28008, 53048, 63528, 57011, 46408, 48338,
                    58493, 34007, 30151, 18788, 46177, 55648, 40571, 26545, 37588, 43300, 46262,
                    1873, 12876, 14127, 10910, 2823, 12842, 58486, 52316, 35774, 26, 31375, 47605,
                    47554, 15316, 7116, 50892, 63950, 33445, 39945, 63713, 16455, 56400, 8868,
                    57496, 22285, 35320, 7177, 34525, 32373, 12834, 22014, 47938, 17303, 6127, 961,
                    62843, 40607, 10177, 11589, 32421, 36699, 59894, 45500, 59696, 50021, 40614,
                    46900, 3744, 953, 20234, 21249, 38554, 53119, 57265, 13226, 16341, 5973, 53646,
                    20702, 41280, 37423, 25092, 17597, 19608, 50287, 50817, 8823, 50558, 54239,
                    13944, 45784, 27839, 18239, 46712, 46121, 10838, 31446, 52864, 216, 9528,
                    59986, 56031, 44275, 51788, 3264, 29146, 42579, 24586, 43887, 11508, 34377,
                    19189, 2166, 48578, 7862, 57296, 48931, 19245, 12048, 58350, 1608, 56129,
                    34373, 39019, 45323, 16377, 19248, 55893, 47104, 31725, 21500, 33340, 31829,
                    25310, 28551, 23204, 44429, 4425, 27277, 25834, 59350, 4016, 63025, 47800,
                    35371, 52498, 49368, 36810, 41311, 17731, 11559, 64562, 7348, 21347, 45127,
                    46204, 30559, 57169, 29224, 36066, 59203, 61361, 33731, 31868, 20145, 12301,
                    62127, 12725, 15930, 13345, 15872, 52319, 19471, 17735, 25297, 10204, 41635,
                    40979, 55644, 33744, 23971, 11894, 17344, 34128, 51349, 33753, 6618, 20687,
                    30357, 46385, 2803, 16401, 1161, 60205, 64095, 64526, 40561, 34386, 9544,
                    26331, 55185, 35941, 56782, 12164, 23111, 24234, 51813, 9740, 22359, 28008,
                    29188, 29153, 54340, 12390, 44524, 46328, 22548, 40699, 54388, 26513, 38042,
                    58877, 8718, 24771, 41097, 24974, 59710, 13356, 47617, 55333, 8105, 37891,
                    17996, 27033, 39839, 28651, 61209, 4112, 43863, 15082, 10328, 11765, 8728,
                    46834, 64955, 60454, 48326, 65245, 568, 4982, 29946, 43871, 62720, 46653,
                    47687, 13622, 44050, 41265, 9956, 39928, 28294, 61047, 57822, 38884, 59847,
                    63234, 57966, 52652, 23106, 55983, 481, 21981, 38426, 6213, 41817, 47510,
                    33644, 17836, 25946, 41968, 742, 25176, 8591, 11904, 43546, 42132, 12860,
                    39035, 50949, 4252, 63926, 24871, 25530, 21401, 48368, 30214, 31948, 63551,
                    65114, 41704, 51066, 28449, 34326, 12318, 63015, 50072, 31756, 62782, 408,
                    57460, 47060, 57277, 54241, 30820, 26351, 1855, 12205, 29938, 52856, 26712,
                    44365, 42671, 46560, 59494, 62885, 40630, 39527, 21494, 2058, 48705, 61846,
                    12495, 31765, 52685, 4901, 35146, 33950, 39003, 38303, 12939, 58443, 41101,
                    57476, 11428, 12070, 61697, 62659, 60093, 35708, 46926, 23641, 42455, 12611,
                    36082, 6754, 24172, 2821, 1285, 11065, 2278, 24610, 16763, 45022, 59164, 17484,
                    53068, 54584, 18777, 64296, 55866, 26810, 63730, 11251, 61573, 15781, 54778,
                    25317, 29879, 21001, 32984, 4191, 6639, 23044, 7807, 36069, 29551, 57682,
                    20968, 8524, 31141, 8427, 10177, 21973, 35541, 56457, 21691, 51618, 50699,
                    45188, 52019, 63940, 33237, 7312, 5401, 9205, 44042, 13933, 50820, 48931, 7732,
                    40235, 59971, 49621, 13121, 58870, 34002, 56564, 6746, 50677, 13671, 3253,
                    61656, 58, 14136, 2355, 18156, 38457, 18192, 35451, 32230, 645, 48503, 636,
                    34700, 50858, 2371, 10544, 43588, 43284, 35474, 22335, 62553, 50590, 39404,
                    59335, 9423, 25854, 14475, 48491, 65104, 30232, 61102, 53388, 15004, 21505,
                    62358, 35018, 8998, 57529, 1550, 21663, 48751, 27123, 27655, 34083, 65355,
                    50673, 47149, 38904, 1604, 15246, 3784, 60125, 58625, 14541, 42132, 43782,
                    21779, 39409, 50046, 11302, 3756, 38488, 62398, 41686, 41211, 26880, 44951,
                    19333, 41869, 3229, 29642, 9879, 32909, 10118, 54204, 15907, 57210, 37963,
                    35374, 64813, 28029, 5563, 16445, 54244, 53894, 671, 36325, 10310, 20705,
                    18761, 46668, 43778, 9546, 55011, 6991, 14974, 9182, 65037, 1850, 44044, 29765,
                    63468, 24683, 56028, 48246, 20911, 21101, 11311, 17191, 64980, 30874, 14576,
                    22012, 64078, 36413, 11880, 18063, 47371, 5097, 43515, 9024, 22710, 16367,
                    63977, 1174, 59415, 28548, 47111, 30374, 43806, 983, 58518, 10557, 23885, 2605,
                    25523, 2686, 40527, 6091, 23542, 15116, 53968, 43868, 12012, 4870, 64060, 331,
                    43823, 47250, 9293, 33457, 40166, 48356, 54043, 50596,
                ]),
                c: 54,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data("ssz_rs/tests/data/containers/valid/ComplexTestStruct_lengthy_chaos_0/serialized.ssz_snappy");
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("079ed404b123f765913f7fddd43bc35e06cbeb8a97c2058564434dd8cf513c3a");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_one_9() {
    let value = ComplexTestStruct {
        a: 32826,
        b: List::<u16, 128>::from_iter([52269]),
        c: 179,
        d: List::<u8, 256>::from_iter([166]),
        e: VarTestStruct {
            a: 47224,
            b: List::<u16, 1024>::from_iter([27133]),
            c: 46,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 190,
                b: 17267852126418429692,
                c: 1192183507,
            },
            FixedTestStruct {
                a: 86,
                b: 5812480785575976468,
                c: 517726582,
            },
            FixedTestStruct {
                a: 70,
                b: 14751118928048906008,
                c: 2949562141,
            },
            FixedTestStruct {
                a: 25,
                b: 6477487707159203533,
                c: 627300018,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 53608,
                b: List::<u16, 1024>::from_iter([33375]),
                c: 209,
            },
            VarTestStruct {
                a: 33550,
                b: List::<u16, 1024>::from_iter([39605]),
                c: 19,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_one_9/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("b6a6dadc39093cfcbe17d99863ec39be349756cd0e156aa1ecf2edaa6823fab1");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_random_chaos_2() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([false, false, false]),
        b: Bitvector::<2>::from_iter([false, false]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([false, false, false, true, true]),
        e: Bitvector::<8>::from_iter([true, true, true, true, false, true, true, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_random_chaos_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("c89390bf6b5c49e2c42be8203a79bdb6c67780ad00c1e649fea1255335f4244b");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_zero_chaos_1() {
    let value = VarTestStruct {
        a: 0,
        b: List::<u16, 1024>::from_iter([
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        ]),
        c: 0,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_zero_chaos_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("037ec5030f962590e3fbdb61d5614e93129138f4fdf5a380dbca64d2a4ac7810");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_max_3() {
    let value = ComplexTestStruct {
        a: 65535,
        b: List::<u16, 128>::from_iter([
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535,
        ]),
        c: 255,
        d: List::<u8, 256>::from_iter([255]),
        e: VarTestStruct {
            a: 65535,
            b: List::<u16, 1024>::from_iter([
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            ]),
            c: 255,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 65535,
                b: List::<u16, 1024>::from_iter([
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535,
                ]),
                c: 255,
            },
            VarTestStruct {
                a: 65535,
                b: List::<u16, 1024>::from_iter([
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535,
                ]),
                c: 255,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_max_3/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("2b5b8b8a2aa2d905a2716be903b7694e03740120db4a613c7d0ba87b171dfe2c");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_one_7() {
    let value = ComplexTestStruct {
        a: 46962,
        b: List::<u16, 128>::from_iter([51108]),
        c: 232,
        d: List::<u8, 256>::from_iter([51]),
        e: VarTestStruct {
            a: 61296,
            b: List::<u16, 1024>::from_iter([50107]),
            c: 80,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 142,
                b: 16391694718469767627,
                c: 1723717716,
            },
            FixedTestStruct {
                a: 150,
                b: 18231846756020050949,
                c: 4085824434,
            },
            FixedTestStruct {
                a: 242,
                b: 3167723324830397151,
                c: 3505585751,
            },
            FixedTestStruct {
                a: 54,
                b: 11608704772362674523,
                c: 2197949526,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 35151,
                b: List::<u16, 1024>::from_iter([47168]),
                c: 175,
            },
            VarTestStruct {
                a: 49526,
                b: List::<u16, 1024>::from_iter([16871]),
                c: 223,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_one_7/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("7460458ef6fd374a9de68db7a0b3d0f0d1aed59325725d07a90616456ebcd588");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_zero_chaos_2() {
    let value = FixedTestStruct { a: 0, b: 0, c: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_zero_chaos_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("db56114e00fdd4c1f85c892bf35ac9a89289aaecb1ebd0a96cde606a748b5d71");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_one_0() {
    let value = ComplexTestStruct {
        a: 48911,
        b: List::<u16, 128>::from_iter([9378]),
        c: 223,
        d: List::<u8, 256>::from_iter([88]),
        e: VarTestStruct {
            a: 35646,
            b: List::<u16, 1024>::from_iter([45153]),
            c: 194,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 223,
                b: 15858315646050493180,
                c: 1035175295,
            },
            FixedTestStruct {
                a: 238,
                b: 8214804078873394894,
                c: 211540354,
            },
            FixedTestStruct {
                a: 206,
                b: 2768604207237255181,
                c: 1481584540,
            },
            FixedTestStruct {
                a: 21,
                b: 8252301037967392689,
                c: 3525266586,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 35378,
                b: List::<u16, 1024>::from_iter([35733]),
                c: 226,
            },
            VarTestStruct {
                a: 63219,
                b: List::<u16, 1024>::from_iter([29843]),
                c: 106,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_one_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("a02e83c64be6459fb89ee3893623c5767cbec7295e71e887392771ff98603a03");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_one_chaos_1() {
    let value = ComplexTestStruct {
        a: 38015,
        b: List::<u16, 128>::from_iter([22188]),
        c: 189,
        d: List::<u8, 256>::from_iter([137]),
        e: VarTestStruct {
            a: 27201,
            b: List::<u16, 1024>::from_iter([3990]),
            c: 169,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 244,
                b: 17680911497750963160,
                c: 2820605766,
            },
            FixedTestStruct {
                a: 41,
                b: 6582973943842155323,
                c: 3930139073,
            },
            FixedTestStruct {
                a: 181,
                b: 5035412352079054455,
                c: 1060450728,
            },
            FixedTestStruct {
                a: 161,
                b: 16594572392883778734,
                c: 925588037,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 6057,
                b: List::<u16, 1024>::from_iter([55]),
                c: 169,
            },
            VarTestStruct {
                a: 32091,
                b: List::<u16, 1024>::from_iter([21718]),
                c: 207,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_one_chaos_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("a57d86f4ea29cd835b6bc7adf0a5205f1ed819aa736892dd336da3869d857820");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_max_3() {
    let value = SingleFieldTestStruct { a: 255 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_max_3/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("ff00000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_random_7() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([true, false]),
        b: Bitvector::<2>::from_iter([true, false]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([true, false]),
        e: Bitvector::<8>::from_iter([true, false, true, false, false, true, true, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_random_7/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("9b29961c7d4a3b73ea66e6adf69a520890e9bedb001b01c3a24b79a0cc135997");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_max_chaos_2() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([true, true, true]),
        b: Bitvector::<2>::from_iter([true, true]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([true, true, true, true]),
        e: Bitvector::<8>::from_iter([true, true, true, true, true, true, true, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_max_chaos_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("662a52b056d31844fe9a143bc7bf82f6c52d7cc9d6b9d9736c2e0d7c9a4b65f3");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_zero_0() {
    let value = ComplexTestStruct {
        a: 0,
        b: List::<u16, 128>::from_iter([
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        ]),
        c: 0,
        d: List::<u8, 256>::from_iter([0]),
        e: VarTestStruct {
            a: 0,
            b: List::<u16, 1024>::from_iter([
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            ]),
            c: 0,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 0,
                b: List::<u16, 1024>::from_iter([
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0,
                ]),
                c: 0,
            },
            VarTestStruct {
                a: 0,
                b: List::<u16, 1024>::from_iter([
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0,
                ]),
                c: 0,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_zero_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("d3f0fe44a7a2f41215d6fdb22cce2e0c89be118c7a5106ef5bff4290a570ede0");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_zero_1() {
    let value = SingleFieldTestStruct { a: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_zero_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("0000000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_max_4() {
    let value = SingleFieldTestStruct { a: 255 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_max_4/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("ff00000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_zero_6() {
    let value = SingleFieldTestStruct { a: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_zero_6/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("0000000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_zero_7() {
    let value = ComplexTestStruct {
        a: 0,
        b: List::<u16, 128>::from_iter([
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        ]),
        c: 0,
        d: List::<u8, 256>::from_iter([0]),
        e: VarTestStruct {
            a: 0,
            b: List::<u16, 1024>::from_iter([
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0,
            ]),
            c: 0,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 0,
                b: List::<u16, 1024>::from_iter([
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0,
                ]),
                c: 0,
            },
            VarTestStruct {
                a: 0,
                b: List::<u16, 1024>::from_iter([
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0,
                ]),
                c: 0,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_zero_7/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("ecdc839d58de1e9b6003770857a5097dea8c25c6f63078494bee748f7a912b8f");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_random_0() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([false]),
        b: Bitvector::<2>::from_iter([false, true]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([true, true, true, true]),
        e: Bitvector::<8>::from_iter([false, true, false, false, true, true, true, false]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_random_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("772980f52813d8970bcc933736cd21975517a61483612efd2086591e1b0cdae6");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_random_9() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([true, true, false, true]),
        b: Bitvector::<2>::from_iter([true, false]),
        c: Bitvector::<1>::from_iter([false]),
        d: Bitlist::<6>::from_iter([true, false, true, true]),
        e: Bitvector::<8>::from_iter([false, false, false, false, true, false, true, false]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_random_9/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("0c78458e737991adc376b4be7ab7b07522374623557c4ca8abcd00bd8665cd13");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_zero_8() {
    let value = SingleFieldTestStruct { a: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_zero_8/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("0000000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_zero_9() {
    let value = ComplexTestStruct {
        a: 0,
        b: List::<u16, 128>::from_iter([0, 0, 0]),
        c: 0,
        d: List::<u8, 256>::from_iter([0]),
        e: VarTestStruct {
            a: 0,
            b: List::<u16, 1024>::from_iter([
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            ]),
            c: 0,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
            FixedTestStruct { a: 0, b: 0, c: 0 },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 0,
                b: List::<u16, 1024>::from_iter([
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                ]),
                c: 0,
            },
            VarTestStruct {
                a: 0,
                b: List::<u16, 1024>::from_iter([
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0,
                ]),
                c: 0,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_zero_9/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("eef804ef0a314328f86f7635f913264f4c7a0ce11d8a9e5dc3c400bb8d7a6aa7");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_one_1() {
    let value = ComplexTestStruct {
        a: 63214,
        b: List::<u16, 128>::from_iter([13623]),
        c: 59,
        d: List::<u8, 256>::from_iter([216]),
        e: VarTestStruct {
            a: 14337,
            b: List::<u16, 1024>::from_iter([57158]),
            c: 73,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 205,
                b: 5393092458938150238,
                c: 3739864261,
            },
            FixedTestStruct {
                a: 146,
                b: 7554862186025036695,
                c: 759065969,
            },
            FixedTestStruct {
                a: 152,
                b: 10256506337230585302,
                c: 478033645,
            },
            FixedTestStruct {
                a: 171,
                b: 4506016525792096404,
                c: 3824862461,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 52933,
                b: List::<u16, 1024>::from_iter([37049]),
                c: 141,
            },
            VarTestStruct {
                a: 26191,
                b: List::<u16, 1024>::from_iter([45926]),
                c: 141,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_one_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("9e054c2087b21ff5263743e8939a648ec8d6195c7c7dbb4eb38baf2d15e94400");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_one_6() {
    let value = ComplexTestStruct {
        a: 51972,
        b: List::<u16, 128>::from_iter([48645]),
        c: 46,
        d: List::<u8, 256>::from_iter([105]),
        e: VarTestStruct {
            a: 1558,
            b: List::<u16, 1024>::from_iter([39947]),
            c: 65,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 70,
                b: 905948488145107787,
                c: 2675781419,
            },
            FixedTestStruct {
                a: 3,
                b: 12539792087931462647,
                c: 4719259,
            },
            FixedTestStruct {
                a: 73,
                b: 13544872847030609257,
                c: 2819826618,
            },
            FixedTestStruct {
                a: 159,
                b: 16328658841145598323,
                c: 2375225558,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 30336,
                b: List::<u16, 1024>::from_iter([30909]),
                c: 240,
            },
            VarTestStruct {
                a: 64263,
                b: List::<u16, 1024>::from_iter([38121]),
                c: 100,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_one_6/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("69b0ce69dfbc8abb8ae4fba564dcb813f5cc5b93c76d2b3d0689687c35821036");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_max_2() {
    let value = ComplexTestStruct {
        a: 65535,
        b: List::<u16, 128>::from_iter([
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535,
        ]),
        c: 255,
        d: List::<u8, 256>::from_iter([255]),
        e: VarTestStruct {
            a: 65535,
            b: List::<u16, 1024>::from_iter([
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535,
            ]),
            c: 255,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 65535,
                b: List::<u16, 1024>::from_iter([
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535,
                ]),
                c: 255,
            },
            VarTestStruct {
                a: 65535,
                b: List::<u16, 1024>::from_iter([
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535,
                ]),
                c: 255,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_max_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("9660907d6be249c807c9910f05a030bf95e523742de605d1d71b6a73dd5d7697");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_zero_chaos_0() {
    let value = VarTestStruct {
        a: 0,
        b: List::<u16, 1024>::from_iter([
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0,
        ]),
        c: 0,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_zero_chaos_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("6d78c67e92d89d5fa157efbff423b287f4940a3bd4e7c7b3800624c42ad10ac6");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_max_5() {
    let value = ComplexTestStruct {
        a: 65535,
        b: List::<u16, 128>::from_iter([65535, 65535, 65535, 65535, 65535]),
        c: 255,
        d: List::<u8, 256>::from_iter([255]),
        e: VarTestStruct {
            a: 65535,
            b: List::<u16, 1024>::from_iter([
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                65535, 65535, 65535, 65535, 65535, 65535, 65535,
            ]),
            c: 255,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
            FixedTestStruct {
                a: 255,
                b: 18446744073709551615,
                c: 4294967295,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 65535,
                b: List::<u16, 1024>::from_iter([
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                ]),
                c: 255,
            },
            VarTestStruct {
                a: 65535,
                b: List::<u16, 1024>::from_iter([
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
                    65535, 65535, 65535, 65535, 65535, 65535,
                ]),
                c: 255,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_max_5/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("f3caea79b0c0a1756a7596bf0939a6d7495497936461f41d0315ce321d4b3dad");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_one_8() {
    let value = ComplexTestStruct {
        a: 43221,
        b: List::<u16, 128>::from_iter([62632]),
        c: 161,
        d: List::<u8, 256>::from_iter([170]),
        e: VarTestStruct {
            a: 34470,
            b: List::<u16, 1024>::from_iter([49333]),
            c: 243,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 120,
                b: 1523648906580514715,
                c: 791591623,
            },
            FixedTestStruct {
                a: 12,
                b: 16621022813318247745,
                c: 1103698378,
            },
            FixedTestStruct {
                a: 156,
                b: 9403042551474992172,
                c: 3829124548,
            },
            FixedTestStruct {
                a: 86,
                b: 6955517517277308905,
                c: 3651778934,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 7919,
                b: List::<u16, 1024>::from_iter([5167]),
                c: 3,
            },
            VarTestStruct {
                a: 27175,
                b: List::<u16, 1024>::from_iter([53104]),
                c: 220,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_one_8/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("dc304f765bc1d7f380986aff8ff000690ca7c7932024088083c2646913353701");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_max_chaos_0() {
    let value = SingleFieldTestStruct { a: 255 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data("ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_max_chaos_0/serialized.ssz_snappy");
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("ff00000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_lengthy_chaos_1() {
    let value = ComplexTestStruct {
        a: 14153,
        b: List::<u16, 128>::from_iter([
            3646, 43626, 7304, 41108, 40285, 9810, 25903, 50110, 7170, 37407, 23703, 47708, 39247,
            51866, 27826, 30891, 49449, 42721, 47268, 49391, 8446, 62433, 5953, 32559, 34536,
            26449, 55360, 44990, 62608, 9057, 24577, 29791, 59127, 106, 19484, 64217, 49766, 62407,
            36633, 18191, 28343, 43827, 64699, 57327, 19680, 21294, 5297, 36792, 58178, 36460,
            32037, 13112, 11320, 4296, 14785, 61496, 54847, 21482, 44656, 62059, 51609, 13485,
            57640, 36199, 26888, 22599, 23692, 43160, 61576, 15902, 58977, 32955, 49398, 5118,
            10258, 22497, 12683, 22530, 23509, 2327, 46832, 55917, 47865, 6088, 39543, 52726,
            36646, 16540, 21295, 50418, 14579, 48353, 56037, 59253, 56033, 44440, 10645, 48244,
            2681, 54833, 30926, 36170, 39698, 53837, 31233, 55783, 22756, 16, 63077, 34320, 22347,
            15187, 6878, 28362, 12863, 17010, 6690, 49025, 12362, 65018, 19042, 11384, 23229,
            62542, 31741, 34130, 44763, 58955,
        ]),
        c: 116,
        d: List::<u8, 256>::from_iter([
            31, 110, 87, 211, 48, 167, 201, 153, 135, 255, 242, 32, 187, 155, 152, 94, 126, 108,
            64, 248, 24, 12, 148, 186, 242, 192, 36, 127, 200, 224, 130, 20, 130, 214, 47, 45, 113,
            230, 16, 252, 145, 195, 203, 181, 160, 8, 205, 220, 94, 67, 63, 34, 3, 179, 202, 10,
            219, 39, 227, 72, 172, 168, 134, 18, 191, 9, 78, 47, 47, 110, 94, 174, 30, 90, 250, 51,
            179, 74, 132, 74, 27, 163, 138, 76, 179, 214, 180, 52, 183, 9, 123, 94, 133, 53, 155,
            165, 117, 72, 101, 164, 98, 248, 221, 42, 60, 87, 124, 27, 198, 75, 13, 159, 155, 208,
            30, 189, 166, 8, 115, 100, 32, 63, 12, 186, 19, 107, 188, 144, 233, 245, 158, 73, 137,
            1, 168, 89, 89, 217, 101, 74, 237, 68, 227, 105, 224, 140, 60, 130, 208, 84, 141, 186,
            242, 168, 68, 147, 117, 166, 44, 180, 253, 218, 245, 48, 18, 146, 38, 248, 130, 127,
            99, 38, 44, 234, 140, 200, 220, 198, 4, 158, 186, 22, 230, 150, 10, 234, 26, 53, 231,
            59, 229, 209, 111, 29, 247, 153, 102, 56, 51, 68, 108, 63, 139, 70, 215, 203, 233, 80,
            159, 68, 192, 77, 125, 50, 168, 8, 133, 64, 164, 204, 231, 211, 234, 229, 176, 139, 34,
            159, 233, 12, 43, 54, 73, 115, 213, 128, 121, 152, 183, 10, 238, 170, 56, 168, 232,
            105, 214, 138, 60, 85, 14, 173, 194, 111, 84, 59,
        ]),
        e: VarTestStruct {
            a: 49114,
            b: List::<u16, 1024>::from_iter([
                17251, 42508, 18514, 29700, 37188, 49814, 10247, 16616, 45265, 22033, 59763, 50534,
                11814, 7749, 44996, 40729, 3975, 11578, 47843, 37474, 58121, 42916, 34628, 60136,
                40308, 7411, 54556, 61192, 29267, 12158, 12718, 23535, 18819, 36543, 62603, 60332,
                26639, 18296, 57782, 50721, 2466, 22995, 17026, 35514, 63527, 38351, 64324, 17545,
                53468, 18647, 14189, 40652, 59800, 5715, 60799, 59201, 28715, 43677, 10699, 2031,
                3225, 13485, 20167, 46672, 17658, 47734, 38090, 64495, 42273, 63120, 42043, 11141,
                15945, 48804, 11778, 49143, 38655, 60802, 19087, 7281, 11581, 4701, 37464, 58761,
                61831, 53595, 54210, 47303, 34708, 50619, 49094, 64257, 49608, 12841, 46804, 28059,
                15780, 29245, 25921, 52872, 65361, 16061, 38807, 61018, 9378, 18444, 58957, 42772,
                4161, 4163, 31090, 60900, 1617, 17693, 44209, 6974, 7613, 23520, 30463, 206, 41442,
                53838, 4578, 31617, 43141, 36137, 48405, 61333, 3680, 10415, 55655, 11936, 12182,
                1001, 17018, 29022, 1733, 56289, 62343, 34374, 61605, 61655, 32922, 57362, 18718,
                37139, 13278, 40863, 49366, 55005, 29378, 37129, 25255, 10305, 26244, 11784, 55221,
                19507, 61288, 12417, 56620, 13229, 1531, 31029, 47441, 11462, 41878, 58026, 27743,
                151, 1889, 21134, 43711, 36750, 239, 45265, 36580, 2631, 63188, 49495, 22525,
                23580, 58949, 21751, 44573, 15334, 24328, 22796, 48483, 15819, 35459, 49130, 10832,
                49520, 12251, 43967, 38342, 7704, 29519, 54953, 16351, 28500, 42617, 53414, 49399,
                33370, 4408, 20331, 8029, 8522, 9842, 59594, 5094, 63546, 11898, 33364, 28400,
                27348, 45591, 19806, 27025, 38392, 17057, 35073, 3251, 27231, 38202, 100, 49246,
                51075, 21932, 41837, 24100, 17870, 26414, 59747, 60942, 6539, 32755, 62336, 15245,
                16189, 51684, 29212, 42977, 19124, 10456, 34969, 7414, 54571, 40351, 64920, 60389,
                58862, 61109, 42320, 7682, 53190, 54090, 23943, 6750, 4697, 42959, 25042, 54376,
                8897, 58655, 55312, 34545, 55234, 29446, 30272, 36565, 37024, 43609, 5810, 59589,
                8820, 13841, 57177, 26310, 57516, 23160, 60493, 31658, 32035, 62452, 39022, 39747,
                10057, 60247, 10562, 62921, 37069, 48243, 16449, 52502, 45952, 27489, 54865, 9759,
                21658, 5536, 52679, 18567, 11336, 54948, 19386, 7651, 39928, 28966, 52420, 37600,
                61748, 59013, 20081, 53920, 63614, 19487, 5340, 39983, 5208, 25179, 48097, 13860,
                62090, 10481, 35142, 18289, 29660, 24041, 40655, 49542, 16345, 145, 42552, 59030,
                48137, 16368, 64814, 46478, 55442, 1328, 49419, 61961, 48037, 4644, 22247, 30270,
                55366, 21514, 37698, 7204, 2525, 35271, 49325, 35490, 6561, 4124, 30715, 13418,
                54819, 25244, 6537, 53717, 45230, 60241, 28634, 29717, 30269, 13805, 1414, 22214,
                20820, 46126, 32598, 42835, 21463, 50476, 324, 64765, 60392, 45129, 37156, 33942,
                40448, 23612, 49207, 48599, 10022, 300, 4077, 31177, 14616, 56754, 11679, 24069,
                16237, 49219, 46328, 56166, 48865, 19340, 5131, 59010, 17167, 30618, 39272, 5419,
                6310, 20598, 10153, 721, 49473, 58040, 35182, 9549, 52950, 62261, 40739, 13700,
                1426, 29053, 1796, 35489, 21023, 48247, 21289, 59013, 50184, 20452, 54280, 51990,
                30518, 41701, 39461, 36530, 12429, 6373, 28738, 40072, 1336, 26925, 52827, 50656,
                33098, 58228, 4882, 45852, 9457, 60684, 60047, 37624, 51959, 26789, 54563, 48233,
                12000, 28461, 30950, 50831, 17824, 51787, 28146, 38163, 8207, 24983, 43136, 16177,
                1720, 48334, 21644, 21783, 21748, 17582, 8682, 45920, 40970, 31654, 46245, 51134,
                37615, 759, 3944, 11765, 22238, 27209, 56964, 9037, 51668, 43614, 36414, 4536,
                31035, 60731, 50565, 64499, 4110, 40696, 22922, 2538, 33658, 62063, 29639, 47197,
                34207, 31416, 50155, 6461, 58911, 30431, 14980, 34093, 45617, 51832, 25671, 5305,
                12637, 36838, 4833, 247, 57931, 48875, 61050, 41894, 57368, 1232, 21162, 18768,
                49029, 56047, 48278, 61767, 17390, 62828, 13436, 48808, 9550, 64407, 61055, 353,
                34903, 45727, 21903, 53375, 42276, 3601, 51842, 26075, 7489, 58453, 45296, 11426,
                53357, 50119, 51128, 8758, 5839, 21714, 59299, 4907, 34596, 13904, 58278, 4884,
                48699, 24896, 15523, 7905, 14118, 34527, 34842, 44738, 51775, 22045, 5145, 7475,
                40457, 10800, 48415, 64458, 53340, 54244, 23859, 7494, 10567, 8991, 8367, 50628,
                32921, 23202, 9193, 57765, 17072, 6162, 19554, 49794, 42946, 41637, 45096, 50762,
                6979, 59327, 5360, 55734, 32340, 23236, 44200, 7516, 15743, 26512, 50931, 35732,
                51748, 60219, 44079, 46535, 33852, 34657, 22875, 62040, 48952, 47488, 48481, 60482,
                46378, 11826, 43226, 3385, 26380, 9793, 31416, 9898, 15571, 15540, 12671, 3728,
                45270, 64625, 4563, 18414, 45638, 17397, 4114, 8195, 12843, 31882, 40991, 57993,
                37860, 45713, 60938, 9671, 57166, 11189, 17359, 7073, 47656, 28523, 17266, 38659,
                61827, 16761, 60709, 804, 12466, 17086, 26509, 19888, 24374, 24913, 16858, 27344,
                7026, 64568, 35796, 22094, 25621, 14621, 25041, 13731, 33591, 58785, 22586, 60945,
                52044, 32819, 42796, 9196, 53834, 39936, 40525, 20393, 57397, 37063, 13281, 29176,
                26092, 18325, 16986, 3682, 19281, 52256, 19311, 49412, 21951, 38980, 14479, 33705,
                7439, 24631, 25653, 53861, 48986, 35070, 33414, 12188, 39654, 53542, 59446, 15833,
                19512, 36859, 18609, 46937, 56171, 65121, 52136, 63850, 21651, 6903, 50095, 64861,
                65086, 59128, 47546, 56114, 40490, 61307, 44285, 23127, 53374, 11726, 13948, 17557,
                20560, 28420, 49563, 53395, 48735, 59699, 18910, 40441, 31818, 65308, 9992, 49220,
                4902, 37443, 11376, 55511, 31729, 20730, 24161, 61530, 55607, 35083, 62505, 41292,
                62622, 63875, 25101, 7094, 43058, 29347, 7897, 45444, 63411, 49477, 55649, 16899,
                29654, 60380, 52861, 2299, 47898, 24274, 32152, 27113, 53276, 63817, 26359, 26556,
                37284, 63007, 44210, 25181, 58139, 10848, 15839, 29052, 28828, 63240, 14802, 13330,
                10366, 10402, 33278, 62674, 13234, 57939, 9554, 65518, 36680, 42047, 53028, 56779,
                59946, 7255, 25348, 3509, 45840, 9611, 64878, 57639, 12394, 11460, 12483, 24930,
                59521, 51658, 30353, 764, 16910, 44809, 27857, 13898, 2503, 13826, 3514, 28881,
                45999, 61908, 17381, 51638, 9481, 44231, 58028, 60061, 8495, 49259, 62768, 63702,
                41785, 19414, 41494, 63755, 45857, 43960, 28875, 43556, 39644, 22248, 5844, 28605,
                234, 56916, 48525, 59507, 50250, 43682, 17410, 1938, 20700, 63290, 44546, 15914,
                414, 65269, 6803, 7991, 21773, 5459, 3330, 44052, 52104, 31971, 62125, 11619,
                55175, 44484, 17914, 62703, 48459, 38801, 44015, 45141, 25163, 24736, 29823, 46864,
                59561, 16623, 6586, 63322, 4398, 63106, 8044, 60786, 64815, 14764, 9459, 49278,
                27004, 44027, 19722, 24129, 20006, 19138, 13661, 60178, 46734, 45671, 63760, 17760,
                58343, 31831, 11580, 48968, 62985, 8828, 31788, 55767, 35067, 43696, 52449, 47258,
                43438, 24491, 64633, 60541, 60013, 38233, 2727, 25568, 9007, 61857, 47530, 59925,
                48777, 17026, 21715, 29400, 64469, 11153, 37176, 23453, 54585, 15212, 28450, 58783,
                27610, 9440, 53245, 11353, 15589, 6929, 22334, 12628, 34556, 43656, 58775, 27840,
                4056, 45993, 37973, 65389, 35167, 21854, 44460, 23386, 63009, 623, 59714, 31298,
                60028, 37190, 16501, 45325, 42475, 35713, 44411, 8359, 191, 5877, 38981, 56831,
                51178, 16904, 11348, 26265, 30491, 34503, 33817, 21091, 38326, 60471, 37690, 22688,
                30657, 25218, 55009, 4431, 42249, 52815, 27293, 29437, 18365, 28062, 43652, 58427,
                37517, 31197, 5756,
            ]),
            c: 225,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 33,
                b: 7895405943655935510,
                c: 2142447552,
            },
            FixedTestStruct {
                a: 22,
                b: 18002124139429285600,
                c: 992281172,
            },
            FixedTestStruct {
                a: 233,
                b: 4015541180465670820,
                c: 859454356,
            },
            FixedTestStruct {
                a: 189,
                b: 6174994657624261209,
                c: 2497554522,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 43514,
                b: List::<u16, 1024>::from_iter([
                    44929, 30752, 18611, 33923, 42378, 2509, 29985, 3365, 50241, 47603, 5913,
                    64265, 60191, 4381, 60195, 52257, 8319, 17226, 33510, 21910, 36008, 47181,
                    46498, 62647, 64293, 8237, 52988, 8429, 30288, 61242, 15886, 20878, 36914,
                    26985, 15918, 22455, 15111, 57579, 40171, 51379, 22865, 123, 18539, 12775,
                    37124, 37183, 53672, 62981, 15213, 52534, 57669, 55561, 44128, 63745, 4987,
                    10918, 59584, 50536, 16194, 9955, 8000, 29145, 26491, 786, 36659, 49852, 39488,
                    50223, 47115, 51898, 43073, 13749, 17473, 46325, 12986, 52878, 55953, 33529,
                    25698, 52805, 16878, 44039, 57282, 33653, 44329, 32550, 19413, 82, 23578,
                    13014, 18528, 4571, 25938, 34107, 41657, 49230, 45622, 61743, 11037, 3616,
                    33212, 48356, 62391, 19786, 46850, 65063, 11554, 24158, 19176, 37583, 17948,
                    35746, 14283, 57465, 102, 11464, 50353, 32463, 47838, 32814, 13447, 822, 38429,
                    35887, 2772, 8249, 56418, 58329, 54021, 7154, 46271, 64647, 41844, 48320,
                    14849, 3687, 49835, 42697, 13874, 24482, 47331, 12997, 64447, 5167, 27444,
                    10449, 47009, 7033, 13668, 26509, 25931, 43616, 63274, 25197, 51924, 49903,
                    7615, 31087, 40684, 23690, 9220, 28555, 29352, 25147, 56359, 36049, 59553,
                    50161, 11636, 56402, 63944, 32999, 52526, 62197, 32598, 33275, 39413, 55734,
                    12599, 4706, 17357, 16499, 24072, 45395, 37698, 19098, 61210, 30590, 18064,
                    30783, 30295, 35121, 46037, 6084, 53354, 21791, 53214, 56948, 28048, 5076,
                    21893, 24443, 17012, 46505, 46280, 18781, 15365, 56811, 31155, 38242, 55163,
                    1292, 46542, 61963, 57289, 33038, 25, 52081, 19091, 21069, 40486, 10108, 50677,
                    61918, 12707, 57257, 50555, 33418, 45330, 40647, 8896, 26080, 61907, 41936,
                    65462, 54584, 44126, 58851, 50207, 56923, 31992, 47721, 39634, 25590, 41214,
                    58032, 60938, 65307, 43968, 48752, 61391, 45034, 35633, 31588, 61227, 35019,
                    16819, 20542, 12794, 53649, 58554, 61746, 57647, 14215, 51870, 10050, 61221,
                    58773, 60195, 48726, 29889, 15079, 10043, 29019, 18899, 26012, 16401, 43855,
                    63069, 61647, 7136, 38241, 60104, 9587, 29410, 42343, 64967, 29170, 64150,
                    38526, 25994, 7673, 23210, 45043, 24277, 54115, 28303, 60073, 43737, 6031,
                    5668, 9942, 33665, 26797, 17533, 16820, 3934, 35458, 14911, 17753, 13280,
                    36501, 26329, 26322, 30341, 2296, 58472, 50252, 59069, 32304, 40320, 60379,
                    31350, 53792, 36106, 30614, 47433, 29400, 64251, 46079, 49796, 24230, 4133,
                    21292, 5622, 63441, 9734, 11309, 23719, 36631, 15990, 21734, 14415, 46842,
                    15892, 58514, 38528, 15405, 61022, 58050, 36243, 54661, 47638, 46619, 582,
                    33621, 48483, 40371, 7615, 27816, 40494, 8444, 15942, 56895, 63904, 27589,
                    45724, 5517, 8583, 1408, 16277, 29648, 21671, 52503, 10429, 127, 57791, 64595,
                    1080, 56974, 27077, 12897, 30626, 36821, 29051, 18500, 4435, 50958, 39340,
                    49621, 1815, 39985, 15934, 36779, 31123, 40005, 7579, 2729, 16836, 18032,
                    16973, 65285, 45233, 30934, 36170, 17047, 31875, 48463, 54787, 6987, 64265,
                    44516, 21404, 56981, 744, 11853, 63861, 15589, 56897, 48055, 64377, 22937,
                    57003, 39575, 47030, 55396, 52461, 61589, 54249, 8930, 57564, 46031, 14112,
                    17047, 46471, 10174, 4365, 38415, 52948, 62715, 50041, 51973, 5434, 38061,
                    13272, 38028, 53130, 9475, 40016, 53229, 44076, 59783, 50717, 52603, 21009,
                    5486, 2882, 28565, 63564, 62037, 25490, 24691, 24607, 5621, 19278, 24466,
                    63721, 2018, 51647, 60634, 44402, 47470, 47072, 17539, 135, 53327, 23611,
                    20733, 22085, 54828, 15090, 36469, 15332, 47031, 30378, 60277, 56027, 64012,
                    60593, 38235, 50743, 25902, 28555, 27334, 2510, 57558, 27016, 51477, 58571,
                    26172, 21974, 44733, 31867, 46300, 31581, 10817, 47280, 832, 57432, 58641,
                    11027, 59896, 10055, 26070, 3080, 12709, 64316, 3767, 58757, 57262, 4204,
                    58619, 27596, 14356, 35646, 23127, 44044, 53508, 3610, 36884, 17507, 12074,
                    11208, 33905, 8226, 14953, 41716, 25979, 51091, 48156, 15384, 35348, 44355,
                    12326, 7498, 36711, 12992, 55385, 34691, 62028, 19985, 61393, 40828, 2746,
                    39141, 17945, 41555, 48287, 20246, 46809, 14012, 39185, 11904, 22606, 44276,
                    53015, 6490, 39924, 38071, 57, 57429, 64938, 4268, 5449, 40144, 27066, 61075,
                    61940, 32308, 60455, 61326, 3704, 18303, 30834, 49426, 40648, 3853, 15653,
                    59446, 11292, 24688, 14809, 39266, 23286, 18076, 28768, 42746, 21868, 30207,
                    43299, 295, 63809, 7898, 17956, 11152, 21166, 48415, 39014, 15134, 9903, 63926,
                    55808, 24506, 60151, 38258, 2493, 35633, 12629, 13802, 30066, 43022, 17022,
                    57377, 64704, 5218, 50170, 3626, 39697, 10087, 65530, 12033, 36422, 1738,
                    13477, 54184, 41538, 53862, 47159, 5054, 14755, 45002, 5923, 12309, 37642,
                    16496, 22221, 18096, 15132, 8706, 48927, 45233, 51246, 45951, 9304, 34730,
                    65138, 977, 22085, 5862, 19270, 44460, 32874, 46327, 2470, 31874, 31561, 51392,
                    63663, 39078, 47218, 26605, 44663, 20032, 25580, 40333, 11381, 6134, 59631,
                    62556, 30404, 21469, 47247, 17795, 60489, 28995, 28004, 20490, 49065, 58104,
                    49330, 44478, 20236, 35917, 55248, 52762, 42524, 8396, 44134, 834, 7430, 33391,
                    28342, 19492, 45311, 6693, 7460, 9854, 18115, 23170, 211, 37705, 44710, 62170,
                    31886, 42590, 27309, 47771, 44016, 63865, 8484, 34894, 1651, 26264, 5124,
                    11162, 6808, 55565, 29031, 12438, 41303, 2913, 53350, 63673, 3118, 35006, 1560,
                    41136, 9071, 48506, 26910, 8327, 50345, 11163, 32280, 57420, 17556, 60816,
                    62894, 30395, 46223, 59297, 877, 27721, 14567, 33419, 42989, 64345, 43782,
                    36821, 25086, 10936, 29852, 59570, 25167, 48388, 5439, 50086, 26667, 19198,
                    59999, 63908, 18939, 3288, 65474, 42233, 1275, 2482, 30837, 15496, 61442,
                    28819, 20642, 28771, 46764, 65050, 30458, 53280, 60533, 55758, 59964, 18259,
                    34340, 53025, 31538, 37279, 41182, 11296, 5643, 40366, 17387, 44647, 3594,
                    4213, 41261, 10591, 29018, 23062, 11618, 1835, 9568, 167, 40975, 39561, 56241,
                    401, 18785, 53649, 47883, 29046, 47341, 63404, 15977, 30583, 36011, 31855,
                    52845, 10150, 6787, 17672, 4477, 61969, 52631, 6184, 63642, 22364, 62169,
                    31625, 51560, 50011, 8227, 37511, 23559, 4669, 4964, 27604, 50319, 38388,
                    46510, 52492, 38035, 1031, 60402, 41494, 43197, 25190, 40897, 47219, 2238,
                    51849, 52927, 64336, 23334, 38427, 34965, 51550, 59912, 45050, 2844, 39823,
                    20736, 59971, 34176, 957, 43590, 42759, 3365, 31964, 43493, 13553, 734, 58623,
                    16200, 38891, 58853, 48898, 6316, 53870, 45180, 55957, 64555, 50314, 61629,
                    53066, 36801, 42586, 44949, 7538, 43423, 2596, 22043, 53557, 64701, 42047,
                    32789, 5268, 44885, 15096, 29614, 52876, 27126, 50054, 29134, 53293, 39797,
                    19175, 13041, 16193, 45162, 17525, 51257, 29010, 40224, 21154, 48391, 27566,
                    55429, 50281, 15376, 12502, 41158, 18230, 35230, 19043, 62323, 48364, 3745,
                    4973, 36283, 56399, 60725, 19185, 18415, 11590, 57600, 16803, 3642, 17928,
                    50785, 15806, 50179, 35140, 38046, 1935, 18014, 63215, 21927, 4544, 51981,
                    43741, 12769, 47671, 22865, 40754, 39025, 41145, 2491, 38647, 8947, 64839,
                    11809, 45553, 49738, 21659, 26393, 52991, 22242, 42192, 11540, 12394, 23926,
                    52867, 5820, 39167, 603, 65512, 18700, 64200, 16923, 53878, 53091, 8102, 49033,
                    30448, 46268, 9209, 30771, 58698, 16693, 43514, 33212, 27521, 12052, 13213,
                    53117, 13466, 1428, 20468, 40192, 29634, 23425, 17430, 22188, 16160, 23704,
                    24888, 25431, 33689, 44304, 62530, 44649, 29854, 58068, 16506, 50867,
                ]),
                c: 137,
            },
            VarTestStruct {
                a: 682,
                b: List::<u16, 1024>::from_iter([
                    51885, 64263, 59471, 10232, 10988, 50916, 6958, 21670, 35134, 15072, 23280,
                    50462, 43383, 53899, 13108, 31128, 5505, 18184, 21356, 28188, 53305, 8847,
                    10739, 16128, 61911, 34784, 57065, 27155, 36478, 34699, 47869, 2809, 19476,
                    1397, 15487, 35488, 23, 22699, 52499, 19378, 21941, 54265, 40593, 12644, 19667,
                    7302, 19220, 31616, 2470, 58308, 1193, 55829, 50929, 34118, 21280, 15378,
                    50725, 47052, 9451, 45938, 1869, 6637, 60820, 55589, 9551, 21625, 43601, 60493,
                    30261, 39640, 28761, 996, 45975, 24842, 60244, 58729, 11108, 42608, 46292,
                    25125, 60270, 39690, 1076, 60639, 56960, 7720, 37861, 40753, 47845, 35041,
                    56018, 49755, 44315, 15042, 52793, 18360, 30950, 15097, 52572, 10356, 25489,
                    37421, 54132, 30301, 50787, 21191, 30707, 4946, 19194, 32760, 24736, 1766,
                    28215, 54927, 56821, 32308, 18946, 19539, 31501, 2375, 14640, 9334, 28531,
                    2697, 9467, 64218, 57413, 6241, 37805, 42121, 26541, 54921, 22415, 35303,
                    24179, 18096, 57569, 20836, 7405, 1758, 14013, 50213, 32026, 60545, 48861,
                    46476, 56929, 57331, 50772, 60598, 40803, 35821, 43306, 53095, 3944, 4212,
                    62082, 55523, 23353, 3974, 42011, 29962, 6263, 20121, 50439, 43564, 43261,
                    10965, 48151, 21381, 53260, 16065, 23922, 44281, 62627, 57237, 18526, 61645,
                    61077, 27717, 52090, 9608, 40498, 54711, 55615, 51509, 49660, 26278, 51028,
                    20895, 24827, 32886, 57697, 4674, 39051, 10962, 35300, 57721, 54688, 18565,
                    39842, 29788, 32053, 22380, 29836, 53893, 17207, 6061, 11221, 1194, 13836, 166,
                    13341, 782, 65149, 51559, 13117, 50973, 6819, 39517, 9190, 36922, 20984, 32148,
                    17045, 34135, 12829, 55755, 22114, 60340, 47395, 64043, 15088, 7884, 44870,
                    37497, 23095, 11086, 14518, 14300, 17229, 22719, 32005, 20226, 22845, 33504,
                    65282, 46550, 59392, 22698, 62835, 42428, 5068, 33090, 25260, 24764, 19840,
                    11692, 10560, 15428, 5894, 36469, 1089, 18994, 24909, 28358, 45786, 6063,
                    37124, 6321, 12738, 46859, 7161, 7693, 15449, 47911, 18069, 33817, 11638,
                    19572, 16039, 30263, 56367, 55980, 17991, 38577, 28211, 43408, 30378, 4345,
                    12764, 12458, 37452, 61647, 51060, 45889, 46747, 21824, 59021, 29810, 17627,
                    12337, 15913, 41355, 36459, 50584, 50129, 18982, 14832, 63847, 19279, 26971,
                    56370, 48373, 16912, 36070, 57668, 42596, 32202, 53388, 39568, 24270, 2259,
                    35974, 16621, 22901, 14438, 29774, 18843, 60286, 1239, 21090, 28745, 8214,
                    48803, 64351, 47989, 59081, 13531, 2872, 38635, 55266, 14755, 13172, 50033,
                    4353, 57725, 4297, 17288, 55870, 49440, 31800, 24358, 38203, 48116, 24772,
                    3315, 55547, 44020, 18630, 20230, 19876, 28408, 1924, 58984, 51871, 36020, 111,
                    23865, 21119, 43187, 12476, 42920, 58671, 50266, 38301, 21021, 53483, 57848,
                    52284, 2509, 5276, 63897, 12814, 53021, 4521, 39886, 49102, 30061, 20411, 666,
                    54133, 51846, 61860, 8960, 1839, 5891, 51375, 31913, 42988, 35667, 33502,
                    49102, 63568, 6948, 37589, 6977, 35862, 25374, 42700, 25442, 34339, 30825,
                    11402, 2238, 5023, 53468, 36891, 53547, 34426, 35798, 47379, 46436, 61636,
                    14672, 9365, 519, 44847, 33250, 15883, 52001, 30298, 49425, 62052, 29692, 3220,
                    59012, 53021, 42723, 18904, 6964, 57080, 43094, 4915, 59830, 18105, 61872,
                    49925, 9381, 14090, 39371, 7614, 8123, 14801, 38490, 52853, 50257, 39089,
                    15690, 15447, 4098, 56386, 26130, 231, 26085, 32434, 17354, 47890, 63094,
                    37814, 32048, 55738, 30158, 20459, 10093, 35827, 29829, 50064, 50011, 61362,
                    47261, 21484, 15125, 38043, 62612, 19606, 51279, 27319, 18406, 7711, 845,
                    54338, 20958, 51039, 40810, 9731, 32836, 54568, 43614, 6051, 47944, 46780,
                    51537, 34824, 20832, 34881, 34703, 52696, 48155, 63930, 4742, 35455, 18262,
                    10182, 31301, 53019, 803, 23919, 27315, 4054, 52737, 57889, 11976, 34740,
                    61283, 57961, 18743, 32607, 36146, 45068, 15976, 7589, 56094, 52212, 42864,
                    51759, 60716, 52478, 17328, 31212, 31782, 33630, 18143, 16914, 11151, 45393,
                    62488, 11174, 2731, 7811, 16857, 13971, 32459, 29734, 21508, 51784, 7179,
                    30676, 62897, 9707, 10244, 24367, 38336, 64284, 22535, 52716, 4914, 20226,
                    9250, 26509, 37163, 32899, 11797, 12143, 60148, 10285, 51091, 59231, 58976,
                    27185, 40824, 5613, 61206, 21453, 8981, 1187, 10879, 24628, 12233, 50134,
                    27770, 47483, 26915, 37567, 50443, 22908, 63645, 23597, 54193, 36265, 35831,
                    21171, 40700, 30715, 14026, 1398, 30908, 59173, 42740, 391, 40363, 25100,
                    24888, 31788, 1734, 50025, 19157, 43650, 58603, 35709, 50590, 2355, 28139,
                    51402, 27056, 17200, 58397, 25369, 49671, 46315, 49881, 46069, 4322, 16821,
                    38447, 34348, 26915, 25296, 28276, 53083, 738, 50719, 56613, 21793, 26112,
                    20341, 31836, 62869, 40063, 49251, 61809, 5821, 18904, 4125, 47548, 2989,
                    23220, 49684, 4892, 10053, 6845, 12079, 62921, 30743, 9836, 7562, 10226, 27180,
                    9872, 24256, 37618, 49264, 65276, 19840, 38786, 65467, 38990, 51685, 38196,
                    36233, 21010, 9712, 51660, 17285, 3520, 45300, 8234, 41814, 8230, 55465, 24002,
                    58996, 23995, 44, 27612, 1222, 55582, 10288, 28682, 60622, 19721, 63749, 31297,
                    22461, 46685, 42796, 58295, 14193, 18000, 41708, 54061, 41703, 56889, 35306,
                    40604, 22650, 40998, 29928, 27296, 3660, 27725, 47601, 23060, 14650, 51366,
                    26083, 38630, 46456, 30454, 24209, 57674, 25704, 41440, 55637, 58976, 26635,
                    44228, 12119, 52000, 20399, 6701, 64592, 50326, 46284, 29129, 53831, 50111,
                    10335, 13313, 11975, 34380, 55759, 45047, 34983, 25479, 9928, 33349, 39667,
                    7734, 3954, 11141, 43034, 49650, 47595, 59460, 9821, 61240, 39396, 15182,
                    40374, 2819, 65045, 14458, 24008, 33989, 32244, 9364, 28902, 64745, 55628,
                    34632, 37123, 10154, 42704, 56249, 12742, 39102, 41559, 17601, 16326, 56500,
                    53232, 41076, 5494, 44174, 19277, 61369, 47611, 16724, 45709, 63909, 40888,
                    65105, 65129, 4969, 18388, 65266, 63157, 59069, 61299, 8618, 13986, 48325,
                    35023, 7554, 59183, 48032, 52445, 10594, 13892, 57451, 33565, 59449, 15262,
                    62237, 32499, 64405, 16602, 43535, 65166, 61425, 63533, 22577, 18731, 58541,
                    50128, 43280, 43412, 55138, 24121, 13639, 37875, 42162, 13233, 1047, 18374,
                    63928, 32265, 22846, 1742, 4661, 35350, 24643, 37514, 26525, 19847, 50411,
                    17293, 2973, 12739, 35014, 18078, 49176, 34885, 58976, 20349, 34040, 39699,
                    55457, 6496, 16798, 57469, 9813, 54291, 16887, 61271, 39207, 41101, 7050,
                    44552, 55398, 6230, 35660, 63164, 6822, 40135, 23987, 2031, 60381, 55977, 1477,
                    17703, 12113, 9730, 57047, 30788, 41837, 63418, 52850, 53543, 60557, 62675,
                    64384, 263, 53297, 32822, 56334, 62735, 1036, 17559, 12389, 43005, 10191,
                    25091, 11614, 11225, 60081, 10003, 22666, 46772, 53431, 44698, 33021, 3625,
                    6583, 57814, 3998, 6771, 37186, 62504, 14616, 8474, 46336, 6439, 43900, 14697,
                    11672, 9598, 22231, 43700, 33424, 43368, 42154, 60076, 50717, 47203, 38562,
                    55326, 10654, 31287, 20065, 21512, 11599, 57976, 9811, 26964, 62980, 803,
                    63189, 12274, 62802, 44802, 45384, 10276, 19558, 16547, 18209, 30466, 17486,
                    4231, 28724, 28061, 24595, 20195, 10892, 4686, 60117, 24328, 30101, 15432,
                    9795, 39252, 2615, 44553, 19023, 49900, 43334, 47979, 63896, 19809, 53601,
                    9421, 37053, 19118, 12297, 61584, 62299, 48690, 61172, 8422, 46287, 35075,
                    27211, 2026, 62737, 47333, 44598, 5456, 49090, 61830, 36327, 60356, 30742,
                    32377, 40148, 27936, 58838, 20097, 49658, 37537, 25700, 45346, 63345, 65132,
                ]),
                c: 150,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data("ssz_rs/tests/data/containers/valid/ComplexTestStruct_lengthy_chaos_1/serialized.ssz_snappy");
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("9e8d9f5d5a03974171cc977eb7fc10305f1bee1b469a11974f25424d8e518773");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_nil_5() {
    let value = ComplexTestStruct {
        a: 31744,
        b: List::<u16, 128>::from_iter([]),
        c: 33,
        d: List::<u8, 256>::from_iter([]),
        e: VarTestStruct {
            a: 32909,
            b: List::<u16, 1024>::from_iter([]),
            c: 160,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 88,
                b: 4508311636793282544,
                c: 415305280,
            },
            FixedTestStruct {
                a: 81,
                b: 7176574044321399517,
                c: 3531697000,
            },
            FixedTestStruct {
                a: 148,
                b: 10325477718060625155,
                c: 2170710618,
            },
            FixedTestStruct {
                a: 213,
                b: 10147841225099919266,
                c: 364863742,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 44590,
                b: List::<u16, 1024>::from_iter([]),
                c: 43,
            },
            VarTestStruct {
                a: 2413,
                b: List::<u16, 1024>::from_iter([]),
                c: 252,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_nil_5/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("d3339dcf8b5c37412b46d01fad924e5f5baafbd8ef6fb5e7d32cda58a8184e2c");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_max_chaos_0() {
    let value = VarTestStruct {
        a: 65535,
        b: List::<u16, 1024>::from_iter([
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535,
        ]),
        c: 255,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_max_chaos_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("c3e720d29dc4e4baa5cbad059f4eb0b99189c911dcede2863bb5b77795c5cc3d");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_nil_2() {
    let value = ComplexTestStruct {
        a: 51296,
        b: List::<u16, 128>::from_iter([]),
        c: 24,
        d: List::<u8, 256>::from_iter([]),
        e: VarTestStruct {
            a: 53715,
            b: List::<u16, 1024>::from_iter([]),
            c: 87,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 112,
                b: 6113442914607827252,
                c: 2881063212,
            },
            FixedTestStruct {
                a: 51,
                b: 1725127278526211301,
                c: 638134721,
            },
            FixedTestStruct {
                a: 217,
                b: 14421469423501165880,
                c: 3735440152,
            },
            FixedTestStruct {
                a: 123,
                b: 2364172394143535253,
                c: 3578914154,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 28075,
                b: List::<u16, 1024>::from_iter([]),
                c: 109,
            },
            VarTestStruct {
                a: 52080,
                b: List::<u16, 1024>::from_iter([]),
                c: 183,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_nil_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("3009a7b09039d85079b9a29358d237bbd3fbeb4c25d05bc9da326188342995a3");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_nil_chaos_1() {
    let value = ComplexTestStruct {
        a: 16389,
        b: List::<u16, 128>::from_iter([]),
        c: 229,
        d: List::<u8, 256>::from_iter([]),
        e: VarTestStruct {
            a: 60733,
            b: List::<u16, 1024>::from_iter([]),
            c: 201,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 2,
                b: 384053484578005994,
                c: 870669292,
            },
            FixedTestStruct {
                a: 192,
                b: 8050360655543648157,
                c: 2676129625,
            },
            FixedTestStruct {
                a: 68,
                b: 3997619651490197308,
                c: 793030358,
            },
            FixedTestStruct {
                a: 214,
                b: 14099480025000544619,
                c: 1206054754,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 23399,
                b: List::<u16, 1024>::from_iter([]),
                c: 162,
            },
            VarTestStruct {
                a: 6205,
                b: List::<u16, 1024>::from_iter([]),
                c: 80,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_nil_chaos_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("b89f29dc5910fc88db50b3b75245371c139f5f927a522da5ad4ac100a40aae77");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_max() {
    let value = VarTestStruct {
        a: 65535,
        b: List::<u16, 1024>::from_iter([
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
        ]),
        c: 255,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_max/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("d9824eb3449dabb9f62c69e72c5e5ba5917a1d68e679557e3fd1cb0cfdc38d17");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_small_test_struct_zero_4() {
    let value = SmallTestStruct { a: 0, b: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SmallTestStruct_zero_4/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SmallTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("f5a5fd42d16a20302798ef6ed309979b43003d2320d9f0e8ea9831a92759fb4b");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_small_test_struct_zero_3() {
    let value = SmallTestStruct { a: 0, b: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SmallTestStruct_zero_3/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SmallTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("f5a5fd42d16a20302798ef6ed309979b43003d2320d9f0e8ea9831a92759fb4b");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_zero() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([false, false, false, false]),
        b: Bitvector::<2>::from_iter([false, false]),
        c: Bitvector::<1>::from_iter([false]),
        d: Bitlist::<6>::from_iter([false, false]),
        e: Bitvector::<8>::from_iter([false, false, false, false, false, false, false, false]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_zero/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("7aa68d25017352ef95142af2bb269ce805269676da6111d74887aa9cdcb072a4");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_max_2() {
    let value = FixedTestStruct {
        a: 255,
        b: 18446744073709551615,
        c: 4294967295,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_max_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("3925681862db7892428eac4afae08671930e623601b5b85fbbc366371e29acd7");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_random_chaos_0() {
    let value = SingleFieldTestStruct { a: 15 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data("ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_random_chaos_0/serialized.ssz_snappy");
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("0f00000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_max_5() {
    let value = FixedTestStruct {
        a: 255,
        b: 18446744073709551615,
        c: 4294967295,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_max_5/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("3925681862db7892428eac4afae08671930e623601b5b85fbbc366371e29acd7");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_random_chaos_0() {
    let value = FixedTestStruct {
        a: 162,
        b: 17433115223182371175,
        c: 867140057,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_random_chaos_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("dc82cc007c637f89a9b7ba1c446f17f598663637c51c774d3b988b5f27d6556c");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_small_test_struct_zero_chaos_1() {
    let value = SmallTestStruct { a: 0, b: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SmallTestStruct_zero_chaos_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SmallTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("f5a5fd42d16a20302798ef6ed309979b43003d2320d9f0e8ea9831a92759fb4b");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_zero() {
    let value = VarTestStruct {
        a: 0,
        b: List::<u16, 1024>::from_iter([
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        ]),
        c: 0,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_zero/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("7b7591e4bc71e165eadd3cab254795eb03ce695be7e531a9e601bc3327c3fd6e");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_small_test_struct_zero_2() {
    let value = SmallTestStruct { a: 0, b: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SmallTestStruct_zero_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SmallTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("f5a5fd42d16a20302798ef6ed309979b43003d2320d9f0e8ea9831a92759fb4b");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_small_test_struct_zero_5() {
    let value = SmallTestStruct { a: 0, b: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SmallTestStruct_zero_5/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SmallTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("f5a5fd42d16a20302798ef6ed309979b43003d2320d9f0e8ea9831a92759fb4b");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_nil_3() {
    let value = ComplexTestStruct {
        a: 59736,
        b: List::<u16, 128>::from_iter([]),
        c: 120,
        d: List::<u8, 256>::from_iter([]),
        e: VarTestStruct {
            a: 9471,
            b: List::<u16, 1024>::from_iter([]),
            c: 162,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 220,
                b: 15034598248334105810,
                c: 3955824760,
            },
            FixedTestStruct {
                a: 175,
                b: 17553500545866453449,
                c: 542828098,
            },
            FixedTestStruct {
                a: 140,
                b: 2940978812180365208,
                c: 3410385304,
            },
            FixedTestStruct {
                a: 219,
                b: 13559886729958279487,
                c: 3025496256,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 34009,
                b: List::<u16, 1024>::from_iter([]),
                c: 98,
            },
            VarTestStruct {
                a: 55878,
                b: List::<u16, 1024>::from_iter([]),
                c: 150,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_nil_3/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("39b4d31246afbdb07fd955fdf5d982bd832714cbed6666fd7ef47379cf947275");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_nil_chaos_0() {
    let value = ComplexTestStruct {
        a: 6980,
        b: List::<u16, 128>::from_iter([]),
        c: 27,
        d: List::<u8, 256>::from_iter([]),
        e: VarTestStruct {
            a: 25023,
            b: List::<u16, 1024>::from_iter([]),
            c: 192,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 232,
                b: 3780683719095057064,
                c: 1934241831,
            },
            FixedTestStruct {
                a: 138,
                b: 5487763393146156444,
                c: 1481858532,
            },
            FixedTestStruct {
                a: 183,
                b: 6392067212513580675,
                c: 1590857235,
            },
            FixedTestStruct {
                a: 215,
                b: 10047526190675975666,
                c: 3987494123,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 17308,
                b: List::<u16, 1024>::from_iter([]),
                c: 78,
            },
            VarTestStruct {
                a: 23441,
                b: List::<u16, 1024>::from_iter([]),
                c: 130,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_nil_chaos_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("5bc8bd92a0d88a9a3b388b7109e8294ec4c24fd9e2ccc6fd9021c36a2acf77df");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_max_chaos_1() {
    let value = VarTestStruct {
        a: 65535,
        b: List::<u16, 1024>::from_iter([
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
            65535, 65535, 65535, 65535, 65535, 65535, 65535,
        ]),
        c: 255,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_max_chaos_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("fd31fbb40e94c30fa8fe09c0055e48d66a2d142c1a3213086d902067eaa8b8de");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_nil_4() {
    let value = ComplexTestStruct {
        a: 44905,
        b: List::<u16, 128>::from_iter([]),
        c: 144,
        d: List::<u8, 256>::from_iter([]),
        e: VarTestStruct {
            a: 35688,
            b: List::<u16, 1024>::from_iter([]),
            c: 125,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 102,
                b: 1970672590229388203,
                c: 4291083769,
            },
            FixedTestStruct {
                a: 20,
                b: 17267026789235764353,
                c: 4169619511,
            },
            FixedTestStruct {
                a: 174,
                b: 16712701607286209302,
                c: 1877382468,
            },
            FixedTestStruct {
                a: 216,
                b: 3418735781718036586,
                c: 3896879220,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 37923,
                b: List::<u16, 1024>::from_iter([]),
                c: 146,
            },
            VarTestStruct {
                a: 31848,
                b: List::<u16, 1024>::from_iter([]),
                c: 206,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_nil_4/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("fcad01afa41478c73d86c160078d557a11aec6425bdd91de7909ad735e8b2151");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_small_test_struct_zero_chaos_0() {
    let value = SmallTestStruct { a: 0, b: 0 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SmallTestStruct_zero_chaos_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SmallTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("f5a5fd42d16a20302798ef6ed309979b43003d2320d9f0e8ea9831a92759fb4b");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_random_chaos_1() {
    let value = FixedTestStruct {
        a: 203,
        b: 7769282278803472418,
        c: 872994431,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_random_chaos_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("b4bd04eda485b869dcaebd603d86834d9e70885e7e061df343aaf753f4252267");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_max_4() {
    let value = FixedTestStruct {
        a: 255,
        b: 18446744073709551615,
        c: 4294967295,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_max_4/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("3925681862db7892428eac4afae08671930e623601b5b85fbbc366371e29acd7");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_random_chaos_1() {
    let value = SingleFieldTestStruct { a: 8 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data("ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_random_chaos_1/serialized.ssz_snappy");
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("0800000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_fixed_test_struct_max_3() {
    let value = FixedTestStruct {
        a: 255,
        b: 18446744073709551615,
        c: 4294967295,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/FixedTestStruct_max_3/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: FixedTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("3925681862db7892428eac4afae08671930e623601b5b85fbbc366371e29acd7");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_nil_6() {
    let value = VarTestStruct {
        a: 15781,
        b: List::<u16, 1024>::from_iter([]),
        c: 117,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_nil_6/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("7cee3918d516db214447c2cbbe0d0ddb54dd8f75652bfc15ec6abcf3363f8380");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_max_8() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([true, true]),
        b: Bitvector::<2>::from_iter([true, true]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([true, true, true, true]),
        e: Bitvector::<8>::from_iter([true, true, true, true, true, true, true, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_max_8/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("f369e7425a52cffdac341543d5368d4f233d155a29c2d0bfece3c159c0c6d120");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_random_chaos_0() {
    let value = VarTestStruct {
        a: 20024,
        b: List::<u16, 1024>::from_iter([
            50415, 14691, 1540, 5555, 46426, 5084, 61089, 64926, 6761, 37513, 65376, 54489, 38631,
            64061, 33211, 39189, 28466, 1332, 1554, 60180, 62555, 38396, 26765, 43012, 62762,
            30589, 48460, 10895, 56421, 25159, 29698, 17067, 8678, 12472, 47725, 3749, 47570,
            50091, 22530, 23836, 43479, 19416, 11628, 22769, 60042, 34077, 35784, 47253, 43942,
            9772, 34212, 2378, 12489, 26474, 16528, 16533, 43136, 46743, 65159, 7834, 30141, 32596,
            3266, 49003, 43483, 62933, 47066, 37184, 33265, 46946, 16943, 27682, 45667, 19897,
            54706, 48836, 34148, 32396, 36028, 48912, 13886, 38639, 46992, 20723, 47781, 35465,
            10823, 57601, 1941, 34947, 38289, 22401, 54022, 28605, 51426, 19729, 40588, 61870,
            54391, 64232, 57285, 51301, 19758, 31126, 44410, 30930, 6313, 49138, 12903, 16322,
            51595, 31209, 11794, 46535, 5848, 37369, 63523, 3558, 35933, 22237, 142, 43778, 35821,
            42856, 51226, 19815, 39110, 15431, 16405, 44153, 29090, 51086, 9234, 60264, 17812,
            6344, 34303, 23311, 60750, 58033, 8395, 8180, 32722, 53750, 36287, 62570, 64602, 59705,
            57045, 61207, 54829, 3065, 46226, 1560, 53855, 22350, 29676, 3772, 25197, 13154, 59467,
            63930, 40048, 24310, 40208, 53189, 25532, 64791, 22454, 22972, 28653, 53351, 14018,
            8485, 38100, 27994, 59238, 22096, 24263, 38404, 11698, 21448, 55749, 28552, 46457,
            52657, 16404, 37052, 50241, 13786, 62506, 16093, 37386, 32616, 38524, 57914, 48661,
            63601, 37180, 51208, 43958, 9767, 49984, 17679, 62702, 53779, 34764, 13121, 4593,
            19616, 41995, 47601, 7371, 36543, 25749, 25398, 43312, 20832, 23673, 62253, 26121,
            19417, 63338, 54080, 31067, 36783, 53706, 15264, 43824, 8798, 1952, 11873, 20518,
            48107, 37712, 18823, 44531, 46339, 56137, 12002, 11276, 46426, 745, 30352, 63135,
            23485, 24990, 32430, 22503, 41411, 8230, 60485, 22404, 47756, 53641, 49979, 2305,
            52034, 14948, 61653, 16465, 4249, 53323, 44208, 34030, 18885, 42284, 34426, 19697,
            25183, 18643, 7019, 16287, 44307, 11976, 61967, 58819, 4939, 30951, 15373, 6681, 51867,
            57236, 12452, 20489, 36178, 9375, 7957, 47229, 55450, 8476, 41892, 57441, 12676, 48849,
            55509, 16823, 14713, 37583, 3906, 27984, 6103, 11146, 41422, 33991, 36998, 28722,
            61620, 58500, 20239, 24700, 30944, 39324, 35678, 31245, 25501, 36776, 15269, 61951,
            25986, 10284, 21690, 19371, 27076, 6103, 15133, 32848, 33510, 29715, 10221, 55405,
            3326, 59714, 35267, 54121, 14463, 10658, 55319, 6384, 33895, 34788, 52269, 20990,
            54147, 25851, 37671, 2646, 58811, 32270, 12865, 5745, 22231, 37592, 24683, 35713,
            64178, 64745, 49797, 57194, 8938, 42369, 40919, 64981, 11992, 40631, 51280, 36044, 724,
            15176, 58869, 25607, 58137, 11295, 29772, 29624, 6228, 47820, 3888, 23260, 39392,
            35103, 60755, 3966, 63797, 15225, 61318, 15584, 28410, 54620, 36110, 8688, 44187,
            37597, 6195, 9016, 31273, 47347, 35568, 34638, 37937, 34637, 6290, 50656, 32033, 7226,
            42194, 39106, 45405, 21693, 16092, 41532, 30354, 20101, 54807, 2857, 25225, 59120,
            37677, 30770, 45447, 33102, 2848, 54737, 12462, 36100, 50324, 32606, 63236, 7644,
            34225, 12352, 9901, 19945, 58161, 9105, 30544, 11124, 4259, 35668, 26545, 38872, 2871,
            61528, 49217, 51832, 55311, 4775, 50206, 49568, 31800, 45043, 28182, 40021, 50302,
            54351, 58711, 9749, 15995, 41126, 7720, 26837, 13746, 364, 55098, 41456, 51557, 29385,
            47218, 20570, 41640, 28159, 2841, 31752, 10013, 21995, 3842, 19470, 28675, 3690, 7284,
            16943, 33767, 8536, 22033, 201, 58904, 23344, 34108, 62412, 56907, 4172, 36785, 42715,
            271, 62652, 44814, 19038, 7976, 48004, 41031, 46609, 44951, 4872, 10378, 18930, 14129,
            11708, 11881, 59959, 32809, 58896, 53672, 985, 23235, 1280, 11370, 22538, 39351, 6452,
            15922, 48776, 56179, 38162, 53453, 52079, 797, 19863, 56261, 10791, 61504, 26444,
            62127, 55636, 64896, 29736, 14065, 33222, 59271, 5846, 42300, 12082, 30435, 64814,
            52029, 6635, 53123, 52479, 46922, 24994, 31630, 8396, 59423, 28572, 8290, 23912, 31492,
            23390, 40482, 1652, 65141, 34382, 54280, 60472, 19746, 55493, 7333, 61742, 5987, 55969,
            38802, 14359, 9375, 5217, 23375, 52290, 26364, 14036, 4643, 1013, 42628, 25715, 5971,
            8893, 54207, 46675, 38028, 52655, 45932, 9822, 20493, 61674, 46519, 19780, 12653,
            23509, 42351, 61998, 28007, 13971, 51891, 21116, 56354, 52227, 59588, 34446, 14469,
            37872, 53026, 18392, 61418, 57965, 62668, 8188, 42144, 47393, 26705, 9921, 11523,
            56812, 19431, 50364, 9013, 29260, 44454, 65216, 40307, 1063, 43485, 60618, 45733,
            51501, 28449, 16594, 10928, 47410, 21681, 31153, 30097, 60080, 49023, 52491, 3945,
            57808, 54839, 36504, 35123, 30218, 58562, 30454, 37844, 54997, 513, 56026, 64204,
            38384, 49152, 40185, 6928, 16068, 56296, 53210, 23605, 38802, 49598, 47446, 31348,
            31550, 46591, 62197, 2669, 20287, 57718, 36655, 27269, 51400, 48442, 27975, 46763,
            10527, 50308, 42448, 19874, 18138, 51635, 58006, 38255, 51009, 62755, 14112, 35672,
            27854, 43031, 36589, 59735, 62582, 28040, 51998, 11989, 37834, 41908, 48241, 13171, 96,
            38848, 58155, 57830, 41327, 50369, 7856, 1473, 39120, 14950, 19766, 710, 35895, 63926,
            53754, 44439, 50890, 23436, 57338, 35649, 45566, 35096, 1123, 58337, 7029, 16698, 3943,
            1713, 15092, 18684, 28021, 22657, 34189, 25908, 5271, 45891, 52860, 22869, 8127, 26735,
            13878, 727, 51438, 32697, 23508, 33799, 19428, 15029, 32220, 63704, 51499, 32641,
            17782, 2682, 19613, 13697, 22936, 41355, 44057, 12931, 52143, 47752, 25775, 11560,
            16993, 55556, 3832, 27532, 4162, 57769, 7650, 14678, 56498, 12020, 32406, 41742, 45746,
            5239, 6406, 30538, 55791, 17912, 51183, 15024, 28913, 13700, 53146, 63430, 10696,
            58921, 33252, 24965, 50473, 53123, 59450, 56274, 41362, 56632, 64041, 22895, 21444,
            51595, 18083, 48767, 42830, 48904, 61484, 65024, 12885, 52640, 58779, 6173, 40261,
            9293, 62461, 16776, 18227, 13724, 16066, 50851, 59257, 19984, 61413, 33282, 12569,
            4993, 19577, 3057, 62153, 35490, 47457, 27443, 63944, 54061, 10348, 8850, 34907, 38465,
            20042, 38176, 42568, 6996, 6428, 47410, 56918, 34974, 34814, 7407, 14701, 19761, 17527,
            50845, 2668, 37404, 3025, 22121, 8684, 2157, 15368, 12666, 11467, 4879, 54456, 48970,
            36708, 46073, 28929, 3798, 36198, 6881, 24540, 65443, 25335, 10305, 41671, 4972, 59362,
            8608, 26819, 17, 51407, 38436, 17656, 41545, 47542, 47180, 53891, 41076, 15263, 15977,
            19388, 12888, 47317, 25290, 30845, 5782, 11387, 27731, 52330, 50002, 7994, 45787,
            60505, 49357, 41204, 3012, 59708, 15620, 24226, 11859, 58417, 56933, 46387, 36134,
            26079, 30691, 60054, 10899, 100, 16926, 6627, 46467, 19482, 37558, 17398, 26372, 61721,
            61304, 4540,
        ]),
        c: 245,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_random_chaos_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("686b4990347887370f9ad5116ce942ea8bb7f752a959fcee547af5655075a358");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_one_5() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([true]),
        b: Bitvector::<2>::from_iter([false, false]),
        c: Bitvector::<1>::from_iter([false]),
        d: Bitlist::<6>::from_iter([true]),
        e: Bitvector::<8>::from_iter([true, false, true, true, false, true, false, false]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_one_5/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("0a9f6477919000daaadaaf9f290347d1e51387c7bc8843bc8188c5ec65323b1b");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_var_test_struct_nil_1() {
    let value = VarTestStruct {
        a: 57718,
        b: List::<u16, 1024>::from_iter([]),
        c: 30,
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/VarTestStruct_nil_1/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: VarTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("0816604b74ffed4de14e90ab139ee0242dab266445b8e932ebc2379a38059f9b");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_one_2() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([false]),
        b: Bitvector::<2>::from_iter([false, false]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([false]),
        e: Bitvector::<8>::from_iter([false, false, true, false, true, false, true, true]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/BitsStruct_one_2/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: BitsStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("b7b8ea390463d99872628ca0d4aa1fc58abe086fd2b51b37396c61388d044ebe");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_random_chaos_0() {
    let value = ComplexTestStruct {
        a: 11713,
        b: List::<u16, 128>::from_iter([
            38091, 53824, 7944, 31766, 19699, 31242, 4608, 29028, 11885, 840, 21861, 65003, 18717,
            32490, 18436, 15216, 33190,
        ]),
        c: 160,
        d: List::<u8, 256>::from_iter([
            128, 197, 56, 67, 137, 198, 224, 251, 177, 132, 101, 181, 68, 221, 57, 132, 165, 50,
            120, 136, 16, 78, 43, 59, 57, 185, 100, 12, 139, 168, 37, 228, 49, 225, 77, 90, 94,
            187, 90, 218, 93, 114, 227, 179, 0, 207, 17, 157, 156, 49, 247, 80, 156, 168, 35, 209,
            211, 36, 31, 244, 181, 101, 62, 207, 85, 151, 160, 129, 177, 232, 187, 210, 250, 152,
            192, 153, 73, 245, 168, 211, 90, 225, 59, 89, 12, 60, 56, 120, 154, 51, 28, 55, 29,
            104, 227, 24, 91, 159, 210, 199, 88, 127, 230, 33, 61, 56, 115, 43, 74, 203, 212, 67,
            119, 140, 94, 145, 118, 193, 107, 218, 217, 16, 117, 119, 11, 184, 19, 13, 159, 176,
            46, 204, 68, 128, 42, 238, 230, 68, 212, 111, 180, 236, 161, 108, 140, 247, 49, 41, 46,
            89, 1, 84, 251, 191, 70, 75, 49, 185, 121, 2, 146, 119, 33, 196, 221, 4, 146, 78, 148,
            174, 159, 101, 133, 226, 195, 161, 7, 226, 153, 195, 66, 41, 224, 219, 86, 59, 148,
            161, 235, 208, 97, 155, 76, 166, 191, 48, 71, 25, 109, 172, 111, 173, 194, 73, 166, 15,
            207, 113, 14, 208, 63, 156, 58, 34, 70, 138, 52, 53, 52, 203, 175, 45, 170, 140,
        ]),
        e: VarTestStruct {
            a: 59882,
            b: List::<u16, 1024>::from_iter([
                21911, 63942, 31199, 31455, 33871, 7137, 41350, 62486, 3011, 27349, 598, 515,
                63354, 28621, 57115, 31259, 53789, 8037, 44746, 7200, 1431, 46405, 34155, 38815,
                19379, 8367, 26984, 6685, 15469, 819, 45620, 18928, 60330, 25053, 8829, 27017,
                62227, 52796, 2068, 64540, 51838, 3044, 25158, 22706, 9091, 18485, 32778, 48731,
                6341, 13256, 35247, 2095, 45437, 48666, 20844, 46266, 57326, 31444, 39945, 35581,
                32790, 13204, 11089, 17709, 40439, 16864, 24972, 62603, 6320, 35115, 34288, 17679,
                37087, 15719, 33589, 6432, 27013, 39712, 13545, 5533, 50743, 53643, 62551, 9233,
                51692, 54995, 24099, 24103, 57032, 570, 30014, 45376, 38895, 8928, 34876, 23399,
                60376, 12834, 29815, 49496, 51841, 63858, 20521, 31781, 31769, 63906, 39068, 52573,
                29639, 9812, 37681, 30759, 59162, 5477, 62006, 4472, 45322, 31142, 33801, 54237,
                8747, 32962, 8497, 3565, 19087, 50149, 29615, 6779, 44698, 31083, 49008, 55457,
                32468, 29909, 34814, 17740, 30370, 47333, 53621, 27697, 186, 34665, 52641, 41697,
                12186, 40139, 62143, 16414, 59557, 48, 47188, 232, 18546, 33344, 50508, 53638,
                29098, 47692, 40216, 8327, 35926, 39917, 20730, 23245, 15972, 35974, 46016, 34902,
                1017, 51546, 15189, 37713, 6054, 59146, 34223, 51638, 16595, 16097, 44686, 60853,
                54007, 19110, 737, 62212, 19361, 60994, 28791, 38829, 28052, 39998, 44467, 64374,
                12243, 59538, 975, 46140, 40464, 61536, 10820, 22447, 46188, 17133, 2407, 32064,
                55561, 63220, 47580, 52985, 16254, 36020, 35441, 40882, 60969, 51962, 44512, 40780,
                57122, 37990, 43411, 39691, 32989, 12136, 27183, 62416, 62270, 33436, 43005, 61122,
                18488, 45109, 58483, 26082, 41115, 6955, 16865, 29139, 33105, 16380, 18416, 33893,
                23211, 61222, 43424, 56222, 11306, 42831, 48960, 46798, 15182, 17353, 57282, 44854,
                9838, 39257, 1855, 44383, 58702, 39671, 44911, 24600, 6342, 54348, 40836, 40660,
                41567, 33906, 25119, 3784, 44549, 35538, 12811, 40454, 23712, 55207, 41212, 63194,
                21569, 13478, 21729, 39749, 31562, 42044, 55429, 28764, 61050, 37945, 43425, 25634,
                13738, 23423, 44965, 20576, 59775, 1165, 3296, 62139, 16725, 2207, 33629, 51716,
                40077, 14993, 25244, 44344, 1908, 53162, 36091, 45250, 45046, 16320, 33840, 11733,
                40495, 53875, 22867, 1650, 19937, 19730, 24175, 273, 3846, 10817, 32813, 30131,
                50668, 64478, 57044, 38327, 55132, 62049, 43699, 24083, 56483, 29779, 20439, 31097,
                13244, 25340, 58792, 55176, 30626, 60712, 4090, 54403, 33479, 36684, 33380, 53084,
                13803, 24861, 27864, 47821, 6773, 44541, 31238, 43090, 19840, 19050, 3940, 22155,
                6112, 24384, 25416, 3155, 43976, 5411, 29967, 14936, 63687, 47242, 20711, 5640,
                56265, 50443, 47002, 25929, 38761, 17248, 40095, 13299, 23132, 30674, 10071, 62046,
                62809, 21816, 11102, 24633, 3763, 22028, 46264, 61133, 39898, 18530, 26374, 37556,
                8944, 7456, 59409, 22601, 43783, 38173, 61181, 49867, 17291, 51330, 64447, 29910,
                8052, 11328, 36249, 52613, 52716, 25336, 46961, 7966, 55176, 20518, 10301, 18739,
                47311, 28821, 21893, 45771, 32628, 46916, 33384, 49121, 32095, 37673, 27914, 5695,
                15101, 58044, 2922, 57629, 45094, 25799, 17038, 61721, 25092, 50696, 36417, 24051,
                56573, 41416, 25049, 37633, 31009, 26730, 56392, 61518, 39090, 19513, 9530, 45894,
                14283, 37410, 34687, 35053, 59797, 48811, 28297, 19307, 26689, 999, 48030, 60389,
                15667, 38826, 61706, 30610, 17062, 60869, 23673, 60992, 36272, 4796, 40180, 23204,
                5736, 25667, 32459,
            ]),
            c: 138,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 3,
                b: 10543900606472943020,
                c: 3667820647,
            },
            FixedTestStruct {
                a: 140,
                b: 3106764529416694417,
                c: 3299042996,
            },
            FixedTestStruct {
                a: 90,
                b: 7465421768114232817,
                c: 4159847108,
            },
            FixedTestStruct {
                a: 203,
                b: 2684306830788579479,
                c: 1893894578,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 40858,
                b: List::<u16, 1024>::from_iter([
                    2788, 10634, 25075, 37806, 19970, 3306, 31405, 59273, 5695, 43782, 45669, 6010,
                    26852, 19119, 47012, 10896, 48177, 26451, 11056, 9638, 54412, 58348, 21355,
                    23069, 8248, 22387, 14432, 55546, 2130, 27403, 40026, 14435, 55608, 670, 54559,
                    22714, 29506, 28563, 48739, 29845, 7603, 63174, 63976, 8382, 51232, 43955,
                    30792, 57540, 18210, 36241, 55113, 30758, 33362, 25927, 48838, 34824, 8344,
                    33180, 24733, 58445, 55640, 22949, 31161, 6112, 22149, 36158, 29335, 51974,
                    6373, 19635, 22409, 21960, 30162, 16257, 2221, 55103, 42073, 5229, 57969,
                    59040, 21810, 5548, 27600, 4788, 60800, 41560, 28655, 52634, 59985, 37218,
                    37291, 24168, 43727, 7393, 52503, 17332, 17178, 48446, 60566, 24685, 42778,
                    64209, 18401, 56495, 38745, 38045, 36030, 23540, 52676, 63996, 53337, 52018,
                    27, 21439, 35276, 19013, 7941, 3997, 49907, 13177, 9785, 51121, 26936, 43991,
                    7757, 54269, 54288, 7852, 12327, 8026, 51726, 5798, 24537, 38903, 29850, 64853,
                    43076, 56347, 12430, 15989, 30429, 58600, 20849, 31856,
                ]),
                c: 130,
            },
            VarTestStruct {
                a: 12545,
                b: List::<u16, 1024>::from_iter([
                    36909, 51751, 12111, 59079, 46526, 4876, 50528, 7980, 56125, 64004, 24620,
                    49385, 31497, 19486, 39428, 15275, 6246, 42311, 9976, 28136, 384, 13157, 11033,
                    54386, 63350, 8749, 51761, 3010, 26301, 17629, 42550, 41173, 12420, 43223,
                    18931, 37301, 63485, 14434, 843, 28576, 6330, 61196, 27493, 35991, 38113, 541,
                    30462, 19448, 12020, 29102, 4715, 14887, 54079, 33752, 1086, 31190, 18268,
                    5781, 13098, 11334, 41608, 58424, 37230, 11536, 14234, 52841, 26828, 59710,
                    30229, 45046, 64771, 12830, 27497, 31718, 60450, 4834, 45595, 50929, 19659,
                    65424, 44026, 29002, 23916, 56964, 54028, 8802, 24610, 44073, 63226, 7022,
                    43168, 50203, 39935, 61562, 27074, 40682, 6333, 64950, 33907, 56345, 28826,
                    37666, 37257, 25416, 16198, 29425, 57543, 62687, 30963, 46241, 17083, 46272,
                    22719, 58906, 30047, 1084, 9214, 32649, 48677, 47719, 60644, 22396, 47890,
                    64346, 6483, 41128, 32617, 48245, 2928, 4799, 7684, 56571, 16256, 1027, 47234,
                    54874, 12543, 44156, 38190, 60342, 58814, 23698, 8170, 22915, 19784, 23356,
                    44845, 15773, 62332, 15096, 4553, 14846, 52091, 13514, 31692, 10483, 60043,
                    28451, 25101, 6586, 27180, 57237, 19471, 2055, 24677, 10739, 21370, 28007,
                    12136, 24029, 42573, 19842, 35572, 57847, 58340, 36554, 37934, 59666, 15644,
                    37750, 1289, 36069, 34835, 1359, 61560, 9434, 26133, 20316, 2489, 46648, 16812,
                    62792, 50396, 23640, 2243, 19594, 55815, 51115, 1341, 3820, 4825, 18191, 30972,
                    11983, 56554, 48410, 24655, 16905, 25828, 54388, 57386, 12938, 40312, 32217,
                    5306, 601, 36359, 35333, 37537, 20139, 47691, 31606, 23131, 30520, 8524, 49072,
                    47280, 11897, 23921, 28200, 39814, 11851, 38126, 23335, 48695, 57701, 64949,
                    32995, 23131, 23058, 54495, 19158, 40721, 18920, 38116, 47381, 42741, 56642,
                    6619, 57273, 12646, 41410, 62932, 60024, 40809, 35689, 12857, 48328, 22404,
                    12858, 26318, 45654, 36550, 20334, 9512, 48412, 34956, 58916, 58683, 62359,
                    7009, 56563, 1917, 36564, 8104, 5294, 37605, 6435, 64151, 33276, 8525, 45226,
                    11158, 10834, 22672, 23122, 32289, 63656, 60143, 4224, 23745, 17968, 19982,
                    3241, 2753, 52734, 32614, 63485, 4974, 7579, 17150, 49416, 5870, 55200, 4485,
                    47478, 277, 49058, 30687, 12902, 16978, 41017, 26003, 20066, 58240, 37094,
                    27343, 19875, 10517, 42200, 52579, 5857, 14363, 57234, 45577, 52691, 21534,
                    38716, 5540, 51071, 8333, 11011, 24834, 60541, 27476, 29425, 717, 64899, 39324,
                    48617, 29272, 20953, 3474, 5785, 30465, 24459, 7268, 56848, 41079, 19835,
                    33775, 20086, 40697, 45009, 4012, 46419, 46114, 38750, 10045, 60425, 48876,
                    3364, 2364, 28512, 11325, 5054, 1987, 15081, 56143, 53631, 1559, 25992, 2517,
                    44917, 56650, 32053, 36889, 13717, 51613, 56090, 28665, 24446, 33675, 47281,
                    14743, 61310, 38786, 22914, 55711, 61658, 17186, 63839, 63410, 60133, 18043,
                    47934, 63867, 7736, 15644, 6275, 28329, 23820, 7517, 8245, 65474, 11551, 7698,
                    10247, 17469, 36728, 43832, 15090, 45654, 10699, 11856, 39320, 19135, 35258,
                    35361, 19725, 40662, 9238, 38076, 53398, 39280, 49906, 48459, 3072, 44075,
                    27257, 58255, 60512, 57107, 18983, 41116, 36323, 65145, 10494, 55846, 30461,
                    21136, 27785, 59061, 38028, 48725, 19760, 41044, 48754, 36415, 53626, 15627,
                    52797, 35559, 46816, 21576, 21287, 42735, 12724, 993, 45749, 27537, 43692,
                    39152, 27314, 16217, 40398, 21775, 35485, 54528, 34943, 13017, 49820, 5779,
                    4350, 45950, 54239, 30308, 64246, 21912, 26047, 14026, 32015, 60671, 13444,
                    59129, 57076, 38204, 37091, 2953, 3156, 41465, 65297, 14993, 59576, 9113,
                    63762, 12163, 31506, 50992, 29253, 25230, 60401, 21443, 26873, 34591, 17844,
                    54662, 38004, 61293, 62170, 15846, 50095, 46162, 31470, 36133, 62791, 37772,
                    56917, 25286, 44512, 31030, 51344, 34624, 39069, 64309, 55601, 20086, 30201,
                    55060, 20609, 48482, 48324, 24078, 61501, 10807, 44404, 21091, 17601, 38409,
                    13886, 36357, 27345, 50662, 63244, 34959, 28627, 45322, 45487, 11596, 26986,
                    13631, 3627, 15324, 12053, 24930, 57165, 34251, 45676, 60534, 44939, 21957,
                    12697, 38733, 52052, 7789, 8659, 43510, 51967, 49718, 61029, 24792, 46187,
                    8486, 3587, 32424, 29229, 28192, 31987, 22668, 17440, 8991, 30355, 63413, 1553,
                    28268, 39523, 9023, 29175, 41240, 54084, 16256, 34273, 48573, 46952, 48971,
                    39679, 61326, 60519, 37212, 19583, 62612, 61299, 54724, 65262, 45834, 36411,
                    22398, 53928, 23935, 49643, 49472, 51104, 27844, 11267, 41223, 31835, 62314,
                    40634, 13657, 62179, 65532, 60440, 28600, 14512, 62565, 14408, 42352, 15551,
                    34133, 38305, 26777, 15943, 8410, 59366, 48421, 50301, 50490, 27500, 22375,
                    54938, 62004, 62986, 51309, 16915, 19941, 28601, 21009, 6582, 45103, 13407,
                    50511, 39781, 27502, 21204, 54019, 2626, 53441, 30271, 3733, 58560, 53403,
                    13730, 61490, 12681, 29555, 55317, 32245, 9348, 10884, 42977, 11126, 11197,
                    16620, 52947, 7753, 16653, 31950, 43758, 26509, 26608, 10685, 25568, 35152,
                    12010, 5681, 54530, 63902, 394, 53113, 34477, 30211, 10885, 33818, 50020,
                    41149, 58793, 54479, 58125, 60881, 20082, 37565, 9832, 49352, 50951, 16845,
                    7938, 62623, 51017, 30135, 53247, 10488, 9752, 17834, 20475, 56232, 36525,
                    41204, 4487, 64036, 51355, 61211, 54683, 25506, 63451, 64956, 6375, 6752,
                    45594, 50956, 52428, 44238, 3582, 36127, 46680, 20573, 12050, 41008, 46429,
                    31657, 13589, 23648, 52357, 12312, 10623, 5139, 9514, 1453, 27388, 281, 35460,
                    8381, 925, 12923, 12555, 11395, 55960, 29072, 62264, 25327, 61197, 27349,
                    14020, 16663, 24667, 52880, 15332, 3820, 39748, 22841, 30888, 45173, 36552,
                    57391, 3474, 26808, 53168, 58492, 27016, 1999, 36481, 32246, 40897, 23536,
                    58873, 55404, 3049, 19545, 2064, 26106, 28617, 16740, 31478, 2973, 45089,
                    32644, 63735, 57290, 28347, 8824, 20875, 864, 3715, 2322, 35870, 59988, 45746,
                    4367, 29170, 32005, 49661, 2268, 26537, 58283, 38188, 30555, 19758, 41504,
                    10261, 41032, 8445, 8324, 5066, 63199, 4207, 48280, 6282, 47772, 49229, 17173,
                    22369, 28149, 58809, 21646, 13151, 56724, 9009, 58182, 50481, 25990, 11390,
                    51481, 9897, 18870, 4882, 20852, 7179, 59480, 18200, 30919, 60625, 62655,
                    42103, 16726, 11645, 12317, 4227, 62607, 30532, 9141, 10892, 19133, 30280,
                    2162, 41270, 57410, 37484, 27627, 10545, 15112, 14857, 8892, 48077, 57039,
                    39495, 17934, 57925, 35217, 47916, 62096, 12802, 47430, 33258, 61781, 48092,
                    41055, 59958, 39127, 6795, 3265, 11772, 56251, 48449, 60469, 23218, 20512,
                    29054, 39350, 63070, 22061, 60782, 37855, 10149, 20871, 52064, 29556, 14087,
                    44469, 63217, 1368, 2199, 31664, 4290, 21911, 8334, 62998, 19587, 7397, 60792,
                    30594, 11792, 6538, 35927, 63296, 3378, 35641, 3871, 13061, 22446, 33693,
                    20330, 19247, 16685, 18197, 54145, 11266, 10999, 24617, 8601, 54577, 29660,
                    56513, 9335, 27424, 57140, 17413, 33406, 30033, 43291, 38537, 40876, 8092,
                    28171, 23457, 11139, 28537, 20270, 9900, 63923, 13348, 34434, 13571, 42450,
                    31259, 60825, 23244, 7085, 61507, 14662, 37940, 19505, 8820,
                ]),
                c: 126,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_random_chaos_0/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("24e69161141c575a7830d20b60f6fea329b6111bcff7cf03437f1f533057722e");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_complex_test_struct_random_3() {
    let value = ComplexTestStruct {
        a: 32772,
        b: List::<u16, 128>::from_iter([
            46512, 38507, 19398, 17365, 6742, 22022, 38263, 43803, 45345, 15434, 50542, 53308,
            63955, 25109, 65120, 12016, 24683, 11769, 37715, 47612, 758, 57637, 39030, 61451,
            27955, 26480, 56870, 14359, 13136, 29373, 27964, 9592, 17585, 43888, 52807, 59179,
            60588,
        ]),
        c: 67,
        d: List::<u8, 256>::from_iter([
            181, 94, 231, 30, 237, 90, 219, 84, 180, 2, 196, 224, 0, 22, 130, 105, 38, 216, 219,
            93, 1, 86, 54, 122, 79, 101, 33, 205, 60, 22, 108,
        ]),
        e: VarTestStruct {
            a: 8345,
            b: List::<u16, 1024>::from_iter([
                60661, 49902, 47308, 6595, 50664, 56406, 11771, 42777, 21007, 26990, 34886, 56815,
                49289, 28126, 32071, 20342, 61101, 11472, 43864, 17495, 57493, 26384, 60112, 40415,
                54428, 37676, 35336, 5659, 43952, 1820, 60659, 42128, 23481, 1511, 17740, 19556,
                7189, 187, 25146, 49939, 64360, 57579, 24440, 11254, 25465, 44487, 55186, 21889,
                32330, 12735, 34473, 64052, 14340, 41266, 8917, 14460, 2372, 56423, 63573, 46036,
                41622, 55954, 51299, 30236, 41351, 41427, 11856, 15840, 16499, 9052, 1617, 28820,
                53368, 64978, 5952, 54583, 6959, 36968, 38491, 11290, 24280, 59225, 42423, 10858,
                58972, 62694, 17945, 32236, 4876, 49885, 14320, 38274, 51161, 40511, 54055, 11698,
                3581, 26390, 42412, 16387, 60623, 9104, 65037, 33759, 56355, 57896, 34812, 52450,
                8116, 1865, 27057, 38613, 37727, 16730, 65310, 25713, 15196, 35483, 27103, 46787,
                27021, 14108, 28113, 40375, 5219, 49546, 38249, 20616, 9913, 61691, 52180, 43596,
                39355, 27859, 32671, 35663, 47209, 25116, 29800, 12615, 16644, 21300, 54498, 33869,
                37133, 16775, 27134, 64503, 36620, 32691, 33056, 24221, 51813, 40508, 62605, 27413,
                28038, 41369, 6957, 51822, 27961, 37665, 54342, 11522, 9633, 22910, 5392, 36716,
                60970, 29281, 36121, 55029, 39427, 26613, 21841, 33515, 3762, 64478, 17893, 9047,
                54351, 59048, 38384, 61266, 8324, 62132, 60242, 38262, 62380, 56315, 42129, 48504,
                50906, 63009, 34832, 9933, 55761, 38537, 10387, 43365, 4561, 22626, 37789, 10012,
                10957, 23006, 42206, 9568, 61257, 22541, 13400, 42267, 27184, 2238, 20977, 48279,
                20661, 42800, 30939, 50651, 38924, 22894, 28349, 63315, 17893, 27696, 44178, 43338,
                50645, 9550, 42527, 7709, 268, 47651, 50083, 42349, 12834, 57596, 44135, 63979,
                48959, 64099, 35136, 23514, 49251, 54830, 35128, 23921, 38196, 10849, 17991, 53139,
                50893, 29409, 34378, 20674, 24454, 27481, 53260, 29400, 45057, 54446, 2436, 5662,
                59825, 38321, 55586, 4122, 38412, 21932, 46899, 14115, 60484, 10540, 47833, 26175,
                59574, 15050, 60366, 29536, 5998, 56437, 9417, 48398, 1055, 39469, 54949, 62692,
                12187, 28902, 51034, 32169, 10743, 29931, 25311, 8644, 53153, 6242, 11240, 7022,
                22311, 65226, 23253, 51921, 26016, 36818, 57480, 42550, 10502, 41387, 22959, 27416,
                990, 53066, 58693, 1730, 56394, 4654, 2825, 59626, 41255, 52990, 47236, 52090,
                22144, 47978, 64800, 2200, 59663, 1161, 19938, 42793, 19828, 7421, 43782, 23262,
                62431, 46623, 12734, 26844, 31080, 61013, 20274, 56498, 2474, 43219, 40744, 43742,
                39451, 53179, 3519, 41552, 1735, 10708, 30431, 40519, 29592, 63614, 27260, 16044,
                43660, 9865, 3302, 10307, 51984, 61184, 52501, 52734, 61325, 44000, 44361, 64576,
                52422, 48468, 14226, 22083, 53032, 5809, 18115, 6507, 40464, 25427, 58283, 5512,
                54631, 30018, 10222, 705, 64481, 15951, 46499, 14846, 18973, 22976, 55839, 35381,
                63270, 56033, 51708, 65343, 40242, 55424, 28390, 22661, 23623, 36398, 233, 36699,
                9948, 31313, 37078, 32464, 13621, 44054, 13083, 49077, 3703, 46140, 50121, 16581,
                7665, 48858, 18817, 60417, 3529, 17193, 5879, 58982, 60326, 43928, 18639, 7864,
                46417, 58747, 51583, 63093, 27592, 32345, 15113, 55570, 33643, 48492, 43793, 45173,
                52138, 12960, 59536, 52839, 8046, 27862, 23385, 10597, 32660, 5050, 41658, 6323,
                17656, 5956, 37780, 36975, 9739, 46319, 5171, 31343, 44979, 49807, 41433, 13,
                50503, 34929, 20664, 35118, 51385, 63751, 42589, 23549, 33358, 14252, 28691, 50288,
                57960, 55388, 10796, 6584, 22685, 36904, 56941, 29592, 64168, 24183, 55027, 49816,
                25008, 41278, 3909, 54649, 27278, 48757, 45572, 49370, 30605, 50774, 2717, 7802,
                14564, 58630, 30744, 9113, 15957, 49563, 25235, 5865, 23366, 23402, 64888, 9922,
                51498, 26597, 5462, 19900, 7574, 63745, 43211, 20357, 21043, 29759, 17634, 56256,
                50034,
            ]),
            c: 227,
        },
        f: Vector::<FixedTestStruct, 4>::from_iter([
            FixedTestStruct {
                a: 48,
                b: 3998434500497351183,
                c: 1718012518,
            },
            FixedTestStruct {
                a: 251,
                b: 4416660904362289185,
                c: 1596040344,
            },
            FixedTestStruct {
                a: 69,
                b: 5158912912770106064,
                c: 241204715,
            },
            FixedTestStruct {
                a: 123,
                b: 8382074815237110674,
                c: 1679281156,
            },
        ]),
        g: Vector::<VarTestStruct, 2>::from_iter([
            VarTestStruct {
                a: 15384,
                b: List::<u16, 1024>::from_iter([
                    5959, 6219, 51610, 25393, 26568, 36825, 33793, 15462, 3731, 46490, 18670,
                    59749, 64649, 30855, 57728, 46187, 48013, 29656, 5719, 2129, 39236, 12781,
                    44300, 17277, 16144, 18436, 48934, 47980, 49588, 44451, 11375, 19642, 3430,
                    13018, 30729, 35357, 20384, 7598, 4906, 32580, 58767, 56361, 14687, 41085,
                    57927, 16925, 44121, 36156, 38729, 54197, 2831, 22096, 9762, 58970, 42830,
                    27376, 42089, 59723, 63066, 28894, 44596, 31886, 2118, 6079, 8228, 47080,
                    13300, 38540, 57184, 8925, 13265, 60115, 18196, 24774, 54258, 26994, 30908,
                    42248, 16526, 45656, 26613, 11960, 34505, 4644, 63475, 48352, 48284, 14257,
                    46426, 58673, 28058, 63352, 12968, 3979, 49824, 26719, 44872, 18876, 65262,
                    25073, 26748, 60971, 7063, 16460, 19174, 49338, 55019, 54480, 64045, 17218,
                    19906, 49895, 10195, 40600, 58356, 51597, 16293, 8680, 17010, 32074, 53368,
                    1643, 49264, 50093, 42292, 29629, 47139, 34649, 8461, 53079, 47853, 1738,
                    34660, 49167, 55509, 49734, 20701, 48965, 46535, 8257, 20975, 62645, 60014,
                    46229, 29956, 60648, 26813, 47195, 25104, 58288, 65234, 19043, 53027, 4272,
                    64416, 24705, 64563, 21854, 19159, 28833, 3451, 57904, 42054, 65466, 7439,
                    25431, 25170, 11291, 12745, 29751, 43088, 55028, 52414, 61549, 61586, 3664,
                    17723, 64044, 3554, 39822, 61535, 28851, 9006, 21400, 56127, 50769, 44122,
                    1444, 41403, 65153, 29299, 38533, 39523, 6388, 19035, 35519, 64052, 21244,
                    46638, 49630, 4620, 14246, 55839, 39755, 59444, 31426, 64998, 24926, 22412,
                    49777, 8346, 3047, 11398, 39726, 7626, 26854, 22072, 43614, 35621, 29573,
                    26821, 49768, 8466, 52756, 31542, 54525, 58698, 37824, 5296, 34358, 5260,
                    18163, 42916, 5765, 60153, 10137, 54670, 14537, 35912, 32866, 12687, 51059,
                    39025, 62160, 29538, 27957, 46811, 56877, 63408, 56240, 51150, 20998, 4555,
                    55239, 37606, 49990, 3329, 35258, 8374, 39443, 46818, 50064, 39279, 25335,
                    54222, 62298, 37825, 10869, 15118, 58081, 9682, 62477, 59610, 25043, 61584,
                    53776, 52624, 9470, 3509, 26592, 61925, 53692, 5954, 60498, 56927, 10820, 4267,
                    26148, 2979, 39078, 64438, 21733, 60908, 53109, 16152, 58066, 8907, 43706,
                    12557, 29217, 23523, 43543, 45883, 51974, 53745, 30563, 44917, 20337, 41205,
                    16985, 57304, 42917, 55884, 30273, 32150, 48084, 29207, 52436, 13353, 16835,
                    38685, 2575, 50733, 48585, 3443, 25052, 2813, 11267, 42974, 47810, 62158,
                    49096, 24447, 32912, 48257, 46798, 2959, 57701, 53772, 24083, 16381, 40240,
                    64086, 53960, 26584, 23731, 681, 18244, 32655, 6467, 52000, 54924, 1776, 35889,
                    11103, 42746, 18101, 25944, 35968, 19621, 25010, 46524, 46861, 22103, 12804,
                    4838, 57402, 32212, 11887, 2832, 63361, 1774, 3132, 10579, 18957, 8840, 3101,
                    35556, 57981, 59369, 239, 52584, 38141, 4223, 32392, 31456, 6448, 27970, 14905,
                    38217, 15609, 61709, 38072, 46825, 58297, 2109, 51016, 56858, 42974, 63839,
                    29124, 21198, 36140, 43033, 63130, 53850, 57280, 8933, 46591, 7853, 50782,
                    18932, 46531, 254, 60849, 9653, 52901, 23043, 39212, 49193, 30108, 16261,
                    10505, 50480, 42465, 1442, 22624, 326, 12075, 50553, 42752, 8989, 2097, 4941,
                    18560, 18083, 53395, 64342, 54640, 34025, 3771, 51317, 2777, 45122, 62673,
                    30879, 9642, 9997, 41401, 29251, 51099, 1379, 57810, 6953, 33610, 39181, 44671,
                    19306, 44920, 59263, 54267, 8652, 24750, 30831, 33661, 61646, 38958, 37168,
                    46969, 34679, 48832, 53671, 31429, 36421, 14291, 39228, 13546, 15426, 37474,
                    60970, 30742, 294, 10040, 25366, 14667, 15116, 22052, 60019, 26158, 5256,
                    22361, 33442, 18234, 41124, 33579, 12463, 16060, 61772, 34240, 2080, 1626,
                    17255, 8641, 52928, 27386, 31134, 28055, 34354, 39063, 59559, 10366, 18065,
                    18010, 7621, 43091, 34856, 7031, 34665, 17818, 25718, 45279, 6968, 50897,
                    35321, 42, 18302, 26360, 12134, 55188, 4650, 64873, 28227, 61398, 19969, 44079,
                    61632, 57169, 52134, 44441, 11602, 5340, 62268, 12737, 52834, 8472, 25361,
                    26360, 43941, 11080, 56189, 60049, 6652, 43078, 1450, 39574, 40169, 13405,
                    61600, 37263, 3362, 16721, 30031, 16801, 60472, 64269, 6259, 46961, 51379,
                    20276, 8681, 27259, 22382, 62223, 22173, 3060, 54646, 11948, 51499, 37744,
                    29314, 22686, 57945, 21684, 19084, 32743, 29609, 6717, 27254, 53561, 35172,
                    4283, 10536, 51153, 1410, 40941, 27316, 16489, 33575, 63, 60563, 40086, 21379,
                    64478, 18406, 56345, 5069, 32049, 63954, 47988, 8078, 34885, 33431, 6785,
                    28016, 8251, 27484, 55375, 44501, 23571, 13318, 22758, 39371, 8213, 50481,
                    9062, 12390, 40632, 28069, 64830, 61586, 39768, 60888, 14639, 7425, 52186,
                    35263, 31977, 63260, 8946, 64552, 10606, 45470, 50546, 40694, 31475, 56734,
                    52936, 59738, 24944, 18581, 2129, 1661, 32940, 32660, 30031, 59302, 21684,
                    45854, 53364, 39399, 43713, 51339, 8330, 23889, 1836, 57516, 7168, 53639,
                    64409, 46910, 20769, 54063, 37013, 18226, 16336, 36838, 50611, 18220, 40804,
                    5837, 11764, 15492, 20120, 39206, 81, 41196, 13405, 62579, 11607, 64411, 13359,
                    1074, 33085, 56376, 56313, 44159, 41297, 49935, 39849, 33794, 40972, 63412,
                    12501, 45346, 5195, 46890, 50103, 286, 18457, 34622, 16698, 58580, 60837, 9504,
                    28204, 4829, 59565, 57319, 36982, 3922, 29571, 5260, 36530, 58266, 11378,
                    24878, 16180, 4973, 43290, 46938, 53044, 37348, 56705, 65269, 1966, 47327,
                    22460, 15514, 23699, 52380, 3010, 9807, 12779, 32086, 35809, 63962, 48728,
                    35518, 46672, 5279, 4572, 64516,
                ]),
                c: 206,
            },
            VarTestStruct {
                a: 58443,
                b: List::<u16, 1024>::from_iter([
                    35162, 59545, 64720, 35632, 63282, 59684, 14274, 55738, 60495, 50521, 43762,
                    38088, 19927, 14449, 59919, 37496, 24495, 38854, 31634, 662, 45989, 9417,
                    25665, 48594, 3179, 6071, 33212, 37207, 5791, 29739, 865, 21841, 54280, 16054,
                    4641, 55042, 3141, 45192, 17522, 54160, 4066, 28145, 17582, 17626, 21776,
                    41753, 23230, 10570, 21156, 61673, 33491, 4486, 51168, 2920, 19023, 24502,
                    33483, 53943, 42885, 52217, 49185, 45990, 23638, 6999, 26281, 43556, 1019,
                    7817, 30403, 39535, 60253, 37769, 11131, 54629, 60309, 37588, 46457, 26521,
                    24357, 33458, 23086, 28445, 31369, 63813, 37864, 37404, 36455, 3489, 49395,
                    12855, 64232, 25925, 18167, 41147, 43357, 47109, 43180, 43678, 47432, 31444,
                    22862, 61991, 1366, 19702, 45567, 28319, 44365, 58590, 31208, 16295, 23547,
                    45385, 40447, 32375, 4905, 46723, 22423, 46100, 41751, 17262, 975, 64042, 6757,
                    57384, 1027, 6433, 60591, 44286, 44746, 60038, 49602, 51315, 5312, 33843,
                    27688, 44575, 1905, 52650, 11955, 27127, 49436, 25995, 62818, 6943, 34032,
                    47025, 25404, 38528, 27120, 8473, 20581, 3685, 53190, 51264, 33840, 63510,
                    22577, 3027, 6513, 61229, 23643, 62206, 41084, 35864, 10879, 25393, 64165,
                    4428, 3728, 16139, 61809, 59266, 16172, 4004, 61975, 65374, 18083, 14269,
                    63791, 11977, 50743, 21922, 59719, 59944, 1287, 35884, 27892, 13434, 64990,
                    14049, 6884, 33440, 53916, 47914, 10587, 41253, 4186, 37441, 59907, 15773,
                    16296, 59000, 44655, 3325, 53898, 27044, 47556, 28171, 10751, 54328, 44318,
                    41344, 26848, 35614, 40184, 28054, 53430, 63613, 51654, 45564, 13307, 6919,
                    39434, 37675, 17131, 46880, 59654, 32246, 59236, 42432, 40224, 48163, 57589,
                    32531, 29170, 49552, 46317, 55073, 45335, 4681, 17466, 30415, 27755, 19940,
                    22913, 10394, 48731, 53706, 52702, 2568, 54014, 54728, 4097, 23648, 13740,
                    44910, 55461, 51665, 29863, 19767, 40241, 25724, 53277, 23478, 45597, 63021,
                    63149, 35421, 41107, 35354, 59844, 13259, 63558, 15557, 52231, 10270, 38484,
                    13879, 31907, 27744, 64604, 39975, 29556, 996, 57375, 42994, 53005, 37285,
                    8311, 35763, 42671, 22629, 31919, 18842, 52562, 35920, 22700, 63283, 42216,
                    61460, 46431, 42657, 50637, 56170, 62798, 25184, 53436, 39036, 7002, 7441,
                    61339, 12453, 59392, 49829, 46374, 38689, 8662, 35532, 32467, 11004, 62526,
                    50099, 54850, 44561, 29706, 29954, 51586, 20893, 18585, 54749, 23821, 55786,
                    56696, 59582, 57718, 32218, 17687, 43837, 26122, 59632, 14502, 49574, 17235,
                    45649, 48339, 52198, 40540, 5778, 63968, 28732, 50271, 56804, 37989, 51131,
                    20681, 59430, 26846, 49197, 25369, 23653, 28979, 9079, 19761, 50837, 33837,
                    62812, 50432, 19545, 20756, 65115, 37383, 56885, 11798, 8141, 54229, 26981,
                    28050, 32423, 62389, 9536, 20055, 9898, 38777, 21528, 36533, 12410, 19648,
                    36981, 60106, 59734, 44457, 53061, 2345, 2123, 9578, 43292, 15286, 8112, 62899,
                    65455, 2037, 6451, 45211, 32266, 4951, 33196, 4214, 28583, 14900, 25086, 11575,
                    64019, 57452, 29542, 62365, 26818, 1525, 64756, 5441, 4596, 31735, 48100,
                    63207, 48087, 46687, 41302, 36221, 10083, 13884, 5194, 53193, 45184, 14194,
                    54876, 48152, 62164, 42523, 47250, 2382, 3520, 13475, 51367, 37039, 10004,
                    63567, 19937, 3806, 18555, 55444, 18713, 42419, 9475, 4584, 1297, 5286, 2121,
                    56235, 40598, 28506, 28734, 61027, 58442, 63388, 29947, 41243, 61891, 31132,
                    31346, 62525, 27215, 6431, 28961, 29590, 21294, 33959, 20008, 44409, 3993,
                    12571, 8595, 446, 29954, 43691, 657, 18210, 13179, 62353, 60336, 36775, 5826,
                    9593, 24987, 737, 20181, 15850, 53097, 24013, 54712, 30251, 64521, 13087,
                    37573, 40672, 36764, 30216, 7657, 57808, 19938, 39499, 40751, 11706, 16785,
                    17176, 43432, 64933, 60776, 61213, 49322, 32640, 1415, 59737, 38896, 52038,
                    33523, 51402, 14645, 61535, 64572, 13787, 32877, 58387, 61861, 7235, 64661,
                    37363, 5420, 36179, 13616, 40814, 5139, 1362, 27082, 55688, 50228, 58806,
                    30812, 63570, 30172, 17650, 39695, 14953, 27195, 51182, 32917, 19422, 19611,
                    50538, 53048, 21892, 4814, 52565, 44784, 4158, 63727, 61735, 28642, 62125,
                    37773, 44550, 59696, 14665, 12393, 52089, 6948, 15903, 38387, 17751, 27447,
                    19734, 65045, 47494, 55724, 49437, 51140, 18432, 48788, 32370, 58643, 30998,
                    30852, 53140, 7903, 29220, 34556, 5427, 47399, 54001, 34680, 56949, 33742,
                    48436, 60298, 14576, 32116, 21245, 48655, 47081, 41389, 64676, 19491, 41551,
                    63641, 12802, 48869, 35667, 52732, 18219, 29279, 29855, 13755, 52778, 62678,
                    61131, 36153, 42729, 51075, 5702, 7693, 12944, 27100, 11036, 5376, 37992,
                    30803, 6722, 27931, 1247, 62228, 6100, 33655, 22528, 46742, 27397, 32372,
                    47329, 60046, 24562, 19228, 53344, 58912, 55103, 49343, 20384, 5567, 42069,
                    24273, 46768, 33387, 42809, 34843, 36283, 13428, 28143, 26179, 6718, 24023,
                    23004, 24257, 10534,
                ]),
                c: 156,
            },
        ]),
    };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/ComplexTestStruct_random_3/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: ComplexTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("94ae9da9095ee46b7da1e78d09ff01ca80f996b586792b8a586858b479416fad");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_single_field_test_struct_random_4() {
    let value = SingleFieldTestStruct { a: 17 };
    let encoding = serialize(&value);
    let expected_encoding = read_ssz_snappy_from_test_data(
        "ssz_rs/tests/data/containers/valid/SingleFieldTestStruct_random_4/serialized.ssz_snappy",
    );
    assert_eq!(encoding, expected_encoding);

    let recovered_value: SingleFieldTestStruct = deserialize(&expected_encoding);
    assert_eq!(recovered_value, value);

    let root = hash_tree_root(&value);
    let expected_root =
        root_from_hex("1100000000000000000000000000000000000000000000000000000000000000");
    assert_eq!(root, expected_root);
}

#[test]
fn test_containers_bits_struct_max_6() {
    let value = BitsStruct {
        a: Bitlist::<5>::from_iter([true, true, true, true, true]),
        b: Bitvector::<2>::from_iter([true, true]),
        c: Bitvector::<1>::from_iter([true]),
        d: Bitlist::<6>::from_iter([true, true, true, true, true]),
        e: Bitvector::<8>::from_iter([true, true, true, true, true, true, true, true]),
    };
    let encoding = seriali