## sss-rs 0.9.0 07/09/2021
 - Move out reconstruction functions out of Secret impl block, for consistency with the sharing 
   functions.
   	- reconstruct, reconstruct_from_srcs no longer belong to Secret struct and instead take
	  it as its first argument.
 - RustFmt pass, have not used RustFmt up to this point, and fixed a lot of non-idiomatic code.

## sss-rs 0.8.1 09/06/2021
 - Remove rust-crypto dependency since it is no longer maintained (thank you umgefahren for pointing that out to me)
 - Fix improper license setting in Cargo.toml that caused it to be listed as non-standard in crates.io

## sss-rs 0.8.0 03/27/2021
 - Rework wrapped_sharing to use wrapped_sharing::Error instead of returning Box\<dyn Error> 
   so it can be matched against to gain more information. This *shouldn't* be a breaking change, 
   but the API did change. 

## sss-rs 0.7.2 10/12/2020
 - Add 'verifiable' flag to sharing/reconstruction functions in wrapped_sharing
 	- This allows the use of wrapped_sharing without being forced to place a verfiable hash at
	  the end of the shares.
	- Developer Note: It was a bit of an oversight to assume verifiable sharing be not optional.
	  There are definitely situations where one would not want the reconstruction to be verifiable.

## sss-rs 0.7.1 07/16/2020
 - Update README.md to reflect recent 0.7.0 changes


## sss-rs 0.7.0 07/14/2020
 - A LOT of cleanup:
 	- Documentation formatting cleaned up and made more consistent
	- References to old arguments/api removed
	- Made geometry and utils module private
	- Removed re-exports of both primary modules to avoid confusion between their functions
### sharer.rs **(Renamed to wrapped_sharing.rs)**
 - Removed 'Sharer' struct and moved its functionality to standalone functions, similar to raw_share
 - Shares generated by sharer functions are now (secret length) + (hash length) **+ 1** due to the 
   first byte of every share being the corresponding X value for those share points.
 - Simplified Sharer Usage:
	- Made base share/reconstruct functions use Vec's
	- Path-related args now properly ask for AsRef<Path>
	- Added many convenient unwrap methods for Secret to get the bytes.
 - MAJOR bug fix regarding sharer share reconstruction, if they were to be reconstructed out of order,
   or if more shares were generated than needed and only the required but out-of-order shares were 
   used, would cause incorrect reconstruction.
   	- Now, if you generate with N shares, M required for reconstruction, then any X number of shares, 
	  M <= X <= N, and in any order, can be used for reconstruction. (This goes for raw_share functions
	  as well)
### raw_share.rs: **(Renamed to basic_sharing.rs)**:
 - Greatly shortened names
 - Sharing functions have also been added to raw_share that include some of this functionality 
   regarding putting the x value at the front of the share's y-values. They are listed as 
   "no_points" variants of the raw_share functions.
 - Removed "custom_rng" wrapper for raw_share functions
	- Since it was just one additional parameter, a simple Option made more sense
 - Removed shuffle operations, since they served little purpose other than novelty


## sss-rs 0.6.1 11/27/2019
 - Updated rand and chacha deps to 0.7.2 and 0.2.1 respectively


## sss-rs 0.6.0 11/27/2019
 - Added functions to raw_share that allow for custom RNGs for coefficient generation
 	- It should be noted that using predictable RNG can lead to a loss of unconditional security,
		so use with caution

## sss-rs 0.5.0 10/02/2019
 - Re-enabled finite field arithmetic via GF(256)
 	- A decrease in share creation speed by a factor of 4 (since we are processing bytes vs u32s)
	- Reconstruction speed has remained the same.
 	- Shares are now the same size as the secret
	- When shares exceed 10 there's no longer a chance at an multiplication overflow
	- Secrets with len % 4 != 0 no longer have trailing bytes not properly shared with finite field 
		arithmetic due to points' y-values never being larger than the prime
		- All bytes in general are now guaranteed to be properly shared via finite field arithmetic
	- Reconstruction and share speed do not scale linearly with the number of shares (citation needed)

## sss-rs 0.4.0 09/29/2019
 - Segmented reading/processing of secrets and shares
	- For all secrets/shares, they are read in chunks of 8KB, which had shown to give the best 
	 performance
 	- This greatly reduces the memory footprint and is a general perforamnce improvement
 - 4-byte secret processing
 	- Secrets are now processed in chunks of 4-bytes vs 1-byte, which gave major perforamnce 
	  improvements.
	- For secrets with length not divisible by 4, are processed in single bytes, no padding!
 - Temporarily disabled finite field arithmetic via primes
 	- Note: My knowledge of how finite field arithmetic worked seemed to be off, and was never 
	working as intended, so has been disabled until I can properly implement it back in. The API
	remains the same however, it accepts primes but does nothing with them.

## sss-rs 0.3.1 09/22/2019
 - Tests were making use of the same dir and stem, and since Rust unit tests are run in multiple threads by default, this caused occasional test failures when the two tests happened to be running at the same time. The test files are now named based on the name of the test to prevent this issue again

## sss-rs 0.3.0 09/21/2019
 - Sharer struct: Wrapped the original, function-only API with an struct with builder style construction with sane defaults.
 	- Handles sharing and reconstruction of shares. 
	- Output shares to files with just a stem and a dir
	- Output share N to a generic Write destination
	- Test the reconstruction to ensure the secret can be recreated.
 	- A default prime number is an option, since keeping the prime a secret is not technically necessary.
	
## sss-rs 0.2.0 09/17/2019
 - The main shuffle function now takes an arbitrary number of bytes instead of a password. Forcing a 
 specific hashing algorithm to be used was restrictive and inflexible, and using a trait object, while 
 better, would still restrict hashing algorithms to ones ported to Rust or wrapped in Rust code. 
 	- However since the seed must be 32 bytes, the hash will be sent through SHA256 to produce a 
	32-byte hash. This has little impact on the security of the initial hashing algorithm.

## sss-rs 0.1.1 09/16/2019
 - Fixed Rust stable compilation error regarding enum variants on type aliases
 	- In the Display impl for the Error enum, its variants were referenced as Self:: instead of Error::
	  which caused compilation issues on Rust's current stable version 1.36.0


## sss-rs 0.1.0 09/15/2019
 - Initial version 
