use sshcerts::fido::*;
use sshcerts::fido::verification::Transport;

const YUBIKEY_BIO_AUTH_DATA_ED25519: [u8; 225] = [
    159, 134, 208, 129, 136, 76, 125, 101, 154, 47, 234, 160, 197, 90, 208, 21, 163,
    191, 79, 27, 43, 11, 130, 44, 209, 93, 108, 21, 176, 240, 10, 8, 69, 0, 0, 0, 4,
    216, 82, 45, 159, 87, 91, 72, 102, 136, 169, 186, 153, 250, 2, 243, 91, 0, 128,
    187, 175, 246, 203, 246, 168, 180, 21, 189, 218, 30, 138, 67, 114, 210, 112, 219,
    54, 100, 217, 198, 11, 242, 135, 179, 16, 97, 54, 122, 37, 5, 179, 239, 60, 253,
    239, 165, 185, 110, 16, 15, 64, 106, 235, 66, 169, 194, 144, 26, 13, 62, 19, 92,
    236, 67, 12, 244, 95, 85, 76, 6, 158, 250, 224, 36, 16, 118, 123, 117, 5, 208,
    170, 12, 184, 153, 127, 131, 34, 88, 87, 187, 96, 88, 63, 11, 177, 132, 141, 108,
    188, 43, 98, 74, 119, 56, 152, 47, 185, 150, 91, 75, 24, 211, 200, 186, 202, 212,
    72, 1, 163, 77, 32, 123, 143, 64, 167, 77, 104, 248, 66, 74, 8, 173, 85, 227, 182,
    110, 105, 164, 1, 1, 3, 39, 32, 6, 33, 88, 32, 169, 114, 64, 116, 199, 57, 16,
    33, 164, 172, 100, 85, 52, 105, 107, 184, 133, 57, 167, 125, 245, 119, 15, 217,
    69, 223, 26, 160, 108, 250, 208, 254];

const YUBIKEY_BIO_AUTH_SIG_ED25519: [u8; 72] = [
    48, 70, 2, 33, 0, 155, 249, 91, 55, 178, 134, 80, 255, 47,189, 218, 141, 171, 224,
    158, 174, 86, 225, 13, 4, 201, 203, 71, 155, 72, 111, 63, 98, 233, 50, 147, 105,
    2, 33, 0, 150, 52, 141, 217, 224, 105, 182, 118, 22, 74, 251, 149, 149, 106, 31,
    101, 53, 78, 169, 33, 28, 94, 86, 215, 159, 84, 62, 181, 133, 161, 72, 9];

const YUBIKEY_BIO_CHALLENGE_ED25519: [u8; 32] = [
    159, 69, 175, 144, 191, 241, 46, 53, 60, 61, 10, 226, 116, 217, 243, 221, 68, 124,
    248, 177, 150, 25, 249, 110, 113, 19, 36, 95, 60, 172, 83, 35];

const YUBIKEY_BIO_INTERMEDIATE: [u8; 732] = [
    48, 130, 2, 216, 48, 130, 1, 192, 160, 3, 2, 1, 2, 2, 9, 0,
    255, 135, 108, 45, 175, 115, 121, 200, 48, 13, 6, 9, 42, 134, 72, 134, 247, 13, 1, 1,
    11, 5, 0, 48, 46, 49, 44, 48, 42, 6, 3, 85, 4, 3, 19, 35, 89, 117, 98, 105, 99, 111,
    32, 85, 50, 70, 32, 82, 111, 111, 116, 32, 67, 65, 32, 83, 101, 114, 105, 97, 108,
    32, 52, 53, 55, 50, 48, 48, 54, 51, 49, 48, 32, 23, 13, 49, 52, 48, 56, 48, 49, 48,
    48, 48, 48, 48, 48, 90, 24, 15, 50, 48, 53, 48, 48, 57, 48, 52, 48, 48, 48, 48, 48,
    48, 90, 48, 110, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 83, 69, 49, 18, 48, 16, 6, 3,
    85, 4, 10, 12, 9, 89, 117, 98, 105, 99, 111, 32, 65, 66, 49, 34, 48, 32, 6, 3, 85, 4,
    11, 12, 25, 65, 117, 116, 104, 101, 110, 116, 105, 99, 97, 116, 111, 114, 32, 65, 116,
    116, 101, 115, 116, 97, 116, 105, 111, 110, 49, 39, 48, 37, 6, 3, 85, 4, 3, 12, 30,
    89, 117, 98, 105, 99, 111, 32, 85, 50, 70, 32, 69, 69, 32, 83, 101, 114, 105, 97, 108,
    32, 55, 54, 50, 48, 56, 55, 52, 50, 51, 48, 89, 48, 19, 6, 7, 42, 134, 72, 206, 61, 2,
    1, 6, 8, 42, 134, 72, 206, 61, 3, 1, 7, 3, 66, 0, 4, 37, 241, 35, 160, 72, 40, 63, 197,
    121, 108, 207, 136, 125, 153, 72, 159, 217, 53, 194, 65, 152, 196, 181, 216, 213, 178,
    194, 191, 215, 221, 93, 21, 175, 228, 91, 112, 112, 119, 101, 103, 213, 181, 176, 178,
    62, 4, 86, 11, 91, 234, 119, 180, 131, 177, 246, 73, 30, 83, 163, 242, 190, 230, 163,
    154, 163, 129, 129, 48, 127, 48, 19, 6, 10, 43, 6, 1, 4, 1, 130, 196, 10, 13, 1, 4, 5,
    4, 3, 5, 5, 6, 48, 34, 6, 9, 43, 6, 1, 4, 1, 130, 196, 10, 2, 4, 21, 49, 46, 51, 46,
    54, 46, 49, 46, 52, 46, 49, 46, 52, 49, 52, 56, 50, 46, 49, 46, 57, 48, 19, 6, 11, 43,
    6, 1, 4, 1, 130, 229, 28, 2, 1, 1, 4, 4, 3, 2, 5, 32, 48, 33, 6, 11, 43, 6, 1, 4, 1, 
    130, 229, 28, 1, 1, 4, 4, 18, 4, 16, 216, 82, 45, 159, 87, 91, 72, 102, 136, 169, 186,
    153, 250, 2, 243, 91, 48, 12, 6, 3, 85, 29, 19, 1, 1, 255, 4, 2, 48, 0, 48, 13, 6, 9,
    42, 134, 72, 134, 247, 13, 1, 1, 11, 5, 0, 3, 130, 1, 1, 0, 82, 176, 105, 73, 219,
    170, 209, 166, 76, 27, 169, 235, 193, 152, 179, 23, 236, 49, 249, 163, 115, 99, 186,
    81, 97, 179, 66, 227, 164, 156, 173, 80, 79, 52, 231, 66, 139, 184, 150, 233, 207, 210,
    141, 3, 173, 16, 206, 50, 90, 6, 131, 142, 155, 108, 78, 203, 23, 173, 64, 208, 144,
    161, 108, 158, 124, 52, 73, 131, 50, 255, 133, 59, 98, 116, 126, 143, 205, 240, 13,
    174, 98, 117, 110, 87, 189, 64, 177, 109, 103, 121, 7, 168, 53, 192, 67, 90, 46, 188,
    233, 176, 185, 6, 156, 161, 34, 191, 157, 150, 74, 115, 32, 106, 247, 79, 243, 192, 1,
    68, 235, 255, 61, 231, 199, 117, 141, 49, 71, 200, 194, 249, 254, 135, 193, 47, 42, 150,
    117, 162, 4, 107, 1, 7, 99, 97, 169, 151, 33, 135, 31, 167, 143, 176, 222, 41, 69, 181,
    121, 249, 22, 108, 72, 173, 47, 213, 12, 60, 229, 108, 130, 33, 167, 80, 131, 246, 86,
    17, 147, 148, 54, 143, 241, 125, 44, 146, 12, 99, 160, 159, 1, 237, 37, 1, 20, 107, 125,
    241, 171, 57, 112, 162, 163, 41, 56, 250, 154, 81, 122, 244, 113, 8, 94, 22, 11, 60,
    167, 151, 100, 35, 23, 70, 186, 106, 187, 166, 142, 13, 19, 206, 37, 151, 150, 188, 210,
    160, 58, 216, 60, 116, 225, 83, 49, 50, 142, 171, 67, 142, 106, 65, 151, 203, 18, 236,
    111, 209, 227, 136];

const YUBIKEY_5C_NFC_AUTH_DATA_ED25519: [u8; 225] = [
    159, 134, 208, 129, 136, 76, 125, 101, 154, 47, 234, 160, 197, 90, 208, 21, 163, 191, 79,
    27, 43, 11, 130, 44, 209, 93, 108, 21, 176, 240, 10, 8, 69, 0, 0, 0, 2, 47, 192, 87, 159,
    129, 19, 71, 234, 177, 22, 187, 90, 141, 185, 32, 42, 0, 128, 195, 26, 28, 253, 69, 244,
    112, 119, 113, 206, 206, 49, 184, 54, 67, 101, 113, 98, 161, 219, 30, 65, 173, 94, 219,
    63, 247, 199, 142, 88, 11, 82, 169, 142, 112, 26, 135, 21, 18, 154, 218, 138, 226, 104,
    148, 159, 64, 81, 59, 69, 202, 4, 80, 163, 126, 134, 205, 96, 93, 236, 95, 99, 136, 59,
    202, 216, 201, 88, 4, 37, 170, 209, 15, 54, 226, 155, 48, 208, 222, 18, 194, 236, 183,
    127, 38, 180, 253, 240, 77, 221, 201, 77, 66, 177, 215, 36, 8, 178, 121, 3, 176, 235, 187,
    167, 122, 116, 190, 88, 86, 68, 77, 177, 116, 53, 94, 89, 207, 227, 123, 184, 241, 155,
    64, 166, 228, 229, 84, 67, 164, 1, 1, 3, 39, 32, 6, 33, 88, 32, 205, 173, 255, 190, 98,
    148, 49, 124, 44, 124, 44, 190, 97, 14, 162, 203, 99, 97, 34, 226, 212, 107, 64, 13, 223,
    245, 108, 146, 100, 58, 232, 11];

const YUBIKEY_5C_NFC_AUTH_SIG_ED25519: [u8; 72] = [
    48, 70, 2, 33, 0, 220, 90, 136, 45, 153, 231, 169, 168, 36, 213, 98, 189, 179, 101, 228,
    125, 27, 247, 191, 150, 196, 90, 5, 141, 54, 160, 167, 204, 101, 108, 159, 119, 2, 33, 0,
    138, 59, 159, 214, 240, 123, 36, 203, 15, 202, 216, 136, 3, 123, 25, 223, 38, 62, 225, 254,
    239, 254, 145, 35, 23, 225, 236, 237, 227, 174, 116, 212];

const YUBIKEY_5C_NFC_CHALLENGE_ED25519: [u8; 32] = [
    150, 37, 143, 154, 46, 53, 105, 39, 63, 194, 72, 239, 202, 197, 10, 126, 218, 217,
    27, 150, 200, 239, 27, 97, 153, 78, 162, 122, 15, 190, 11, 44];

const YUBIKEY_5C_NFC_INTERMEDIATE: [u8; 705] = [
    48, 130, 2, 189, 48, 130, 1, 165, 160, 3, 2, 1, 2, 2, 4, 30, 143, 135, 52, 48, 13,
    6, 9, 42, 134, 72, 134, 247, 13, 1, 1, 11, 5, 0, 48, 46, 49, 44, 48, 42, 6, 3, 85,
    4, 3, 19, 35, 89, 117, 98, 105, 99, 111, 32, 85, 50, 70, 32, 82, 111, 111, 116, 32,
    67, 65, 32, 83, 101, 114, 105, 97, 108, 32, 52, 53, 55, 50, 48, 48, 54, 51, 49, 48,
    32, 23, 13, 49, 52, 48, 56, 48, 49, 48, 48, 48, 48, 48, 48, 90, 24, 15, 50, 48, 53,
    48, 48, 57, 48, 52, 48, 48, 48, 48, 48, 48, 90, 48, 110, 49, 11, 48, 9, 6, 3, 85,
    4, 6, 19, 2, 83, 69, 49, 18, 48, 16, 6, 3, 85, 4, 10, 12, 9, 89, 117, 98, 105, 99,
    111, 32, 65, 66, 49, 34, 48, 32, 6, 3, 85, 4, 11, 12, 25, 65, 117, 116, 104, 101,
    110, 116, 105, 99, 97, 116, 111, 114, 32, 65, 116, 116, 101, 115, 116, 97, 116, 105,
    111, 110, 49, 39, 48, 37, 6, 3, 85, 4, 3, 12, 30, 89, 117, 98, 105, 99, 111, 32, 85,
    50, 70, 32, 69, 69, 32, 83, 101, 114, 105, 97, 108, 32, 53, 49, 50, 55, 50, 50, 55,
    52, 48, 48, 89, 48, 19, 6, 7, 42, 134, 72, 206, 61, 2, 1, 6, 8, 42, 134, 72, 206,
    61, 3, 1, 7, 3, 66, 0, 4, 168, 121, 248, 35, 56, 237, 20, 148, 186, 192, 112, 75,
    204, 127, 198, 99, 209, 178, 113, 113, 89, 118, 36, 49, 1, 199, 96, 81, 21, 215, 193,
    82, 158, 40, 28, 28, 103, 50, 45, 56, 75, 92, 213, 93, 211, 233, 129, 141, 95, 216,
    92, 34, 175, 50, 110, 12, 100, 252, 32, 175, 227, 63, 35, 102, 163, 108, 48, 106, 48,
    34, 6, 9, 43, 6, 1, 4, 1, 130, 196, 10, 2, 4, 21, 49, 46, 51, 46, 54, 46, 49, 46, 52,
    46, 49, 46, 52, 49, 52, 56, 50, 46, 49, 46, 55, 48, 19, 6, 11, 43, 6, 1, 4, 1, 130,
    229, 28, 2, 1, 1, 4, 4, 3, 2, 4, 48, 48, 33, 6, 11, 43, 6, 1, 4, 1, 130, 229, 28, 1,
    1, 4, 4, 18, 4, 16, 47, 192, 87, 159, 129, 19, 71, 234, 177, 22, 187, 90, 141, 185,
    32, 42, 48, 12, 6, 3, 85, 29, 19, 1, 1, 255, 4, 2, 48, 0, 48, 13, 6, 9, 42, 134, 72,
    134, 247, 13, 1, 1, 11, 5, 0, 3, 130, 1, 1, 0, 134, 147, 255, 98, 223, 13, 87, 121,
    212, 116, 141, 127, 200, 209, 2, 39, 49, 138, 142, 88, 14, 106, 58, 87, 193, 8, 233,
    78, 3, 195, 133, 104, 179, 102, 137, 79, 206, 86, 36, 190, 74, 62, 253, 127, 52, 17,
    139, 61, 153, 55, 67, 247, 146, 161, 152, 145, 96, 200, 252, 154, 224, 176, 78, 61,
    249, 238, 21, 227, 232, 140, 4, 252, 130, 168, 220, 191, 88, 24, 225, 8, 220, 194,
    150, 133, 119, 174, 121, 255, 102, 43, 148, 115, 78, 61, 236, 69, 151, 48, 93, 115,
    230, 229, 94, 226, 190, 185, 205, 150, 120, 202, 9, 53, 229, 51, 235, 99, 143, 142,
    38, 250, 187, 129, 124, 218, 68, 31, 190, 152, 49, 131, 42, 229, 246, 226, 173, 153,
    47, 158, 187, 219, 76, 98, 35, 139, 143, 141, 122, 180, 129, 214, 211, 38, 59, 205,
    191, 158, 74, 87, 85, 3, 112, 152, 138, 213, 129, 52, 64, 250, 3, 44, 173, 182, 114,
    60, 173, 216, 248, 215, 186, 128, 159, 117, 180, 60, 255, 160, 165, 185, 173, 209,
    66, 50, 239, 157, 158, 20, 129, 38, 56, 35, 60, 76, 164, 168, 115, 185, 248, 172,
    152, 227, 43, 161, 145, 103, 96, 110, 21, 144, 159, 205, 219, 74, 45, 255, 189, 174,
    70, 32, 36, 159, 154, 102, 70, 172, 129, 228, 131, 45, 17, 25, 254, 191, 170, 115,
    26, 136, 45, 162, 90, 119, 130, 125, 70, 209, 144, 23];
    
    

#[test]
fn verify_and_parse_auth_data_yubikey_bio() {
    let verified_data = verification::verify_auth_data(&YUBIKEY_BIO_AUTH_DATA_ED25519, &YUBIKEY_BIO_AUTH_SIG_ED25519,&YUBIKEY_BIO_CHALLENGE_ED25519, -7, &YUBIKEY_BIO_INTERMEDIATE, None).unwrap();

    // Verify data pulled from the intermediate certificate
    assert_eq!(verified_data.transports, Some(vec![Transport::USB]));
    assert_eq!(verified_data.firmware, Some(format!("5.5.6")));
    assert_eq!(verified_data.aaguid, Some(hex::decode("d8522d9f575b486688a9ba99fa02f35b").unwrap()));

    // Verify data pulled from the auth data
    assert_eq!(verified_data.auth_data.aaguid, verified_data.aaguid.unwrap());
    assert_eq!(verified_data.auth_data.rpid_hash, hex::decode("9f86d081884c7d659a2feaa0c55ad015a3bf4f1b2b0b822cd15d6c15b0f00a08").unwrap());
}

#[test]
fn verify_and_parse_auth_data_yubikey_5c_nfc() {
    let verified_data = verification::verify_auth_data(&YUBIKEY_5C_NFC_AUTH_DATA_ED25519, &YUBIKEY_5C_NFC_AUTH_SIG_ED25519, &YUBIKEY_5C_NFC_CHALLENGE_ED25519, -7, &YUBIKEY_5C_NFC_INTERMEDIATE, None).unwrap();

    // Verify data pulled from the intermediate certificate
    assert_eq!(verified_data.transports, Some(vec![Transport::USB, Transport::NFC]));
    assert_eq!(verified_data.aaguid, Some(hex::decode("2fc0579f811347eab116bb5a8db9202a").unwrap()));

    // Verify data pulled from the auth data
    assert_eq!(verified_data.auth_data.aaguid, verified_data.aaguid.unwrap());
    assert_eq!(verified_data.auth_data.rpid_hash, hex::decode("9f86d081884c7d659a2feaa0c55ad015a3bf4f1b2b0b822cd15d6c15b0f00a08").unwrap());
}