// Copyright (C) 2021 Parity Technologies (UK) Ltd.
// SPDX-License-Identifier: Apache-2.0
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// 	http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

export interface RegistryEntry {
	decimals: number[],
	displayName: string;
	network: string;
	prefix: number;
	standardAccount: '*25519' | 'Ed25519' | 'Sr25519' | 'secp256k1' | null;
	symbols: string[];
	website: string | null;
}

export type Registry = RegistryEntry[];
