use std::{error::Error, fmt, str::Utf8Error};

#[derive(Debug, Eq, PartialEq)]
#[non_exhaustive]
pub enum PacketParseError {
    NotEnoughData,
    BadUdtVersion(i32),
    BadConnectionType(i32),
    BadSocketType(u16),
    BadControlType(u16),
    UnsupportedSrtExtensionType(u16),
    BadSrtExtensionMessage, // could be split
    BadCryptoLength(u32),
    BadCipherKind(u8),
    BadKeyPacketType(u8),
    BadKeySign(u16),
    BadAuth(u8),
    BadStreamEncapsulation(u8),
    StreamEncapsulationNotSrt,
    BadDataEncryption(u8),
    StreamTypeNotUtf8(Utf8Error),
    ZeroAckSequenceNumber,
    BadFilter(String),
}

impl fmt::Display for PacketParseError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        <Self as fmt::Debug>::fmt(self, f)
    }
}

impl Error for PacketParseError {}
