extern crate rand;

use rand::prelude::*;

#[derive(Clone)]
pub struct Point {
    pub cs: Vec<f64> // coordinates
}

impl Point {
    pub fn new_default(dim: usize) -> Self {
        Self{cs: vec![0f64; dim]}
    }

    pub fn new(cs: Vec<f64>) -> Self {
        Self{cs}
    }

    pub fn new_random(rng: &mut ThreadRng, dim: usize, rad: f64) -> Self {
        Self{cs: (0..dim).map(|_| rng.gen_range((-rad)..=rad)).collect::<Vec<f64>>()}
    }

    pub fn mult(&self, a: f64) -> Self {
        Self{cs: self.cs.iter().map(|&c| c * a).collect::<Vec<f64>>()}
    }

    pub fn add(&self, other: &Self) -> Self {
        Self{cs: (0..self.cs.len()).map(|i| self.cs[i] + other.cs[i]).collect::<Vec<f64>>()}
    }

    pub fn sub(&self, other: &Self) -> Self {
        Self{cs: (0..self.cs.len()).map(|i| self.cs[i] - other.cs[i]).collect::<Vec<f64>>()}
    }

}

impl std::fmt::Debug for Point {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_list().entries(self.cs.iter()).finish()
    }
}
