extern crate sr_rcd;

use std::time::Instant;

use sr_rcd::{    
    Point,
    QMSpace,
    rcd,
    RMP,
    Sensor
};

fn main() {
    let space = RMP::new(2, 3.14, 1e-4, &Point::new(vec![0.2, -0.15]));

    let sensorium = vec![
        Sensor::make(&Point::new(vec![7.404, -15.194]), 38.866),
        Sensor::make(&Point::new(vec![43.341, 25.427]), 64.142),
        Sensor::make(&Point::new(vec![-26.462, -39.81]), 52.927),
        Sensor::make(&Point::new(vec![-30.801, 10.53]), 9.186),
        Sensor::make(&Point::new(vec![47.429, 2.364]), 67.277),
        Sensor::make(&Point::new(vec![-46.583, 15.65]), 23.557),
        Sensor::make(&Point::new(vec![8.321, 17.004]), 34.69),
        Sensor::make(&Point::new(vec![8.553, 36.044]), 37.817),
    ];

    let start = Instant::now();
    match rcd(&sensorium, &space, &Point::new_default(space.dim()), 100.0, 0.1) {
        Ok(z) => {
            println!("Time: {:.3} sec", start.elapsed().as_secs_f64());
            println!("RCD-approximated source: {:.4?}", &z);
        },
        Err(s) => println!("ERROR: {}", s)
    }
}


