use convert_case::{Case, Casing};
use proc_macro::TokenStream;
use syn::{parse_macro_input, spanned::Spanned, Data, DataStruct, DeriveInput, Fields, Ident};

extern crate proc_macro;

#[macro_use]
extern crate quote;
extern crate syn;

#[proc_macro_attribute]
pub fn auto_iden(_args: TokenStream, input: TokenStream) -> TokenStream {
    let input = parse_macro_input!(input as DeriveInput);
    let fields = match &input.data {
        Data::Struct(DataStruct {
            fields: Fields::Named(fields),
            ..
        }) => &fields.named,
        _ => panic!("#[auto_iden] can only be used on structs"),
    };
    let field_names = fields.iter().map(|field| {
        let ident = &field.ident;
        let str = ident
            .as_ref()
            .expect("#[auto_iden] can only be used on structs with named fields")
            .to_string();
        let to_pascal = str.to_case(Case::Pascal);
        (ident.as_ref().unwrap(), Ident::new(to_pascal.as_str(), ident.span()))
    });
    let table_name = input.ident.to_string().to_case(Case::Snake);
    let struct_name = quote::format_ident!("{}TypeDef", &input.ident);
    let pascal_names = field_names.clone().map(|(_, pascal)| pascal);
    let snake_names = field_names.map(|(snake, _)| snake);
    let pascal_names2 = pascal_names.clone();

    TokenStream::from(quote! {
        #input

        #[derive(Debug, Clone, Copy, PartialEq, Eq, Hash)]
        enum #struct_name {
            Table,
            #(#pascal_names),*
        }

        impl sea_query::Iden for #struct_name {
            fn unquoted(&self, s: &mut dyn sea_query::Write) {
                write!(s, "{}", match self {
                    #struct_name::Table => #table_name,
                    #(#struct_name::#pascal_names2 => stringify!(#snake_names)),*
                }).unwrap();
            }
        }
    })
}
