
#[macro_export]
/// 从SQL中查找指定标记,返回用于查询的SQL跟待绑定的字段列表
/// 示例请查看单元测试
macro_rules! model_sql_bind {
    ($db:ty,$sql:expr,[$($key:literal),+$(,)?])=>{
        {
            let mut query_sql=$sql.to_string();
            let mut posv:std::collections::HashMap<usize,(String,usize)>=std::collections::HashMap::new();
            $(
                for (pos,mstr) in query_sql.match_indices($key) {
                    let len=$key.len();
                    if let Some((_,vallen))=posv.get(&pos) {
                        if len>*vallen {
                            posv.insert(pos, (mstr.to_string(),len));
                        }
                    } else {
                        posv.insert(pos, (mstr.to_string(),len));
                    }
                }
            )+
            let mut spos = posv.into_iter().collect::<Vec<_>>();
            spos.sort_by(|a,b|if a.1.1<b.1.1 {
              std::cmp::Ordering::Greater
            }else {
              std::cmp::Ordering::Less
            });
            for(pos,val)in spos.iter().enumerate(){
                let bsts=$crate::DbType::type_new::<$db>().mark(pos);
                query_sql = query_sql.replace(val.1.0.as_str(),bsts.as_str());
            }
            spos.sort_by_key(|a|a.0);
            let mut match_vec = vec![];
            for (_,(key,_)) in spos.into_iter(){
                match_vec.push(key.clone());
            };
            (query_sql,match_vec)
        }
    };
}
#[macro_export]
/// 简化model_sql_bind返回的待绑定操作代码的宏
/// 可以自行循环实现此过程
macro_rules! model_sql_bind_match {
    ($bind_res:expr,{$($key:literal:$bind:expr),+$(,)?})=>{
        {
            for key in $bind_res.iter() {
                match key.as_str(){
                    $(
                        $key=>{$bind},
                    )+
                    _=>{},
                }
            }
        }
    };
}



#[test]
fn test_sql_bind_macro(){
    let (sql,bind_res)=crate::model_sql_bind!(
        sqlx::MySql,
        r#"
            select * from (SELECT :nickname as nickname,:gender as gender,1 as gender_group,:nickname as nickname1,:gender as gender1 ) as t where gender in (1) and gender_group in (:gender_group)
        "#,
        [":nickname",":gender",":gender_group"]
    );
    assert_eq!(
        "select * from (SELECT ? as nickname,? as gender,1 as gender_group,? as nickname1,? as gender1 ) as t where gender in (1) and gender_group in (?)",
        sql.as_str().trim()
    );
    crate::model_sql_bind_match!(bind_res,{
        ":nickname":{
            assert!(true);
        },
        ":gender":{
            assert!(true);
        },
        ":gender_group":{
            assert!(true);
        }
    });
}