use sqlx::database::HasArguments;
use sqlx::{Arguments, Database, Error, Executor, IntoArguments, Pool};
use sqlx::query::{Query};
use std::vec;
use super::TableName;
use super::{DbType,  ModelTableField, ModelTableName};



pub struct Delete<DB>
    where DB:Database
{
    pub table_name:TableName,
    _marker:std::marker::PhantomData<DB>
}
impl <DB> Delete<DB>
    where DB:Database
{
    pub fn type_new<T1>() -> Delete<DB>
    where
        T1: ModelTableField<DB>+ModelTableName
    {
        Delete {
           table_name:T1::table_name(),
           _marker:Default::default()
        }
    }
    pub fn new(table_name:TableName) -> Delete<DB>
    {
        Delete {
           table_name,
           _marker:Default::default()
        }
    }

    pub async fn execute_by_where<'c,RB>(
        &self,
        where_sql: &str,
        where_bind: RB,
        pool:&'c Pool<DB>
    ) -> Result<<DB as Database>::QueryResult, Error>
    where
        for<'q> RB: FnOnce(
            Query<'q,DB,<DB as HasArguments<'q>>::Arguments> ,
            &'q Delete<DB>,
        ) ->Query<'q,DB,<DB as HasArguments<'q>>::Arguments>,
        for<'n> <DB as HasArguments<'n>>::Arguments:
            Arguments<'n>+IntoArguments<'n,DB>,
        &'c Pool<DB>: Executor<'c, Database = DB>
    {
        let sql = format!("DELETE FROM {} WHERE {}", self.table_name.full_name(), where_sql);
        let mut res = sqlx::query(sql.as_str());
        res = where_bind(res,self);
        res.execute(pool).await
    }
    pub async fn execute<'c>(&self,pool:&'c Pool<DB>) -> Result<<DB as Database>::QueryResult, Error> 
    where
        for<'n> <DB as HasArguments<'n>>::Arguments:
            Arguments<'n>+IntoArguments<'n,DB>,
        &'c Pool<DB>: Executor<'c, Database = DB>
    {
        let sql = format!("DELETE FROM {}",  self.table_name.full_name());
        let res = sqlx::query(sql.as_str());
        res.execute(pool).await
    }
    execute_by_sql!(Delete<DB>);
}


use sqlx::{MySql};
impl Delete<MySql> {
    pub async fn execute_by_pk<'c,T>(&self, source: &T,pool:&'c Pool<MySql>) -> Result<<MySql as Database>::QueryResult, Error>
    where
        T: ModelTableField<MySql>
    {
        let pkf = T::table_pk();
        let mut where_sql = vec![];
        for (pos, val) in pkf.0.iter().enumerate() {
            let bst = DbType::type_new::<MySql>().mark(pos);
            where_sql.push(format!("{}={}", val.name, bst));
        }
        let sql = format!(
            "DELETE FROM {} WHERE {}",
            self.table_name.full_name(),
            where_sql.join(" and ")
        );
        let mut res = sqlx::query(sql.as_str());
        for val in pkf.0.iter() {
            res = source.query_sqlx_bind(val, res);
        }
        res.execute(pool).await
    }
    pub async fn execute_by_scalar_pk<'c,T,PT>(&self, pk_scalar: PT,pool:&'c Pool<MySql>) -> Result<<MySql as Database>::QueryResult, Error>
        where 
            T:ModelTableField<MySql>,
            for<'q> PT:'q+ Send + sqlx::Encode<'q, MySql> + sqlx::Type<MySql>

    {
        let sql = format!(
            "DELETE FROM {} WHERE {}",
            self.table_name.full_name(),
            scalar_pk_where!(MySql,T::table_pk())
        );
        let mut res = sqlx::query(sql.as_str());
        res=res.bind(pk_scalar);
        res.execute(pool).await
    }
}
