// Copyright (c) 2021 TOYOTA MOTOR CORPORATION. Licensed under MIT OR Apache-2.0.

pub(crate) mod stream_shape;

use serde::{Deserialize, Serialize};
use std::sync::Arc;

use self::stream_shape::StreamShape;

use super::name::StreamName;

#[derive(Clone, Eq, PartialEq, Debug, Serialize, Deserialize, new)]
pub(crate) struct StreamModel {
    name: StreamName,
    shape: Arc<StreamShape>,
}

impl StreamModel {
    pub(crate) fn name(&self) -> &StreamName {
        &self.name
    }

    pub(crate) fn shape(&self) -> Arc<StreamShape> {
        self.shape.clone()
    }
}
