use std::collections::HashMap;

use lazy_static::lazy_static;
use maplit::hashmap;
use strum::{Display, EnumIter, EnumString};

use crate::Error;

#[derive(Debug, Clone, Copy, EnumIter, Display, EnumString)]
#[strum(serialize_all = "camelCase")]
pub enum Spinners {
    Dots,
    Dots2,
    Dots3,
    Dots4,
    Dots5,
    Dots6,
    Dots7,
    Dots8,
    Dots9,
    Dots10,
    Dots11,
    Pipe,
    Star,
    Star2,
    Flip,
    Hamburger,
    GrowVertical,
    GrowHorizontal,
    Balloon,
    Balloon2,
    Noise,
    Bounce,
    BoxBounce,
    BoxBounce2,
    Triangle,
    Arc,
    Circle,
    SquareCorners,
    CircleQuaters,
    CircleHalves,
    Squish,
    Toggle,
    Toggle2,
    Toggle3,
    Toggle4,
    Toggle5,
    Toggle6,
    Toggle7,
    Toggle8,
    Toggle9,
    Toggle10,
    Toggle11,
    Toggle12,
    Toggle13,
    Arrow,
    Dots8Bit,
    Line,
    Line2,
    SimpleDots,
    SimpleDotsScrolling,
    Arrow2,
    Arrow3,
    BouncingBar,
    BouncingBall,
    Smiley,
    Monkey,
    Hearts,
    Clock,
    Earth,
    Material,
    Moon,
    Runner,
    Pong,
    Shark,
    Dqpb,
    Weather,
    Christmas,
    Grenade,
    Point,
    Layer,
    BetaWave,
    FingerDance,
    FistBump,
    SoccerHeader,
    Mindblown,
    Speaker,
    OrangePulse,
    BluePulse,
    OrangeBluePulse,
    TimeTravel,
    Aesthetic,
}

impl Spinners {
    pub fn get_frames(&self) -> Result<Vec<&'static str>, Error> {
        if let Some(frames) = SPINNER_MAP.get(&self.to_string()) {
            Ok(frames.to_vec())
        } else {
            Err(Error::UnknownSpinner(self.to_string()))
        }
    }
}

lazy_static! {
    pub(crate) static ref SPINNER_MAP: HashMap<String, Vec<&'static str>> = {
        hashmap! {
            r"dots".into() => vec![
            r"⠋",
            r"⠙",
            r"⠹",
            r"⠸",
            r"⠼",
            r"⠴",
            r"⠦",
            r"⠧",
            r"⠇",
            r"⠏"
            ],
            "dots2".into()  =>  vec![
            r"⣾",
            r"⣽",
            r"⣻",
            r"⢿",
            r"⡿",
            r"⣟",
            r"⣯",
            r"⣷"
            ],
            "dots3".into()  =>  vec![
            r"⠋",
            r"⠙",
            r"⠚",
            r"⠞",
            r"⠖",
            r"⠦",
            r"⠴",
            r"⠲",
            r"⠳",
            r"⠓"
            ],
            "dots4".into()  =>  vec![
            r"⠄",
            r"⠆",
            r"⠇",
            r"⠋",
            r"⠙",
            r"⠸",
            r"⠰",
            r"⠠",
            r"⠰",
            r"⠸",
            r"⠙",
            r"⠋",
            r"⠇",
            r"⠆"
            ],
            "dots5".into()  =>  vec![
            r"⠋",
            r"⠙",
            r"⠚",
            r"⠒",
            r"⠂",
            r"⠂",
            r"⠒",
            r"⠲",
            r"⠴",
            r"⠦",
            r"⠖",
            r"⠒",
            r"⠐",
            r"⠐",
            r"⠒",
            r"⠓",
            r"⠋"
            ],
            "dots6".into()  =>  vec![
            r"⠁",
            r"⠉",
            r"⠙",
            r"⠚",
            r"⠒",
            r"⠂",
            r"⠂",
            r"⠒",
            r"⠲",
            r"⠴",
            r"⠤",
            r"⠄",
            r"⠄",
            r"⠤",
            r"⠴",
            r"⠲",
            r"⠒",
            r"⠂",
            r"⠂",
            r"⠒",
            r"⠚",
            r"⠙",
            r"⠉",
            r"⠁"
            ],
            "dots7".into()  =>  vec![
            r"⠈",
            r"⠉",
            r"⠋",
            r"⠓",
            r"⠒",
            r"⠐",
            r"⠐",
            r"⠒",
            r"⠖",
            r"⠦",
            r"⠤",
            r"⠠",
            r"⠠",
            r"⠤",
            r"⠦",
            r"⠖",
            r"⠒",
            r"⠐",
            r"⠐",
            r"⠒",
            r"⠓",
            r"⠋",
            r"⠉",
            r"⠈"
            ],
            "dots8".into()  =>  vec![
            r"⠁",
            r"⠁",
            r"⠉",
            r"⠙",
            r"⠚",
            r"⠒",
            r"⠂",
            r"⠂",
            r"⠒",
            r"⠲",
            r"⠴",
            r"⠤",
            r"⠄",
            r"⠄",
            r"⠤",
            r"⠠",
            r"⠠",
            r"⠤",
            r"⠦",
            r"⠖",
            r"⠒",
            r"⠐",
            r"⠐",
            r"⠒",
            r"⠓",
            r"⠋",
            r"⠉",
            r"⠈",
            r"⠈"
            ],
            "dots9".into()  =>  vec![
            r"⢹",
            r"⢺",
            r"⢼",
            r"⣸",
            r"⣇",
            r"⡧",
            r"⡗",
            r"⡏"
            ],
            "dots10".into()  =>  vec![
            r"⢄",
            r"⢂",
            r"⢁",
            r"⡁",
            r"⡈",
            r"⡐",
            r"⡠"
            ],
            "dots11".into()  =>  vec![
            r"⠁",
            r"⠂",
            r"⠄",
            r"⡀",
            r"⢀",
            r"⠠",
            r"⠐",
            r"⠈"
            ],
            "pipe".into()  =>  vec![
            r"┤",
            r"┘",
            r"┴",
            r"└",
            r"├",
            r"┌",
            r"┬",
            r"┐"
            ],
            "star".into()  =>  vec![
            r"✶",
            r"✸",
            r"✹",
            r"✺",
            r"✹",
            r"✷"
            ],
            "star2".into()  =>  vec![
            r"+",
            r"x",
            r"*"
            ],
            "flip".into()  =>  vec![
            r"_",
            r"_",
            r"_",
            r"-",
            r"`",
            r"`",
            r"'",
            r"´",
            r"-",
            r"_",
            r"_",
            r"_"
            ],
            "hamburger".into()  =>  vec![
            r"☱",
            r"☲",
            r"☴"
            ],
            "growVertical".into()  =>  vec![
            r"▁",
            r"▃",
            r"▄",
            r"▅",
            r"▆",
            r"▇",
            r"▆",
            r"▅",
            r"▄",
            r"▃"
            ],
            "growHorizontal".into()  =>  vec![
            r"▏",
            r"▎",
            r"▍",
            r"▌",
            r"▋",
            r"▊",
            r"▉",
            r"▊",
            r"▋",
            r"▌",
            r"▍",
            r"▎"
            ],
            "balloon".into()  =>  vec![
            r".",
            r"i",
            r"n",
            r"t",
            r"o",
            r"(",
            r")",
            r" ",
            r".",
            r"o",
            r"O",
            r"@",
            r"*",
            r" "
            ],
            "balloon2".into()  =>  vec![
            r".",
            r"o",
            r"O",
            r"°",
            r"O",
            r"o",
            r"."
            ],
            "noise".into()  =>  vec![
            r"▓",
            r"▒",
            r"░"
            ],
            "bounce".into()  =>  vec![
            r"⠁",
            r"⠂",
            r"⠄",
            r"⠂"
            ],
            "boxBounce".into()  =>  vec![
            r"▖",
            r"▘",
            r"▝",
            r"▗"
            ],
            "boxBounce2".into()  =>  vec![
            r"▌",
            r"▀",
            r"▐",
            r"▄"
            ],
            "triangle".into()  =>  vec![
            r"◢",
            r"◣",
            r"◤",
            r"◥"
            ],
            "arc".into()  =>  vec![
            r"◜",
            r"◠",
            r"◝",
            r"◞",
            r"◡",
            r"◟"
            ],
            "circle".into()  =>  vec![
            r"◡",
            r"⊙",
            r"◠"
            ],
            "squareCorners".into()  =>  vec![
            r"◰",
            r"◳",
            r"◲",
            r"◱"
            ],
            "circleQuaters".into()  =>  vec![
            r"◴",
            r"◷",
            r"◶",
            r"◵"
            ],
            "circleHalves".into()  =>  vec![
            r"◐",
            r"◓",
            r"◑",
            r"◒"
            ],
            "squish".into()  =>  vec![
            r"╫",
            r"╪"
            ],
            "toggle".into()  =>  vec![
            r"⊶",
            r"⊷"
            ],
            "toggle2".into()  =>  vec![
            r"▫",
            r"▪"
            ],
            "toggle3".into()  =>  vec![
            r"□",
            r"■"
            ],
            "toggle4".into()  =>  vec![
            r"■",
            r"□",
            r"▪",
            r"▫"
            ],
            "toggle5".into()  =>  vec![
            r"▮",
            r"▯"
            ],
            "toggle6".into()  =>  vec![
            r"ဝ",
            r"၀"
            ],
            "toggle7".into()  =>  vec![
            r"⦾",
            r"⦿"
            ],
            "toggle8".into()  =>  vec![
            r"◍",
            r"◌"
            ],
            "toggle9".into()  =>  vec![
            r"◉",
            r"◎"
            ],
            "toggle10".into()  =>  vec![
            r"㊂",
            r"㊀",
            r"㊁"
            ],
            "toggle11".into()  =>  vec![
            r"⧇",
            r"⧆"
            ],
            "toggle12".into()  =>  vec![
            r"☗",
            r"☖"
            ],
            "toggle13".into()  =>  vec![
            r"=",
            r"*",
            r"-"
            ],
            "arrow".into()  =>  vec![
            r"←",
            r"↖",
            r"↑",
            r"↗",
            r"→",
            r"↘",
            r"↓",
            r"↙"
            ],
            "dots8Bit".into() => vec![
            r"⠀",
            r"⠁",
            r"⠂",
            r"⠃",
            r"⠄",
            r"⠅",
            r"⠆",
            r"⠇",
            r"⡀",
            r"⡁",
            r"⡂",
            r"⡃",
            r"⡄",
            r"⡅",
            r"⡆",
            r"⡇",
            r"⠈",
            r"⠉",
            r"⠊",
            r"⠋",
            r"⠌",
            r"⠍",
            r"⠎",
            r"⠏",
            r"⡈",
            r"⡉",
            r"⡊",
            r"⡋",
            r"⡌",
            r"⡍",
            r"⡎",
            r"⡏",
            r"⠐",
            r"⠑",
            r"⠒",
            r"⠓",
            r"⠔",
            r"⠕",
            r"⠖",
            r"⠗",
            r"⡐",
            r"⡑",
            r"⡒",
            r"⡓",
            r"⡔",
            r"⡕",
            r"⡖",
            r"⡗",
            r"⠘",
            r"⠙",
            r"⠚",
            r"⠛",
            r"⠜",
            r"⠝",
            r"⠞",
            r"⠟",
            r"⡘",
            r"⡙",
            r"⡚",
            r"⡛",
            r"⡜",
            r"⡝",
            r"⡞",
            r"⡟",
            r"⠠",
            r"⠡",
            r"⠢",
            r"⠣",
            r"⠤",
            r"⠥",
            r"⠦",
            r"⠧",
            r"⡠",
            r"⡡",
            r"⡢",
            r"⡣",
            r"⡤",
            r"⡥",
            r"⡦",
            r"⡧",
            r"⠨",
            r"⠩",
            r"⠪",
            r"⠫",
            r"⠬",
            r"⠭",
            r"⠮",
            r"⠯",
            r"⡨",
            r"⡩",
            r"⡪",
            r"⡫",
            r"⡬",
            r"⡭",
            r"⡮",
            r"⡯",
            r"⠰",
            r"⠱",
            r"⠲",
            r"⠳",
            r"⠴",
            r"⠵",
            r"⠶",
            r"⠷",
            r"⡰",
            r"⡱",
            r"⡲",
            r"⡳",
            r"⡴",
            r"⡵",
            r"⡶",
            r"⡷",
            r"⠸",
            r"⠹",
            r"⠺",
            r"⠻",
            r"⠼",
            r"⠽",
            r"⠾",
            r"⠿",
            r"⡸",
            r"⡹",
            r"⡺",
            r"⡻",
            r"⡼",
            r"⡽",
            r"⡾",
            r"⡿",
            r"⢀",
            r"⢁",
            r"⢂",
            r"⢃",
            r"⢄",
            r"⢅",
            r"⢆",
            r"⢇",
            r"⣀",
            r"⣁",
            r"⣂",
            r"⣃",
            r"⣄",
            r"⣅",
            r"⣆",
            r"⣇",
            r"⢈",
            r"⢉",
            r"⢊",
            r"⢋",
            r"⢌",
            r"⢍",
            r"⢎",
            r"⢏",
            r"⣈",
            r"⣉",
            r"⣊",
            r"⣋",
            r"⣌",
            r"⣍",
            r"⣎",
            r"⣏",
            r"⢐",
            r"⢑",
            r"⢒",
            r"⢓",
            r"⢔",
            r"⢕",
            r"⢖",
            r"⢗",
            r"⣐",
            r"⣑",
            r"⣒",
            r"⣓",
            r"⣔",
            r"⣕",
            r"⣖",
            r"⣗",
            r"⢘",
            r"⢙",
            r"⢚",
            r"⢛",
            r"⢜",
            r"⢝",
            r"⢞",
            r"⢟",
            r"⣘",
            r"⣙",
            r"⣚",
            r"⣛",
            r"⣜",
            r"⣝",
            r"⣞",
            r"⣟",
            r"⢠",
            r"⢡",
            r"⢢",
            r"⢣",
            r"⢤",
            r"⢥",
            r"⢦",
            r"⢧",
            r"⣠",
            r"⣡",
            r"⣢",
            r"⣣",
            r"⣤",
            r"⣥",
            r"⣦",
            r"⣧",
            r"⢨",
            r"⢩",
            r"⢪",
            r"⢫",
            r"⢬",
            r"⢭",
            r"⢮",
            r"⢯",
            r"⣨",
            r"⣩",
            r"⣪",
            r"⣫",
            r"⣬",
            r"⣭",
            r"⣮",
            r"⣯",
            r"⢰",
            r"⢱",
            r"⢲",
            r"⢳",
            r"⢴",
            r"⢵",
            r"⢶",
            r"⢷",
            r"⣰",
            r"⣱",
            r"⣲",
            r"⣳",
            r"⣴",
            r"⣵",
            r"⣶",
            r"⣷",
            r"⢸",
            r"⢹",
            r"⢺",
            r"⢻",
            r"⢼",
            r"⢽",
            r"⢾",
            r"⢿",
            r"⣸",
            r"⣹",
            r"⣺",
            r"⣻",
            r"⣼",
            r"⣽",
            r"⣾",
            r"⣿"
            ],
            "line".into() => vec![
            r"-",
            r"\",
            r"|",
            r"/"
            ],
            "line2".into() => vec![
            r"⠂",
            r"-",
            r"–",
            r"—",
            r"–",
            r"-"
            ],
            "pipe".into() => vec![
            r"┤",
            r"┘",
            r"┴",
            r"└",
            r"├",
            r"┌",
            r"┬",
            r"┐"
            ],
            "simpleDots".into() => vec![
            r".  ",
            r".. ",
            r"...",
            r"   "
            ],
            "simpleDotsScrolling".into() => vec![
            r".  ",
            r".. ",
            r"...",
            r" ..",
            r"  .",
            r"   "
            ],
            "star".into() => vec![
            r"✶",
            r"✸",
            r"✹",
            r"✺",
            r"✹",
            r"✷"
            ],
            "star2".into() => vec![
            r"+",
            r"x",
            r"*"
            ],
            "flip".into() => vec![
            r"_",
            r"_",
            r"_",
            r"-",
            r"`",
            r"`",
            r"'",
            r"´",
            r"-",
            r"_",
            r"_",
            r"_"
            ],
            "hamburger".into() => vec![
            r"☱",
            r"☲",
            r"☴"
            ],
            "growVertical".into() => vec![
            r"▁",
            r"▃",
            r"▄",
            r"▅",
            r"▆",
            r"▇",
            r"▆",
            r"▅",
            r"▄",
            r"▃"
            ],
            "growHorizontal".into() => vec![
            r"▏",
            r"▎",
            r"▍",
            r"▌",
            r"▋",
            r"▊",
            r"▉",
            r"▊",
            r"▋",
            r"▌",
            r"▍",
            r"▎"
            ],
            "balloon".into() => vec![
            r" ",
            r".",
            r"o",
            r"O",
            r"@",
            r"*",
            r" "
            ],
            "balloon2".into() => vec![
            r".",
            r"o",
            r"O",
            r"°",
            r"O",
            r"o",
            r"."
            ],
            "noise".into() => vec![
            r"▓",
            r"▒",
            r"░"
            ],
            "bounce".into() => vec![
            r"⠁",
            r"⠂",
            r"⠄",
            r"⠂"
            ],
            "boxBounce".into() => vec![
            r"▖",
            r"▘",
            r"▝",
            r"▗"
            ],
            "boxBounce2".into() => vec![
            r"▌",
            r"▀",
            r"▐",
            r"▄"
            ],
            "triangle".into() => vec![
            r"◢",
            r"◣",
            r"◤",
            r"◥"
            ],
            "arc".into() => vec![
            r"◜",
            r"◠",
            r"◝",
            r"◞",
            r"◡",
            r"◟"
            ],
            "circle".into() => vec![
            r"◡",
            r"⊙",
            r"◠"
            ],
            "squareCorners".into() => vec![
            r"◰",
            r"◳",
            r"◲",
            r"◱"
            ],
            "circleQuarters".into() => vec![
            r"◴",
            r"◷",
            r"◶",
            r"◵"
            ],
            "circleHalves".into() => vec![
            r"◐",
            r"◓",
            r"◑",
            r"◒"
            ],
            "squish".into() => vec![
            r"╫",
            r"╪"
            ],
            "toggle".into() => vec![
            r"⊶",
            r"⊷"
            ],
            "toggle2".into() => vec![
            r"▫",
            r"▪"
            ],
            "toggle3".into() => vec![
            r"□",
            r"■"
            ],
            "toggle4".into() => vec![
            r"■",
            r"□",
            r"▪",
            r"▫"
            ],
            "toggle5".into() => vec![
            r"▮",
            r"▯"
            ],
            "toggle6".into() => vec![
            r"ဝ",
            r"၀"
            ],
            "toggle7".into() => vec![
            r"⦾",
            r"⦿"
            ],
            "toggle8".into() => vec![
            r"◍",
            r"◌"
            ],
            "toggle9".into() => vec![
            r"◉",
            r"◎"
            ],
            "toggle10".into() => vec![
            r"㊂",
            r"㊀",
            r"㊁"
            ],
            "toggle11".into() => vec![
            r"⧇",
            r"⧆"
            ],
            "toggle12".into() => vec![
            r"☗",
            r"☖"
            ],
            "toggle13".into() => vec![
            r"=",
            r"*",
            r"-"
            ],
            "arrow".into() => vec![
            r"←",
            r"↖",
            r"↑",
            r"↗",
            r"→",
            r"↘",
            r"↓",
            r"↙"
            ],
            "arrow2".into() => vec![
            r"⬆️ ",
            r"↗️ ",
            r"➡️ ",
            r"↘️ ",
            r"⬇️ ",
            r"↙️ ",
            r"⬅️ ",
            r"↖️ "
            ],
            "arrow3".into() => vec![
            r"▹▹▹▹▹",
            r"▸▹▹▹▹",
            r"▹▸▹▹▹",
            r"▹▹▸▹▹",
            r"▹▹▹▸▹",
            r"▹▹▹▹▸"
            ],
            "bouncingBar".into() => vec![
            r"[    ]",
            r"[=   ]",
            r"[==  ]",
            r"[=== ]",
            r"[ ===]",
            r"[  ==]",
            r"[   =]",
            r"[    ]",
            r"[   =]",
            r"[  ==]",
            r"[ ===]",
            r"[====]",
            r"[=== ]",
            r"[==  ]",
            r"[=   ]"
            ],
            "bouncingBall".into() => vec![
            r"( ●    )",
            r"(  ●   )",
            r"(   ●  )",
            r"(    ● )",
            r"(     ●)",
            r"(    ● )",
            r"(   ●  )",
            r"(  ●   )",
            r"( ●    )",
            r"(●     )"
            ],
            "smiley".into() => vec![
            r"😄 ",
            r"😝 "
            ],
            "monkey".into() => vec![
            r"🙈 ",
            r"🙈 ",
            r"🙉 ",
            r"🙊 "
            ],
            "hearts".into() => vec![
            r"💛 ",
            r"💙 ",
            r"💜 ",
            r"💚 ",
            r"❤️ "
            ],
            "clock".into() => vec![
            r"🕛 ",
            r"🕐 ",
            r"🕑 ",
            r"🕒 ",
            r"🕓 ",
            r"🕔 ",
            r"🕕 ",
            r"🕖 ",
            r"🕗 ",
            r"🕘 ",
            r"🕙 ",
            r"🕚 "
            ],
            "earth".into() => vec![
            r"🌍 ",
            r"🌎 ",
            r"🌏 "
            ],
            "material".into() => vec![
            r"█▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁",
            r"██▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁",
            r"███▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁",
            r"████▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁",
            r"██████▁▁▁▁▁▁▁▁▁▁▁▁▁▁",
            r"██████▁▁▁▁▁▁▁▁▁▁▁▁▁▁",
            r"███████▁▁▁▁▁▁▁▁▁▁▁▁▁",
            r"████████▁▁▁▁▁▁▁▁▁▁▁▁",
            r"█████████▁▁▁▁▁▁▁▁▁▁▁",
            r"█████████▁▁▁▁▁▁▁▁▁▁▁",
            r"██████████▁▁▁▁▁▁▁▁▁▁",
            r"███████████▁▁▁▁▁▁▁▁▁",
            r"█████████████▁▁▁▁▁▁▁",
            r"██████████████▁▁▁▁▁▁",
            r"██████████████▁▁▁▁▁▁",
            r"▁██████████████▁▁▁▁▁",
            r"▁██████████████▁▁▁▁▁",
            r"▁██████████████▁▁▁▁▁",
            r"▁▁██████████████▁▁▁▁",
            r"▁▁▁██████████████▁▁▁",
            r"▁▁▁▁█████████████▁▁▁",
            r"▁▁▁▁██████████████▁▁",
            r"▁▁▁▁██████████████▁▁",
            r"▁▁▁▁▁██████████████▁",
            r"▁▁▁▁▁██████████████▁",
            r"▁▁▁▁▁██████████████▁",
            r"▁▁▁▁▁▁██████████████",
            r"▁▁▁▁▁▁██████████████",
            r"▁▁▁▁▁▁▁█████████████",
            r"▁▁▁▁▁▁▁█████████████",
            r"▁▁▁▁▁▁▁▁████████████",
            r"▁▁▁▁▁▁▁▁████████████",
            r"▁▁▁▁▁▁▁▁▁███████████",
            r"▁▁▁▁▁▁▁▁▁███████████",
            r"▁▁▁▁▁▁▁▁▁▁██████████",
            r"▁▁▁▁▁▁▁▁▁▁██████████",
            r"▁▁▁▁▁▁▁▁▁▁▁▁████████",
            r"▁▁▁▁▁▁▁▁▁▁▁▁▁███████",
            r"▁▁▁▁▁▁▁▁▁▁▁▁▁▁██████",
            r"▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁█████",
            r"▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁█████",
            r"█▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁████",
            r"██▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁███",
            r"██▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁███",
            r"███▁▁▁▁▁▁▁▁▁▁▁▁▁▁███",
            r"████▁▁▁▁▁▁▁▁▁▁▁▁▁▁██",
            r"█████▁▁▁▁▁▁▁▁▁▁▁▁▁▁█",
            r"█████▁▁▁▁▁▁▁▁▁▁▁▁▁▁█",
            r"██████▁▁▁▁▁▁▁▁▁▁▁▁▁█",
            r"████████▁▁▁▁▁▁▁▁▁▁▁▁",
            r"█████████▁▁▁▁▁▁▁▁▁▁▁",
            r"█████████▁▁▁▁▁▁▁▁▁▁▁",
            r"█████████▁▁▁▁▁▁▁▁▁▁▁",
            r"█████████▁▁▁▁▁▁▁▁▁▁▁",
            r"███████████▁▁▁▁▁▁▁▁▁",
            r"████████████▁▁▁▁▁▁▁▁",
            r"████████████▁▁▁▁▁▁▁▁",
            r"██████████████▁▁▁▁▁▁",
            r"██████████████▁▁▁▁▁▁",
            r"▁██████████████▁▁▁▁▁",
            r"▁██████████████▁▁▁▁▁",
            r"▁▁▁█████████████▁▁▁▁",
            r"▁▁▁▁▁████████████▁▁▁",
            r"▁▁▁▁▁████████████▁▁▁",
            r"▁▁▁▁▁▁███████████▁▁▁",
            r"▁▁▁▁▁▁▁▁█████████▁▁▁",
            r"▁▁▁▁▁▁▁▁█████████▁▁▁",
            r"▁▁▁▁▁▁▁▁▁█████████▁▁",
            r"▁▁▁▁▁▁▁▁▁█████████▁▁",
            r"▁▁▁▁▁▁▁▁▁▁█████████▁",
            r"▁▁▁▁▁▁▁▁▁▁▁████████▁",
            r"▁▁▁▁▁▁▁▁▁▁▁████████▁",
            r"▁▁▁▁▁▁▁▁▁▁▁▁███████▁",
            r"▁▁▁▁▁▁▁▁▁▁▁▁███████▁",
            r"▁▁▁▁▁▁▁▁▁▁▁▁▁███████",
            r"▁▁▁▁▁▁▁▁▁▁▁▁▁███████",
            r"▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁█████",
            r"▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁████",
            r"▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁████",
            r"▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁████",
            r"▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁███",
            r"▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁███",
            r"▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁██",
            r"▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁██",
            r"▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁██",
            r"▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁█",
            r"▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁█",
            r"▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁█",
            r"▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁",
            r"▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁",
            r"▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁",
            r"▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁"
            ],
            "moon".into() => vec![
            r"🌑 ",
            r"🌒 ",
            r"🌓 ",
            r"🌔 ",
            r"🌕 ",
            r"🌖 ",
            r"🌗 ",
            r"🌘 "
            ],
            "runner".into() => vec![
            r"🚶 ",
            r"🏃 "
            ],
            "pong".into() => vec![
            r"▐⠂       ▌",
            r"▐⠈       ▌",
            r"▐ ⠂      ▌",
            r"▐ ⠠      ▌",
            r"▐  ⡀     ▌",
            r"▐  ⠠     ▌",
            r"▐   ⠂    ▌",
            r"▐   ⠈    ▌",
            r"▐    ⠂   ▌",
            r"▐    ⠠   ▌",
            r"▐     ⡀  ▌",
            r"▐     ⠠  ▌",
            r"▐      ⠂ ▌",
            r"▐      ⠈ ▌",
            r"▐       ⠂▌",
            r"▐       ⠠▌",
            r"▐       ⡀▌",
            r"▐      ⠠ ▌",
            r"▐      ⠂ ▌",
            r"▐     ⠈  ▌",
            r"▐     ⠂  ▌",
            r"▐    ⠠   ▌",
            r"▐    ⡀   ▌",
            r"▐   ⠠    ▌",
            r"▐   ⠂    ▌",
            r"▐  ⠈     ▌",
            r"▐  ⠂     ▌",
            r"▐ ⠠      ▌",
            r"▐ ⡀      ▌",
            r"▐⠠       ▌"
            ],
            "shark".into() => vec![
            r"▐|\____________▌",
            r"▐_|\___________▌",
            r"▐__|\__________▌",
            r"▐___|\_________▌",
            r"▐____|\________▌",
            r"▐_____|\_______▌",
            r"▐______|\______▌",
            r"▐_______|\_____▌",
            r"▐________|\____▌",
            r"▐_________|\___▌",
            r"▐__________|\__▌",
            r"▐___________|\_▌",
            r"▐____________|\▌",
            r"▐____________/|▌",
            r"▐___________/|_▌",
            r"▐__________/|__▌",
            r"▐_________/|___▌",
            r"▐________/|____▌",
            r"▐_______/|_____▌",
            r"▐______/|______▌",
            r"▐_____/|_______▌",
            r"▐____/|________▌",
            r"▐___/|_________▌",
            r"▐__/|__________▌",
            r"▐_/|___________▌",
            r"▐/|____________▌"
            ],
            "dqpb".into() => vec![
            r"d",
            r"q",
            r"p",
            r"b"
            ],
            "weather".into() => vec![
            r"☀️ ",
            r"☀️ ",
            r"☀️ ",
            r"🌤  ",
            r"⛅️ ",
            r"🌥  ",
            r"☁️ ",
            r"🌧  ",
            r"🌨  ",
            r"🌧  ",
            r"🌨  ",
            r"🌧  ",
            r"🌨  ",
            r"⛈  ",
            r"🌨  ",
            r"🌧  ",
            r"🌨  ",
            r"☁️ ",
            r"🌥  ",
            r"⛅️ ",
            r"🌤  ",
            r"☀️ ",
            r"☀️ "
            ],
            "christmas".into() => vec![
            r"🌲",
            r"🎄"
            ],
            "grenade".into() => vec![
            r"،    ",
            r"′    ",
            r" ´   ",
            r" ‾   ",
            r"  ⸌  ",
            r"  ⸊  ",
            r"  |  ",
            r"  ⁎  ",
            r"  ⁕  ",
            r" ෴ ",
            r"  ⁓  ",
            r"     ",
            r"     ",
            r"     "
            ],
            "point".into() => vec![
            r"∙∙∙",
            r"●∙∙",
            r"∙●∙",
            r"∙∙●",
            r"∙∙∙"
            ],
            "layer".into() => vec![
            r"-",
            r"=",
            r"≡"
            ],
            "betaWave".into() => vec![
            r"ρββββββ",
            r"βρβββββ",
            r"ββρββββ",
            r"βββρβββ",
            r"ββββρββ",
            r"βββββρβ",
            r"ββββββρ"
            ],
            "fingerDance".into() => vec![
            r"🤘 ",
            r"🤟 ",
            r"🖖 ",
            r"✋ ",
            r"🤚 ",
            r"👆 "
            ],
            "fistBump".into() => vec![
            r"🤜　　　　🤛 ",
            r"🤜　　　　🤛 ",
            r"🤜　　　　🤛 ",
            r"　🤜　　🤛　 ",
            r"　　🤜🤛　　 ",
            r"　🤜✨🤛　　 ",
            r"🤜　✨　🤛　 "
            ],
            "soccerHeader".into() => vec![
            r" 🧑⚽️       🧑 ",
            r"🧑  ⚽️      🧑 ",
            r"🧑   ⚽️     🧑 ",
            r"🧑    ⚽️    🧑 ",
            r"🧑     ⚽️   🧑 ",
            r"🧑      ⚽️  🧑 ",
            r"🧑       ⚽️🧑  ",
            r"🧑      ⚽️  🧑 ",
            r"🧑     ⚽️   🧑 ",
            r"🧑    ⚽️    🧑 ",
            r"🧑   ⚽️     🧑 ",
            r"🧑  ⚽️      🧑 "
            ],
            "mindblown".into() => vec![
            r"😐 ",
            r"😐 ",
            r"😮 ",
            r"😮 ",
            r"😦 ",
            r"😦 ",
            r"😧 ",
            r"😧 ",
            r"🤯 ",
            r"💥 ",
            r"✨ ",
            r"　 ",
            r"　 ",
            r"　 "
            ],
            "speaker".into() => vec![
            r"🔈 ",
            r"🔉 ",
            r"🔊 ",
            r"🔉 "
            ],
            "orangePulse".into() => vec![
            r"🔸 ",
            r"🔶 ",
            r"🟠 ",
            r"🟠 ",
            r"🔶 "
            ],
            "bluePulse".into() => vec![
            r"🔹 ",
            r"🔷 ",
            r"🔵 ",
            r"🔵 ",
            r"🔷 "
            ],
            "orangeBluePulse".into() => vec![
            r"🔸 ",
            r"🔶 ",
            r"🟠 ",
            r"🟠 ",
            r"🔶 ",
            r"🔹 ",
            r"🔷 ",
            r"🔵 ",
            r"🔵 ",
            r"🔷 "
            ],
            "timeTravel".into() => vec![
            r"🕛 ",
            r"🕚 ",
            r"🕙 ",
            r"🕘 ",
            r"🕗 ",
            r"🕖 ",
            r"🕕 ",
            r"🕔 ",
            r"🕓 ",
            r"🕒 ",
            r"🕑 ",
            r"🕐 "
            ],
            "aesthetic".into() => vec![
            r"▰▱▱▱▱▱▱",
            r"▰▰▱▱▱▱▱",
            r"▰▰▰▱▱▱▱",
            r"▰▰▰▰▱▱▱",
            r"▰▰▰▰▰▱▱",
            r"▰▰▰▰▰▰▱",
            r"▰▰▰▰▰▰▰",
            r"▰▱▱▱▱▱▱"
            ],
        }
    };
}
