use std::collections::HashMap;

use lazy_static::lazy_static;
use maplit::hashmap;
use strum::{Display, EnumIter, EnumString};

use crate::Error;

#[derive(Debug, Clone, Copy, EnumIter, Display, EnumString)]
#[strum(serialize_all = "camelCase")]
pub enum Spinners {
    Dots,
    Dots2,
    Dots3,
    Dots4,
    Dots5,
    Dots6,
    Dots7,
    Dots8,
    Dots9,
    Dots10,
    Dots11,
    Pipe,
    Star,
    Star2,
    Flip,
    Hamburger,
    GrowVertical,
    GrowHorizontal,
    Balloon,
    Balloon2,
    Noise,
    Bounce,
    BoxBounce,
    BoxBounce2,
    Triangle,
    Arc,
    Circle,
    SquareCorners,
    CircleQuaters,
    CircleHalves,
    Squish,
    Toggle,
    Toggle2,
    Toggle3,
    Toggle4,
    Toggle5,
    Toggle6,
    Toggle7,
    Toggle8,
    Toggle9,
    Toggle10,
    Toggle11,
    Toggle12,
    Toggle13,
    Arrow,
    Dots12,
    Dots8Bit,
    Line,
    Line2,
    SimpleDots,
    SimpleDotsScrolling,
    Arrow2,
    Arrow3,
    BouncingBar,
    BouncingBall,
    Smiley,
    Monkey,
    Hearts,
    Clock,
    Earth,
    Material,
    Moon,
    Runner,
    Pong,
    Shark,
    Dqpb,
    Weather,
    Christmas,
    Grenade,
    Point,
    Layer,
    BetaWave,
    FingerDance,
    FistBump,
    SoccerHeader,
    Mindblown,
    Speaker,
    OrangePulse,
    BluePulse,
    OrangeBluePulse,
    TimeTravel,
    Aesthetic,
}

impl Spinners {
    pub fn get_frames(&self) -> Result<Vec<&'static str>, Error> {
        if let Some(frames) = SPINNER_MAP.get(&self.to_string()) {
            Ok(frames.to_vec())
        } else {
            Err(Error::UnknownSpinner(self.to_string()))
        }
    }
}

lazy_static! {
    pub(crate) static ref SPINNER_MAP: HashMap<String, Vec<&'static str>> = {
        hashmap! {
            "dots".into() => vec!["⠋","⠙","⠹","⠸","⠼","⠴","⠦","⠧","⠇","⠏"],
            "dots2".into()  =>  vec!["⣾","⣽","⣻","⢿","⡿","⣟","⣯","⣷"],
            "dots3".into()  =>  vec!["⠋","⠙","⠚","⠞","⠖","⠦","⠴","⠲","⠳","⠓"],
            "dots4".into()  =>  vec!["⠄","⠆","⠇","⠋","⠙","⠸","⠰","⠠","⠰","⠸","⠙","⠋","⠇","⠆"],
            "dots5".into()  =>  vec!["⠋","⠙","⠚","⠒","⠂","⠂","⠒","⠲","⠴","⠦","⠖","⠒","⠐","⠐","⠒","⠓","⠋"],
            "dots6".into()  =>  vec!["⠁","⠉","⠙","⠚","⠒","⠂","⠂","⠒","⠲","⠴","⠤","⠄","⠄","⠤","⠴","⠲","⠒","⠂","⠂","⠒","⠚","⠙","⠉","⠁"],
            "dots7".into()  =>  vec!["⠈","⠉","⠋","⠓","⠒","⠐","⠐","⠒","⠖","⠦","⠤","⠠","⠠","⠤","⠦","⠖","⠒","⠐","⠐","⠒","⠓","⠋","⠉","⠈"],
            "dots8".into()  =>  vec!["⠁","⠁","⠉","⠙","⠚","⠒","⠂","⠂","⠒","⠲","⠴","⠤","⠄","⠄","⠤","⠠","⠠","⠤","⠦","⠖","⠒","⠐","⠐","⠒","⠓","⠋","⠉","⠈","⠈"],
            "dots9".into()  =>  vec!["⢹","⢺","⢼","⣸","⣇","⡧","⡗","⡏"],
            "dots10".into()  =>  vec!["⢄","⢂","⢁","⡁","⡈","⡐","⡠"],
            "dots11".into()  =>  vec!["⠁","⠂","⠄","⡀","⢀","⠠","⠐","⠈"],
            "pipe".into()  =>  vec!["┤","┘","┴","└","├","┌","┬","┐"],
            "star".into()  =>  vec!["✶","✸","✹","✺","✹","✷"],
            "star2".into()  =>  vec!["+","x","*"],
            "flip".into()  =>  vec!["_","_","_","-","`","`","'","´","-","_","_","_"],
            "hamburger".into()  =>  vec!["☱","☲","☴"],
            "growVertical".into()  =>  vec!["▁","▃","▄","▅","▆","▇","▆","▅","▄","▃"],
            "growHorizontal".into()  =>  vec!["▏","▎","▍","▌","▋","▊","▉","▊","▋","▌","▍","▎"],
            "balloon".into()  =>  vec![".","i","n","t","o","(",")"," ",".","o","O","@","*"," "],
            "balloon2".into()  =>  vec![".","o","O","°","O","o","."],
            "noise".into()  =>  vec!["▓","▒","░"],
            "bounce".into()  =>  vec!["⠁","⠂","⠄","⠂"],
            "boxBounce".into()  =>  vec!["▖","▘","▝","▗"],
            "boxBounce2".into()  =>  vec!["▌","▀","▐","▄"],
            "triangle".into()  =>  vec!["◢","◣","◤","◥"],
            "arc".into()  =>  vec!["◜","◠","◝","◞","◡","◟"],
            "circle".into()  =>  vec!["◡","⊙","◠"],
            "squareCorners".into()  =>  vec!["◰","◳","◲","◱"],
            "circleQuaters".into()  =>  vec!["◴","◷","◶","◵"],
            "circleHalves".into()  =>  vec!["◐","◓","◑","◒"],
            "squish".into()  =>  vec!["╫","╪"],
            "toggle".into()  =>  vec!["⊶","⊷"],
            "toggle2".into()  =>  vec!["▫","▪"],
            "toggle3".into()  =>  vec!["□","■"],
            "toggle4".into()  =>  vec!["■","□","▪","▫"],
            "toggle5".into()  =>  vec!["▮","▯"],
            "toggle6".into()  =>  vec!["ဝ","၀"],
            "toggle7".into()  =>  vec!["⦾","⦿"],
            "toggle8".into()  =>  vec!["◍","◌"],
            "toggle9".into()  =>  vec!["◉","◎"],
            "toggle10".into()  =>  vec!["㊂","㊀","㊁"],
            "toggle11".into()  =>  vec!["⧇","⧆"],
            "toggle12".into()  =>  vec!["☗","☖"],
            "toggle13".into()  =>  vec!["=","*","-"],
            "arrow".into()  =>  vec!["←","↖","↑","↗","→","↘","↓","↙"],
            "dots8Bit".into() => vec![
            "⠀",
            "⠁",
            "⠂",
            "⠃",
            "⠄",
            "⠅",
            "⠆",
            "⠇",
            "⡀",
            "⡁",
            "⡂",
            "⡃",
            "⡄",
            "⡅",
            "⡆",
            "⡇",
            "⠈",
            "⠉",
            "⠊",
            "⠋",
            "⠌",
            "⠍",
            "⠎",
            "⠏",
            "⡈",
            "⡉",
            "⡊",
            "⡋",
            "⡌",
            "⡍",
            "⡎",
            "⡏",
            "⠐",
            "⠑",
            "⠒",
            "⠓",
            "⠔",
            "⠕",
            "⠖",
            "⠗",
            "⡐",
            "⡑",
            "⡒",
            "⡓",
            "⡔",
            "⡕",
            "⡖",
            "⡗",
            "⠘",
            "⠙",
            "⠚",
            "⠛",
            "⠜",
            "⠝",
            "⠞",
            "⠟",
            "⡘",
            "⡙",
            "⡚",
            "⡛",
            "⡜",
            "⡝",
            "⡞",
            "⡟",
            "⠠",
            "⠡",
            "⠢",
            "⠣",
            "⠤",
            "⠥",
            "⠦",
            "⠧",
            "⡠",
            "⡡",
            "⡢",
            "⡣",
            "⡤",
            "⡥",
            "⡦",
            "⡧",
            "⠨",
            "⠩",
            "⠪",
            "⠫",
            "⠬",
            "⠭",
            "⠮",
            "⠯",
            "⡨",
            "⡩",
            "⡪",
            "⡫",
            "⡬",
            "⡭",
            "⡮",
            "⡯",
            "⠰",
            "⠱",
            "⠲",
            "⠳",
            "⠴",
            "⠵",
            "⠶",
            "⠷",
            "⡰",
            "⡱",
            "⡲",
            "⡳",
            "⡴",
            "⡵",
            "⡶",
            "⡷",
            "⠸",
            "⠹",
            "⠺",
            "⠻",
            "⠼",
            "⠽",
            "⠾",
            "⠿",
            "⡸",
            "⡹",
            "⡺",
            "⡻",
            "⡼",
            "⡽",
            "⡾",
            "⡿",
            "⢀",
            "⢁",
            "⢂",
            "⢃",
            "⢄",
            "⢅",
            "⢆",
            "⢇",
            "⣀",
            "⣁",
            "⣂",
            "⣃",
            "⣄",
            "⣅",
            "⣆",
            "⣇",
            "⢈",
            "⢉",
            "⢊",
            "⢋",
            "⢌",
            "⢍",
            "⢎",
            "⢏",
            "⣈",
            "⣉",
            "⣊",
            "⣋",
            "⣌",
            "⣍",
            "⣎",
            "⣏",
            "⢐",
            "⢑",
            "⢒",
            "⢓",
            "⢔",
            "⢕",
            "⢖",
            "⢗",
            "⣐",
            "⣑",
            "⣒",
            "⣓",
            "⣔",
            "⣕",
            "⣖",
            "⣗",
            "⢘",
            "⢙",
            "⢚",
            "⢛",
            "⢜",
            "⢝",
            "⢞",
            "⢟",
            "⣘",
            "⣙",
            "⣚",
            "⣛",
            "⣜",
            "⣝",
            "⣞",
            "⣟",
            "⢠",
            "⢡",
            "⢢",
            "⢣",
            "⢤",
            "⢥",
            "⢦",
            "⢧",
            "⣠",
            "⣡",
            "⣢",
            "⣣",
            "⣤",
            "⣥",
            "⣦",
            "⣧",
            "⢨",
            "⢩",
            "⢪",
            "⢫",
            "⢬",
            "⢭",
            "⢮",
            "⢯",
            "⣨",
            "⣩",
            "⣪",
            "⣫",
            "⣬",
            "⣭",
            "⣮",
            "⣯",
            "⢰",
            "⢱",
            "⢲",
            "⢳",
            "⢴",
            "⢵",
            "⢶",
            "⢷",
            "⣰",
            "⣱",
            "⣲",
            "⣳",
            "⣴",
            "⣵",
            "⣶",
            "⣷",
            "⢸",
            "⢹",
            "⢺",
            "⢻",
            "⢼",
            "⢽",
            "⢾",
            "⢿",
            "⣸",
            "⣹",
            "⣺",
            "⣻",
            "⣼",
            "⣽",
            "⣾",
            "⣿"
            ],
            "Line".into() => vec![
            "-",
            "\\",
            "|",
            "/"
            ],
            "Line2".into() => vec![
            "⠂",
            "-",
            "–",
            "—",
            "–",
            "-"
            ],
            "Pipe".into() => vec![
            "┤",
            "┘",
            "┴",
            "└",
            "├",
            "┌",
            "┬",
            "┐"
            ],
            "SimpleDots".into() => vec![
            ".  ",
            ".. ",
            "...",
            "   "
            ],
            "SimpleDotsScrolling".into() => vec![
            ".  ",
            ".. ",
            "...",
            " ..",
            "  .",
            "   "
            ],
            "Star".into() => vec![
            "✶",
            "✸",
            "✹",
            "✺",
            "✹",
            "✷"
            ],
            "Star2".into() => vec![
            "+",
            "x",
            "*"
            ],
            "Flip".into() => vec![
            "_",
            "_",
            "_",
            "-",
            "`",
            "`",
            "'",
            "´",
            "-",
            "_",
            "_",
            "_"
            ],
            "Hamburger".into() => vec![
            "☱",
            "☲",
            "☴"
            ],        "GrowVertical".into() => vec![
            "▁",
            "▃",
            "▄",
            "▅",
            "▆",
            "▇",
            "▆",
            "▅",
            "▄",
            "▃"
            ],
            "GrowHorizontal".into() => vec![
            "▏",
            "▎",
            "▍",
            "▌",
            "▋",
            "▊",
            "▉",
            "▊",
            "▋",
            "▌",
            "▍",
            "▎"
            ],
            "Balloon".into() => vec![
            " ",
            ".",
            "o",
            "O",
            "@",
            "*",
            " "
            ],
            "Balloon2".into() => vec![
            ".",
            "o",
            "O",
            "°",
            "O",
            "o",
            "."
            ],
            "Noise".into() => vec![
            "▓",
            "▒",
            "░"
            ],        "Bounce".into() => vec![
            "⠁",
            "⠂",
            "⠄",
            "⠂"
            ],
            "BoxBounce".into() => vec![
            "▖",
            "▘",
            "▝",
            "▗"
            ],
            "BoxBounce2".into() => vec![
            "▌",
            "▀",
            "▐",
            "▄"
            ],        "Triangle".into() => vec![
            "◢",
            "◣",
            "◤",
            "◥"
            ],
            "Arc".into() => vec![
            "◜",
            "◠",
            "◝",
            "◞",
            "◡",
            "◟"
            ],
            "Circle".into() => vec![
            "◡",
            "⊙",
            "◠"
            ],
            "squareCorners".into() => vec![
            "◰",
            "◳",
            "◲",
            "◱"
            ],
            "circleQuarters".into() => vec![
            "◴",
            "◷",
            "◶",
            "◵"
            ],
            "circleHalves".into() => vec![
            "◐",
            "◓",
            "◑",
            "◒"
            ],
            "squish".into() => vec![
            "╫",
            "╪"
            ],
            "toggle".into() => vec![
            "⊶",
            "⊷"
            ],
            "toggle2".into() => vec![
            "▫",
            "▪"
            ],
            "toggle3".into() => vec![
            "□",
            "■"
            ],
            "toggle4".into() => vec![
            "■",
            "□",
            "▪",
            "▫"
            ],
            "toggle5".into() => vec![
            "▮",
            "▯"
            ],
            "toggle6".into() => vec![
            "ဝ",
            "၀"
            ],
            "toggle7".into() => vec![
            "⦾",
            "⦿"
            ],
            "toggle8".into() => vec![
            "◍",
            "◌"
            ],
            "toggle9".into() => vec![
            "◉",
            "◎"
            ],
            "toggle10".into() => vec![
            "㊂",
            "㊀",
            "㊁"
            ],
            "toggle11".into() => vec![
            "⧇",
            "⧆"
            ],
            "toggle12".into() => vec![
            "☗",
            "☖"
            ],
            "toggle13".into() => vec![
            "=",
            "*",
            "-"
            ],
            "arrow".into() => vec![
            "←",
            "↖",
            "↑",
            "↗",
            "→",
            "↘",
            "↓",
            "↙"
            ],
            "arrow2".into() => vec![
            "⬆️ ",
            "↗️ ",
            "➡️ ",
            "↘️ ",
            "⬇️ ",
            "↙️ ",
            "⬅️ ",
            "↖️ "
            ],
            "arrow3".into() => vec![
            "▹▹▹▹▹",
            "▸▹▹▹▹",
            "▹▸▹▹▹",
            "▹▹▸▹▹",
            "▹▹▹▸▹",
            "▹▹▹▹▸"
            ],
            "bouncingBar".into() => vec![
            "[    ]",
            "[=   ]",
            "[==  ]",
            "[=== ]",
            "[ ===]",
            "[  ==]",
            "[   =]",
            "[    ]",
            "[   =]",
            "[  ==]",
            "[ ===]",
            "[====]",
            "[=== ]",
            "[==  ]",
            "[=   ]"
            ],
            "bouncingBall".into() => vec![
            "( ●    )",
            "(  ●   )",
            "(   ●  )",
            "(    ● )",
            "(     ●)",
            "(    ● )",
            "(   ●  )",
            "(  ●   )",
            "( ●    )",
            "(●     )"
            ],
            "smiley".into() => vec![
            "😄 ",
            "😝 "
            ],
            "monkey".into() => vec![
            "🙈 ",
            "🙈 ",
            "🙉 ",
            "🙊 "
            ],
            "hearts".into() => vec![
            "💛 ",
            "💙 ",
            "💜 ",
            "💚 ",
            "❤️ "
            ],
            "clock".into() => vec![
            "🕛 ",
            "🕐 ",
            "🕑 ",
            "🕒 ",
            "🕓 ",
            "🕔 ",
            "🕕 ",
            "🕖 ",
            "🕗 ",
            "🕘 ",
            "🕙 ",
            "🕚 "
            ],
            "earth".into() => vec![
            "🌍 ",
            "🌎 ",
            "🌏 "
            ],
            "material".into() => vec![
            "█▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁",
            "██▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁",
            "███▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁",
            "████▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁",
            "██████▁▁▁▁▁▁▁▁▁▁▁▁▁▁",
            "██████▁▁▁▁▁▁▁▁▁▁▁▁▁▁",
            "███████▁▁▁▁▁▁▁▁▁▁▁▁▁",
            "████████▁▁▁▁▁▁▁▁▁▁▁▁",
            "█████████▁▁▁▁▁▁▁▁▁▁▁",
            "█████████▁▁▁▁▁▁▁▁▁▁▁",
            "██████████▁▁▁▁▁▁▁▁▁▁",
            "███████████▁▁▁▁▁▁▁▁▁",
            "█████████████▁▁▁▁▁▁▁",
            "██████████████▁▁▁▁▁▁",
            "██████████████▁▁▁▁▁▁",
            "▁██████████████▁▁▁▁▁",
            "▁██████████████▁▁▁▁▁",
            "▁██████████████▁▁▁▁▁",
            "▁▁██████████████▁▁▁▁",
            "▁▁▁██████████████▁▁▁",
            "▁▁▁▁█████████████▁▁▁",
            "▁▁▁▁██████████████▁▁",
            "▁▁▁▁██████████████▁▁",
            "▁▁▁▁▁██████████████▁",
            "▁▁▁▁▁██████████████▁",
            "▁▁▁▁▁██████████████▁",
            "▁▁▁▁▁▁██████████████",
            "▁▁▁▁▁▁██████████████",
            "▁▁▁▁▁▁▁█████████████",
            "▁▁▁▁▁▁▁█████████████",
            "▁▁▁▁▁▁▁▁████████████",
            "▁▁▁▁▁▁▁▁████████████",
            "▁▁▁▁▁▁▁▁▁███████████",
            "▁▁▁▁▁▁▁▁▁███████████",
            "▁▁▁▁▁▁▁▁▁▁██████████",
            "▁▁▁▁▁▁▁▁▁▁██████████",
            "▁▁▁▁▁▁▁▁▁▁▁▁████████",
            "▁▁▁▁▁▁▁▁▁▁▁▁▁███████",
            "▁▁▁▁▁▁▁▁▁▁▁▁▁▁██████",
            "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁█████",
            "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁█████",
            "█▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁████",
            "██▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁███",
            "██▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁███",
            "███▁▁▁▁▁▁▁▁▁▁▁▁▁▁███",
            "████▁▁▁▁▁▁▁▁▁▁▁▁▁▁██",
            "█████▁▁▁▁▁▁▁▁▁▁▁▁▁▁█",
            "█████▁▁▁▁▁▁▁▁▁▁▁▁▁▁█",
            "██████▁▁▁▁▁▁▁▁▁▁▁▁▁█",
            "████████▁▁▁▁▁▁▁▁▁▁▁▁",
            "█████████▁▁▁▁▁▁▁▁▁▁▁",
            "█████████▁▁▁▁▁▁▁▁▁▁▁",
            "█████████▁▁▁▁▁▁▁▁▁▁▁",
            "█████████▁▁▁▁▁▁▁▁▁▁▁",
            "███████████▁▁▁▁▁▁▁▁▁",
            "████████████▁▁▁▁▁▁▁▁",
            "████████████▁▁▁▁▁▁▁▁",
            "██████████████▁▁▁▁▁▁",
            "██████████████▁▁▁▁▁▁",
            "▁██████████████▁▁▁▁▁",
            "▁██████████████▁▁▁▁▁",
            "▁▁▁█████████████▁▁▁▁",
            "▁▁▁▁▁████████████▁▁▁",
            "▁▁▁▁▁████████████▁▁▁",
            "▁▁▁▁▁▁███████████▁▁▁",
            "▁▁▁▁▁▁▁▁█████████▁▁▁",
            "▁▁▁▁▁▁▁▁█████████▁▁▁",
            "▁▁▁▁▁▁▁▁▁█████████▁▁",
            "▁▁▁▁▁▁▁▁▁█████████▁▁",
            "▁▁▁▁▁▁▁▁▁▁█████████▁",
            "▁▁▁▁▁▁▁▁▁▁▁████████▁",
            "▁▁▁▁▁▁▁▁▁▁▁████████▁",
            "▁▁▁▁▁▁▁▁▁▁▁▁███████▁",
            "▁▁▁▁▁▁▁▁▁▁▁▁███████▁",
            "▁▁▁▁▁▁▁▁▁▁▁▁▁███████",
            "▁▁▁▁▁▁▁▁▁▁▁▁▁███████",
            "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁█████",
            "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁████",
            "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁████",
            "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁████",
            "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁███",
            "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁███",
            "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁██",
            "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁██",
            "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁██",
            "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁█",
            "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁█",
            "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁█",
            "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁",
            "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁",
            "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁",
            "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁"
            ],
            "moon".into() => vec![
            "🌑 ",
            "🌒 ",
            "🌓 ",
            "🌔 ",
            "🌕 ",
            "🌖 ",
            "🌗 ",
            "🌘 "
            ],
            "runner".into() => vec![
            "🚶 ",
            "🏃 "
            ],
            "pong".into() => vec![
            "▐⠂       ▌",
            "▐⠈       ▌",
            "▐ ⠂      ▌",
            "▐ ⠠      ▌",
            "▐  ⡀     ▌",
            "▐  ⠠     ▌",
            "▐   ⠂    ▌",
            "▐   ⠈    ▌",
            "▐    ⠂   ▌",
            "▐    ⠠   ▌",
            "▐     ⡀  ▌",
            "▐     ⠠  ▌",
            "▐      ⠂ ▌",
            "▐      ⠈ ▌",
            "▐       ⠂▌",
            "▐       ⠠▌",
            "▐       ⡀▌",
            "▐      ⠠ ▌",
            "▐      ⠂ ▌",
            "▐     ⠈  ▌",
            "▐     ⠂  ▌",
            "▐    ⠠   ▌",
            "▐    ⡀   ▌",
            "▐   ⠠    ▌",
            "▐   ⠂    ▌",
            "▐  ⠈     ▌",
            "▐  ⠂     ▌",
            "▐ ⠠      ▌",
            "▐ ⡀      ▌",
            "▐⠠       ▌"
            ],
            "shark".into() => vec![
            "▐|\\____________▌",
            "▐_|\\___________▌",
            "▐__|\\__________▌",
            "▐___|\\_________▌",
            "▐____|\\________▌",
            "▐_____|\\_______▌",
            "▐______|\\______▌",
            "▐_______|\\_____▌",
            "▐________|\\____▌",
            "▐_________|\\___▌",
            "▐__________|\\__▌",
            "▐___________|\\_▌",
            "▐____________|\\▌",
            "▐____________/|▌",
            "▐___________/|_▌",
            "▐__________/|__▌",
            "▐_________/|___▌",
            "▐________/|____▌",
            "▐_______/|_____▌",
            "▐______/|______▌",
            "▐_____/|_______▌",
            "▐____/|________▌",
            "▐___/|_________▌",
            "▐__/|__________▌",
            "▐_/|___________▌",
            "▐/|____________▌"
            ],
            "dqpb".into() => vec![
            "d",
            "q",
            "p",
            "b"
            ],
            "weather".into() => vec![
            "☀️ ",
            "☀️ ",
            "☀️ ",
            "🌤 ",
            "⛅️ ",
            "🌥 ",
            "☁️ ",
            "🌧 ",
            "🌨 ",
            "🌧 ",
            "🌨 ",
            "🌧 ",
            "🌨 ",
            "⛈ ",
            "🌨 ",
            "🌧 ",
            "🌨 ",
            "☁️ ",
            "🌥 ",
            "⛅️ ",
            "🌤 ",
            "☀️ ",
            "☀️ "
            ],
            "christmas".into() => vec![
            "🌲",
            "🎄"
            ],
            "grenade".into() => vec![
            "،  ",
            "′  ",
            " ´ ",
            " ‾ ",
            "  ⸌",
            "  ⸊",
            "  |",
            "  ⁎",
            "  ⁕",
            " ෴ ",
            "  ⁓",
            "   ",
            "   ",
            "   "
            ],
            "point".into() => vec![
            "∙∙∙",
            "●∙∙",
            "∙●∙",
            "∙∙●",
            "∙∙∙"
            ],
            "layer".into() => vec![
            "-",
            "=",
            "≡"
            ],
            "betaWave".into() => vec![
            "ρββββββ",
            "βρβββββ",
            "ββρββββ",
            "βββρβββ",
            "ββββρββ",
            "βββββρβ",
            "ββββββρ"
            ],
            "fingerDance".into() => vec![
            "🤘 ",
            "🤟 ",
            "🖖 ",
            "✋ ",
            "🤚 ",
            "👆 "
            ],
            "fistBump".into() => vec![
            "🤜　　　　🤛 ",
            "🤜　　　　🤛 ",
            "🤜　　　　🤛 ",
            "　🤜　　🤛　 ",
            "　　🤜🤛　　 ",
            "　🤜✨🤛　　 ",
            "🤜　✨　🤛　 "
            ],
            "soccerHeader".into() => vec![
            " 🧑⚽️       🧑 ",
            "🧑  ⚽️      🧑 ",
            "🧑   ⚽️     🧑 ",
            "🧑    ⚽️    🧑 ",
            "🧑     ⚽️   🧑 ",
            "🧑      ⚽️  🧑 ",
            "🧑       ⚽️🧑  ",
            "🧑      ⚽️  🧑 ",
            "🧑     ⚽️   🧑 ",
            "🧑    ⚽️    🧑 ",
            "🧑   ⚽️     🧑 ",
            "🧑  ⚽️      🧑 "
            ],
            "mindblown".into() => vec![
            "😐 ",
            "😐 ",
            "😮 ",
            "😮 ",
            "😦 ",
            "😦 ",
            "😧 ",
            "😧 ",
            "🤯 ",
            "💥 ",
            "✨ ",
            "　 ",
            "　 ",
            "　 "
            ],
            "speaker".into() => vec![
            "🔈 ",
            "🔉 ",
            "🔊 ",
            "🔉 "
            ],
            "orangePulse".into() => vec![
            "🔸 ",
            "🔶 ",
            "🟠 ",
            "🟠 ",
            "🔶 "
            ],
            "bluePulse".into() => vec![
            "🔹 ",
            "🔷 ",
            "🔵 ",
            "🔵 ",
            "🔷 "
            ],
            "orangeBluePulse".into() => vec![
            "🔸 ",
            "🔶 ",
            "🟠 ",
            "🟠 ",
            "🔶 ",
            "🔹 ",
            "🔷 ",
            "🔵 ",
            "🔵 ",
            "🔷 "
            ],
            "timeTravel".into() => vec![
            "🕛 ",
            "🕚 ",
            "🕙 ",
            "🕘 ",
            "🕗 ",
            "🕖 ",
            "🕕 ",
            "🕔 ",
            "🕓 ",
            "🕒 ",
            "🕑 ",
            "🕐 "
            ],
            "aesthetic".into() => vec![
            "▰▱▱▱▱▱▱",
            "▰▰▱▱▱▱▱",
            "▰▰▰▱▱▱▱",
            "▰▰▰▰▱▱▱",
            "▰▰▰▰▰▱▱",
            "▰▰▰▰▰▰▱",
            "▰▰▰▰▰▰▰",
            "▰▱▱▱▱▱▱"
            ],
        }
    };
}
