// Take a look at the license at the top of the repository in the LICENSE file.

use std::os::unix::io::{IntoRawFd, RawFd};

use glib::translate::*;

use crate::GlScanout;

impl GlScanout {
    pub fn fd(&self) -> RawFd {
        unsafe { (*self.to_glib_none().0).fd }
    }

    pub fn width(&self) -> u32 {
        unsafe { (*self.to_glib_none().0).width }
    }

    pub fn height(&self) -> u32 {
        unsafe { (*self.to_glib_none().0).height }
    }

    pub fn stride(&self) -> u32 {
        unsafe { (*self.to_glib_none().0).stride }
    }

    pub fn format(&self) -> u32 {
        unsafe { (*self.to_glib_none().0).format }
    }

    pub fn y0_top(&self) -> bool {
        unsafe { from_glib((*self.to_glib_none().0).y0top) }
    }
}

impl IntoRawFd for GlScanout {
    fn into_raw_fd(mut self) -> RawFd {
        unsafe {
            let ffi = &mut *self.to_glib_none_mut().0;
            // close is unchecked in spice-gtk
            std::mem::replace(&mut ffi.fd, -1)
        }
    }
}
