// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Channel;
use crate::SessionMigration;
use crate::SessionVerify;
use crate::URI;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "SpiceSession")]
    pub struct Session(Object<ffi::SpiceSession, ffi::SpiceSessionClass>);

    match fn {
        type_ => || ffi::spice_session_get_type(),
    }
}

impl Session {
    #[doc(alias = "spice_session_new")]
    pub fn new() -> Session {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::spice_session_new()) }
    }

    #[doc(alias = "spice_session_connect")]
    pub fn connect(&self) -> bool {
        unsafe { from_glib(ffi::spice_session_connect(self.to_glib_none().0)) }
    }

    #[doc(alias = "spice_session_disconnect")]
    pub fn disconnect(&self) {
        unsafe {
            ffi::spice_session_disconnect(self.to_glib_none().0);
        }
    }

    #[doc(alias = "spice_session_get_channels")]
    #[doc(alias = "get_channels")]
    pub fn channels(&self) -> Vec<Channel> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::spice_session_get_channels(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "spice_session_get_proxy_uri")]
    #[doc(alias = "get_proxy_uri")]
    pub fn proxy_uri(&self) -> Option<URI> {
        unsafe { from_glib_none(ffi::spice_session_get_proxy_uri(self.to_glib_none().0)) }
    }

    #[doc(alias = "spice_session_get_read_only")]
    #[doc(alias = "get_read_only")]
    pub fn is_read_only(&self) -> bool {
        unsafe { from_glib(ffi::spice_session_get_read_only(self.to_glib_none().0)) }
    }

    #[doc(alias = "spice_session_has_channel_type")]
    pub fn has_channel_type(&self, type_: i32) -> bool {
        unsafe {
            from_glib(ffi::spice_session_has_channel_type(
                self.to_glib_none().0,
                type_,
            ))
        }
    }

    #[doc(alias = "spice_session_is_for_migration")]
    pub fn is_for_migration(&self) -> bool {
        unsafe { from_glib(ffi::spice_session_is_for_migration(self.to_glib_none().0)) }
    }

    #[doc(alias = "spice_session_open_fd")]
    pub fn open_fd(&self, fd: i32) -> bool {
        unsafe { from_glib(ffi::spice_session_open_fd(self.to_glib_none().0, fd)) }
    }

    pub fn ca(&self) -> Option<glib::ByteArray> {
        glib::ObjectExt::property(self, "ca")
    }

    pub fn set_ca(&self, ca: Option<&glib::ByteArray>) {
        glib::ObjectExt::set_property(self, "ca", &ca)
    }

    #[doc(alias = "ca-file")]
    pub fn ca_file(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "ca-file")
    }

    #[doc(alias = "ca-file")]
    pub fn set_ca_file(&self, ca_file: Option<&str>) {
        glib::ObjectExt::set_property(self, "ca-file", &ca_file)
    }

    #[doc(alias = "cache-size")]
    pub fn cache_size(&self) -> i32 {
        glib::ObjectExt::property(self, "cache-size")
    }

    #[doc(alias = "cache-size")]
    pub fn set_cache_size(&self, cache_size: i32) {
        glib::ObjectExt::set_property(self, "cache-size", &cache_size)
    }

    #[doc(alias = "cert-subject")]
    pub fn cert_subject(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "cert-subject")
    }

    #[doc(alias = "cert-subject")]
    pub fn set_cert_subject(&self, cert_subject: Option<&str>) {
        glib::ObjectExt::set_property(self, "cert-subject", &cert_subject)
    }

    pub fn ciphers(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "ciphers")
    }

    pub fn set_ciphers(&self, ciphers: Option<&str>) {
        glib::ObjectExt::set_property(self, "ciphers", &ciphers)
    }

    #[doc(alias = "client-sockets")]
    pub fn is_client_sockets(&self) -> bool {
        glib::ObjectExt::property(self, "client-sockets")
    }

    #[doc(alias = "client-sockets")]
    pub fn set_client_sockets(&self, client_sockets: bool) {
        glib::ObjectExt::set_property(self, "client-sockets", &client_sockets)
    }

    #[doc(alias = "disable-effects")]
    pub fn disable_effects(&self) -> Vec<glib::GString> {
        glib::ObjectExt::property(self, "disable-effects")
    }

    #[doc(alias = "disable-effects")]
    pub fn set_disable_effects(&self, disable_effects: &[&str]) {
        glib::ObjectExt::set_property(self, "disable-effects", &disable_effects)
    }

    #[doc(alias = "enable-audio")]
    pub fn enables_audio(&self) -> bool {
        glib::ObjectExt::property(self, "enable-audio")
    }

    #[doc(alias = "enable-audio")]
    pub fn set_enable_audio(&self, enable_audio: bool) {
        glib::ObjectExt::set_property(self, "enable-audio", &enable_audio)
    }

    #[doc(alias = "enable-smartcard")]
    pub fn enables_smartcard(&self) -> bool {
        glib::ObjectExt::property(self, "enable-smartcard")
    }

    #[doc(alias = "enable-smartcard")]
    pub fn set_enable_smartcard(&self, enable_smartcard: bool) {
        glib::ObjectExt::set_property(self, "enable-smartcard", &enable_smartcard)
    }

    #[doc(alias = "enable-usbredir")]
    pub fn enables_usbredir(&self) -> bool {
        glib::ObjectExt::property(self, "enable-usbredir")
    }

    #[doc(alias = "enable-usbredir")]
    pub fn set_enable_usbredir(&self, enable_usbredir: bool) {
        glib::ObjectExt::set_property(self, "enable-usbredir", &enable_usbredir)
    }

    #[doc(alias = "gl-scanout")]
    pub fn is_gl_scanout(&self) -> bool {
        glib::ObjectExt::property(self, "gl-scanout")
    }

    #[doc(alias = "gl-scanout")]
    pub fn set_gl_scanout(&self, gl_scanout: bool) {
        glib::ObjectExt::set_property(self, "gl-scanout", &gl_scanout)
    }

    #[doc(alias = "glz-window-size")]
    pub fn glz_window_size(&self) -> i32 {
        glib::ObjectExt::property(self, "glz-window-size")
    }

    #[doc(alias = "glz-window-size")]
    pub fn set_glz_window_size(&self, glz_window_size: i32) {
        glib::ObjectExt::set_property(self, "glz-window-size", &glz_window_size)
    }

    pub fn host(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "host")
    }

    pub fn set_host(&self, host: Option<&str>) {
        glib::ObjectExt::set_property(self, "host", &host)
    }

    #[doc(alias = "inhibit-keyboard-grab")]
    pub fn is_inhibit_keyboard_grab(&self) -> bool {
        glib::ObjectExt::property(self, "inhibit-keyboard-grab")
    }

    #[doc(alias = "inhibit-keyboard-grab")]
    pub fn set_inhibit_keyboard_grab(&self, inhibit_keyboard_grab: bool) {
        glib::ObjectExt::set_property(self, "inhibit-keyboard-grab", &inhibit_keyboard_grab)
    }

    #[doc(alias = "migration-state")]
    pub fn migration_state(&self) -> SessionMigration {
        glib::ObjectExt::property(self, "migration-state")
    }

    pub fn name(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "name")
    }

    pub fn password(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "password")
    }

    pub fn set_password(&self, password: Option<&str>) {
        glib::ObjectExt::set_property(self, "password", &password)
    }

    pub fn port(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "port")
    }

    pub fn set_port(&self, port: Option<&str>) {
        glib::ObjectExt::set_property(self, "port", &port)
    }

    pub fn protocol(&self) -> i32 {
        glib::ObjectExt::property(self, "protocol")
    }

    pub fn set_protocol(&self, protocol: i32) {
        glib::ObjectExt::set_property(self, "protocol", &protocol)
    }

    pub fn proxy(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "proxy")
    }

    pub fn set_proxy(&self, proxy: Option<&str>) {
        glib::ObjectExt::set_property(self, "proxy", &proxy)
    }

    pub fn pubkey(&self) -> Option<glib::ByteArray> {
        glib::ObjectExt::property(self, "pubkey")
    }

    pub fn set_pubkey(&self, pubkey: Option<&glib::ByteArray>) {
        glib::ObjectExt::set_property(self, "pubkey", &pubkey)
    }

    #[doc(alias = "read-only")]
    pub fn set_read_only(&self, read_only: bool) {
        glib::ObjectExt::set_property(self, "read-only", &read_only)
    }

    #[doc(alias = "secure-channels")]
    pub fn secure_channels(&self) -> Vec<glib::GString> {
        glib::ObjectExt::property(self, "secure-channels")
    }

    #[doc(alias = "secure-channels")]
    pub fn set_secure_channels(&self, secure_channels: &[&str]) {
        glib::ObjectExt::set_property(self, "secure-channels", &secure_channels)
    }

    #[doc(alias = "share-dir-ro")]
    pub fn is_share_dir_ro(&self) -> bool {
        glib::ObjectExt::property(self, "share-dir-ro")
    }

    #[doc(alias = "share-dir-ro")]
    pub fn set_share_dir_ro(&self, share_dir_ro: bool) {
        glib::ObjectExt::set_property(self, "share-dir-ro", &share_dir_ro)
    }

    #[doc(alias = "shared-dir")]
    pub fn shared_dir(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "shared-dir")
    }

    #[doc(alias = "shared-dir")]
    pub fn set_shared_dir(&self, shared_dir: Option<&str>) {
        glib::ObjectExt::set_property(self, "shared-dir", &shared_dir)
    }

    #[doc(alias = "smartcard-certificates")]
    pub fn smartcard_certificates(&self) -> Vec<glib::GString> {
        glib::ObjectExt::property(self, "smartcard-certificates")
    }

    #[doc(alias = "smartcard-certificates")]
    pub fn set_smartcard_certificates(&self, smartcard_certificates: &[&str]) {
        glib::ObjectExt::set_property(self, "smartcard-certificates", &smartcard_certificates)
    }

    #[doc(alias = "smartcard-db")]
    pub fn smartcard_db(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "smartcard-db")
    }

    #[doc(alias = "smartcard-db")]
    pub fn set_smartcard_db(&self, smartcard_db: Option<&str>) {
        glib::ObjectExt::set_property(self, "smartcard-db", &smartcard_db)
    }

    #[doc(alias = "tls-port")]
    pub fn tls_port(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "tls-port")
    }

    #[doc(alias = "tls-port")]
    pub fn set_tls_port(&self, tls_port: Option<&str>) {
        glib::ObjectExt::set_property(self, "tls-port", &tls_port)
    }

    #[doc(alias = "unix-path")]
    pub fn unix_path(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "unix-path")
    }

    #[doc(alias = "unix-path")]
    pub fn set_unix_path(&self, unix_path: Option<&str>) {
        glib::ObjectExt::set_property(self, "unix-path", &unix_path)
    }

    pub fn uri(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "uri")
    }

    pub fn set_uri(&self, uri: Option<&str>) {
        glib::ObjectExt::set_property(self, "uri", &uri)
    }

    pub fn username(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "username")
    }

    pub fn set_username(&self, username: Option<&str>) {
        glib::ObjectExt::set_property(self, "username", &username)
    }

    //pub fn uuid(&self) -> /*Unimplemented*/Fundamental: Pointer {
    //    glib::ObjectExt::property(self, "uuid")
    //}

    pub fn verify(&self) -> SessionVerify {
        glib::ObjectExt::property(self, "verify")
    }

    pub fn set_verify(&self, verify: SessionVerify) {
        glib::ObjectExt::set_property(self, "verify", &verify)
    }

    #[doc(alias = "channel-destroy")]
    pub fn connect_channel_destroy<F: Fn(&Self, &Channel) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn channel_destroy_trampoline<F: Fn(&Session, &Channel) + 'static>(
            this: *mut ffi::SpiceSession,
            channel: *mut ffi::SpiceChannel,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(channel))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"channel-destroy\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    channel_destroy_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "channel-new")]
    pub fn connect_channel_new<F: Fn(&Self, &Channel) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn channel_new_trampoline<F: Fn(&Session, &Channel) + 'static>(
            this: *mut ffi::SpiceSession,
            channel: *mut ffi::SpiceChannel,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(channel))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"channel-new\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    channel_new_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "disconnected")]
    pub fn connect_disconnected<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn disconnected_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"disconnected\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    disconnected_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "mm-time-reset")]
    pub fn connect_mm_time_reset<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn mm_time_reset_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"mm-time-reset\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    mm_time_reset_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "ca")]
    pub fn connect_ca_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_ca_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::ca\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_ca_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "ca-file")]
    pub fn connect_ca_file_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_ca_file_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::ca-file\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_ca_file_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "cache-size")]
    pub fn connect_cache_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_cache_size_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::cache-size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_cache_size_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "cert-subject")]
    pub fn connect_cert_subject_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_cert_subject_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::cert-subject\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_cert_subject_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "ciphers")]
    pub fn connect_ciphers_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_ciphers_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::ciphers\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_ciphers_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "client-sockets")]
    pub fn connect_client_sockets_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_client_sockets_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::client-sockets\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_client_sockets_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "disable-effects")]
    pub fn connect_disable_effects_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_disable_effects_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::disable-effects\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_disable_effects_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-audio")]
    pub fn connect_enable_audio_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_audio_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-audio\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_enable_audio_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-smartcard")]
    pub fn connect_enable_smartcard_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_smartcard_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-smartcard\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_enable_smartcard_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-usbredir")]
    pub fn connect_enable_usbredir_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_usbredir_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-usbredir\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_enable_usbredir_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gl-scanout")]
    pub fn connect_gl_scanout_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gl_scanout_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gl-scanout\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gl_scanout_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "glz-window-size")]
    pub fn connect_glz_window_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_glz_window_size_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::glz-window-size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_glz_window_size_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "host")]
    pub fn connect_host_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_host_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::host\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_host_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "inhibit-keyboard-grab")]
    pub fn connect_inhibit_keyboard_grab_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_inhibit_keyboard_grab_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::inhibit-keyboard-grab\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_inhibit_keyboard_grab_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "migration-state")]
    pub fn connect_migration_state_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_migration_state_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::migration-state\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_migration_state_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "name")]
    pub fn connect_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_name_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_name_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "password")]
    pub fn connect_password_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_password_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::password\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_password_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "port")]
    pub fn connect_port_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_port_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::port\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_port_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "protocol")]
    pub fn connect_protocol_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_protocol_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::protocol\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_protocol_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "proxy")]
    pub fn connect_proxy_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_proxy_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::proxy\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_proxy_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "pubkey")]
    pub fn connect_pubkey_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_pubkey_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pubkey\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pubkey_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "read-only")]
    pub fn connect_read_only_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_read_only_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::read-only\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_read_only_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "secure-channels")]
    pub fn connect_secure_channels_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_secure_channels_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::secure-channels\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_secure_channels_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "share-dir-ro")]
    pub fn connect_share_dir_ro_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_share_dir_ro_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::share-dir-ro\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_share_dir_ro_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "shared-dir")]
    pub fn connect_shared_dir_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_shared_dir_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::shared-dir\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_shared_dir_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "smartcard-certificates")]
    pub fn connect_smartcard_certificates_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_smartcard_certificates_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::smartcard-certificates\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_smartcard_certificates_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "smartcard-db")]
    pub fn connect_smartcard_db_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_smartcard_db_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::smartcard-db\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_smartcard_db_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "tls-port")]
    pub fn connect_tls_port_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tls_port_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tls-port\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tls_port_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "unix-path")]
    pub fn connect_unix_path_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_unix_path_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::unix-path\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_unix_path_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "uri")]
    pub fn connect_uri_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_uri_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::uri\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_uri_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "username")]
    pub fn connect_username_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_username_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::username\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_username_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "uuid")]
    pub fn connect_uuid_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_uuid_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::uuid\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_uuid_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "verify")]
    pub fn connect_verify_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_verify_trampoline<F: Fn(&Session) + 'static>(
            this: *mut ffi::SpiceSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::verify\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_verify_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for Session {
    fn default() -> Self {
        Self::new()
    }
}

impl fmt::Display for Session {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Session")
    }
}
