// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Session;
use crate::UsbDevice;
use glib::object::IsA;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use std::pin::Pin;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "SpiceUsbDeviceManager")]
    pub struct UsbDeviceManager(Object<ffi::SpiceUsbDeviceManager, ffi::SpiceUsbDeviceManagerClass>);

    match fn {
        type_ => || ffi::spice_usb_device_manager_get_type(),
    }
}

impl UsbDeviceManager {
    #[doc(alias = "spice_usb_device_manager_can_redirect_device")]
    pub fn can_redirect_device(&self, device: &UsbDevice) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::spice_usb_device_manager_can_redirect_device(
                self.to_glib_none().0,
                mut_override(device.to_glib_none().0),
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "spice_usb_device_manager_connect_device_async")]
    pub fn connect_device_async<P: FnOnce(Result<(), glib::Error>) + Send + 'static>(
        &self,
        device: &UsbDevice,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let user_data: Box_<P> = Box_::new(callback);
        unsafe extern "C" fn connect_device_async_trampoline<
            P: FnOnce(Result<(), glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ = ffi::spice_usb_device_manager_connect_device_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<P> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = connect_device_async_trampoline::<P>;
        unsafe {
            ffi::spice_usb_device_manager_connect_device_async(
                self.to_glib_none().0,
                mut_override(device.to_glib_none().0),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    pub fn connect_device_async_future(
        &self,
        device: &UsbDevice,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        let device = device.clone();
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.connect_device_async(&device, Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }

    #[doc(alias = "spice_usb_device_manager_create_shared_cd_device")]
    pub fn create_shared_cd_device(&self, filename: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::spice_usb_device_manager_create_shared_cd_device(
                self.to_glib_none().0,
                filename.to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "spice_usb_device_manager_disconnect_device")]
    pub fn disconnect_device(&self, device: &UsbDevice) {
        unsafe {
            ffi::spice_usb_device_manager_disconnect_device(
                self.to_glib_none().0,
                mut_override(device.to_glib_none().0),
            );
        }
    }

    #[doc(alias = "spice_usb_device_manager_disconnect_device_async")]
    pub fn disconnect_device_async<P: FnOnce(Result<(), glib::Error>) + Send + 'static>(
        &self,
        device: &UsbDevice,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let user_data: Box_<P> = Box_::new(callback);
        unsafe extern "C" fn disconnect_device_async_trampoline<
            P: FnOnce(Result<(), glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ = ffi::spice_usb_device_manager_disconnect_device_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<P> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = disconnect_device_async_trampoline::<P>;
        unsafe {
            ffi::spice_usb_device_manager_disconnect_device_async(
                self.to_glib_none().0,
                mut_override(device.to_glib_none().0),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    pub fn disconnect_device_async_future(
        &self,
        device: &UsbDevice,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        let device = device.clone();
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.disconnect_device_async(&device, Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }

    #[doc(alias = "spice_usb_device_manager_get_devices")]
    #[doc(alias = "get_devices")]
    pub fn devices(&self) -> Vec<UsbDevice> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::spice_usb_device_manager_get_devices(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "spice_usb_device_manager_get_devices_with_filter")]
    #[doc(alias = "get_devices_with_filter")]
    pub fn devices_with_filter(&self, filter: Option<&str>) -> Vec<UsbDevice> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(
                ffi::spice_usb_device_manager_get_devices_with_filter(
                    self.to_glib_none().0,
                    filter.to_glib_none().0,
                ),
            )
        }
    }

    #[doc(alias = "spice_usb_device_manager_is_device_connected")]
    pub fn is_device_connected(&self, device: &UsbDevice) -> bool {
        unsafe {
            from_glib(ffi::spice_usb_device_manager_is_device_connected(
                self.to_glib_none().0,
                mut_override(device.to_glib_none().0),
            ))
        }
    }

    #[doc(alias = "spice_usb_device_manager_is_device_shared_cd")]
    pub fn is_device_shared_cd(&self, device: &UsbDevice) -> bool {
        unsafe {
            from_glib(ffi::spice_usb_device_manager_is_device_shared_cd(
                self.to_glib_none().0,
                mut_override(device.to_glib_none().0),
            ))
        }
    }

    #[doc(alias = "spice_usb_device_manager_is_redirecting")]
    pub fn is_redirecting(&self) -> bool {
        unsafe {
            from_glib(ffi::spice_usb_device_manager_is_redirecting(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "auto-connect")]
    pub fn is_auto_connect(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.as_ptr() as *mut glib::gobject_ffi::GObject,
                b"auto-connect\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `auto-connect` getter")
        }
    }

    #[doc(alias = "auto-connect")]
    pub fn set_auto_connect(&self, auto_connect: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.as_ptr() as *mut glib::gobject_ffi::GObject,
                b"auto-connect\0".as_ptr() as *const _,
                auto_connect.to_value().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "auto-connect-filter")]
    pub fn auto_connect_filter(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.as_ptr() as *mut glib::gobject_ffi::GObject,
                b"auto-connect-filter\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `auto-connect-filter` getter")
        }
    }

    #[doc(alias = "auto-connect-filter")]
    pub fn set_auto_connect_filter(&self, auto_connect_filter: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.as_ptr() as *mut glib::gobject_ffi::GObject,
                b"auto-connect-filter\0".as_ptr() as *const _,
                auto_connect_filter.to_value().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "free-channels")]
    pub fn free_channels(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.as_ptr() as *mut glib::gobject_ffi::GObject,
                b"free-channels\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `free-channels` getter")
        }
    }

    #[doc(alias = "redirect-on-connect")]
    pub fn redirect_on_connect(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.as_ptr() as *mut glib::gobject_ffi::GObject,
                b"redirect-on-connect\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `redirect-on-connect` getter")
        }
    }

    #[doc(alias = "redirect-on-connect")]
    pub fn set_redirect_on_connect(&self, redirect_on_connect: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.as_ptr() as *mut glib::gobject_ffi::GObject,
                b"redirect-on-connect\0".as_ptr() as *const _,
                redirect_on_connect.to_value().to_glib_none().0,
            );
        }
    }

    pub fn session(&self) -> Option<Session> {
        unsafe {
            let mut value = glib::Value::from_type(<Session as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.as_ptr() as *mut glib::gobject_ffi::GObject,
                b"session\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `session` getter")
        }
    }

    #[doc(alias = "spice_usb_device_manager_get")]
    pub fn get(session: &Session) -> Result<UsbDeviceManager, glib::Error> {
        skip_assert_initialized!();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::spice_usb_device_manager_get(session.to_glib_none().0, &mut error);
            if error.is_null() {
                Ok(from_glib_none(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "auto-connect-failed")]
    pub fn connect_auto_connect_failed<F: Fn(&Self, &UsbDevice, &glib::Error) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn auto_connect_failed_trampoline<
            F: Fn(&UsbDeviceManager, &UsbDevice, &glib::Error) + 'static,
        >(
            this: *mut ffi::SpiceUsbDeviceManager,
            device: *mut ffi::SpiceUsbDevice,
            error: *mut glib::ffi::GError,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                &from_glib_borrow(device),
                &from_glib_borrow(error),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"auto-connect-failed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    auto_connect_failed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "device-added")]
    pub fn connect_device_added<F: Fn(&Self, &UsbDevice) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn device_added_trampoline<
            F: Fn(&UsbDeviceManager, &UsbDevice) + 'static,
        >(
            this: *mut ffi::SpiceUsbDeviceManager,
            device: *mut ffi::SpiceUsbDevice,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(device))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"device-added\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    device_added_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "device-error")]
    pub fn connect_device_error<F: Fn(&Self, &UsbDevice, &glib::Error) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn device_error_trampoline<
            F: Fn(&UsbDeviceManager, &UsbDevice, &glib::Error) + 'static,
        >(
            this: *mut ffi::SpiceUsbDeviceManager,
            device: *mut ffi::SpiceUsbDevice,
            error: *mut glib::ffi::GError,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                &from_glib_borrow(device),
                &from_glib_borrow(error),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"device-error\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    device_error_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "device-removed")]
    pub fn connect_device_removed<F: Fn(&Self, &UsbDevice) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn device_removed_trampoline<
            F: Fn(&UsbDeviceManager, &UsbDevice) + 'static,
        >(
            this: *mut ffi::SpiceUsbDeviceManager,
            device: *mut ffi::SpiceUsbDevice,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(device))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"device-removed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    device_removed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "auto-connect")]
    pub fn connect_auto_connect_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_auto_connect_trampoline<F: Fn(&UsbDeviceManager) + 'static>(
            this: *mut ffi::SpiceUsbDeviceManager,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::auto-connect\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_auto_connect_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "auto-connect-filter")]
    pub fn connect_auto_connect_filter_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_auto_connect_filter_trampoline<
            F: Fn(&UsbDeviceManager) + 'static,
        >(
            this: *mut ffi::SpiceUsbDeviceManager,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::auto-connect-filter\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_auto_connect_filter_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "free-channels")]
    pub fn connect_free_channels_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_free_channels_trampoline<F: Fn(&UsbDeviceManager) + 'static>(
            this: *mut ffi::SpiceUsbDeviceManager,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::free-channels\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_free_channels_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "redirect-on-connect")]
    pub fn connect_redirect_on_connect_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_redirect_on_connect_trampoline<
            F: Fn(&UsbDeviceManager) + 'static,
        >(
            this: *mut ffi::SpiceUsbDeviceManager,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::redirect-on-connect\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_redirect_on_connect_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for UsbDeviceManager {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("UsbDeviceManager")
    }
}
