// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Channel;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "SpiceInputsChannel")]
    pub struct InputsChannel(Object<ffi::SpiceInputsChannel, ffi::SpiceInputsChannelClass>) @extends Channel;

    match fn {
        type_ => || ffi::spice_inputs_channel_get_type(),
    }
}

impl InputsChannel {
    #[doc(alias = "spice_inputs_channel_button_press")]
    pub fn button_press(&self, button: i32, button_state: i32) {
        unsafe {
            ffi::spice_inputs_channel_button_press(self.to_glib_none().0, button, button_state);
        }
    }

    #[doc(alias = "spice_inputs_channel_button_release")]
    pub fn button_release(&self, button: i32, button_state: i32) {
        unsafe {
            ffi::spice_inputs_channel_button_release(self.to_glib_none().0, button, button_state);
        }
    }

    #[doc(alias = "spice_inputs_channel_key_press")]
    pub fn key_press(&self, scancode: u32) {
        unsafe {
            ffi::spice_inputs_channel_key_press(self.to_glib_none().0, scancode);
        }
    }

    #[doc(alias = "spice_inputs_channel_key_press_and_release")]
    pub fn key_press_and_release(&self, scancode: u32) {
        unsafe {
            ffi::spice_inputs_channel_key_press_and_release(self.to_glib_none().0, scancode);
        }
    }

    #[doc(alias = "spice_inputs_channel_key_release")]
    pub fn key_release(&self, scancode: u32) {
        unsafe {
            ffi::spice_inputs_channel_key_release(self.to_glib_none().0, scancode);
        }
    }

    #[doc(alias = "spice_inputs_channel_motion")]
    pub fn motion(&self, dx: i32, dy: i32, button_state: i32) {
        unsafe {
            ffi::spice_inputs_channel_motion(self.to_glib_none().0, dx, dy, button_state);
        }
    }

    #[doc(alias = "spice_inputs_channel_position")]
    pub fn position(&self, x: i32, y: i32, display: i32, button_state: i32) {
        unsafe {
            ffi::spice_inputs_channel_position(self.to_glib_none().0, x, y, display, button_state);
        }
    }

    #[doc(alias = "spice_inputs_channel_set_key_locks")]
    pub fn set_key_locks(&self, locks: u32) {
        unsafe {
            ffi::spice_inputs_channel_set_key_locks(self.to_glib_none().0, locks);
        }
    }

    #[doc(alias = "key-modifiers")]
    pub fn key_modifiers(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.as_ptr() as *mut glib::gobject_ffi::GObject,
                b"key-modifiers\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `key-modifiers` getter")
        }
    }

    #[doc(alias = "inputs-modifiers")]
    pub fn connect_inputs_modifiers<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn inputs_modifiers_trampoline<F: Fn(&InputsChannel) + 'static>(
            this: *mut ffi::SpiceInputsChannel,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"inputs-modifiers\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    inputs_modifiers_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "key-modifiers")]
    pub fn connect_key_modifiers_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_key_modifiers_trampoline<F: Fn(&InputsChannel) + 'static>(
            this: *mut ffi::SpiceInputsChannel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::key-modifiers\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_key_modifiers_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for InputsChannel {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("InputsChannel")
    }
}
