// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::ChannelEvent;
use crate::Session;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use std::pin::Pin;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "SpiceChannel")]
    pub struct Channel(Object<ffi::SpiceChannel, ffi::SpiceChannelClass>);

    match fn {
        type_ => || ffi::spice_channel_get_type(),
    }
}

impl Channel {
    #[doc(alias = "spice_channel_new")]
    pub fn new(s: &Session, type_: i32, id: i32) -> Channel {
        skip_assert_initialized!();
        unsafe { from_glib_full(ffi::spice_channel_new(s.to_glib_none().0, type_, id)) }
    }

    #[doc(alias = "spice_channel_string_to_type")]
    pub fn string_to_type(str: &str) -> i32 {
        assert_initialized_main_thread!();
        unsafe { ffi::spice_channel_string_to_type(str.to_glib_none().0) }
    }

    #[doc(alias = "spice_channel_type_to_string")]
    pub fn type_to_string(type_: i32) -> Option<glib::GString> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::spice_channel_type_to_string(type_)) }
    }
}

pub const NONE_CHANNEL: Option<&Channel> = None;

pub trait ChannelExt: 'static {
    #[doc(alias = "spice_channel_connect")]
    fn connect(&self) -> bool;

    #[doc(alias = "spice_channel_disconnect")]
    fn disconnect(&self, reason: ChannelEvent);

    #[doc(alias = "spice_channel_flush_async")]
    fn flush_async<P: FnOnce(Result<(), glib::Error>) + Send + 'static>(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    );

    fn flush_async_future(
        &self,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>>;

    #[doc(alias = "spice_channel_get_error")]
    #[doc(alias = "get_error")]
    fn error(&self) -> Option<glib::Error>;

    #[doc(alias = "spice_channel_open_fd")]
    fn open_fd(&self, fd: i32) -> bool;

    #[doc(alias = "spice_channel_test_capability")]
    fn test_capability(&self, cap: u32) -> bool;

    #[doc(alias = "spice_channel_test_common_capability")]
    fn test_common_capability(&self, cap: u32) -> bool;

    #[doc(alias = "channel-id")]
    fn channel_id(&self) -> i32;

    #[doc(alias = "channel-type")]
    fn channel_type(&self) -> i32;

    fn socket(&self) -> Option<gio::Socket>;

    #[doc(alias = "spice-session")]
    fn spice_session(&self) -> Option<Session>;

    #[doc(alias = "total-read-bytes")]
    fn total_read_bytes(&self) -> libc::c_ulong;

    #[doc(alias = "channel-event")]
    fn connect_channel_event<F: Fn(&Self, ChannelEvent) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "open-fd")]
    fn connect_open_fd<F: Fn(&Self, i32) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "socket")]
    fn connect_socket_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "total-read-bytes")]
    fn connect_total_read_bytes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Channel>> ChannelExt for O {
    fn connect(&self) -> bool {
        unsafe { from_glib(ffi::spice_channel_connect(self.as_ref().to_glib_none().0)) }
    }

    fn disconnect(&self, reason: ChannelEvent) {
        unsafe {
            ffi::spice_channel_disconnect(self.as_ref().to_glib_none().0, reason.into_glib());
        }
    }

    fn flush_async<P: FnOnce(Result<(), glib::Error>) + Send + 'static>(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let user_data: Box_<P> = Box_::new(callback);
        unsafe extern "C" fn flush_async_trampoline<
            P: FnOnce(Result<(), glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ = ffi::spice_channel_flush_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<P> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = flush_async_trampoline::<P>;
        unsafe {
            ffi::spice_channel_flush_async(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn flush_async_future(
        &self,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.flush_async(Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }

    fn error(&self) -> Option<glib::Error> {
        unsafe { from_glib_none(ffi::spice_channel_get_error(self.as_ref().to_glib_none().0)) }
    }

    fn open_fd(&self, fd: i32) -> bool {
        unsafe {
            from_glib(ffi::spice_channel_open_fd(
                self.as_ref().to_glib_none().0,
                fd,
            ))
        }
    }

    fn test_capability(&self, cap: u32) -> bool {
        unsafe {
            from_glib(ffi::spice_channel_test_capability(
                self.as_ref().to_glib_none().0,
                cap,
            ))
        }
    }

    fn test_common_capability(&self, cap: u32) -> bool {
        unsafe {
            from_glib(ffi::spice_channel_test_common_capability(
                self.as_ref().to_glib_none().0,
                cap,
            ))
        }
    }

    fn channel_id(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"channel-id\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `channel-id` getter")
        }
    }

    fn channel_type(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"channel-type\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `channel-type` getter")
        }
    }

    fn socket(&self) -> Option<gio::Socket> {
        unsafe {
            let mut value = glib::Value::from_type(<gio::Socket as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"socket\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `socket` getter")
        }
    }

    fn spice_session(&self) -> Option<Session> {
        unsafe {
            let mut value = glib::Value::from_type(<Session as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"spice-session\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `spice-session` getter")
        }
    }

    fn total_read_bytes(&self) -> libc::c_ulong {
        unsafe {
            let mut value = glib::Value::from_type(<libc::c_ulong as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"total-read-bytes\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `total-read-bytes` getter")
        }
    }

    fn connect_channel_event<F: Fn(&Self, ChannelEvent) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn channel_event_trampoline<
            P: IsA<Channel>,
            F: Fn(&P, ChannelEvent) + 'static,
        >(
            this: *mut ffi::SpiceChannel,
            event: ffi::SpiceChannelEvent,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Channel::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(event),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"channel-event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    channel_event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_open_fd<F: Fn(&Self, i32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn open_fd_trampoline<P: IsA<Channel>, F: Fn(&P, i32) + 'static>(
            this: *mut ffi::SpiceChannel,
            with_tls: libc::c_int,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Channel::from_glib_borrow(this).unsafe_cast_ref(), with_tls)
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"open-fd\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    open_fd_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_socket_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_socket_trampoline<P: IsA<Channel>, F: Fn(&P) + 'static>(
            this: *mut ffi::SpiceChannel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Channel::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::socket\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_socket_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_total_read_bytes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_total_read_bytes_trampoline<
            P: IsA<Channel>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::SpiceChannel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Channel::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::total-read-bytes\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_total_read_bytes_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for Channel {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Channel")
    }
}
