// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

#![allow(non_camel_case_types, non_upper_case_globals, non_snake_case)]
#![allow(
    clippy::approx_constant,
    clippy::type_complexity,
    clippy::unreadable_literal,
    clippy::upper_case_acronyms
)]
#![cfg_attr(feature = "dox", feature(doc_cfg))]

use gio_sys as gio;
use glib_sys as glib;
use gobject_sys as gobject;

#[allow(unused_imports)]
use libc::{
    c_char, c_double, c_float, c_int, c_long, c_short, c_uchar, c_uint, c_ulong, c_ushort, c_void,
    intptr_t, size_t, ssize_t, time_t, uintptr_t, FILE,
};

#[allow(unused_imports)]
use glib::{gboolean, gconstpointer, gpointer, GType};

// Enums
pub type SpiceChannelEvent = c_int;
pub const SPICE_CHANNEL_NONE: SpiceChannelEvent = 0;
pub const SPICE_CHANNEL_OPENED: SpiceChannelEvent = 10;
pub const SPICE_CHANNEL_SWITCHING: SpiceChannelEvent = 11;
pub const SPICE_CHANNEL_CLOSED: SpiceChannelEvent = 12;
pub const SPICE_CHANNEL_ERROR_CONNECT: SpiceChannelEvent = 20;
pub const SPICE_CHANNEL_ERROR_TLS: SpiceChannelEvent = 21;
pub const SPICE_CHANNEL_ERROR_LINK: SpiceChannelEvent = 22;
pub const SPICE_CHANNEL_ERROR_AUTH: SpiceChannelEvent = 23;
pub const SPICE_CHANNEL_ERROR_IO: SpiceChannelEvent = 24;

pub type SpiceClientError = c_int;
pub const SPICE_CLIENT_ERROR_FAILED: SpiceClientError = 0;
pub const SPICE_CLIENT_ERROR_USB_DEVICE_REJECTED: SpiceClientError = 1;
pub const SPICE_CLIENT_ERROR_USB_DEVICE_LOST: SpiceClientError = 2;
pub const SPICE_CLIENT_ERROR_AUTH_NEEDS_PASSWORD: SpiceClientError = 3;
pub const SPICE_CLIENT_ERROR_AUTH_NEEDS_USERNAME: SpiceClientError = 4;
pub const SPICE_CLIENT_ERROR_AUTH_NEEDS_PASSWORD_AND_USERNAME: SpiceClientError = 5;
pub const SPICE_CLIENT_ERROR_USB_SERVICE: SpiceClientError = 6;

pub type SpiceQmpPortVmAction = c_int;
pub const SPICE_QMP_PORT_VM_ACTION_QUIT: SpiceQmpPortVmAction = 0;
pub const SPICE_QMP_PORT_VM_ACTION_RESET: SpiceQmpPortVmAction = 1;
pub const SPICE_QMP_PORT_VM_ACTION_POWER_DOWN: SpiceQmpPortVmAction = 2;
pub const SPICE_QMP_PORT_VM_ACTION_PAUSE: SpiceQmpPortVmAction = 3;
pub const SPICE_QMP_PORT_VM_ACTION_CONTINUE: SpiceQmpPortVmAction = 4;
pub const SPICE_QMP_PORT_VM_ACTION_LAST: SpiceQmpPortVmAction = 5;

pub type SpiceSessionMigration = c_int;
pub const SPICE_SESSION_MIGRATION_NONE: SpiceSessionMigration = 0;
pub const SPICE_SESSION_MIGRATION_SWITCHING: SpiceSessionMigration = 1;
pub const SPICE_SESSION_MIGRATION_MIGRATING: SpiceSessionMigration = 2;
pub const SPICE_SESSION_MIGRATION_CONNECTING: SpiceSessionMigration = 3;

// Constants
pub const SPICE_GTK_MAJOR_VERSION: c_int = 0;
pub const SPICE_GTK_MICRO_VERSION: c_int = 8;
pub const SPICE_GTK_MINOR_VERSION: c_int = 39;
pub const SPICE_WEBDAV_CLIPBOARD_FOLDER_PATH: *const c_char =
    b"/.spice-clipboard\0" as *const u8 as *const c_char;

// Flags
pub type SpiceInputsLock = c_uint;
pub const SPICE_INPUTS_SCROLL_LOCK: SpiceInputsLock = 1;
pub const SPICE_INPUTS_NUM_LOCK: SpiceInputsLock = 2;
pub const SPICE_INPUTS_CAPS_LOCK: SpiceInputsLock = 4;

pub type SpiceSessionVerify = c_uint;
pub const SPICE_SESSION_VERIFY_PUBKEY: SpiceSessionVerify = 1;
pub const SPICE_SESSION_VERIFY_HOSTNAME: SpiceSessionVerify = 2;
pub const SPICE_SESSION_VERIFY_SUBJECT: SpiceSessionVerify = 4;

// Callbacks
pub type spice_msg_handler = Option<unsafe extern "C" fn(*mut SpiceChannel, *mut SpiceMsgIn)>;

// Records
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceAudioClass {
    pub parent_class: gobject::GObjectClass,
    pub connect_channel:
        Option<unsafe extern "C" fn(*mut SpiceAudio, *mut SpiceChannel) -> gboolean>,
    pub get_playback_volume_info_async: Option<
        unsafe extern "C" fn(
            *mut SpiceAudio,
            *mut gio::GCancellable,
            *mut SpiceMainChannel,
            gio::GAsyncReadyCallback,
            gpointer,
        ),
    >,
    pub get_playback_volume_info_finish: Option<
        unsafe extern "C" fn(
            *mut SpiceAudio,
            *mut gio::GAsyncResult,
            *mut gboolean,
            *mut u8,
            *mut *mut u16,
            *mut *mut glib::GError,
        ) -> gboolean,
    >,
    pub get_record_volume_info_async: Option<
        unsafe extern "C" fn(
            *mut SpiceAudio,
            *mut gio::GCancellable,
            *mut SpiceMainChannel,
            gio::GAsyncReadyCallback,
            gpointer,
        ),
    >,
    pub get_record_volume_info_finish: Option<
        unsafe extern "C" fn(
            *mut SpiceAudio,
            *mut gio::GAsyncResult,
            *mut gboolean,
            *mut u8,
            *mut *mut u16,
            *mut *mut glib::GError,
        ) -> gboolean,
    >,
    pub _spice_reserved: [gpointer; 6],
}

impl ::std::fmt::Debug for SpiceAudioClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceAudioClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .field("connect_channel", &self.connect_channel)
            .field(
                "get_playback_volume_info_async",
                &self.get_playback_volume_info_async,
            )
            .field(
                "get_playback_volume_info_finish",
                &self.get_playback_volume_info_finish,
            )
            .field(
                "get_record_volume_info_async",
                &self.get_record_volume_info_async,
            )
            .field(
                "get_record_volume_info_finish",
                &self.get_record_volume_info_finish,
            )
            .finish()
    }
}

#[repr(C)]
pub struct _SpiceAudioPrivate(c_void);

pub type SpiceAudioPrivate = *mut _SpiceAudioPrivate;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceChannelClass {
    pub parent_class: gobject::GObjectClass,
    pub channel_event: Option<unsafe extern "C" fn(*mut SpiceChannel, SpiceChannelEvent)>,
    pub open_fd: Option<unsafe extern "C" fn(*mut SpiceChannel, c_int)>,
    pub handle_msg: Option<unsafe extern "C" fn(*mut SpiceChannel, *mut SpiceMsgIn)>,
    pub channel_up: Option<unsafe extern "C" fn(*mut SpiceChannel)>,
    pub iterate_write: Option<unsafe extern "C" fn(*mut SpiceChannel)>,
    pub iterate_read: Option<unsafe extern "C" fn(*mut SpiceChannel)>,
    pub deprecated: gpointer,
    pub channel_reset: Option<unsafe extern "C" fn(*mut SpiceChannel, gboolean)>,
    pub deprecated2: gpointer,
    pub channel_send_migration_handshake: Option<unsafe extern "C" fn(*mut SpiceChannel)>,
    pub priv_: *mut SpiceChannelClassPrivate,
    pub _spice_reserved: [gpointer; 8],
}

impl ::std::fmt::Debug for SpiceChannelClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceChannelClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .field("channel_event", &self.channel_event)
            .field("open_fd", &self.open_fd)
            .field("handle_msg", &self.handle_msg)
            .field("channel_up", &self.channel_up)
            .field("iterate_write", &self.iterate_write)
            .field("iterate_read", &self.iterate_read)
            .field("channel_reset", &self.channel_reset)
            .field(
                "channel_send_migration_handshake",
                &self.channel_send_migration_handshake,
            )
            .finish()
    }
}

#[repr(C)]
pub struct _SpiceChannelClassPrivate(c_void);

pub type SpiceChannelClassPrivate = *mut _SpiceChannelClassPrivate;

#[repr(C)]
pub struct _SpiceChannelPrivate(c_void);

pub type SpiceChannelPrivate = *mut _SpiceChannelPrivate;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceCursorChannelClass {
    pub parent_class: SpiceChannelClass,
    pub cursor_set:
        Option<unsafe extern "C" fn(*mut SpiceCursorChannel, c_int, c_int, c_int, c_int, gpointer)>,
    pub cursor_move: Option<unsafe extern "C" fn(*mut SpiceCursorChannel, c_int, c_int)>,
    pub cursor_hide: Option<unsafe extern "C" fn(*mut SpiceCursorChannel)>,
    pub cursor_reset: Option<unsafe extern "C" fn(*mut SpiceCursorChannel)>,
}

impl ::std::fmt::Debug for SpiceCursorChannelClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceCursorChannelClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .field("cursor_set", &self.cursor_set)
            .field("cursor_move", &self.cursor_move)
            .field("cursor_hide", &self.cursor_hide)
            .field("cursor_reset", &self.cursor_reset)
            .finish()
    }
}

#[repr(C)]
pub struct _SpiceCursorChannelPrivate(c_void);

pub type SpiceCursorChannelPrivate = *mut _SpiceCursorChannelPrivate;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceCursorShape {
    pub type_: c_int,
    pub width: u16,
    pub height: u16,
    pub hot_spot_x: u16,
    pub hot_spot_y: u16,
    pub data: gpointer,
}

impl ::std::fmt::Debug for SpiceCursorShape {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceCursorShape @ {:p}", self))
            .field("type_", &self.type_)
            .field("width", &self.width)
            .field("height", &self.height)
            .field("hot_spot_x", &self.hot_spot_x)
            .field("hot_spot_y", &self.hot_spot_y)
            .field("data", &self.data)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceDisplayChannelClass {
    pub parent_class: SpiceChannelClass,
    pub display_primary_create: Option<
        unsafe extern "C" fn(*mut SpiceChannel, c_int, c_int, c_int, c_int, c_int, gpointer),
    >,
    pub display_primary_destroy: Option<unsafe extern "C" fn(*mut SpiceChannel)>,
    pub display_invalidate:
        Option<unsafe extern "C" fn(*mut SpiceChannel, c_int, c_int, c_int, c_int)>,
    pub display_mark: Option<unsafe extern "C" fn(*mut SpiceChannel, gboolean)>,
}

impl ::std::fmt::Debug for SpiceDisplayChannelClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceDisplayChannelClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .field("display_primary_create", &self.display_primary_create)
            .field("display_primary_destroy", &self.display_primary_destroy)
            .field("display_invalidate", &self.display_invalidate)
            .field("display_mark", &self.display_mark)
            .finish()
    }
}

#[repr(C)]
pub struct _SpiceDisplayChannelPrivate(c_void);

pub type SpiceDisplayChannelPrivate = *mut _SpiceDisplayChannelPrivate;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceDisplayMonitorConfig {
    pub id: c_uint,
    pub surface_id: c_uint,
    pub x: c_uint,
    pub y: c_uint,
    pub width: c_uint,
    pub height: c_uint,
}

impl ::std::fmt::Debug for SpiceDisplayMonitorConfig {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceDisplayMonitorConfig @ {:p}", self))
            .field("id", &self.id)
            .field("surface_id", &self.surface_id)
            .field("x", &self.x)
            .field("y", &self.y)
            .field("width", &self.width)
            .field("height", &self.height)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceDisplayPrimary {
    pub format: c_int,
    pub width: c_int,
    pub height: c_int,
    pub stride: c_int,
    pub shmid: c_int,
    pub data: *mut u8,
    pub marked: gboolean,
}

impl ::std::fmt::Debug for SpiceDisplayPrimary {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceDisplayPrimary @ {:p}", self))
            .field("format", &self.format)
            .field("width", &self.width)
            .field("height", &self.height)
            .field("stride", &self.stride)
            .field("shmid", &self.shmid)
            .field("data", &self.data)
            .field("marked", &self.marked)
            .finish()
    }
}

#[repr(C)]
pub struct _SpiceFileTransferTaskClass(c_void);

pub type SpiceFileTransferTaskClass = *mut _SpiceFileTransferTaskClass;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceGlScanout {
    pub fd: c_int,
    pub width: u32,
    pub height: u32,
    pub stride: u32,
    pub format: u32,
    pub y0top: gboolean,
}

impl ::std::fmt::Debug for SpiceGlScanout {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceGlScanout @ {:p}", self))
            .field("fd", &self.fd)
            .field("width", &self.width)
            .field("height", &self.height)
            .field("stride", &self.stride)
            .field("format", &self.format)
            .field("y0top", &self.y0top)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceInputsChannelClass {
    pub parent_class: SpiceChannelClass,
    pub inputs_modifiers: Option<unsafe extern "C" fn(*mut SpiceChannel)>,
}

impl ::std::fmt::Debug for SpiceInputsChannelClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceInputsChannelClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .field("inputs_modifiers", &self.inputs_modifiers)
            .finish()
    }
}

#[repr(C)]
pub struct _SpiceInputsChannelPrivate(c_void);

pub type SpiceInputsChannelPrivate = *mut _SpiceInputsChannelPrivate;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceMainChannelClass {
    pub parent_class: SpiceChannelClass,
    pub mouse_update: Option<unsafe extern "C" fn(*mut SpiceChannel)>,
    pub agent_update: Option<unsafe extern "C" fn(*mut SpiceChannel)>,
}

impl ::std::fmt::Debug for SpiceMainChannelClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceMainChannelClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .field("mouse_update", &self.mouse_update)
            .field("agent_update", &self.agent_update)
            .finish()
    }
}

#[repr(C)]
pub struct _SpiceMainChannelPrivate(c_void);

pub type SpiceMainChannelPrivate = *mut _SpiceMainChannelPrivate;

#[repr(C)]
pub struct _SpiceMsgIn(c_void);

pub type SpiceMsgIn = *mut _SpiceMsgIn;

#[repr(C)]
pub struct _SpiceMsgOut(c_void);

pub type SpiceMsgOut = *mut _SpiceMsgOut;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpicePlaybackChannelClass {
    pub parent_class: SpiceChannelClass,
    pub playback_start:
        Option<unsafe extern "C" fn(*mut SpicePlaybackChannel, c_int, c_int, c_int)>,
    pub playback_data:
        Option<unsafe extern "C" fn(*mut SpicePlaybackChannel, *mut gpointer, c_int)>,
    pub playback_stop: Option<unsafe extern "C" fn(*mut SpicePlaybackChannel)>,
}

impl ::std::fmt::Debug for SpicePlaybackChannelClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpicePlaybackChannelClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .field("playback_start", &self.playback_start)
            .field("playback_data", &self.playback_data)
            .field("playback_stop", &self.playback_stop)
            .finish()
    }
}

#[repr(C)]
pub struct _SpicePlaybackChannelPrivate(c_void);

pub type SpicePlaybackChannelPrivate = *mut _SpicePlaybackChannelPrivate;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpicePortChannelClass {
    pub parent_class: SpiceChannelClass,
}

impl ::std::fmt::Debug for SpicePortChannelClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpicePortChannelClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
pub struct _SpicePortChannelPrivate(c_void);

pub type SpicePortChannelPrivate = *mut _SpicePortChannelPrivate;

#[repr(C)]
pub struct _SpiceQmpPortClass(c_void);

pub type SpiceQmpPortClass = *mut _SpiceQmpPortClass;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceQmpStatus {
    pub ref_: c_int,
    pub version: c_int,
    pub running: gboolean,
    pub singlestep: gboolean,
    pub status: *mut c_char,
}

impl ::std::fmt::Debug for SpiceQmpStatus {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceQmpStatus @ {:p}", self))
            .field("version", &self.version)
            .field("running", &self.running)
            .field("singlestep", &self.singlestep)
            .field("status", &self.status)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceRecordChannelClass {
    pub parent_class: SpiceChannelClass,
    pub record_start: Option<unsafe extern "C" fn(*mut SpiceRecordChannel, c_int, c_int, c_int)>,
    pub record_data: Option<unsafe extern "C" fn(*mut SpiceRecordChannel, *mut gpointer, c_int)>,
    pub record_stop: Option<unsafe extern "C" fn(*mut SpiceRecordChannel)>,
}

impl ::std::fmt::Debug for SpiceRecordChannelClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceRecordChannelClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .field("record_start", &self.record_start)
            .field("record_data", &self.record_data)
            .field("record_stop", &self.record_stop)
            .finish()
    }
}

#[repr(C)]
pub struct _SpiceRecordChannelPrivate(c_void);

pub type SpiceRecordChannelPrivate = *mut _SpiceRecordChannelPrivate;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceSessionClass {
    pub parent_class: gobject::GObjectClass,
    pub channel_new: Option<unsafe extern "C" fn(*mut SpiceSession, *mut SpiceChannel)>,
    pub channel_destroy: Option<unsafe extern "C" fn(*mut SpiceSession, *mut SpiceChannel)>,
    pub _spice_reserved: [gpointer; 10],
}

impl ::std::fmt::Debug for SpiceSessionClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceSessionClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .field("channel_new", &self.channel_new)
            .field("channel_destroy", &self.channel_destroy)
            .finish()
    }
}

#[repr(C)]
pub struct _SpiceSessionPrivate(c_void);

pub type SpiceSessionPrivate = *mut _SpiceSessionPrivate;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceSmartcardChannelClass {
    pub parent_class: SpiceChannelClass,
}

impl ::std::fmt::Debug for SpiceSmartcardChannelClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceSmartcardChannelClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
pub struct _SpiceSmartcardChannelPrivate(c_void);

pub type SpiceSmartcardChannelPrivate = *mut _SpiceSmartcardChannelPrivate;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceSmartcardManagerClass {
    pub parent_class: gobject::GObjectClass,
    pub reader_added:
        Option<unsafe extern "C" fn(*mut SpiceSmartcardManager, *mut SpiceSmartcardReader)>,
    pub reader_removed:
        Option<unsafe extern "C" fn(*mut SpiceSmartcardManager, *mut SpiceSmartcardReader)>,
    pub card_inserted:
        Option<unsafe extern "C" fn(*mut SpiceSmartcardManager, *mut SpiceSmartcardReader)>,
    pub card_removed:
        Option<unsafe extern "C" fn(*mut SpiceSmartcardManager, *mut SpiceSmartcardReader)>,
    pub _spice_reserved: [gpointer; 10],
}

impl ::std::fmt::Debug for SpiceSmartcardManagerClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceSmartcardManagerClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .field("reader_added", &self.reader_added)
            .field("reader_removed", &self.reader_removed)
            .field("card_inserted", &self.card_inserted)
            .field("card_removed", &self.card_removed)
            .finish()
    }
}

#[repr(C)]
pub struct _SpiceSmartcardManagerPrivate(c_void);

pub type SpiceSmartcardManagerPrivate = *mut _SpiceSmartcardManagerPrivate;

#[repr(C)]
pub struct _SpiceSmartcardReader(c_void);

pub type SpiceSmartcardReader = *mut _SpiceSmartcardReader;

#[repr(C)]
pub struct _SpiceURIClass(c_void);

pub type SpiceURIClass = *mut _SpiceURIClass;

#[repr(C)]
pub struct _SpiceURIPrivate(c_void);

pub type SpiceURIPrivate = *mut _SpiceURIPrivate;

#[repr(C)]
pub struct SpiceUsbDevice(c_void);

impl ::std::fmt::Debug for SpiceUsbDevice {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceUsbDevice @ {:p}", self))
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceUsbDeviceManagerClass {
    pub parent_class: gobject::GObjectClass,
    pub device_added: Option<unsafe extern "C" fn(*mut SpiceUsbDeviceManager, *mut SpiceUsbDevice)>,
    pub device_removed:
        Option<unsafe extern "C" fn(*mut SpiceUsbDeviceManager, *mut SpiceUsbDevice)>,
    pub auto_connect_failed: Option<
        unsafe extern "C" fn(*mut SpiceUsbDeviceManager, *mut SpiceUsbDevice, *mut glib::GError),
    >,
    pub device_error: Option<
        unsafe extern "C" fn(*mut SpiceUsbDeviceManager, *mut SpiceUsbDevice, *mut glib::GError),
    >,
    pub _spice_reserved: [gpointer; 10],
}

impl ::std::fmt::Debug for SpiceUsbDeviceManagerClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceUsbDeviceManagerClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .field("device_added", &self.device_added)
            .field("device_removed", &self.device_removed)
            .field("auto_connect_failed", &self.auto_connect_failed)
            .field("device_error", &self.device_error)
            .finish()
    }
}

#[repr(C)]
pub struct _SpiceUsbDeviceManagerPrivate(c_void);

pub type SpiceUsbDeviceManagerPrivate = *mut _SpiceUsbDeviceManagerPrivate;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceUsbredirChannelClass {
    pub parent_class: SpiceChannelClass,
}

impl ::std::fmt::Debug for SpiceUsbredirChannelClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceUsbredirChannelClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
pub struct _SpiceUsbredirChannelPrivate(c_void);

pub type SpiceUsbredirChannelPrivate = *mut _SpiceUsbredirChannelPrivate;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceWebdavChannelClass {
    pub parent_class: SpicePortChannelClass,
}

impl ::std::fmt::Debug for SpiceWebdavChannelClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceWebdavChannelClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
pub struct _SpiceWebdavChannelPrivate(c_void);

pub type SpiceWebdavChannelPrivate = *mut _SpiceWebdavChannelPrivate;

// Classes
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceAudio {
    pub parent: gobject::GObject,
    pub priv_: *mut SpiceAudioPrivate,
}

impl ::std::fmt::Debug for SpiceAudio {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceAudio @ {:p}", self))
            .field("parent", &self.parent)
            .field("priv_", &self.priv_)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceChannel {
    pub parent: gobject::GObject,
    pub priv_: *mut SpiceChannelPrivate,
}

impl ::std::fmt::Debug for SpiceChannel {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceChannel @ {:p}", self))
            .field("parent", &self.parent)
            .field("priv_", &self.priv_)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceCursorChannel {
    pub parent: SpiceChannel,
    pub priv_: *mut SpiceCursorChannelPrivate,
}

impl ::std::fmt::Debug for SpiceCursorChannel {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceCursorChannel @ {:p}", self))
            .field("parent", &self.parent)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceDisplayChannel {
    pub parent: SpiceChannel,
    pub priv_: *mut SpiceDisplayChannelPrivate,
}

impl ::std::fmt::Debug for SpiceDisplayChannel {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceDisplayChannel @ {:p}", self))
            .field("parent", &self.parent)
            .finish()
    }
}

#[repr(C)]
pub struct SpiceFileTransferTask(c_void);

impl ::std::fmt::Debug for SpiceFileTransferTask {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceFileTransferTask @ {:p}", self))
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceInputsChannel {
    pub parent: SpiceChannel,
    pub priv_: *mut SpiceInputsChannelPrivate,
}

impl ::std::fmt::Debug for SpiceInputsChannel {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceInputsChannel @ {:p}", self))
            .field("parent", &self.parent)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceMainChannel {
    pub parent: SpiceChannel,
    pub priv_: *mut SpiceMainChannelPrivate,
}

impl ::std::fmt::Debug for SpiceMainChannel {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceMainChannel @ {:p}", self))
            .field("parent", &self.parent)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpicePlaybackChannel {
    pub parent: SpiceChannel,
    pub priv_: *mut SpicePlaybackChannelPrivate,
}

impl ::std::fmt::Debug for SpicePlaybackChannel {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpicePlaybackChannel @ {:p}", self))
            .field("parent", &self.parent)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpicePortChannel {
    pub parent: SpiceChannel,
    pub priv_: *mut SpicePortChannelPrivate,
}

impl ::std::fmt::Debug for SpicePortChannel {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpicePortChannel @ {:p}", self))
            .field("parent", &self.parent)
            .finish()
    }
}

#[repr(C)]
pub struct SpiceQmpPort(c_void);

impl ::std::fmt::Debug for SpiceQmpPort {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceQmpPort @ {:p}", self))
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceRecordChannel {
    pub parent: SpiceChannel,
    pub priv_: *mut SpiceRecordChannelPrivate,
}

impl ::std::fmt::Debug for SpiceRecordChannel {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceRecordChannel @ {:p}", self))
            .field("parent", &self.parent)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceSession {
    pub parent: gobject::GObject,
    pub priv_: *mut SpiceSessionPrivate,
}

impl ::std::fmt::Debug for SpiceSession {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceSession @ {:p}", self))
            .field("parent", &self.parent)
            .field("priv_", &self.priv_)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceSmartcardChannel {
    pub parent: SpiceChannel,
    pub priv_: *mut SpiceSmartcardChannelPrivate,
}

impl ::std::fmt::Debug for SpiceSmartcardChannel {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceSmartcardChannel @ {:p}", self))
            .field("parent", &self.parent)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceSmartcardManager {
    pub parent: gobject::GObject,
    pub priv_: *mut SpiceSmartcardManagerPrivate,
}

impl ::std::fmt::Debug for SpiceSmartcardManager {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceSmartcardManager @ {:p}", self))
            .field("parent", &self.parent)
            .finish()
    }
}

#[repr(C)]
pub struct SpiceURI(c_void);

impl ::std::fmt::Debug for SpiceURI {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceURI @ {:p}", self)).finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceUsbDeviceManager {
    pub parent: gobject::GObject,
    pub priv_: *mut SpiceUsbDeviceManagerPrivate,
}

impl ::std::fmt::Debug for SpiceUsbDeviceManager {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceUsbDeviceManager @ {:p}", self))
            .field("parent", &self.parent)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceUsbredirChannel {
    pub parent: SpiceChannel,
    pub priv_: *mut SpiceUsbredirChannelPrivate,
}

impl ::std::fmt::Debug for SpiceUsbredirChannel {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceUsbredirChannel @ {:p}", self))
            .field("parent", &self.parent)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct SpiceWebdavChannel {
    pub parent: SpicePortChannel,
    pub priv_: *mut SpiceWebdavChannelPrivate,
}

impl ::std::fmt::Debug for SpiceWebdavChannel {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SpiceWebdavChannel @ {:p}", self))
            .field("parent", &self.parent)
            .finish()
    }
}

#[link(name = "spice-client-glib-2.0")]
extern "C" {

    //=========================================================================
    // SpiceChannelEvent
    //=========================================================================
    pub fn spice_channel_event_get_type() -> GType;

    //=========================================================================
    // SpiceSessionMigration
    //=========================================================================
    pub fn spice_session_migration_get_type() -> GType;

    //=========================================================================
    // SpiceInputsLock
    //=========================================================================
    pub fn spice_inputs_lock_get_type() -> GType;

    //=========================================================================
    // SpiceSessionVerify
    //=========================================================================
    pub fn spice_session_verify_get_type() -> GType;

    //=========================================================================
    // SpiceCursorShape
    //=========================================================================
    pub fn spice_cursor_shape_get_type() -> GType;

    //=========================================================================
    // SpiceGlScanout
    //=========================================================================
    pub fn spice_gl_scanout_get_type() -> GType;
    pub fn spice_gl_scanout_free(scanout: *mut SpiceGlScanout);

    //=========================================================================
    // SpiceQmpStatus
    //=========================================================================
    pub fn spice_qmp_status_get_type() -> GType;
    pub fn spice_qmp_status_ref(status: *mut SpiceQmpStatus) -> *mut SpiceQmpStatus;
    pub fn spice_qmp_status_unref(status: *mut SpiceQmpStatus);

    //=========================================================================
    // SpiceSmartcardReader
    //=========================================================================
    pub fn spice_smartcard_reader_insert_card(reader: *mut SpiceSmartcardReader) -> gboolean;
    pub fn spice_smartcard_reader_is_software(reader: *mut SpiceSmartcardReader) -> gboolean;
    pub fn spice_smartcard_reader_remove_card(reader: *mut SpiceSmartcardReader) -> gboolean;

    //=========================================================================
    // SpiceUsbDevice
    //=========================================================================
    pub fn spice_usb_device_get_type() -> GType;
    pub fn spice_usb_device_get_description(
        device: *mut SpiceUsbDevice,
        format: *const c_char,
    ) -> *mut c_char;
    pub fn spice_usb_device_get_libusb_device(device: *const SpiceUsbDevice) -> gconstpointer;

    //=========================================================================
    // SpiceAudio
    //=========================================================================
    pub fn spice_audio_get_type() -> GType;
    pub fn spice_audio_new(
        session: *mut SpiceSession,
        context: *mut glib::GMainContext,
        name: *const c_char,
    ) -> *mut SpiceAudio;
    pub fn spice_audio_get(
        session: *mut SpiceSession,
        context: *mut glib::GMainContext,
    ) -> *mut SpiceAudio;

    //=========================================================================
    // SpiceChannel
    //=========================================================================
    pub fn spice_channel_get_type() -> GType;
    pub fn spice_channel_new(s: *mut SpiceSession, type_: c_int, id: c_int) -> *mut SpiceChannel;
    pub fn spice_channel_string_to_type(str: *const c_char) -> c_int;
    pub fn spice_channel_type_to_string(type_: c_int) -> *const c_char;
    pub fn spice_channel_connect(channel: *mut SpiceChannel) -> gboolean;
    pub fn spice_channel_destroy(channel: *mut SpiceChannel);
    pub fn spice_channel_disconnect(channel: *mut SpiceChannel, reason: SpiceChannelEvent);
    pub fn spice_channel_flush_async(
        channel: *mut SpiceChannel,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn spice_channel_flush_finish(
        channel: *mut SpiceChannel,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn spice_channel_get_error(channel: *mut SpiceChannel) -> *const glib::GError;
    pub fn spice_channel_open_fd(channel: *mut SpiceChannel, fd: c_int) -> gboolean;
    pub fn spice_channel_set_capability(channel: *mut SpiceChannel, cap: u32);
    pub fn spice_channel_test_capability(channel: *mut SpiceChannel, cap: u32) -> gboolean;
    pub fn spice_channel_test_common_capability(channel: *mut SpiceChannel, cap: u32) -> gboolean;

    //=========================================================================
    // SpiceCursorChannel
    //=========================================================================
    pub fn spice_cursor_channel_get_type() -> GType;

    //=========================================================================
    // SpiceDisplayChannel
    //=========================================================================
    pub fn spice_display_channel_get_type() -> GType;
    pub fn spice_display_change_preferred_compression(
        channel: *mut SpiceDisplayChannel,
        compression: c_int,
    );
    pub fn spice_display_change_preferred_video_codec_type(
        channel: *mut SpiceDisplayChannel,
        codec_type: c_int,
    );
    pub fn spice_display_channel_change_preferred_compression(
        channel: *mut SpiceDisplayChannel,
        compression: c_int,
    );
    pub fn spice_display_channel_change_preferred_video_codec_type(
        channel: *mut SpiceDisplayChannel,
        codec_type: c_int,
    );
    pub fn spice_display_channel_change_preferred_video_codec_types(
        channel: *mut SpiceDisplayChannel,
        codecs: *const c_int,
        ncodecs: size_t,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn spice_display_channel_get_primary(
        channel: *mut SpiceDisplayChannel,
        surface_id: u32,
        primary: *mut SpiceDisplayPrimary,
    ) -> gboolean;
    pub fn spice_display_get_primary(
        channel: *mut SpiceDisplayChannel,
        surface_id: u32,
        primary: *mut SpiceDisplayPrimary,
    ) -> gboolean;
    pub fn spice_display_channel_get_gl_scanout(
        channel: *mut SpiceDisplayChannel,
    ) -> *const SpiceGlScanout;
    pub fn spice_display_channel_gl_draw_done(channel: *mut SpiceDisplayChannel);

    //=========================================================================
    // SpiceFileTransferTask
    //=========================================================================
    pub fn spice_file_transfer_task_get_type() -> GType;
    pub fn spice_file_transfer_task_cancel(self_: *mut SpiceFileTransferTask);
    pub fn spice_file_transfer_task_get_filename(self_: *mut SpiceFileTransferTask) -> *mut c_char;
    pub fn spice_file_transfer_task_get_progress(self_: *mut SpiceFileTransferTask) -> c_double;
    pub fn spice_file_transfer_task_get_total_bytes(self_: *mut SpiceFileTransferTask) -> u64;
    pub fn spice_file_transfer_task_get_transferred_bytes(self_: *mut SpiceFileTransferTask)
        -> u64;

    //=========================================================================
    // SpiceInputsChannel
    //=========================================================================
    pub fn spice_inputs_channel_get_type() -> GType;
    pub fn spice_inputs_channel_button_press(
        channel: *mut SpiceInputsChannel,
        button: c_int,
        button_state: c_int,
    );
    pub fn spice_inputs_channel_button_release(
        channel: *mut SpiceInputsChannel,
        button: c_int,
        button_state: c_int,
    );
    pub fn spice_inputs_channel_key_press(channel: *mut SpiceInputsChannel, scancode: c_uint);
    pub fn spice_inputs_channel_key_press_and_release(
        channel: *mut SpiceInputsChannel,
        scancode: c_uint,
    );
    pub fn spice_inputs_channel_key_release(channel: *mut SpiceInputsChannel, scancode: c_uint);
    pub fn spice_inputs_channel_motion(
        channel: *mut SpiceInputsChannel,
        dx: c_int,
        dy: c_int,
        button_state: c_int,
    );
    pub fn spice_inputs_channel_position(
        channel: *mut SpiceInputsChannel,
        x: c_int,
        y: c_int,
        display: c_int,
        button_state: c_int,
    );
    pub fn spice_inputs_channel_set_key_locks(channel: *mut SpiceInputsChannel, locks: c_uint);

    //=========================================================================
    // SpiceMainChannel
    //=========================================================================
    pub fn spice_main_channel_get_type() -> GType;
    pub fn spice_main_channel_agent_test_capability(
        channel: *mut SpiceMainChannel,
        cap: u32,
    ) -> gboolean;
    pub fn spice_main_channel_clipboard_selection_grab(
        channel: *mut SpiceMainChannel,
        selection: c_uint,
        types: *mut u32,
        ntypes: c_int,
    );
    pub fn spice_main_channel_clipboard_selection_notify(
        channel: *mut SpiceMainChannel,
        selection: c_uint,
        type_: u32,
        data: *const u8,
        size: size_t,
    );
    pub fn spice_main_channel_clipboard_selection_release(
        channel: *mut SpiceMainChannel,
        selection: c_uint,
    );
    pub fn spice_main_channel_clipboard_selection_request(
        channel: *mut SpiceMainChannel,
        selection: c_uint,
        type_: u32,
    );
    pub fn spice_main_channel_file_copy_async(
        channel: *mut SpiceMainChannel,
        sources: *mut *mut gio::GFile,
        flags: gio::GFileCopyFlags,
        cancellable: *mut gio::GCancellable,
        progress_callback: gio::GFileProgressCallback,
        progress_callback_data: gpointer,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn spice_main_channel_file_copy_finish(
        channel: *mut SpiceMainChannel,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn spice_main_channel_request_mouse_mode(channel: *mut SpiceMainChannel, mode: c_int);
    pub fn spice_main_channel_send_monitor_config(channel: *mut SpiceMainChannel) -> gboolean;
    pub fn spice_main_channel_update_display(
        channel: *mut SpiceMainChannel,
        id: c_int,
        x: c_int,
        y: c_int,
        width: c_int,
        height: c_int,
        update: gboolean,
    );
    pub fn spice_main_channel_update_display_enabled(
        channel: *mut SpiceMainChannel,
        id: c_int,
        enabled: gboolean,
        update: gboolean,
    );
    pub fn spice_main_channel_update_display_mm(
        channel: *mut SpiceMainChannel,
        id: c_int,
        width_mm: c_int,
        height_mm: c_int,
        update: gboolean,
    );

    //=========================================================================
    // SpicePlaybackChannel
    //=========================================================================
    pub fn spice_playback_channel_get_type() -> GType;
    pub fn spice_playback_channel_set_delay(channel: *mut SpicePlaybackChannel, delay_ms: u32);

    //=========================================================================
    // SpicePortChannel
    //=========================================================================
    pub fn spice_port_channel_get_type() -> GType;
    pub fn spice_port_channel_event(port: *mut SpicePortChannel, event: u8);
    pub fn spice_port_channel_write_async(
        port: *mut SpicePortChannel,
        buffer: *mut u8,
        count: size_t,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn spice_port_channel_write_finish(
        port: *mut SpicePortChannel,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> ssize_t;

    //=========================================================================
    // SpiceQmpPort
    //=========================================================================
    pub fn spice_qmp_port_get_type() -> GType;
    pub fn spice_qmp_port_get(channel: *mut SpicePortChannel) -> *mut SpiceQmpPort;
    pub fn spice_qmp_port_query_status_async(
        self_: *mut SpiceQmpPort,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn spice_qmp_port_query_status_finish(
        self_: *mut SpiceQmpPort,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> *mut SpiceQmpStatus;
    pub fn spice_qmp_port_vm_action_async(
        self_: *mut SpiceQmpPort,
        action: SpiceQmpPortVmAction,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn spice_qmp_port_vm_action_finish(
        self_: *mut SpiceQmpPort,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> gboolean;

    //=========================================================================
    // SpiceRecordChannel
    //=========================================================================
    pub fn spice_record_channel_get_type() -> GType;
    pub fn spice_record_channel_send_data(
        channel: *mut SpiceRecordChannel,
        data: gpointer,
        bytes: size_t,
        time: u32,
    );

    //=========================================================================
    // SpiceSession
    //=========================================================================
    pub fn spice_session_get_type() -> GType;
    pub fn spice_session_new() -> *mut SpiceSession;
    pub fn spice_session_connect(session: *mut SpiceSession) -> gboolean;
    pub fn spice_session_disconnect(session: *mut SpiceSession);
    pub fn spice_session_get_channels(session: *mut SpiceSession) -> *mut glib::GList;
    pub fn spice_session_get_proxy_uri(session: *mut SpiceSession) -> *mut SpiceURI;
    pub fn spice_session_get_read_only(session: *mut SpiceSession) -> gboolean;
    pub fn spice_session_has_channel_type(session: *mut SpiceSession, type_: c_int) -> gboolean;
    pub fn spice_session_is_for_migration(session: *mut SpiceSession) -> gboolean;
    pub fn spice_session_open_fd(session: *mut SpiceSession, fd: c_int) -> gboolean;

    //=========================================================================
    // SpiceSmartcardChannel
    //=========================================================================
    pub fn spice_smartcard_channel_get_type() -> GType;

    //=========================================================================
    // SpiceSmartcardManager
    //=========================================================================
    pub fn spice_smartcard_manager_get_type() -> GType;
    pub fn spice_smartcard_manager_get() -> *mut SpiceSmartcardManager;
    pub fn spice_smartcard_manager_get_readers(
        manager: *mut SpiceSmartcardManager,
    ) -> *mut glib::GList;
    pub fn spice_smartcard_manager_insert_card(manager: *mut SpiceSmartcardManager) -> gboolean;
    pub fn spice_smartcard_manager_remove_card(manager: *mut SpiceSmartcardManager) -> gboolean;

    //=========================================================================
    // SpiceURI
    //=========================================================================
    pub fn spice_uri_get_type() -> GType;
    pub fn spice_uri_get_hostname(uri: *mut SpiceURI) -> *const c_char;
    pub fn spice_uri_get_password(uri: *mut SpiceURI) -> *const c_char;
    pub fn spice_uri_get_port(uri: *mut SpiceURI) -> c_uint;
    pub fn spice_uri_get_scheme(uri: *mut SpiceURI) -> *const c_char;
    pub fn spice_uri_get_user(uri: *mut SpiceURI) -> *const c_char;
    pub fn spice_uri_set_hostname(uri: *mut SpiceURI, hostname: *const c_char);
    pub fn spice_uri_set_password(uri: *mut SpiceURI, password: *const c_char);
    pub fn spice_uri_set_port(uri: *mut SpiceURI, port: c_uint);
    pub fn spice_uri_set_scheme(uri: *mut SpiceURI, scheme: *const c_char);
    pub fn spice_uri_set_user(uri: *mut SpiceURI, user: *const c_char);
    pub fn spice_uri_to_string(uri: *mut SpiceURI) -> *mut c_char;

    //=========================================================================
    // SpiceUsbDeviceManager
    //=========================================================================
    pub fn spice_usb_device_manager_get_type() -> GType;
    pub fn spice_usb_device_manager_get(
        session: *mut SpiceSession,
        error: *mut *mut glib::GError,
    ) -> *mut SpiceUsbDeviceManager;
    pub fn spice_usb_device_manager_can_redirect_device(
        manager: *mut SpiceUsbDeviceManager,
        device: *mut SpiceUsbDevice,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn spice_usb_device_manager_connect_device_async(
        manager: *mut SpiceUsbDeviceManager,
        device: *mut SpiceUsbDevice,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn spice_usb_device_manager_connect_device_finish(
        manager: *mut SpiceUsbDeviceManager,
        res: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn spice_usb_device_manager_create_shared_cd_device(
        manager: *mut SpiceUsbDeviceManager,
        filename: *mut c_char,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn spice_usb_device_manager_disconnect_device(
        manager: *mut SpiceUsbDeviceManager,
        device: *mut SpiceUsbDevice,
    );
    pub fn spice_usb_device_manager_disconnect_device_async(
        manager: *mut SpiceUsbDeviceManager,
        device: *mut SpiceUsbDevice,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn spice_usb_device_manager_disconnect_device_finish(
        manager: *mut SpiceUsbDeviceManager,
        res: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn spice_usb_device_manager_get_devices(
        manager: *mut SpiceUsbDeviceManager,
    ) -> *mut glib::GPtrArray;
    pub fn spice_usb_device_manager_get_devices_with_filter(
        manager: *mut SpiceUsbDeviceManager,
        filter: *const c_char,
    ) -> *mut glib::GPtrArray;
    pub fn spice_usb_device_manager_is_device_connected(
        manager: *mut SpiceUsbDeviceManager,
        device: *mut SpiceUsbDevice,
    ) -> gboolean;
    pub fn spice_usb_device_manager_is_device_shared_cd(
        manager: *mut SpiceUsbDeviceManager,
        device: *mut SpiceUsbDevice,
    ) -> gboolean;
    pub fn spice_usb_device_manager_is_redirecting(manager: *mut SpiceUsbDeviceManager)
        -> gboolean;

    //=========================================================================
    // SpiceUsbredirChannel
    //=========================================================================
    pub fn spice_usbredir_channel_get_type() -> GType;

    //=========================================================================
    // SpiceWebdavChannel
    //=========================================================================
    pub fn spice_webdav_channel_get_type() -> GType;

    //=========================================================================
    // Other functions
    //=========================================================================
    pub fn spice_client_error_quark() -> glib::GQuark;
    pub fn spice_display_get_gl_scanout(channel: *mut SpiceDisplayChannel)
        -> *const SpiceGlScanout;
    pub fn spice_display_gl_draw_done(channel: *mut SpiceDisplayChannel);
    pub fn spice_g_signal_connect_object(
        instance: gpointer,
        detailed_signal: *const c_char,
        c_handler: gobject::GCallback,
        gobject: gpointer,
        connect_flags: gobject::GConnectFlags,
    ) -> c_ulong;
    pub fn spice_get_option_group() -> *mut glib::GOptionGroup;
    pub fn spice_inputs_button_press(
        channel: *mut SpiceInputsChannel,
        button: c_int,
        button_state: c_int,
    );
    pub fn spice_inputs_button_release(
        channel: *mut SpiceInputsChannel,
        button: c_int,
        button_state: c_int,
    );
    pub fn spice_inputs_key_press(channel: *mut SpiceInputsChannel, scancode: c_uint);
    pub fn spice_inputs_key_press_and_release(channel: *mut SpiceInputsChannel, scancode: c_uint);
    pub fn spice_inputs_key_release(channel: *mut SpiceInputsChannel, scancode: c_uint);
    pub fn spice_inputs_motion(
        channel: *mut SpiceInputsChannel,
        dx: c_int,
        dy: c_int,
        button_state: c_int,
    );
    pub fn spice_inputs_position(
        channel: *mut SpiceInputsChannel,
        x: c_int,
        y: c_int,
        display: c_int,
        button_state: c_int,
    );
    pub fn spice_inputs_set_key_locks(channel: *mut SpiceInputsChannel, locks: c_uint);
    pub fn spice_main_agent_test_capability(channel: *mut SpiceMainChannel, cap: u32) -> gboolean;
    pub fn spice_main_clipboard_grab(
        channel: *mut SpiceMainChannel,
        types: *mut u32,
        ntypes: c_int,
    );
    pub fn spice_main_clipboard_notify(
        channel: *mut SpiceMainChannel,
        type_: u32,
        data: *const u8,
        size: size_t,
    );
    pub fn spice_main_clipboard_release(channel: *mut SpiceMainChannel);
    pub fn spice_main_clipboard_request(channel: *mut SpiceMainChannel, type_: u32);
    pub fn spice_main_clipboard_selection_grab(
        channel: *mut SpiceMainChannel,
        selection: c_uint,
        types: *mut u32,
        ntypes: c_int,
    );
    pub fn spice_main_clipboard_selection_notify(
        channel: *mut SpiceMainChannel,
        selection: c_uint,
        type_: u32,
        data: *const u8,
        size: size_t,
    );
    pub fn spice_main_clipboard_selection_release(
        channel: *mut SpiceMainChannel,
        selection: c_uint,
    );
    pub fn spice_main_clipboard_selection_request(
        channel: *mut SpiceMainChannel,
        selection: c_uint,
        type_: u32,
    );
    pub fn spice_main_file_copy_async(
        channel: *mut SpiceMainChannel,
        sources: *mut *mut gio::GFile,
        flags: gio::GFileCopyFlags,
        cancellable: *mut gio::GCancellable,
        progress_callback: gio::GFileProgressCallback,
        progress_callback_data: gpointer,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn spice_main_file_copy_finish(
        channel: *mut SpiceMainChannel,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn spice_main_request_mouse_mode(channel: *mut SpiceMainChannel, mode: c_int);
    pub fn spice_main_send_monitor_config(channel: *mut SpiceMainChannel) -> gboolean;
    pub fn spice_main_set_display(
        channel: *mut SpiceMainChannel,
        id: c_int,
        x: c_int,
        y: c_int,
        width: c_int,
        height: c_int,
    );
    pub fn spice_main_set_display_enabled(
        channel: *mut SpiceMainChannel,
        id: c_int,
        enabled: gboolean,
    );
    pub fn spice_main_update_display(
        channel: *mut SpiceMainChannel,
        id: c_int,
        x: c_int,
        y: c_int,
        width: c_int,
        height: c_int,
        update: gboolean,
    );
    pub fn spice_main_update_display_enabled(
        channel: *mut SpiceMainChannel,
        id: c_int,
        enabled: gboolean,
        update: gboolean,
    );
    pub fn spice_port_event(port: *mut SpicePortChannel, event: u8);
    pub fn spice_port_write_async(
        port: *mut SpicePortChannel,
        buffer: *mut u8,
        count: size_t,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn spice_port_write_finish(
        port: *mut SpicePortChannel,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> ssize_t;
    pub fn spice_record_send_data(
        channel: *mut SpiceRecordChannel,
        data: gpointer,
        bytes: size_t,
        time: u32,
    );
    pub fn spice_set_session_option(session: *mut SpiceSession);
    pub fn spice_util_get_debug() -> gboolean;
    pub fn spice_util_get_version_string() -> *const c_char;
    pub fn spice_util_set_debug(enabled: gboolean);
    pub fn spice_uuid_to_string(uuid: *const [u8; 16]) -> *mut c_char;

}
