mod common;

pub use common::*;
use spf_milter::*;

// This test is disabled because it depends on live DNS records.
#[ignore]
#[tokio::test]
async fn live() {
    let opts = configure_logging(CliOptions::builder())
        .config_file(to_config_file_name(file!()))
        .build();

    let config = Config::read(opts).await.unwrap();

    let milter = SpfMilter::spawn(config).await.unwrap();

    let exit_code = run_miltertest(file!(), milter.addr()).await.unwrap();

    milter.shutdown().await.unwrap();

    assert!(exit_code.success());
}
