mod common;

pub use common::*;
use spf_milter::*;

#[tokio::test]
async fn delete_auth_results() {
    let opts = configure_logging(CliOptions::builder())
        .config_file(to_config_file_name(file!()))
        .build();

    let lookup = MockLookup::builder()
        .lookup_txt(|_| Ok(vec!["v=spf1 ~all".into()]))
        .build();

    let config = Config::read_with_lookup(opts, lookup).await.unwrap();

    let milter = SpfMilter::spawn(config).await.unwrap();

    let exit_code = run_miltertest(file!(), milter.addr()).await.unwrap();

    milter.shutdown().await.unwrap();

    assert!(exit_code.success());
}
