pub mod auth_results;
pub mod format;
pub mod received_spf;

use std::fmt::Display;

/// A trait for header fields.
pub trait HeaderField: Display {
    fn name(&self) -> &'static str;

    /// Returns a formatted representation of the header field body (the header
    /// ‘value’), typically with some line wrapping applied.
    fn format_body(&self) -> String;
}

// See RFC 5322, 2.1.1.
const HEADER_LINE_WIDTH: usize = 78;
