# Speak
Speak is a **Chatbot based in machine-learning**, which can be used to **interact with the user**. The philosophy of the project is to **make the user feel like they are talking to a real person**, and the way Speak does that is by being very fast, that's it.

## Features
Speak is very simple to use by design, that's the reason it has only a few public objects and functions. The features you're going to use are:

- `Map<T>` (Struct)
- `Learn(...)`
- `Run(...)`

**That's it**, you can use Speak with just two functions! These two functions are just normal functions, and you can use them in any way you want. If you want to know more, check the wiki, [clicking this link](https://github.com/blyxyas/speak/wiki) or with your favorite IDE documentation tool. (All docs are integrated in the crate.)

## Configuration
One of the philosophies of Speak is that the UX is very customizable. That's why Speak has a lot of flexibility when using custom features!

While a lot of custom values are available simply as arguments to the main functions (`learn` & `run`), there also some options that can be set to help the compiler.

The current available features are:

- `fancy_docs`: Enables the fancy documentation (Documentation that uses graphs and equations). This feature is **enabled** by default.

- `debug`: Enables the debug mode. This prints various numbers and messages to the terminal while the program is running. This feature is **enabled** by default.

See also: [Features Documentation](https://doc.rust-lang.org/cargo/reference/features.html)

## Why is Speak so fast?

Firstly, Speak is written in Rust, with just a few hundred lines of code, with 0 dependencies and just two files (the main library and the utils library.), Secondly, it's written in the (realisticly) most efficient and strict way possible. Also have in mind that Speak **is** designed to be fast in every loop, in every function wrapping there's a lot of thought, because **performance is very important for this project**, we want to be able to even have a **live chat** with the bot.

## When will Speak be ready?

I cannot know when Speak will be ready, but I can promise that it will be ready soon. I'm trying to make it the most perfect tool I can, that's why I'm taking a lot of time to make it.


## Features

### Working on:

* ~~`learn` function~~
* ~~`run` function~~

### To do:

* Multithreading
* Change most `Vec`(s) to arrays (Without runtime inefficiencies)
* Add `JS` version
* Make configuration easier

## Contributions

You can contribute to this project with almost anything, it can be code, documentation, bug reports, feature requests... etc. You can do it opening an [issue](https://github.com/SpeakML/speak/issues/new) or a [pull request](https://github.com/SpeakML/speak/pulls/new), or you can contact me on social media.

**Thanks for contributing!**

[![Stargazers repo roster for @SpeakML/speak](https://reporoster.com/stars/SpeakML/speak)](https://github.com/SpeakML/speak/stargazers)

[![Forkers repo roster for @SpeakML/speak](https://reporoster.com/forks/SpeakML/speak)](https://github.com/SpeakML/speak/network/members)

## ⚖️ License & Credits

Speak uses the [**GNU General Public License v2.0**](https://github.com/SpeakML/speak/blob/current/LICENSE/)

Creator: [Alex G. C. aka Blyxyas](https://github.com/blyxyas)
