pub const LICENSE_TEXTS: &[(&str, &str)] = &[
    ("0BSD", include!("text/licenses/0BSD")),
    ("AAL", include!("text/licenses/AAL")),
    ("ADSL", include!("text/licenses/ADSL")),
    ("AFL-1.1", include!("text/licenses/AFL-1.1")),
    ("AFL-1.2", include!("text/licenses/AFL-1.2")),
    ("AFL-2.0", include!("text/licenses/AFL-2.0")),
    ("AFL-2.1", include!("text/licenses/AFL-2.1")),
    ("AFL-3.0", include!("text/licenses/AFL-3.0")),
    ("AGPL-1.0", include!("text/licenses/AGPL-1.0")),
    ("AGPL-1.0-only", include!("text/licenses/AGPL-1.0-only")),
    (
        "AGPL-1.0-or-later",
        include!("text/licenses/AGPL-1.0-or-later"),
    ),
    ("AGPL-3.0", include!("text/licenses/AGPL-3.0")),
    ("AGPL-3.0-only", include!("text/licenses/AGPL-3.0-only")),
    (
        "AGPL-3.0-or-later",
        include!("text/licenses/AGPL-3.0-or-later"),
    ),
    ("AMDPLPA", include!("text/licenses/AMDPLPA")),
    ("AML", include!("text/licenses/AML")),
    ("AMPAS", include!("text/licenses/AMPAS")),
    ("ANTLR-PD", include!("text/licenses/ANTLR-PD")),
    (
        "ANTLR-PD-fallback",
        include!("text/licenses/ANTLR-PD-fallback"),
    ),
    ("APAFML", include!("text/licenses/APAFML")),
    ("APL-1.0", include!("text/licenses/APL-1.0")),
    ("APSL-1.0", include!("text/licenses/APSL-1.0")),
    ("APSL-1.1", include!("text/licenses/APSL-1.1")),
    ("APSL-1.2", include!("text/licenses/APSL-1.2")),
    ("APSL-2.0", include!("text/licenses/APSL-2.0")),
    ("Abstyles", include!("text/licenses/Abstyles")),
    ("Adobe-2006", include!("text/licenses/Adobe-2006")),
    ("Adobe-Glyph", include!("text/licenses/Adobe-Glyph")),
    ("Afmparse", include!("text/licenses/Afmparse")),
    ("Aladdin", include!("text/licenses/Aladdin")),
    ("Apache-1.0", include!("text/licenses/Apache-1.0")),
    ("Apache-1.1", include!("text/licenses/Apache-1.1")),
    ("Apache-2.0", include!("text/licenses/Apache-2.0")),
    ("Artistic-1.0", include!("text/licenses/Artistic-1.0")),
    (
        "Artistic-1.0-Perl",
        include!("text/licenses/Artistic-1.0-Perl"),
    ),
    (
        "Artistic-1.0-cl8",
        include!("text/licenses/Artistic-1.0-cl8"),
    ),
    ("Artistic-2.0", include!("text/licenses/Artistic-2.0")),
    ("BSD-1-Clause", include!("text/licenses/BSD-1-Clause")),
    ("BSD-2-Clause", include!("text/licenses/BSD-2-Clause")),
    (
        "BSD-2-Clause-FreeBSD",
        include!("text/licenses/BSD-2-Clause-FreeBSD"),
    ),
    (
        "BSD-2-Clause-NetBSD",
        include!("text/licenses/BSD-2-Clause-NetBSD"),
    ),
    (
        "BSD-2-Clause-Patent",
        include!("text/licenses/BSD-2-Clause-Patent"),
    ),
    (
        "BSD-2-Clause-Views",
        include!("text/licenses/BSD-2-Clause-Views"),
    ),
    ("BSD-3-Clause", include!("text/licenses/BSD-3-Clause")),
    (
        "BSD-3-Clause-Attribution",
        include!("text/licenses/BSD-3-Clause-Attribution"),
    ),
    (
        "BSD-3-Clause-Clear",
        include!("text/licenses/BSD-3-Clause-Clear"),
    ),
    (
        "BSD-3-Clause-LBNL",
        include!("text/licenses/BSD-3-Clause-LBNL"),
    ),
    (
        "BSD-3-Clause-Modification",
        include!("text/licenses/BSD-3-Clause-Modification"),
    ),
    (
        "BSD-3-Clause-No-Military-License",
        include!("text/licenses/BSD-3-Clause-No-Military-License"),
    ),
    (
        "BSD-3-Clause-No-Nuclear-License",
        include!("text/licenses/BSD-3-Clause-No-Nuclear-License"),
    ),
    (
        "BSD-3-Clause-No-Nuclear-License-2014",
        include!("text/licenses/BSD-3-Clause-No-Nuclear-License-2014"),
    ),
    (
        "BSD-3-Clause-No-Nuclear-Warranty",
        include!("text/licenses/BSD-3-Clause-No-Nuclear-Warranty"),
    ),
    (
        "BSD-3-Clause-Open-MPI",
        include!("text/licenses/BSD-3-Clause-Open-MPI"),
    ),
    ("BSD-4-Clause", include!("text/licenses/BSD-4-Clause")),
    (
        "BSD-4-Clause-Shortened",
        include!("text/licenses/BSD-4-Clause-Shortened"),
    ),
    ("BSD-4-Clause-UC", include!("text/licenses/BSD-4-Clause-UC")),
    ("BSD-Protection", include!("text/licenses/BSD-Protection")),
    ("BSD-Source-Code", include!("text/licenses/BSD-Source-Code")),
    ("BSL-1.0", include!("text/licenses/BSL-1.0")),
    ("BUSL-1.1", include!("text/licenses/BUSL-1.1")),
    ("Bahyph", include!("text/licenses/Bahyph")),
    ("Barr", include!("text/licenses/Barr")),
    ("Beerware", include!("text/licenses/Beerware")),
    ("BitTorrent-1.0", include!("text/licenses/BitTorrent-1.0")),
    ("BitTorrent-1.1", include!("text/licenses/BitTorrent-1.1")),
    ("BlueOak-1.0.0", include!("text/licenses/BlueOak-1.0.0")),
    ("Borceux", include!("text/licenses/Borceux")),
    ("C-UDA-1.0", include!("text/licenses/C-UDA-1.0")),
    ("CAL-1.0", include!("text/licenses/CAL-1.0")),
    (
        "CAL-1.0-Combined-Work-Exception",
        include!("text/licenses/CAL-1.0-Combined-Work-Exception"),
    ),
    ("CATOSL-1.1", include!("text/licenses/CATOSL-1.1")),
    ("CC-BY-1.0", include!("text/licenses/CC-BY-1.0")),
    ("CC-BY-2.0", include!("text/licenses/CC-BY-2.0")),
    ("CC-BY-2.5", include!("text/licenses/CC-BY-2.5")),
    ("CC-BY-2.5-AU", include!("text/licenses/CC-BY-2.5-AU")),
    ("CC-BY-3.0", include!("text/licenses/CC-BY-3.0")),
    ("CC-BY-3.0-AT", include!("text/licenses/CC-BY-3.0-AT")),
    ("CC-BY-3.0-DE", include!("text/licenses/CC-BY-3.0-DE")),
    ("CC-BY-3.0-NL", include!("text/licenses/CC-BY-3.0-NL")),
    ("CC-BY-3.0-US", include!("text/licenses/CC-BY-3.0-US")),
    ("CC-BY-4.0", include!("text/licenses/CC-BY-4.0")),
    ("CC-BY-NC-1.0", include!("text/licenses/CC-BY-NC-1.0")),
    ("CC-BY-NC-2.0", include!("text/licenses/CC-BY-NC-2.0")),
    ("CC-BY-NC-2.5", include!("text/licenses/CC-BY-NC-2.5")),
    ("CC-BY-NC-3.0", include!("text/licenses/CC-BY-NC-3.0")),
    ("CC-BY-NC-3.0-DE", include!("text/licenses/CC-BY-NC-3.0-DE")),
    ("CC-BY-NC-4.0", include!("text/licenses/CC-BY-NC-4.0")),
    ("CC-BY-NC-ND-1.0", include!("text/licenses/CC-BY-NC-ND-1.0")),
    ("CC-BY-NC-ND-2.0", include!("text/licenses/CC-BY-NC-ND-2.0")),
    ("CC-BY-NC-ND-2.5", include!("text/licenses/CC-BY-NC-ND-2.5")),
    ("CC-BY-NC-ND-3.0", include!("text/licenses/CC-BY-NC-ND-3.0")),
    (
        "CC-BY-NC-ND-3.0-DE",
        include!("text/licenses/CC-BY-NC-ND-3.0-DE"),
    ),
    (
        "CC-BY-NC-ND-3.0-IGO",
        include!("text/licenses/CC-BY-NC-ND-3.0-IGO"),
    ),
    ("CC-BY-NC-ND-4.0", include!("text/licenses/CC-BY-NC-ND-4.0")),
    ("CC-BY-NC-SA-1.0", include!("text/licenses/CC-BY-NC-SA-1.0")),
    ("CC-BY-NC-SA-2.0", include!("text/licenses/CC-BY-NC-SA-2.0")),
    (
        "CC-BY-NC-SA-2.0-FR",
        include!("text/licenses/CC-BY-NC-SA-2.0-FR"),
    ),
    (
        "CC-BY-NC-SA-2.0-UK",
        include!("text/licenses/CC-BY-NC-SA-2.0-UK"),
    ),
    ("CC-BY-NC-SA-2.5", include!("text/licenses/CC-BY-NC-SA-2.5")),
    ("CC-BY-NC-SA-3.0", include!("text/licenses/CC-BY-NC-SA-3.0")),
    (
        "CC-BY-NC-SA-3.0-DE",
        include!("text/licenses/CC-BY-NC-SA-3.0-DE"),
    ),
    (
        "CC-BY-NC-SA-3.0-IGO",
        include!("text/licenses/CC-BY-NC-SA-3.0-IGO"),
    ),
    ("CC-BY-NC-SA-4.0", include!("text/licenses/CC-BY-NC-SA-4.0")),
    ("CC-BY-ND-1.0", include!("text/licenses/CC-BY-ND-1.0")),
    ("CC-BY-ND-2.0", include!("text/licenses/CC-BY-ND-2.0")),
    ("CC-BY-ND-2.5", include!("text/licenses/CC-BY-ND-2.5")),
    ("CC-BY-ND-3.0", include!("text/licenses/CC-BY-ND-3.0")),
    ("CC-BY-ND-3.0-DE", include!("text/licenses/CC-BY-ND-3.0-DE")),
    ("CC-BY-ND-4.0", include!("text/licenses/CC-BY-ND-4.0")),
    ("CC-BY-SA-1.0", include!("text/licenses/CC-BY-SA-1.0")),
    ("CC-BY-SA-2.0", include!("text/licenses/CC-BY-SA-2.0")),
    ("CC-BY-SA-2.0-UK", include!("text/licenses/CC-BY-SA-2.0-UK")),
    ("CC-BY-SA-2.1-JP", include!("text/licenses/CC-BY-SA-2.1-JP")),
    ("CC-BY-SA-2.5", include!("text/licenses/CC-BY-SA-2.5")),
    ("CC-BY-SA-3.0", include!("text/licenses/CC-BY-SA-3.0")),
    ("CC-BY-SA-3.0-AT", include!("text/licenses/CC-BY-SA-3.0-AT")),
    ("CC-BY-SA-3.0-DE", include!("text/licenses/CC-BY-SA-3.0-DE")),
    ("CC-BY-SA-4.0", include!("text/licenses/CC-BY-SA-4.0")),
    ("CC-PDDC", include!("text/licenses/CC-PDDC")),
    ("CC0-1.0", include!("text/licenses/CC0-1.0")),
    ("CDDL-1.0", include!("text/licenses/CDDL-1.0")),
    ("CDDL-1.1", include!("text/licenses/CDDL-1.1")),
    ("CDL-1.0", include!("text/licenses/CDL-1.0")),
    (
        "CDLA-Permissive-1.0",
        include!("text/licenses/CDLA-Permissive-1.0"),
    ),
    (
        "CDLA-Permissive-2.0",
        include!("text/licenses/CDLA-Permissive-2.0"),
    ),
    (
        "CDLA-Sharing-1.0",
        include!("text/licenses/CDLA-Sharing-1.0"),
    ),
    ("CECILL-1.0", include!("text/licenses/CECILL-1.0")),
    ("CECILL-1.1", include!("text/licenses/CECILL-1.1")),
    ("CECILL-2.0", include!("text/licenses/CECILL-2.0")),
    ("CECILL-2.1", include!("text/licenses/CECILL-2.1")),
    ("CECILL-B", include!("text/licenses/CECILL-B")),
    ("CECILL-C", include!("text/licenses/CECILL-C")),
    ("CERN-OHL-1.1", include!("text/licenses/CERN-OHL-1.1")),
    ("CERN-OHL-1.2", include!("text/licenses/CERN-OHL-1.2")),
    ("CERN-OHL-P-2.0", include!("text/licenses/CERN-OHL-P-2.0")),
    ("CERN-OHL-S-2.0", include!("text/licenses/CERN-OHL-S-2.0")),
    ("CERN-OHL-W-2.0", include!("text/licenses/CERN-OHL-W-2.0")),
    ("CNRI-Jython", include!("text/licenses/CNRI-Jython")),
    ("CNRI-Python", include!("text/licenses/CNRI-Python")),
    (
        "CNRI-Python-GPL-Compatible",
        include!("text/licenses/CNRI-Python-GPL-Compatible"),
    ),
    ("CPAL-1.0", include!("text/licenses/CPAL-1.0")),
    ("CPL-1.0", include!("text/licenses/CPL-1.0")),
    ("CPOL-1.02", include!("text/licenses/CPOL-1.02")),
    ("CUA-OPL-1.0", include!("text/licenses/CUA-OPL-1.0")),
    ("Caldera", include!("text/licenses/Caldera")),
    ("ClArtistic", include!("text/licenses/ClArtistic")),
    ("Condor-1.1", include!("text/licenses/Condor-1.1")),
    ("Crossword", include!("text/licenses/Crossword")),
    ("CrystalStacker", include!("text/licenses/CrystalStacker")),
    ("Cube", include!("text/licenses/Cube")),
    ("D-FSL-1.0", include!("text/licenses/D-FSL-1.0")),
    ("DOC", include!("text/licenses/DOC")),
    ("DRL-1.0", include!("text/licenses/DRL-1.0")),
    ("DSDP", include!("text/licenses/DSDP")),
    ("Dotseqn", include!("text/licenses/Dotseqn")),
    ("ECL-1.0", include!("text/licenses/ECL-1.0")),
    ("ECL-2.0", include!("text/licenses/ECL-2.0")),
    ("EFL-1.0", include!("text/licenses/EFL-1.0")),
    ("EFL-2.0", include!("text/licenses/EFL-2.0")),
    ("EPICS", include!("text/licenses/EPICS")),
    ("EPL-1.0", include!("text/licenses/EPL-1.0")),
    ("EPL-2.0", include!("text/licenses/EPL-2.0")),
    ("EUDatagrid", include!("text/licenses/EUDatagrid")),
    ("EUPL-1.0", include!("text/licenses/EUPL-1.0")),
    ("EUPL-1.1", include!("text/licenses/EUPL-1.1")),
    ("EUPL-1.2", include!("text/licenses/EUPL-1.2")),
    ("Entessa", include!("text/licenses/Entessa")),
    ("ErlPL-1.1", include!("text/licenses/ErlPL-1.1")),
    ("Eurosym", include!("text/licenses/Eurosym")),
    ("FSFAP", include!("text/licenses/FSFAP")),
    ("FSFUL", include!("text/licenses/FSFUL")),
    ("FSFULLR", include!("text/licenses/FSFULLR")),
    ("FTL", include!("text/licenses/FTL")),
    ("Fair", include!("text/licenses/Fair")),
    ("Frameworx-1.0", include!("text/licenses/Frameworx-1.0")),
    ("FreeBSD-DOC", include!("text/licenses/FreeBSD-DOC")),
    ("FreeImage", include!("text/licenses/FreeImage")),
    ("GD", include!("text/licenses/GD")),
    ("GFDL-1.1", include!("text/licenses/GFDL-1.1")),
    (
        "GFDL-1.1-invariants",
        include!("text/licenses/GFDL-1.1-invariants-only"),
    ),
    (
        "GFDL-1.1-invariants-only",
        include!("text/licenses/GFDL-1.1-invariants-only"),
    ),
    (
        "GFDL-1.1-invariants-or-later",
        include!("text/licenses/GFDL-1.1-invariants-or-later"),
    ),
    (
        "GFDL-1.1-no-invariants",
        include!("text/licenses/GFDL-1.1-no-invariants-only"),
    ),
    (
        "GFDL-1.1-no-invariants-only",
        include!("text/licenses/GFDL-1.1-no-invariants-only"),
    ),
    (
        "GFDL-1.1-no-invariants-or-later",
        include!("text/licenses/GFDL-1.1-no-invariants-or-later"),
    ),
    ("GFDL-1.1-only", include!("text/licenses/GFDL-1.1-only")),
    (
        "GFDL-1.1-or-later",
        include!("text/licenses/GFDL-1.1-or-later"),
    ),
    ("GFDL-1.2", include!("text/licenses/GFDL-1.2")),
    (
        "GFDL-1.2-invariants",
        include!("text/licenses/GFDL-1.2-invariants-only"),
    ),
    (
        "GFDL-1.2-invariants-only",
        include!("text/licenses/GFDL-1.2-invariants-only"),
    ),
    (
        "GFDL-1.2-invariants-or-later",
        include!("text/licenses/GFDL-1.2-invariants-or-later"),
    ),
    (
        "GFDL-1.2-no-invariants",
        include!("text/licenses/GFDL-1.2-no-invariants-only"),
    ),
    (
        "GFDL-1.2-no-invariants-only",
        include!("text/licenses/GFDL-1.2-no-invariants-only"),
    ),
    (
        "GFDL-1.2-no-invariants-or-later",
        include!("text/licenses/GFDL-1.2-no-invariants-or-later"),
    ),
    ("GFDL-1.2-only", include!("text/licenses/GFDL-1.2-only")),
    (
        "GFDL-1.2-or-later",
        include!("text/licenses/GFDL-1.2-or-later"),
    ),
    ("GFDL-1.3", include!("text/licenses/GFDL-1.3")),
    (
        "GFDL-1.3-invariants",
        include!("text/licenses/GFDL-1.3-invariants-only"),
    ),
    (
        "GFDL-1.3-invariants-only",
        include!("text/licenses/GFDL-1.3-invariants-only"),
    ),
    (
        "GFDL-1.3-invariants-or-later",
        include!("text/licenses/GFDL-1.3-invariants-or-later"),
    ),
    (
        "GFDL-1.3-no-invariants",
        include!("text/licenses/GFDL-1.3-no-invariants-only"),
    ),
    (
        "GFDL-1.3-no-invariants-only",
        include!("text/licenses/GFDL-1.3-no-invariants-only"),
    ),
    (
        "GFDL-1.3-no-invariants-or-later",
        include!("text/licenses/GFDL-1.3-no-invariants-or-later"),
    ),
    ("GFDL-1.3-only", include!("text/licenses/GFDL-1.3-only")),
    (
        "GFDL-1.3-or-later",
        include!("text/licenses/GFDL-1.3-or-later"),
    ),
    ("GL2PS", include!("text/licenses/GL2PS")),
    ("GLWTPL", include!("text/licenses/GLWTPL")),
    ("GPL-1.0", include!("text/licenses/GPL-1.0")),
    ("GPL-1.0+", include!("text/licenses/GPL-1.0+")),
    ("GPL-1.0-only", include!("text/licenses/GPL-1.0-only")),
    (
        "GPL-1.0-or-later",
        include!("text/licenses/GPL-1.0-or-later"),
    ),
    ("GPL-2.0", include!("text/licenses/GPL-2.0")),
    ("GPL-2.0+", include!("text/licenses/GPL-2.0+")),
    ("GPL-2.0-only", include!("text/licenses/GPL-2.0-only")),
    (
        "GPL-2.0-or-later",
        include!("text/licenses/GPL-2.0-or-later"),
    ),
    (
        "GPL-2.0-with-GCC-exception",
        include!("text/licenses/GPL-2.0-with-GCC-exception"),
    ),
    (
        "GPL-2.0-with-autoconf-exception",
        include!("text/licenses/GPL-2.0-with-autoconf-exception"),
    ),
    (
        "GPL-2.0-with-bison-exception",
        include!("text/licenses/GPL-2.0-with-bison-exception"),
    ),
    (
        "GPL-2.0-with-classpath-exception",
        include!("text/licenses/GPL-2.0-with-classpath-exception"),
    ),
    (
        "GPL-2.0-with-font-exception",
        include!("text/licenses/GPL-2.0-with-font-exception"),
    ),
    ("GPL-3.0", include!("text/licenses/GPL-3.0")),
    ("GPL-3.0+", include!("text/licenses/GPL-3.0+")),
    ("GPL-3.0-only", include!("text/licenses/GPL-3.0-only")),
    (
        "GPL-3.0-or-later",
        include!("text/licenses/GPL-3.0-or-later"),
    ),
    (
        "GPL-3.0-with-GCC-exception",
        include!("text/licenses/GPL-3.0-with-GCC-exception"),
    ),
    (
        "GPL-3.0-with-autoconf-exception",
        include!("text/licenses/GPL-3.0-with-autoconf-exception"),
    ),
    ("Giftware", include!("text/licenses/Giftware")),
    ("Glide", include!("text/licenses/Glide")),
    ("Glulxe", include!("text/licenses/Glulxe")),
    ("HPND", include!("text/licenses/HPND")),
    (
        "HPND-sell-variant",
        include!("text/licenses/HPND-sell-variant"),
    ),
    ("HTMLTIDY", include!("text/licenses/HTMLTIDY")),
    ("HaskellReport", include!("text/licenses/HaskellReport")),
    ("Hippocratic-2.1", include!("text/licenses/Hippocratic-2.1")),
    ("IBM-pibs", include!("text/licenses/IBM-pibs")),
    ("ICU", include!("text/licenses/ICU")),
    ("IJG", include!("text/licenses/IJG")),
    ("IPA", include!("text/licenses/IPA")),
    ("IPL-1.0", include!("text/licenses/IPL-1.0")),
    ("ISC", include!("text/licenses/ISC")),
    ("ImageMagick", include!("text/licenses/ImageMagick")),
    ("Imlib2", include!("text/licenses/Imlib2")),
    ("Info-ZIP", include!("text/licenses/Info-ZIP")),
    ("Intel", include!("text/licenses/Intel")),
    ("Intel-ACPI", include!("text/licenses/Intel-ACPI")),
    ("Interbase-1.0", include!("text/licenses/Interbase-1.0")),
    ("JPNIC", include!("text/licenses/JPNIC")),
    ("JSON", include!("text/licenses/JSON")),
    ("JasPer-2.0", include!("text/licenses/JasPer-2.0")),
    ("LAL-1.2", include!("text/licenses/LAL-1.2")),
    ("LAL-1.3", include!("text/licenses/LAL-1.3")),
    ("LGPL-2.0", include!("text/licenses/LGPL-2.0")),
    ("LGPL-2.0+", include!("text/licenses/LGPL-2.0+")),
    ("LGPL-2.0-only", include!("text/licenses/LGPL-2.0-only")),
    (
        "LGPL-2.0-or-later",
        include!("text/licenses/LGPL-2.0-or-later"),
    ),
    ("LGPL-2.1", include!("text/licenses/LGPL-2.1")),
    ("LGPL-2.1+", include!("text/licenses/LGPL-2.1+")),
    ("LGPL-2.1-only", include!("text/licenses/LGPL-2.1-only")),
    (
        "LGPL-2.1-or-later",
        include!("text/licenses/LGPL-2.1-or-later"),
    ),
    ("LGPL-3.0", include!("text/licenses/LGPL-3.0")),
    ("LGPL-3.0+", include!("text/licenses/LGPL-3.0+")),
    ("LGPL-3.0-only", include!("text/licenses/LGPL-3.0-only")),
    (
        "LGPL-3.0-or-later",
        include!("text/licenses/LGPL-3.0-or-later"),
    ),
    ("LGPLLR", include!("text/licenses/LGPLLR")),
    ("LPL-1.0", include!("text/licenses/LPL-1.0")),
    ("LPL-1.02", include!("text/licenses/LPL-1.02")),
    ("LPPL-1.0", include!("text/licenses/LPPL-1.0")),
    ("LPPL-1.1", include!("text/licenses/LPPL-1.1")),
    ("LPPL-1.2", include!("text/licenses/LPPL-1.2")),
    ("LPPL-1.3a", include!("text/licenses/LPPL-1.3a")),
    ("LPPL-1.3c", include!("text/licenses/LPPL-1.3c")),
    ("Latex2e", include!("text/licenses/Latex2e")),
    ("Leptonica", include!("text/licenses/Leptonica")),
    ("LiLiQ-P-1.1", include!("text/licenses/LiLiQ-P-1.1")),
    ("LiLiQ-R-1.1", include!("text/licenses/LiLiQ-R-1.1")),
    ("LiLiQ-Rplus-1.1", include!("text/licenses/LiLiQ-Rplus-1.1")),
    ("Libpng", include!("text/licenses/Libpng")),
    ("Linux-OpenIB", include!("text/licenses/Linux-OpenIB")),
    ("MIT", include!("text/licenses/MIT")),
    ("MIT-0", include!("text/licenses/MIT-0")),
    ("MIT-CMU", include!("text/licenses/MIT-CMU")),
    (
        "MIT-Modern-Variant",
        include!("text/licenses/MIT-Modern-Variant"),
    ),
    ("MIT-advertising", include!("text/licenses/MIT-advertising")),
    ("MIT-enna", include!("text/licenses/MIT-enna")),
    ("MIT-feh", include!("text/licenses/MIT-feh")),
    ("MIT-open-group", include!("text/licenses/MIT-open-group")),
    ("MITNFA", include!("text/licenses/MITNFA")),
    ("MPL-1.0", include!("text/licenses/MPL-1.0")),
    ("MPL-1.1", include!("text/licenses/MPL-1.1")),
    ("MPL-2.0", include!("text/licenses/MPL-2.0")),
    (
        "MPL-2.0-no-copyleft-exception",
        include!("text/licenses/MPL-2.0-no-copyleft-exception"),
    ),
    ("MS-PL", include!("text/licenses/MS-PL")),
    ("MS-RL", include!("text/licenses/MS-RL")),
    ("MTLL", include!("text/licenses/MTLL")),
    ("MakeIndex", include!("text/licenses/MakeIndex")),
    ("MirOS", include!("text/licenses/MirOS")),
    ("Motosoto", include!("text/licenses/Motosoto")),
    ("MulanPSL-1.0", include!("text/licenses/MulanPSL-1.0")),
    ("MulanPSL-2.0", include!("text/licenses/MulanPSL-2.0")),
    ("Multics", include!("text/licenses/Multics")),
    ("Mup", include!("text/licenses/Mup")),
    ("NAIST-2003", include!("text/licenses/NAIST-2003")),
    ("NASA-1.3", include!("text/licenses/NASA-1.3")),
    ("NBPL-1.0", include!("text/licenses/NBPL-1.0")),
    ("NCGL-UK-2.0", include!("text/licenses/NCGL-UK-2.0")),
    ("NCSA", include!("text/licenses/NCSA")),
    ("NGPL", include!("text/licenses/NGPL")),
    ("NIST-PD", include!("text/licenses/NIST-PD")),
    (
        "NIST-PD-fallback",
        include!("text/licenses/NIST-PD-fallback"),
    ),
    ("NLOD-1.0", include!("text/licenses/NLOD-1.0")),
    ("NLOD-2.0", include!("text/licenses/NLOD-2.0")),
    ("NLPL", include!("text/licenses/NLPL")),
    ("NOASSERTION", ""),
    ("NOSL", include!("text/licenses/NOSL")),
    ("NPL-1.0", include!("text/licenses/NPL-1.0")),
    ("NPL-1.1", include!("text/licenses/NPL-1.1")),
    ("NPOSL-3.0", include!("text/licenses/NPOSL-3.0")),
    ("NRL", include!("text/licenses/NRL")),
    ("NTP", include!("text/licenses/NTP")),
    ("NTP-0", include!("text/licenses/NTP-0")),
    ("Naumen", include!("text/licenses/Naumen")),
    ("Net-SNMP", include!("text/licenses/Net-SNMP")),
    ("NetCDF", include!("text/licenses/NetCDF")),
    ("Newsletr", include!("text/licenses/Newsletr")),
    ("Nokia", include!("text/licenses/Nokia")),
    ("Noweb", include!("text/licenses/Noweb")),
    ("Nunit", include!("text/licenses/Nunit")),
    ("O-UDA-1.0", include!("text/licenses/O-UDA-1.0")),
    ("OCCT-PL", include!("text/licenses/OCCT-PL")),
    ("OCLC-2.0", include!("text/licenses/OCLC-2.0")),
    ("ODC-By-1.0", include!("text/licenses/ODC-By-1.0")),
    ("ODbL-1.0", include!("text/licenses/ODbL-1.0")),
    ("OFL-1.0", include!("text/licenses/OFL-1.0")),
    ("OFL-1.0-RFN", include!("text/licenses/OFL-1.0-RFN")),
    ("OFL-1.0-no-RFN", include!("text/licenses/OFL-1.0-no-RFN")),
    ("OFL-1.1", include!("text/licenses/OFL-1.1")),
    ("OFL-1.1-RFN", include!("text/licenses/OFL-1.1-RFN")),
    ("OFL-1.1-no-RFN", include!("text/licenses/OFL-1.1-no-RFN")),
    ("OGC-1.0", include!("text/licenses/OGC-1.0")),
    ("OGDL-Taiwan-1.0", include!("text/licenses/OGDL-Taiwan-1.0")),
    ("OGL-Canada-2.0", include!("text/licenses/OGL-Canada-2.0")),
    ("OGL-UK-1.0", include!("text/licenses/OGL-UK-1.0")),
    ("OGL-UK-2.0", include!("text/licenses/OGL-UK-2.0")),
    ("OGL-UK-3.0", include!("text/licenses/OGL-UK-3.0")),
    ("OGTSL", include!("text/licenses/OGTSL")),
    ("OLDAP-1.1", include!("text/licenses/OLDAP-1.1")),
    ("OLDAP-1.2", include!("text/licenses/OLDAP-1.2")),
    ("OLDAP-1.3", include!("text/licenses/OLDAP-1.3")),
    ("OLDAP-1.4", include!("text/licenses/OLDAP-1.4")),
    ("OLDAP-2.0", include!("text/licenses/OLDAP-2.0")),
    ("OLDAP-2.0.1", include!("text/licenses/OLDAP-2.0.1")),
    ("OLDAP-2.1", include!("text/licenses/OLDAP-2.1")),
    ("OLDAP-2.2", include!("text/licenses/OLDAP-2.2")),
    ("OLDAP-2.2.1", include!("text/licenses/OLDAP-2.2.1")),
    ("OLDAP-2.2.2", include!("text/licenses/OLDAP-2.2.2")),
    ("OLDAP-2.3", include!("text/licenses/OLDAP-2.3")),
    ("OLDAP-2.4", include!("text/licenses/OLDAP-2.4")),
    ("OLDAP-2.5", include!("text/licenses/OLDAP-2.5")),
    ("OLDAP-2.6", include!("text/licenses/OLDAP-2.6")),
    ("OLDAP-2.7", include!("text/licenses/OLDAP-2.7")),
    ("OLDAP-2.8", include!("text/licenses/OLDAP-2.8")),
    ("OML", include!("text/licenses/OML")),
    ("OPL-1.0", include!("text/licenses/OPL-1.0")),
    ("OPUBL-1.0", include!("text/licenses/OPUBL-1.0")),
    ("OSET-PL-2.1", include!("text/licenses/OSET-PL-2.1")),
    ("OSL-1.0", include!("text/licenses/OSL-1.0")),
    ("OSL-1.1", include!("text/licenses/OSL-1.1")),
    ("OSL-2.0", include!("text/licenses/OSL-2.0")),
    ("OSL-2.1", include!("text/licenses/OSL-2.1")),
    ("OSL-3.0", include!("text/licenses/OSL-3.0")),
    ("OpenSSL", include!("text/licenses/OpenSSL")),
    ("PDDL-1.0", include!("text/licenses/PDDL-1.0")),
    ("PHP-3.0", include!("text/licenses/PHP-3.0")),
    ("PHP-3.01", include!("text/licenses/PHP-3.01")),
    ("PSF-2.0", include!("text/licenses/PSF-2.0")),
    ("Parity-6.0.0", include!("text/licenses/Parity-6.0.0")),
    ("Parity-7.0.0", include!("text/licenses/Parity-7.0.0")),
    ("Plexus", include!("text/licenses/Plexus")),
    (
        "PolyForm-Noncommercial-1.0.0",
        include!("text/licenses/PolyForm-Noncommercial-1.0.0"),
    ),
    (
        "PolyForm-Small-Business-1.0.0",
        include!("text/licenses/PolyForm-Small-Business-1.0.0"),
    ),
    ("PostgreSQL", include!("text/licenses/PostgreSQL")),
    ("Python-2.0", include!("text/licenses/Python-2.0")),
    ("QPL-1.0", include!("text/licenses/QPL-1.0")),
    ("Qhull", include!("text/licenses/Qhull")),
    ("RHeCos-1.1", include!("text/licenses/RHeCos-1.1")),
    ("RPL-1.1", include!("text/licenses/RPL-1.1")),
    ("RPL-1.5", include!("text/licenses/RPL-1.5")),
    ("RPSL-1.0", include!("text/licenses/RPSL-1.0")),
    ("RSA-MD", include!("text/licenses/RSA-MD")),
    ("RSCPL", include!("text/licenses/RSCPL")),
    ("Rdisc", include!("text/licenses/Rdisc")),
    ("Ruby", include!("text/licenses/Ruby")),
    ("SAX-PD", include!("text/licenses/SAX-PD")),
    ("SCEA", include!("text/licenses/SCEA")),
    ("SGI-B-1.0", include!("text/licenses/SGI-B-1.0")),
    ("SGI-B-1.1", include!("text/licenses/SGI-B-1.1")),
    ("SGI-B-2.0", include!("text/licenses/SGI-B-2.0")),
    ("SHL-0.5", include!("text/licenses/SHL-0.5")),
    ("SHL-0.51", include!("text/licenses/SHL-0.51")),
    ("SISSL", include!("text/licenses/SISSL")),
    ("SISSL-1.2", include!("text/licenses/SISSL-1.2")),
    ("SMLNJ", include!("text/licenses/SMLNJ")),
    ("SMPPL", include!("text/licenses/SMPPL")),
    ("SNIA", include!("text/licenses/SNIA")),
    ("SPL-1.0", include!("text/licenses/SPL-1.0")),
    ("SSH-OpenSSH", include!("text/licenses/SSH-OpenSSH")),
    ("SSH-short", include!("text/licenses/SSH-short")),
    ("SSPL-1.0", include!("text/licenses/SSPL-1.0")),
    ("SWL", include!("text/licenses/SWL")),
    ("Saxpath", include!("text/licenses/Saxpath")),
    ("Sendmail", include!("text/licenses/Sendmail")),
    ("Sendmail-8.23", include!("text/licenses/Sendmail-8.23")),
    ("SimPL-2.0", include!("text/licenses/SimPL-2.0")),
    ("Sleepycat", include!("text/licenses/Sleepycat")),
    ("Spencer-86", include!("text/licenses/Spencer-86")),
    ("Spencer-94", include!("text/licenses/Spencer-94")),
    ("Spencer-99", include!("text/licenses/Spencer-99")),
    ("StandardML-NJ", include!("text/licenses/StandardML-NJ")),
    ("SugarCRM-1.1.3", include!("text/licenses/SugarCRM-1.1.3")),
    ("TAPR-OHL-1.0", include!("text/licenses/TAPR-OHL-1.0")),
    ("TCL", include!("text/licenses/TCL")),
    ("TCP-wrappers", include!("text/licenses/TCP-wrappers")),
    ("TMate", include!("text/licenses/TMate")),
    ("TORQUE-1.1", include!("text/licenses/TORQUE-1.1")),
    ("TOSL", include!("text/licenses/TOSL")),
    ("TU-Berlin-1.0", include!("text/licenses/TU-Berlin-1.0")),
    ("TU-Berlin-2.0", include!("text/licenses/TU-Berlin-2.0")),
    ("UCL-1.0", include!("text/licenses/UCL-1.0")),
    ("UPL-1.0", include!("text/licenses/UPL-1.0")),
    (
        "Unicode-DFS-2015",
        include!("text/licenses/Unicode-DFS-2015"),
    ),
    (
        "Unicode-DFS-2016",
        include!("text/licenses/Unicode-DFS-2016"),
    ),
    ("Unicode-TOU", include!("text/licenses/Unicode-TOU")),
    ("Unlicense", include!("text/licenses/Unlicense")),
    ("VOSTROM", include!("text/licenses/VOSTROM")),
    ("VSL-1.0", include!("text/licenses/VSL-1.0")),
    ("Vim", include!("text/licenses/Vim")),
    ("W3C", include!("text/licenses/W3C")),
    ("W3C-19980720", include!("text/licenses/W3C-19980720")),
    ("W3C-20150513", include!("text/licenses/W3C-20150513")),
    ("WTFPL", include!("text/licenses/WTFPL")),
    ("Watcom-1.0", include!("text/licenses/Watcom-1.0")),
    ("Wsuipa", include!("text/licenses/Wsuipa")),
    ("X11", include!("text/licenses/X11")),
    ("XFree86-1.1", include!("text/licenses/XFree86-1.1")),
    ("XSkat", include!("text/licenses/XSkat")),
    ("Xerox", include!("text/licenses/Xerox")),
    ("Xnet", include!("text/licenses/Xnet")),
    ("YPL-1.0", include!("text/licenses/YPL-1.0")),
    ("YPL-1.1", include!("text/licenses/YPL-1.1")),
    ("ZPL-1.1", include!("text/licenses/ZPL-1.1")),
    ("ZPL-2.0", include!("text/licenses/ZPL-2.0")),
    ("ZPL-2.1", include!("text/licenses/ZPL-2.1")),
    ("Zed", include!("text/licenses/Zed")),
    ("Zend-2.0", include!("text/licenses/Zend-2.0")),
    ("Zimbra-1.3", include!("text/licenses/Zimbra-1.3")),
    ("Zimbra-1.4", include!("text/licenses/Zimbra-1.4")),
    ("Zlib", include!("text/licenses/Zlib")),
    ("blessing", include!("text/licenses/blessing")),
    ("bzip2-1.0.5", include!("text/licenses/bzip2-1.0.5")),
    ("bzip2-1.0.6", include!("text/licenses/bzip2-1.0.6")),
    (
        "copyleft-next-0.3.0",
        include!("text/licenses/copyleft-next-0.3.0"),
    ),
    (
        "copyleft-next-0.3.1",
        include!("text/licenses/copyleft-next-0.3.1"),
    ),
    ("curl", include!("text/licenses/curl")),
    ("diffmark", include!("text/licenses/diffmark")),
    ("dvipdfm", include!("text/licenses/dvipdfm")),
    ("eCos-2.0", include!("text/licenses/eCos-2.0")),
    ("eGenix", include!("text/licenses/eGenix")),
    ("etalab-2.0", include!("text/licenses/etalab-2.0")),
    ("gSOAP-1.3b", include!("text/licenses/gSOAP-1.3b")),
    ("gnuplot", include!("text/licenses/gnuplot")),
    ("iMatix", include!("text/licenses/iMatix")),
    ("libpng-2.0", include!("text/licenses/libpng-2.0")),
    ("libselinux-1.0", include!("text/licenses/libselinux-1.0")),
    ("libtiff", include!("text/licenses/libtiff")),
    ("mpich2", include!("text/licenses/mpich2")),
    ("psfrag", include!("text/licenses/psfrag")),
    ("psutils", include!("text/licenses/psutils")),
    ("wxWindows", include!("text/licenses/wxWindows")),
    ("xinetd", include!("text/licenses/xinetd")),
    ("xpp", include!("text/licenses/xpp")),
    (
        "zlib-acknowledgement",
        include!("text/licenses/zlib-acknowledgement"),
    ),
];

pub const EXCEPTION_TEXTS: &[(&str, &str)] = &[
    ("389-exception", include!("text/exceptions/389-exception")),
    (
        "Autoconf-exception-2.0",
        include!("text/exceptions/Autoconf-exception-2.0"),
    ),
    (
        "Autoconf-exception-3.0",
        include!("text/exceptions/Autoconf-exception-3.0"),
    ),
    (
        "Bison-exception-2.2",
        include!("text/exceptions/Bison-exception-2.2"),
    ),
    (
        "Bootloader-exception",
        include!("text/exceptions/Bootloader-exception"),
    ),
    (
        "CLISP-exception-2.0",
        include!("text/exceptions/CLISP-exception-2.0"),
    ),
    (
        "Classpath-exception-2.0",
        include!("text/exceptions/Classpath-exception-2.0"),
    ),
    (
        "DigiRule-FOSS-exception",
        include!("text/exceptions/DigiRule-FOSS-exception"),
    ),
    ("FLTK-exception", include!("text/exceptions/FLTK-exception")),
    (
        "Fawkes-Runtime-exception",
        include!("text/exceptions/Fawkes-Runtime-exception"),
    ),
    (
        "Font-exception-2.0",
        include!("text/exceptions/Font-exception-2.0"),
    ),
    (
        "GCC-exception-2.0",
        include!("text/exceptions/GCC-exception-2.0"),
    ),
    (
        "GCC-exception-3.1",
        include!("text/exceptions/GCC-exception-3.1"),
    ),
    (
        "GPL-3.0-linking-exception",
        include!("text/exceptions/GPL-3.0-linking-exception"),
    ),
    (
        "GPL-3.0-linking-source-exception",
        include!("text/exceptions/GPL-3.0-linking-source-exception"),
    ),
    ("GPL-CC-1.0", include!("text/exceptions/GPL-CC-1.0")),
    (
        "LGPL-3.0-linking-exception",
        include!("text/exceptions/LGPL-3.0-linking-exception"),
    ),
    ("LLVM-exception", include!("text/exceptions/LLVM-exception")),
    ("LZMA-exception", include!("text/exceptions/LZMA-exception")),
    (
        "Libtool-exception",
        include!("text/exceptions/Libtool-exception"),
    ),
    (
        "Linux-syscall-note",
        include!("text/exceptions/Linux-syscall-note"),
    ),
    (
        "Nokia-Qt-exception-1.1",
        include!("text/exceptions/Nokia-Qt-exception-1.1"),
    ),
    (
        "OCCT-exception-1.0",
        include!("text/exceptions/OCCT-exception-1.0"),
    ),
    (
        "OCaml-LGPL-linking-exception",
        include!("text/exceptions/OCaml-LGPL-linking-exception"),
    ),
    (
        "OpenJDK-assembly-exception-1.0",
        include!("text/exceptions/OpenJDK-assembly-exception-1.0"),
    ),
    (
        "PS-or-PDF-font-exception-20170817",
        include!("text/exceptions/PS-or-PDF-font-exception-20170817"),
    ),
    (
        "Qt-GPL-exception-1.0",
        include!("text/exceptions/Qt-GPL-exception-1.0"),
    ),
    (
        "Qt-LGPL-exception-1.1",
        include!("text/exceptions/Qt-LGPL-exception-1.1"),
    ),
    (
        "Qwt-exception-1.0",
        include!("text/exceptions/Qwt-exception-1.0"),
    ),
    ("SHL-2.0", include!("text/exceptions/SHL-2.0")),
    ("SHL-2.1", include!("text/exceptions/SHL-2.1")),
    (
        "Swift-exception",
        include!("text/exceptions/Swift-exception"),
    ),
    (
        "Universal-FOSS-exception-1.0",
        include!("text/exceptions/Universal-FOSS-exception-1.0"),
    ),
    (
        "WxWindows-exception-3.1",
        include!("text/exceptions/WxWindows-exception-3.1"),
    ),
    (
        "eCos-exception-2.0",
        include!("text/exceptions/eCos-exception-2.0"),
    ),
    (
        "freertos-exception-2.0",
        include!("text/exceptions/freertos-exception-2.0"),
    ),
    (
        "gnu-javamail-exception",
        include!("text/exceptions/gnu-javamail-exception"),
    ),
    (
        "i2p-gpl-java-exception",
        include!("text/exceptions/i2p-gpl-java-exception"),
    ),
    ("mif-exception", include!("text/exceptions/mif-exception")),
    (
        "openvpn-openssl-exception",
        include!("text/exceptions/openvpn-openssl-exception"),
    ),
    (
        "u-boot-exception-2.0",
        include!("text/exceptions/u-boot-exception-2.0"),
    ),
];
