mod common;

pub use common::*;
use spamassassin_milter::*;

#[tokio::test]
async fn spam_message() {
    let config = configure_spamc(Config::builder())
        .spamc_args(&[format!("--port={}", SPAMD_PORT)])
        .build();

    let server = spawn_mock_spamd_server(SPAMD_PORT, |spam| {
        let mut spam = spam
            .replacen("X-Spam-Checker-Version: BogusChecker 1.0.0\r\n", "", 1)
            .replacen("X-Spam-Report: Bogus report\r\n", "", 1)
            .replacen(
                "\r\n\r\n",
                "\r\n\
                 X-Spam-Checker-Version: MyChecker 1.0.0\r\n\
                 X-Spam-Flag: YES\r\n\
                 X-Spam-Custom: Custom-Value\r\n\
                 Content-Type: multipart/mixed; ...\r\n\
                 \r\n",
                1,
            )
            .replacen(
                "Subject: Test message\r\n",
                "Subject: [SPAM] Test message\r\n",
                1,
            );

        // Replace the message body with the SpamAssassin ‘report’.
        spam.replace_range(
            (spam.find("\r\n\r\n").unwrap() + 4)..,
            "Spam detection software has identified ...",
        );

        Err(spam)
    })
    .await
    .unwrap();

    let milter = SpamAssassinMilter::spawn(LOCALHOST, config).await.unwrap();

    let exit_code = run_miltertest(file!(), milter.addr()).await.unwrap();

    milter.shutdown().await.unwrap();
    server.await.unwrap().unwrap();

    assert!(exit_code.success());
}
