mod common;

pub use common::*;
use spamassassin_milter::*;

#[tokio::test]
async fn skip_oversized() {
    let config = configure_spamc(Config::builder())
        .max_message_size(512)
        .spamc_args(&[format!("--port={}", SPAMD_PORT)])
        .build();

    let server = spawn_mock_spamd_server(SPAMD_PORT, Ok).await.unwrap();

    let milter = SpamAssassinMilter::spawn(LOCALHOST, config).await.unwrap();

    let exit_code = run_miltertest(file!(), milter.addr()).await.unwrap();

    milter.shutdown().await.unwrap();
    server.await.unwrap().unwrap();

    assert!(exit_code.success());
}
