mod common;

pub use common::*;
use spamassassin_milter::*;

#[tokio::test]
async fn reject_spam() {
    let config = configure_spamc(Config::builder())
        .reject_spam(true)
        .reply_code("554".into())
        .reply_text("Not allowed!".into())
        .spamc_args(&[format!("--port={}", SPAMD_PORT)])
        .build();

    let server = spawn_mock_spamd_server(SPAMD_PORT, |spam| {
        Err(spam.replacen("\r\n\r\n", "\r\nX-Spam-Flag: YES\r\n\r\n", 1))
    })
    .await
    .unwrap();

    let milter = SpamAssassinMilter::spawn(LOCALHOST, config).await.unwrap();

    let exit_code = run_miltertest(file!(), milter.addr()).await.unwrap();

    milter.shutdown().await.unwrap();
    server.await.unwrap().unwrap();

    assert!(exit_code.success());
}
